/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.io;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.collections.ConcurrentLinkedStack;
import com.oracle.coherence.common.collections.Stack;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.util.Duration;
import com.oracle.coherence.common.util.MemorySize;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SegmentedBufferManager
implements BufferManager,
Disposable {
    private static final int GEN_ID_SHIFT = 6;
    protected static final int GEN_ID_BITS = 4;
    private static final int GEN_ID_MASK = 960;
    protected static final int GEN_ID_UNPOOLED = 15;
    private static final int GEN_ID_TRUNCATE = 10;
    public static final long UNPOOLED_RECLAIM_INTERVAL = 1024L;
    public static final int STATS_FREQUENCY = 255;
    public static final int DEFAULT_BUF_SIZE = 1024;
    public static final short DEFAULT_GROWTH_FACTOR = 1;
    public static final int DEFAULT_SEGMENT_COUNT = 7;
    protected static final long CLEANUP_FREQUENCY_MILLIS = new Duration(System.getProperty(SegmentedBufferManager.class.getName() + ".cleanup.frequency", "1s")).as(Duration.Magnitude.MILLI);
    protected static final Logger LOGGER = Logger.getLogger(SegmentedBufferManager.class.getName());
    private final BufferAllocator m_allocator;
    private final Segment[] f_aSegments;
    private final int m_cbMin;
    private final int m_cbMax;
    private final int m_nSegmentGrowthFactor;
    protected String m_sName = this.getClass().getSimpleName() + "(" + System.identityHashCode(this) + ")";

    public SegmentedBufferManager(BufferAllocator allocator, int cbBufferMin, long cbMax) {
        this(allocator, 7, cbMax / 7L, cbBufferMin, 1);
    }

    public SegmentedBufferManager(BufferAllocator allocator, long cbMax) {
        this(allocator, 7, cbMax / 7L, 1024, 1);
    }

    public SegmentedBufferManager(BufferAllocator allocator, int cSegments, long cbSegment, int cbBufferMin, int nGrowthFactor) {
        this.m_allocator = allocator;
        int cbDefaultBuf = 1024;
        cbSegment = Math.min(cbSegment, 0x77FFFFFF1L);
        if ((cbBufferMin & 0x3FF) != 0) {
            cbBufferMin = cbBufferMin / 1024 * 1024 + (cbBufferMin % 1024 == 0 ? 0 : 1024);
        }
        int cHighestBit = 31;
        int cLowestBit = Integer.numberOfTrailingZeros(cbBufferMin);
        int nMaxSegments = 31 - cLowestBit * nGrowthFactor;
        if (nMaxSegments < 1) {
            throw new IllegalArgumentException("Growthfactor is to aggressive: " + nGrowthFactor);
        }
        if (cSegments > nMaxSegments) {
            throw new IllegalArgumentException("The number of segments exceeded: " + nMaxSegments);
        }
        int cbBuff = this.m_cbMin = cbBufferMin;
        this.f_aSegments = new Segment[cSegments];
        Segment[] aSegment = this.f_aSegments;
        for (int i = 0; i < cSegments; ++i) {
            long cBuf = cbSegment / (long)cbBuff;
            aSegment[i] = this.allocateSegment(cbBuff, (int)(cBuf > Integer.MAX_VALUE ? Integer.MAX_VALUE : cBuf));
            cbBuff <<= nGrowthFactor;
        }
        this.m_cbMax = cbBuff >> nGrowthFactor;
        this.m_nSegmentGrowthFactor = nGrowthFactor;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }

    @Override
    public long getCapacity() {
        long cbCapacity = 0L;
        for (Segment seg : this.f_aSegments) {
            long cbBuf = seg.getBufferSize();
            long cbGen = cbBuf * (long)seg.getGenerationSize();
            cbCapacity += cbGen * 15L;
        }
        return cbCapacity;
    }

    @Override
    public ByteBuffer acquire(int cbMin) {
        ByteBuffer buff = this.ensureMinBuffer(cbMin, Integer.MAX_VALUE);
        if (buff.capacity() > cbMin) {
            buff.limit(cbMin);
        }
        return buff;
    }

    @Override
    public ByteBuffer acquirePref(int cbPref) {
        ByteBuffer buff = this.ensureBuffer(cbPref);
        if (buff.capacity() > cbPref) {
            buff.limit(cbPref);
        }
        return buff;
    }

    @Override
    public ByteBuffer acquireSum(int cbSum) {
        return this.ensureBuffer(cbSum);
    }

    @Override
    public void release(ByteBuffer buffer) {
        this.getSegment(buffer.capacity()).release(buffer);
    }

    @Override
    public ByteBuffer truncate(ByteBuffer buff) {
        int nGen = this.decodeGeneration(buff.capacity());
        return nGen < 10 ? buff : this.truncateComplex(buff);
    }

    protected ByteBuffer truncateComplex(ByteBuffer buff) {
        int cbSeg = this.decodeSize(buff.capacity());
        int cbSegPre = cbSeg >> this.m_nSegmentGrowthFactor;
        int cbUsed = buff.remaining();
        if (cbSeg > this.m_cbMin && cbUsed <= cbSegPre) {
            ByteBuffer buffNew;
            try {
                buffNew = this.ensureMinBuffer(cbUsed, cbSeg - 1);
            }
            catch (OutOfMemoryError e) {
                return buff;
            }
            buffNew.put(buff).flip();
            this.release(buff);
            return buffNew;
        }
        return buff;
    }

    @Override
    public void dispose() {
        for (Segment pool : this.f_aSegments) {
            pool.dispose();
        }
    }

    public String toString() {
        long cbCapacity = 0L;
        long cbUsed = 0L;
        long cAlloc = 0L;
        long cNonPooled = 0L;
        long cbAvailable = 0L;
        long cbPeakHist = 0L;
        StringBuilder sbSeg = new StringBuilder();
        for (Segment seg : this.f_aSegments) {
            long cbBuf = seg.getBufferSize();
            long cbGen = cbBuf * (long)seg.getGenerationSize();
            cbAvailable += (long)seg.f_stackBuf.size() * cbBuf;
            cbCapacity += cbGen * 15L;
            cbUsed += (long)seg.getAcquired() * cbBuf;
            cAlloc += seg.getAllocationCount();
            cNonPooled += seg.getNonPooledAllocationCount();
            cbPeakHist += (long)seg.m_cMaxBuffersHistoric * cbBuf;
            sbSeg.append(seg).append(", ");
        }
        return this.getName() + "(capacity=" + new MemorySize(cbCapacity) + ", usage=" + new MemorySize(cbUsed) + ".." + new MemorySize(cbPeakHist) + "/" + new MemorySize(cbAvailable) + ", hit rate=" + (cAlloc - cNonPooled) * 100L / (cAlloc == 0L ? 1L : cAlloc) + "%, segment utilization=" + sbSeg.toString() + "allocator=" + this.m_allocator + ")";
    }

    protected BufferAllocator getAllocator() {
        return this.m_allocator;
    }

    protected int decodeGeneration(int cbBuffer) {
        return (cbBuffer & 0x3C0) >> 6;
    }

    private int decodeSize(int cb) {
        return cb & 0xFFFFFC3F;
    }

    private ByteBuffer ensureBuffer(int cb) {
        Segment[] aSegments = this.f_aSegments;
        int cSegments = aSegments.length;
        int iSeg = 0;
        if (cb >= this.m_cbMax) {
            iSeg = cSegments - 1;
        } else {
            int cbMin = this.m_cbMin;
            while (cb > cbMin) {
                cb >>= this.m_nSegmentGrowthFactor;
                ++iSeg;
            }
        }
        ByteBuffer buff = null;
        for (int i = 0; i < cSegments && buff == null; ++i) {
            if (iSeg + i < cSegments) {
                buff = aSegments[iSeg + i].acquire(false);
            }
            if (buff != null || i <= 0 || iSeg - i < 0) continue;
            buff = aSegments[iSeg - i].acquire(false);
        }
        return buff == null ? aSegments[iSeg].acquire(true) : buff;
    }

    private ByteBuffer ensureMinBuffer(int cbMin, int cbMax) {
        int iSeg;
        Segment[] aSegments = this.f_aSegments;
        int cSegments = aSegments.length;
        if (cbMin > this.m_cbMax) {
            throw new OutOfMemoryError("requested buffer size exceeds pool maximum");
        }
        int cSeg = aSegments.length;
        for (iSeg = 0; iSeg < cSeg && aSegments[iSeg].f_cbBuffer < cbMin; ++iSeg) {
        }
        for (int i = iSeg; i < cSegments; ++i) {
            Segment segment = aSegments[i];
            if (segment.f_cbUnpooledBuffer > cbMax) break;
            ByteBuffer buf = segment.acquire(false);
            if (buf == null) continue;
            return buf;
        }
        return aSegments[iSeg].acquire(true);
    }

    private Segment getSegment(int cb) throws IllegalArgumentException {
        int iSeg;
        Segment[] aSegments = this.f_aSegments;
        int cbDecoded = cb = this.decodeSize(cb);
        int cSeg = aSegments.length;
        int cbMin = this.m_cbMin;
        for (iSeg = 0; cb > cbMin && iSeg < cSeg; cb >>= this.m_nSegmentGrowthFactor, ++iSeg) {
        }
        if (iSeg < cSeg && cbDecoded == aSegments[iSeg].getBufferSize()) {
            return aSegments[iSeg];
        }
        throw new IllegalArgumentException("No pool segment for size: " + cbDecoded + " in " + cSeg + " segment(s) between " + aSegments[0].getBufferSize() + " .. " + aSegments[cSeg - 1].getBufferSize());
    }

    protected Segment allocateSegment(int cbBuffer, int cBuffers) {
        return new Segment(cbBuffer, cBuffers);
    }

    public static interface BufferAllocator {
        public ByteBuffer allocate(int var1);

        public void release(ByteBuffer var1);
    }

    protected class Segment
    implements Disposable {
        private static final int GEN_ID_EMPTY = -1;
        private static final int GEN_ID_LOCKED = -2;
        protected final int f_cbBuffer;
        protected final int f_cBufferGen;
        protected final Stack<ByteBuffer> f_stackBuf;
        protected final AtomicInteger f_cGeneration;
        private volatile long m_ldtNextEvaluation;
        protected final AtomicLong f_cAcquired;
        protected final AtomicLong f_cNonPooledAllocations;
        protected final AtomicLong f_cReleased;
        protected final AtomicLong f_cNonPooledReleased;
        protected final int f_cbUnpooledBuffer;
        private int m_cMaxBuffers;
        private int m_cMaxBuffersHistoric;

        protected Segment(int cbBuffer, int cBuffers) {
            this.f_cbBuffer = cbBuffer;
            this.f_cBufferGen = Math.max(cBuffers / 15, 1);
            this.f_stackBuf = new ConcurrentLinkedStack<ByteBuffer>();
            this.f_cGeneration = new AtomicInteger(-1);
            this.f_cReleased = new AtomicLong(0L);
            this.f_cNonPooledReleased = new AtomicLong(0L);
            this.f_cAcquired = new AtomicLong(0L);
            this.f_cNonPooledAllocations = new AtomicLong(0L);
            this.f_cbUnpooledBuffer = this.encodeGeneration(15);
        }

        public ByteBuffer acquire() {
            return this.acquire(true);
        }

        public ByteBuffer acquire(boolean fEnsure) {
            ByteBuffer buffer = this.f_stackBuf.pop();
            if (buffer == null && (buffer = this.acquireComplex(fEnsure)) == null) {
                return null;
            }
            this.f_cAcquired.incrementAndGet();
            return buffer;
        }

        protected boolean isShrinkable() {
            return true;
        }

        public void release(ByteBuffer buffer) {
            int cCurrentGen;
            int nGeneration = SegmentedBufferManager.this.decodeGeneration(buffer.capacity());
            if ((this.f_cReleased.incrementAndGet() & 0xFFL) == 0L) {
                this.recordUsage();
                this.evaluateCapacity(true);
            }
            if (nGeneration == 15 && this.f_cNonPooledReleased.incrementAndGet() % 1024L != 0L && this.f_stackBuf.size() < this.f_cBufferGen * 10) {
                --nGeneration;
            }
            buffer.order(ByteOrder.BIG_ENDIAN).clear();
            if (BufferManagers.ZERO_ON_RELEASE) {
                Buffers.zero(buffer);
            }
            if (nGeneration <= (cCurrentGen = this.getGenerationId()) || cCurrentGen == -2 && nGeneration != 15 || !this.isShrinkable()) {
                this.f_stackBuf.push(buffer);
            } else {
                this.dropBuffer(buffer);
            }
        }

        protected void dropBuffer(ByteBuffer buffer) {
            SegmentedBufferManager.this.m_allocator.release(buffer);
        }

        @Override
        public void dispose() {
            this.trim(0);
        }

        public int getBufferSize() {
            return this.f_cbBuffer;
        }

        public int getGenerationSize() {
            return this.f_cBufferGen;
        }

        private int getGenerationId() {
            return this.f_cGeneration.get();
        }

        protected int getAcquired() {
            return Math.max(0, (int)(this.f_cAcquired.get() - this.f_cReleased.get()));
        }

        private long getAllocationCount() {
            return this.f_cAcquired.get();
        }

        private long getReleaseCount() {
            return this.f_cReleased.get();
        }

        private long getNonPooledAllocationCount() {
            return this.f_cNonPooledAllocations.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ByteBuffer acquireComplex(boolean fEnsure) {
            AtomicInteger atomicGen = this.f_cGeneration;
            block6: while (true) {
                int cGen = atomicGen.get();
                ByteBuffer buffer = this.f_stackBuf.pop();
                if (buffer != null) {
                    return buffer;
                }
                switch (cGen) {
                    case 14: {
                        return fEnsure ? this.allocateNonPooledBuffer() : null;
                    }
                    case -2: {
                        continue block6;
                    }
                }
                if (!atomicGen.compareAndSet(cGen, -2)) continue;
                int nGen = cGen + 1;
                boolean fSuccess = false;
                try {
                    this.recordUsage();
                    fSuccess = this.allocateGeneration(nGen);
                    atomicGen.set(fSuccess ? nGen : cGen);
                }
                catch (Throwable throwable) {
                    atomicGen.set(fSuccess ? nGen : cGen);
                    throw throwable;
                }
            }
        }

        protected ByteBuffer allocateNonPooledBuffer() {
            this.f_cNonPooledAllocations.incrementAndGet();
            return SegmentedBufferManager.this.m_allocator.allocate(this.f_cbUnpooledBuffer);
        }

        protected boolean allocateGeneration(int nGeneration) {
            int cbBuffer = this.encodeGeneration(nGeneration);
            LOGGER.log(Level.FINE, SegmentedBufferManager.this.getName() + " growing segment '" + this.getBufferSize() + "' to " + (nGeneration + 1) + " generations");
            this.m_ldtNextEvaluation = System.currentTimeMillis() + CLEANUP_FREQUENCY_MILLIS;
            try {
                return this.allocateGenerationBuffers(nGeneration, cbBuffer);
            }
            catch (OutOfMemoryError e) {
                return false;
            }
        }

        protected boolean allocateGenerationBuffers(int nGen, int cbBuffer) {
            int c = this.getGenerationSize();
            for (int i = 0; i < c; ++i) {
                try {
                    this.f_stackBuf.push(SegmentedBufferManager.this.m_allocator.allocate(cbBuffer));
                    continue;
                }
                catch (OutOfMemoryError e) {
                    return i > 0;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evaluateCapacity(boolean fEvalPeers) {
            long ldtNow = System.currentTimeMillis();
            int nGen = this.getGenerationId();
            if (nGen > -1 && ldtNow > this.m_ldtNextEvaluation && this.f_cGeneration.compareAndSet(nGen, -2)) {
                this.m_ldtNextEvaluation = ldtNow + CLEANUP_FREQUENCY_MILLIS;
                int nDesiredGen = nGen;
                try {
                    if (this.isShrinkable()) {
                        int nInUse = nGen - this.f_stackBuf.size() / this.f_cBufferGen;
                        int nRecent = -1 + this.m_cMaxBuffers / this.f_cBufferGen + (this.m_cMaxBuffers % this.f_cBufferGen == 0 ? 0 : 1);
                        nDesiredGen = Math.min(nGen, Math.max(nInUse, nRecent));
                        int cCapacity = Math.min(nGen + 1, 15);
                        if (nDesiredGen == -1 || nDesiredGen < cCapacity && nDesiredGen != nGen) {
                            this.m_cMaxBuffersHistoric = this.m_cMaxBuffers;
                            LOGGER.log(Level.FINE, SegmentedBufferManager.this.getName() + " shrinking segment '" + this.getBufferSize() + "' by " + (nGen - nDesiredGen) + " generation(s) to " + (nDesiredGen + 1) + ", based on recent high water mark of " + new MemorySize(this.m_cMaxBuffers * this.f_cbBuffer));
                            int cTrimmed = this.trim(nDesiredGen);
                            LOGGER.log(Level.FINEST, SegmentedBufferManager.this.getName() + " scavenged " + cTrimmed + " buffers; " + new MemorySize(this.f_cbBuffer * cTrimmed));
                        }
                    }
                    if (fEvalPeers) {
                        for (Segment pool : SegmentedBufferManager.this.f_aSegments) {
                            if (pool == this) continue;
                            pool.evaluateCapacity(false);
                        }
                    }
                }
                finally {
                    this.m_cMaxBuffers /= 2;
                    this.f_cGeneration.set(nDesiredGen);
                }
            }
        }

        private void recordUsage() {
            this.m_cMaxBuffers = Math.max(this.m_cMaxBuffers, this.getAcquired());
            this.m_cMaxBuffersHistoric = Math.max(this.m_cMaxBuffersHistoric, this.m_cMaxBuffers);
        }

        private int trim(int nGeneration) {
            int cbCutoff = this.encodeGeneration(nGeneration + 1);
            int cRemove = 0;
            ConcurrentLinkedStack<ByteBuffer> stackTmp = new ConcurrentLinkedStack<ByteBuffer>();
            ByteBuffer buf = this.f_stackBuf.pop();
            while (buf != null) {
                if (buf.capacity() >= cbCutoff) {
                    ++cRemove;
                    this.dropBuffer(buf);
                } else {
                    stackTmp.push(buf);
                }
                buf = this.f_stackBuf.pop();
            }
            for (ByteBuffer buf2 : stackTmp) {
                this.f_stackBuf.push(buf2);
            }
            return cRemove;
        }

        protected int encodeGeneration(int nGenId) {
            return this.getBufferSize() | nGenId << 6;
        }

        public String toString() {
            return new MemorySize(this.f_cbBuffer).toString() + "(" + this.getAcquired() * 100 / (this.f_cBufferGen * 15) + "%)";
        }
    }
}

