/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import com.oracle.coherence.common.base.Factory;
import com.oracle.coherence.common.net.SelectionService;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractStickySelectionService
implements SelectionService {
    protected final SelectionService[] f_aServices;
    protected final WeakHashMap<SelectableChannel, SelectionService> f_mapPerm = new WeakHashMap();
    protected final Map<SelectableChannel, SelectionService> f_mapService = new ConcurrentHashMap<SelectableChannel, SelectionService>();

    public AbstractStickySelectionService(int cServices, Factory<? extends SelectionService> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        SelectionService[] aSvc = new SelectionService[cServices];
        for (int i = 0; i < cServices; ++i) {
            aSvc[i] = factory.create();
        }
        this.f_aServices = aSvc;
    }

    @Override
    public void register(SelectableChannel chan, SelectionService.Handler handler) throws IOException {
        this.ensureService(chan).register(chan, handler);
        if (handler == null) {
            this.f_mapService.remove(chan);
        }
    }

    @Override
    public void invoke(SelectableChannel chan, Runnable runnable, long cMillis) throws IOException {
        this.ensureService(chan).invoke(chan, runnable, cMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void associate(SelectableChannel chanParent, SelectableChannel chanChild) throws IOException {
        AbstractStickySelectionService abstractStickySelectionService = this;
        synchronized (abstractStickySelectionService) {
            SelectionService svcOld;
            SelectionService selectionService = svcOld = chanParent == null ? this.f_mapPerm.remove(chanChild) : this.f_mapPerm.put(chanChild, this.ensureService(chanParent));
            if (svcOld != null) {
                svcOld.associate(null, chanChild);
            }
            this.f_mapService.clear();
        }
    }

    @Override
    public void shutdown() {
        for (SelectionService svc : this.f_aServices) {
            svc.shutdown();
        }
        this.f_mapService.clear();
        this.f_mapPerm.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectionService ensureService(SelectableChannel chan) {
        SelectionService svc = this.f_mapService.get(chan);
        if (svc == null) {
            AbstractStickySelectionService abstractStickySelectionService = this;
            synchronized (abstractStickySelectionService) {
                svc = this.f_mapService.get(chan);
                if (svc == null) {
                    svc = this.f_mapPerm.get(chan);
                    if (svc == null) {
                        svc = this.selectService(chan);
                        this.f_mapPerm.put(chan, svc);
                        this.f_mapService.clear();
                    } else {
                        this.f_mapService.put(chan, svc);
                    }
                }
            }
        }
        return svc;
    }

    protected abstract SelectionService selectService(SelectableChannel var1);
}

