/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SocketChannel;

public class SocketChannelOutputStream
extends OutputStream {
    protected final SocketChannel f_channel;

    public SocketChannelOutputStream(SocketChannel channel) {
        this.f_channel = channel;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] ab, int off, int len) throws IOException {
        Object object = this.f_channel.blockingLock();
        synchronized (object) {
            if (!this.f_channel.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            this.f_channel.write(ByteBuffer.wrap(ab, off, len));
        }
    }

    @Override
    public void close() throws IOException {
        this.f_channel.close();
    }
}

