/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.net.socketbus;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.collections.Arrays;
import com.oracle.coherence.common.internal.continuations.AbstractContinuationFrame;
import com.oracle.coherence.common.internal.continuations.Continuations;
import com.oracle.coherence.common.internal.continuations.WrapperContinuation;
import com.oracle.coherence.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.coherence.common.net.SafeSelectionHandler;
import com.oracle.coherence.common.net.SelectionService;
import com.oracle.coherence.common.net.Sockets;
import com.oracle.coherence.common.net.exabus.Bus;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.Event;
import com.oracle.coherence.common.net.exabus.util.SimpleEvent;
import com.oracle.coherence.common.net.exabus.util.UrlEndPoint;
import com.oracle.coherence.common.util.SafeClock;
import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.net.ssl.SSLException;

public abstract class AbstractSocketBus
implements Bus {
    public static final int CLOSE_SOCKET = 0;
    public static final int SOCKET_SHUTDOWN_INPUT = 1;
    public static final int SOCKET_SHUTDOWN_OUTPUT = 2;
    public static final int SOCKET_SHUTDOWN_INPUT_OUTPUT = 3;
    public static final int SOCKET_DROP_OUTPUT = 4;
    protected final SocketBusDriver f_driver;
    protected final int f_nDropRatio;
    protected final int f_nCorruptionRatio;
    protected final boolean f_fCrc;
    private final ServerSocketChannel f_channelServer;
    private volatile BusState m_nState = BusState.INITIAL;
    private final ReadWriteLock f_lockState = new ReentrantReadWriteLock();
    protected UrlEndPoint m_pointLocal;
    private Collector<Event> m_collectorEvent;
    private final ConcurrentMap<EndPoint, Connection> f_mapConnections = new ConcurrentHashMap<EndPoint, Connection>();
    private final Set<Connection> f_setFlush = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Connection[] EMPTY_CONNECTION_ARRAY = new Connection[0];
    protected static final AtomicLong f_atomicIdGenerator = new AtomicLong(SafeClock.INSTANCE.getSafeTimeMillis());
    private static final byte CONNECT_NEW = 0;
    private static final byte CONNECT_MIGRATE = 1;

    public AbstractSocketBus(SocketBusDriver driver, UrlEndPoint pointLocal) throws IOException {
        this.f_driver = driver;
        String sProtocol = this.getProtocolName();
        if (!sProtocol.equals(pointLocal.getProtocol())) {
            throw new IllegalArgumentException("unsupported protocol: " + pointLocal.getProtocol());
        }
        ServerSocketChannel chan = driver.getDependencies().getSocketProvider().openServerSocketChannel();
        Sockets.configureBlocking(chan, false);
        this.configureSocket(chan.socket());
        chan.socket().bind(pointLocal.getAddress());
        this.f_nDropRatio = driver.getDependencies().getDropRatio();
        this.f_nCorruptionRatio = driver.getDependencies().getCorruptionRatio();
        this.f_fCrc = driver.getDependencies().isCrcEnabled();
        this.f_channelServer = chan;
        this.m_pointLocal = driver.resolveBindPoint(pointLocal, chan.socket());
    }

    @Override
    public EndPoint getLocalEndPoint() {
        return this.m_pointLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        Lock lock = this.f_lockState.writeLock();
        lock.lock();
        boolean fInterrupted = this.isInterrupted();
        try {
            this.verifyState(BusState.INITIAL);
            this.m_nState = BusState.OPEN;
            this.onOpen();
            try {
                ServerSocketChannel channel = this.f_channelServer;
                this.getSelectionService().register(this.f_channelServer, new AcceptHandler(channel));
            }
            catch (IOException e) {
                this.getLogger().log(this.makeExceptionRecord(Level.SEVERE, e, "{0} ServerSocket failure; no new connection will be accepted", this.getLocalEndPoint()));
            }
        }
        finally {
            lock.unlock();
            if (fInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Lock lock = this.f_lockState.writeLock();
        lock.lock();
        boolean fInterrupted = this.isInterrupted();
        try {
            if (this.m_nState.ordinal() >= BusState.CLOSING.ordinal()) {
                return;
            }
            this.verifyState(BusState.OPEN);
            this.m_nState = BusState.CLOSING;
            ConcurrentMap<EndPoint, Connection> mapConn = this.f_mapConnections;
            final AtomicInteger cConnections = new AtomicInteger(mapConn.size() + 1);
            this.getSelectionService().invoke(this.f_channelServer, new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractSocketBus.this.f_channelServer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (cConnections.decrementAndGet() == 0) {
                        AbstractSocketBus.this.onClose();
                    }
                }
            }, 0L);
            Iterator iterator = mapConn.values().iterator();
            while (iterator.hasNext()) {
                Connection conn;
                Connection connection = conn = (Connection)iterator.next();
                synchronized (connection) {
                    conn.scheduleShutdown(null, true, new Continuation<Void>(){

                        @Override
                        public void proceed(Void v) {
                            if (cConnections.decrementAndGet() == 0) {
                                AbstractSocketBus.this.onClose();
                            }
                        }
                    });
                }
            }
            return;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            lock.unlock();
            if (fInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(EndPoint peer) {
        Lock lock = this.f_lockState.readLock();
        lock.lock();
        boolean fInterrupted = this.isInterrupted();
        try {
            Connection conn;
            this.verifyState(BusState.OPEN);
            if (this.getLocalEndPoint().equals(peer)) {
                throw new IllegalArgumentException("SocketBus does not support connections to self");
            }
            Connection connection = conn = this.makeConnection(this.verifyEndPoint(peer));
            synchronized (connection) {
                if (this.f_mapConnections.putIfAbsent(peer, conn) == null) {
                    conn.connect();
                } else {
                    conn.dispose();
                }
            }
        }
        finally {
            lock.unlock();
            if (fInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(EndPoint peer) {
        Connection conn;
        Connection connection = conn = this.ensureConnection(peer);
        synchronized (connection) {
            conn.ensureValid().scheduleDisconnect(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(EndPoint peer) {
        Connection conn;
        Connection connection = conn = this.ensureConnection(peer);
        synchronized (connection) {
            conn.ensureValid().scheduleShutdown(null, true, null);
        }
    }

    @Override
    public String toString(EndPoint peer) {
        try {
            return this.ensureConnection(peer).toString();
        }
        catch (Throwable e) {
            return "unknown peer " + peer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        BusState nState = this.m_nState;
        if (nState != BusState.OPEN && nState != BusState.CLOSING) {
            throw new IllegalStateException("invalid bus state: " + (Object)((Object)nState));
        }
        boolean fInterrupted = this.isInterrupted();
        try {
            Object[] aConn = this.f_setFlush.toArray(EMPTY_CONNECTION_ARRAY);
            Arrays.shuffle(aConn);
            for (Object conn : aConn) {
                ((Connection)conn).optimisticFlush();
            }
        }
        finally {
            if (fInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void setEventCollector(Collector<Event> collector) {
        Lock lock = this.f_lockState.readLock();
        lock.lock();
        try {
            this.verifyState(BusState.INITIAL);
            this.m_collectorEvent = collector;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Collector<Event> getEventCollector() {
        return this.m_collectorEvent;
    }

    protected void scheduleTask(Runnable proc, long cMillis) {
        this.scheduleTask(this.f_channelServer, proc, cMillis);
    }

    protected void scheduleUnsafeTask(Runnable proc, long cMillis) {
        this.scheduleUnsafeTask(this.f_channelServer, proc, cMillis);
    }

    protected void scheduleTask(SelectableChannel chan, final Runnable proc, long cMillis) {
        BusState nState = this.m_nState;
        if (nState != BusState.OPEN && nState != BusState.CLOSING) {
            throw new IllegalStateException("invalid bus state: " + (Object)((Object)nState));
        }
        this.scheduleUnsafeTask(chan, new Runnable(){

            @Override
            public void run() {
                if (AbstractSocketBus.this.m_nState != BusState.CLOSED) {
                    proc.run();
                }
            }
        }, cMillis);
    }

    protected void scheduleUnsafeTask(SelectableChannel chan, Runnable proc, long cMillis) {
        try {
            this.getSocketDriver().getDependencies().getSelectionService().invoke(chan, proc, cMillis);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void halt() {
        try {
            this.f_channelServer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Connection conn : this.getConnections()) {
            try {
                conn.m_channel.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean checkDrop(SocketChannel channel) {
        if (this.f_nDropRatio != 0 && ThreadLocalRandom.current().nextInt(Math.abs(this.f_nDropRatio)) == 0) {
            AbstractSocketBus.closeChannel(channel);
            return true;
        }
        return false;
    }

    private void checkForceCorruption(ByteBuffer buffer, int cb) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (this.f_nCorruptionRatio != 0 && ((Random)random).nextInt(Math.abs(this.f_nCorruptionRatio)) == 0) {
            int nCorrupt = buffer.position() - (((Random)random).nextInt(cb) + 1);
            buffer.put(nCorrupt, (byte)((Random)random).nextInt());
        }
    }

    private ByteBuffer getFirstAvailableForCorruption(ByteBuffer[] aBuffer, int of) {
        int c = aBuffer.length;
        while (of < c && !aBuffer[of].hasRemaining()) {
            ++of;
        }
        return of < c ? aBuffer[of] : null;
    }

    public void sever(String sPeerName, int nClose) {
        Connection[] aConn = sPeerName == null ? (Connection[])this.f_mapConnections.values().stream().toArray(Connection[]::new) : new Connection[]{this.ensureConnection(this.f_driver.getDepot().resolveEndPoint(sPeerName))};
        for (Connection conn : aConn) {
            try {
                switch (nClose) {
                    case 1: {
                        conn.m_channel.shutdownInput();
                        break;
                    }
                    case 2: {
                        conn.m_channel.shutdownOutput();
                        break;
                    }
                    case 3: {
                        conn.m_channel.shutdownInput();
                        conn.m_channel.shutdownOutput();
                        break;
                    }
                    case 4: {
                        conn.m_fDropOutput = true;
                        break;
                    }
                    default: {
                        conn.m_channel.close();
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void closeChannel(SelectableChannel chan) {
        try {
            chan.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void onOpen() {
        final long cMillisHeartbeat = this.f_driver.getDependencies().getHeartbeatMillis();
        if (cMillisHeartbeat > 0L) {
            this.scheduleTask(new Runnable(){

                @Override
                public void run() {
                    AbstractSocketBus.this.scheduleTask(this, cMillisHeartbeat);
                    AbstractSocketBus.this.getConnections().forEach(Connection::heartbeat);
                }
            }, cMillisHeartbeat);
        }
        long cMillisAckTimeout = this.f_driver.getDependencies().getAckTimeoutMillis();
        long cMillisAckFatalTimeout = this.f_driver.getDependencies().getAckFatalTimeoutMillis();
        if (cMillisAckTimeout > 0L || cMillisAckFatalTimeout > 0L) {
            final long cIntervalMillis = Math.max(100L, (cMillisAckTimeout == 0L ? cMillisAckFatalTimeout : (cMillisAckFatalTimeout == 0L ? cMillisAckTimeout : Math.min(cMillisAckTimeout, cMillisAckFatalTimeout))) / 20L);
            this.scheduleTask(new Runnable(){

                @Override
                public void run() {
                    AbstractSocketBus.this.scheduleTask(this, cIntervalMillis);
                    long ldtNow = SafeClock.INSTANCE.getSafeTimeMillis();
                    AbstractSocketBus.this.getRegisteredConnections().forEach(conn -> conn.checkHealth(ldtNow));
                }
            }, cIntervalMillis);
        }
        EndPoint epThis = this.getLocalEndPoint();
        this.getLogger().log(this.makeRecord(Level.FINER, "{0} opened using {1}", epThis, this.f_channelServer.socket()));
        this.emitEvent(new SimpleEvent(Event.Type.OPEN, epThis));
    }

    protected void onClose() {
        EndPoint epThis = this.getLocalEndPoint();
        this.getLogger().log(this.makeRecord(Level.FINER, "{0} closed using {1}", epThis, this.f_channelServer.socket()));
        this.m_nState = BusState.CLOSED;
        this.emitEvent(new SimpleEvent(Event.Type.CLOSE, epThis));
    }

    protected Collection<Connection> getRegisteredConnections() {
        return this.f_mapConnections.values();
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder().append(this.getLocalEndPoint()).append(", state=").append((Object)this.m_nState);
        ConcurrentMap<EndPoint, Connection> mapCon = this.f_mapConnections;
        int cConnections = 0;
        int cActive = 0;
        for (Connection conn : mapCon.values()) {
            ++cConnections;
            if (conn.m_state != ConnectionState.ACTIVE) continue;
            ++cActive;
        }
        sb.append(", connections ");
        int cCon = mapCon.size();
        sb.append("[");
        for (Connection conn : mapCon.values()) {
            sb.append("\n\t").append(conn);
        }
        sb.append("]\n");
        sb.append("active=").append(cActive).append('/').append(cConnections);
        return sb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getDescription() + ')';
    }

    protected boolean isInterrupted() {
        return Blocking.interrupted();
    }

    protected Logger getLogger() {
        return this.getSocketDriver().getDependencies().getLogger();
    }

    protected LogRecord makeRecord(Level level, String sMsg, Object ... oaParams) {
        LogRecord rec = new LogRecord(level, sMsg);
        rec.setParameters(oaParams);
        return rec;
    }

    protected LogRecord makeExceptionRecord(Level level, Throwable t, String sMsg, Object ... oaParams) {
        LogRecord rec = this.makeRecord(level, sMsg, oaParams);
        rec.setThrown(t);
        return rec;
    }

    protected void addFlushable(Connection conn) {
        this.f_setFlush.add(conn);
    }

    protected void removeFlushable(Connection conn) {
        this.f_setFlush.remove(conn);
    }

    protected boolean isFlushable(Connection conn) {
        return this.f_setFlush.contains(conn);
    }

    protected void emitEvent(Event event) {
        Collector<Event> coll = this.m_collectorEvent;
        if (coll != null) {
            try {
                coll.add(event);
                coll.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void addEvent(Event event) {
        Collector<Event> coll = this.m_collectorEvent;
        if (coll != null) {
            try {
                coll.add(event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void flushEvents() {
        Collector<Event> coll = this.m_collectorEvent;
        if (coll != null) {
            try {
                coll.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected Collection<Connection> getConnections() {
        return this.f_mapConnections.values();
    }

    protected void configureSocket(Socket socket) throws IOException {
        Sockets.configure(socket, this.getSocketDriver().getDependencies().getSocketOptions());
    }

    protected void configureSocket(ServerSocket socket) throws IOException {
        Sockets.configure(socket, this.getSocketDriver().getDependencies().getSocketOptions());
    }

    protected void verifyState(BusState nState) {
        BusState nStateCurr = this.m_nState;
        if (nStateCurr != nState) {
            throw new IllegalStateException("invalid bus state: required " + (Object)((Object)nState) + ", actual " + (Object)((Object)nStateCurr));
        }
    }

    protected UrlEndPoint verifyEndPoint(EndPoint peer) {
        if (this.f_driver.isSupported(peer) && ((UrlEndPoint)peer).getProtocol().equals(this.getProtocolName())) {
            return (UrlEndPoint)peer;
        }
        throw new IllegalArgumentException("unsupported EndPoint " + peer);
    }

    protected SelectionService getSelectionService() {
        return this.getSocketDriver().getDependencies().getSelectionService();
    }

    protected SocketBusDriver getSocketDriver() {
        return this.f_driver;
    }

    protected Connection ensureConnection(EndPoint peer) {
        Connection conn = (Connection)this.f_mapConnections.get(peer);
        if (conn == null) {
            this.verifyState(BusState.OPEN);
            throw new IllegalArgumentException("unknown peer " + peer);
        }
        return conn;
    }

    protected int getProtocolIdentifier() {
        return this.getClass().getName().hashCode() ^ this.getSocketDriver().getClass().getName().hashCode();
    }

    protected String getProtocolName() {
        return this.getClass().getSimpleName();
    }

    protected short getMinimumProtocolVersion() {
        return 0;
    }

    protected short getMaximumProtocolVersion() {
        return 5;
    }

    protected abstract Connection makeConnection(UrlEndPoint var1);

    protected static enum BusState {
        INITIAL,
        OPEN,
        CLOSING,
        CLOSED;

    }

    protected class AcceptHandler
    extends SafeSelectionHandler<ServerSocketChannel> {
        protected AcceptHandler(ServerSocketChannel channel) {
            super(channel);
        }

        @Override
        public int onReadySafe(int nOps) {
            SocketChannel chan = null;
            try {
                chan = ((ServerSocketChannel)this.getChannel()).accept();
                if (chan != null) {
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} starting phase NEGOTIATE on {1}", AbstractSocketBus.this.getLocalEndPoint(), chan.socket()));
                    Sockets.configureBlocking(chan, false);
                    AbstractSocketBus.this.configureSocket(chan.socket());
                    AbstractSocketBus.this.getSelectionService().register(chan, new HandshakeHandler(chan, null));
                }
            }
            catch (IOException e) {
                if (chan == null) {
                    throw new RuntimeException(e);
                }
                try {
                    chan.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return 16;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int onException(Throwable t) {
            ServerSocketChannel channel = (ServerSocketChannel)this.getChannel();
            if (channel.isOpen()) {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(Level.INFO, t, "{0} unexpected exception during Bus accept, ignoring", AbstractSocketBus.this.getLocalEndPoint()));
                return 16;
            }
            AbstractSocketBus abstractSocketBus = AbstractSocketBus.this;
            synchronized (abstractSocketBus) {
                if (AbstractSocketBus.this.m_nState == BusState.OPEN) {
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(Level.SEVERE, t, "{0} ServerSocket failure; no new connection will be accepted", AbstractSocketBus.this.getLocalEndPoint()));
                }
                return 0;
            }
        }
    }

    protected class HandshakeHandler
    extends SafeSelectionHandler<SocketChannel> {
        protected Connection m_connection;
        protected HandshakePhase m_phase;
        protected ByteBuffer m_headerOut;
        protected ByteBuffer m_headerIn;
        protected int m_nProtocol;

        public HandshakeHandler(SocketChannel channel, Connection connection) {
            super(channel);
            this.m_phase = HandshakePhase.NEGOTIATE;
            this.m_connection = connection;
            int cbNegotiate = 10;
            this.m_headerIn = ByteBuffer.allocate(cbNegotiate);
            ByteBuffer headerOut = this.m_headerOut = ByteBuffer.allocate(cbNegotiate);
            headerOut.putInt(AbstractSocketBus.this.getProtocolIdentifier()).putShort(AbstractSocketBus.this.getMinimumProtocolVersion()).putShort(AbstractSocketBus.this.getMaximumProtocolVersion()).putShort((short)AbstractSocketBus.this.getLocalEndPoint().getCanonicalName().length());
            headerOut.flip();
        }

        @Override
        public int onReadySafe(int nOps) throws IOException {
            SocketChannel channel = (SocketChannel)this.getChannel();
            Connection connection = this.m_connection;
            ByteBuffer headerOut = this.m_headerOut;
            ByteBuffer headerIn = this.m_headerIn;
            HandshakePhase phase = this.m_phase;
            int nInterest = 0;
            if (channel.isConnectionPending()) {
                if (!channel.finishConnect()) {
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} finishConnect pending for {1} on {2}", AbstractSocketBus.this.getLocalEndPoint(), connection.getPeer(), channel.socket()));
                    return 8;
                }
                connection.m_cReconnectAttempts = 0;
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} socket connected for {1} on {2}", AbstractSocketBus.this.getLocalEndPoint(), connection.getPeer(), channel.socket()));
            }
            if (AbstractSocketBus.this.f_nDropRatio > 0 && AbstractSocketBus.this.checkDrop(channel)) {
                throw new IOException("test drop; " + (Object)((Object)phase));
            }
            channel.write(headerOut);
            if ((nOps & 1) != 0 && channel.read(headerIn) < 0) {
                throw new IOException("InputShutdown during handshake " + (Object)((Object)phase) + " in " + headerIn + " out " + headerOut);
            }
            if (headerIn.hasRemaining()) {
                nInterest = 1;
            }
            if (headerOut.hasRemaining()) {
                nInterest |= 4;
            }
            if (nInterest == 0) {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} processing {1} handshake for {2} on {3}", new Object[]{AbstractSocketBus.this.getLocalEndPoint(), phase, connection == null ? null : connection.getPeer(), channel.socket()}));
                switch (phase) {
                    case NEGOTIATE: {
                        nInterest = this.onNegotiate();
                        break;
                    }
                    case INTRODUCE: {
                        nInterest = this.onIntroduce();
                        break;
                    }
                    case ACCEPT: {
                        nInterest = this.onAccept();
                        break;
                    }
                    default: {
                        nInterest = this.onAbandon();
                    }
                }
                if (this.m_phase != phase) {
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} waiting for {1} handshake for {2} on {3} with interest {4}, {5}B to read, {6}B to write", new Object[]{AbstractSocketBus.this.getLocalEndPoint(), this.m_phase, this.m_connection == null ? null : this.m_connection.getPeer(), ((SocketChannel)this.getChannel()).socket(), nInterest, this.m_headerIn.remaining(), this.m_headerOut.remaining()}));
                }
            }
            return nInterest;
        }

        @Override
        public int onException(Throwable eReason) {
            Connection connection = this.m_connection;
            if (connection == null) {
                this.close(eReason);
            } else {
                ConnectionState state = connection.m_state;
                if (connection.m_channel == this.getChannel() && state != null && state.ordinal() < ConnectionState.DEFUNCT.ordinal()) {
                    connection.onException(eReason);
                }
            }
            return 0;
        }

        public int onNegotiate() {
            Connection connection = this.m_connection;
            ByteBuffer headerIn = this.m_headerIn;
            headerIn.flip();
            int nId = headerIn.getInt();
            int nIdReq = AbstractSocketBus.this.getProtocolIdentifier();
            if (nId != nIdReq) {
                if (nId >>> 8 == (nIdReq & 0xFFFFFF)) {
                    nId = nIdReq;
                    headerIn.position(3);
                } else {
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.WARNING, "{0} rejecting connection from {1} using incompatible protocol id {2}, required {3}", AbstractSocketBus.this.getLocalEndPoint(), ((SocketChannel)this.getChannel()).socket().getInetAddress(), nId, nIdReq));
                    this.close(new IOException("incompatible protocol"));
                    return 0;
                }
            }
            short nMin = headerIn.getShort();
            short nMax = headerIn.getShort();
            if (nMin > AbstractSocketBus.this.getMaximumProtocolVersion() || nMax < AbstractSocketBus.this.getMinimumProtocolVersion()) {
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.WARNING, "{0} rejecting connection from {1} using unsupported protocol {2} version ({3} ... {4}), supported ({5} ... {6})", AbstractSocketBus.this.getLocalEndPoint(), ((SocketChannel)this.getChannel()).socket().getInetAddress(), nId, nMin, nMax, AbstractSocketBus.this.getMinimumProtocolVersion(), AbstractSocketBus.this.getMaximumProtocolVersion()));
                this.close(new IOException("protocol version mismatch"));
                return 0;
            }
            int nProt = this.m_nProtocol = Math.min(AbstractSocketBus.this.getMaximumProtocolVersion(), nMax);
            AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINEST, "{0} handshaking with {1} using protocol {2} version {3}", AbstractSocketBus.this.getLocalEndPoint(), ((SocketChannel)this.getChannel()).socket().getInetAddress(), nId, nProt));
            this.m_phase = HandshakePhase.INTRODUCE;
            String sName = AbstractSocketBus.this.getLocalEndPoint().getCanonicalName();
            boolean fSendConnect = nProt > 0 && connection != null;
            boolean fSendIdentity = nProt > 1 && fSendConnect;
            ByteBuffer bufOut = this.m_headerOut = ByteBuffer.allocate(sName.length() * 2 + (fSendConnect ? 1 : 0) + (fSendIdentity ? (nProt > 3 ? 16 : 8) : 0));
            int c = sName.length();
            for (int i = 0; i < c; ++i) {
                bufOut.putChar(sName.charAt(i));
            }
            if (fSendConnect) {
                byte nConnect = connection.m_state == ConnectionState.OPEN && connection.m_lIdentityPeer == 0L ? (byte)0 : 1;
                bufOut.put(nConnect);
                if (fSendIdentity) {
                    if (nProt > 3) {
                        bufOut.putLong(connection.f_lIdentity).putLong(connection.m_lIdentityPeer);
                    } else {
                        bufOut.putLong(nConnect == 0 ? connection.f_lIdentity : connection.m_lIdentityPeer);
                    }
                }
            }
            bufOut.flip();
            this.m_headerIn = ByteBuffer.allocate(headerIn.getShort() * 2 + (nProt > 0 ? 1 : 0) + (nProt > 3 ? 16 : (nProt > 1 ? 8 : 0)));
            return 5;
        }

        /*
         * Exception decompiling
         */
        public int onIntroduce() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int onAccept() throws IOException {
            Connection connection;
            Connection connection2 = connection = this.m_connection;
            synchronized (connection2) {
                switch (connection.m_state) {
                    case OPEN: {
                        connection.m_state = ConnectionState.ACTIVE;
                    }
                    case ACTIVE: {
                        AbstractSocketBus.this.getSelectionService().register((SelectableChannel)this.getChannel(), connection);
                        connection.m_handler = connection;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("state = " + (Object)((Object)connection.m_state));
                    }
                }
            }
            return 0;
        }

        public int onAbandon() {
            this.close(new IOException("protocol error"));
            return 1;
        }

        public void close(Throwable eReason) {
            SocketChannel channel = (SocketChannel)this.getChannel();
            Connection connection = this.m_connection;
            HandshakePhase phase = this.m_phase;
            if (connection == null) {
                if (phase != HandshakePhase.ABANDON) {
                    AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(eReason instanceof SSLException ? Level.WARNING : Level.FINEST, eReason, "{0} close due to exception during handshake phase {1} on {2}", new Object[]{AbstractSocketBus.this.getLocalEndPoint(), phase, channel.socket()}));
                }
            } else {
                connection.scheduleDisconnect(eReason);
            }
            AbstractSocketBus.closeChannel(channel);
        }
    }

    protected abstract class Connection
    implements SelectionService.Handler,
    GatheringByteChannel,
    ScatteringByteChannel,
    Disposable {
        private final UrlEndPoint f_peer;
        private final AtomicBoolean f_lockFlush = new AtomicBoolean();
        protected volatile ConnectionState m_state;
        protected final long f_lIdentity = f_atomicIdGenerator.incrementAndGet();
        protected long m_lIdentityPeer;
        private SocketChannel m_channel;
        private boolean m_fDropOutput;
        private int m_cbPacket = -1;
        private HandshakeHandler m_next;
        private Queue<Runnable> m_queueDeferred;
        protected long m_cbRead;
        protected long m_cbWrite;
        protected int m_nProtocol = -1;
        protected int m_cMigrations;
        protected Throwable m_eMigrationCause;
        protected int m_cReconnectAttempts;
        protected CRC32 f_crcRx;
        protected CRC32 f_crcTx;
        protected volatile SelectionService.Handler m_handler;

        public Connection(UrlEndPoint peer) {
            this.f_peer = peer;
            if (AbstractSocketBus.this.f_fCrc) {
                this.f_crcRx = new CRC32();
                this.f_crcTx = new CRC32();
                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINER, "Packet corruption detection enabled for connection {0} to {1}", AbstractSocketBus.this.getLocalEndPoint(), peer));
            }
        }

        protected void open() throws IOException {
            if (this.m_state != null) {
                throw new IllegalStateException("state = " + (Object)((Object)this.m_state));
            }
            this.m_state = ConnectionState.OPEN;
            UrlEndPoint peer = this.f_peer;
            AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINER, "{0} opening connection with {1} using {2}", AbstractSocketBus.this.getLocalEndPoint(), peer, this.m_channel.socket()));
            AbstractSocketBus.this.emitEvent(new SimpleEvent(Event.Type.CONNECT, peer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isValid() {
            ConnectionState state = this.m_state;
            if (state == null) {
                Connection connection = this;
                synchronized (connection) {
                    state = this.m_state;
                    if (state == null) {
                        return false;
                    }
                }
            }
            return state != ConnectionState.FINAL;
        }

        public Connection ensureValid() {
            if (this.isValid()) {
                return this;
            }
            throw new IllegalArgumentException("connection to " + this.f_peer + " is not open, in state " + (Object)((Object)this.m_state));
        }

        private void connect() {
            SocketChannel channel;
            ConnectionState state = this.m_state;
            if (state != null && state.ordinal() >= ConnectionState.DEFUNCT.ordinal()) {
                throw new IllegalStateException("state = " + (Object)((Object)this.m_state));
            }
            if (this.m_channel != null && this.m_channel.isOpen()) {
                throw new IllegalStateException();
            }
            try {
                this.m_channel = channel = AbstractSocketBus.this.getSocketDriver().getDependencies().getSocketProvider().openSocketChannel();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                Sockets.configureBlocking(channel, false);
                AbstractSocketBus.this.configureSocket(channel.socket());
                channel.connect(this.f_peer.getAddress());
            }
            catch (IOException e) {
                this.onException(e);
            }
            try {
                if (state == null) {
                    this.open();
                }
                HandshakeHandler handler = new HandshakeHandler(channel, this);
                AbstractSocketBus.this.getSelectionService().register(channel, handler);
                this.m_handler = handler;
            }
            catch (IOException e) {
                this.scheduleDisconnect(e);
            }
        }

        public void scheduleDisconnect(Throwable eReason) {
            this.scheduleShutdown(eReason, false, null);
        }

        public void scheduleShutdown(final Throwable eReason, final boolean fRelease, Continuation<Void> continuation) {
            this.invoke(new AbstractContinuationFrame<Void>(continuation){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    HandshakeHandler handlerNext;
                    boolean fEmitDisconnect = false;
                    Connection connection = Connection.this;
                    synchronized (connection) {
                        handlerNext = Connection.this.m_next;
                        switch (Connection.this.m_state) {
                            case OPEN: 
                            case ACTIVE: {
                                fEmitDisconnect = true;
                                Connection.this.m_state = ConnectionState.DEFUNCT;
                            }
                            case DEFUNCT: {
                                if (!fRelease) break;
                                Connection.this.m_next = null;
                                Connection.this.m_state = ConnectionState.FINAL;
                                break;
                            }
                            case FINAL: {
                                return null;
                            }
                            default: {
                                throw new IllegalStateException("state = " + (Object)((Object)Connection.this.m_state));
                            }
                        }
                    }
                    final WrapperContinuation<Void> continuation = new WrapperContinuation<Void>(this.getContinuation()){

                        @Override
                        public void proceed(Void v) {
                            AbstractSocketBus.this.flushEvents();
                            super.proceed(v);
                        }
                    };
                    if (fRelease) {
                        if (fEmitDisconnect) {
                            final HandshakeHandler handlerRelease = handlerNext;
                            Connection.this.doDisconnect(fEmitDisconnect, eReason, (Continuation<? super Void>)new Continuation<Void>(){

                                @Override
                                public void proceed(Void v) {
                                    Connection.this.doRelease(handlerRelease, continuation);
                                }
                            });
                        } else {
                            Connection.this.doRelease(handlerNext, (Continuation<? super Void>)continuation);
                        }
                    } else {
                        Connection.this.doDisconnect(fEmitDisconnect, eReason, (Continuation<? super Void>)continuation);
                    }
                    return (Void)this.continueAsync();
                }
            });
        }

        protected abstract void drainReceipts();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doDisconnect(boolean fFirst, Throwable eReason, Continuation<? super Void> continuation) {
            try {
                if (fFirst) {
                    this.onDisconnected(eReason);
                }
                try {
                    this.m_channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.drainReceipts();
            }
            finally {
                Continuations.proceed(continuation, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRelease(HandshakeHandler handlerNext, Continuation<? super Void> continuation) {
            try {
                block16: {
                    EndPoint peer = this.getPeer();
                    this.onReleased();
                    this.drainReceipts();
                    Lock lockWrite = AbstractSocketBus.this.f_lockState.writeLock();
                    lockWrite.lock();
                    try {
                        if (handlerNext != null && !((SocketChannel)handlerNext.getChannel()).socket().isInputShutdown() && AbstractSocketBus.this.m_nState == BusState.OPEN) {
                            Connection connection = handlerNext.m_connection;
                            synchronized (connection) {
                                AbstractSocketBus.this.f_mapConnections.replace(peer, handlerNext.m_connection);
                                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINER, "{0} releasing connection with {1}", AbstractSocketBus.this.getLocalEndPoint(), peer));
                                AbstractSocketBus.this.addEvent(new SimpleEvent(Event.Type.RELEASE, peer));
                                try {
                                    handlerNext.m_connection.open();
                                    AbstractSocketBus.this.getSelectionService().register((SelectableChannel)handlerNext.getChannel(), handlerNext);
                                    handlerNext.m_connection.m_handler = handlerNext;
                                }
                                catch (IOException e) {
                                    handlerNext.m_connection.scheduleDisconnect(e);
                                }
                            }
                            handlerNext = null;
                            break block16;
                        }
                        if (handlerNext != null) {
                            handlerNext.close(null);
                        }
                        AbstractSocketBus.this.f_mapConnections.remove(peer);
                        AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeRecord(Level.FINER, "{0} releasing connection with {1}", AbstractSocketBus.this.getLocalEndPoint(), peer));
                        AbstractSocketBus.this.addEvent(new SimpleEvent(Event.Type.RELEASE, peer));
                    }
                    finally {
                        lockWrite.unlock();
                    }
                }
                if (handlerNext != null) {
                    try {
                        ((SocketChannel)handlerNext.getChannel()).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                Continuations.proceed(continuation, null);
            }
        }

        public void onDisconnected(Throwable eReason) {
            AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(eReason instanceof SSLException ? Level.WARNING : Level.FINER, eReason, "{0} disconnected connection with {1}", AbstractSocketBus.this.getLocalEndPoint(), this));
            AbstractSocketBus.this.addEvent(new SimpleEvent(Event.Type.DISCONNECT, this.getPeer(), eReason));
        }

        public void onReleased() {
            AbstractSocketBus.this.removeFlushable(this);
            this.dispose();
        }

        public void onMigration() {
            ++this.m_cMigrations;
        }

        @Override
        public void dispose() {
        }

        protected abstract void flush();

        protected abstract boolean heartbeat();

        protected void checkHealth(long ldtNow) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void optimisticFlush() {
            AtomicBoolean lockFlush = this.f_lockFlush;
            if (lockFlush.compareAndSet(false, true)) {
                Connection connection = this;
                synchronized (connection) {
                    try {
                        this.ensureValid().flush();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    finally {
                        lockFlush.set(false);
                    }
                }
            }
        }

        public final boolean isFlushInProgress() {
            return this.f_lockFlush.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean wakeup() throws IOException {
            if (this.m_state == null) {
                return false;
            }
            switch (this.m_state) {
                case OPEN: {
                    return false;
                }
                case ACTIVE: {
                    Connection connection = this;
                    synchronized (connection) {
                        AbstractSocketBus.this.getSelectionService().register(this.m_channel, this.m_handler);
                    }
                    return true;
                }
            }
            throw new ClosedChannelException();
        }

        protected int getSendBufferSize() throws SocketException {
            SocketChannel chan = this.m_channel;
            if (chan == null) {
                return -1;
            }
            return chan.socket().getSendBufferSize();
        }

        protected int getPacketSize() {
            Socket socket;
            SocketChannel chan;
            int cbPacket = this.m_cbPacket;
            if (cbPacket <= 0 && (chan = this.m_channel) != null && (socket = chan.socket()).isBound()) {
                this.m_cbPacket = cbPacket = Sockets.getMTU(socket);
            }
            return cbPacket;
        }

        protected int getReceiveBufferSize() throws SocketException {
            SocketChannel chan = this.m_channel;
            if (chan == null) {
                return -1;
            }
            return chan.socket().getReceiveBufferSize();
        }

        public EndPoint getPeer() {
            return this.f_peer;
        }

        public int getProtocolVersion() {
            return this.m_nProtocol;
        }

        protected synchronized void invoke(Runnable runnable) {
            Queue<Runnable> queueDeferred = this.m_queueDeferred;
            if (queueDeferred == null) {
                try {
                    AbstractSocketBus.this.getSelectionService().invoke(this.m_channel, runnable, 0L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                queueDeferred.add(runnable);
            }
        }

        public void registerHandler(SelectionService.Handler handler) throws IOException {
            AbstractSocketBus.this.getSelectionService().register(this.m_channel, handler);
        }

        @Override
        public void close() {
            this.scheduleDisconnect(null);
        }

        @Override
        public boolean isOpen() {
            return this.m_state.ordinal() < ConnectionState.FINAL.ordinal();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            switch (6.$SwitchMap$com$oracle$coherence$common$internal$net$socketbus$AbstractSocketBus$ConnectionState[this.m_state.ordinal()]) {
                case 1: {
                    return 0L;
                }
                case 2: {
                    chan = this.m_channel;
                    cbWrite = 0L;
                    cbPre = 0L;
                    e = offset + length;
                    for (i = offset; i < e; ++i) {
                        cbPre += (long)srcs[i].remaining();
                    }
                    if (this.m_fDropOutput) {
                        e = offset + length;
                        for (i = offset; i < e; ++i) {
                            srcs[i].position(srcs[i].limit());
                        }
                        this.m_cbWrite += cbPre;
                        return cbPre;
                    }
                    try {
                        i = offset;
                        c = length;
                        do {
                            cb = chan.write(srcs, i, c);
                            cbWrite += cb;
                            while (cb != 0L && c > 0 && !srcs[i].hasRemaining()) {
                                ++i;
                                --c;
                            }
                        } while (cb != 0L && c > 0);
                    }
                    catch (IOException ex) {
                        cbPost = 0L;
                        e = offset + length;
                        for (i = offset; i < e; ++i) {
                            cbPost += (long)srcs[i].remaining();
                        }
                        cbWrite = cbPre - cbPost;
                        if (cbWrite != 0L) ** GOTO lbl41
                        throw ex;
                    }
lbl41:
                    // 2 sources

                    this.m_cbWrite += cbWrite;
                    return cbWrite;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0L;
                }
                case ACTIVE: {
                    return this.write(srcs, 0, srcs.length);
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0;
                }
                case ACTIVE: {
                    int cb = this.m_channel.write(src);
                    this.m_cbWrite += (long)cb;
                    return cb;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0L;
                }
                case ACTIVE: {
                    long cb;
                    ByteBuffer bufFirstCorrupt = null;
                    int cbFirst = 0;
                    if (AbstractSocketBus.this.f_nCorruptionRatio != 0) {
                        bufFirstCorrupt = AbstractSocketBus.this.getFirstAvailableForCorruption(dsts, offset);
                        cbFirst = bufFirstCorrupt.remaining();
                    }
                    if ((cb = this.m_channel.read(dsts, offset, length)) < 0L) break;
                    if (AbstractSocketBus.this.f_nCorruptionRatio != 0) {
                        AbstractSocketBus.this.checkForceCorruption(bufFirstCorrupt, (int)Math.min(cb, (long)cbFirst));
                    }
                    if (AbstractSocketBus.this.f_nDropRatio != 0 && AbstractSocketBus.this.checkDrop(this.m_channel)) break;
                    this.m_cbRead += cb;
                    return cb;
                }
            }
            return -1L;
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            switch (this.m_state) {
                case OPEN: {
                    return 0;
                }
                case ACTIVE: {
                    int cb = this.m_channel.read(dst);
                    if (cb < 0) break;
                    if (AbstractSocketBus.this.f_fCrc && AbstractSocketBus.this.f_nCorruptionRatio != 0) {
                        AbstractSocketBus.this.checkForceCorruption(dst, cb);
                    }
                    if (AbstractSocketBus.this.f_nDropRatio != 0 && AbstractSocketBus.this.checkDrop(this.m_channel)) break;
                    this.m_cbRead += (long)cb;
                    return cb;
                }
            }
            return -1;
        }

        public synchronized void migrate(final Throwable eReason) {
            if (this.getProtocolVersion() == 0) {
                this.scheduleDisconnect(eReason);
            } else {
                if (eReason instanceof ConnectException && ++this.m_cReconnectAttempts > AbstractSocketBus.this.f_driver.getDependencies().getSocketReconnectLimit()) {
                    this.scheduleDisconnect(eReason);
                    return;
                }
                final long cMillisDelay = eReason instanceof ConnectException || AbstractSocketBus.this.getLocalEndPoint().getCanonicalName().compareTo(this.getPeer().getCanonicalName()) > 0 ? AbstractSocketBus.this.f_driver.getDependencies().getSocketReconnectDelayMillis() : 0L;
                final SocketChannel chan = this.m_channel;
                final String sChan = chan.toString();
                AbstractSocketBus.closeChannel(chan);
                AbstractSocketBus.this.scheduleUnsafeTask(chan, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Connection connection = Connection.this;
                        synchronized (connection) {
                            if (Connection.this.m_state.ordinal() < ConnectionState.DEFUNCT.ordinal() && chan == Connection.this.m_channel) {
                                AbstractSocketBus.this.getLogger().log(AbstractSocketBus.this.makeExceptionRecord(Level.FINER, eReason, "{0} migrating connection with {1} off of {2} on {3}", AbstractSocketBus.this.getLocalEndPoint(), Connection.this.getPeer(), sChan, Connection.this));
                                Connection.this.m_eMigrationCause = eReason;
                                Connection.this.onMigration();
                                try {
                                    AbstractSocketBus.this.getSelectionService().register(chan, null);
                                    Connection.this.m_handler = null;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                AbstractSocketBus.this.scheduleUnsafeTask(chan, () -> Connection.this.connect(), cMillisDelay);
                            }
                        }
                    }
                }, cMillisDelay);
            }
        }

        protected abstract int onReadySafe(int var1) throws IOException;

        protected int onException(Throwable t) {
            ConnectionState state = this.m_state;
            if (t instanceof IOException && !(t instanceof SSLException) && (state == null || state.ordinal() < ConnectionState.DEFUNCT.ordinal())) {
                this.migrate(t);
            } else {
                this.scheduleDisconnect(t);
            }
            return 0;
        }

        @Override
        public final int onReady(int nOps) {
            try {
                return this.onReadySafe(nOps);
            }
            catch (Throwable t) {
                return this.onException(t);
            }
        }

        protected void setProtocolVersion(int nProt) {
            int nProtocol = this.m_nProtocol;
            if (nProtocol != -1 && nProtocol != nProt) {
                throw new IllegalStateException();
            }
            this.m_nProtocol = nProt;
        }

        public String toString() {
            SocketChannel channel = this.m_channel;
            Socket socket = channel == null ? null : channel.socket();
            int cMigrations = this.m_cMigrations;
            return "peer=" + this.getPeer() + ", state=" + (Object)((Object)this.m_state) + ", socket=" + socket + (cMigrations == 0 ? "" : ", migrations=" + cMigrations) + ", bytes(in=" + this.m_cbRead + ", out=" + this.m_cbWrite + "), flushlock " + this.f_lockFlush.get();
        }

        public int hashCode() {
            return this.f_peer.hashCode();
        }
    }

    protected static enum HandshakePhase {
        NEGOTIATE,
        INTRODUCE,
        ACCEPT,
        ABANDON;

    }

    protected static enum ConnectionState {
        OPEN,
        ACTIVE,
        DEFUNCT,
        FINAL;

    }
}

