/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.internal.util;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import javax.management.MBeanServer;

public class HeapDump {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean s_hotspotDiagMBean;

    public static String dumpHeapForBug(String sBugId) {
        String sClass = HeapDump.class.getName();
        String sPropBug = sClass + "." + sBugId;
        if (Boolean.parseBoolean(System.getProperty(sPropBug, System.getProperty(sClass, "false")))) {
            String sFileName;
            try {
                String sDirName;
                try {
                    sDirName = System.getProperty(sClass + ".dir", System.getProperty("java.io.tmpdir", "."));
                }
                catch (Throwable t) {
                    sDirName = ".";
                }
                File fileDir = new File(sDirName);
                int cLimit = Integer.parseInt(System.getProperty(sPropBug + ".limit", System.getProperty(sClass + ".limit", "3")));
                if (cLimit <= 0) {
                    return null;
                }
                String sPrefix = sBugId + "-";
                Iterator iter = Files.list(fileDir.toPath()).iterator();
                while (iter.hasNext()) {
                    Path path = (Path)iter.next();
                    if (!path.getFileName().toFile().getName().startsWith(sPrefix) || --cLimit > 0) continue;
                    return null;
                }
                File file = File.createTempFile(sPrefix, ".hprof", fileDir);
                sFileName = file.getCanonicalPath();
                file.delete();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return HeapDump.dumpHeap(sFileName, true);
        }
        return null;
    }

    public static String dumpHeap() {
        return HeapDump.dumpHeap(null, true);
    }

    public static String dumpHeap(String sFileName, boolean fLive) {
        HeapDump.initHotspotMBean();
        try {
            File file;
            if (sFileName == null) {
                try {
                    sFileName = System.getProperty(HeapDump.class.getName() + ".dir", System.getProperty("java.io.tmpdir", "."));
                }
                catch (Throwable t) {
                    sFileName = ".";
                }
            }
            if ((file = new File(sFileName)).isDirectory()) {
                file = File.createTempFile("heapdump-", ".hprof", file);
                sFileName = file.getCanonicalPath();
                file.delete();
            }
            s_hotspotDiagMBean.dumpHeap(sFileName, fLive);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
        return sFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (s_hotspotDiagMBean != null) return;
        Class<HeapDump> clazz = HeapDump.class;
        synchronized (HeapDump.class) {
            if (s_hotspotDiagMBean != null) return;
            try {
                HotSpotDiagnosticMXBean bean;
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                s_hotspotDiagMBean = bean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exp) {
                throw new RuntimeException(exp);
            }
            return;
        }
    }
}

