/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.io.SingleBufferSequence;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class BufferSequenceOutputStream
extends OutputStream
implements DataOutput {
    protected BufferManager m_manager;
    protected ByteBuffer m_buffer;
    protected ByteBuffer m_buffTmp;
    protected long m_cb;
    protected List<ByteBuffer> m_listBuffers;

    public BufferSequenceOutputStream(BufferManager manager) {
        this(manager, 0L);
    }

    public BufferSequenceOutputStream(BufferManager manager, long cb) {
        if (manager == null) {
            throw new IllegalArgumentException("manager cannot be null");
        }
        this.m_manager = manager;
        if (cb > 0L) {
            int ncb = (int)cb;
            this.m_buffer = (ByteBuffer)manager.acquirePref(ncb < 0 ? Integer.MAX_VALUE : ncb).clear();
        }
    }

    public void writeBuffer(ByteBuffer buf) throws IOException {
        this.writeBuffer(buf, 0L);
    }

    public void writeBufferSequence(BufferSequence bufseq) throws IOException {
        long cbHint = bufseq.getLength();
        int c = bufseq.getBufferCount();
        for (int i = 0; i < c; ++i) {
            cbHint = this.writeBuffer(bufseq.getBuffer(i), cbHint);
        }
    }

    public BufferSequence toBufferSequence() throws IOException {
        BufferManager manager = this.m_manager;
        List<ByteBuffer> listBuffers = this.m_listBuffers;
        ByteBuffer bufLast = this.m_buffer;
        this.flush();
        this.m_listBuffers = null;
        this.m_buffer = null;
        this.m_manager = null;
        if (listBuffers == null) {
            if (bufLast == null || bufLast.position() == 0) {
                if (bufLast != null) {
                    manager.release(bufLast);
                }
                return Buffers.getEmptyBufferSequence();
            }
            bufLast.flip();
            return new SingleBufferSequence(manager, manager.truncate(bufLast));
        }
        bufLast.flip();
        listBuffers.add(manager.truncate(bufLast));
        return Buffers.createBufferSequence(manager, listBuffers.toArray(new ByteBuffer[listBuffers.size()]));
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.flush(this.ensureBuffer(2).putShort((short)v));
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.flush(this.ensureBuffer(2).putChar((char)v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.flush(this.ensureBuffer(4).putInt(v));
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.flush(this.ensureBuffer(8).putLong(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.flush(this.ensureBuffer(4).putFloat(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.flush(this.ensureBuffer(8).putDouble(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int i = 0;
        int c = s.length();
        while (i <= c - 8) {
            long lch = (long)(0xFF & s.charAt(i++)) << 56;
            lch |= (long)(0xFF & s.charAt(i++)) << 48;
            lch |= (long)(0xFF & s.charAt(i++)) << 40;
            lch |= (long)(0xFF & s.charAt(i++)) << 32;
            lch |= (long)(0xFF & s.charAt(i++)) << 24;
            lch |= (long)(0xFF & s.charAt(i++)) << 16;
            lch |= (long)(0xFF & s.charAt(i++)) << 8;
            this.writeLong(lch |= (long)(0xFF & s.charAt(i++)));
        }
        if (i <= c - 4) {
            int nch = (0xFF & s.charAt(i++)) << 24;
            nch |= (0xFF & s.charAt(i++)) << 16;
            nch |= (0xFF & s.charAt(i++)) << 8;
            this.writeInt(nch |= 0xFF & s.charAt(i++));
        }
        if (i <= c - 2) {
            int nch = (0xFF & s.charAt(i++)) << 8;
            this.writeShort(nch |= 0xFF & s.charAt(i++));
        }
        if (i < c) {
            this.writeByte(s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int i = 0;
        int c = s.length();
        while (i <= c - 4) {
            long lch = (long)(0xFFFF & s.charAt(i++)) << 48;
            lch |= (long)(0xFFFF & s.charAt(i++)) << 32;
            lch |= (long)(0xFFFF & s.charAt(i++)) << 16;
            this.writeLong(lch |= (long)(0xFFFF & s.charAt(i++)));
        }
        if (i <= c - 2) {
            int nch = (0xFFFF & s.charAt(i++)) << 16;
            this.writeInt(nch |= 0xFFFF & s.charAt(i++));
        }
        if (i < c) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.write(bytearr, 0, utflen + 2);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureBuffer().put((byte)b);
    }

    @Override
    public void write(byte[] ab, int of, int cb) throws IOException {
        if (ab == null || of < 0 || cb < 0 || of + cb > ab.length) {
            if (ab == null) {
                throw new IllegalArgumentException("null byte array");
            }
            throw new IllegalArgumentException("ab.length=" + ab.length + ", of=" + of + ", cb=" + cb);
        }
        while (cb > 0) {
            ByteBuffer buff = this.ensureSpace(cb);
            int cbCopy = Math.min(buff.remaining(), cb);
            buff.put(ab, of, cbCopy);
            cb -= cbCopy;
            of += cbCopy;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.m_manager == null) {
            throw new IOException("stream closed");
        }
    }

    @Override
    public void close() {
        if (this.m_manager != null) {
            try {
                this.toBufferSequence().dispose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private long writeBuffer(ByteBuffer buf, long cbHint) throws IOException {
        int cbDst;
        int cb;
        ByteBuffer bufDst = this.ensureSpace(cbHint);
        int nLimit = buf.limit();
        cbHint = Math.max((long)cb, cbHint);
        for (cb = buf.remaining(); cb > bufDst.remaining(); cb -= cbDst) {
            cbDst = bufDst.remaining();
            buf.limit(buf.position() + cbDst);
            bufDst.put(buf);
            buf.limit(nLimit);
            bufDst = this.ensureSpace(cbHint -= (long)cbDst);
        }
        bufDst.put(buf);
        return cbHint - (long)cb;
    }

    protected final ByteBuffer ensureBuffer() throws IOException {
        return this.ensureSpace(1L);
    }

    protected final ByteBuffer ensureSpace(long cbHint) throws IOException {
        BufferManager manager = this.m_manager;
        if (manager == null) {
            throw new IOException("stream closed");
        }
        ByteBuffer buffer = this.m_buffer;
        if (buffer != null && !buffer.hasRemaining()) {
            buffer.flip();
            this.m_cb += (long)buffer.remaining();
            this.ensureBufferList().add(buffer);
            buffer = null;
        }
        if (buffer == null) {
            this.m_buffer = buffer = manager.acquireSum((int)Math.min(Integer.MAX_VALUE, Math.max(this.m_cb, cbHint)));
        }
        return buffer;
    }

    protected final ByteBuffer ensureBuffer(int cb) throws IOException {
        ByteBuffer buff = this.ensureSpace(cb);
        if (buff.remaining() >= cb && buff.order() == ByteOrder.BIG_ENDIAN) {
            return buff;
        }
        ByteBuffer buffTmp = this.m_buffTmp;
        if (buffTmp == null) {
            this.m_buffTmp = buffTmp = ByteBuffer.allocate(8);
        }
        return buffTmp;
    }

    protected final void flush(ByteBuffer buff) throws IOException {
        if (buff == this.m_buffTmp) {
            this.write(buff.array(), 0, buff.position());
            buff.position(0);
        }
    }

    protected List<ByteBuffer> ensureBufferList() {
        List<ByteBuffer> listBuffers = this.m_listBuffers;
        if (listBuffers == null) {
            this.m_listBuffers = listBuffers = new ArrayList<ByteBuffer>();
        }
        return listBuffers;
    }
}

