/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.io;

import com.oracle.coherence.common.io.BufferSequence;
import java.nio.ByteBuffer;

public class CompositeBufferSequence
implements BufferSequence {
    final BufferSequence f_bufSeqA;
    final BufferSequence f_bufSeqB;

    public CompositeBufferSequence(BufferSequence bufSeqA, BufferSequence bufSeqB) {
        this.f_bufSeqA = bufSeqA;
        this.f_bufSeqB = bufSeqB;
    }

    @Override
    public long getLength() {
        return this.f_bufSeqA.getLength() + this.f_bufSeqB.getLength();
    }

    @Override
    public int getBufferCount() {
        return this.f_bufSeqA.getBufferCount() + this.f_bufSeqB.getBufferCount();
    }

    @Override
    public ByteBuffer getBuffer(int iBuffer) {
        int cBufA = this.f_bufSeqA.getBufferCount();
        return iBuffer < cBufA ? this.f_bufSeqA.getBuffer(iBuffer) : this.f_bufSeqB.getBuffer(iBuffer - cBufA);
    }

    @Override
    public ByteBuffer getUnsafeBuffer(int iBuffer) {
        int cBufA = this.f_bufSeqA.getBufferCount();
        return iBuffer < cBufA ? this.f_bufSeqA.getUnsafeBuffer(iBuffer) : this.f_bufSeqB.getUnsafeBuffer(iBuffer - cBufA);
    }

    @Override
    public int getBufferPosition(int iBuffer) {
        int cBufA = this.f_bufSeqA.getBufferCount();
        return iBuffer < cBufA ? this.f_bufSeqA.getBufferPosition(iBuffer) : this.f_bufSeqB.getBufferPosition(iBuffer - cBufA);
    }

    @Override
    public int getBufferLimit(int iBuffer) {
        int cBufA = this.f_bufSeqA.getBufferCount();
        return iBuffer < cBufA ? this.f_bufSeqA.getBufferLimit(iBuffer) : this.f_bufSeqB.getBufferLimit(iBuffer - cBufA);
    }

    @Override
    public int getBufferLength(int iBuffer) {
        int cBufA = this.f_bufSeqA.getBufferCount();
        return iBuffer < cBufA ? this.f_bufSeqA.getBufferLength(iBuffer) : this.f_bufSeqB.getBufferLength(iBuffer - cBufA);
    }

    @Override
    public ByteBuffer[] getBuffers() {
        int cBufA = this.f_bufSeqA.getBufferCount();
        int cBufB = this.f_bufSeqB.getBufferCount();
        ByteBuffer[] aBuff = new ByteBuffer[cBufA + cBufB];
        this.f_bufSeqA.getBuffers(0, cBufA, aBuff, 0);
        this.f_bufSeqB.getBuffers(0, cBufB, aBuff, cBufA);
        return aBuff;
    }

    @Override
    public void getBuffers(int iBuffer, int cBuffers, ByteBuffer[] abufDest, int iDest) {
        int cBufA = this.f_bufSeqA.getBufferCount();
        if (iBuffer < cBufA) {
            int cBufCopy = Math.min(cBuffers, cBufA - iBuffer);
            this.f_bufSeqA.getBuffers(iBuffer, cBufCopy, abufDest, iDest);
            iDest += cBufCopy;
            iBuffer += cBufCopy;
            cBuffers -= cBufCopy;
        }
        if (cBuffers > 0) {
            this.f_bufSeqB.getBuffers(iBuffer - cBufA, cBuffers, abufDest, iDest);
        }
    }

    @Override
    public void dispose() {
        this.f_bufSeqA.dispose();
        this.f_bufSeqB.dispose();
    }
}

