/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net;

import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class SSLSettings {
    protected SSLContext m_ctx;
    protected boolean m_fClientAuthRequired;
    protected HostnameVerifier m_hostnameVerifier;
    protected String[] m_asCipherSuitesEnabled;
    protected String[] m_asProtocolVersionsEnabled;

    public SSLSettings() {
    }

    public SSLSettings(SSLSettings settingsSSL) {
        if (settingsSSL != null) {
            this.m_ctx = settingsSSL.getSSLContext();
            this.m_fClientAuthRequired = settingsSSL.isClientAuthenticationRequired();
            this.m_hostnameVerifier = settingsSSL.getHostnameVerifier();
            this.m_asCipherSuitesEnabled = settingsSSL.getEnabledCipherSuites();
            this.m_asProtocolVersionsEnabled = settingsSSL.getEnabledProtocolVersions();
        }
    }

    public SSLContext getSSLContext() {
        SSLContext ctx = this.m_ctx;
        try {
            return ctx == null ? SSLContext.getDefault() : ctx;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public SSLSettings setSSLContext(SSLContext ctx) {
        this.m_ctx = ctx;
        return this;
    }

    public boolean isClientAuthenticationRequired() {
        return this.m_fClientAuthRequired;
    }

    public SSLSettings setClientAuthenticationRequired(boolean fRequired) {
        this.m_fClientAuthRequired = fRequired;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.m_hostnameVerifier;
    }

    public SSLSettings setHostnameVerifier(HostnameVerifier verifier) {
        this.m_hostnameVerifier = verifier;
        return this;
    }

    public String[] getEnabledCipherSuites() {
        return this.m_asCipherSuitesEnabled;
    }

    public SSLSettings setEnabledCipherSuites(String[] asCiphers) {
        this.m_asCipherSuitesEnabled = asCiphers;
        return this;
    }

    public String[] getEnabledProtocolVersions() {
        return this.m_asProtocolVersionsEnabled;
    }

    public SSLSettings setEnabledProtocolVersions(String[] asProtocols) {
        this.m_asProtocolVersionsEnabled = asProtocols;
        return this;
    }
}

