/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.net.exabus.util;

import com.oracle.coherence.common.base.Hasher;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.exabus.EndPoint;
import java.net.SocketAddress;

public class UrlEndPoint
implements EndPoint {
    public static final String PROTOCOL_DELIMITER = "://";
    private final String f_sName;
    private final String f_sProtocol;
    private final SocketAddress f_address;
    private final String f_sQuery;
    private final int f_nHashCode;
    private final Hasher<? super SocketAddress> f_hasher;

    public UrlEndPoint(String sName, SocketProvider provider, Hasher<? super SocketAddress> hasher) {
        String sQuery;
        String sAddress;
        if (sName == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        int ofProtocolEnd = sName.indexOf(PROTOCOL_DELIMITER);
        if (ofProtocolEnd == -1) {
            throw new IllegalArgumentException("name does not contain a protocol");
        }
        String sProtocol = sName.substring(0, ofProtocolEnd);
        String sRemainder = sName.substring(ofProtocolEnd + PROTOCOL_DELIMITER.length());
        if (sRemainder.indexOf(47) != -1) {
            throw new IllegalArgumentException("URL paths are not supported");
        }
        if (sRemainder.indexOf(63) != -1) {
            int ofQuery = sRemainder.indexOf(63);
            sAddress = sRemainder.substring(0, ofQuery);
            sQuery = sRemainder.substring(ofQuery + 1);
        } else {
            sAddress = sRemainder;
            sQuery = null;
        }
        this.f_sName = sName;
        this.f_sProtocol = sProtocol;
        this.f_hasher = hasher;
        this.f_address = provider.resolveAddress(sAddress);
        this.f_sQuery = sQuery;
        this.f_nHashCode = sProtocol.hashCode() + hasher.hashCode(this.f_address);
    }

    public SocketAddress getAddress() {
        return this.f_address;
    }

    public String getProtocol() {
        return this.f_sProtocol;
    }

    public String getQueryString() {
        return this.f_sQuery;
    }

    @Override
    public String getCanonicalName() {
        return this.f_sName;
    }

    @Override
    public int hashCode() {
        return this.f_nHashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UrlEndPoint) {
            UrlEndPoint that = (UrlEndPoint)o;
            return this.getProtocol().equals(that.getProtocol()) && this.f_hasher.equals(this.getAddress(), that.getAddress());
        }
        return false;
    }

    public String toString() {
        return this.f_sName;
    }
}

