/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.Property;
import com.oracle.coherence.common.schema.PropertyHandler;
import com.oracle.coherence.common.schema.Schema;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AbstractPropertyHandler<TInternal extends Property, TExternal>
implements PropertyHandler<TInternal, TExternal> {
    private Class<TInternal> m_internalClass;
    private Class<TExternal> m_externalClass;
    private Constructor<TInternal> m_ctorInternal;

    protected AbstractPropertyHandler() {
        Class<?> clazz = this.getClass();
        Type superclass = clazz.getGenericSuperclass();
        Type internalType = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        while (!superclass.toString().startsWith("com.oracle.coherence.common.schema.AbstractPropertyHandler")) {
            clazz = clazz.getSuperclass();
            superclass = clazz.getGenericSuperclass();
        }
        Type externalType = ((ParameterizedType)superclass).getActualTypeArguments()[1];
        if (internalType instanceof Class) {
            this.setInternalClass((Class)internalType);
        }
        if (externalType instanceof Class) {
            this.m_externalClass = (Class)externalType;
        }
    }

    protected void setInternalClass(Class<TInternal> internalType) {
        this.m_internalClass = internalType;
        try {
            this.m_ctorInternal = this.m_internalClass.getConstructor(ExtensibleProperty.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Property class " + this.m_internalClass.getName() + " does not implement a constructor that accepts " + ExtensibleProperty.class.getName());
        }
    }

    @Override
    public Class<TInternal> getInternalPropertyClass() {
        return this.m_internalClass;
    }

    @Override
    public Class<TExternal> getExternalPropertyClass() {
        return this.m_externalClass;
    }

    @Override
    public TInternal createProperty(ExtensibleProperty parent) {
        try {
            return (TInternal)((Property)this.m_ctorInternal.newInstance(parent));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void importProperty(TInternal property, TExternal source, Schema schema) {
    }

    @Override
    public void exportProperty(TInternal property, TExternal target, Schema schema) {
    }
}

