/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.Property;
import com.oracle.coherence.common.schema.SchemaVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExtensibleProperty
implements Property<CanonicalTypeDescriptor> {
    private String m_name;
    private CanonicalTypeDescriptor m_type;
    private Map<String, Property> m_extensions = new HashMap<String, Property>();

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public CanonicalTypeDescriptor getType() {
        return this.m_type;
    }

    @Override
    public <T extends Property> T getExtension(Class<T> clzExtension) {
        return (T)this.m_extensions.get(clzExtension.getName());
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visitProperty(this);
        for (Property ext : this.getExtensions()) {
            ext.accept(visitor);
        }
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setType(CanonicalTypeDescriptor type) {
        this.m_type = type;
    }

    public <T extends Property> void addExtension(T extension) {
        this.m_extensions.put(extension.getClass().getName(), extension);
    }

    public Collection<Property> getExtensions() {
        return Collections.unmodifiableCollection(this.m_extensions.values());
    }

    public String toString() {
        return "ExtensibleProperty{name='" + this.m_name + '\'' + ", type=" + this.m_type + '}';
    }
}

