/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema;

import com.oracle.coherence.common.schema.CanonicalTypeDescriptor;
import com.oracle.coherence.common.schema.ExtensibleProperty;
import com.oracle.coherence.common.schema.PropertyAware;
import com.oracle.coherence.common.schema.SchemaVisitor;
import com.oracle.coherence.common.schema.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ExtensibleType
implements Type<ExtensibleProperty, CanonicalTypeDescriptor> {
    private CanonicalTypeDescriptor m_descriptor;
    private CanonicalTypeDescriptor m_base;
    private boolean m_fExternal;
    private Set<CanonicalTypeDescriptor> m_interfaces = new LinkedHashSet<CanonicalTypeDescriptor>();
    private Map<String, ExtensibleProperty> m_properties = new LinkedHashMap<String, ExtensibleProperty>();
    private Map<String, Type> m_extensions = new HashMap<String, Type>();

    @Override
    public String getNamespace() {
        return this.m_descriptor.getNamespace();
    }

    @Override
    public String getName() {
        return this.m_descriptor.getName();
    }

    @Override
    public String getFullName() {
        return this.m_descriptor.getFullName();
    }

    @Override
    public CanonicalTypeDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    @Override
    public ExtensibleProperty getProperty(String propertyName) {
        return this.m_properties.get(propertyName);
    }

    @Override
    public Collection<ExtensibleProperty> getProperties() {
        return Collections.unmodifiableCollection(this.m_properties.values());
    }

    @Override
    public <T extends Type> T getExtension(Class<T> clzExtension) {
        return (T)this.m_extensions.get(clzExtension.getName());
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visitType(this);
        for (Type ext : this.getExtensions()) {
            ext.accept(visitor);
        }
        for (ExtensibleProperty property : this.getProperties()) {
            property.accept(visitor);
        }
    }

    public void setDescriptor(CanonicalTypeDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public CanonicalTypeDescriptor getBase() {
        return this.m_base;
    }

    public void setBase(CanonicalTypeDescriptor base) {
        this.m_base = base;
    }

    public boolean isExternal() {
        return this.m_fExternal;
    }

    public void setExternal(boolean fExternal) {
        this.m_fExternal = fExternal;
    }

    public Set<CanonicalTypeDescriptor> getInterfaces() {
        return Collections.unmodifiableSet(this.m_interfaces);
    }

    public void addInterface(CanonicalTypeDescriptor descriptor) {
        this.m_interfaces.add(descriptor);
    }

    public void addProperty(ExtensibleProperty property) {
        this.m_properties.put(property.getName(), property);
        for (Type ext : this.m_extensions.values()) {
            if (!(ext instanceof PropertyAware)) continue;
            ((PropertyAware)((Object)ext)).propertyAdded(property);
        }
    }

    public <T extends Type> void addExtension(T extension) {
        this.m_extensions.put(extension.getClass().getName(), extension);
    }

    public Collection<Type> getExtensions() {
        return Collections.unmodifiableCollection(this.m_extensions.values());
    }

    public String toString() {
        return "ExtensibleType{descriptor=" + this.m_descriptor + ", base=" + this.m_base + ", external=" + this.m_fExternal + ", interfaces=" + this.m_interfaces + '}';
    }
}

