/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.lang;

import com.oracle.coherence.common.schema.AbstractPropertyHandler;
import com.oracle.coherence.common.schema.Schema;
import com.oracle.coherence.common.schema.TypeDescriptor;
import com.oracle.coherence.common.schema.lang.AbstractLangProperty;
import com.oracle.coherence.common.schema.util.AsmUtils;
import com.oracle.coherence.common.schema.util.StringUtils;
import com.tangosol.internal.asm.Type;
import com.tangosol.internal.asm.tree.AnnotationNode;
import com.tangosol.internal.asm.tree.FieldNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;

public class ClassFilePropertyHandler<T extends AbstractLangProperty<TD>, TD extends TypeDescriptor, A extends Annotation>
extends AbstractPropertyHandler<T, FieldNode> {
    private final Class<TD> m_typeDescriptorClass;
    private final Class<A> m_annotationClass;
    private Method m_parseMethod;

    public ClassFilePropertyHandler() {
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        this.m_typeDescriptorClass = (Class)((ParameterizedType)superclass).getActualTypeArguments()[1];
        this.m_annotationClass = (Class)((ParameterizedType)superclass).getActualTypeArguments()[2];
    }

    @Override
    public void importProperty(T property, FieldNode source, Schema schema) {
        String name;
        AnnotationNode an = AsmUtils.getAnnotation(source, this.m_annotationClass);
        if (an != null && !StringUtils.isEmpty(name = (String)AsmUtils.getAnnotationAttribute(an, "type"))) {
            ((AbstractLangProperty)property).setType(this.parseTypeName(name));
        }
    }

    @Override
    public void exportProperty(T property, FieldNode target, Schema schema) {
        if (((AbstractLangProperty)property).getType() != null) {
            AnnotationNode an = new AnnotationNode(Type.getDescriptor(this.m_annotationClass));
            an.values = Arrays.asList("type", ((AbstractLangProperty)property).getType().getFullName());
            AsmUtils.addAnnotation(target, an);
        }
    }

    protected TD parseTypeName(String name) {
        try {
            if (this.m_parseMethod == null) {
                this.m_parseMethod = this.m_typeDescriptorClass.getMethod("parse", String.class);
            }
            return (TD)((TypeDescriptor)this.m_parseMethod.invoke(this.m_typeDescriptorClass, name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

