/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.lang.cpp;

import com.oracle.coherence.common.schema.PropertyHandler;
import com.oracle.coherence.common.schema.SchemaExtension;
import com.oracle.coherence.common.schema.TypeHandler;
import com.oracle.coherence.common.schema.lang.ClassFilePropertyHandler;
import com.oracle.coherence.common.schema.lang.ClassFileTypeHandler;
import com.oracle.coherence.common.schema.lang.JavaSourcePropertyHandler;
import com.oracle.coherence.common.schema.lang.JavaSourceTypeHandler;
import com.oracle.coherence.common.schema.lang.XmlPropertyHandler;
import com.oracle.coherence.common.schema.lang.XmlTypeHandler;
import com.oracle.coherence.common.schema.lang.cpp.CppProperty;
import com.oracle.coherence.common.schema.lang.cpp.CppTypeDescriptor;
import com.oracle.coherence.common.schema.lang.cpp.annotation.CppType;
import java.util.Arrays;
import java.util.Collection;

public class CppExtension
implements SchemaExtension {
    private static final String NS = "http://xmlns.oracle.com/coherence/schema/cpp";

    @Override
    public String getName() {
        return "c++";
    }

    @Override
    public Collection<TypeHandler> getTypeHandlers() {
        return Arrays.asList(new CppClassFileTypeHandler(), new CppJavaSourceTypeHandler(), new CppXmlTypeHandler());
    }

    @Override
    public Collection<PropertyHandler> getPropertyHandlers() {
        return Arrays.asList(new CppClassFilePropertyHandler(), new CppJavaSourcePropertyHandler(), new CppXmlPropertyHandler());
    }

    public static class CppXmlPropertyHandler
    extends XmlPropertyHandler<CppProperty, CppTypeDescriptor> {
        public CppXmlPropertyHandler() {
            super(CppExtension.NS);
        }
    }

    public static class CppXmlTypeHandler
    extends XmlTypeHandler<com.oracle.coherence.common.schema.lang.cpp.CppType, CppTypeDescriptor> {
        public CppXmlTypeHandler() {
            super(CppExtension.NS);
        }
    }

    public static class CppJavaSourcePropertyHandler
    extends JavaSourcePropertyHandler<CppProperty, CppTypeDescriptor, com.oracle.coherence.common.schema.lang.cpp.annotation.CppProperty> {
    }

    public static class CppJavaSourceTypeHandler
    extends JavaSourceTypeHandler<com.oracle.coherence.common.schema.lang.cpp.CppType, CppTypeDescriptor, CppType> {
    }

    public static class CppClassFilePropertyHandler
    extends ClassFilePropertyHandler<CppProperty, CppTypeDescriptor, com.oracle.coherence.common.schema.lang.cpp.annotation.CppProperty> {
    }

    public static class CppClassFileTypeHandler
    extends ClassFileTypeHandler<com.oracle.coherence.common.schema.lang.cpp.CppType, CppTypeDescriptor, CppType> {
    }
}

