/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.schema.util;

import com.tangosol.internal.asm.Type;
import com.tangosol.internal.asm.tree.AnnotationNode;
import com.tangosol.internal.asm.tree.ClassNode;
import com.tangosol.internal.asm.tree.FieldNode;
import java.util.ArrayList;
import java.util.List;

public class AsmUtils {
    public static String javaName(String sInternalName) {
        return sInternalName.replace('/', '.');
    }

    public static String internalName(String sJavaName) {
        return sJavaName.replace('.', '/');
    }

    public static void addAnnotation(ClassNode node, AnnotationNode annotation) {
        if (node.visibleAnnotations == null) {
            node.visibleAnnotations = new ArrayList<AnnotationNode>();
        }
        node.visibleAnnotations.add(annotation);
    }

    public static void addAnnotation(FieldNode node, AnnotationNode annotation) {
        if (node.visibleAnnotations == null) {
            node.visibleAnnotations = new ArrayList<AnnotationNode>();
        }
        node.visibleAnnotations.add(annotation);
    }

    public static boolean hasAnnotation(ClassNode node, Class annotationClass) {
        return AsmUtils.getAnnotation(node, annotationClass) != null;
    }

    public static boolean hasAnnotation(FieldNode node, Class annotationClass) {
        return AsmUtils.getAnnotation(node, annotationClass) != null;
    }

    public static AnnotationNode getAnnotation(ClassNode node, Class ... annotationClasses) {
        return AsmUtils.findAnnotationNode(node.visibleAnnotations, annotationClasses);
    }

    public static AnnotationNode getAnnotation(FieldNode node, Class ... annotationClasses) {
        return AsmUtils.findAnnotationNode(node.visibleAnnotations, annotationClasses);
    }

    private static AnnotationNode findAnnotationNode(List<AnnotationNode> annotations, Class[] annotationClasses) {
        if (annotations != null) {
            for (Class annotationClass : annotationClasses) {
                String desc = Type.getDescriptor(annotationClass);
                for (AnnotationNode an : annotations) {
                    if (!desc.equals(an.desc)) continue;
                    return an;
                }
            }
        }
        return null;
    }

    public static Object getAnnotationAttribute(AnnotationNode an, String name) {
        if (an.values != null) {
            for (int i = 0; i < an.values.size(); i += 2) {
                if (!name.equals(an.values.get(i))) continue;
                Object val = an.values.get(i + 1);
                if (val instanceof String[]) {
                    String[] asVal = (String[])val;
                    String sEnumClass = Type.getType(asVal[0]).getClassName();
                    String sEnumValue = asVal[1];
                    try {
                        return Enum.valueOf(Class.forName(sEnumClass), sEnumValue);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                return val;
            }
        }
        try {
            Class<?> clazz = AsmUtils.class.getClassLoader().loadClass(an.desc.substring(1, an.desc.length() - 1).replace('/', '.'));
            Object defaultValue = clazz.getMethod(name, new Class[0]).getDefaultValue();
            return defaultValue instanceof Class ? Type.getType((Class)defaultValue) : defaultValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

