/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.persistence;

import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;

public class PersistenceException
extends RuntimeException {
    private volatile PersistenceEnvironment<?>[] m_aEnv;
    private volatile PersistenceManager<?>[] m_aManager;
    private volatile PersistentStore<?>[] m_aStore;

    public PersistenceException() {
    }

    public PersistenceException(String sMessage) {
        super(sMessage);
    }

    public PersistenceException(String sMessage, Throwable eCause) {
        super(sMessage, eCause);
    }

    public PersistenceException(Throwable eCause) {
        super(eCause);
    }

    public PersistenceException(String sMessage, PersistenceException eCause) {
        super(sMessage, eCause);
        this.initPersistenceEnvironment(eCause.getPersistenceEnvironment()).initPersistenceManager(eCause.getPersistenceManager()).initPersistentStore(eCause.getPersistentStore());
    }

    public PersistenceException(PersistenceException eCause) {
        super(eCause);
        this.initPersistenceEnvironment(eCause.getPersistenceEnvironment()).initPersistenceManager(eCause.getPersistenceManager()).initPersistentStore(eCause.getPersistentStore());
    }

    public PersistenceEnvironment<?> getPersistenceEnvironment() {
        PersistenceEnvironment<?>[] aEnv = this.m_aEnv;
        return aEnv == null ? null : aEnv[0];
    }

    public synchronized PersistenceException initPersistenceEnvironment(PersistenceEnvironment<?> env) {
        if (this.m_aEnv == null) {
            this.m_aEnv = new PersistenceEnvironment[]{env};
        }
        return this;
    }

    public PersistenceManager<?> getPersistenceManager() {
        PersistenceManager<?>[] aManager = this.m_aManager;
        return aManager == null ? null : aManager[0];
    }

    public synchronized PersistenceException initPersistenceManager(PersistenceManager<?> manager) {
        if (this.m_aManager == null) {
            this.m_aManager = new PersistenceManager[]{manager};
        }
        return this;
    }

    public PersistentStore<?> getPersistentStore() {
        PersistentStore<?>[] aStore = this.m_aStore;
        return aStore == null ? null : this.m_aStore[0];
    }

    public synchronized PersistenceException initPersistentStore(PersistentStore<?> store) {
        if (this.m_aStore == null) {
            this.m_aStore = new PersistentStore[]{store};
        }
        return this;
    }
}

