/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.application.console;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Application;
import com.tangosol.coherence.component.application.Console;
import com.tangosol.coherence.component.application.console.Coherence$CacheItem;
import com.tangosol.coherence.component.application.console.Coherence$Logger;
import com.tangosol.coherence.component.application.console.Coherence$Worker;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.jmxHelper.HttpAdapter;
import com.tangosol.coherence.component.net.jmxHelper.ServerConnector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberHeartbeat;
import com.tangosol.coherence.component.util.transactionCache.Local;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.dslquery.QueryPlus;
import com.tangosol.coherence.dslquery.internal.PersistenceToolsHelper;
import com.tangosol.dev.component.ComponentClassLoader;
import com.tangosol.dev.component.NullStorage;
import com.tangosol.internal.net.logging.DefaultLoggingDependencies;
import com.tangosol.internal.net.logging.LegacyXmlLoggingHelper;
import com.tangosol.internal.net.management.DefaultGatewayDependencies;
import com.tangosol.internal.net.management.LegacyXmlGatewayHelper;
import com.tangosol.internal.util.MapBackupHelper;
import com.tangosol.internal.util.ObjectFormatter;
import com.tangosol.io.ReadBuffer;
import com.tangosol.license.LicensedObject;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.cache.ContinuousQueryCache;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.SimplePartitionKey;
import com.tangosol.net.security.SimpleHandler;
import com.tangosol.run.jca.SimpleValidator;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.CompositeKey;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.UID;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.Versionable;
import com.tangosol.util.WrapperException;
import com.tangosol.util.aggregator.QueryRecorder;
import com.tangosol.util.comparator.ChainedComparator;
import com.tangosol.util.comparator.InverseComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ConditionalExtractor;
import com.tangosol.util.extractor.DeserializationAccelerator;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.FilterTrigger;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.processor.AsynchronousProcessor;
import com.tangosol.util.processor.ConditionalProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.security.auth.Subject;

public class Coherence
extends Console {
    public static final String COPYRIGHT = "Copyright (c) 2000, 2021, Oracle and/or its affiliates. All rights reserved.";
    public static final String DEFAULT_EDITION = "GE";
    public static final String DEFAULT_MODE = "development";
    public static final String[] EDITION_NAMES;
    public static final String FILE_CFG_CERTIFICATE = "tangosol.cer";
    public static final String FILE_CFG_COHERENCE = "/tangosol-coherence.xml";
    public static final String FILE_CFG_COHERENCE_OVERRIDE = "/tangosol-coherence-override.xml";
    public static final String[] MODE_NAMES;
    public static final String TITLE = "Oracle Coherence";
    public static final String VERSION;
    public static final String VERSION_INTERNAL;
    private transient List __m_CommandHistory;
    private int __m_Edition;
    private transient Map __m_Filters;
    private transient Coherence$Logger __m_Logger;
    private transient AtomicReference __m_LoggerRef;
    private transient NamedCache __m_Map;
    private int __m_Mode;
    private PersistenceToolsHelper __m_PersistenceToolsHelper;
    private transient String __m_Product;
    private boolean __m_Script;
    private ScriptEngine __m_ScriptEngine;
    private transient CacheService __m_Service;
    private transient boolean __m_Stop;
    private static ListMap __mapChildren;
    private static transient String __s_BuildNumber;
    private static transient SafeCluster __s_Cluster;
    private static volatile boolean __s_ConfigurationLoaded;
    private static transient boolean __s_LicenseLoaded;
    private static Map __s_ServiceConfigMap;
    private static transient ThreadLocal __s_TloCluster;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;
    private static /* synthetic */ Class __sf2;
    private static /* synthetic */ Class __sf3;

    static {
        try {
            EDITION_NAMES = new String[]{"DC", "RTC", "SE", "CE", "EE", DEFAULT_EDITION};
            MODE_NAMES = new String[]{"eval", "dev", "prod"};
            VERSION = null;
            VERSION_INTERNAL = null;
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        Coherence._initStatic();
    }

    public Coherence() {
        this(null, null, true);
    }

    public Coherence(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        if (Application.__singleton != null) {
            throw new IllegalStateException("A singleton for \\\"Coherence\\\" has already been set");
        }
        Application.__singleton = this;
        this.__initPrivate();
        try {
            this.setCommandHistory(new LinkedList());
            this.setLoggerRef(new AtomicReference());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        try {
            Coherence.setServiceConfigMap(new SafeHashMap());
            __s_TloCluster = new ThreadLocal();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("CacheItem", Coherence$CacheItem.get_CLASS());
        Class clazz2 = __mapChildren.put("Logger", Coherence$Logger.get_CLASS());
        Class clazz3 = __mapChildren.put("Worker", Coherence$Worker.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("com.tangosol.run.xml.XmlElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm2() {
        Class<?> clazz = __sf2;
        if (clazz == null) {
            try {
                clazz = __sf2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm3() {
        Class<?> clazz = __sf3;
        if (clazz == null) {
            try {
                clazz = __sf3 = Class.forName("com.tangosol.license.LicensedObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static void _initStatic$Default() {
        Coherence.__initStatic();
    }

    protected static void _initStatic() {
        Coherence._initStatic$Default();
        String MANIFEST = "META-INF/MANIFEST.MF";
        InputStream in = null;
        String sVersion = null;
        String sVersionPrefix = "";
        String sDescr = null;
        Attributes attrs = null;
        try {
            try {
                ProtectionDomain domain = Coherence.get_CLASS().getProtectionDomain();
                CodeSource source = domain == null ? null : domain.getCodeSource();
                URL urlSrc = source == null ? null : source.getLocation();
                if (urlSrc != null) {
                    try {
                        URLConnection urlCon = new URL(new StringBuilder(String.valueOf("jar:")).append(urlSrc).append('!').append('/').append(MANIFEST).toString()).openConnection();
                        urlCon.setUseCaches(false);
                        in = urlCon.getInputStream();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (in == null) {
                        try {
                            in = new URL(new StringBuilder(String.valueOf(urlSrc)).append(new StringBuilder(String.valueOf('/')).append(MANIFEST).toString()).toString()).openStream();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (in != null && (attrs = Coherence.getCoherenceAttributes(in)) == null) {
                        in.close();
                    }
                }
                if (attrs == null) {
                    ClassLoader loader = Coherence.get_CLASS().getClassLoader();
                    Enumeration<URL> enumMF = loader == null ? ClassLoader.getSystemResources(MANIFEST) : loader.getResources(MANIFEST);
                    while (enumMF.hasMoreElements()) {
                        URL urlNext = enumMF.nextElement();
                        in = urlNext.openStream();
                        attrs = Coherence.getCoherenceAttributes(in);
                        if (attrs != null) break;
                        in.close();
                    }
                }
                if (attrs != null) {
                    Coherence.setBuildNumber(attrs.getValue("Implementation-Build"));
                    sDescr = attrs.getValue("Implementation-Description");
                    sVersion = attrs.getValue("Implementation-Version");
                    sVersionPrefix = attrs.getValue("Coherence-Version-Prefix");
                    sVersionPrefix = (sVersionPrefix == null ? true : sVersionPrefix.isEmpty()) ? "" : new StringBuilder(String.valueOf(sVersionPrefix)).append(".").toString();
                }
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {}
        if (sVersion == null) {
            System.err.println(new StringBuilder(String.valueOf(TITLE)).append(": The Manifest is corrupted or inaccessible;").append(" some functionality may be disabled").toString());
            sVersion = "n/a";
            Coherence.setBuildNumber("n/a");
        }
        VERSION = sVersion;
        VERSION_INTERNAL = new StringBuilder(String.valueOf(sVersionPrefix)).append(sVersion).toString();
    }

    protected Set applyFilter(String sFilter, boolean fKeysOnly, Comparator comparator, int nPage) {
        try {
            LimitFilter filterLimit;
            Filter filter = (Filter)this.getFilters().get(sFilter);
            Set<Object> setEntry = null;
            if (filter instanceof LimitFilter) {
                filterLimit = (LimitFilter)filter;
                if (nPage >= 0) {
                    filterLimit.setPage(nPage);
                }
                filterLimit.setComparator(comparator);
            }
            setEntry = fKeysOnly ? this.getMap().keySet(filter) : (comparator != null ? this.getMap().entrySet(filter, comparator) : this.getMap().entrySet(filter));
            if (!(filter instanceof LimitFilter) ? false : nPage < 0) {
                filterLimit = (LimitFilter)filter;
                if (setEntry.size() < filterLimit.getPageSize()) {
                    filterLimit.setPage(0);
                } else {
                    filterLimit.nextPage();
                }
            }
            return setEntry;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected static String calculateAttribute(String sAttr) {
        String MODE = "{mode}";
        if (sAttr.indexOf(MODE) >= 0) {
            XmlElement xmlLicense = (XmlElement)Coherence.getServiceConfigMap().get("$License");
            sAttr = Base.replace(sAttr, MODE, xmlLicense.getSafeElement("license-mode").getString(DEFAULT_MODE));
        }
        while (!sAttr.startsWith("{") ? false : sAttr.endsWith("}")) {
            String sDefault;
            String sPropName;
            int ofDefault = sAttr.indexOf(32);
            int cchLength = sAttr.length();
            if (ofDefault < 0) {
                sDefault = sPropName = sAttr.substring(1, cchLength - 1);
            } else {
                sPropName = sAttr.substring(1, ofDefault);
                sDefault = sAttr.substring(ofDefault + 1, cchLength - 1);
            }
            sAttr = Config.getProperty(sPropName, sDefault);
        }
        return sAttr;
    }

    protected Object convertArgument(String sParam) {
        block47: {
            String sValue;
            int ofStart = sParam.indexOf(123);
            if (ofStart == 0) {
                if (sParam.equals("{cluster}")) {
                    return Coherence.getSafeCluster();
                }
                if (sParam.startsWith("{composite:")) {
                    String sArgs = sParam.substring(11, sParam.length() - 1).trim();
                    int iSplit = sArgs.indexOf(44);
                    return new CompositeKey<Object, Object>(this.convertArgument(sArgs.substring(0, iSplit).trim()), this.convertArgument(sArgs.substring(iSplit + 1).trim()));
                }
                if (sParam.equals("{Date}")) {
                    return new Date(Base.getSafeTimeMillis());
                }
                if (sParam.equals("{date}")) {
                    return new Date(Coherence.getSafeCluster().getTimeMillis());
                }
                if (sParam.equals("{map}")) {
                    return this.getMap();
                }
                if (sParam.equals("{Member}")) {
                    return Coherence.getSafeCluster().getLocalMember();
                }
                if (sParam.startsWith("{partition:")) {
                    Integer NPart = (Integer)this.convertArgument(sParam.substring(11, sParam.length() - 1));
                    return SimplePartitionKey.getPartitionKey(NPart);
                }
                if (sParam.equals("{random}")) {
                    return Base.getRandom().nextInt();
                }
                if (sParam.equals("{result}")) {
                    return ((ThreadLocal)this.get_Sink()).get();
                }
                if (sParam.equals("{service}")) {
                    return this.getService();
                }
                if (sParam.equals("{time}")) {
                    return Coherence.getSafeCluster().getTimeMillis();
                }
                if (sParam.endsWith("}")) {
                    sValue = sParam.substring(1, sParam.length() - 1);
                    if (sValue.charAt(0) == '#') {
                        int ofIter = sValue.indexOf(32);
                        String sIter = sValue.substring(1, ofIter);
                        int cIters = Integer.parseInt(sIter);
                        if (ofIter > 0) {
                            Object[] aoValue = new Object[cIters];
                            sValue = sValue.substring(ofIter + 1);
                            int i = 0;
                            while (i < cIters) {
                                String s = sValue.indexOf(35) >= 0 ? Base.replace(sValue, "#", String.valueOf(i)) : sValue;
                                aoValue[i] = this.convertArgument(s);
                                ++i;
                            }
                            return new ImmutableArrayList(aoValue);
                        }
                    } else {
                        if (sValue.indexOf(44) >= 0) {
                            Object[] aoValue = sValue.length() == 0 ? ClassHelper.VOID : this.convertArguments(Base.parseDelimitedString(sValue, ','));
                            return new ImmutableArrayList(aoValue);
                        }
                        if (sValue.startsWith("filter:")) {
                            String sFilter = sValue.substring(sValue.indexOf(58) + 1);
                            return (Filter)this.getFilters().get(sFilter);
                        }
                    }
                } else {
                    throw new RuntimeException(new StringBuilder(String.valueOf("Unbalanced {} in parameter: ")).append(sParam).append("; quotes may need to be used").toString());
                }
            }
            if (ofStart >= 0) {
                int ofEnd;
                String[][] aasReplace = null;
                try {
                    SafeCluster cluster = Coherence.getSafeCluster();
                    long dtTime = cluster.getTimeMillis();
                    Member member = cluster.getLocalMember();
                    aasReplace = new String[][]{{"{Date}", String.valueOf(new Date(Base.getSafeTimeMillis()))}, {"{date}", String.valueOf(new Date(dtTime))}, {"{random}", String.valueOf(Base.getRandom().nextInt())}, {"{result}", String.valueOf(((ThreadLocal)this.get_Sink()).get())}, {"{time}", String.valueOf(dtTime)}, {"{Member}", String.valueOf(member)}, {"{member}", member == null ? "0" : String.valueOf(member.getId())}};
                }
                catch (Exception e) {
                    // empty catch block
                }
                int iR = 0;
                int cR = aasReplace == null ? 0 : aasReplace.length;
                while (iR < cR) {
                    void asReplace = aasReplace[iR];
                    sParam = Base.replace(sParam, (String)asReplace[0], (String)asReplace[1]);
                    ++iR;
                }
                int ofBegin = sParam.indexOf("{random:");
                if (ofBegin >= 0 && (ofEnd = sParam.indexOf(125, ofBegin)) > ofBegin) {
                    int iMax;
                    String sMax = sParam.substring(ofBegin + "{random:".length(), ofEnd);
                    int ofRnd = sMax.indexOf(44);
                    if (ofRnd >= 0) {
                        int iofRnd = ofRnd;
                        ofRnd = Integer.parseInt(sMax.substring(0, ofRnd));
                        sMax = sMax.substring(iofRnd + 1);
                    }
                    int iRand = (iMax = sMax.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(sMax)) > 0 ? Base.getRandom().nextInt(iMax) : (iMax < 0 ? (int)((double)(-iMax) * Base.getRandom().nextDouble() * Base.getRandom().nextDouble()) : (int)Math.abs((double)Integer.MAX_VALUE * Base.getRandom().nextGaussian()));
                    sParam = Base.replace(sParam, sParam.substring(ofBegin, ofEnd + 1), String.valueOf(iRand + ofRnd));
                }
            }
            if (sParam.startsWith("[")) {
                if (sParam.equals("[null]")) {
                    return null;
                }
                if (sParam.equals("[true]")) {
                    return Boolean.TRUE;
                }
                if (sParam.equals("[false]")) {
                    return Boolean.FALSE;
                }
                if (sParam.endsWith("]")) {
                    sValue = sParam.substring(1, sParam.length() - 1);
                    return sValue.length() == 0 ? ClassHelper.VOID : this.convertArguments(Base.parseDelimitedString(sValue, ','));
                }
            } else {
                if (sParam.startsWith("0x")) {
                    return new Binary(Base.parseHex(sParam));
                }
                if (sParam.endsWith("l")) {
                    try {
                        return Long.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block47;
                    }
                }
                if (sParam.endsWith("f")) {
                    try {
                        return Float.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block47;
                    }
                }
                if (sParam.endsWith("d")) {
                    try {
                        return Double.valueOf(sParam.substring(0, sParam.length() - 1));
                    }
                    catch (NumberFormatException e) {
                        break block47;
                    }
                }
                if (!(sParam.length() == 2) ? false : sParam.charAt(0) == '\\') {
                    return new Character(sParam.charAt(1));
                }
                if (sParam.startsWith(" ")) {
                    return sParam.trim();
                }
                if (Character.isDigit(sParam.charAt(0))) {
                    try {
                        return Integer.valueOf(sParam);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    {
                    }
                }
            }
        }
        return sParam;
    }

    public Object[] convertArguments(String[] asParam) {
        int cParams = asParam == null ? 0 : asParam.length;
        Object[] aoParam = new Object[cParams];
        Class<?> clzUniform = null;
        int i = 0;
        while (i < cParams) {
            String sParam = asParam[i];
            Object oParam = this.convertArgument(sParam);
            Class<?> clzParam = oParam == null ? Coherence.__sm0() : oParam.getClass();
            clzUniform = i == 0 ? clzParam : (clzUniform == clzParam ? clzUniform : null);
            aoParam[i] = oParam;
            if (oParam != sParam) {
                asParam[i] = String.valueOf(oParam);
            }
            ++i;
        }
        if (clzUniform != null) {
            Object[] aoParamTyped = (Object[])Array.newInstance(clzUniform, cParams);
            aoParam = Arrays.copyOf(aoParam, cParams, aoParamTyped.getClass());
        }
        return aoParam;
    }

    protected Object createReader() {
        Object reader;
        try {
            reader = Class.forName("jline.console.ConsoleReader").newInstance();
        }
        catch (Exception e) {
            return new InputStreamReader(System.in);
        }
        try {
            File fileHistory = new File(".coh-history");
            if (fileHistory.exists() ^ true) {
                fileHistory.createNewFile();
            }
            Class<?> clzHistory = Class.forName("jline.console.history.FileHistory");
            Object history = ClassHelper.newInstance(clzHistory, new Object[]{fileHistory});
            ClassHelper.invoke(reader, "setHistory", new Object[]{history});
            ClassHelper.invoke(reader, "setHistoryEnabled", new Object[]{Boolean.TRUE});
            ClassHelper.invoke(reader, "setExpandEvents", new Object[]{Boolean.FALSE});
        }
        catch (Exception e) {
            System.out.println(new StringBuilder(String.valueOf("failed to setup history: ")).append(e).toString());
        }
        return reader;
    }

    public void debugOutput(String message, int severity) {
        Coherence$Logger logger = this.ensureRunningLogger();
        try {
            if (logger.isEnabled(severity)) {
                logger.log(severity, message);
            }
        }
        catch (Throwable error) {
            System.err.println("<Error>: Failed to write a log message");
        }
    }

    public void debugOutput(Throwable e) {
        Coherence$Logger logger = this.ensureRunningLogger();
        try {
            if (logger.isEnabled(Logger.LEVEL_ERROR)) {
                logger.log(Logger.LEVEL_ERROR, e);
            }
        }
        catch (Throwable error) {
            System.err.println("<Error>: Failed to write a log message");
        }
    }

    public static Message displayMessage(ReadBuffer buf, InetSocketAddress addr, ClusterService$SeniorMemberHeartbeat msgPrevHeartbeat) throws IOException {
        Broadcast packet = (Broadcast)Packet.instantiate(buf.getBufferInput(), 0);
        Message msg = new ClusterService().instantiateMessage(packet.getMessageType());
        msg.setDeserializationRequired(true);
        msg.setMessageType(packet.getMessageType());
        msg.setMessagePartCount(1);
        msg.setPacket(0, packet);
        ReadBuffer.BufferInput input = packet.getReadBuffer().getBufferInput();
        msg.readInternal(input);
        msg.read(input);
        ClusterService$SeniorMemberHeartbeat msgCurHeartbeat = msg instanceof ClusterService$SeniorMemberHeartbeat ? (ClusterService$SeniorMemberHeartbeat)msg : null;
        if (!(!(!(msgCurHeartbeat != null) ? false : msgPrevHeartbeat != null) ? false : packet.getFromId() == msgPrevHeartbeat.getPacket(0).getFromId()) ? false : msgCurHeartbeat.getMemberSet().toString().equals(msgPrevHeartbeat.getMemberSet().toString())) {
            long lLastRecvTimestamp = msgCurHeartbeat.getLastReceivedMillis();
            String sLastRecvTimestamp = lLastRecvTimestamp == 0L ? "none" : new Date(lLastRecvTimestamp).toString();
            Base.out(new StringBuilder(String.valueOf("Message \"SeniorMemberHeartbeat\" (no change) LastRecvTimestamp=")).append(sLastRecvTimestamp).toString());
        } else {
            Base.out(msg);
        }
        return msgCurHeartbeat;
    }

    protected void doAggregate(Object[] aoParam, boolean fSilent) {
        InvocableMap.EntryAggregator aggregator;
        NamedCache map = this.getMap();
        int cParams = aoParam.length;
        if (cParams < 2) {
            Component._trace("Aggregator name must be specified");
            return;
        }
        Object oTarget = aoParam[0];
        String sAggregator = (String)aoParam[1];
        Object extractor = null;
        if (cParams > 2) {
            String sMethod = (String)aoParam[2];
            extractor = (sMethod == null ? true : sMethod.equals("none")) ? NullImplementation.getValueExtractor() : (Object)sMethod;
        }
        try {
            Object[] objectArray;
            Class<?> clzAggregator = Class.forName(new StringBuilder(String.valueOf("com.tangosol.util.aggregator.")).append(sAggregator).toString());
            if (extractor == null) {
                objectArray = ClassHelper.VOID;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = extractor;
            }
            aggregator = (InvocableMap.EntryAggregator)ClassHelper.newInstance(clzAggregator, objectArray);
        }
        catch (Throwable e) {
            Coherence.printException(new StringBuilder(String.valueOf("Invalid aggregator format: ")).append(sAggregator).append(" ").append(Coherence.toString(extractor)).append("\n").toString(), e);
            return;
        }
        Object oResult = (oTarget instanceof Filter ? true : oTarget == null) ? map.aggregate((Filter)oTarget, aggregator) : (oTarget instanceof Collection ? map.aggregate((Collection)oTarget, aggregator) : (oTarget.equals("*") ? map.aggregate(map.keySet(), aggregator) : map.aggregate(Collections.singleton(oTarget), aggregator)));
        ((ThreadLocal)this.get_Sink()).set(oResult);
        if (fSilent ^ true) {
            Component._trace(String.valueOf(oResult));
        }
    }

    protected void doBackup(String[] asParam, boolean fSilent) {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        NamedCache map = this.getMap();
        try {
            File file = new File(asParam[0]);
            FileOutputStream streamFile = new FileOutputStream(file);
            DataOutputStream streamData = new DataOutputStream(new BufferedOutputStream(streamFile, 32 * 1024));
            MapBackupHelper.writeMap(streamData, map);
            streamData.close();
            streamFile.close();
            if (fSilent ^ true) {
                Component._trace(new StringBuilder(String.valueOf(map.size())).append(" entries written to ").append(file.getAbsolutePath()).append(" (").append(file.length()).append(" bytes)").toString());
            }
        }
        catch (IOException e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to backup: ")).append(e).toString());
        }
    }

    protected void doBatch(String[] asParam, boolean fSilent) throws InterruptedException {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        String sFile = asParam[0];
        InputStreamReader readerRaw = null;
        try {
            try {
                String sCmd;
                readerRaw = new FileReader(sFile);
                BufferedReader reader = new BufferedReader(readerRaw);
                while (!((sCmd = reader.readLine()) == null)) {
                    if (!(sCmd.length() > 0)) continue;
                    if (fSilent ^ true) {
                        Component._trace(new StringBuilder(String.valueOf(">>> ")).append(sCmd).toString());
                    }
                    if (!(sCmd.startsWith("//") ^ true)) continue;
                    this.processCommand(sCmd);
                }
            }
            catch (IOException e) {
                Component._trace(new StringBuilder(String.valueOf("Failed to read the batch file: ")).append(e).toString());
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                readerRaw.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            readerRaw.close();
        }
        catch (Exception e) {}
    }

    protected void doBulkPut(String[] asParam, boolean fSilent) {
        if (this.isMapValid() ^ true) {
            return;
        }
        int cIters = 1000;
        int cbData = 1000;
        try {
            cIters = Integer.parseInt(asParam[0]);
            cbData = Integer.parseInt(asParam[1]);
        }
        catch (Exception e) {
            Component._trace(new StringBuilder(String.valueOf("Assuming iterations=")).append(cIters).append(", size=").append(cbData).toString());
        }
        int iFirst = 0;
        String sKey = asParam[2];
        try {
            iFirst = Integer.parseInt(sKey);
            sKey = "{result}";
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int cBatch = 0;
        if (asParam.length > 3) {
            String sBatch = asParam[3];
            if ("all".equals(sBatch)) {
                cBatch = cIters;
            } else if ("async".equals(sBatch)) {
                cBatch = -1;
            } else {
                try {
                    cBatch = Integer.parseInt(sBatch);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        NamedCache cache = this.getMap();
        AsyncNamedCache cacheAsync = null;
        List listFutures = Collections.emptyList();
        if (cBatch < 0) {
            cacheAsync = cache.async();
            listFutures = new ArrayList();
        }
        cBatch = Math.abs(cBatch);
        if (cIters < 0) {
            cIters = -cIters;
            iFirst -= cIters - 1;
        }
        if (fSilent ^ true) {
            Component._trace(new StringBuilder(String.valueOf(new Date())).append(": adding ").append(cIters).append(" items (starting with #").append(iFirst).append(") each ").append(cbData).append(" bytes ...").toString());
        }
        int nOrigin = 0;
        try {
            nOrigin = this.getService().getCluster().getLocalMember().getId();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HashMap<Object, byte[]> mapBatch = cBatch > 0 ? new HashMap<Object, byte[]>(cBatch) : null;
        Random random = new Random();
        ThreadLocal tlSink = (ThreadLocal)this.get_Sink();
        Object oResult = tlSink.get();
        long lBegin = Base.getSafeTimeMillis();
        int i = iFirst;
        int iLast = iFirst + cIters;
        int cB = 0;
        while (i < iLast) {
            Object oVal;
            Object oKey;
            tlSink.set(i);
            if (cbData > 0) {
                byte[] ab = new byte[cbData];
                ab[0] = (byte)random.nextInt();
                oKey = this.convertArgument(sKey);
                oVal = ab;
            } else {
                Coherence$CacheItem item = new Coherence$CacheItem();
                item.setIndex(i);
                item.setOrigin(nOrigin);
                oKey = cbData < 0 ? (Object)item : this.convertArgument(sKey);
                oVal = item;
            }
            if (cBatch > 0) {
                mapBatch.put(oKey, (byte[])oVal);
                if (++cB == cBatch ? true : i + 1 == iLast) {
                    if (cacheAsync == null) {
                        cache.putAll(mapBatch);
                    } else {
                        listFutures.add(cacheAsync.putAll(mapBatch));
                    }
                    mapBatch.clear();
                    cB = 0;
                }
            } else {
                cache.put(oKey, oVal);
            }
            ++i;
        }
        tlSink.set(oResult);
        if (fSilent ^ true) {
            if (listFutures.isEmpty() ^ true) {
                try {
                    CompletableFuture.allOf((CompletableFuture[])listFutures.toArray()).get();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            long lElapsed = Base.getSafeTimeMillis() - lBegin;
            if (cbData == 0) {
                cbData = 480;
            }
            double dThrouK = (double)cIters * (double)(cbData += 4) / (double)lElapsed;
            double dThrouI = (double)cIters * (double)1000 / (double)lElapsed;
            Component._trace(new StringBuilder(String.valueOf(new Date())).append(": done putting (").append(lElapsed).append("ms, ").append((int)dThrouK).append("KB/sec, ").append((int)dThrouI).append(" items/sec)").toString());
        }
    }

    protected void doBulkRemove(String[] asParam, boolean fSilent) {
        if (this.isMapValid() ^ true) {
            return;
        }
        int cIters = 1000;
        try {
            cIters = Integer.parseInt(asParam[0]);
        }
        catch (Exception e) {
            Component._trace(new StringBuilder(String.valueOf("Assuming iterations=")).append(cIters).toString());
        }
        int iFirst = 0;
        String sKey = asParam[2];
        try {
            iFirst = Integer.parseInt(sKey);
            sKey = "{result}";
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int cBatch = 0;
        if (asParam.length > 3) {
            String sBatch = asParam[3];
            if ("all".equals(sBatch)) {
                cBatch = cIters;
            } else {
                try {
                    cBatch = Integer.parseInt(sBatch);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (cIters < 0) {
            cIters = -cIters;
            iFirst -= cIters - 1;
        }
        if (fSilent ^ true) {
            Component._trace(new StringBuilder(String.valueOf(new Date())).append(": removing ").append(cIters).append(" items (starting with #").append(iFirst).append(")").toString());
        }
        boolean fResult = false;
        Set setAll = this.getMap().keySet();
        HashSet<Object> setBatch = cBatch > 0 ? new HashSet<Object>() : null;
        long lBegin = Base.getSafeTimeMillis();
        ThreadLocal tlSink = (ThreadLocal)this.get_Sink();
        Object oResult = tlSink.get();
        int i = iFirst;
        int iLast = iFirst + cIters;
        int cB = 0;
        while (i < iLast) {
            tlSink.set(i);
            Object oKey = this.convertArgument(sKey);
            if (cBatch > 0) {
                setBatch.add(oKey);
                if (cB++ == cBatch) {
                    fResult |= setAll.removeAll(setBatch);
                    setBatch.clear();
                    cB = 0;
                }
            } else {
                fResult |= setAll.remove(oKey);
            }
            ++i;
        }
        if (!(cBatch > 1) ? false : setBatch.isEmpty() ^ true) {
            fResult |= setAll.removeAll(setBatch);
        }
        tlSink.set(oResult);
        long lElapsed = Base.getSafeTimeMillis() - lBegin;
        if (fSilent ^ true) {
            Component._trace(new StringBuilder(String.valueOf(new Date())).append(": done removing; ").append("result=").append(fResult).append(" (").append(lElapsed).append("ms)").toString());
        }
    }

    protected void doCache(String[] asParam, boolean fSilent) {
        boolean fCQC;
        ConfigurableCacheFactory factory = CacheFactory.getConfigurableCacheFactory();
        String sName = asParam[0];
        boolean fUnique = !(asParam.length > 1) ? false : asParam[1].equals("unique");
        boolean fBinary = !(asParam.length > 1) ? false : asParam[1].equals("binary");
        boolean bl = fCQC = !(asParam.length > 1) ? false : this.getFilters().containsKey(asParam[1]);
        ClassLoader loader = fUnique ? this.getUniqueClassLoader() : (fBinary ? NullImplementation.getClassLoader() : null);
        NamedCache cache = CacheFactory.getCache(sName, loader);
        String sPrompt = cache.getCacheName();
        if (fCQC) {
            cache = new ContinuousQueryCache(cache, (Filter)this.getFilters().get(asParam[1]));
            sPrompt = new StringBuilder(String.valueOf("CQC-")).append(sPrompt).toString();
        }
        this.getLogger().setPrompt(sPrompt);
        this.setService(cache.getCacheService());
        this.setMap(cache);
        if (fSilent ^ true) {
            if (factory instanceof DefaultConfigurableCacheFactory) {
                DefaultConfigurableCacheFactory dccf = (DefaultConfigurableCacheFactory)factory;
                DefaultConfigurableCacheFactory.CacheInfo info = dccf.findSchemeMapping(sName);
                Component._trace(String.valueOf(dccf.resolveScheme(info)));
            } else if (factory instanceof ExtensibleConfigurableCacheFactory) {
                ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)factory;
                Component._trace(AccessController.doPrivileged(new ObjectFormatter().asPrivilegedAction(new StringBuilder(String.valueOf("Cache Configuration: ")).append(sName).toString(), eccf.getCacheConfig().findSchemeByCacheName(sName), eccf.getParameterResolver(sName, null, null))));
            }
        }
    }

    protected void doCacheFactory(String[] asParam, boolean fSilent) {
        ConfigurableCacheFactory factory;
        int cParams = asParam.length;
        switch (cParams) {
            case 2: {
                System.setProperty("scope-name", asParam[1]);
            }
            case 1: {
                factory = CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(asParam[0], Base.getContextClassLoader());
                CacheFactory.setConfigurableCacheFactory(factory);
            }
        }
        if (fSilent ^ true) {
            factory = CacheFactory.getConfigurableCacheFactory();
            XmlElement xmlConfig = null;
            if (factory instanceof DefaultConfigurableCacheFactory) {
                xmlConfig = ((DefaultConfigurableCacheFactory)factory).getConfig();
            } else if (factory instanceof ExtensibleConfigurableCacheFactory) {
                xmlConfig = (XmlElement)((ExtensibleConfigurableCacheFactory)factory).getResourceRegistry().getResource(Coherence.__sm1(), "legacy-cache-config");
            }
            if (xmlConfig != null) {
                Component._trace(xmlConfig.getSafeElement("caching-scheme-mapping").toString());
            }
        }
    }

    protected void doConnector(String[] asParam, boolean fSilent) throws InterruptedException {
        int cParams = asParam.length;
        if (cParams == 0) {
            Component._trace("Command: connector (listener | publisher) [(unicast | multicast | p2p <ip:port> | member <id> | *) [on | off | drop <drop ratio> | pause <pause ratio> | delay <delay>]]");
            return;
        }
        com.tangosol.coherence.component.net.Member member = null;
        HashSet<InetSocketAddress> setAddr = null;
        int CHANNEL_ADV = 1;
        int CHANNEL_PREF = 2;
        int CHANNEL_BROAD_UDP = 4;
        int CHANNEL_BROAD_TCP = 8;
        int CHANNEL_MULTI = 16;
        int nChannels = CHANNEL_MULTI | CHANNEL_ADV | CHANNEL_PREF | CHANNEL_BROAD_UDP | CHANNEL_BROAD_TCP;
        if (cParams >= 2) {
            char chParam = asParam[1].charAt(0);
            switch (chParam) {
                case 'u': {
                    nChannels = CHANNEL_ADV | CHANNEL_PREF | CHANNEL_BROAD_UDP | CHANNEL_BROAD_TCP;
                    break;
                }
                case 'm': {
                    if (asParam[1].startsWith("mu")) {
                        nChannels = CHANNEL_MULTI;
                        break;
                    }
                    try {
                        int nMember = Integer.parseInt(asParam[2]);
                        Cluster cluster = Coherence.getSafeCluster().getCluster();
                        member = ((MemberSet)cluster.getMemberSet()).getMember(nMember);
                        setAddr = new HashSet();
                        setAddr.add(member.getSocketAddress());
                        break;
                    }
                    catch (Exception e) {
                        Component._trace(e);
                        return;
                    }
                }
                case 'p': {
                    setAddr = new HashSet<InetSocketAddress>();
                    int i = 2;
                    while (i < cParams) {
                        String sParam = asParam[i];
                        if (sParam.endsWith(",")) {
                            sParam = sParam.substring(0, sParam.length() - 1);
                        } else {
                            i = cParams;
                        }
                        try {
                            int iColon = sParam.indexOf(58);
                            if (iColon == -1) {
                                Component._trace("address must include port");
                                return;
                            }
                            InetAddress ipAddr = iColon == 0 ? InetAddress.getLocalHost() : InetAddress.getByName(sParam.substring(0, iColon));
                            int nPort = Integer.parseInt(sParam.substring(iColon + 1));
                            setAddr.add(new InetSocketAddress(ipAddr, nPort));
                        }
                        catch (Exception e) {
                            Component._trace(e);
                            return;
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        int cAddr = setAddr == null ? 0 : setAddr.size();
        float flRate = -1.0f;
        boolean fPause = false;
        boolean fDelay = false;
        if (cParams >= cAddr + 3) {
            String sRate = asParam[cAddr + 2];
            float f = sRate.equals("off") ? 1.0f : (sRate.equals("on") ? 0.0f : ((sRate.equals("drop") ? true : sRate.equals("pause")) ? (cParams >= cAddr + 4 ? Float.parseFloat(asParam[cAddr + 3]) : -1.0f) : (flRate = sRate.equals("delay") ? 0.0f : -1.0f)));
            fPause = !(!sRate.equals("pause") ? false : flRate > 0.0f) ? false : flRate < 1.0f;
            fDelay = sRate.equals("delay");
            if (flRate < 0.0f ? true : flRate > 1.0f) {
                Component._trace("Ratio should be within [0.0, 1.0] interval");
                return;
            }
        }
        if (!fDelay ? false : member != null) {
            Cluster cluster = Coherence.getSafeCluster().getCluster();
            long nDelay = Base.parseTime(asParam[cAddr + 3]);
            int nResendDelay = cluster.getDependencies().getPublisherResendDelayMillis();
            int nDropCount = (int)Math.ceil((float)nDelay / (float)nResendDelay);
            Component._trace(new StringBuilder(String.valueOf("Each packet sent to member ")).append(member).append(" will be dropped ").append(nDropCount).append(" times.").toString());
            member.setTxDebugDropCount(nDropCount);
            return;
        }
        long lPause = (long)((float)10000 * flRate);
        int iDropRate = fPause ? 100000 : (int)(flRate * (float)100000);
        while (true) {
            int nChannel = CHANNEL_ADV;
            while (nChannel <= CHANNEL_MULTI) {
                if ((nChannels & nChannel) != 0) {
                    boolean fTx;
                    String sDirection;
                    String sTarget = new StringBuilder(String.valueOf(this.getMap() == null ? "&" : "&getCacheService.getService.")).append("getCluster").toString();
                    if (asParam[0].startsWith("l")) {
                        sDirection = "Rx";
                        fTx = false;
                        switch (nChannel) {
                            case 1: {
                                sTarget = new StringBuilder(String.valueOf(sTarget)).append(".getPointListener").toString();
                                break;
                            }
                            case 2: {
                                sTarget = new StringBuilder(String.valueOf(sTarget)).append(".getPreferredListener").toString();
                                break;
                            }
                            case 4: {
                                sTarget = new StringBuilder(String.valueOf(sTarget)).append(".getUdpBroadcastListener").toString();
                                break;
                            }
                            case 8: {
                                sTarget = new StringBuilder(String.valueOf(sTarget)).append(".getTcpBroadcastListener").toString();
                                break;
                            }
                            case 16: {
                                sTarget = new StringBuilder(String.valueOf(sTarget)).append(".getUdpBroadcastListener").toString();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(new StringBuilder(String.valueOf("unknown listener channel ")).append(nChannel).toString());
                            }
                        }
                        sTarget = new StringBuilder(String.valueOf(sTarget)).append(".getUdpSocket").toString();
                    } else {
                        sDirection = "Tx";
                        fTx = true;
                        sTarget = new StringBuilder(String.valueOf(sTarget)).append(new StringBuilder(String.valueOf(".getPublisher")).append(nChannel == CHANNEL_MULTI ? ".getUdpSocketMulticast" : ".getUdpSocketUnicast").toString()).toString();
                    }
                    if (flRate == -1.0f) {
                        this.processCommand(sTarget);
                    } else {
                        UdpSocket socket = (UdpSocket)this.processCommand(new StringBuilder(String.valueOf('@')).append(sTarget).toString());
                        if (socket != null) {
                            if (fTx) {
                                socket.setTxDebugDropAddresses(setAddr);
                            } else {
                                socket.setRxDebugDropAddresses(setAddr);
                            }
                        }
                        this.processCommand(new StringBuilder(String.valueOf('@')).append(sTarget).append(".set").append(sDirection).append("DebugDropRate ").append(iDropRate).toString());
                    }
                }
                nChannel <<= 1;
            }
            if (!fPause) break;
            ((ThreadLocal)this.get_Sink()).set(null);
            Blocking.sleep(lPause);
            lPause = (long)10000 - lPause;
            iDropRate = Math.abs(iDropRate - 100000);
        }
    }

    protected void doExplain(String[] asParam, boolean fSilent) {
        String sFilter = asParam[0];
        boolean fTrace = !(asParam.length > 1) ? false : asParam[1].equals("trace");
        Filter filter = (Filter)this.getFilters().get(sFilter);
        if (filter != null) {
            QueryRecorder recorder = new QueryRecorder(fTrace ? QueryRecorder.RecordType.TRACE : QueryRecorder.RecordType.EXPLAIN);
            Object oResult = this.getMap().aggregate(filter, recorder);
            if (fSilent ^ true) {
                Component._trace(String.valueOf(oResult));
            }
        }
    }

    protected void doFilter(Object[] aoParam, boolean fSilent) {
        Map mapFilter = this.getFilters();
        int cParams = aoParam.length;
        String sFilterName = (String)aoParam[0];
        String sFilterType = (String)aoParam[1];
        Object[] aoFilterParam = new Object[cParams - 2];
        try {
            int i = 2;
            while (i < cParams) {
                Object oParam = aoParam[i];
                String sParam = String.valueOf(oParam);
                Filter filter = (Filter)mapFilter.get(sParam);
                if (filter != null) {
                    oParam = filter;
                } else if (sParam.equals(".")) {
                    oParam = IdentityExtractor.INSTANCE;
                } else if (sParam.startsWith("!")) {
                    oParam = this.convertArgument(sParam.substring(1));
                    oParam = oParam == null ? new KeyExtractor(null) : new KeyExtractor((String)oParam);
                } else if (!sFilterType.equals("Partitioned") ? false : oParam instanceof Integer) {
                    DistributedCacheService service = (DistributedCacheService)this.getMap().getCacheService();
                    PartitionSet parts = new PartitionSet(service.getPartitionCount());
                    parts.add((Integer)oParam);
                    oParam = parts;
                }
                aoFilterParam[i - 2] = oParam;
                ++i;
            }
            if (sFilterType.equals("All") ? true : sFilterType.equals("Any")) {
                int cFilters = aoFilterParam.length;
                Filter[] aFilter = new Filter[cFilters];
                System.arraycopy(aoFilterParam, 0, aFilter, 0, cFilters);
                aoFilterParam = new Object[]{aFilter};
            }
            Class<?> clzFilter = Class.forName(new StringBuilder(String.valueOf("com.tangosol.util.filter.")).append(sFilterType).append("Filter").toString());
            Filter filter = (Filter)ClassHelper.newInstance(clzFilter, aoFilterParam);
            mapFilter.put(sFilterName, filter);
            if (fSilent ^ true) {
                Component._trace(String.valueOf(filter));
            }
        }
        catch (Throwable e) {
            Coherence.printException("Invalid filter format: ", e);
        }
    }

    protected Object doFunction(String sFunction, Object[] aoParam, boolean fSilent) {
        Object oTarget = null;
        boolean fSetTarget = true;
        if (sFunction.startsWith("&&") ? true : sFunction.startsWith("&!")) {
            fSetTarget = sFunction.startsWith("&&");
            sFunction = sFunction.substring(2);
            oTarget = ((ThreadLocal)this.get_Sink()).get();
        } else if (sFunction.startsWith("&/")) {
            try {
                String sClass = sFunction.substring(2);
                int ofClz = sClass.indexOf(46);
                sFunction = sClass.substring(ofClz + 1);
                sClass = sClass.substring(0, ofClz).replace('/', '.');
                try {
                    oTarget = Class.forName(sClass);
                }
                catch (ClassNotFoundException e) {
                    oTarget = Class.forName(new StringBuilder(String.valueOf("java.lang.")).append(sClass).toString());
                }
            }
            catch (Exception e) {
                Component._trace(new StringBuilder(String.valueOf("Invalid format: ")).append(e).toString());
                return e;
            }
        } else if (sFunction.startsWith("&{")) {
            int ofTarget = sFunction.indexOf(125);
            if (ofTarget > 0) {
                oTarget = this.convertArgument(sFunction.substring(1, ++ofTarget));
                if (!(sFunction.length() > ofTarget) ? false : sFunction.charAt(ofTarget) == '.') {
                    ++ofTarget;
                }
                sFunction = sFunction.substring(ofTarget);
            }
        } else if (sFunction.startsWith("&~")) {
            sFunction = sFunction.substring(2);
            oTarget = this;
        } else {
            sFunction = sFunction.substring(1);
            oTarget = this.getMap();
            if (oTarget == null) {
                oTarget = Coherence.getSafeCluster();
            }
        }
        if (sFunction.length() > 0) {
            oTarget = Coherence.processFunction(oTarget, sFunction, fSilent, aoParam);
        } else {
            Coherence.processFunction(oTarget, "toString", fSilent, aoParam);
        }
        if (fSetTarget) {
            ((ThreadLocal)this.get_Sink()).set(oTarget);
        }
        return oTarget;
    }

    protected void doHistory(String[] asParam, boolean fSilent) throws InterruptedException {
        List listCommands = this.getCommandHistory();
        String sPattern = null;
        int nLimit = -1;
        switch (asParam.length) {
            case 0: {
                break;
            }
            case 1: {
                if (asParam[0].equals("clear")) {
                    if (listCommands != null) {
                        listCommands.clear();
                    }
                    return;
                }
                if (asParam[0].equals("on")) {
                    if (listCommands == null) {
                        this.setCommandHistory(new LinkedList());
                    }
                    return;
                }
                if (asParam[0].equals("off")) {
                    this.setCommandHistory(null);
                    return;
                }
                try {
                    nLimit = Integer.parseInt(asParam[0]);
                }
                catch (NumberFormatException e) {
                    sPattern = asParam[0];
                }
                break;
            }
            case 2: {
                sPattern = asParam[0];
                nLimit = Integer.parseInt(asParam[1]);
                break;
            }
            default: {
                Component._trace("history ([<pattern>] [<limit>]) | (['on' | 'off' | 'clear'])");
                return;
            }
        }
        if (fSilent ? true : listCommands == null) {
            return;
        }
        if (nLimit < 0) {
            nLimit = Integer.MAX_VALUE;
        }
        int cCommands = listCommands.size();
        if (sPattern == null) {
            int iCmd = Math.max(0, cCommands - nLimit);
            ListIterator iter = listCommands.listIterator(iCmd);
            while (iter.hasNext()) {
                Component._trace(new StringBuilder(String.valueOf("  ")).append(++iCmd).append("  ").append(iter.next()).toString());
            }
        } else {
            LinkedList<String> listOut = new LinkedList<String>();
            int cMatches = 0;
            int iCmd = cCommands;
            HashSet<String> setMatch = new HashSet<String>();
            Iterator iter = listCommands.listIterator(cCommands);
            while (!iter.hasPrevious() ? false : cMatches < nLimit) {
                String sCmd = (String)iter.previous();
                if ((sCmd.startsWith(sPattern) ? true : sCmd.matches(sPattern)) && setMatch.contains(sCmd) ^ true) {
                    setMatch.add(sCmd);
                    listOut.add(0, new StringBuilder(String.valueOf("  ")).append(iCmd).append("  ").append(sCmd).toString());
                    ++cMatches;
                }
                --iCmd;
            }
            iter = listOut.iterator();
            while (iter.hasNext()) {
                Component._trace((String)iter.next());
            }
        }
        Component._trace("\nenter !<index> to reissue a command");
    }

    protected void doIndex(String[] asParam, boolean fSilent) {
        AbstractExtractor extractor;
        boolean fFwd;
        String sMethod = asParam[0];
        boolean fRemove = !(asParam.length > 1) ? false : asParam[1].equals("remove");
        Filter filter = asParam.length > 2 ? (Filter)this.getFilters().get(asParam[2]) : null;
        boolean bl = fFwd = !(asParam.length > 3) ? false : Boolean.getBoolean(asParam[3]);
        if (sMethod.startsWith("!")) {
            extractor = new KeyExtractor(sMethod.substring(1));
        } else {
            ValueExtractor<Object, Object> valueExtractor = sMethod.equals(".") ? IdentityExtractor.INSTANCE : (extractor = sMethod.equals("~") ? new DeserializationAccelerator() : (sMethod.indexOf(46) < 0 ? (ValueExtractor)new ReflectionExtractor(sMethod) : new ChainedExtractor(sMethod)));
        }
        if (filter != null) {
            extractor = new ConditionalExtractor(filter, extractor, fFwd);
        }
        if (fRemove) {
            this.getMap().removeIndex(extractor);
        } else {
            this.getMap().addIndex(extractor, true, new SafeComparator(null));
        }
    }

    protected void doInvoke(String sService, String[] asParam, boolean fSilent) {
        InvocationService srvc;
        block18: {
            try {
                srvc = (InvocationService)CacheFactory.getService(sService);
            }
            catch (IllegalArgumentException e) {
                srvc = (InvocationService)Coherence.getCluster().getService(sService);
                if (!(srvc == null)) break block18;
                throw e;
            }
        }
        int cParams = asParam.length;
        if (cParams == 0) {
            return;
        }
        String sCommand = asParam[0];
        String sTarget = cParams >= 2 ? asParam[1] : "all";
        boolean fAsync = !(cParams >= 3) ? false : asParam[2].startsWith("a");
        int iPriority = cParams >= 4 ? Integer.parseInt(asParam[3]) : 0;
        long cTimeout = cParams >= 5 ? Long.parseLong(asParam[4]) : 0L;
        Coherence$CacheItem task = new Coherence$CacheItem();
        task.setInvokeCommand(sCommand);
        task.setSchedulingPriority(iPriority);
        task.setExecutionTimeoutMillis(cTimeout);
        Set setMember = null;
        if (sTarget.equals("all") ^ true) {
            setMember = srvc.getInfo().getServiceMembers();
            if (sTarget.equals("other")) {
                setMember.remove(Coherence.getSafeCluster().getLocalMember());
            } else if (sTarget.equals("senior")) {
                setMember.clear();
                setMember.add(srvc.getInfo().getOldestMember());
            } else {
                setMember.clear();
                Set setAll = srvc.getInfo().getServiceMembers();
                try {
                    int nMember = Integer.parseInt(sTarget);
                    Iterator iter = setAll.iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        if (!(member.getId() == nMember)) continue;
                        setMember.add(member);
                        break;
                    }
                }
                catch (NumberFormatException e) {
                    Component._trace(new StringBuilder(String.valueOf("Unknown target: ")).append(sTarget).toString());
                    return;
                }
            }
        }
        if (fAsync) {
            srvc.execute(task, setMember, fSilent ? null : (Coherence$Worker)this._newChild("Worker"));
        } else {
            TreeMap mapResult = srvc.query(task, setMember);
            if (fSilent ^ true) {
                if (mapResult.isEmpty()) {
                    Component._trace("No results");
                } else {
                    if (mapResult.size() > 1) {
                        mapResult = new TreeMap(mapResult);
                    }
                    Iterator iter = mapResult.keySet().iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        Object oResult = mapResult.get(member);
                        Component._trace(new StringBuilder(String.valueOf("Member ")).append(member == null ? "Proxy" : String.valueOf(member.getId())).append(", Result=").append(oResult instanceof Throwable ? new StringBuilder(String.valueOf(oResult)).append("\n").append(Component.getStackTrace((Throwable)oResult)).toString() : String.valueOf(oResult)).toString());
                    }
                }
            }
        }
    }

    protected void doJmx(String[] asParam) {
        String sName;
        int cParams = asParam.length;
        int nPort = 8082;
        String sUrl = "";
        try {
            if (cParams > 0) {
                nPort = Integer.parseInt(asParam[0]);
            }
        }
        catch (NumberFormatException e) {
            sUrl = asParam[0];
        }
        boolean fStart = cParams <= 1 ? true : asParam[1].equals("stop") ^ true;
        String string = sName = sUrl.length() == 0 ? "Adapter" : "Connector";
        if (fStart) {
            Component wrapper = this._findChild(sName);
            if (wrapper != null) {
                Component._trace(new StringBuilder(String.valueOf("Already started: ")).append(wrapper).toString());
                return;
            }
            try {
                wrapper = sUrl.length() == 0 ? new HttpAdapter() : new ServerConnector();
            }
            catch (NoClassDefFoundError e) {
                Component._trace("JMX library is not on a classpath; only remote management is allowed");
                return;
            }
            try {
                if (wrapper instanceof HttpAdapter) {
                    ((HttpAdapter)wrapper).start(nPort, Coherence.getSafeCluster());
                } else {
                    ((ServerConnector)wrapper).start(sUrl, Coherence.getSafeCluster());
                }
            }
            catch (RuntimeException e) {
                if (cParams > 1) {
                    Component._trace(e);
                } else {
                    Component._trace(e.getMessage());
                }
                return;
            }
            this._addChild(wrapper, sName);
            ((ThreadLocal)this.get_Sink()).set(wrapper);
            Component._trace(new StringBuilder(String.valueOf("Installed: ")).append(wrapper).toString());
        } else {
            Component wrapper = this._findChild(sName);
            if (wrapper != null) {
                if (wrapper instanceof HttpAdapter) {
                    ((HttpAdapter)wrapper).stop();
                } else {
                    ((ServerConnector)wrapper).stop();
                }
                this._removeChild(wrapper);
            }
        }
    }

    protected void doList(String[] asParam, boolean fSilent) {
        Set setEntry;
        NamedCache map = this.getMap();
        int cParams = asParam.length;
        if (cParams > 0) {
            String sName = asParam[0];
            if (this.getFilters().containsKey(sName)) {
                Comparator comparator = null;
                int nPage = -1;
                if (cParams > 1) {
                    String[] asMethod = Base.parseDelimitedString(asParam[1], ',');
                    int cMethods = asMethod.length;
                    if (cMethods > 1) {
                        Comparator[] acomp = new Comparator[cMethods];
                        int i = 0;
                        while (i < cMethods) {
                            String sMethod = asMethod[i];
                            acomp[i] = sMethod.startsWith("!") ? (Comparator)new KeyExtractor(sMethod.substring(1)) : new ReflectionExtractor(sMethod);
                            ++i;
                        }
                        comparator = new ChainedComparator(acomp);
                    } else {
                        String sMethod;
                        comparator = asMethod[0].equals("null") ? new SafeComparator(null) : ((sMethod = asMethod[0]).startsWith("!") ? (Comparator)new KeyExtractor(sMethod.substring(1)) : new ReflectionExtractor(sMethod));
                    }
                    if (!(cParams > 2) ? false : asParam[2].startsWith("desc")) {
                        comparator = new InverseComparator(comparator);
                    }
                    if (cParams > 3) {
                        nPage = Integer.parseInt(asParam[3]);
                    }
                }
                setEntry = this.applyFilter(sName, false, comparator, nPage);
            } else {
                map = this.getService().ensureCache(sName, null);
                setEntry = map.entrySet();
            }
        } else {
            setEntry = map.entrySet();
        }
        int cSize = setEntry.size();
        int cLimit = Math.min(cSize, 50);
        int c = 0;
        Iterator iter = setEntry.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(!(c++ < cLimit) ? false : fSilent ^ true)) continue;
            Component._trace(new StringBuilder(String.valueOf(entry.getKey())).append(" = ").append(entry.getValue()).toString());
        }
        if (!(cLimit < cSize) ? false : fSilent ^ true) {
            Component._trace(new StringBuilder(String.valueOf("Only ")).append(cLimit).append(" out of total ").append(cSize).append(" items were printed").toString());
        }
        if (c != cSize) {
            Component._trace(new StringBuilder(String.valueOf("Iterator returned ")).append(c).append(" items").toString());
        }
        ((ThreadLocal)this.get_Sink()).set(setEntry);
    }

    protected void doListen(String sSource, boolean fStop, Filter filter, Object oKey, boolean fLite) {
        NamedCache map = this.getMap();
        CacheService service = map.getCacheService();
        ObservableMap mapListen = map;
        if (sSource.equals("local")) {
            BackingMapManager mgr = service.getBackingMapManager();
            if (mgr == null) {
                Component._trace(new StringBuilder(String.valueOf("Service ")).append(service.getInfo().getServiceName()).append(" does not have BackingMapManager;").append(" use coherence-cache-config.xml and 'cache' command to create a cache").toString());
                return;
            }
            String sCacheName = map.getCacheName();
            try {
                mapListen = (ObservableMap)ClassHelper.invoke(mgr, "getBackingMap", new Object[]{sCacheName});
            }
            catch (ClassCastException e) {
                Component._trace(new StringBuilder(String.valueOf("Local storage for cache: ")).append(sCacheName).append(" is not observable;").append(" use coherence-cache-config.xml to configure").toString());
                return;
            }
            catch (Exception e) {
                Component._trace(new StringBuilder(String.valueOf("Service ")).append(service.getInfo().getServiceName()).append(" uses unsupported BackingMapManager: ").append(mgr.getClass().getName()).toString());
                return;
            }
            if (mapListen == null) {
                Component._trace(new StringBuilder(String.valueOf("Local storage for cache: ")).append(sCacheName).append(" is missing").toString());
                return;
            }
        }
        String sWorker = new StringBuilder(String.valueOf("Worker!")).append(sSource).toString();
        Coherence$Worker worker = (Coherence$Worker)this._findChild(sWorker);
        if (fStop) {
            if (sSource.startsWith("trigger")) {
                int nAction = sSource.endsWith("remove") ? FilterTrigger.ACTION_REMOVE : (sSource.endsWith("ignore") ? FilterTrigger.ACTION_IGNORE : FilterTrigger.ACTION_ROLLBACK);
                mapListen.removeMapListener(new MapTriggerListener(new FilterTrigger(filter, nAction)));
            } else if (worker == null) {
                Component._trace("No listener to stop");
            } else {
                if (sSource.equals("members")) {
                    service.removeMemberListener(worker);
                } else if (sSource.equals("master")) {
                    service.getCluster().ensureService("Cluster", "Cluster").removeMemberListener(worker);
                } else if (sSource.equals("service")) {
                    service.removeServiceListener(worker);
                } else if (sSource.equals("partition")) {
                    ((PartitionedService)((Object)service)).removePartitionListener(worker);
                } else if (sSource.equals("interceptor")) {
                    CacheFactory.getConfigurableCacheFactory().getInterceptorRegistry().unregisterEventInterceptor(worker.getInterceptorId());
                } else {
                    MapListener listener = worker;
                    if (sSource.endsWith("-sync")) {
                        listener = new MapListenerSupport.WrapperSynchronousListener(listener);
                    }
                    if (oKey == null) {
                        mapListen.removeMapListener(listener, filter);
                    } else if (oKey instanceof Set) {
                        mapListen.removeMapListener(listener, new InKeySetFilter(null, (Set)oKey));
                    } else {
                        mapListen.removeMapListener(listener, oKey);
                    }
                }
                int cRefCount = worker.getRefCount() - 1;
                if (cRefCount == 0) {
                    this._removeChild(worker);
                } else {
                    worker.setRefCount(cRefCount);
                }
            }
        } else if (sSource.startsWith("trigger")) {
            int nAction = sSource.endsWith("remove") ? FilterTrigger.ACTION_REMOVE : (sSource.endsWith("ignore") ? FilterTrigger.ACTION_IGNORE : FilterTrigger.ACTION_ROLLBACK);
            mapListen.addMapListener(new MapTriggerListener(new FilterTrigger(filter, nAction)));
        } else {
            if (worker == null) {
                worker = new Coherence$Worker();
                this._addChild(worker, sWorker);
                if (sSource.charAt(0) == '@') {
                    worker.setSilent(true);
                }
            }
            if (sSource.equals("members")) {
                service.addMemberListener(worker);
            } else if (sSource.equals("master")) {
                service.getCluster().ensureService("Cluster", "Cluster").addMemberListener(worker);
            } else if (sSource.equals("service")) {
                service.addServiceListener(worker);
            } else if (sSource.equals("partition")) {
                ((PartitionedService)((Object)service)).addPartitionListener(worker);
            } else if (sSource.equals("interceptor")) {
                if (oKey instanceof String) {
                    worker.setEventTypes(new ImmutableArrayList(((String)oKey).split(",")));
                }
                String sId = CacheFactory.getConfigurableCacheFactory().getInterceptorRegistry().registerEventInterceptor(worker);
                worker.setInterceptorId(sId);
            } else {
                MapListener listener = worker;
                if (sSource.endsWith("-sync")) {
                    listener = new MapListenerSupport.WrapperSynchronousListener(listener);
                }
                if (oKey == null) {
                    mapListen.addMapListener(listener, filter, fLite);
                } else if (oKey instanceof Set) {
                    mapListen.addMapListener(listener, new InKeySetFilter(null, (Set)oKey), fLite);
                } else {
                    mapListen.addMapListener(listener, oKey, fLite);
                }
            }
            worker.setRefCount(worker.getRefCount() + 1);
        }
    }

    protected void doLog(Object[] aoParam, boolean fSilent) {
        int cParams = aoParam.length;
        String sMsg = null;
        int cchMsg = 50;
        if (cParams >= 1) {
            if (aoParam[0] instanceof Number) {
                cchMsg = ((Number)aoParam[0]).intValue();
                cchMsg = Math.max(1, cchMsg);
            } else {
                sMsg = String.valueOf(aoParam[0]);
                cchMsg = sMsg.length();
            }
        }
        if (sMsg == null) {
            sMsg = Base.dup('*', cchMsg);
        }
        int cIters = 1;
        if (!(cParams >= 2) ? false : aoParam[1] instanceof Number) {
            cIters = ((Number)aoParam[1]).intValue();
        }
        cIters = Math.max(1, cIters);
        int nLevel = 3;
        if (!(cParams >= 3) ? false : aoParam[2] instanceof Number) {
            nLevel = ((Number)aoParam[2]).intValue();
        }
        if (fSilent ^ true) {
            Component._trace(new StringBuilder(String.valueOf("Logging ")).append(cIters).append(" messages of ").append(cchMsg).append(" characters at level ").append(nLevel).append(":").toString());
        }
        if (cIters == 1) {
            Component._trace(sMsg, nLevel);
        } else {
            int i = 1;
            while (i <= cIters) {
                Component._trace(new StringBuilder(String.valueOf(i)).append(":").append(sMsg).toString(), nLevel);
                ++i;
            }
        }
    }

    protected void doPersistence(String[] asParam, boolean fSilent) {
        String sOp = asParam[0];
        PersistenceToolsHelper helper = this.getPersistenceToolsHelper();
        String oResult = "Success";
        if (helper == null) {
            helper = new PersistenceToolsHelper();
            this.setPersistenceToolsHelper(helper);
        }
        try {
            if ("force".equals(sOp)) {
                helper.invokeOperation("forceRecovery", asParam[1], null, null);
                return;
            }
            if (this.isMapValid() ^ true) {
                oResult = null;
                return;
            }
            CacheService service = this.getService();
            String sServiceName = service.getInfo().getServiceName();
            String sSnapshotName = null;
            String sOperation = null;
            int cParams = asParam.length;
            if ("list".equals(sOp)) {
                boolean fArchived = !(cParams == 2) ? false : "archived".equals(asParam[1]);
                Component._trace(new StringBuilder(String.valueOf(fArchived ? "Archived s" : "S")).append("napshots for service ").append(sServiceName).toString());
                String[] asSnapshots = fArchived ? helper.listArchivedSnapshots(sServiceName) : helper.listSnapshots(sServiceName);
                if (asSnapshots != null) {
                    int i = 0;
                    while (i < asSnapshots.length) {
                        Component._trace(new StringBuilder(String.valueOf("    ")).append(asSnapshots[i]).toString());
                        ++i;
                    }
                }
                oResult = null;
            } else {
                int i = 1;
                if ("create".equals(sOp)) {
                    sOperation = PersistenceToolsHelper.CREATE_SNAPSHOT;
                } else if ("recover".equals(sOp)) {
                    sOperation = PersistenceToolsHelper.RECOVER_SNAPSHOT;
                } else if ("archive".equals(sOp)) {
                    sOperation = PersistenceToolsHelper.ARCHIVE_SNAPSHOT;
                } else if ("remove".equals(sOp)) {
                    sOperation = cParams == 2 ? PersistenceToolsHelper.REMOVE_SNAPSHOT : ((!(cParams == 3) ? false : "archived".equals(asParam[1])) ? PersistenceToolsHelper.REMOVE_ARCHIVED_SNAPSHOT : null);
                    i = cParams == 3 ? 2 : 1;
                } else if ("retrieve".equals(sOp)) {
                    sOperation = (!(cParams == 3) ? false : "archived".equals(asParam[1])) ? PersistenceToolsHelper.RETRIEVE_ARCHIVED_SNAPSHOT : null;
                    i = 2;
                } else {
                    Component._trace("Invalid persistence/snapshot command");
                    return;
                }
                sSnapshotName = asParam[i];
                if (fSilent ^ true) {
                    Component._trace(new StringBuilder(String.valueOf("Issuing ")).append(sOperation).append(" for service ").append(sServiceName).append(" and snapshot ").append(sSnapshotName).toString());
                }
                helper.invokeOperationWithWait(sOperation, sSnapshotName, sServiceName);
            }
        }
        catch (Exception e) {
            oResult = e.getMessage();
        }
        if (!(fSilent ^ true) ? false : oResult != null) {
            Component._trace(oResult.toString());
        }
        ((ThreadLocal)this.get_Sink()).set(oResult);
    }

    protected void doProcess(Object[] aoParam, boolean fAsync, boolean fSilent) {
        Object oResult;
        InvocableMap.EntryProcessor processor;
        NamedCache map = this.getMap();
        int cParams = aoParam.length;
        if (cParams < 2) {
            Component._trace("Processor name must be specified");
            return;
        }
        int iParam = 0;
        Object oTarget = aoParam[iParam++];
        Filter filter = aoParam[iParam] instanceof Filter ? (Filter)aoParam[iParam++] : null;
        String sProcessor = (String)aoParam[iParam++];
        Object[] aoProcessorParam = new Object[cParams -= iParam];
        if (cParams > 0) {
            System.arraycopy(aoParam, iParam, aoProcessorParam, 0, cParams);
        }
        try {
            Class<?> clzProcessor = Class.forName(new StringBuilder(String.valueOf("com.tangosol.util.processor.")).append(sProcessor).toString());
            processor = (ConditionalProcessor)ClassHelper.newInstance(clzProcessor, aoProcessorParam);
        }
        catch (Throwable e) {
            Coherence.printException(new StringBuilder(String.valueOf("Invalid processor format: ")).append(sProcessor).append(" ").append(Coherence.toString(aoProcessorParam)).append("\n").toString(), e);
            return;
        }
        if (filter != null) {
            processor = new ConditionalProcessor(filter, processor);
        }
        if (fAsync) {
            processor = new AsynchronousProcessor(processor);
        }
        Object object = (oTarget instanceof Filter ? true : oTarget == null) ? map.invokeAll((Filter)oTarget, processor) : (oTarget instanceof Collection ? map.invokeAll((Collection)oTarget, processor) : (oResult = oTarget.equals("*") ? map.invokeAll(map.keySet(), processor) : map.invoke(oTarget, processor)));
        if (fAsync) {
            oResult = processor;
        }
        ((ThreadLocal)this.get_Sink()).set(oResult);
        if (fSilent ^ true) {
            Component._trace(String.valueOf(oResult));
        }
    }

    protected void doReissueCommand(int nCmd, String sRemainder, boolean fSilent) throws InterruptedException {
        List list = this.getCommandHistory();
        if (list == null) {
            Component._trace("history is off");
            return;
        }
        if (nCmd <= 0 ? true : nCmd > list.size()) {
            Component._trace("history index out of range");
            return;
        }
        String sCmd = (String)list.get(nCmd - 1);
        if (!(sRemainder != null) ? false : sRemainder.length() > 0) {
            sCmd = new StringBuilder(String.valueOf(fSilent ? new StringBuilder(String.valueOf("@")).append(sCmd).toString() : sCmd)).append(" ").append(sRemainder).toString();
            this.recordCommand(sCmd);
        } else if (fSilent) {
            sCmd = new StringBuilder(String.valueOf("@")).append(sCmd).toString();
        }
        Component._trace(new StringBuilder(String.valueOf("reissuing: ")).append(sCmd).toString());
        this.processCommand(sCmd);
    }

    protected void doRepeat(String sCmd, int cIter, boolean fForce) throws InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        int cch = sCmd.length();
        int ofPrev = 0;
        while (ofPrev < cch) {
            int ofNext;
            if (sCmd.charAt(ofPrev) == '{') {
                ++ofPrev;
                ofNext = sCmd.lastIndexOf(125);
            } else {
                ofNext = sCmd.indexOf(59, ofPrev);
            }
            if (ofNext < 0) {
                list.add(sCmd.substring(ofPrev));
                break;
            }
            list.add(sCmd.substring(ofPrev, ofNext));
            ofPrev = ofNext + 1;
        }
        int cCmds = list.size();
        String[] asCmd = list.toArray(new String[cCmds]);
        int i = 0;
        block1: while (i < cIter) {
            ((ThreadLocal)this.get_Sink()).set(i);
            int j = 0;
            while (j < cCmds) {
                Object oResult;
                sCmd = asCmd[j].trim();
                if (sCmd.length() > 0 && (oResult = this.processCommand(sCmd)) instanceof Throwable) {
                    if (!fForce) break block1;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void doRestore(String[] asParam, boolean fSilent) {
        if (asParam.length == 0) {
            Component._trace("File name is expected");
            return;
        }
        NamedCache map = this.getMap();
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            File file = new File(asParam[0]);
            FileInputStream streamFile = new FileInputStream(file);
            DataInputStream streamData = new DataInputStream(new BufferedInputStream(streamFile, 32 * 1024));
            int cBlock = Integer.MAX_VALUE;
            if (asParam.length > 1) {
                try {
                    cBlock = Integer.parseInt(asParam[1]);
                    Component._assert(cBlock > 0);
                }
                catch (Exception e) {
                    Component._trace("Invalid block size");
                    return;
                }
            }
            int cEntries = MapBackupHelper.readMap(streamData, map, cBlock, loader);
            if (fSilent ^ true) {
                Component._trace(new StringBuilder(String.valueOf(cEntries)).append(" entries restored from ").append(file.getAbsolutePath()).toString());
            }
            streamData.close();
            streamFile.close();
        }
        catch (IOException e) {
            Component._trace(new StringBuilder(String.valueOf("Failed to restore: ")).append(e).toString());
        }
    }

    protected void doScan(String[] asParam) {
        int iFirst = 1;
        int cIters = 1000;
        try {
            iFirst = Integer.parseInt(asParam[0]);
            cIters = Integer.parseInt(asParam[1]);
        }
        catch (NumberFormatException e) {
            Component._trace(new StringBuilder(String.valueOf("Assuming first=")).append(iFirst).append(", iterations=").append(cIters).toString());
        }
        NamedCache map = this.getMap();
        int iGapStart = 0;
        int iGapEnd = 0;
        int i = iFirst;
        int iLast = iFirst + cIters;
        while (i < iLast) {
            if (map.containsKey(i) ^ true) {
                iGapStart = i;
                iGapEnd = i;
                while (!(++i < iLast) ? false : map.containsKey(i) ^ true) {
                    iGapEnd = i;
                }
                if (iGapStart == iGapEnd) {
                    Component._trace(new StringBuilder(String.valueOf("\nMissing item: ")).append(iGapStart).toString());
                } else {
                    Component._trace(new StringBuilder(String.valueOf("\nMissing items: ")).append(iGapStart).append(" .. ").append(iGapEnd).toString());
                }
            }
            if (!(i > iGapStart + 1000) ? false : i % 1000 == 0) {
                System.out.print(new StringBuilder(String.valueOf("\b\b\b\b\b\b\b")).append(i).toString());
                System.out.flush();
            }
            ++i;
        }
    }

    protected void doScript(String sCmd, boolean fSilent) {
        ScriptEngine engine = this.getScriptEngine();
        NamedCache cache = this.getMap();
        engine.put("cluster", Coherence.getSafeCluster());
        engine.put("service", this.getService());
        engine.put("map", cache);
        if (sCmd.length() == 0) {
            this.setScript(true);
            this.getLogger().setPrompt(new StringBuilder(String.valueOf(this.getLogger().getPrompt())).append(" [script]").toString());
        } else if (sCmd.equals("bye")) {
            this.setScript(false);
            this.getLogger().setPrompt(cache == null ? "?" : cache.getCacheName());
        } else {
            Object oResult;
            String sPrefix = "with (imports) {\n";
            String sPostfix = "\n}\n";
            try {
                oResult = engine.eval(new StringBuilder(String.valueOf(sPrefix)).append(sCmd).append(sPostfix).toString());
            }
            catch (Exception e) {
                oResult = e.getMessage();
                fSilent = false;
            }
            if (fSilent ^ true) {
                Component._trace(Coherence.toString(oResult));
            }
        }
    }

    protected Object doSecure(String[] asParam, boolean fSilent) throws InterruptedException {
        Subject subject;
        PrivilegedAction action;
        int cParams = asParam.length;
        if (cParams < 3) {
            return null;
        }
        String sName = asParam[0];
        char[] acPwd = asParam[1].toCharArray();
        String sCmd = asParam[2];
        int i = 3;
        while (i < cParams) {
            sCmd = new StringBuilder(String.valueOf(sCmd)).append(new StringBuilder(String.valueOf(' ')).append(asParam[i]).toString()).toString();
            ++i;
        }
        boolean fImpersonate = false;
        if (sName.startsWith("hack_")) {
            fImpersonate = true;
            sName = sName.substring("hack_".length());
        }
        try {
            SimpleHandler handler = new SimpleHandler(sName, acPwd);
            action = Security.createPrivilegedAction(this.getClass().getMethod("processCommand", Coherence.__sm2()), this, new Object[]{sCmd});
            subject = (Subject)ClassHelper.invokeStatic(Class.forName("com.tangosol.net.security.Security"), "login", new Object[]{handler});
        }
        catch (Throwable e) {
            Coherence.printException(null, e);
            return null;
        }
        if (fImpersonate) {
            subject = Security.getInstance().impersonate(subject, sName, asParam[0]);
        }
        try {
            return ClassHelper.invokeStatic(Class.forName("com.tangosol.net.security.Security"), "runAs", new Object[]{subject, action});
        }
        catch (Throwable e) {
            Throwable eOrig = e;
            while (true) {
                if (e instanceof WrapperException) {
                    e = ((WrapperException)e).getOriginalException();
                    continue;
                }
                if (!(e instanceof InvocationTargetException)) break;
                e = eOrig = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof AccessControlException) {
                Component._trace(new StringBuilder(String.valueOf("Permission rejected: ")).append(((AccessControlException)e).getPermission()).toString(), 1);
            }
            Component._trace(eOrig);
            return null;
        }
    }

    protected void doServer(String[] asParam) {
        try {
            DefaultCacheServer.startServerDaemon();
        }
        catch (Throwable e) {
            Component._trace(new StringBuilder(String.valueOf("Error in starting DefaultCacheServer: ")).append(e.getMessage()).toString(), 1);
        }
    }

    protected void doTransaction(String sFunction, String[] asParam) {
        if (sFunction.equals("begin")) {
            int nIsolation;
            int nConcur;
            String sConcur = asParam[0];
            String sIsolation = asParam[1];
            int nTimeout = 20;
            try {
                nTimeout = Integer.parseInt(asParam[2]);
            }
            catch (Exception e) {
                // empty catch block
            }
            switch (sConcur.charAt(0)) {
                case 'E': 
                case 'e': {
                    nConcur = TransactionMap.CONCUR_EXTERNAL;
                    break;
                }
                case 'O': 
                case 'o': {
                    nConcur = TransactionMap.CONCUR_OPTIMISTIC;
                    break;
                }
                default: {
                    nConcur = TransactionMap.CONCUR_PESSIMISTIC;
                    break;
                }
            }
            switch (sIsolation.charAt(0)) {
                case 'C': 
                case 'c': {
                    nIsolation = TransactionMap.TRANSACTION_GET_COMMITTED;
                    break;
                }
                case 'R': 
                case 'r': {
                    nIsolation = TransactionMap.TRANSACTION_REPEATABLE_GET;
                    break;
                }
                default: {
                    nIsolation = TransactionMap.TRANSACTION_SERIALIZABLE;
                    break;
                }
            }
            this.txStart(nConcur, nIsolation, nTimeout);
        } else if (sFunction.equals("commit")) {
            try {
                ((TransactionMap)((Object)this.getMap())).prepare();
                ((TransactionMap)((Object)this.getMap())).commit();
            }
            finally {
                Object var4_6 = null;
                this.txEnd();
            }
        } else if (sFunction.equals("rollback")) {
            ((TransactionMap)((Object)this.getMap())).rollback();
            this.txEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Coherence$Logger ensureRunningLogger() {
        Coherence$Logger logger = this.getLogger();
        if (logger.isStarted() ^ true) {
            Class clazz = Coherence.get_CLASS();
            synchronized (clazz) {
                if (!(logger.isStarted() ^ true) ? false : logger.isConfigured() ^ true) {
                    try {
                        logger.setConfigured(true);
                        logger.setDependencies(LegacyXmlLoggingHelper.fromXml(Coherence.getServiceConfig("$Logger"), new DefaultLoggingDependencies()));
                        logger.start();
                    }
                    catch (RuntimeException e) {
                        this.setLogger(null);
                        throw e;
                    }
                    catch (Error e) {
                        this.setLogger(null);
                        throw e;
                    }
                }
            }
        }
        return logger;
    }

    public static String getBuildNumber() {
        return __s_BuildNumber;
    }

    public static SafeCluster getCluster() {
        return __s_Cluster;
    }

    protected static Attributes getCoherenceAttributes(InputStream in) throws IOException {
        Attributes attrs = new Manifest(in).getMainAttributes();
        String sGroupId = attrs.getValue("Implementation-GroupId");
        return (sGroupId == null ? true : sGroupId.startsWith("com.oracle.coherence") ^ true) ? null : attrs;
    }

    public List getCommandHistory() {
        return this.__m_CommandHistory;
    }

    public int getEdition() {
        return this.__m_Edition;
    }

    public Map getFilters() {
        HashMap mapFilter = this.__m_Filters;
        if (mapFilter == null) {
            mapFilter = new HashMap();
            this.setFilters(mapFilter);
        }
        return mapFilter;
    }

    protected Object getHistory(Object oReader) {
        if (oReader instanceof Reader ^ true) {
            try {
                return ClassHelper.invoke(oReader, "getHistory", ClassHelper.VOID);
            }
            catch (Exception e) {
                System.out.println(new StringBuilder(String.valueOf("failed to flush history: ")).append(e).toString());
            }
        }
        return null;
    }

    public static TransactionMap getLocalTransaction(NamedCache cache) {
        Local mapTx = new Local();
        mapTx.initialize(cache);
        return mapTx;
    }

    public Coherence$Logger getLogger() {
        Coherence$Logger logger;
        AtomicReference refLogger = this.getLoggerRef();
        while ((logger = (Coherence$Logger)refLogger.get()) == null && refLogger.compareAndSet(null, logger = (Coherence$Logger)this._newChild("Logger")) ^ true) {
        }
        return logger;
    }

    protected AtomicReference getLoggerRef() {
        return this.__m_LoggerRef;
    }

    public NamedCache getMap() {
        return this.__m_Map;
    }

    public int getMode() {
        return this.__m_Mode;
    }

    public PersistenceToolsHelper getPersistenceToolsHelper() {
        return this.__m_PersistenceToolsHelper;
    }

    public String getProduct() {
        return this.__m_Product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SafeCluster getSafeCluster() {
        SafeCluster cluster = Coherence.getCluster();
        if (cluster == null && (cluster = (SafeCluster)Coherence.getTloCluster().get()) == null) {
            Class clazz = Coherence.get_CLASS();
            synchronized (clazz) {
                cluster = Coherence.getCluster();
                if (cluster == null) {
                    cluster = new SafeCluster();
                    Coherence.getTloCluster().set(cluster);
                    try {
                        ((Coherence)Coherence.get_Instance()).ensureRunningLogger();
                        DefaultGatewayDependencies dependencies = LegacyXmlGatewayHelper.fromXml(Coherence.getServiceConfig("$Management"), new DefaultGatewayDependencies());
                        Gateway mgmt = Gateway.createGateway(dependencies, cluster);
                        cluster.setManagement(mgmt);
                        Coherence.setCluster(cluster);
                    }
                    finally {
                        Object var3_5 = null;
                        Coherence.getTloCluster().set(null);
                    }
                }
            }
        }
        return cluster;
    }

    public ScriptEngine getScriptEngine() {
        ScriptEngine engine = this.__m_ScriptEngine;
        if (engine == null) {
            String sInit = new StringBuilder(String.valueOf("var imports = new JavaImporter(java.lang, com.tangosol.net,")).append("com.tangosol.util,").append("com.tangosol.util.extractor, com.tangosol.util.filter, com.tangosol.util.processor,").append("com.tangosol.util.aggregator)\n").toString();
            engine = new ScriptEngineManager().getEngineByName("nashorn");
            engine.put("coherence", this);
            try {
                engine.eval(sInit);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
            this.setScriptEngine(engine);
        }
        return engine;
    }

    public CacheService getService() {
        return this.__m_Service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlElement getServiceConfig(String sServiceType) {
        Map mapConfig = Coherence.getServiceConfigMap();
        Class clazz = Coherence.get_CLASS();
        synchronized (clazz) {
            if (Coherence.isConfigurationLoaded() ^ true) {
                ((Coherence)Coherence.get_Instance()).ensureRunningLogger();
                if (Coherence.isConfigurationLoaded() ^ true) {
                    Coherence.loadConfiguration();
                    Coherence.setConfigurationLoaded(true);
                    Coherence.validateEnvironment();
                }
            }
        }
        XmlElement xml = (XmlElement)mapConfig.get(sServiceType);
        return xml == null ? null : (XmlElement)xml.clone();
    }

    protected static Map getServiceConfigMap() {
        return __s_ServiceConfigMap;
    }

    protected CacheService getSimpleCache(String sServiceName) {
        sServiceName = (sServiceName == null ? true : sServiceName.length() == 0) ? "Default" : sServiceName;
        com.tangosol.net.Cluster cluster = CacheFactory.ensureCluster();
        CacheService service = (CacheService)cluster.ensureService(sServiceName, "SimpleCache");
        if (service.isRunning() ^ true) {
            service.configure(Coherence.getServiceConfig("SimpleCache"));
            service.start();
        }
        return service;
    }

    private static ThreadLocal getTloCluster() {
        return __s_TloCluster;
    }

    protected ClassLoader getUniqueClassLoader() {
        return new ComponentClassLoader(this.getClass().getClassLoader(), new NullStorage());
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/application/console/Coherence".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        Component singleton = Application.__singleton;
        if (singleton == null) {
            singleton = new Coherence();
        } else if (!(singleton instanceof Coherence)) {
            throw new IllegalStateException("A singleton for \\\"Coherence\\\" has already been set to a different type");
        }
        return singleton;
    }

    private final Component get_Module() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get_Sink() {
        ThreadLocal oSink = super.get_Sink();
        if (oSink == null) {
            Coherence coherence = this;
            synchronized (coherence) {
                oSink = super.get_Sink();
                if (oSink == null) {
                    oSink = new ThreadLocal();
                    this.set_Sink(oSink);
                }
            }
        }
        return oSink;
    }

    public static boolean isConfigurationLoaded() {
        return __s_ConfigurationLoaded;
    }

    public boolean isDebugOutputEnabled(int iSeverity) {
        Coherence$Logger logger = this.getLogger();
        return logger == null ? super.isDebugOutputEnabled(iSeverity) : logger.isEnabled(iSeverity);
    }

    private static boolean isLicenseLoaded() {
        return __s_LicenseLoaded;
    }

    protected boolean isMapValid() {
        if (this.getMap() == null) {
            Component._trace("Please specify the current map using \"cache\" or \"map\" command");
            return false;
        }
        return true;
    }

    public boolean isScript() {
        return this.__m_Script;
    }

    public boolean isStop() {
        return this.__m_Stop;
    }

    protected static void loadConfiguration() {
        Coherence.get_Instance();
        Map mapConfig = Coherence.getServiceConfigMap();
        XmlDocument xmlCoherence = XmlHelper.loadResource(FILE_CFG_COHERENCE, "operational configuration", Coherence.get_CLASS().getClassLoader());
        Coherence.replaceSystemProperties(xmlCoherence);
        XmlElement xmlLicense = xmlCoherence.ensureElement("license-config");
        String sModeDescription = Coherence.resolveMode(xmlLicense);
        mapConfig.put("$License", xmlLicense.clone());
        Coherence.loadOverrides(xmlCoherence, new HashSet());
        String sEditionDesc = Coherence.resolveEdition(xmlLicense);
        Component._trace(new StringBuilder(String.valueOf("\n")).append(TITLE).append(" Version ").append(VERSION).append(" Build ").append(Coherence.getBuildNumber()).append("\n ").append(sEditionDesc).append(": ").append(sModeDescription).append(" mode").append("\n").append(COPYRIGHT).append("\n").toString());
        XmlElement xmlCluster = xmlCoherence.ensureElement("cluster-config");
        XmlElement xmlLogging = xmlCoherence.getSafeElement("logging-config");
        XmlElement xmlTracing = xmlCoherence.getSafeElement("tracing-config");
        XmlElement xmlFactory = xmlCoherence.getSafeElement("configurable-cache-factory-config");
        XmlElement xmlBuilder = xmlCoherence.getSafeElement("cache-factory-builder-config");
        XmlElement xmlSecurity = xmlCoherence.getSafeElement("security-config");
        XmlElement xmlManagement = xmlCoherence.getSafeElement("management-config");
        XmlElement xmlFederation = xmlCoherence.getSafeElement("federation-config");
        xmlCluster.getElementList().addAll(xmlLicense.getElementList());
        mapConfig.put("Cluster", xmlCluster.clone());
        mapConfig.put("$License", xmlLicense.clone());
        mapConfig.put("$Logger", xmlLogging.clone());
        mapConfig.put("$Tracing", xmlTracing.clone());
        mapConfig.put("$CacheFactory", xmlFactory.clone());
        mapConfig.put("$CacheFactoryBuilder", xmlBuilder.clone());
        mapConfig.put("$Security", xmlSecurity.clone());
        mapConfig.put("$Management", xmlManagement.clone());
        mapConfig.put("$Federation", xmlFederation.clone());
        Iterator iter = xmlCoherence.getSafeElement("cluster-config/services").getElements("service");
        while (iter.hasNext()) {
            XmlElement xmlSvc = (XmlElement)iter.next();
            String sSvcType = xmlSvc.getSafeElement("service-type").getString("service");
            SimpleElement xmlParams = new SimpleElement(sSvcType);
            XmlHelper.transformInitParams(xmlParams, xmlSvc.getSafeElement("init-params"));
            mapConfig.put(sSvcType, xmlParams);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void loadLicenses(XmlElement xml, String sLicenseFile) {
        boolean bl;
        Signature signature;
        XmlDocument xmlLicenses;
        String sXml;
        URL url;
        InputStream stream = null;
        String sUrl = null;
        ClassLoader loader = Coherence.get_CLASS().getClassLoader();
        if (loader == null) {
            loader = Base.getContextClassLoader();
        }
        if ((url = loader.getResource(sLicenseFile)) != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (stream == null && (url = Coherence.__sm3().getClassLoader().getResource(sLicenseFile)) != null) {
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (stream == null) {
            String sErrorMsg = new StringBuilder(String.valueOf("Edition file (")).append(sLicenseFile).append(") is missing from the ").append(TITLE).append(" libraries").toString();
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        sUrl = url.toString();
        try {
            try {
                sXml = new String(Base.read(stream), "ISO-8859-1");
            }
            catch (IOException e) {
                throw new WrapperException(e, "An exception occurred while reading the license data");
            }
            Object var8_13 = null;
        }
        catch (Throwable e) {
            Object var8_14 = null;
            try {
                stream.close();
                throw e;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw e;
        }
        try {}
        catch (IOException e2) {}
        stream.close();
        if (sXml == null ? true : sXml.length() == 0) {
            String sErrorMsg = new StringBuilder(String.valueOf("Edition data (")).append(sUrl).append(") is missing or empty.").toString();
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        Component._trace(new StringBuilder(String.valueOf("Loaded edition data from \"")).append(sUrl).append("\"").toString(), 6);
        try {
            xmlLicenses = new SimpleParser().parseXml(sXml);
        }
        catch (IOException e) {
            throw new WrapperException(e, "An exception occurred while parsing the license data");
        }
        xml.ensureElement("license-list").getElementList().addAll(xmlLicenses.getElementList());
        if (Coherence.isLicenseLoaded()) {
            return;
        }
        Coherence.setLicenseLoaded(true);
        InputStream streamCert = null;
        try {
            Certificate cert;
            try {
                streamCert = loader.getResourceAsStream(FILE_CFG_CERTIFICATE);
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                cert = factory.generateCertificate(streamCert);
                signature = Signature.getInstance("SHA1withDSA");
                signature.initVerify(cert.getPublicKey());
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Error during license validation");
            }
            cert = null;
            bl = streamCert != null;
        }
        catch (Throwable e) {
            Object cert = null;
            if (!(streamCert != null)) throw e;
            try {
                streamCert.close();
                throw e;
            }
            catch (IOException e3) {
                // empty catch block
            }
            throw e;
        }
        if (bl) {
            try {}
            catch (IOException e3) {}
            streamCert.close();
        }
        ArrayList<LicensedObject.LicenseData> list = new ArrayList<LicensedObject.LicenseData>();
        Iterator iter = xmlLicenses.getElements("license");
        while (true) {
            int ofColon;
            if (!iter.hasNext()) {
                LicensedObject.setLicenseData(list.toArray(new LicensedObject.LicenseData[0]));
                return;
            }
            XmlElement xmlLicense = (XmlElement)iter.next();
            String sLicensee = xmlLicense.getSafeElement("licensee").getString(null);
            String sAgreement = xmlLicense.getSafeElement("agreement").getString(null);
            String sMode = xmlLicense.getSafeElement("type").getString(null);
            String sFromDate = xmlLicense.getSafeElement("from-date").getString(null);
            String sToDate = xmlLicense.getSafeElement("to-date").getString(null);
            String sRenewDate = xmlLicense.getSafeElement("maintenance-renewal-date").getString(null);
            int cSeats = xmlLicense.getSafeElement("max-seats").getInt();
            int cUsers = xmlLicense.getSafeElement("max-users").getInt();
            String sSite = xmlLicense.getSafeElement("site").getString(null);
            int cServers = xmlLicense.getSafeElement("max-servers").getInt();
            int cSockets = xmlLicense.getSafeElement("max-sockets").getInt();
            int cCores = xmlLicense.getSafeElement("max-cpus").getInt();
            String sUid = xmlLicense.getSafeElement("id").getString(null);
            String sKey = xmlLicense.getSafeElement("key").getString(null);
            String sSig = xmlLicense.getSafeElement("signature").getString(null);
            String sClass = null;
            String sSoftware = null;
            String sEdition = null;
            if (sUid == null) {
                String sMsg = new StringBuilder(String.valueOf("You are using an out-of-date license format; ")).append("please contact Oracle to obtain a replacement license.").toString();
                Component._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            UID uid = new UID(sUid);
            long lDateFrom = sFromDate == null ? 0L : Coherence.parseDate(sFromDate);
            long lDateTo = sToDate == null ? 0L : Coherence.parseDate(sToDate);
            long lDateRenew = sRenewDate == null ? 0L : Coherence.parseDate(sRenewDate);
            int nMode = -1;
            if (!(sMode != null) ? false : sMode.length() > 0) {
                switch (sMode.charAt(0)) {
                    case 'e': {
                        nMode = 0;
                        break;
                    }
                    case 'd': {
                        nMode = 1;
                        break;
                    }
                    case 'p': {
                        nMode = 2;
                        break;
                    }
                }
            }
            if (nMode < 0) {
                String sErrorMsg = new StringBuilder(String.valueOf("Invalid license mode: \"")).append(sMode).append("\"").toString();
                Component._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
            if (sSig == null) {
                if (sKey == null) {
                    continue;
                }
            } else {
                sSoftware = xmlLicense.getSafeElement("software").getString();
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(sSoftware).append(sLicensee).append(sAgreement == null ? "" : sAgreement).append(nMode).append(lDateFrom).append(lDateTo).append(lDateRenew).append(cSeats).append(cUsers).append(sSite).append(cServers).append(cSockets).append(cCores).append(uid);
                    ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                    DataOutputStream streamSig = new DataOutputStream(streamRaw);
                    streamSig.writeUTF(sb.toString());
                    signature.update(streamRaw.toByteArray());
                    if (signature.verify(Base.parseHex(sSig)) ^ true) {
                        String sMsg = new StringBuilder(String.valueOf("The ")).append(sSoftware).append(" license signature ").append("is not valid, please contact Oracle.").toString();
                        System.err.println(sMsg);
                        Component._trace(sMsg, 1);
                        continue;
                    }
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, new StringBuilder(String.valueOf("Error validating license signature for ")).append(sSoftware).toString());
                }
                if (sSoftware.endsWith(": Grid Edition")) {
                    sEdition = DEFAULT_EDITION;
                    sClass = "com.tangosol.license.CoherenceDataGridEdition";
                } else if (sSoftware.endsWith(": Enterprise Edition") ? true : sSoftware.endsWith(": Application Edition")) {
                    sEdition = "EE";
                    sClass = "com.tangosol.license.CoherenceApplicationEdition";
                } else if (sSoftware.endsWith(": Community Edition")) {
                    sEdition = "CE";
                    sClass = "com.tangosol.license.CoherenceCommunityEdition";
                } else if (sSoftware.endsWith(": Standard Edition") ? true : sSoftware.endsWith(": Caching Edition")) {
                    sEdition = "SE";
                    sClass = "com.tangosol.license.CoherenceCachingEdition";
                } else if (sSoftware.endsWith(": Compute Client")) {
                    sEdition = "CC";
                    sClass = "com.tangosol.license.CoherenceComputeClient";
                } else if (sSoftware.endsWith(": Real-Time Client")) {
                    sEdition = "RTC";
                    sClass = "com.tangosol.license.CoherenceRealTimeClient";
                } else if (sSoftware.endsWith(": Data Client")) {
                    sEdition = "DC";
                    sClass = "com.tangosol.license.CoherenceDataClient";
                }
            }
            if (!(sClass == null) ? false : sKey != null) {
                try {
                    sClass = new Binary(Base.parseHex(sKey.substring(9, sKey.length() - 1))).getBufferInput().readUTF();
                }
                catch (IOException e) {
                    continue;
                }
                if (sClass.endsWith(".CoherenceEnterprise")) {
                    sSoftware = new StringBuilder(String.valueOf(TITLE)).append(": Enterprise Edition").toString();
                    sEdition = "EE";
                    sClass = "com.tangosol.license.CoherenceApplicationEdition";
                } else if (sClass.endsWith(".Coherence")) {
                    sSoftware = new StringBuilder(String.valueOf(TITLE)).append(": Standard Edition").toString();
                    sEdition = "SE";
                    sClass = "com.tangosol.license.CoherenceCachingEdition";
                } else {
                    if (!(sClass.endsWith(".CoherenceLocal") ? true : sClass.endsWith(".ClientAccess"))) continue;
                    sSoftware = new StringBuilder(String.valueOf(TITLE)).append(": Data Client").toString();
                    sEdition = "DC";
                    sClass = "com.tangosol.license.CoherenceDataClient";
                }
            }
            boolean fOem = sLicensee.startsWith("OEM:");
            String sApp = null;
            if (fOem && (ofColon = (sLicensee = sLicensee.substring(4)).lastIndexOf(58)) > 0) {
                sApp = sLicensee.substring(ofColon + 1);
                sLicensee = sLicensee.substring(0, ofColon);
            }
            list.add(new LicensedObject.LicenseData(sSoftware, sEdition, sLicensee, fOem, sAgreement, nMode, sClass, sSite, sApp, lDateFrom, lDateTo, lDateRenew, cSeats, cUsers, cServers, cSockets, cCores, uid));
        }
    }

    protected static void loadOverrides(XmlElement xml, Set setOverrides) {
        block9: {
            String ATTR_OVERRIDE = "xml-override";
            String ATTR_ID = "id";
            XmlValue attr = xml.getAttribute(ATTR_OVERRIDE);
            if (attr != null) {
                xml.setAttribute(ATTR_OVERRIDE, null);
                String sOverride = Coherence.calculateAttribute(attr.getString());
                try {
                    URL url;
                    XmlDocument xmlOverride = null;
                    File file = new File(sOverride);
                    if (!file.exists() ? false : file.isDirectory()) {
                        sOverride = new File(file, FILE_CFG_COHERENCE_OVERRIDE).getPath();
                    }
                    if ((url = Resources.findFileOrResource(sOverride, Coherence.get_CLASS().getClassLoader())) != null) {
                        xmlOverride = XmlHelper.loadXml(url);
                        Component._trace(new StringBuilder(String.valueOf("Loaded operational overrides from \"")).append(url).append('\"').toString(), 3);
                    }
                    if (xmlOverride == null) {
                        Component._trace(new StringBuilder(String.valueOf("Optional configuration override \"")).append(sOverride).append("\" is not specified").toString(), 3);
                        break block9;
                    }
                    if (xmlOverride.getName().equals(xml.getName())) {
                        Coherence.replaceSystemProperties(xmlOverride);
                        XmlValue attrOverride = xmlOverride.getAttribute(ATTR_OVERRIDE);
                        if (attrOverride == null ? true : setOverrides.add(attrOverride.getString())) {
                            Coherence.loadOverrides(xmlOverride, setOverrides);
                            XmlHelper.overrideElement(xml, xmlOverride, ATTR_ID);
                            break block9;
                        }
                        throw new IOException(new StringBuilder(String.valueOf("Document \"")).append(sOverride).append("\" is cyclically referenced by the '").append(ATTR_OVERRIDE).append("' attribute of element '").append(xml.getName()).append("'").toString());
                    }
                    throw new IOException(new StringBuilder(String.valueOf("Root name mismatch in the document: ")).append(sOverride).append("; ").append("expected name: \"").append(xml.getName()).append('\"').toString());
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, new StringBuilder(String.valueOf("Failed to apply the element override: ")).append(sOverride).toString());
                }
            }
        }
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            Coherence.loadOverrides((XmlElement)iter.next(), new HashSet(setOverrides));
        }
    }

    public static void main(String[] asArgs) {
        Application.setArgument(asArgs);
        ((Coherence)Coherence.get_Instance()).run();
    }

    public static String[] parseArguments(String sArguments) {
        if (sArguments.length() == 0) {
            return new String[0];
        }
        char[] ach = sArguments.toCharArray();
        int cch = ach.length;
        boolean fEsc = false;
        boolean fQuote = false;
        char chQuote = (char)0;
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int ofCur = 0;
        while (ofCur < cch) {
            char ch = ach[ofCur];
            if (fEsc) {
                switch (ch) {
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case ' ': {
                        sb.append(' ');
                        break;
                    }
                    default: {
                        sb.append('\\').append(ch);
                        break;
                    }
                }
                fEsc = false;
            } else {
                switch (ch) {
                    case '\"': 
                    case '\'': {
                        if (fQuote) {
                            if (ch == chQuote) {
                                fQuote = false;
                                break;
                            }
                            sb.append(ch);
                            break;
                        }
                        fQuote = true;
                        chQuote = ch;
                        break;
                    }
                    case ' ': {
                        if (fQuote) {
                            sb.append(' ');
                            break;
                        }
                        if (!(sb.length() > 0)) break;
                        list.add(sb.toString());
                        sb.setLength(0);
                        break;
                    }
                    case '\\': {
                        fEsc = true;
                        break;
                    }
                    default: {
                        sb.append(ch);
                        break;
                    }
                }
            }
            ++ofCur;
        }
        if (fQuote) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("Unmatched quote (")).append(chQuote).append(") in command: ").append(sArguments).toString());
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public static long parseDate(String s) {
        if (s == null ? true : s.length() == 0) {
            return 0L;
        }
        String[] asParts = Base.parseDelimitedString(s, '-');
        return Date.UTC(Integer.parseInt(asParts[0]) - 1900, Integer.parseInt(asParts[1]) - 1, Integer.parseInt(asParts[2]), 0, 0, 0);
    }

    public static int parseEditionName(String sEdition) {
        if (sEdition != null) {
            String[] asEdition = EDITION_NAMES;
            int i = 0;
            int c = asEdition.length;
            while (i < c) {
                if (sEdition.equals(asEdition[i])) {
                    return i;
                }
                ++i;
            }
        }
        Component._trace(new StringBuilder(String.valueOf("Unknown edition: ")).append(sEdition).toString(), 2);
        return 0;
    }

    public static int parseModeName(String sMode) {
        if (sMode != null) {
            String[] asMode = MODE_NAMES;
            int i = 0;
            int c = asMode.length;
            while (i < c) {
                if (sMode.equals(asMode[i])) {
                    return i;
                }
                ++i;
            }
        }
        Component._trace(new StringBuilder(String.valueOf("Unknown mode: ")).append(sMode).toString(), 2);
        return 1;
    }

    public static void printException(String sPrefix, Throwable e) {
        Object oPartial;
        while (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (sPrefix == null) {
            Component._trace(e);
        } else {
            Component._trace(new StringBuilder(String.valueOf(sPrefix)).append(Component.getStackTrace(e)).toString(), 1);
        }
        if (e instanceof RequestTimeoutException && (oPartial = ((RequestTimeoutException)e).getPartialResult()) != null) {
            Component._trace(new StringBuilder(String.valueOf("Partial result: ")).append(oPartial).toString());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object processCommand(String sCmd) throws InterruptedException {
        block195: {
            block223: {
                block222: {
                    block221: {
                        block220: {
                            block219: {
                                block218: {
                                    block217: {
                                        block216: {
                                            block215: {
                                                block214: {
                                                    block213: {
                                                        block212: {
                                                            block211: {
                                                                block210: {
                                                                    block209: {
                                                                        block208: {
                                                                            block207: {
                                                                                block206: {
                                                                                    block205: {
                                                                                        block204: {
                                                                                            block203: {
                                                                                                block202: {
                                                                                                    block201: {
                                                                                                        block200: {
                                                                                                            block199: {
                                                                                                                block198: {
                                                                                                                    block197: {
                                                                                                                        block196: {
                                                                                                                            service = this.getService();
                                                                                                                            map = this.getMap();
                                                                                                                            oResult = null;
                                                                                                                            fSilent = false;
                                                                                                                            if (sCmd.charAt(0) == '@') {
                                                                                                                                fSilent = true;
                                                                                                                                sCmd = sCmd.substring(1);
                                                                                                                            }
                                                                                                                            if (this.isScript()) {
                                                                                                                                this.doScript(sCmd, fSilent);
                                                                                                                                return null;
                                                                                                                            }
                                                                                                                            ofFunction = sCmd.indexOf(32);
                                                                                                                            if (ofFunction < 0) {
                                                                                                                                sFunction = sCmd;
                                                                                                                                sCmd = "";
                                                                                                                            } else {
                                                                                                                                sFunction = sCmd.substring(0, ofFunction);
                                                                                                                                sCmd = sCmd.substring(ofFunction + 1).trim();
                                                                                                                            }
                                                                                                                            if (sFunction.startsWith("#")) {
                                                                                                                                sIter = sFunction.substring(1);
                                                                                                                                fForce = false;
                                                                                                                                if (sIter.startsWith("#")) {
                                                                                                                                    sIter = sIter.substring(1);
                                                                                                                                    fForce = true;
                                                                                                                                }
                                                                                                                                try {
                                                                                                                                    cIter = Integer.parseInt(sIter);
                                                                                                                                    this.doRepeat(sCmd, cIter, fForce);
                                                                                                                                }
                                                                                                                                catch (NumberFormatException e) {
                                                                                                                                    Component._trace(new StringBuilder(String.valueOf("invalid counter: ")).append(sIter).toString());
                                                                                                                                }
                                                                                                                                return null;
                                                                                                                            }
                                                                                                                            asParam = Coherence.parseArguments(sCmd);
                                                                                                                            cParams = asParam.length;
                                                                                                                            v0 = aoParam = sFunction.startsWith("bulk") != false ? null : this.convertArguments(asParam);
                                                                                                                            if (sFunction.startsWith("!")) {
                                                                                                                                if (sFunction.length() == 1) {
                                                                                                                                    this.doHistory(asParam, fSilent);
                                                                                                                                } else {
                                                                                                                                    nCmd = Integer.parseInt(sFunction.substring(1));
                                                                                                                                    this.doReissueCommand(nCmd, sCmd, fSilent);
                                                                                                                                }
                                                                                                                                return null;
                                                                                                                            }
                                                                                                                            if (!sFunction.startsWith("&")) break block196;
                                                                                                                            oResult = this.doFunction(sFunction, aoParam, fSilent);
                                                                                                                            break block195;
                                                                                                                        }
                                                                                                                        if (!(sFunction.equals("lock") != false ? true : sFunction.equals("unlock"))) break block197;
                                                                                                                        if (this.isMapValid()) {
                                                                                                                            oResult = this.doFunction(new StringBuilder(String.valueOf('&')).append(sFunction).toString(), aoParam, fSilent);
                                                                                                                        }
                                                                                                                        break block195;
                                                                                                                    }
                                                                                                                    if (!sFunction.equals("bye")) break block198;
                                                                                                                    CacheFactory.shutdown();
                                                                                                                    this.setStop(true);
                                                                                                                    break block195;
                                                                                                                }
                                                                                                                if (sFunction.equals("echo")) {
                                                                                                                    Component._trace(Arrays.deepToString(aoParam));
                                                                                                                    return aoParam;
                                                                                                                }
                                                                                                                if (!sFunction.equals("help")) break block199;
                                                                                                                Component._trace("The commands are:");
                                                                                                                Component._trace("  aggregate ('{' <key> [, <key>]* '}' | '{filter:'<filter-name>'}' | '*') <aggregator-name> [<extractor>]");
                                                                                                                Component._trace("  assert <value>");
                                                                                                                Component._trace("  backup <path>");
                                                                                                                Component._trace("  batch <path>");
                                                                                                                Component._trace("  bulkput <# of iterations> <block size> <start key> [<batch size> | all]");
                                                                                                                Component._trace("  bulkremove <# of iterations> <start key> [all]");
                                                                                                                Component._trace("  bye");
                                                                                                                Component._trace("  cachefactory [<path>]");
                                                                                                                Component._trace("  cache <name>");
                                                                                                                Component._trace("  cohql [<paramValue>]*");
                                                                                                                Component._trace("  clear");
                                                                                                                Component._trace("  destroy");
                                                                                                                Component._trace("  explain <filter name> [trace]");
                                                                                                                Component._trace("  filter <name> <type> [(<accessor> <value>) | [<paramValue>]+]");
                                                                                                                Component._trace("  get <key>");
                                                                                                                Component._trace("  hash");
                                                                                                                Component._trace("  help");
                                                                                                                Component._trace("  history ([<pattern>] [<limit>]) | (['on' | 'off' | 'clear'])");
                                                                                                                Component._trace("  inc <key> [<increment>]");
                                                                                                                Component._trace("  invoke <command> [('all' | 'other' | 'senior' | <id>) [('async' | 'sync')]]");
                                                                                                                Component._trace("  index <accessor> [add | remove]");
                                                                                                                Component._trace("  jmx [(<port> | <url>) [('start' | 'stop')]]");
                                                                                                                Component._trace("  kill");
                                                                                                                Component._trace("  list [<map name> | <filter name> [<accessor> [asc | desc]]]");
                                                                                                                Component._trace("  listen [('start' | 'stop') [('cluster' | 'interceptor' | 'local' | 'members' | 'trigger' | 'partition')]] [<filter> | <key> | <event-types>] [<lite>]");
                                                                                                                Component._trace("  lock <key>");
                                                                                                                Component._trace("  log (<size> | <message>) [<iterations> [<level>]]");
                                                                                                                Component._trace("  maps");
                                                                                                                Component._trace("  memory");
                                                                                                                Component._trace("  process (<key> | '{' <key> [, <key>]* '}' | '{filter:'<filter-name>'}' | '*') <processor-name> [<paramValue>]+");
                                                                                                                Component._trace("  profile <command>");
                                                                                                                Component._trace("  put <key> <value>");
                                                                                                                Component._trace("  release");
                                                                                                                Component._trace("  remove <key>");
                                                                                                                Component._trace("  restore <path>");
                                                                                                                Component._trace("  resume [all]");
                                                                                                                Component._trace("  runAs <name> <password> <command>");
                                                                                                                Component._trace("  server [<path-to-gar>] [<app-name>]");
                                                                                                                Component._trace("  service");
                                                                                                                Component._trace("  services");
                                                                                                                Component._trace("  size [<filter name>]");
                                                                                                                Component._trace("  sleep [interval]");
                                                                                                                Component._trace("  snapshot [create | archive | recover | remove] <snapshot-name>");
                                                                                                                Component._trace("  snapshot list [archived]");
                                                                                                                Component._trace("  snapshot [remove | retrieve] archived <snapshot-name>");
                                                                                                                Component._trace("  stats [cluster | service | p2p] [reset]");
                                                                                                                Component._trace("  suspend [all]");
                                                                                                                Component._trace("  unlock <key>");
                                                                                                                Component._trace("  waitkey <start key> <stop key>");
                                                                                                                Component._trace("  who | cluster");
                                                                                                                Component._trace("  whoami | service");
                                                                                                                Component._trace("  worker <command>");
                                                                                                                Component._trace("  #<repeat count> <command>");
                                                                                                                Component._trace("  &<functionName> [<paramValue>]*");
                                                                                                                Component._trace("  !<history index>");
                                                                                                                break block195;
                                                                                                            }
                                                                                                            if (!sFunction.equals("aggregate")) break block200;
                                                                                                            if (this.isMapValid()) {
                                                                                                                this.doAggregate(aoParam, fSilent);
                                                                                                            }
                                                                                                            break block195;
                                                                                                        }
                                                                                                        if (!sFunction.equals("assert")) break block201;
                                                                                                        if (cParams >= 1 && (sValue = String.valueOf(aoParam[0])).equals(sResult = String.valueOf(((ThreadLocal)this.get_Sink()).get())) ^ true) {
                                                                                                            sMsg = new StringBuilder(String.valueOf("Assertion failed: expected=\"")).append(sValue).append("\"; actual=\"").append(sResult).append('\"').toString();
                                                                                                            Component._trace(sMsg, 1);
                                                                                                            oResult = new RuntimeException(sMsg);
                                                                                                        }
                                                                                                        break block195;
                                                                                                    }
                                                                                                    if (!sFunction.equals("backup")) break block202;
                                                                                                    this.doBackup(asParam, fSilent);
                                                                                                    break block195;
                                                                                                }
                                                                                                if (!sFunction.equals("batch")) break block203;
                                                                                                this.doBatch(asParam, fSilent);
                                                                                                break block195;
                                                                                            }
                                                                                            if (!sFunction.equals("bulkput")) break block204;
                                                                                            this.doBulkPut(asParam, fSilent);
                                                                                            break block195;
                                                                                        }
                                                                                        if (!sFunction.equals("bulkremove")) break block205;
                                                                                        this.doBulkRemove(asParam, fSilent);
                                                                                        break block195;
                                                                                    }
                                                                                    if (!sFunction.equals("cachefactory")) break block206;
                                                                                    this.doCacheFactory(asParam, fSilent);
                                                                                    break block195;
                                                                                }
                                                                                if (!sFunction.equals("cache")) break block207;
                                                                                if (cParams > 0) {
                                                                                    this.doCache(asParam, fSilent);
                                                                                } else {
                                                                                    Component._trace(String.valueOf(map));
                                                                                }
                                                                                break block195;
                                                                            }
                                                                            if (!sFunction.equals("cohql")) break block208;
                                                                            QueryPlus.main(asParam);
                                                                            break block195;
                                                                        }
                                                                        if (!sFunction.equals("clear")) break block209;
                                                                        if (this.isMapValid()) {
                                                                            map.clear();
                                                                        }
                                                                        break block195;
                                                                    }
                                                                    if (!sFunction.equals("truncate")) break block210;
                                                                    if (this.isMapValid()) {
                                                                        map.truncate();
                                                                    }
                                                                    break block195;
                                                                }
                                                                if (!(sFunction.equals("cluster") != false ? true : sFunction.equals("who"))) break block211;
                                                                Component._trace(String.valueOf(Coherence.getSafeCluster()));
                                                                break block195;
                                                            }
                                                            if (!sFunction.equals("connector")) break block212;
                                                            this.doConnector(asParam, fSilent);
                                                            break block195;
                                                        }
                                                        if (!sFunction.equals("destroy")) break block213;
                                                        if (this.isMapValid()) {
                                                            CacheFactory.destroyCache(map);
                                                        }
                                                        break block195;
                                                    }
                                                    if (!sFunction.equals("explain")) break block214;
                                                    if (this.isMapValid()) {
                                                        this.doExplain(asParam, fSilent);
                                                    }
                                                    break block195;
                                                }
                                                if (!sFunction.equals("filter")) break block215;
                                                if (this.isMapValid()) {
                                                    this.doFilter(aoParam, fSilent);
                                                }
                                                break block195;
                                            }
                                            if (!sFunction.equals("get")) break block216;
                                            if (this.isMapValid() == false ? false : cParams >= 1) {
                                                oResult = map.get(aoParam[0]);
                                                ((ThreadLocal)this.get_Sink()).set(oResult);
                                                if (fSilent ^ true) {
                                                    Component._trace(Coherence.toString(oResult));
                                                }
                                            }
                                            break block195;
                                        }
                                        if (!sFunction.equals("hash")) break block217;
                                        if (this.isMapValid() ^ true) {
                                            return null;
                                        }
                                        iHash = 0;
                                        iter = map.keySet().iterator();
                                        while (iter.hasNext()) {
                                            oKey = iter.next();
                                            oVal = map.get(oKey);
                                            if (oVal instanceof byte[]) {
                                                ab = (byte[])oVal;
                                                i = 0;
                                                c = ab.length;
                                                while (i < c) {
                                                    iHash += ab[i];
                                                    ++i;
                                                }
                                                continue;
                                            }
                                            if (!(oVal != null)) continue;
                                            iHash += oVal.hashCode();
                                        }
                                        Component._trace(new StringBuilder(String.valueOf("hash=")).append(iHash).toString());
                                        break block195;
                                    }
                                    if (!sFunction.equals("history")) break block218;
                                    this.doHistory(asParam, fSilent);
                                    break block195;
                                }
                                if (sFunction.equals("inc")) {
                                    if (this.isMapValid() ^ true) {
                                        return null;
                                    }
                                    oKey = aoParam[0];
                                    cInc = 1;
                                    try {
                                        cInc = Integer.parseInt(asParam[1]);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    v1 = fLock = cParams <= 2 != false ? true : asParam[2].startsWith("o") ^ true;
                                    if (fLock) {
                                        map.lock(oKey, -1);
                                    }
                                    try {
                                        oVal /* !! */  = map.get(oKey);
                                        v2 = sVal = fSilent != false ? null : String.valueOf(oVal /* !! */ );
                                        if (oVal /* !! */  instanceof Versionable) {
                                            ver = (Versionable)oVal /* !! */ ;
                                            i = 0;
                                            while (i < cInc) {
                                                ver.incrementVersion();
                                                ++i;
                                            }
                                        } else {
                                            nVal = 0;
                                            try {
                                                nVal = Integer.parseInt(String.valueOf(oVal /* !! */ ));
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                            oVal /* !! */  = nVal + cInc;
                                        }
                                        map.put(oKey, oVal /* !! */ );
                                        if (fSilent ^ true) {
                                            Component._trace(new StringBuilder(String.valueOf("incremented ")).append(oKey).append(" from ").append(sVal).append(" to ").append(oVal /* !! */ ).toString());
                                        }
                                        ((ThreadLocal)this.get_Sink()).set(oVal /* !! */ );
                                    }
                                    finally {
                                        sVal = null;
                                        if (fLock) {
                                            map.unlock(oKey);
                                        }
                                    }
                                }
                                if (!sFunction.equals("index")) break block219;
                                if (this.isMapValid() ^ true) {
                                    return null;
                                }
                                this.doIndex(asParam, fSilent);
                                break block195;
                            }
                            if (!sFunction.equals("iterate")) break block220;
                            cItems = 0;
                            iter = (Iterator)((ThreadLocal)this.get_Sink()).get();
                            while (iter.hasNext()) {
                                oNext = iter.next();
                                ++cItems;
                            }
                            if (fSilent ^ true) {
                                Component._trace(new StringBuilder(String.valueOf(cItems)).append(" items").toString());
                            }
                            break block195;
                        }
                        if (!sFunction.startsWith("invoke")) break block221;
                        ofName = sFunction.indexOf(58);
                        sName = ofName < 0 != false ? "InvocationService" : sFunction.substring(ofName + 1);
                        this.doInvoke(sName, asParam, fSilent);
                        break block195;
                    }
                    if (!sFunction.equals("jmx")) break block222;
                    this.doJmx(asParam);
                    break block195;
                }
                if (!sFunction.equals("kill")) break block223;
                if (!(cParams > 0)) ** GOTO lbl313
                if (asParam[0].equals("all")) {
                    CacheFactory.shutdown();
                } else {
                    svcCluster = Coherence.getSafeCluster().getCluster().getClusterService();
                    setMember = svcCluster.getClusterMemberSet();
                    member = setMember.getMember(Integer.parseInt(asParam[0]));
                    if (svcCluster.getThisMember().equals(member)) {
                        Coherence.getSafeCluster().shutdown();
                    } else {
                        svcCluster.doMemberLeft(member);
                        return null;
lbl313:
                        // 1 sources

                        if (service == null) {
                            Coherence.getSafeCluster().shutdown();
                        } else {
                            service.shutdown();
                        }
                    }
                }
                this.setService(null);
                this.setMap(null);
                this.getLogger().setPrompt("?");
                break block195;
            }
            if (sFunction.equals("script")) {
                this.doScript(sCmd, fSilent);
            } else if (sFunction.equals("snapshot") != false ? true : sFunction.equals("persistence")) {
                if (cParams == 0) {
                    Component._trace("Please provide correct arguments to persistence/snapshot command");
                } else {
                    this.doPersistence(asParam, fSilent);
                }
            } else if (sFunction.equals("suspend") != false ? true : sFunction.equals("resume")) {
                svcCluster = Coherence.getSafeCluster().getCluster().getClusterService();
                fResume = sFunction.equals("resume");
                sName = (service == null != false ? true : (asParam.length > 0 == false ? false : asParam[0].equals("all"))) != false ? svcCluster.getServiceName() : ((Grid)((SafeService)service).getService()).getServiceName();
                svcCluster.doServiceQueiscence(sName, fResume);
            } else if (sFunction.equals("list")) {
                if (this.isMapValid()) {
                    this.doList(asParam, fSilent);
                }
            } else if (sFunction.equals("listen")) {
                fStop = cParams >= 1 == false ? false : asParam[0].equals("stop");
                sSource = cParams >= 2 != false ? asParam[1] : "global";
                oKey = null;
                filter = null;
                fLite = false;
                if (cParams >= 3 && (filter = (Filter)this.getFilters().get(asParam[2])) == null) {
                    oKey = aoParam[2];
                }
                if (cParams >= 4) {
                    fLite = asParam[3].equals("lite");
                }
                this.doListen(sSource, fStop, filter, oKey, fLite);
            } else if (sFunction.equals("log")) {
                this.doLog(aoParam, fSilent);
            } else if (sFunction.equals("maps")) {
                enumS = CacheFactory.ensureCluster().getServiceNames();
                while (enumS.hasMoreElements()) {
                    sName = enumS.nextElement();
                    srv = Coherence.getSafeCluster().getService(sName);
                    if (!(srv instanceof CacheService == false ? false : srv.isRunning())) continue;
                    rc = (CacheService)srv;
                    enumC = rc.getCacheNames();
                    while (enumC.hasMoreElements()) {
                        Component._trace(new StringBuilder(String.valueOf(srv.getInfo().getServiceName())).append(":").append(enumC.nextElement()).toString());
                    }
                }
            } else if (sFunction.equals("memory")) {
                rt = Runtime.getRuntime();
                rt.gc();
                lTotal = rt.totalMemory();
                lFree = rt.freeMemory();
                Component._trace(new StringBuilder(String.valueOf("total=")).append(lTotal / (long)1000).append("K (").append(lTotal).append(")").toString());
                Component._trace(new StringBuilder(String.valueOf("free =")).append(lFree / (long)1000).append("K (").append(lFree).append(")").toString());
                try {
                    LMax = (Long)ClassHelper.invoke(rt, "maxMemory", ClassHelper.VOID);
                    Component._trace(new StringBuilder(String.valueOf("max  =")).append(LMax / (long)1000).append("K (").append(LMax).append(")").toString());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                oResult = lFree;
            } else if (sFunction.equals("new")) {
                if (cParams > 0) {
                    try {
                        sClass = asParam[0];
                        if (sClass.startsWith("Component")) {
                            oResult = Component._newInstance(sClass);
                        } else {
                            clz = Class.forName(sClass);
                            if (cParams > 1) {
                                ao = new Object[cParams - 1];
                                System.arraycopy(aoParam, 1, ao, 0, cParams - 1);
                                oResult = ClassHelper.newInstance(clz, ao);
                            } else {
                                oResult = clz.newInstance();
                            }
                        }
                    }
                    catch (Exception e) {
                        Coherence.printException(null, e);
                    }
                }
                if (fSilent ^ true) {
                    Component._trace(Coherence.toString(oResult));
                }
                ((ThreadLocal)this.get_Sink()).set(oResult);
            } else if (sFunction.startsWith("process")) {
                if (this.isMapValid()) {
                    this.doProcess(aoParam, sFunction.equals("processAsync"), fSilent);
                }
            } else if (sFunction.equals("profile")) {
                lBegin = Base.getSafeTimeMillis();
                this.processCommand(sCmd);
                lElapsed = Base.getSafeTimeMillis() - lBegin;
                Component._trace(new StringBuilder(String.valueOf("Elapsed ")).append(lElapsed).append("ms").toString());
            } else if (sFunction.equals("put")) {
                if (this.isMapValid() == false ? false : cParams >= 2) {
                    oResult = map.put(aoParam[0], aoParam[1]);
                    if (fSilent ^ true) {
                        Component._trace(Coherence.toString(oResult));
                    }
                }
            } else if (sFunction.equals("release")) {
                if (this.isMapValid()) {
                    CacheFactory.releaseCache(map);
                }
            } else if (sFunction.equals("remove")) {
                if (this.isMapValid() == false ? false : cParams >= 1) {
                    oResult = map.remove(aoParam[0]);
                    ((ThreadLocal)this.get_Sink()).set(oResult);
                    if (fSilent ^ true) {
                        Component._trace(Coherence.toString(oResult));
                    }
                }
            } else if (sFunction.equals("restore")) {
                this.doRestore(asParam, fSilent);
            } else if (sFunction.equalsIgnoreCase("runAs")) {
                oResult = this.doSecure(asParam, fSilent);
            } else if (sFunction.equals("scan")) {
                if (this.isMapValid()) {
                    this.doScan(asParam);
                }
            } else if (sFunction.equals("server")) {
                this.doServer(asParam);
            } else if (sFunction.equals("service") != false ? true : sFunction.equals("whoami")) {
                if (service == null) {
                    this.processCommand("who");
                } else {
                    Component._trace(String.valueOf(service));
                    Component._trace(String.valueOf(service.getInfo().getServiceMembers()));
                }
            } else if (sFunction.equals("services")) {
                enum = CacheFactory.ensureCluster().getServiceNames();
                while (enum.hasMoreElements()) {
                    sName = enum.nextElement();
                    info = Coherence.getSafeCluster().getServiceInfo(sName);
                    if (!(info != null)) continue;
                    Component._trace(info.toString());
                }
            } else {
                if (sFunction.equals("sleep")) {
                    lMillis = 1L;
                    try {
                        lMillis = Long.parseLong(asParam[0]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    oKey = null;
                    if (cParams > 1) {
                        if (this.isMapValid() ^ true) {
                            return null;
                        }
                        oKey = aoParam[1];
                    }
                    try {
                        block194: {
                            try {
                                lStart = Base.getSafeTimeMillis();
                                if (oKey != null) {
                                    map.lock(oKey, -1L);
                                }
                                if (lMillis > (long)0) {
                                    Blocking.sleep(lMillis);
                                    lStop = Base.getSafeTimeMillis();
                                } else {
                                    do {
                                        i = 0;
                                        while (i < 100) {
                                            ++i;
                                        }
                                        Thread.yield();
                                    } while ((lStop = Base.getSafeTimeMillis()) < lStart - lMillis);
                                }
                                if (fSilent ^ true) {
                                    Component._trace(new StringBuilder(String.valueOf("Elapsed ")).append(lStop - lStart).append("ms").toString());
                                }
                            }
                            catch (InterruptedException e) {
                                Component._trace("Sleep was interrupted; re-setting the interrupt flag...", 3);
                                Thread.currentThread().interrupt();
                                if (!(fSilent ^ true)) break block194;
                                throw Base.ensureRuntimeException(e);
                            }
                        }
                        enumC = null;
                        ** if (!(oKey != null)) goto lbl-1000
                    }
                    catch (Throwable e) {
                        enumC = null;
                        if (oKey != null) {
                            map.unlock(oKey);
                        }
                        throw e;
                    }
lbl-1000:
                    // 1 sources

                    {
                        map.unlock(oKey);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block195;
                    }
                }
                if (sFunction.equals("size")) {
                    if (this.isMapValid() ^ true) {
                        return null;
                    }
                    if (cParams > 0) {
                        sName = asParam[0];
                        if (this.getFilters().containsKey(sName)) {
                            nPage = -1;
                            if (cParams > 1) {
                                nPage = Integer.parseInt(asParam[1]);
                            }
                            setEntry = this.applyFilter(sName, true, null, nPage);
                        } else {
                            map = CacheFactory.getCache(sName);
                            setEntry = map.entrySet();
                        }
                    } else {
                        setEntry = map.entrySet();
                    }
                    cSize = setEntry.size();
                    if (fSilent ^ true) {
                        Component._trace(String.valueOf(cSize));
                    }
                    ((ThreadLocal)this.get_Sink()).set(setEntry);
                } else if (sFunction.equals("stats")) {
                    fCluster = true;
                    fP2p = false;
                    fReset = false;
                    iNext = 0;
                    if (cParams > iNext == false ? false : asParam[iNext].equals("service")) {
                        fCluster = false;
                        ++iNext;
                    } else if (cParams > iNext == false ? false : asParam[iNext].equals("p2p")) {
                        fCluster = false;
                        fP2p = true;
                        ++iNext;
                    }
                    if (cParams > iNext == false ? false : asParam[iNext].equals("reset")) {
                        fReset = true;
                    }
                    v3 = sSilent = fSilent != false ? "@" : "";
                    if (fCluster) {
                        v4 = sTarget = this.getMap() == null != false ? "&" : "&getCacheService.getService.";
                        if (fReset) {
                            this.processCommand(new StringBuilder(String.valueOf('@')).append(sTarget).append("getCluster.resetStats").toString());
                        }
                        oResult = this.processCommand(new StringBuilder(String.valueOf(sSilent)).append(sTarget).append("getCluster.formatStats").toString());
                    } else if (fP2p) {
                        v5 = sTarget = this.getMap() == null != false ? "&" : "&getCacheService.getService.";
                        if (fReset) {
                            this.processCommand(new StringBuilder(String.valueOf('@')).append(sTarget).append("getCluster.resetPointToPointStats").toString());
                        }
                        oResult = this.processCommand(new StringBuilder(String.valueOf(sSilent)).append(sTarget).append("getCluster.formatPointToPointStats").toString());
                    } else if (this.isMapValid()) {
                        if (fReset) {
                            this.processCommand("@&getCacheService.getService.resetStats");
                        }
                        oResult = this.processCommand(new StringBuilder(String.valueOf(sSilent)).append("&getCacheService.getService.formatStats [true]").toString());
                    }
                } else if (sFunction.equals("sum")) {
                    if (this.isMapValid() ^ true) {
                        return null;
                    }
                    cSum = 0;
                    cNums = 0;
                    cNots = 0;
                    iter = map.values().iterator();
                    while (iter.hasNext()) {
                        oVal = iter.next();
                        if (oVal instanceof Number) {
                            ++cNums;
                            cSum += ((Number)oVal).longValue();
                            continue;
                        }
                        if (oVal instanceof Versionable) {
                            oVer = ((Versionable)oVal).getVersionIndicator();
                            if (oVer instanceof Number) {
                                ++cNums;
                                cSum += ((Number)oVer).longValue();
                                continue;
                            }
                            ++cNots;
                            continue;
                        }
                        ++cNots;
                    }
                    if (fSilent ^ true) {
                        Component._trace(new StringBuilder(String.valueOf("sum=")).append(cSum).append(" (").append(cNums).append(" values were numbers, ").append(cNots).append(" were not)").toString());
                    }
                    oResult = cSum;
                    ((ThreadLocal)this.get_Sink()).set(oResult);
                } else if (sFunction.equals("waitkey")) {
                    if (this.isMapValid() ^ true) {
                        return null;
                    }
                    oKeyStart = aoParam[0];
                    oKeyStop = aoParam[1];
                    Component._trace(new StringBuilder(String.valueOf("waiting for key: ")).append(oKeyStart).toString());
                    while (map.containsKey(oKeyStart) ^ true) {
                        Blocking.sleep(10);
                    }
                    Component._trace(new StringBuilder(String.valueOf("waiting for key: ")).append(oKeyStop).toString());
                    lBegin = Base.getSafeTimeMillis();
                    while (map.containsKey(oKeyStop) ^ true) {
                        Blocking.sleep(10);
                    }
                    lElapsed = Base.getSafeTimeMillis() - lBegin;
                    Component._trace(new StringBuilder(String.valueOf(new Date())).append(": done (").append(lElapsed).append("ms)").toString());
                } else if (sFunction.equals("worker")) {
                    sName = null;
                    worker = null;
                    try {
                        sName = new StringBuilder(String.valueOf("Worker!")).append(Integer.parseInt(asParam[0])).toString();
                        worker = (Coherence$Worker)this._findChild(sName);
                        if (worker == null) {
                            Component._trace(new StringBuilder(String.valueOf(sName)).append(" has been terminated.").toString());
                            return null;
                        }
                        if (fSilent ^ true) {
                            Component._trace(worker.toString());
                        }
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                    if (worker == null) {
                        fWait = cParams == 1 == false ? false : asParam[0].equals("wait");
                        i = 0;
                        while (i < 1000) {
                            sName = new StringBuilder(String.valueOf("Worker!")).append(i).toString();
                            worker = (Coherence$Worker)this._findChild(sName);
                            if (worker == null) {
                                if (cParams > 0 == false ? false : fWait ^ true) {
                                    break;
                                }
                            } else if (fWait) {
                                worker.getThread().join();
                            } else if (cParams == 0) {
                                Component._trace(worker.toString());
                            }
                            ++i;
                        }
                        if ((fWait ^ true) == false ? false : cParams > 0) {
                            worker = new Coherence$Worker();
                            this._addChild((Component)worker, sName);
                            worker.setThreadName(sName);
                            worker.getQueue().add(sCmd);
                            worker.start();
                        }
                    }
                    ((ThreadLocal)this.get_Sink()).set(worker == null != false ? (Object)Coherence$Worker.getWorkerGroup() : worker);
                } else if ((sFunction.equals("begin") != false ? true : sFunction.equals("commit")) != false ? true : sFunction.equals("rollback")) {
                    if (this.isMapValid()) {
                        this.doTransaction(sFunction, asParam);
                    }
                } else if (sFunction.equals("pause")) {
                    cluster = Coherence.getSafeCluster();
                    member = (com.tangosol.coherence.component.net.Member)cluster.getLocalMember();
                    while (member.getId() == 0) {
                        Component._trace("pausing input; waiting to join cluster");
                        Blocking.sleep(1000);
                        member = (com.tangosol.coherence.component.net.Member)cluster.getLocalMember();
                    }
                    file = new File(new StringBuilder(String.valueOf("member")).append(member.getId()).toString());
                    Component._trace(new StringBuilder(String.valueOf("pausing input; create file ")).append(file).append(" to continue").toString());
                    while (file.exists() ^ true) {
                        Blocking.sleep(1000);
                    }
                    file.delete();
                } else {
                    Component._trace(new StringBuilder(String.valueOf("Unknown command: \"")).append(sFunction).append('\"').append("\nPrint \"help\" for command list").toString());
                }
            }
        }
        return oResult;
    }

    public static Object processFunction(Object target, String sFunction, boolean fSilent, Object[] aoParam) {
        boolean fLast = false;
        try {
            do {
                String sMethod = sFunction;
                int ofNext = sFunction.indexOf(46);
                if (ofNext == -1) {
                    ofNext = sFunction.length();
                    fLast = true;
                } else {
                    sMethod = sFunction.substring(0, ofNext);
                    sFunction = sFunction.substring(ofNext + 1);
                }
                int nIx = -1;
                int ofIx = sMethod.indexOf(91);
                if (ofIx != -1) {
                    nIx = Integer.parseInt(sMethod.substring(ofIx + 1, sMethod.indexOf(93)));
                    sMethod = sMethod.substring(0, ofIx);
                }
                if (sMethod.endsWith("lock") && (!(aoParam.length > 0) ? false : "*".equals(aoParam[0]))) {
                    aoParam[0] = ConcurrentMap.LOCK_ALL;
                }
                boolean fTryStatic = target instanceof Class;
                boolean fTryInstance = fTryStatic ^ true;
                if (fTryStatic) {
                    try {
                        target = ClassHelper.invokeStatic((Class)target, sMethod, fLast ? aoParam : ClassHelper.VOID);
                    }
                    catch (NoSuchMethodException e) {
                        fTryInstance = true;
                    }
                }
                if (fTryInstance) {
                    target = ClassHelper.invoke(target, sMethod, fLast ? aoParam : ClassHelper.VOID);
                }
                if (nIx >= 0) {
                    target = Array.get(target, nIx);
                }
                if (fLast) {
                    if (!(fSilent ^ true)) continue;
                    Component._trace(Coherence.toString(target));
                    continue;
                }
                if (!(target == null)) continue;
                if (!(fSilent ^ true)) break;
                Component._trace(new StringBuilder(String.valueOf("Exception: ")).append(sMethod).append(" returned null").toString());
                break;
            } while (fLast ^ true);
        }
        catch (Throwable e) {
            target = e;
            Coherence.printException(null, e);
        }
        return target;
    }

    protected String readLine(Object oReader, Object oHistory) throws Exception {
        if (oReader instanceof Reader) {
            char[] ach = new char[256];
            int cch = ((Reader)oReader).read(ach);
            return cch <= 1 ? "" : new String(ach).trim();
        }
        String sLine = (String)ClassHelper.invoke(oReader, "readLine", ClassHelper.VOID);
        ClassHelper.invoke(oHistory, "flush", ClassHelper.VOID);
        return sLine;
    }

    protected void recordCommand(String sCmd) throws InterruptedException {
        List list = this.getCommandHistory();
        if (((list == null ? true : sCmd.startsWith("history")) ? true : sCmd.startsWith("!")) ? true : (!(list.isEmpty() ^ true) ? false : list.get(list.size() - 1).equals(sCmd))) {
            return;
        }
        list.add(sCmd);
    }

    protected static void replaceSystemProperties(XmlElement xml) {
        XmlHelper.replaceSystemProperties(xml, "system-property");
    }

    public static String resolveEdition(XmlElement xmlLicense) {
        String sDescription;
        String sLicenseFile;
        String sEdition = xmlLicense.getSafeElement("edition-name").getString(DEFAULT_EDITION);
        int nEdition = 0;
        if ((sEdition.equalsIgnoreCase("ge") ? true : sEdition.equalsIgnoreCase("grid")) ? true : sEdition.equalsIgnoreCase("dge")) {
            sLicenseFile = "coherence-grid.xml";
            sEdition = DEFAULT_EDITION;
            sDescription = "Grid Edition";
            nEdition = 5;
        } else if ((sEdition.equalsIgnoreCase("ee") ? true : sEdition.equalsIgnoreCase("enterprise")) ? true : sEdition.equalsIgnoreCase("ae")) {
            sLicenseFile = "coherence-enterprise.xml";
            sEdition = "EE";
            sDescription = "Enterprise Edition";
            nEdition = 4;
        } else if ((sEdition.equalsIgnoreCase("ce") ? true : sEdition.equalsIgnoreCase("community")) ? true : sEdition.equalsIgnoreCase("ce")) {
            sLicenseFile = "coherence-community.xml";
            sEdition = "CE";
            sDescription = "Community Edition";
            nEdition = 3;
        } else if (sEdition.equalsIgnoreCase("se") ? true : sEdition.equalsIgnoreCase("standard")) {
            sLicenseFile = "coherence-standard.xml";
            sEdition = "SE";
            sDescription = "Standard Edition";
            nEdition = 2;
        } else if (((sEdition.equalsIgnoreCase("rtc") ? true : sEdition.equalsIgnoreCase("realtime")) ? true : sEdition.equalsIgnoreCase("cc")) ? true : sEdition.equalsIgnoreCase("compute")) {
            sLicenseFile = "coherence-rtc.xml";
            sEdition = "RTC";
            sDescription = "Real-Time Client";
            nEdition = 1;
        } else if (sEdition.equalsIgnoreCase("dc") ? true : sEdition.equalsIgnoreCase("client")) {
            sLicenseFile = "coherence-client.xml";
            sEdition = "DC";
            sDescription = "Data Client";
            nEdition = 0;
        } else {
            String sErrorMsg = new StringBuilder(String.valueOf("Invalid \"edition-name\" specified: \"")).append(sEdition).append("\" (valid editions are GE/EE/SE/RTC/DC)").toString();
            Component._trace(sErrorMsg, 1);
            throw new RuntimeException(sErrorMsg);
        }
        Coherence.loadLicenses(xmlLicense, sLicenseFile);
        LicensedObject.LicenseData[] aLicense = LicensedObject.getLicenseData();
        Component._assert(aLicense != null);
        Coherence app = (Coherence)Coherence.get_Instance();
        app.setEdition(nEdition);
        app.setProduct(new StringBuilder(String.valueOf(TITLE)).append(' ').append(sEdition).toString());
        xmlLicense.ensureElement("edition-name").setString(sEdition);
        return sDescription;
    }

    protected static String resolveMode(XmlElement xmlLicense) {
        String sDescription;
        int nMode = 0;
        String sMode = xmlLicense.getSafeElement("license-mode").getString(DEFAULT_MODE);
        switch (sMode.length() > 0 ? (int)sMode.charAt(0) : 63) {
            case 69: 
            case 101: {
                nMode = 0;
                sDescription = "Evaluation";
                break;
            }
            case 68: 
            case 100: {
                nMode = 1;
                sDescription = "Development";
                break;
            }
            case 80: 
            case 112: {
                nMode = 2;
                sDescription = "Production";
                break;
            }
            default: {
                String sErrorMsg = new StringBuilder(String.valueOf("Invalid \"mode\" specified: \"")).append(sMode).append("\" (valid modes are eval/dev/prod)").toString();
                Component._trace(sErrorMsg, 1);
                throw new RuntimeException(sErrorMsg);
            }
        }
        sMode = MODE_NAMES[nMode];
        ((Coherence)Coherence.get_Instance()).setMode(nMode);
        xmlLicense.ensureElement("license-mode").setString(sMode);
        return sDescription;
    }

    public void run() {
        super.run();
        String sCmd = "";
        String[] asArg = Application.getArgument();
        if (asArg.length > 0) {
            sCmd = asArg[0].startsWith("@") ? asArg[0].substring(1) : new StringBuilder(String.valueOf("cache ")).append(asArg[0]).toString();
            int i = 1;
            int c = asArg.length;
            while (i < c) {
                sCmd = new StringBuilder(String.valueOf(sCmd)).append(new StringBuilder(String.valueOf(' ')).append(asArg[i]).toString()).toString();
                ++i;
            }
            CacheFactory.getCluster();
        } else {
            CacheFactory.ensureCluster();
        }
        Object oReader = this.createReader();
        Object oHistory = this.getHistory(oReader);
        this.ensureRunningLogger().setPrompt("?");
        while (true) {
            if (sCmd.length() > 0) {
                try {
                    this.recordCommand(sCmd);
                    this.processCommand(sCmd);
                }
                catch (Throwable e) {
                    Coherence.printException(null, e);
                }
            }
            if (this.isStop()) {
                this.setStop(false);
                return;
            }
            try {
                Coherence$Logger logger = this.getLogger();
                Blocking.sleep(50);
                logger.setCommandPrompt(true);
                sCmd = this.readLine(oReader, oHistory);
                logger.setCommandPrompt(false);
                logger.setPendingLineFeed(false);
                continue;
            }
            catch (IOException e) {
                System.out.println(new StringBuilder(String.valueOf("Shutting down due to ")).append(e).toString());
                CacheFactory.shutdown();
                this.setStop(true);
                return;
            }
            catch (Exception e) {
                System.out.println(new StringBuilder(String.valueOf("resetting reader due to ")).append(e).toString());
                oReader = this.createReader();
                sCmd = "";
                this.ensureRunningLogger();
                continue;
            }
            break;
        }
    }

    protected static void setBuildNumber(String s) {
        __s_BuildNumber = s;
    }

    protected static void setCluster(SafeCluster cluster) {
        __s_Cluster = cluster;
    }

    protected void setCommandHistory(List list) {
        this.__m_CommandHistory = list;
    }

    protected static void setConfigurationLoaded(boolean fLoaded) {
        __s_ConfigurationLoaded = fLoaded;
    }

    private void setEdition(int nEdition) {
        this.__m_Edition = nEdition;
    }

    protected void setFilters(Map map) {
        this.__m_Filters = map;
    }

    private static void setLicenseLoaded(boolean fLoaded) {
        if (fLoaded) {
            __s_LicenseLoaded = fLoaded;
        }
    }

    public void setLogger(Coherence$Logger logger) {
        Coherence$Logger loggerPrev;
        AtomicReference refLogger = this.getLoggerRef();
        do {
            if (!((loggerPrev = (Coherence$Logger)refLogger.get()) == logger)) continue;
            return;
        } while (!refLogger.compareAndSet(loggerPrev, logger));
        if (loggerPrev != null) {
            loggerPrev.shutdown();
        }
    }

    protected void setLoggerRef(AtomicReference logger) {
        this.__m_LoggerRef = logger;
    }

    protected void setMap(NamedCache map) {
        this.__m_Map = map;
    }

    private void setMode(int nMode) {
        this.__m_Mode = nMode;
    }

    public void setPersistenceToolsHelper(PersistenceToolsHelper helperTools) {
        this.__m_PersistenceToolsHelper = helperTools;
    }

    protected void setProduct(String sProduct) {
        Component._assert(this.getProduct() == null ? true : this.getProduct().equals(sProduct));
        this.__m_Product = sProduct;
        this.getLogger().setLogParameters(null);
    }

    protected void setScript(boolean fScript) {
        this.__m_Script = fScript;
    }

    protected void setScriptEngine(ScriptEngine engine) {
        this.__m_ScriptEngine = engine;
    }

    protected void setService(CacheService service) {
        this.__m_Service = service;
    }

    public static void setServiceConfig(String sServiceType, XmlElement xmlCfg) {
        SafeCluster cluster;
        Coherence app;
        Coherence$Logger logger;
        if (Coherence.getServiceConfig(sServiceType) == null) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("Unknown service type: ")).append(sServiceType).toString());
        }
        Coherence.getServiceConfigMap().put(sServiceType, xmlCfg.clone());
        if ("$Logger".equals(sServiceType) && (logger = (app = (Coherence)Coherence.get_Instance()).getLogger()).isStarted()) {
            app.setLogger(null);
        }
        if ("$Management".equals(sServiceType) && (cluster = Coherence.getSafeCluster()).isRunning() ^ true) {
            Gateway mgmt = Gateway.createGateway(LegacyXmlGatewayHelper.fromXml(xmlCfg, new DefaultGatewayDependencies()), cluster);
            cluster.setManagement(mgmt);
        }
    }

    protected static void setServiceConfigMap(Map map) {
        __s_ServiceConfigMap = map;
    }

    protected void setStop(boolean fStop) {
        this.__m_Stop = fStop;
    }

    private static void setTloCluster(ThreadLocal tloCluster) {
        __s_TloCluster = tloCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        SafeCluster cluster;
        block12: {
            Class clazz = Coherence.get_CLASS();
            synchronized (clazz) {
                cluster = Coherence.getCluster();
            }
            try {
                if (!(cluster != null)) break block12;
                cluster.dispose();
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                Class clazz2 = Coherence.get_CLASS();
                synchronized (clazz2) {
                    if (Coherence.getCluster() == cluster) {
                        Coherence.setCluster(null);
                        Coherence.getServiceConfigMap().clear();
                        Coherence.setConfigurationLoaded(false);
                        ((Coherence)Coherence.get_Instance()).setLogger(null);
                    }
                }
                throw throwable;
            }
        }
        Object var2_4 = null;
        Class clazz = Coherence.get_CLASS();
        synchronized (clazz) {
            if (Coherence.getCluster() == cluster) {
                Coherence.setCluster(null);
                Coherence.getServiceConfigMap().clear();
                Coherence.setConfigurationLoaded(false);
                ((Coherence)Coherence.get_Instance()).setLogger(null);
            }
        }
    }

    public static String toString(Object oResult) {
        int MAX_TRACE = 50;
        String BEGIN = " {\n ";
        String NEXT = "\n ";
        String END = "\n }";
        Class<?> clzArrayType = oResult == null ? null : oResult.getClass().getComponentType();
        if (clzArrayType == null) {
            if (oResult instanceof Iterator) {
                StringBuffer sb = new StringBuffer();
                sb.append(oResult.getClass().getName());
                Iterator iter = (Iterator)oResult;
                if (iter.hasNext()) {
                    sb.append(BEGIN);
                    int i = 0;
                    while (!iter.hasNext() ? false : i < MAX_TRACE) {
                        sb.append(Coherence.toString(iter.next()));
                        if (iter.hasNext()) {
                            sb.append(NEXT);
                        }
                        ++i;
                    }
                    if (iter.hasNext()) {
                        sb.append("...");
                    }
                    sb.append(END);
                }
                return sb.toString();
            }
            if (oResult instanceof Enumeration) {
                StringBuffer sb = new StringBuffer();
                sb.append(oResult.getClass().getName()).append(BEGIN);
                Enumeration enumeration = (Enumeration)oResult;
                int i = 0;
                while (!enumeration.hasMoreElements() ? false : i < MAX_TRACE) {
                    sb.append(Coherence.toString(enumeration.nextElement()));
                    if (enumeration.hasMoreElements()) {
                        sb.append(NEXT);
                    }
                    ++i;
                }
                if (enumeration.hasMoreElements()) {
                    sb.append("...");
                }
                sb.append(END);
                return sb.toString();
            }
            if (oResult instanceof Class) {
                return Base.toString((Class)oResult);
            }
            return String.valueOf(oResult);
        }
        int c = Array.getLength(oResult);
        StringBuffer sb = new StringBuffer();
        sb.append(clzArrayType.getName()).append('[').append(c).append(']');
        if (c > 0) {
            sb.append(BEGIN);
            int cTrace = Math.min(c, MAX_TRACE);
            int i = 0;
            while (i < cTrace) {
                if (i > 0) {
                    sb.append(NEXT);
                }
                sb.append(Coherence.toString(Array.get(oResult, i)));
                ++i;
            }
            if (c > cTrace) {
                sb.append(", ...");
            }
            sb.append(END);
        }
        return sb.toString();
    }

    protected void txEnd() {
        NamedCache map = this.getMap();
        if (map instanceof TransactionMap) {
            NamedCache cache = (NamedCache)((TransactionMap)((Object)map)).getBaseMap();
            this.setMap(cache);
            Coherence$Logger logger = this.getLogger();
            logger.setPrompt(logger.getPrompt().substring(3));
        }
    }

    protected void txStart(int nConcur, int nIsolation, int nTimeout) {
        TransactionMap mapTx;
        NamedCache map = this.getMap();
        if (map instanceof TransactionMap) {
            mapTx = (TransactionMap)((Object)map);
        } else {
            mapTx = CacheFactory.getLocalTransaction(map);
            mapTx.setConcurrency(nConcur);
            mapTx.setTransactionIsolation(nIsolation);
            mapTx.setTransactionTimeout(nTimeout);
            mapTx.setValidator(new SimpleValidator());
            this.setMap((NamedCache)((Object)mapTx));
            Coherence$Logger logger = this.getLogger();
            logger.setPrompt(new StringBuilder(String.valueOf("Tx-")).append(logger.getPrompt()).toString());
        }
        mapTx.begin();
    }

    protected static void validateEnvironment() {
        String sVMName = System.getProperty("java.vm.name", "");
        String sOSName = System.getProperty("os.name", "");
        String sOSArch = System.getProperty("os.arch", "");
        String sDataModel = System.getProperty("sun.arch.data.model", "");
        if (!(!(!(!(sOSName.indexOf("SunOS") != -1) ? false : sOSArch.indexOf("sparc") != -1) ? false : sVMName.indexOf("HotSpot") != -1) ? false : sVMName.indexOf("Client VM") != -1) ? false : sDataModel.equals("32")) {
            String sMsg = new StringBuilder(String.valueOf("Coherence requires the 32-bit Hotspot JVM to be run in ")).append("server mode on Solaris-sparc. Include the '-server' option on ").append("the command line to run the server JVM.").toString();
            Component._trace(sMsg, 1);
            throw new RuntimeException(sMsg);
        }
    }
}

