/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$ClusterService;
import com.tangosol.coherence.component.net.Cluster$NameService$RequestContext;
import com.tangosol.coherence.component.net.Cluster$NameService$TcpAcceptor;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.net.management.Connector$LookupCallback;
import com.tangosol.coherence.component.util.NameService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$LookupCallback;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.io.nio.ByteBufferInputStream;
import com.tangosol.net.Member;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionFilter;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;

public class Cluster$NameService
extends NameService
implements ConnectionFilter {
    private ServerSocket __m_ClusterSocket;
    private static ListMap __mapChildren;

    static {
        Cluster$NameService.__initStatic();
    }

    public Cluster$NameService() {
        this(null, null, true);
    }

    public Cluster$NameService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBinderMap(new ConcurrentHashMap());
            this.setDirectory(new ConcurrentHashMap());
            this.setLookupCallbacks(new SafeLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Cluster$NameService$TcpAcceptor("TcpAcceptor", this, true), "TcpAcceptor");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("RequestContext", Cluster$NameService$RequestContext.get_CLASS());
    }

    public void checkConnection(Connection connection) throws ConnectionException {
        if (connection instanceof TcpAcceptor$TcpConnection) {
            TcpAcceptor$TcpConnection connectionImpl = (TcpAcceptor$TcpConnection)connection;
            String sService = connectionImpl.getServiceName();
            if (!(sService != null) ? false : sService.equals(this.getServiceName()) ^ true) {
                throw new ConnectionException("connection rejected, service mismatch");
            }
            String sCluster = connectionImpl.getClusterName();
            if (!(sCluster != null) ? false : sCluster.equals(this.getCluster().getClusterName()) ^ true) {
                try {
                    Integer nPort = (Integer)this.lookup(new StringBuilder(String.valueOf("Cluster/foreign/")).append(sCluster).append("/NameService/localPort").toString());
                    if (nPort != null) {
                        Object[] addrRedirect = new Object[]{connectionImpl.getSocket().getLocalAddress().getHostAddress(), MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_NAME_SERVICE.getPort(nPort)};
                        connectionImpl.setRedirect(true);
                        connectionImpl.setRedirectList(Collections.singletonList(addrRedirect));
                    }
                }
                catch (NamingException e) {
                    // empty catch block
                }
                throw new ConnectionException("connection rejected, cluster mismatch");
            }
        }
    }

    public ServerSocket getClusterSocket() {
        return this.__m_ClusterSocket;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster$NameService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Cluster$NameService();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void halt() {
        try {
            TcpUtil.close(this.getClusterSocket());
            TcpUtil.close(this.getAcceptor().getProcessor().getServerSocket());
        }
        catch (Throwable throwable) {}
    }

    public boolean isStarted() {
        return this.getAcceptor().isStarted();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onDatagramLookup(DatagramSocket socketIn, SocketAddress addrSrc, ByteBuffer buffer) {
        boolean bl;
        Cluster cluster = (Cluster)this.get_Module();
        try {
            block13: {
                try {
                    Cluster$ClusterService service = cluster.getClusterService();
                    ByteBuffer bufClusterName = cluster.getClusterNameBuffer();
                    int nPos = buffer.position();
                    int nLim = buffer.limit();
                    int cbRequest = buffer.remaining();
                    DataInputStream in = new DataInputStream(new ByteBufferInputStream(buffer));
                    in.readInt();
                    String sClusterName = in.readUTF();
                    if (sClusterName.isEmpty() ? true : sClusterName.equals(cluster.getClusterName())) {
                        int cAttempt = in.readUnsignedByte();
                        int cLimit = in.readUnsignedByte();
                        int cbAddr = in.readUnsignedByte();
                        if (!(!(!((cbAddr == 0 ? true : cbAddr == 4) ? true : cbAddr == 16) ? false : service.isAcceptingClients()) ? false : cAttempt != 0) ? false : (service.getClusterOldestMember() == service.getThisMember() ? true : cAttempt >= Math.min(3, cLimit / 3))) {
                            int nPort;
                            InetAddress addr;
                            if (cbAddr == 0) {
                                in.readInt();
                                InetSocketAddress addrSrcInet = (InetSocketAddress)addrSrc;
                                addr = addrSrcInet.getAddress();
                                nPort = addrSrcInet.getPort();
                            } else {
                                byte[] abAddr = new byte[cbAddr];
                                in.readFully(abAddr);
                                addr = InetAddress.getByAddress(abAddr);
                                nPort = in.readInt();
                            }
                            String sKey = in.readUTF();
                            Binary binMember = new Binary(in);
                            Member memberClient = binMember.length() == 0 ? null : (Member)ExternalizableHelper.fromBinary(binMember, this.getSerializer());
                            InetSocketAddress addrThis = service.getThisMember().getSocketAddress();
                            Cluster$NameService$RequestContext context = new Cluster$NameService$RequestContext();
                            context.setMember(memberClient);
                            context.setAcceptAddress(addrThis.getAddress());
                            context.setSourceAddress(addr);
                            Object oResult = this.lookup(sKey, context);
                            Binary binResult = oResult == null ? null : ExternalizableHelper.toBinary(oResult, this.getSerializer());
                            byte[] abAddrThis = addrThis.getAddress().getAddress();
                            ByteArrayOutputStream outBytes = new ByteArrayOutputStream(cbRequest + (binResult == null ? 0 : binResult.length()));
                            DataOutputStream out = new DataOutputStream(outBytes);
                            out.writeInt(Packet.TYPE_NAME_SERVICE);
                            out.write(bufClusterName.array());
                            out.write(0);
                            out.write(0);
                            out.write(abAddrThis.length);
                            out.write(abAddrThis);
                            out.writeInt(addrThis.getPort());
                            out.writeUTF(sKey);
                            if (binResult == null) {
                                out.writeInt(0);
                            } else if (binResult.length() > 1024) {
                                out.writeInt(-1);
                            } else {
                                binResult.writeExternal(out);
                            }
                            out.flush();
                            byte[] abReply = outBytes.toByteArray();
                            socketIn.send(new DatagramPacket(abReply, abReply.length, addr, nPort));
                        }
                        break block13;
                    }
                    ((Buffer)buffer).position(nPos).limit(nLim);
                    cluster.onForeignPacket(socketIn, addrSrc, buffer);
                    return;
                }
                catch (Exception e) {
                    Component._trace(new StringBuilder(String.valueOf("Failure while parsing NS datagram lookup request, dropping request ")).append(e).toString(), 3);
                    Component._trace(e);
                }
            }
            Object var6_8 = null;
            if (buffer == null) {
                return;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!(buffer != null)) throw throwable;
            cluster.getReceiver().getBufferManager().release(buffer);
            throw throwable;
        }
        if (!bl) return;
        cluster.getReceiver().getBufferManager().release(buffer);
    }

    public void onInit() {
        super.onInit();
        this.addLookupCallback((Cluster)this.get_Module());
        this.addLookupCallback(new ProxyService$LookupCallback());
        this.addLookupCallback(new Connector$LookupCallback());
        ((Cluster$NameService$TcpAcceptor)this._findChild("TcpAcceptor")).setConnectionFilter(this);
    }

    public void setClusterSocket(ServerSocket socketCluster) {
        this.__m_ClusterSocket = socketCluster;
    }

    public boolean tryClusterBind() {
        ServerSocketChannel channel = null;
        try {
            Cluster$NameService$TcpAcceptor acceptor = (Cluster$NameService$TcpAcceptor)this.getAcceptor();
            SocketProvider provider = acceptor.getSocketProvider();
            channel = provider.openServerSocketChannel();
            channel.configureBlocking(false);
            ServerSocket socket = channel.socket();
            acceptor.getSocketOptions().apply(socket);
            socket.bind(new InetSocketAddress32(this.getLocalAddress(), MultiplexedSocketProvider.WellKnownSubPorts.COHERENCE_NAME_SERVICE.getPort(((Cluster)this.get_Module()).getDependencies().getGroupPort())));
            channel.register(acceptor.getProcessor().getSelector(), SelectionKey.OP_ACCEPT);
            Component._trace(new StringBuilder(String.valueOf("NameService now listening for connections on ")).append(provider.getAddressString(socket)).toString(), 3);
            this.setClusterSocket(socket);
            return true;
        }
        catch (IOException e) {
            TcpUtil.close(channel);
            return false;
        }
    }
}

