/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetAddressComparator;
import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$NameServiceBridge$InterruptTask;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteNameService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator$TcpConnection;
import com.tangosol.net.messaging.Channel;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.WrapperException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;

public class Cluster$NameServiceBridge
extends RemoteNameService {
    private volatile boolean __m_ForeignBroadcastBound;
    private volatile boolean __m_ForeignNSBound;
    private static ListMap __mapChildren;

    static {
        Cluster$NameServiceBridge.__initStatic();
    }

    public Cluster$NameServiceBridge() {
        this(null, null, true);
    }

    public Cluster$NameServiceBridge(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMemberListeners(new Listeners());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setServiceListeners(new Listeners());
            this.setServiceName("NameServiceBridge");
            this.setServiceVersion("1");
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("InterruptTask", Cluster$NameServiceBridge$InterruptTask.get_CLASS());
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster$NameServiceBridge".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Cluster$NameServiceBridge();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void halt() {
        try {
            ((TcpInitiator$TcpConnection)((TcpInitiator)this.getInitiator()).getConnection()).close();
        }
        catch (Throwable throwable) {}
    }

    public boolean isForeignBroadcastBound() {
        return this.__m_ForeignBroadcastBound;
    }

    public boolean isForeignNSBound() {
        return this.__m_ForeignNSBound;
    }

    public boolean isFullyBound() {
        return !this.isForeignBroadcastBound() ? false : this.isForeignNSBound();
    }

    protected synchronized void setChannel(Channel channel) {
        this.setForeignBroadcastBound(false);
        this.setForeignNSBound(false);
        super.setChannel(channel);
    }

    protected void setForeignBroadcastBound(boolean fBound) {
        this.__m_ForeignBroadcastBound = fBound;
    }

    protected void setForeignNSBound(boolean fBound) {
        this.__m_ForeignNSBound = fBound;
    }

    public synchronized void start() {
        if (this.isRunning() ^ true) {
            this.doStart();
        }
    }

    public boolean tryForeignBind() {
        block26: {
            if (this.isFullyBound()) {
                return true;
            }
            Cluster cluster = (Cluster)this.get_Module();
            boolean fJoined = cluster.getClusterService().getState() >= ClusterService.STATE_JOINED;
            try {
                if (this.isRunning() ^ true) {
                    this.start();
                }
                String sNameThis = cluster.getClusterName();
                String sNameOther = (String)this.lookup("Cluster/name");
                InetAddress addrDiscThis = cluster.getDependencies().getLocalDiscoveryAddress();
                InetAddress addrDiscThat = (InetAddress)this.lookup("Cluster/localDiscoveryInetAddress");
                InetAddress addrNSThis = cluster.getNameService().getLocalAddress();
                InetAddress addrNSThat = (InetAddress)this.lookup("NameService/localInetAddress");
                boolean fIpv4This = InetAddresses.PreferIPv4Stack;
                Boolean FIpv4That = (Boolean)this.lookup("Cluster/IPv4Stack");
                if (sNameThis.equals(sNameOther)) {
                    if (fJoined) {
                        this.setForeignBroadcastBound(true);
                        this.setForeignNSBound(true);
                        return true;
                    }
                    if (Base.equals(this.lookup("Cluster/multicastInetAddress"), cluster.getClusterService().isWkaEnabled() ? null : cluster.getDependencies().getGroupAddress()) ^ true) {
                        Component._trace(new StringBuilder(String.valueOf("there appears to be other members of the cluster '")).append(sNameOther).append("' already running with an incompatible network configuration, aborting join with ").append(this.lookup("Cluster/info")).toString(), 1);
                        cluster.getClusterService().onStopJoining();
                    } else {
                        cluster.getClusterService().resetBroadcastCounter(new StringBuilder(String.valueOf("there appears to be other members of the cluster '")).append(sNameOther).append("' already running likely with an incompatible network configuration, retrying to join with ").append(this.lookup("Cluster/info")).toString(), null);
                    }
                    break block26;
                }
                if (cluster.isClusterPortSharingEnabled() ^ true) {
                    Component._trace(new StringBuilder(String.valueOf("this cluster '")).append(sNameThis).append("' does not support port sharing and there is another cluster '").append(sNameOther).append("' already bound to the cluster port '").append(cluster.getDependencies().getGroupPort()).append("' on this machine. ").append(this.lookup("Cluster/info")).toString(), 1);
                    if (fJoined) {
                        cluster.getClusterService().onStopRunning();
                    } else {
                        cluster.getClusterService().onStopJoining();
                    }
                    return false;
                }
                if (InetAddressComparator.INSTANCE.compare(addrDiscThis, addrDiscThat) != 0) {
                    Component._trace(new StringBuilder(String.valueOf("this cluster '")).append(sNameThis).append("' is configured with a local discovery address of '").append(addrDiscThis).append("' which is not compatible with ").append("cluster '").append(sNameOther).append("' which is using '").append(addrDiscThat).append("' and currently hosting the shared cluster port '").append(cluster.getDependencies().getGroupPort()).append("', in order to share a cluster port the discovery addresses must be equal. ").append(this.lookup("Cluster/info")).toString(), 1);
                    if (fJoined) {
                        cluster.getClusterService().onStopRunning();
                    } else {
                        cluster.getClusterService().onStopJoining();
                    }
                    return false;
                }
                if (InetAddressComparator.INSTANCE.compare(addrNSThis, addrNSThat) != 0) {
                    Component._trace(new StringBuilder(String.valueOf("this cluster '")).append(sNameThis).append("' is configured with a local NameService address of '").append(addrNSThis).append("' which is not compatible with ").append("cluster '").append(sNameOther).append("' which is using '").append(addrNSThat).append("' and currently hosting the shared cluster port '").append(cluster.getDependencies().getGroupPort()).append("', in order to share a cluster port the NameService addresses must be equal. ").append(this.lookup("Cluster/info")).toString(), 1);
                    if (fJoined) {
                        cluster.getClusterService().onStopRunning();
                    } else {
                        cluster.getClusterService().onStopJoining();
                    }
                    return false;
                }
                if (!(FIpv4That == null ? true : FIpv4That ^ fIpv4This) ? false : (addrDiscThis.isAnyLocalAddress() ? true : addrNSThis.isAnyLocalAddress())) {
                    Component._trace(new StringBuilder(String.valueOf("this JVM for cluster '")).append(sNameThis).append("' is").append(fIpv4This ? " not" : "").append(" configured to allow IPv6 which differs from the configurtion").append(" of the local JVM for cluster '").append(sNameOther).append("' which is currently hosting the shared cluster port. In order to share a cluster port this setting must be equal. ").append("The java.net.preferIPv4Stack system propery can be used to restrict IPv6 support. ").append(this.lookup("Cluster/info")).toString(), 1);
                    if (fJoined) {
                        cluster.getClusterService().onStopRunning();
                    } else {
                        cluster.getClusterService().onStopJoining();
                    }
                    return false;
                }
                String sBindPoint = null;
                try {
                    if (this.isForeignBroadcastBound() ^ true) {
                        InetSocketAddress addrLocal = (InetSocketAddress)cluster.getSocketManager().getUnicastUdpSocket().getDatagramSocket().getLocalSocketAddress();
                        if (addrLocal.getAddress().isAnyLocalAddress()) {
                            addrLocal = new InetSocketAddress(InetAddress.getLoopbackAddress(), addrLocal.getPort());
                        }
                        sBindPoint = new StringBuilder(String.valueOf("Cluster/foreign/")).append(sNameThis).append("/Cluster/localAddress").toString();
                        this.bind(sBindPoint, addrLocal);
                        this.bind(new StringBuilder(String.valueOf("Cluster/foreign/")).append(sNameThis).append("/Cluster/announceVersion").toString(), ClusterService.ANNOUNCE_PROTOCOL_VERSION);
                        this.setForeignBroadcastBound(true);
                    }
                    if (!fJoined ? false : this.isForeignNSBound() ^ true) {
                        sBindPoint = new StringBuilder(String.valueOf("Cluster/foreign/")).append(sNameThis).append("/NameService/localPort").toString();
                        this.bind(sBindPoint, MultiplexedSocketProvider.getBasePort(cluster.getNameService().getAcceptor().getProcessor().getServerSocket().getLocalPort()));
                        this.setForeignNSBound(true);
                    }
                    return true;
                }
                catch (Exception e) {
                    if (!(fJoined ^ true)) break block26;
                    Object oBind = this.lookup(sBindPoint);
                    if (oBind == null) {
                        cluster.getClusterService().resetBroadcastCounter(new StringBuilder(String.valueOf("there is another cluster '")).append(sNameOther).append("' already bound to the cluster port '").append(cluster.getDependencies().getGroupPort()).append("' on this machine and it does not appear to support port sharing.  ").append(this.lookup("Cluster/info")).toString(), null);
                        break block26;
                    }
                    cluster.getClusterService().resetBroadcastCounter(new StringBuilder(String.valueOf("there appears to be other member of the cluster '")).append(sNameOther).append("' already running likely with an incompatible network configuration, retrying to join with ").append(oBind).toString(), null);
                }
            }
            catch (Exception e) {
                if (!(fJoined ^ true)) break block26;
                int nPort = cluster.getDependencies().getGroupPort();
                cluster.getClusterService().resetBroadcastCounter(new StringBuilder(String.valueOf("there appears to be an unresponsive or non-Coherence ")).append("process bound to the cluster-port '").append(nPort).append("' on this machine, retrying join after ").append(e).append(InetAddresses.isEphemeral(nPort) ? new StringBuilder(String.valueOf(". The port '")).append(nPort).append("' appears to be in the ").append("ephemeral port range on this machine and thus may have been randomly assigned to another process. See ").append("your OS documentation on how to check the range and either adjust the range or your cluster port ").append("selection such that the port is outside the ephemeral range.").toString() : "").toString(), null);
            }
        }
        return false;
    }
}

