/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.coherence.common.internal.util.LoggingBridge;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.exabus.Depot;
import com.oracle.coherence.common.net.exabus.spi.Driver;
import com.oracle.coherence.common.net.exabus.util.SimpleDepot;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$SocketManager$AcceptorChannel;
import com.tangosol.coherence.component.net.Cluster$SocketManager$BroadcastTcpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$BroadcastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$PreferredUnicastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.DatagramSocketProvider;
import com.tangosol.net.TcpDatagramSocket;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Cluster$SocketManager
extends Util {
    private volatile transient Depot __m_Depot;
    private SocketProvider __m_TcpRingSocketProvider;
    private DatagramSocketProvider __m_UnicastUdpSocketProvider;

    public Cluster$SocketManager() {
        this(null, null, true);
    }

    public Cluster$SocketManager(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new Cluster$SocketManager$AcceptorChannel("AcceptorChannel", this, true), "AcceptorChannel");
        this._addChild(new Cluster$SocketManager$BroadcastTcpSocket("BroadcastTcpSocket", this, true), "BroadcastTcpSocket");
        this._addChild(new Cluster$SocketManager$BroadcastUdpSocket("BroadcastUdpSocket", this, true), "BroadcastUdpSocket");
        this._addChild(new Cluster$SocketManager$PreferredUnicastUdpSocket("PreferredUnicastUdpSocket", this, true), "PreferredUnicastUdpSocket");
        this._addChild(new Cluster$SocketManager$UnicastUdpSocket("UnicastUdpSocket", this, true), "UnicastUdpSocket");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void bindSockets() throws IOException {
        String sAddr;
        Cluster cluster = (Cluster)this.get_Module();
        ClusterDependencies config = cluster.getDependencies();
        Cluster$SocketManager$AcceptorChannel acceptorChannel = this.getAcceptorChannel();
        Cluster$SocketManager$UnicastUdpSocket udpSocket = this.getUnicastUdpSocket();
        InetAddress addrInet = udpSocket.getInetAddress();
        DatagramSocketProvider provider = this.getUnicastUdpSocketProvider();
        boolean fTransportSvc = cluster.isTransportServiceEnabled();
        boolean fBound = false;
        if (InetAddresses.isLocalAddress(addrInet) ^ true) {
            throw new IOException(new StringBuilder(String.valueOf(addrInet)).append(" is not a local address").toString());
        }
        int nPort = config.getLocalPort();
        if (!(!(!(nPort == 0) ? false : config.getGroupPort() != 8088) ? false : config.getWellKnownAddresses() != null) ? false : cluster.getClusterService().getWellKnownAddresses().contains(new InetSocketAddress(addrInet, 8088))) {
            nPort = 8088;
        }
        IOException eLast = null;
        int nPortMin = nPort;
        int nPortAdjustMax = config.isLocalPortAutoAdjust() ? config.getLocalPortAutoAdjust() : nPort + (fTransportSvc ? 0 : 1);
        fBound = false;
        do {
            ServerSocketChannel channelTcp = null;
            try {
                acceptorChannel.setPort(nPort);
                channelTcp = acceptorChannel.instantiateChannel();
                acceptorChannel.setChannel(channelTcp);
                acceptorChannel.open();
                fBound = true;
            }
            catch (IOException e1) {
                eLast = e1;
                if (!(channelTcp != null)) continue;
                try {
                    channelTcp.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
        } while (!(!(fBound ^ true) ? false : nPort != 0) ? false : ++nPort <= nPortAdjustMax);
        if (fBound) {
            fBound = false;
            try {
                udpSocket.setPort(nPort == 0 ? acceptorChannel.getPort() : nPort);
                udpSocket.open();
                fBound = true;
            }
            catch (IOException e1) {
                eLast = e1;
                nPort = nPortMin;
                while (true) {
                    try {
                        udpSocket.setPort(nPort);
                        udpSocket.open();
                        fBound = true;
                    }
                    catch (IOException e2) {
                        eLast = e2;
                        if (!(!(fBound ^ true) ? false : nPort != 0) ? false : ++nPort <= nPortAdjustMax) continue;
                    }
                    break;
                }
            }
        }
        if (!fBound ? false : fTransportSvc ^ true) {
            fBound = false;
            if (!(nPort > 0) ? false : nPort < nPortAdjustMax) {
                ++nPort;
            }
            Cluster$SocketManager$PreferredUnicastUdpSocket udpSocketPref = this.getPreferredUnicastUdpSocket();
            do {
                try {
                    udpSocketPref.setPort(nPort);
                    udpSocketPref.open();
                    fBound = true;
                }
                catch (IOException e1) {
                    eLast = e1;
                }
            } while (!(!(fBound ^ true) ? false : nPort != 0) ? false : ++nPort <= nPortAdjustMax);
        }
        if (fBound) {
            InetSocketAddress addrBind = (InetSocketAddress)udpSocket.getDatagramSocket().getLocalSocketAddress();
            sAddr = addrBind.toString();
            if (addrBind.getAddress().isAnyLocalAddress()) {
                try {
                    sAddr = new StringBuilder(String.valueOf(InetAddress.getLocalHost().getHostName())).append(":").append(addrBind.getPort()).toString();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
        } else {
            if (config.isLocalPortAutoAdjust()) {
                throw new IOException(new StringBuilder(String.valueOf(provider)).append(" unable to find available port(s) within ").append(nPortMin).append("..").append(Math.max(0, nPort - 1)).toString(), eLast);
            }
            throw new IOException(new StringBuilder(String.valueOf(provider)).append(" failed to bind to configured port ").append(nPortMin).append(". Note, that port auto-adjust feature has been explicitly disabled").toString(), eLast);
        }
        Component._trace(new StringBuilder(String.valueOf("TCMP bound to ")).append(sAddr).append(" using ").append(provider).toString(), 3);
        if (cluster.getClusterService().getWellKnownAddresses() == null) {
            this.getBroadcastUdpSocket().open();
        }
    }

    public void configure(DatagramSocket socket) throws IOException {
        ClusterDependencies config = ((Cluster)this.get_Module()).getDependencies();
        if (socket instanceof TcpDatagramSocket) {
            TcpDatagramSocket datagram = (TcpDatagramSocket)socket;
            datagram.setPacketMagic(0xDDF00D0, -16);
            datagram.setSocketOptions(config.getTcpDatagramSocketOptions());
            datagram.setListenBacklog(config.getTcpBacklog());
        } else if (socket instanceof MulticastSocket) {
            MulticastSocket socketMulti = (MulticastSocket)socket;
            InetAddress addrUnicast = this.getUnicastUdpSocket().getInetAddress();
            socketMulti.setTimeToLive(config.getGroupTimeToLive());
            InetAddress addrGroup = config.getGroupInterface();
            if (!(!(addrGroup != null) ? false : addrGroup.isAnyLocalAddress() ^ true)) {
                addrGroup = (config.getPublisherGroupThreshold() < 100 ? true : addrUnicast.isLoopbackAddress()) ? addrUnicast : null;
            }
            if (!(addrGroup != null) ? false : InetAddresses.isNatLocalAddress(addrGroup, config.getLocalPort(), config.getLocalPortAutoAdjust()) ^ true) {
                socketMulti.setInterface(addrGroup);
            }
        }
    }

    public void configure(ServerSocket socket) throws IOException {
        ((Cluster)this.get_Module()).getClusterService().getTcpRing().getSocketOptions().apply(socket);
    }

    public Cluster$SocketManager$AcceptorChannel getAcceptorChannel() {
        return (Cluster$SocketManager$AcceptorChannel)this._findChild("AcceptorChannel");
    }

    public Cluster$SocketManager$BroadcastTcpSocket getBroadcastTcpSocket() {
        return (Cluster$SocketManager$BroadcastTcpSocket)this._findChild("BroadcastTcpSocket");
    }

    public Cluster$SocketManager$BroadcastUdpSocket getBroadcastUdpSocket() {
        return (Cluster$SocketManager$BroadcastUdpSocket)this._findChild("BroadcastUdpSocket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Depot getDepot() {
        Depot depot = this.__m_Depot;
        if (depot == null) {
            Cluster$SocketManager cluster$SocketManager = this;
            synchronized (cluster$SocketManager) {
                depot = this.__m_Depot;
                if (depot == null) {
                    Cluster cluster = (Cluster)this.get_Module();
                    ClusterDependencies config = cluster.getDependencies();
                    SimpleDepot.DefaultDependencies depsDepot = new SimpleDepot.DefaultDependencies().setSSLSettings(config.getUnicastSocketProviderBuilder().getSSLSettings());
                    HashMap<String, Driver> mapDrivers = new HashMap<String, Driver>(depsDepot.getDrivers());
                    Iterator iterEntry = mapDrivers.entrySet().iterator();
                    while (iterEntry.hasNext()) {
                        Map.Entry entry = iterEntry.next();
                        Driver driver = (Driver)entry.getValue();
                        if (!(driver instanceof SocketBusDriver)) continue;
                        SocketBusDriver.Dependencies depsSocket = ((SocketBusDriver)driver).getDependencies();
                        entry.setValue(new SocketBusDriver(new SocketBusDriver.DefaultDependencies(depsSocket).setLogger(LoggingBridge.createBridge()).setDefaultAckTimeoutMillis(config.getIpMonitorTimeoutMillis() * (long)config.getIpMonitorAttempts()).setAckFatalTimeoutMillis(0L).setSocketReconnectLimit(Integer.MAX_VALUE)));
                    }
                    depsDepot.setDrivers(mapDrivers);
                    depot = new SimpleDepot(depsDepot);
                    this.setDepot(depot);
                }
            }
        }
        return depot;
    }

    public Cluster$SocketManager$PreferredUnicastUdpSocket getPreferredUnicastUdpSocket() {
        return (Cluster$SocketManager$PreferredUnicastUdpSocket)this._findChild("PreferredUnicastUdpSocket");
    }

    public SocketProvider getTcpRingSocketProvider() {
        return this.__m_TcpRingSocketProvider;
    }

    public Cluster$SocketManager$UnicastUdpSocket getUnicastUdpSocket() {
        return (Cluster$SocketManager$UnicastUdpSocket)this._findChild("UnicastUdpSocket");
    }

    public DatagramSocketProvider getUnicastUdpSocketProvider() {
        return this.__m_UnicastUdpSocketProvider;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster$SocketManager".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Cluster$SocketManager();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void releaseSockets() {
        this.getUnicastUdpSocket().close();
        this.getPreferredUnicastUdpSocket().close();
        this.getAcceptorChannel().close();
    }

    public void setDepot(Depot depot) {
        this.__m_Depot = depot;
    }

    public void setTcpRingSocketProvider(SocketProvider pSocketProvider) {
        this.__m_TcpRingSocketProvider = pSocketProvider;
    }

    public void setUnicastUdpSocketProvider(DatagramSocketProvider providerSocket) {
        this.__m_UnicastUdpSocketProvider = providerSocket;
    }
}

