/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.internal.net.socketbus.AbstractSocketBus;
import com.oracle.coherence.common.internal.net.socketbus.SocketBusDriver;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.Event;
import com.oracle.coherence.common.net.exabus.MessageBus;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.MessageHandler$Connection;
import com.tangosol.coherence.component.net.MessageHandler$EventCollector;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.BusEventMessage;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.io.BufferSequenceWriteBufferPool;
import com.tangosol.internal.util.MessagePublisher;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class MessageHandler
extends Net
implements MessagePublisher {
    private BufferManager __m_BufferManager;
    private volatile transient boolean __m_Closing;
    private transient Map __m_ConnectionMap;
    private long __m_DeliveryTimeoutMillis;
    private AtomicLong __m_DisconnectCounter;
    private Collector __m_EventCollector;
    private boolean __m_GlobalBacklog;
    private Object __m_GlobalBacklogMonitor;
    private SafeHashMap __m_HungConnectionIPs;
    private Queue __m_IncomingQueue;
    private boolean __m_LocalBacklog;
    private MessageBus __m_MessageBus;
    private MessagePublisher __m_ParentMessagePublisher;
    private AtomicBoolean __m_PendingParentFlush;
    private Grid __m_Service;
    private long __m_StatsBacklogDirect;
    private long __m_StatsBacklogGlobal;
    private long __m_StatsBacklogLocal;
    private transient long __m_StatsBusBytesIn;
    private transient long __m_StatsBusBytesOut;
    private AtomicLong __m_StatsBusBytesOutBuffered;
    private long __m_StatsBusReceives;
    private long __m_StatsBusSends;
    private LongAdder __m_StatsDrainOverflowDuration;
    private static ListMap __mapChildren;
    private static transient boolean __s_EstimateMessageSize;

    static {
        MessageHandler._initStatic();
    }

    public MessageHandler() {
        this(null, null, true);
    }

    public MessageHandler(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionMap(new SafeHashMap());
            this.setGlobalBacklogMonitor(new Object());
            this.setStatsBusBytesOutBuffered(new AtomicLong());
            this.setStatsDrainOverflowDuration(new LongAdder());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new MessageHandler$EventCollector("EventCollector", this, true), "EventCollector");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_DisconnectCounter = new AtomicLong();
            this.__m_HungConnectionIPs = new SafeHashMap();
            this.__m_PendingParentFlush = new AtomicBoolean();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Connection", MessageHandler$Connection.get_CLASS());
    }

    private static void _initStatic$Default() {
        MessageHandler.__initStatic();
    }

    protected static void _initStatic() {
        MessageHandler._initStatic$Default();
        MessageHandler.setEstimateMessageSize(Boolean.parseBoolean(Config.getProperty("coherence.estimateBusMessageSize", "true")));
    }

    protected boolean checkReleased(EndPoint peer) {
        MessageHandler$Connection connect = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        return connect == null ? true : connect.isReleased();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        MessageHandler messageHandler = this;
        synchronized (messageHandler) {
            if (!(this.isClosing() ^ true)) return;
            this.setClosing(true);
            this.getMessageBus().close();
            Grid service = this.getService();
            Queue queue = this.getIncomingQueue();
            block7: while (true) {
                Message msg;
                if ((msg = (Message)queue.remove()) instanceof BusEventMessage) {
                    switch (((BusEventMessage)msg).getEvent().getType().ordinal()) {
                        case 3: 
                        case 4: {
                            service.onMessage(msg);
                            continue block7;
                        }
                        case 1: {
                            service.onMessage(msg);
                            return;
                        }
                    }
                    continue;
                }
                if (!msg.isDeserializationRequired()) continue;
                msg.releaseIncoming();
            }
        }
    }

    public int compareImportance(Member member) {
        return this.getService().compareImportance(member);
    }

    public boolean connect(Member member, EndPoint peer) {
        Map mapConnect = this.getConnectionMap();
        Component._assert(!(member != null) ? false : peer != null);
        Component._assert(mapConnect.containsKey(peer) ^ true, "Connect request out of order");
        MessageHandler$Connection connect = this.instantiateConnection(peer, member);
        connect.setState(MessageHandler$Connection.STATE_CONNECTING);
        mapConnect.put(peer, connect);
        try {
            this.getMessageBus().connect(peer);
        }
        catch (IllegalArgumentException e) {
            Component._trace(new StringBuilder(String.valueOf("Unable to connect to ")).append(peer).append(" using ").append(this.getMessageBus().getLocalEndPoint()).append(" (").append(e.getMessage()).append("), falling back on default cluster transport").toString(), 2);
            mapConnect.remove(peer);
            return false;
        }
        Component._trace(new StringBuilder(String.valueOf("Registered ")).append(connect).toString(), 6);
        return true;
    }

    public void connectAll() {
        Grid service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        Member memberThis = service.getThisMember();
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(member != memberThis)) continue;
            int nMember = member.getId();
            EndPoint peer = setMembers.getServiceEndPoint(nMember);
            if (peer == null && (!((peer = service.resolveEndPoint(setMembers.getServiceEndPointName(nMember), member, setMembers.getMemberConfigMap(nMember))) != null) ? false : this.connect(member, peer))) {
                setMembers.setServiceEndPoint(nMember, peer);
            }
            setMembers.setServiceEndPointName(nMember, peer == null ? null : peer.getCanonicalName());
        }
    }

    public ReadBuffer createReadBuffer(BufferSequence bufseq) {
        int cBuffers = bufseq.getBufferCount();
        if (cBuffers == 1) {
            return new ByteBufferReadBuffer(bufseq.getBuffer(0));
        }
        ReadBuffer[] abuf = new ReadBuffer[cBuffers];
        int i = 0;
        while (i < cBuffers) {
            abuf[i] = new ByteBufferReadBuffer(bufseq.getBuffer(i));
            ++i;
        }
        return new MultiBufferReadBuffer(abuf);
    }

    public long drainOverflow(Set setDest, long cMillisTimeout) throws InterruptedException {
        int nMemberTo;
        ServiceMemberSet setMemberService;
        EndPoint peer;
        MemberSet setMember = (MemberSet)setDest;
        if ((!(!(setMember.size() == 1) ? false : this.isGlobalBacklog() ^ true) ? false : this.isLocalBacklog() ^ true) && (!((peer = (setMemberService = this.getService().getServiceMemberSet()).getServiceEndPoint(nMemberTo = setMember.getFirstId())) != null) ? false : setMemberService.isServiceBacklogged(nMemberTo) ^ true)) {
            return cMillisTimeout;
        }
        long ldtStart = Base.getSafeTimeMillis();
        cMillisTimeout = this.drainOverflowComplex(setMember, cMillisTimeout);
        long ldtDelta = Base.getSafeTimeMillis() - ldtStart;
        if (ldtDelta > (long)0) {
            this.getStatsDrainOverflowDuration().add(ldtDelta);
        }
        return cMillisTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long drainOverflowComplex(MemberSet setMember, long cMillisTimeout) throws InterruptedException {
        Object object;
        long ldtTimeout;
        Grid service = this.getService();
        ServiceMemberSet setMemberService = service.getServiceMemberSet();
        long l = ldtTimeout = cMillisTimeout == 0L ? Long.MAX_VALUE : Base.getSafeTimeMillis() + cMillisTimeout;
        if (this.isGlobalBacklog()) {
            Object oMonitor;
            object = oMonitor = this.getGlobalBacklogMonitor();
            synchronized (object) {
                while (!(cMillisTimeout >= 0L) ? false : this.isGlobalBacklog()) {
                    Blocking.wait(oMonitor, cMillisTimeout);
                    cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                }
            }
        }
        if (this.isLocalBacklog()) {
            EndPoint pointLocal = this.getMessageBus().getLocalEndPoint();
            object = pointLocal;
            synchronized (object) {
                while (!(cMillisTimeout >= 0L) ? false : this.isLocalBacklog()) {
                    Blocking.wait(pointLocal, cMillisTimeout);
                    cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                }
            }
        }
        boolean fParent = false;
        switch (setMember.size()) {
            case 0: {
                break;
            }
            case 1: {
                int nMemberTo = setMember.getFirstId();
                EndPoint peer = setMemberService.getServiceEndPoint(nMemberTo);
                if (peer == null) {
                    fParent = true;
                    break;
                }
                if (!(!(nMemberTo != 0) ? false : setMemberService.isServiceBacklogged(nMemberTo))) break;
                EndPoint endPoint = peer;
                synchronized (endPoint) {
                    while (!(cMillisTimeout >= 0L) ? false : setMemberService.isServiceBacklogged(nMemberTo)) {
                        Blocking.wait(peer, cMillisTimeout);
                        cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                    }
                    break;
                }
            }
            default: {
                int[] aId = setMember.toIdArray();
                int i = 0;
                int c = aId.length;
                while (i < c) {
                    int nMemberTo = aId[i];
                    EndPoint peer = setMemberService.getServiceEndPoint(nMemberTo);
                    if (peer == null) {
                        fParent = true;
                    } else if (!(nMemberTo != 0) ? false : setMemberService.isServiceBacklogged(nMemberTo)) {
                        EndPoint endPoint = peer;
                        synchronized (endPoint) {
                            while (!(cMillisTimeout >= 0L) ? false : setMemberService.isServiceBacklogged(nMemberTo)) {
                                Blocking.wait(peer, cMillisTimeout);
                                cMillisTimeout = Base.computeSafeWaitTime(ldtTimeout);
                            }
                        }
                    }
                    ++i;
                }
                break block8;
            }
        }
        if (cMillisTimeout < 0L) {
            throw new RequestTimeoutException("Request timed out");
        }
        return fParent ? this.getParentMessagePublisher().drainOverflow(setMember, cMillisTimeout) : cMillisTimeout;
    }

    public void flush() {
        block3: {
            try {
                this.getMessageBus().flush();
            }
            catch (IllegalStateException e) {
                if (!(this.isClosing() ^ true)) break block3;
                throw e;
            }
        }
        AtomicBoolean atomicFlush = this.getPendingParentFlush();
        if (!atomicFlush.get() ? false : atomicFlush.compareAndSet(true, false)) {
            this.getParentMessagePublisher().flush();
        }
    }

    public BufferManager getBufferManager() {
        return this.__m_BufferManager;
    }

    public Map getConnectionMap() {
        return this.__m_ConnectionMap;
    }

    public long getDeliveryTimeoutMillis() {
        return this.__m_DeliveryTimeoutMillis;
    }

    public AtomicLong getDisconnectCounter() {
        return this.__m_DisconnectCounter;
    }

    public Collector getEventCollector() {
        return this.__m_EventCollector;
    }

    public Object getGlobalBacklogMonitor() {
        return this.__m_GlobalBacklogMonitor;
    }

    public SafeHashMap getHungConnectionIPs() {
        return this.__m_HungConnectionIPs;
    }

    public Queue getIncomingQueue() {
        return this.__m_IncomingQueue;
    }

    public MessageBus getMessageBus() {
        return this.__m_MessageBus;
    }

    public MessagePublisher getParentMessagePublisher() {
        return this.__m_ParentMessagePublisher;
    }

    protected AtomicBoolean getPendingParentFlush() {
        return this.__m_PendingParentFlush;
    }

    public Grid getService() {
        return this.__m_Service;
    }

    public Grid getServiceById(int nSvcId) {
        Grid service = this.getService();
        Component._assert(service.getServiceId() == nSvcId);
        return service;
    }

    public long getStatsBacklogDirect() {
        return this.__m_StatsBacklogDirect;
    }

    public long getStatsBacklogGlobal() {
        return this.__m_StatsBacklogGlobal;
    }

    public long getStatsBacklogLocal() {
        return this.__m_StatsBacklogLocal;
    }

    public long getStatsBusBytesIn() {
        return this.__m_StatsBusBytesIn;
    }

    public long getStatsBusBytesOut() {
        return this.__m_StatsBusBytesOut;
    }

    public AtomicLong getStatsBusBytesOutBuffered() {
        return this.__m_StatsBusBytesOutBuffered;
    }

    public long getStatsBusReceives() {
        return this.__m_StatsBusReceives;
    }

    public long getStatsBusSends() {
        return this.__m_StatsBusSends;
    }

    public LongAdder getStatsDrainOverflowDuration() {
        return this.__m_StatsDrainOverflowDuration;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/MessageHandler".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new MessageHandler();
    }

    private final Component get_Module() {
        return this;
    }

    public void initialize(Grid service, MessageBus bus, MessagePublisher publisherParent) {
        Component._assert(this.getService() == null, "Already initialized");
        service.ensureGuardSupport();
        this.setService(service);
        this.setMessageBus(bus);
        this.setParentMessagePublisher(publisherParent);
        this.setIncomingQueue(service.getQueue());
        this.setDeliveryTimeoutMillis(service.getCluster().getDependencies().getPublisherResendTimeoutMillis());
        this.setBufferManager(bus instanceof AbstractSocketBus ? SocketBusDriver.DefaultDependencies.DEFAULT_BUFFER_MANAGER : BufferManagers.getNetworkDirectManager());
        bus.setEventCollector(this.getEventCollector());
        bus.open();
    }

    protected MessageHandler$Connection instantiateConnection(EndPoint peer, Member member) {
        MessageHandler$Connection connect = (MessageHandler$Connection)this._newChild("Connection");
        connect.setPeer(peer);
        connect.setMember(member);
        return connect;
    }

    public boolean isClosing() {
        return this.__m_Closing;
    }

    public static boolean isEstimateMessageSize() {
        return __s_EstimateMessageSize;
    }

    public boolean isGlobalBacklog() {
        return this.__m_GlobalBacklog;
    }

    public boolean isLocalBacklog() {
        return this.__m_LocalBacklog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBacklog(EndPoint peer, boolean fExcessive) {
        EndPoint pointLocal = this.getMessageBus().getLocalEndPoint();
        if (peer == null) {
            if (fExcessive) {
                this.setGlobalBacklog(true);
                this.setStatsBacklogGlobal(this.getStatsBacklogGlobal() + 1L);
            } else {
                Object oMonitor;
                Object object = oMonitor = this.getGlobalBacklogMonitor();
                synchronized (object) {
                    this.setGlobalBacklog(false);
                    oMonitor.notifyAll();
                }
            }
        } else if (peer.equals(pointLocal)) {
            if (fExcessive) {
                this.setLocalBacklog(true);
                this.setStatsBacklogLocal(this.getStatsBacklogLocal() + 1L);
            } else {
                EndPoint oMonitor = pointLocal;
                synchronized (oMonitor) {
                    this.setLocalBacklog(false);
                    pointLocal.notifyAll();
                }
            }
        } else {
            MessageHandler$Connection connect = (MessageHandler$Connection)this.getConnectionMap().get(peer);
            if (connect != null) {
                ServiceMemberSet setMember = this.getService().getServiceMemberSet();
                int nMember = connect.getMember().getId();
                if (fExcessive) {
                    setMember.setServiceBacklogged(nMember, true);
                    this.setStatsBacklogDirect(this.getStatsBacklogDirect() + 1L);
                } else {
                    EndPoint endPoint = peer = connect.getPeer();
                    synchronized (endPoint) {
                        setMember.setServiceBacklogged(nMember, false);
                        peer.notifyAll();
                    }
                }
            }
        }
    }

    public void onBusEvent(Event event) {
        try {
            try {
                switch (event.getType().ordinal()) {
                    case 0: {
                        this.onOpen();
                        break;
                    }
                    case 1: {
                        this.onClose();
                        break;
                    }
                    case 2: {
                        this.onConnect(event.getEndPoint());
                        break;
                    }
                    case 9: {
                        this.onMessage(event.getEndPoint(), (BufferSequence)event.getContent());
                        break;
                    }
                    case 3: {
                        this.onDisconnect(event.getEndPoint(), (Throwable)event.getContent());
                        break;
                    }
                    case 4: {
                        this.onReleased(event.getEndPoint());
                        break;
                    }
                    case 5: {
                        this.onBacklog(event.getEndPoint(), true);
                        break;
                    }
                    case 6: {
                        this.onBacklog(event.getEndPoint(), false);
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            Object var3_4 = null;
            event.dispose();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            event.dispose();
            throw throwable;
        }
    }

    protected void onClose() {
        this.onBacklog(this.getMessageBus().getLocalEndPoint(), false);
        this.onBacklog(null, false);
    }

    protected void onConnect(EndPoint peer) {
        MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        if (conn == null) {
            this.getMessageBus().release(peer);
        } else {
            switch (conn.getState()) {
                case 1: {
                    conn.setState(MessageHandler$Connection.STATE_CONNECTED);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException(new StringBuilder(String.valueOf("Unexpected Connect event: ")).append(conn).toString());
                }
            }
        }
    }

    protected void onDisconnect(EndPoint peer, Throwable tReason) {
        MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        if (conn != null) {
            conn.onDisconnect(tReason);
        }
    }

    public void onException(Throwable e) {
        this.getService().onException(e);
    }

    public void onInit() {
        super.onInit();
        this.setEventCollector((MessageHandler$EventCollector)this._findChild("EventCollector"));
    }

    public void onInterval() {
        try {
            Iterator iter = this.getConnectionMap().values().iterator();
            while (iter.hasNext()) {
                ((MessageHandler$Connection)iter.next()).onInterval();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMessage(EndPoint peer, BufferSequence bufseq) throws IOException {
        MessageHandler$Connection connect = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        if (connect == null) {
            Component._trace(new StringBuilder(String.valueOf("Discarding a message from disconnected or unknown peer: ")).append(peer).toString(), 2);
            return;
        } else if (connect.isEstablished() ? true : connect.establish()) {
            Message msg = connect.prepareMessage(bufseq);
            if (msg == null) {
                return;
            }
            boolean bl = true;
            if (!bl) return;
            Grid svcMsg = msg.getService();
            if (!(svcMsg == this.getService())) throw new IllegalStateException();
            svcMsg.onMessage(msg);
            return;
        } else {
            Component._trace(new StringBuilder(String.valueOf("Ignoring delayed message from departing ")).append(connect).toString(), 6);
        }
    }

    protected void onOpen() {
    }

    protected void onReleased(EndPoint peer) {
        this.onBacklog(peer, false);
        MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().remove(peer);
        if (conn != null) {
            conn.onReleased();
            Component._trace(new StringBuilder(String.valueOf("Unregistered ")).append(conn).toString(), 6);
        }
    }

    public boolean post(Object oMsg) {
        if (this.isClosing()) {
            return false;
        }
        Message msg = (Message)oMsg;
        ServiceMemberSet setEndPoint = this.getService().getServiceMemberSet();
        MemberSet setMemberTo = msg.getToMemberSet();
        Component._assert(setMemberTo != null, "MessageBus cannot be used to broadcast");
        switch (setMemberTo.size()) {
            case 0: {
                return false;
            }
            case 1: {
                int nMemberTo = setMemberTo.getFirstId();
                EndPoint peer = setEndPoint.getServiceEndPoint(nMemberTo);
                if (peer == null) {
                    if (this.getParentMessagePublisher().post(msg)) {
                        this.getPendingParentFlush().set(true);
                        return true;
                    }
                    return false;
                }
                BufferSequence bufseq = this.serializeMessage(msg);
                long cbMsg = bufseq.getLength();
                this.getStatsBusBytesOutBuffered().addAndGet(cbMsg);
                try {
                    MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().get(peer);
                    if (conn == null) {
                        throw new IllegalArgumentException(new StringBuilder(String.valueOf("unknown peer ")).append(peer).toString());
                    }
                    this.getMessageBus().send(peer, bufseq, msg);
                    conn.getSentMessageCount().incrementAndGet();
                    this.setStatsBusSends(this.getStatsBusSends() + 1L);
                    this.setStatsBusBytesOut(this.getStatsBusBytesOut() + cbMsg);
                    return true;
                }
                catch (RuntimeException e) {
                    msg.releaseOutgoing(true);
                    if (this.isClosing() ? true : this.checkReleased(peer)) {
                        return false;
                    }
                    throw e;
                }
            }
        }
        return this.postMulti(msg);
    }

    public void postEventMessage(Event event) {
        Grid service = this.getService();
        BusEventMessage msgEvent = (BusEventMessage)service.instantiateMessage("BusEventMessage");
        msgEvent.setEvent(event);
        msgEvent.setMessageHandler(this);
        msgEvent.addToMember(service.getThisMember());
        service.post(msgEvent);
    }

    protected boolean postMulti(Message msg) {
        ServiceMemberSet setEndPoint = this.getService().getServiceMemberSet();
        MemberSet setMemberTo = msg.getToMemberSet();
        MessageBus bus = this.getMessageBus();
        BufferSequence bufseq = null;
        boolean fSent = false;
        long cbSent = 0L;
        long cbMsg = 0L;
        int[] anId = setMemberTo.toIdArray();
        int i = 0;
        int c = anId.length;
        while (i < c) {
            block8: {
                int nId = anId[i];
                Component._assert(nId != 0);
                EndPoint peer = setEndPoint.getServiceEndPoint(nId);
                if (peer != null) {
                    if (bufseq == null) {
                        bufseq = this.serializeMessage(msg);
                        cbMsg = bufseq.getLength();
                    }
                    setMemberTo.remove(nId);
                    try {
                        MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().get(peer);
                        if (conn == null) {
                            throw new IllegalArgumentException(new StringBuilder(String.valueOf("unknown peer ")).append(peer).toString());
                        }
                        bus.send(peer, bufseq, msg);
                        conn.getSentMessageCount().incrementAndGet();
                        cbSent += cbMsg;
                        fSent = true;
                    }
                    catch (RuntimeException e) {
                        msg.releaseOutgoing(true);
                        if (!((this.isClosing() ? true : this.checkReleased(peer)) ^ true)) break block8;
                        throw e;
                    }
                }
            }
            ++i;
        }
        if (cbSent != 0L) {
            this.setStatsBusSends(this.getStatsBusSends() + 1L);
            this.setStatsBusBytesOut(this.getStatsBusBytesOut() + cbSent);
            this.getStatsBusBytesOutBuffered().addAndGet(cbSent);
        }
        if (setMemberTo.isEmpty() ^ true && this.getParentMessagePublisher().post(msg)) {
            fSent = true;
            this.getPendingParentFlush().set(true);
        }
        return fSent;
    }

    public void processMessage(Event event) throws IOException {
        block8: {
            EndPoint peer = event.getEndPoint();
            BufferSequence bufseq = (BufferSequence)event.getContent();
            MessageHandler$Connection connect = (MessageHandler$Connection)this.getConnectionMap().get(peer);
            this.setStatsBusReceives(this.getStatsBusReceives() + 1L);
            this.setStatsBusBytesIn(this.getStatsBusBytesIn() + bufseq.getLength());
            try {
                if (connect == null) {
                    this.postEventMessage(event);
                    event = null;
                    break block8;
                }
                if (connect.isEstablished() ? true : connect.establish()) {
                    Message msg = connect.prepareMessage(bufseq);
                    if (msg != null) {
                        if (msg.isDeserializationRequired()) {
                            msg.setBufferController(event);
                            event = null;
                        }
                        msg.getService().getQueue().add(msg);
                    }
                    break block8;
                }
                Component._trace(new StringBuilder(String.valueOf("Ignoring delayed message from departing ")).append(connect).toString(), 6);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (event != null) {
                    event.dispose();
                }
                throw throwable;
            }
        }
        Object var6_7 = null;
        if (event != null) {
            event.dispose();
        }
    }

    public void processReceipt(EndPoint peer, Message msg, boolean fSuspect) {
        if (msg == null) {
            Component._trace("received a delivery receipt for a null message", 2);
            Component._trace(new Throwable());
            return;
        }
        BufferSequence bufseq = (BufferSequence)msg.getBufferController();
        if (bufseq == null) {
            Component._trace(new StringBuilder(String.valueOf("received a delivery receipt for a disposed message: ")).append(msg).toString(), 2);
            Component._trace(new Throwable());
            return;
        }
        this.getStatsBusBytesOutBuffered().addAndGet(-bufseq.getLength());
        MessageHandler$Connection connection = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        connection.setReceivedReceiptCount(connection.getReceivedReceiptCount() + 1L);
        msg.releaseOutgoing(fSuspect);
    }

    public void release(EndPoint peer, Continuation continuation) {
        MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        if (conn == null) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("No connection to: ")).append(peer).toString());
        }
        conn.release(continuation);
    }

    public void resetStats() {
        this.setStatsBusSends(0L);
        this.setStatsBusReceives(0L);
        this.setStatsBusBytesOut(0L);
        this.setStatsBusBytesIn(0L);
        this.setStatsBacklogGlobal(0L);
        this.setStatsBacklogLocal(0L);
        this.setStatsBacklogDirect(0L);
    }

    protected BufferSequence serializeMessage(Message msg) {
        BufferSequence bufseq = (BufferSequence)msg.getBufferController();
        if (bufseq == null) {
            BufferSequenceWriteBufferPool adapter = new BufferSequenceWriteBufferPool(this.getBufferManager());
            try {
                Grid service = msg.getService();
                service.serializeMessage(msg, new MultiBufferWriteBuffer(adapter, MessageHandler.isEstimateMessageSize() ? service.estimateMessageSize(msg) : 0).getBufferOutput());
            }
            catch (Throwable e) {
                adapter.toBufferSequence().dispose();
                throw Base.ensureRuntimeException(e);
            }
            bufseq = adapter.toBufferSequence();
            msg.setBufferController(bufseq, msg.getToMemberSet().size());
        }
        return bufseq;
    }

    public void setBufferManager(BufferManager managerBuffer) {
        this.__m_BufferManager = managerBuffer;
    }

    protected void setClosing(boolean fClosing) {
        this.__m_Closing = fClosing;
    }

    protected void setConnectionMap(Map map) {
        this.__m_ConnectionMap = map;
    }

    public void setDeliveryTimeoutMillis(long lMillis) {
        this.__m_DeliveryTimeoutMillis = lMillis;
    }

    private void setDisconnectCounter(AtomicLong longCounter) {
        this.__m_DisconnectCounter = longCounter;
    }

    public static void setEstimateMessageSize(boolean fSize) {
        __s_EstimateMessageSize = fSize;
    }

    protected void setEventCollector(Collector collector) {
        this.__m_EventCollector = collector;
    }

    public void setGlobalBacklog(boolean pGlobalBacklog) {
        this.__m_GlobalBacklog = pGlobalBacklog;
    }

    protected void setGlobalBacklogMonitor(Object oMonitor) {
        this.__m_GlobalBacklogMonitor = oMonitor;
    }

    private void setHungConnectionIPs(SafeHashMap integerCount) {
        this.__m_HungConnectionIPs = integerCount;
    }

    protected void setIncomingQueue(Queue queue) {
        this.__m_IncomingQueue = queue;
    }

    public void setLocalBacklog(boolean pGlobalBacklog) {
        this.__m_LocalBacklog = pGlobalBacklog;
    }

    protected void setMessageBus(MessageBus bus) {
        this.__m_MessageBus = bus;
    }

    protected void setParentMessagePublisher(MessagePublisher publisher) {
        this.__m_ParentMessagePublisher = publisher;
    }

    private void setPendingParentFlush(AtomicBoolean atomic) {
        this.__m_PendingParentFlush = atomic;
    }

    protected void setService(Grid service) {
        this.__m_Service = service;
    }

    protected void setStatsBacklogDirect(long c) {
        this.__m_StatsBacklogDirect = c;
    }

    protected void setStatsBacklogGlobal(long c) {
        this.__m_StatsBacklogGlobal = c;
    }

    protected void setStatsBacklogLocal(long c) {
        this.__m_StatsBacklogLocal = c;
    }

    protected void setStatsBusBytesIn(long lOut) {
        this.__m_StatsBusBytesIn = lOut;
    }

    protected void setStatsBusBytesOut(long lOut) {
        this.__m_StatsBusBytesOut = lOut;
    }

    protected void setStatsBusBytesOutBuffered(AtomicLong longBuffered) {
        this.__m_StatsBusBytesOutBuffered = longBuffered;
    }

    protected void setStatsBusReceives(long lReceives) {
        this.__m_StatsBusReceives = lReceives;
    }

    protected void setStatsBusSends(long lSends) {
        this.__m_StatsBusSends = lSends;
    }

    public void setStatsDrainOverflowDuration(LongAdder adderDuration) {
        this.__m_StatsDrainOverflowDuration = adderDuration;
    }

    public String toString() {
        return new StringBuilder(String.valueOf(this.get_Name())).append("{Service=").append(this.getService().getServiceName()).append(this.isClosing() ? ", closing" : "").append(", connections=").append(this.getConnectionMap().size()).append(", disconnectedIPs=").append(this.getHungConnectionIPs().size()).append(", backlogs=(").append(this.getStatsBacklogGlobal()).append("/").append(this.getStatsBacklogLocal()).append("/").append(this.getStatsBacklogDirect()).append("), bus=").append(this.getMessageBus()).append("}").toString();
    }
}

