/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.util.LiteMap;
import java.util.Map;

public abstract class ServiceLoad
extends Net
implements com.tangosol.net.ServiceLoad {
    private int __m_ConnectionCount;
    private int __m_ConnectionFactor;
    private int __m_ConnectionLimit;
    private int __m_ConnectionPendingCount;
    private int __m_DaemonActiveCount;
    private int __m_DaemonCount;
    private int __m_DaemonFactor;
    private int __m_MessageBacklogFactor;
    private int __m_MessageBacklogIncoming;
    private int __m_MessageBacklogOutgoing;

    public ServiceLoad(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int compareTo(Object o) {
        ServiceLoad that = (ServiceLoad)o;
        int n = this.getConnectionFactor() - that.getConnectionFactor();
        if (n == 0 && (n = this.getMessageBacklogFactor() - that.getMessageBacklogFactor()) == 0) {
            n = this.getDaemonFactor() - that.getDaemonFactor();
        }
        return n;
    }

    public void fromMap(Map map) {
        if (map != null) {
            Integer I = (Integer)map.get("ConnectionCount");
            if (I != null) {
                this.setConnectionCount(I);
            }
            if ((I = (Integer)map.get("ConnectionPendingCount")) != null) {
                this.setConnectionPendingCount(I);
            }
            if ((I = (Integer)map.get("ConnectionLimit")) != null) {
                this.setConnectionLimit(I);
            }
            if ((I = (Integer)map.get("DaemonActiveCount")) != null) {
                this.setDaemonActiveCount(I);
            }
            if ((I = (Integer)map.get("DaemonCount")) != null) {
                this.setDaemonCount(I);
            }
            if ((I = (Integer)map.get("MessageBacklogIncoming")) != null) {
                this.setMessageBacklogIncoming(I);
            }
            if ((I = (Integer)map.get("MessageBacklogOutgoing")) != null) {
                this.setMessageBacklogOutgoing(I);
            }
        }
    }

    public int getConnectionCount() {
        return this.__m_ConnectionCount;
    }

    public int getConnectionFactor() {
        int n = this.__m_ConnectionFactor;
        if (n >= 0) {
            return n;
        }
        int cCurrent = this.getConnectionCount();
        int cPending = this.getConnectionPendingCount();
        int cLimit = this.getConnectionLimit();
        int cTotal = (int)Math.min((long)cCurrent + (long)cPending, (long)Integer.MAX_VALUE);
        n = (!(cLimit > 0) ? false : cTotal >= cLimit) ? Integer.MAX_VALUE : cTotal;
        this.setConnectionFactor(n);
        return n;
    }

    public int getConnectionLimit() {
        return this.__m_ConnectionLimit;
    }

    public int getConnectionPendingCount() {
        return this.__m_ConnectionPendingCount;
    }

    public int getDaemonActiveCount() {
        return this.__m_DaemonActiveCount;
    }

    public int getDaemonCount() {
        return this.__m_DaemonCount;
    }

    public int getDaemonFactor() {
        int cLimit;
        int n = this.__m_DaemonFactor;
        if (n >= 0) {
            return n;
        }
        int cCurrent = this.getDaemonActiveCount();
        n = cCurrent >= (cLimit = this.getDaemonCount()) ? Integer.MAX_VALUE : cCurrent;
        this.setDaemonFactor(n);
        return n;
    }

    protected String getDescription() {
        return new StringBuilder(String.valueOf("ConnectionCount=")).append(this.getConnectionCount()).append(", ConnectionPendingCount=").append(this.getConnectionPendingCount()).append(", ConnectionLimit=").append(this.getConnectionLimit()).append(", ConnectionFactor=").append(this.getConnectionFactor()).append(", DaemonActiveCount=").append(this.getDaemonActiveCount()).append(", DaemonCount=").append(this.getDaemonCount()).append(", DaemonFactor=").append(this.getDaemonFactor()).append(", MessageBacklogIncoming=").append(this.getMessageBacklogIncoming()).append(", MessageBacklogOutgoing=").append(this.getMessageBacklogOutgoing()).append(", MessageBacklogFactor=").append(this.getMessageBacklogFactor()).toString();
    }

    public int getMessageBacklogFactor() {
        int n = this.__m_MessageBacklogFactor;
        if (n >= 0) {
            return n;
        }
        long li = this.getMessageBacklogIncoming();
        long lo = this.getMessageBacklogOutgoing();
        n = (int)Math.min(li + lo, (long)Integer.MAX_VALUE);
        this.setMessageBacklogFactor(n);
        return n;
    }

    public int getMessageBacklogIncoming() {
        return this.__m_MessageBacklogIncoming;
    }

    public int getMessageBacklogOutgoing() {
        return this.__m_MessageBacklogOutgoing;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/ServiceLoad".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public void setConnectionCount(int c) {
        Component._assert(c >= 0);
        this.__m_ConnectionCount = c;
        this.setConnectionFactor(-1);
    }

    protected void setConnectionFactor(int n) {
        this.__m_ConnectionFactor = n;
    }

    public void setConnectionLimit(int c) {
        Component._assert(c >= 0);
        this.__m_ConnectionLimit = c;
        this.setConnectionFactor(-1);
    }

    public void setConnectionPendingCount(int c) {
        Component._assert(c >= 0);
        this.__m_ConnectionPendingCount = c;
        this.setConnectionFactor(-1);
    }

    public void setDaemonActiveCount(int c) {
        Component._assert(c >= 0);
        this.__m_DaemonActiveCount = c;
        this.setDaemonFactor(-1);
    }

    public void setDaemonCount(int c) {
        Component._assert(c >= 0);
        this.__m_DaemonCount = c;
        this.setDaemonFactor(-1);
    }

    protected void setDaemonFactor(int n) {
        this.__m_DaemonFactor = n;
    }

    protected void setMessageBacklogFactor(int n) {
        this.__m_MessageBacklogFactor = n;
    }

    public void setMessageBacklogIncoming(int c) {
        Component._assert(c >= 0);
        this.__m_MessageBacklogIncoming = c;
        this.setMessageBacklogFactor(-1);
    }

    public void setMessageBacklogOutgoing(int c) {
        Component._assert(c >= 0);
        this.__m_MessageBacklogOutgoing = c;
        this.setMessageBacklogFactor(-1);
    }

    public Map toMap() {
        LiteMap<String, Integer> map = new LiteMap<String, Integer>();
        map.put("ConnectionCount", this.getConnectionCount());
        map.put("ConnectionPendingCount", this.getConnectionPendingCount());
        map.put("ConnectionLimit", this.getConnectionLimit());
        map.put("DaemonActiveCount", this.getDaemonActiveCount());
        map.put("DaemonCount", this.getDaemonCount());
        map.put("MessageBacklogIncoming", this.getMessageBacklogIncoming());
        map.put("MessageBacklogOutgoing", this.getMessageBacklogOutgoing());
        return map;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ServiceLoad(").append("ConnectionCount=").append(this.getConnectionCount()).append(", MsgBacklogIncoming=").append(this.getMessageBacklogIncoming()).append("\n)");
        return sb.toString();
    }

    public void updateConnectionCount(int c) {
        this.setConnectionCount(Math.max(0, this.getConnectionCount() + c));
    }

    public void updateConnectionPendingCount(int c) {
        this.setConnectionPendingCount(this.getConnectionPendingCount() + c);
    }
}

