/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;

public abstract class Socket
extends Net {
    public static final int STATE_CLOSED = 2;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_OPEN = 1;
    private InetAddress __m_InetAddress;
    private Exception __m_LastException;
    private long __m_LastExceptionLogMillis;
    private Object __m_Lock;
    private int __m_Port;
    private SocketProvider __m_Provider;
    private int __m_SoTimeout;
    private int __m_State;

    public Socket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void close() {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "STATE_INITIAL";
            }
            case 1: {
                return "STATE_OPEN";
            }
            case 2: {
                return "STATE_CLOSED";
            }
        }
        return "<unknown>";
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("address:port=")).append(Socket.toString(this.getInetAddress())).append(":").append(this.getPort()).toString();
    }

    public InetAddress getInetAddress() {
        return this.__m_InetAddress;
    }

    public Exception getLastException() {
        return this.__m_LastException;
    }

    public long getLastExceptionLogMillis() {
        return this.__m_LastExceptionLogMillis;
    }

    public Object getLock() {
        Object lock = this.__m_Lock;
        return lock == null ? this : lock;
    }

    public int getPort() {
        return this.__m_Port;
    }

    public SocketProvider getProvider() {
        return this.__m_Provider;
    }

    public int getSoTimeout() {
        return this.__m_SoTimeout;
    }

    public int getState() {
        return this.__m_State;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Socket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    protected void onException(IOException eException) {
        this.setLastException(eException);
        long ldtNow = Base.getSafeTimeMillis();
        if (this.getLastExceptionLogMillis() < ldtNow - 1000L) {
            this.setLastExceptionLogMillis(ldtNow);
            Component._trace(new StringBuilder(String.valueOf("Exception on ")).append(this).append("; ").append(eException).append("\n").append(Base.getStackTrace(eException)).toString(), 9);
        }
    }

    public void onInit() {
        this.setProvider(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER);
        super.onInit();
    }

    protected void onInterruptedIOException(InterruptedIOException eException) {
        this.onException(eException);
    }

    public void open() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInetAddress(InetAddress addr) {
        Object object = this.getLock();
        synchronized (object) {
            InetAddress addrCurr = this.getInetAddress();
            Component._assert((this.getState() == STATE_INITIAL ? true : addrCurr == null) ? true : addrCurr.isAnyLocalAddress(), "InetAddress cannot be modified once the socket has been opened");
            this.__m_InetAddress = addr;
        }
    }

    protected void setLastException(Exception e) {
        this.__m_LastException = e;
    }

    protected void setLastExceptionLogMillis(long lMillis) {
        this.__m_LastExceptionLogMillis = lMillis;
    }

    public void setLock(Object oLock) {
        Component._assert(this.getState() == STATE_INITIAL, "Lock cannot be modified once the socket has been opened");
        this.__m_Lock = oLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int nPort) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() == STATE_INITIAL, "Port cannot be modified once the socket has been opened");
            this.__m_Port = nPort;
        }
    }

    public void setProvider(SocketProvider provider) {
        if (provider == null) {
            provider = SocketProviderFactory.DEFAULT_SOCKET_PROVIDER;
        }
        this.__m_Provider = provider;
    }

    public void setSoTimeout(int cMillis) {
        this.__m_SoTimeout = cMillis;
    }

    protected void setState(int nState) {
        this.__m_State = nState;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.get_Name());
        sb.append("{State=").append(Socket.formatStateName(this.getState())).append(", ").append(this.getDescription()).append('}');
        return sb.toString();
    }

    public static String toString(InetAddress addr) {
        return InetAddressHelper.toString(addr);
    }

    protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
        if (cbActualSize < cbRequestedSize) {
            String sMsg = new StringBuilder(String.valueOf(this.get_Name())).append(" failed to set ").append(sBufferName).append(" buffer size to ").append(cbRequestedSize).append(" bytes; actual size is ").append(cbActualSize).append(" bytes. ").append("Consult your OS documentation regarding increasing the maximum socket buffer size.").toString();
            if (cbActualSize < cbMinimumSize) {
                Component._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            sMsg = new StringBuilder(String.valueOf(sMsg)).append(" Proceeding with the actual value may cause sub-optimal performance.").toString();
            Component._trace(sMsg, 2);
        }
    }

    protected void validateSoTimeout(int cActual, int cRequired) {
        if (cActual != cRequired) {
            throw new RuntimeException(new StringBuilder(String.valueOf("Failed to set SoTimeout to ")).append(cRequired).append("; actual value is ").append(cActual).toString());
        }
    }
}

