/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend.proxy;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.Proxy;
import com.tangosol.coherence.component.net.extend.message.request.NamedCacheRequest;
import com.tangosol.coherence.component.net.extend.messageFactory.NamedCacheFactory$MapEvent;
import com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.net.extend.proxy.MapListenerProxy;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy$CleanupTask;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy$EntrySet;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy$KeySet;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy$Values;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.SuspectConnectionException;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NamedCacheProxy
extends Proxy
implements NamedCacheDeactivationListener,
MemberListener,
NamedCache,
Channel.Receiver,
Runnable {
    public static final String ATTR_LISTENER = "named-cache-listener";
    public static final String ATTR_LOCK_MAP = "named-cache-lock-map";
    private Channel __m_Channel;
    private boolean __m_LockEnabled;
    private NamedCache __m_NamedCache;
    private boolean __m_ReadOnly;
    private long __m_TransferThreshold;
    private static ListMap __mapChildren;
    private static boolean __s_LockDeprecateWarned;

    static {
        NamedCacheProxy.__initStatic();
    }

    public NamedCacheProxy() {
        this(null, null, true);
    }

    public NamedCacheProxy(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setEnabled(true);
            this.setTransferThreshold(524288L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("CleanupTask", NamedCacheProxy$CleanupTask.get_CLASS());
        Class clazz2 = __mapChildren.put("EntrySet", NamedCacheProxy$EntrySet.get_CLASS());
        Class clazz3 = __mapChildren.put("KeySet", NamedCacheProxy$KeySet.get_CLASS());
        Class clazz4 = __mapChildren.put("Values", NamedCacheProxy$Values.get_CLASS());
    }

    private void addIndex$Router(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getNamedCache().addIndex(extractor, fOrdered, comparator);
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.assertWriteable();
        this.addIndex$Router(extractor, fOrdered, comparator);
    }

    public void addMapListener(MapListener listener) {
        this.getNamedCache().addMapListener(listener);
    }

    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        this.getNamedCache().addMapListener(listener, filter, fLite);
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.getNamedCache().addMapListener(listener, oKey, fLite);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getNamedCache().aggregate(filter, agent);
    }

    public Object aggregate(Collection colKeys, InvocableMap.EntryAggregator agent) {
        return this.getNamedCache().aggregate(colKeys, agent);
    }

    public void assertLockEnabled() {
        if (this.isLockEnabled()) {
            return;
        }
        throw new SecurityException(new StringBuilder(String.valueOf("lock operations are prohibited on NamedCache \"")).append(this.getCacheName()).append('\"').toString());
    }

    public void assertWriteable() {
        if (this.isReadOnly()) {
            throw new SecurityException(new StringBuilder(String.valueOf("NamedCache \"")).append(this.getCacheName()).append("\" is read-only").toString());
        }
    }

    private void clear$Router() {
        this.getNamedCache().clear();
    }

    public void clear() {
        this.assertWriteable();
        this.clear$Router();
    }

    protected void closeChannel() {
        Channel channel = this.getChannel();
        if (channel != null) {
            channel.close();
        }
    }

    public boolean containsKey(Object oKey) {
        return this.getNamedCache().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.getNamedCache().containsValue(oValue);
    }

    public void destroy() {
        throw new UnsupportedOperationException();
    }

    public void entryDeleted(MapEvent evt) {
        if (evt.getKey() == null) {
            this.closeChannel();
        }
    }

    public void entryInserted(MapEvent evt) {
    }

    private Set entrySet$Router() {
        return this.getNamedCache().entrySet();
    }

    public Set entrySet() {
        NamedCacheProxy$EntrySet set = (NamedCacheProxy$EntrySet)this._newChild("EntrySet");
        set.setSet(this.entrySet$Router());
        return set;
    }

    public Set entrySet(Filter filter) {
        return this.getNamedCache().entrySet(filter);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return this.getNamedCache().entrySet(filter, comparator);
    }

    public void entryUpdated(MapEvent evt) {
        Channel channel = this.getChannel();
        Component._assert(channel != null);
        Protocol.MessageFactory factory = channel.getMessageFactory();
        NamedCacheFactory$MapEvent message = (NamedCacheFactory$MapEvent)factory.createMessage(NamedCacheFactory$MapEvent.TYPE_ID);
        if (message.getImplVersion() >= 6) {
            message.setTruncate(true);
            try {
                channel.send(message);
            }
            catch (ConnectionException e) {
            }
            catch (Throwable t) {
                Component._trace(t, new StringBuilder(String.valueOf("Error sending MapEvent to ")).append(channel).toString());
            }
        } else {
            this.closeChannel();
        }
    }

    public Object get(Object oKey) {
        return this.getNamedCache().get(oKey);
    }

    public Map getAll(Collection colKeys) {
        return this.getNamedCache().getAll(colKeys);
    }

    public String getCacheName() {
        return this.getNamedCache().getCacheName();
    }

    public CacheService getCacheService() {
        return this.getNamedCache().getCacheService();
    }

    public Channel getChannel() {
        return this.__m_Channel;
    }

    protected String getDescription() {
        String sCacheName = null;
        String sServiceName = null;
        try {
            sCacheName = this.getCacheName();
            sServiceName = this.getCacheService().getInfo().getServiceName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new StringBuilder(String.valueOf("NamedCache=")).append(sCacheName == null ? "N/A" : sCacheName).append(", Service=").append(sServiceName == null ? "N/A" : sServiceName).toString();
    }

    public String getName() {
        return this.toString();
    }

    public NamedCache getNamedCache() {
        return this.__m_NamedCache;
    }

    public Protocol getProtocol() {
        return NamedCacheProtocol.getInstance();
    }

    public long getTransferThreshold() {
        return this.__m_TransferThreshold;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/proxy/NamedCacheProxy".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new NamedCacheProxy();
    }

    private final Component get_Module() {
        return this;
    }

    private Object invoke$Router(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invoke(oKey, agent);
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invoke$Router(oKey, agent);
    }

    private Map invokeAll$Router(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invokeAll(filter, agent);
    }

    private Map invokeAll$Router(Collection colKeys, InvocableMap.EntryProcessor agent) {
        return this.getNamedCache().invokeAll(colKeys, agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invokeAll$Router(filter, agent);
    }

    public Map invokeAll(Collection colKeys, InvocableMap.EntryProcessor agent) {
        this.assertWriteable();
        return this.invokeAll$Router(colKeys, agent);
    }

    public boolean isActive() {
        return this.getNamedCache().isActive();
    }

    public boolean isEmpty() {
        return this.getNamedCache().isEmpty();
    }

    public static boolean isLockDeprecateWarned() {
        return __s_LockDeprecateWarned;
    }

    public boolean isLockEnabled() {
        return this.__m_LockEnabled;
    }

    public boolean isReadOnly() {
        return this.__m_ReadOnly;
    }

    private Set keySet$Router() {
        return this.getNamedCache().keySet();
    }

    public Set keySet() {
        NamedCacheProxy$KeySet set = (NamedCacheProxy$KeySet)this._newChild("KeySet");
        set.setSet(this.keySet$Router());
        return set;
    }

    public Set keySet(Filter filter) {
        return this.getNamedCache().keySet(filter);
    }

    private boolean lock$Router(Object oKey) {
        return this.getNamedCache().lock(oKey);
    }

    private boolean lock$Router(Object oKey, long cWait) {
        return this.getNamedCache().lock(oKey, cWait);
    }

    public boolean lock(Object oKey) {
        this.assertLockEnabled();
        return this.lock$Router(oKey);
    }

    public boolean lock(Object oKey, long cWait) {
        this.printLockDeprecatedMessage();
        this.assertLockEnabled();
        return this.lock$Router(oKey, cWait);
    }

    public void memberJoined(MemberEvent evt) {
    }

    public void memberLeaving(MemberEvent evt) {
    }

    public void memberLeft(MemberEvent evt) {
        DistributedCacheService service = (DistributedCacheService)evt.getService();
        if (!(service.getPartitionOwner(0) == null) ? false : service.getOwnershipSenior() == null) {
            this.closeChannel();
        }
    }

    public void onMessage(Message message) {
        if (message instanceof NamedCacheRequest) {
            NamedCacheRequest request = (NamedCacheRequest)message;
            request.setNamedCache(this);
            request.setTransferThreshold(this.getTransferThreshold());
        }
        message.run();
    }

    public void printLockDeprecatedMessage() {
        if (NamedCacheProxy.isLockDeprecateWarned() ^ true) {
            Component._trace("Using the lock API from a Coherence*Extend client is deprecated and will be removed in a future release", 2);
            NamedCacheProxy.setLockDeprecateWarned(true);
        }
    }

    private Object put$Router(Object oKey, Object oValue) {
        return this.getNamedCache().put(oKey, oValue);
    }

    private Object put$Router(Object oKey, Object oValue, long cMillis) {
        return this.getNamedCache().put(oKey, oValue, cMillis);
    }

    public Object put(Object oKey, Object oValue) {
        this.assertWriteable();
        return this.put$Router(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        this.assertWriteable();
        return this.put$Router(oKey, oValue, cMillis);
    }

    private void putAll$Router(Map map) {
        this.getNamedCache().putAll(map);
    }

    public void putAll(Map map) {
        this.assertWriteable();
        this.putAll$Router(map);
    }

    public void registerChannel(Channel channel) {
        Component._assert(this.getChannel() == null);
        NamedCache cache = this.getNamedCache();
        Component._assert(cache != null);
        MapListenerProxy proxyListener = new MapListenerProxy();
        proxyListener.setChannel(channel);
        channel.setAttribute(ATTR_LISTENER, proxyListener);
        channel.setAttribute(ATTR_LOCK_MAP, new SegmentedConcurrentMap());
        this.setChannel(channel);
        cache.addMapListener(this);
        CacheService service = cache.getCacheService();
        if (!(service instanceof DistributedCacheService) ? false : ((DistributedCacheService)service).isLocalStorageEnabled() ^ true) {
            service.addMemberListener(this);
        }
    }

    public void release() {
        throw new UnsupportedOperationException();
    }

    private Object remove$Router(Object oKey) {
        return this.getNamedCache().remove(oKey);
    }

    public Object remove(Object oKey) {
        this.assertWriteable();
        return this.remove$Router(oKey);
    }

    private void removeIndex$Router(ValueExtractor extractor) {
        this.getNamedCache().removeIndex(extractor);
    }

    public void removeIndex(ValueExtractor extractor) {
        this.assertWriteable();
        this.removeIndex$Router(extractor);
    }

    public void removeMapListener(MapListener listener) {
        this.getNamedCache().removeMapListener(listener);
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        this.getNamedCache().removeMapListener(listener, filter);
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        this.getNamedCache().removeMapListener(listener, oKey);
    }

    public void run() {
    }

    protected void setChannel(Channel set) {
        this.__m_Channel = set;
    }

    public static void setLockDeprecateWarned(boolean fEnabled) {
        __s_LockDeprecateWarned = fEnabled;
    }

    public void setLockEnabled(boolean fEnabled) {
        this.__m_LockEnabled = fEnabled;
    }

    public void setNamedCache(NamedCache cache) {
        this.__m_NamedCache = cache;
    }

    public void setReadOnly(boolean fReadOnly) {
        this.__m_ReadOnly = fReadOnly;
    }

    public void setTransferThreshold(long cb) {
        this.__m_TransferThreshold = cb;
    }

    public int size() {
        return this.getNamedCache().size();
    }

    private void truncate$Router() {
        this.getNamedCache().truncate();
    }

    public void truncate() {
        this.assertWriteable();
        this.truncate$Router();
    }

    private boolean unlock$Router(Object oKey) {
        return this.getNamedCache().unlock(oKey);
    }

    public boolean unlock(Object oKey) {
        this.printLockDeprecatedMessage();
        this.assertLockEnabled();
        return this.unlock$Router(oKey);
    }

    public void unregisterChannel(Channel channel) {
        Connection connImpl;
        Throwable t;
        Component._assert(this.getChannel() == channel);
        NamedCache cache = this.getNamedCache();
        Component._assert(cache != null);
        MapListenerProxy proxyListener = (MapListenerProxy)channel.getAttribute(ATTR_LISTENER);
        Component._assert(proxyListener != null);
        cache.removeMapListener(this);
        com.tangosol.net.messaging.Connection conn = channel.getConnection();
        if (conn instanceof Connection && (!((t = (connImpl = (Connection)conn).getCloseThrowable()) != null) ? false : t instanceof SuspectConnectionException) && Component._isTraceEnabled(3)) {
            StringBuilder sb = new StringBuilder(new StringBuilder(String.valueOf(connImpl.toString())).append(' ').toString());
            ConcurrentMap filterMap = proxyListener.getFilterMap();
            ConcurrentMap keyMap = proxyListener.getKeyMap();
            int nListenerCount = 0;
            if (!filterMap.isEmpty() ? false : keyMap.isEmpty()) {
                sb.append("At the time it was closed, this suspect connection had no registered listeners");
            } else {
                sb.append(new StringBuilder(String.valueOf("At the time it was closed, this suspect connection had registered ")).append(keyMap.size()).append(" key and ").append(filterMap.size()).append(" filter listeners, including ").toString());
                if (filterMap.isEmpty() ^ true) {
                    Iterator it = filterMap.keySet().iterator();
                    while (!it.hasNext() ? false : nListenerCount < 50) {
                        Object nextKey = it.next();
                        Object[] nextValue = (Object[])filterMap.get(nextKey);
                        sb.append(new StringBuilder(String.valueOf("{filter=")).append(nextKey).append(", Lite event=").append(((Boolean)nextValue[1]).toString()).append('}').toString());
                        ++nListenerCount;
                    }
                }
                sb.append(new StringBuilder(String.valueOf(", (")).append(nListenerCount).append('/').append(filterMap.size()).append(" filter listeners logged)").toString());
            }
            if (sb.length() > 0) {
                Component._trace(sb.toString(), 3);
            }
        }
        NamedCacheProxy$CleanupTask task = new NamedCacheProxy$CleanupTask();
        task.setProxy(this);
        DaemonPool pool = (DaemonPool)this.getDaemonPool();
        if (!(pool != null) ? false : pool.isStarted()) {
            pool.add(task);
        } else {
            task.run();
        }
        channel.setAttribute(ATTR_LISTENER, null);
        channel.setAttribute(ATTR_LOCK_MAP, null);
        this.setChannel(null);
    }

    private Collection values$Router() {
        return this.getNamedCache().values();
    }

    public Collection values() {
        NamedCacheProxy$Values col = (NamedCacheProxy$Values)this._newChild("Values");
        col.setCollection(this.values$Router());
        return col;
    }
}

