/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.MemberSet$Iterator;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.license.LicensedObject;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.net.SocketAddress;
import java.util.Map;

public class MasterMemberSet
extends ServiceMemberSet {
    public static final int MAX_MEMBERS = 8160;
    private Map __m_AddressMap;
    private long __m_AscensionTimestamp;
    private transient int __m_MaximumPacketLength;
    private Map __m_MemberMap;
    private int __m_RecycleMillis;
    private ActualMemberSet __m_RecycleSet;
    private static ListMap __mapChildren;

    static {
        MasterMemberSet.__initStatic();
    }

    public MasterMemberSet() {
        this(null, null, true);
    }

    public MasterMemberSet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAddressMap(new SafeHashMap());
            this.setMemberMap(new SafeHashMap());
            this.setRecycleMillis(60000);
            this.setRecycleSet(new ActualMemberSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", MemberSet$Iterator.get_CLASS());
    }

    public synchronized boolean add(Object o) {
        if (super.add(o)) {
            Member memberNew = (Member)o;
            this.getMemberMap().put(memberNew.getUid32(), memberNew);
            this.getAddressMap().put(memberNew.getSocketAddress(), memberNew);
            this.getRecycleSet().remove(memberNew.getId());
            return true;
        }
        return false;
    }

    protected void appendEdition(StringBuilder sb, int nMember) {
        Member member = this.getMember(nMember);
        String sEdition = member == null ? "UNKNOWN" : Coherence.EDITION_NAMES[member.getEdition()];
        sb.append('|').append(sEdition);
    }

    protected void appendEditionHeader(StringBuilder sb) {
        sb.append("|Edition");
    }

    protected void appendTransport(StringBuilder sb, int nMember) {
    }

    protected void appendTransportHeader(StringBuilder sb) {
    }

    protected void appendVersion(StringBuilder sb, int nMember) {
        sb.append('|').append(this.getServiceVersionExternal(nMember));
    }

    protected void appendVersionHeader(StringBuilder sb) {
        sb.append("|Version");
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public long compareSeniority(Member memberA, Member memberB) {
        return memberA.getUid32().compareTo(memberB.getUid32());
    }

    public synchronized ObservableMap ensureMemberConfigMap(int i) {
        throw new UnsupportedOperationException();
    }

    public Member findDeadMember(Member member) {
        Member memberDead = this.getRecycleSet().getMember(member.getId());
        return (!(memberDead != null) ? false : memberDead.getUid32().equals(member.getUid32())) ? memberDead : null;
    }

    public Map getAddressMap() {
        return this.__m_AddressMap;
    }

    public long getAscensionTimestamp() {
        return this.__m_AscensionTimestamp;
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("\n  ThisMember=")).append(this.getThisMember()).append(super.getDescription()).append("\n  RecycleMillis=").append(this.getRecycleMillis()).append("\n  RecycleSet=").append(Base.indentString(this.getRecycleSet().toString(), "  ", false)).toString();
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public Member getMember(UUID uid) {
        return (Member)this.getMemberMap().get(uid);
    }

    public Member getMember(SocketAddress addr) {
        return (Member)this.getAddressMap().get(addr);
    }

    protected Map getMemberMap() {
        return this.__m_MemberMap;
    }

    public int getRecycleMillis() {
        return this.__m_RecycleMillis;
    }

    public ActualMemberSet getRecycleSet() {
        return this.__m_RecycleSet;
    }

    public String getServiceVersionExternal(int nMember) {
        return ServiceMemberSet.toVersionString(this.getServiceVersionInt(nMember), false);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/memberSet/actualMemberSet/serviceMemberSet/MasterMemberSet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new MasterMemberSet();
    }

    private final Component get_Module() {
        return this;
    }

    public final synchronized int induct(Member memberNew, ClusterService service) {
        Component._assert(!(memberNew != null) ? false : memberNew.getId() <= 1);
        Component._assert(this.getThisMember() == this.getOldestMember());
        if (((Cluster)service.getCluster()).isAuthorizedHost(memberNew.getAddress()) ^ true) {
            return ClusterService.REJECT_AUTHORIZE;
        }
        if (LicensedObject.isExpired()) {
            return ClusterService.REJECT_LICENSE_EXPIRED;
        }
        if (memberNew.getTimestamp() <= this.getLastJoinTime()) {
            return ClusterService.REJECT_RESTART;
        }
        long lCutoffMillis = Base.getSafeTimeMillis() - (long)this.getRecycleMillis();
        ActualMemberSet setRecycle = this.getRecycleSet();
        int i = 1;
        while (i <= MAX_MEMBERS) {
            Member memberDead;
            if (this.contains(i) ^ true && ((memberDead = ((MemberSet)setRecycle).getMember(i)) == null ? true : memberDead.getTimestamp() < lCutoffMillis)) {
                memberNew.setId(i);
                this.add(memberNew);
                if (Directed.calcHeaderLength(this) <= this.getMaximumPacketLength()) {
                    return ClusterService.REJECT_NONE;
                }
                this.remove(memberNew);
                this.getRecycleSet().remove(memberNew);
                break;
            }
            ++i;
        }
        return ClusterService.REJECT_SIZE;
    }

    public synchronized boolean remove(Object o) {
        Component._assert(o != this.getThisMember());
        if (super.remove(o)) {
            Member member = (Member)o;
            this.getMemberMap().remove(member.getUid32());
            this.getAddressMap().remove(member.getSocketAddress());
            member.setDead(true);
            this.getRecycleSet().add(member);
            return true;
        }
        return false;
    }

    public void setAddressMap(Map mapAddress) {
        this.__m_AddressMap = mapAddress;
    }

    public void setAscensionTimestamp(long lTimestamp) {
        this.__m_AscensionTimestamp = lTimestamp;
    }

    public void setMaximumPacketLength(int cb) {
        this.__m_MaximumPacketLength = cb;
    }

    protected void setMemberMap(Map map) {
        this.__m_MemberMap = map;
    }

    protected synchronized void setOldestMember(Member member) {
        super.setOldestMember(member);
        this.setAscensionTimestamp(Base.getSafeTimeMillis());
    }

    public void setRecycleMillis(int cMillis) {
        this.__m_RecycleMillis = cMillis;
    }

    protected void setRecycleSet(ActualMemberSet set) {
        this.__m_RecycleSet = set;
    }

    private void setServiceVersionExternal(int nMember, String sVersion) {
    }
}

