/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MapEventMessage
extends Message {
    public static final int ENTRY_DELETED = 3;
    public static final int ENTRY_INSERTED = 1;
    public static final int ENTRY_UPDATED = 2;
    public static final int EVT_DELTA_COMPRESSED = 16;
    private static final int EVT_OPT_NEW_SKIP = 256;
    private static final int EVT_OPT_NEW_SWAP = 512;
    private static final int EVT_OPT_OLD_SKIP = 1024;
    private static final int EVT_OPT_OLD_SWAP = 2048;
    public static final int EVT_PRIMING = 64;
    public static final int EVT_SYNTHETIC = 8;
    public static final int EVT_TRANSFORMED = 32;
    public static final int EVT_TYPE_MASK = 7;
    private long __m_CacheId;
    private long __m_EventSUID;
    private int __m_EventType;
    private long[] __m_FilterId;
    private Binary __m_Key;
    private Binary __m_NewValue;
    private Binary __m_OldValue;
    private long __m_OldestPendingEventSUID;

    public MapEventMessage() {
        this(null, null, true);
    }

    public MapEventMessage(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setNotifyDelivery(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Object compressEventHolder(Object oEvent, Binary binValueOld, Binary binValueNew) {
        if (oEvent instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEvent;
            int nType = msgEvent.getEventType();
            if (binValueOld != null) {
                if (binValueOld.equals(msgEvent.getOldValue())) {
                    nType |= EVT_OPT_OLD_SKIP;
                } else if (binValueOld.equals(msgEvent.getNewValue())) {
                    nType |= EVT_OPT_NEW_SWAP;
                }
            }
            if (binValueNew != null) {
                if (binValueNew.equals(msgEvent.getNewValue())) {
                    nType |= EVT_OPT_NEW_SKIP;
                } else if (binValueNew.equals(msgEvent.getOldValue())) {
                    nType |= EVT_OPT_OLD_SWAP;
                }
            }
            msgEvent.setEventType(nType);
        } else if (oEvent != null) {
            Iterator iter = ((List)oEvent).iterator();
            while (iter.hasNext()) {
                MapEventMessage.compressEventHolder(iter.next(), binValueOld, binValueNew);
            }
        }
        return oEvent;
    }

    public static Object decompressEventHolder(Object oEvent, long lCacheId, Binary binKey, Binary binValueOld, Binary binValueNew) {
        if (oEvent instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEvent;
            msgEvent.setCacheId(lCacheId);
            msgEvent.setKey(binKey);
            int nType = msgEvent.getEventType();
            switch (nType & (EVT_OPT_OLD_SKIP | EVT_OPT_OLD_SWAP)) {
                case 1024: {
                    msgEvent.setOldValue(binValueOld);
                    nType &= ~EVT_OPT_OLD_SKIP;
                    break;
                }
                case 2048: {
                    msgEvent.setOldValue(binValueNew);
                    nType &= ~EVT_OPT_OLD_SWAP;
                    break;
                }
            }
            switch (nType & (EVT_OPT_NEW_SKIP | EVT_OPT_NEW_SWAP)) {
                case 256: {
                    msgEvent.setNewValue(binValueNew);
                    nType &= ~EVT_OPT_NEW_SKIP;
                    break;
                }
                case 512: {
                    msgEvent.setNewValue(binValueOld);
                    nType &= ~EVT_OPT_NEW_SWAP;
                    break;
                }
            }
            msgEvent.setEventType(nType);
        } else if (oEvent != null) {
            Iterator iter = ((List)oEvent).iterator();
            while (iter.hasNext()) {
                MapEventMessage.decompressEventHolder(iter.next(), lCacheId, binKey, binValueOld, binValueNew);
            }
        }
        return oEvent;
    }

    public long getCacheId() {
        return this.__m_CacheId;
    }

    public String getCacheName() {
        return new StringBuilder(String.valueOf('[')).append(String.valueOf(this.getCacheId())).append(']').toString();
    }

    public DeltaCompressor getDeltaCompressor() {
        return NullImplementation.getDeltaCompressor();
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("CacheName=")).append(this.getCacheName()).append(", EventType=").append(MapEvent.getDescription(this.getEventType() & EVT_TYPE_MASK)).append(", Key=").append(this.getKey()).append(", OldValue=").append(this.getOldValue()).append(", NewValue=").append(this.getNewValue()).toString();
    }

    public long getEventSUID() {
        return this.__m_EventSUID;
    }

    public int getEventType() {
        return this.__m_EventType;
    }

    public long[] getFilterId() {
        return this.__m_FilterId;
    }

    public Binary getKey() {
        return this.__m_Key;
    }

    public Binary getNewValue() {
        return this.__m_NewValue;
    }

    public Binary getOldValue() {
        return this.__m_OldValue;
    }

    public long getOldestPendingEventSUID() {
        return this.__m_OldestPendingEventSUID;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/message/MapEventMessage".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new MapEventMessage();
    }

    private final Component get_Module() {
        return this;
    }

    public static boolean isCompressedNewValue(Object oEventHolder) {
        if (oEventHolder == null) {
            return false;
        }
        if (oEventHolder instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEventHolder;
            int nType = msgEvent.getEventType();
            return (nType & (EVT_OPT_NEW_SKIP | EVT_OPT_NEW_SWAP)) != 0;
        }
        Iterator iter = ((List)oEventHolder).iterator();
        while (iter.hasNext()) {
            if (!MapEventMessage.isCompressedNewValue(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompressedOldValue(Object oEventHolder) {
        if (oEventHolder == null) {
            return false;
        }
        if (oEventHolder instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEventHolder;
            int nType = msgEvent.getEventType();
            return (nType & (EVT_OPT_OLD_SKIP | EVT_OPT_OLD_SWAP)) != 0;
        }
        Iterator iter = ((List)oEventHolder).iterator();
        while (iter.hasNext()) {
            if (!MapEventMessage.isCompressedOldValue(iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isPriming() {
        return (this.getEventType() & EVT_PRIMING) != 0;
    }

    public boolean isSynthetic() {
        return (this.getEventType() & EVT_SYNTHETIC) != 0;
    }

    public boolean isTransformed() {
        return (this.getEventType() & EVT_TRANSFORMED) != 0;
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.readImpl(input, false);
    }

    protected void readImpl(DataInput stream, boolean fSupplemental) throws IOException {
        this.setEventSUID(ExternalizableHelper.readLong(stream));
        this.setOldestPendingEventSUID(ExternalizableHelper.readLong(stream));
        int nType = ExternalizableHelper.readInt(stream);
        if (fSupplemental) {
            this.ensureToMemberSet().readExternal(stream);
            int nEvent = nType & EVT_TYPE_MASK;
            if (!(nEvent != ENTRY_INSERTED) ? false : (nType & (EVT_OPT_OLD_SKIP | EVT_OPT_OLD_SWAP)) == 0) {
                this.setOldValue((Binary)ExternalizableHelper.readObject(stream, null));
            }
            if (!(nEvent != ENTRY_DELETED) ? false : (nType & (EVT_OPT_NEW_SKIP | EVT_OPT_NEW_SWAP)) == 0) {
                this.setNewValue((Binary)ExternalizableHelper.readObject(stream, null));
            }
        } else {
            this.setCacheId(ExternalizableHelper.readLong(stream));
            this.setKey((Binary)ExternalizableHelper.readObject(stream, null));
            Binary binValueOld = (Binary)ExternalizableHelper.readObject(stream, null);
            Binary binValueNew = (Binary)ExternalizableHelper.readObject(stream, null);
            if ((nType & EVT_DELTA_COMPRESSED) != 0) {
                binValueNew = this.getDeltaCompressor().applyDelta(binValueOld, binValueNew).toBinary();
                nType &= ~EVT_DELTA_COMPRESSED;
            }
            this.setOldValue(binValueOld);
            this.setNewValue(binValueNew);
        }
        this.setEventType(nType);
        int cFilters = stream.readUnsignedShort();
        if (cFilters > 0) {
            long[] alFilterId = new long[cFilters];
            int i = 0;
            while (i < cFilters) {
                alFilterId[i] = ExternalizableHelper.readLong(stream);
                ++i;
            }
            this.setFilterId(alFilterId);
        }
    }

    public static Object readSupplemental(DataInput stream, Grid service) throws IOException {
        int cEvents = ExternalizableHelper.readInt(stream);
        switch (cEvents) {
            case 0: {
                return null;
            }
            case 1: {
                int nMsgType = ExternalizableHelper.readInt(stream);
                MapEventMessage event = (MapEventMessage)service.instantiateMessage(nMsgType);
                event.readImpl(stream, true);
                return event;
            }
        }
        LinkedList<MapEventMessage> listEvents = new LinkedList<MapEventMessage>();
        int i = 0;
        while (i < cEvents) {
            int nMsgType = ExternalizableHelper.readInt(stream);
            MapEventMessage event = (MapEventMessage)service.instantiateMessage(nMsgType);
            event.readImpl(stream, true);
            listEvents.add(event);
            ++i;
        }
        return listEvents;
    }

    public void setCacheId(long lId) {
        this.__m_CacheId = lId;
    }

    public void setEventSUID(long lSUID) {
        this.__m_EventSUID = lSUID;
    }

    public void setEventType(int nType) {
        this.__m_EventType = nType;
    }

    public void setFilterId(long[] alFilterId) {
        this.__m_FilterId = alFilterId;
    }

    public void setKey(Binary binKey) {
        this.__m_Key = binKey;
    }

    public void setNewValue(Binary binValue) {
        this.__m_NewValue = binValue;
    }

    public void setOldValue(Binary binValue) {
        this.__m_OldValue = binValue;
    }

    public void setOldestPendingEventSUID(long lSUID) {
        this.__m_OldestPendingEventSUID = lSUID;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        this.writeImpl(output, false);
    }

    protected void writeImpl(DataOutput stream, boolean fSupplemental) throws IOException {
        int nType = this.getEventType();
        ExternalizableHelper.writeLong(stream, this.getEventSUID());
        ExternalizableHelper.writeLong(stream, this.getOldestPendingEventSUID());
        if (fSupplemental) {
            ExternalizableHelper.writeInt(stream, nType);
            this.ensureToMemberSet().writeExternal(stream);
            int nEvent = nType & EVT_TYPE_MASK;
            if (!(nEvent != ENTRY_INSERTED) ? false : (nType & (EVT_OPT_OLD_SKIP | EVT_OPT_OLD_SWAP)) == 0) {
                ExternalizableHelper.writeObject(stream, this.getOldValue());
            }
            if (!(nEvent != ENTRY_DELETED) ? false : (nType & (EVT_OPT_NEW_SKIP | EVT_OPT_NEW_SWAP)) == 0) {
                ExternalizableHelper.writeObject(stream, this.getNewValue());
            }
        } else {
            Binary binValueOld = this.getOldValue();
            Binary binValueNew = this.getNewValue();
            if (!(binValueOld != null) ? false : binValueNew != null) {
                ReadBuffer bufDelta = this.getDeltaCompressor().extractDelta(binValueOld, binValueNew);
                binValueNew = bufDelta == null ? null : bufDelta.toBinary();
                nType |= EVT_DELTA_COMPRESSED;
            }
            ExternalizableHelper.writeInt(stream, nType);
            ExternalizableHelper.writeLong(stream, this.getCacheId());
            ExternalizableHelper.writeObject(stream, this.getKey());
            ExternalizableHelper.writeObject(stream, binValueOld);
            ExternalizableHelper.writeObject(stream, binValueNew);
        }
        long[] alFilterId = this.getFilterId();
        int cFilters = alFilterId == null ? 0 : alFilterId.length;
        stream.writeShort(cFilters);
        int i = 0;
        while (i < cFilters) {
            ExternalizableHelper.writeLong(stream, alFilterId[i]);
            ++i;
        }
    }

    public static void writeSupplemental(DataOutput stream, Object oEventHolder) throws IOException {
        if (oEventHolder == null) {
            ExternalizableHelper.writeInt(stream, 0);
        } else if (oEventHolder instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEventHolder;
            ExternalizableHelper.writeInt(stream, 1);
            ExternalizableHelper.writeInt(stream, msgEvent.getMessageType());
            msgEvent.writeImpl(stream, true);
        } else {
            List listEvents = (List)oEventHolder;
            ExternalizableHelper.writeInt(stream, listEvents.size());
            Iterator iter = listEvents.iterator();
            while (iter.hasNext()) {
                MapEventMessage msgEvent = (MapEventMessage)iter.next();
                ExternalizableHelper.writeInt(stream, msgEvent.getMessageType());
                msgEvent.writeImpl(stream, true);
            }
        }
    }
}

