/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.messagePacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.sql.Time;
import java.util.Iterator;

public class Directed
extends MessagePacket {
    private int __m_ToMessageId;

    public Directed() {
        this(null, null, true);
    }

    public Directed(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDeliveryState(0);
            this.setPacketType(232718548);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static int calcHeaderLength(MemberSet memberSet) {
        switch (Directed.selectType(memberSet)) {
            case 0: {
                return 0;
            }
            case 232718549: {
                return 4 + 2 + 3 + 2 + 3 + 3 + 2 + 2 + 2;
            }
            case 232718547: {
                return 4 + 1 + 2 + 3 + 3 + 2 + 2 + 2 + (2 + 3) * memberSet.size();
            }
            case 232718548: {
                return 4 + 2 + 2 + 3 + 3 + 2 + 2 + 2 + 1 + 3 * memberSet.size() + 4 * (memberSet.getLastId() + 31) / 32;
            }
        }
        throw new IllegalArgumentException("Unknwon type");
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("ToMemberSet=");
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append('[');
            boolean fFirst = true;
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                Member member = (Member)iter.next();
                int nMember = member.getId();
                sb.append(nMember);
                int nToMsgId = setMember.getDestinationMessageId(nMember);
                if (!(nToMsgId != 0)) continue;
                sb.append('(').append(nToMsgId).append(')');
            }
            sb.append(']');
        }
        long ldtResend = this.getResendScheduled();
        long ldtTimeout = this.getResendTimeout();
        String sResend = ldtResend <= (long)0 ? "none" : new StringBuilder(String.valueOf(new Time(ldtResend).toString())).append(".").append(ldtResend % (long)1000).toString();
        String sTimeout = ldtTimeout <= (long)0 ? "none" : new StringBuilder(String.valueOf(new Time(ldtTimeout).toString())).append(".").append(ldtTimeout % (long)1000).toString();
        sb.append(", ServiceId=").append(this.getServiceId()).append(", MessageType=").append(this.getMessageType()).append(", FromMessageId=").append(this.getFromMessageId()).append(", ToMessageId=").append(this.getToMessageId()).append(", MessagePartCount=").append(this.getMessagePartCount()).append(", MessagePartIndex=").append(this.getMessagePartIndex()).append(", NackInProgress=").append(this.isNackInProgress()).append(", ResendScheduled=").append(sResend).append(", Timeout=").append(sTimeout).append(", PendingResendSkips=").append(this.getPendingResendSkips()).append(", DeliveryState=").append(this.formatDeliveryState(this.getDeliveryState())).append(", HeaderLength=").append(this.getHeaderLength()).append(", BodyLength=").append(this.getBodyLength()).append(", Body=");
        if (this.isOutgoing()) {
            sb.append(this.getReadBuffer() == null ? "Empty" : Base.toHexEscape(this.getReadBuffer().toByteArray()));
        } else {
            sb.append(this.getByteBuffer() == null ? "Empty" : Base.toHexEscape(new ByteBufferReadBuffer(this.getByteBuffer()).toByteArray()));
        }
        return sb.toString();
    }

    public int getDestinationMessageId(int nMemberId) {
        if (nMemberId == this.getToId()) {
            return this.getToMessageId();
        }
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember != null) {
            return setMember.getDestinationMessageId(nMemberId);
        }
        return 0;
    }

    public int getHeaderLength() {
        return Directed.calcHeaderLength(this.getToMemberSet());
    }

    public int getToMessageId() {
        return this.__m_ToMessageId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/messagePacket/Directed".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Directed();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isConfirmationRequired() {
        return true;
    }

    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        int cMembers = 0;
        int iMember = -1;
        switch (this.getPacketType()) {
            case 232718549: {
                int nIdTmp = input.readUnsignedShort();
                MessagePacket.assertIO(nIdTmp == nMemberId);
                cMembers = 1;
                iMember = 0;
                break;
            }
            case 232718547: {
                cMembers = input.readUnsignedByte();
                int i = 0;
                while (i < cMembers) {
                    if (input.readUnsignedShort() == nMemberId) {
                        iMember = i;
                    }
                    ++i;
                }
                break;
            }
            case 232718548: {
                int cBitSets = input.readUnsignedByte();
                int nTheSet = Member.calcByteOffset(nMemberId);
                int nTheMask = Member.calcByteMask(nMemberId);
                int nPartial = nTheMask >>> 1;
                int i = 1;
                int iShift = 1;
                while (i <= 5) {
                    nPartial |= nPartial >>> iShift;
                    ++i;
                    iShift <<= 1;
                }
                i = 0;
                while (i < cBitSets) {
                    int nBits = input.readInt();
                    if (i == nTheSet) {
                        MessagePacket.assertIO((nBits & nTheMask) != 0);
                        iMember = cMembers + MemberSet.countBits(nBits & nPartial);
                    }
                    cMembers += MemberSet.countBits(nBits);
                    ++i;
                }
                int cMembersTmp = input.readUnsignedShort();
                MessagePacket.assertIO(cMembersTmp == cMembers);
                break;
            }
            default: {
                throw new IOException(new StringBuilder(String.valueOf("unknown packet type: ")).append(this.getPacketType()).toString());
            }
        }
        MessagePacket.assertIO(!(!(cMembers > 0) ? false : iMember >= 0) ? false : iMember < cMembers);
        int cbSkip = iMember * 3;
        if (cbSkip > 0) {
            long cbSkipped = input.skip(cbSkip);
            MessagePacket.assertIO(cbSkipped == (long)cbSkip);
        }
        this.setToMessageId(Packet.readUnsignedTrint(input));
        cbSkip = (cMembers - iMember - 1) * 3;
        if (cbSkip > 0) {
            long cbSkipped = input.skip(cbSkip);
            MessagePacket.assertIO(cbSkipped == (long)cbSkip);
        }
        this.setFromId(input.readUnsignedShort());
        this.setFromMessageId(Packet.readUnsignedTrint(input));
        this.setMessagePartCount(Packet.readUnsignedTrint(input));
        this.setServiceId(input.readUnsignedShort());
        this.setMessageType(input.readShort());
        this.setBodyLength(input.readUnsignedShort());
        MessagePacket.assertIO(input.available() >= this.getBodyLength());
    }

    protected static int selectType(MemberSet memberSet) {
        int cMembers = memberSet == null ? 1 : memberSet.size();
        switch (cMembers) {
            case 0: {
                return MessagePacket.TYPE_NO_DESTINATION;
            }
            case 1: {
                return Packet.TYPE_DIRECTED_ONE;
            }
            case 2: 
            case 3: {
                return Packet.TYPE_DIRECTED_FEW;
            }
        }
        if (cMembers > 255) {
            return Packet.TYPE_DIRECTED_MANY;
        }
        return 19 + 5 * cMembers <= 21 + 3 * cMembers + 4 * ((memberSet.getLastId() + 31) / 32) ? Packet.TYPE_DIRECTED_FEW : Packet.TYPE_DIRECTED_MANY;
    }

    public void setToMessageId(int nId) {
        this.__m_ToMessageId = nId;
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        int cMembers = 0;
        int cbSkip = 0;
        switch (nType) {
            case 232718549: {
                cMembers = 1;
                cbSkip += 2;
                break;
            }
            case 232718547: {
                cMembers = input.readUnsignedByte();
                cbSkip += cMembers << 1;
                break;
            }
            case 232718548: {
                int cBitSets = input.readUnsignedByte();
                Packet.ensureSkipBytes(input, cbSkip += cBitSets << 2);
                cbSkip = 0;
                cMembers = input.readUnsignedShort();
                break;
            }
            default: {
                throw new IOException(new StringBuilder(String.valueOf("unknown packet type: ")).append(nType).toString());
            }
        }
        cbSkip += cMembers * 3;
        Packet.ensureSkipBytes(input, cbSkip += 12);
        Packet.ensureSkipBytes(input, input.readUnsignedShort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        DependentMemberSet memberSet = this.getToMemberSet();
        if (memberSet == null) {
            this.setPacketType(Packet.TYPE_DIRECTED_ONE);
            output.writeInt(Packet.TYPE_DIRECTED_ONE);
            output.writeShort(this.getToId());
            Packet.writeTrint(output, this.getToMessageId());
        } else {
            DependentMemberSet dependentMemberSet = memberSet;
            synchronized (dependentMemberSet) {
                int nType = Directed.selectType(memberSet);
                if (nType == MessagePacket.TYPE_NO_DESTINATION) return;
                boolean bl = false;
                if (bl) {
                    return;
                }
                this.setPacketType(nType);
                output.writeInt(nType);
                switch (nType) {
                    case 232718549: {
                        memberSet.writeOneWithMessageId(output);
                        break;
                    }
                    case 232718547: {
                        memberSet.writeFewWithMessageId(output);
                        break;
                    }
                    case 232718548: {
                        memberSet.writeManyWithMessageId(output);
                        break;
                    }
                    default: {
                        throw new IOException(new StringBuilder(String.valueOf("unknown packet type: ")).append(nType).toString());
                    }
                }
            }
        }
        output.writeShort(this.getFromId());
        Packet.writeTrint(output, this.getFromMessageId());
        Packet.writeTrint(output, this.getMessagePartCount());
        output.writeShort(this.getServiceId());
        output.writeShort(this.getMessageType());
        output.writeShort(this.getBodyLength());
        output.writeBuffer(this.getReadBuffer());
    }
}

