/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferControl;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.Registry;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.util.Base;
import java.util.Set;

public abstract class DistributionStrategy
extends Util {
    public static final long PENDING_WARNING_INTERVAL = 30000L;
    public static final int REPORT_BRIEF = 1;
    public static final int REPORT_VERBOSE = 2;
    private boolean __m_DistributionInProgress;
    private long __m_DistributionsPendingStart;
    private PartitionedService __m_Service;
    private long __m_StatsSampleNextMillis;
    private long __m_StatsSamplingInterval;
    private long __m_WarningNextMillis;
    private static /* synthetic */ Class __sf0;

    public DistributionStrategy(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void checkDistribution(MemberSet setOwners, Set setLeaving) {
    }

    protected String displayPendingState(boolean fVerbose) {
        int cIncoming;
        PartitionedService$TransferControl ctrlTransfer;
        StringBuilder sb = new StringBuilder("");
        PartitionedService service = this.getService();
        String sSeparator = "";
        if (this.isDistributionInProgress()) {
            sb.append(new StringBuilder(String.valueOf("The service currently has an active outgoing (sent but not yet completed) request")).append(" for a primary distribution.").toString());
            sSeparator = "\n";
        }
        if ((ctrlTransfer = service.getTransferControl()).isInProgress()) {
            boolean fPrimary = ctrlTransfer.getDistributionRequest() != null;
            sb.append(sSeparator).append("There are ").append(ctrlTransfer.getTransferCount()).append(" outgoing ").append(fPrimary ? "primary" : "backup").append(" transfers in progress");
            sSeparator = "\n";
        }
        if ((cIncoming = ctrlTransfer.getIncomingTransfers().size()) > 0) {
            sb.append(sSeparator).append("There are ").append(cIncoming).append(" incoming transfers in progress");
        }
        return sb.toString();
    }

    public int getBackupCount() {
        return this.getService().getBackupCount();
    }

    public long getDistributionsPendingStart() {
        return this.__m_DistributionsPendingStart;
    }

    public int[][] getPartitionAssignments() {
        return this.getService().getPartitionAssignments();
    }

    public int getPartitionCount() {
        return this.getService().getPartitionCount();
    }

    public PartitionedService getService() {
        return this.__m_Service;
    }

    public long getStatsSampleNextMillis() {
        return this.__m_StatsSampleNextMillis;
    }

    public long getStatsSamplingInterval() {
        return this.__m_StatsSamplingInterval;
    }

    public Member getThisMember() {
        return this.getService().getThisMember();
    }

    public long getWarningNextMillis() {
        return this.__m_WarningNextMillis;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DistributionStrategy".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public void initialize() {
    }

    public boolean isDistributionInProgress() {
        return this.__m_DistributionInProgress;
    }

    public void onDistributionCompleted(Member member, boolean fSuccess) {
    }

    public void onDistributionPlanUpdate(PartitionedService.DistributionPlanUpdate msgUpdate) {
    }

    public void onDistributionRequest(RequestMessage msgRequest) {
    }

    public void onMembershipChanged(int iReason) {
        this.scheduleImmediate();
    }

    public void onPartitionStatsUpdate(PartitionedService.PartitionStatsUpdate msgUpdate) {
    }

    public void recoverOrphans(PartitionSet partsOrphan, MemberSet setOwners, Set setLeaving, GUIDHelper.GUIDResolver resolverGUID, String sSnapshot) {
    }

    public void reportLateDistributions() {
        block4: {
            long ldtPendingStart;
            long ldtNow;
            block3: {
                ldtNow = Base.getSafeTimeMillis();
                ldtPendingStart = this.getDistributionsPendingStart();
                if (!(ldtPendingStart == 0L)) break block3;
                this.setDistributionsPendingStart(ldtNow);
                this.setWarningNextMillis(ldtNow + PENDING_WARNING_INTERVAL);
                break block4;
            }
            if (!(ldtNow > this.getWarningNextMillis())) break block4;
            long cLateSecs = (ldtNow - ldtPendingStart) / (long)1000;
            Component._trace(new StringBuilder(String.valueOf("Current partition distribution has been pending for over ")).append(cLateSecs).append(" seconds;\n").append(this.reportLocalDistributionState(true)).toString(), 2);
            this.setWarningNextMillis(ldtNow + PENDING_WARNING_INTERVAL);
            if (!(cLateSecs >= (long)300) ? false : Config.getBoolean("coherence.distributed.diagnose.stuck")) {
                Registry registry = this.getService().getCluster().getManagement();
                MBeanServerProxy proxy = registry.getMBeanServerProxy();
                String sClusterMBean = "Coherence:type=Cluster";
                String sRoleName = this.getService().getThisMember().getRoleName();
                try {
                    proxy.invoke(sClusterMBean, "logClusterState", new Object[]{sRoleName}, new String[]{DistributionStrategy.__sm0().getName()});
                    proxy.invoke(sClusterMBean, "dumpClusterHeap", new Object[]{sRoleName}, new String[]{DistributionStrategy.__sm0().getName()});
                }
                catch (Exception e) {
                    Component._trace(new StringBuilder(String.valueOf("Failed to logClusterState or dumpClusterHeap ")).append(e.getMessage()).toString(), 2);
                }
            }
        }
    }

    public String reportLocalDistributionState(boolean fVerbose) {
        return "Operation is not implemented by this distribution strategy.";
    }

    public void scheduleImmediate() {
        this.getService().setDistributionNextMillis(0L);
    }

    protected void setDistributionInProgress(boolean fDistribution) {
        this.__m_DistributionInProgress = fDistribution;
    }

    public void setDistributionsPendingStart(long lStart) {
        this.__m_DistributionsPendingStart = lStart;
    }

    public void setService(PartitionedService service) {
        this.__m_Service = service;
    }

    public void setStatsSampleNextMillis(long lMillis) {
        this.__m_StatsSampleNextMillis = lMillis;
    }

    public void setStatsSamplingInterval(long lInterval) {
        this.__m_StatsSamplingInterval = lInterval;
    }

    public void setWarningNextMillis(long lMillis) {
        this.__m_WarningNextMillis = lMillis;
    }
}

