/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounceReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounceWait;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberHeartbeat;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;

public class ClusterService$NewMemberAnnounce
extends DiscoveryMessage {
    public static final int MESSAGE_TYPE = 7;
    private int __m_AnnounceProtocolVersion;
    private int __m_AttemptCounter;
    private int __m_AttemptLimit;
    private transient long __m_ThisRecvTimestamp;
    private long __m_ThisSentTimestamp;

    public ClusterService$NewMemberAnnounce() {
        this(null, null, true);
    }

    public ClusterService$NewMemberAnnounce(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(7);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getAnnounceProtocolVersion() {
        return this.__m_AnnounceProtocolVersion;
    }

    public int getAttemptCounter() {
        return this.__m_AttemptCounter;
    }

    public int getAttemptLimit() {
        return this.__m_AttemptLimit;
    }

    public String getDescription() {
        long lThisSentTimestamp = this.getThisSentTimestamp() & 0xFFFFFFFFFFFFFFL;
        long lThisRecvTimestamp = this.getThisRecvTimestamp();
        String sThisSentTimestamp = lThisSentTimestamp == 0L ? "none" : new Date(lThisSentTimestamp).toString();
        String sThisRecvTimestamp = lThisRecvTimestamp == 0L ? "none" : new Date(lThisRecvTimestamp).toString();
        return new StringBuilder(String.valueOf("AttemptCounter=")).append(this.getAttemptCounter()).append("\nAttemptLimit=").append(this.getAttemptLimit()).append("\nThisSentTimestamp=").append(sThisSentTimestamp).append("\nThisRecvTimestamp=").append(sThisRecvTimestamp).toString();
    }

    public long getThisRecvTimestamp() {
        return this.__m_ThisRecvTimestamp;
    }

    public long getThisSentTimestamp() {
        return this.__m_ThisSentTimestamp;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberAnnounce".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberAnnounce();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        Member memberNew = this.getFromMember();
        InetSocketAddress addrSockSrc = (InetSocketAddress)this.getSourceAddress();
        InetAddress addrSrc = addrSockSrc == null ? null : addrSockSrc.getAddress();
        if (!(!(!(!(!(!(this.getAnnounceProtocolVersion() >= 1) ? false : service.isWkaEnabled()) ? false : addrSrc != null) ? false : memberNew.getAddress().equals(addrSrc) ^ true) ? false : addrSockSrc.getPort() == memberNew.getPort()) ? false : InetAddresses.isLocalAddress(addrSrc) ^ true)) {
            addrSockSrc = null;
            addrSrc = null;
        }
        service.setStatsJoinRequests(service.getStatsJoinRequests() + 1L);
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(ClusterService.REJECT_VERSION, memberNew);
                    throw new EventDeathException("Version mismatch");
                }
                Member memberThis = service.getAnnounceMember();
                if (memberNew.equals(memberThis)) {
                    ClusterDependencies config = service.getCluster().getDependencies();
                    if (!(!(addrSrc != null) ? false : config.getLocalAddress() == null)) break;
                    Member memberAnnounce = service.instantiateMember();
                    memberAnnounce.configure(config, addrSrc, memberThis.getPort(), memberThis.getTcpRingPort(), new int[]{memberThis.getCpuCount(), memberThis.getSocketCount(), memberThis.getMachineId()});
                    service.setAnnounceMember(memberAnnounce);
                    service.resetBroadcastCounter("selecting alternate member address", this);
                    break;
                }
                if (!(!(!(this.getAttemptCounter() > this.getAttemptLimit() / ClusterService.ANNOUNCE_BIND_THRESHOLD) ? false : ((service.isWellKnown(memberNew.getAddress()) ? true : service.isWellKnown(memberNew)) ? true : (!(addrSrc != null) ? false : service.isWellKnown(addrSrc)))) ? false : memberThis.compareTo(memberNew) > 0)) break;
                service.resetBroadcastCounter("an older member announcing", this);
                break;
            }
            case 2: {
                boolean fJoinSuspended;
                if (this.isReadError()) {
                    throw new EventDeathException("Version mismatch");
                }
                MasterMemberSet setMember = service.getClusterMemberSet();
                Member memberThis = setMember.getThisMember();
                Member memberSenior = setMember.getOldestMember();
                boolean fRecordAnnouncing = fJoinSuspended = service.isMembershipSuspended();
                if (!(memberThis == memberSenior) ? false : fJoinSuspended ^ true) {
                    if (memberNew.getId() == 0) {
                        ClusterService$NewMemberAnnounceReply msg = (ClusterService$NewMemberAnnounceReply)service.instantiateMessage("NewMemberAnnounceReply");
                        msg.setAnnounceProtocolVersion(ClusterService.ANNOUNCE_PROTOCOL_VERSION);
                        msg.setToMember(memberNew);
                        msg.setPrevSentTimestamp(this.getThisSentTimestamp());
                        msg.setPrevRecvTimestamp(this.getThisRecvTimestamp());
                        msg.setExternalAddress(addrSockSrc);
                        service.send(msg);
                    } else {
                        ClusterService$SeniorMemberHeartbeat msg = (ClusterService$SeniorMemberHeartbeat)service.instantiateMessage("SeniorMemberHeartbeat");
                        msg.setLastReceivedMillis(service.calcTimestamp(memberThis.getLastIncomingMillis()));
                        msg.setMemberSet(setMember);
                        msg.setWkaEnabled(service.isWkaEnabled());
                        msg.setLastJoinTime(setMember.getLastJoinTime());
                        msg.setToMember(memberNew);
                        service.send(msg);
                    }
                } else if (this.getAttemptCounter() > this.getAttemptLimit() >>> 2 ? true : (service.isWellKnown(memberSenior.getAddress()) ? true : service.isWellKnown(memberSenior)) ^ true) {
                    ClusterService$NewMemberAnnounceWait msg = (ClusterService$NewMemberAnnounceWait)service.instantiateMessage("NewMemberAnnounceWait");
                    msg.setToMember(memberNew);
                    msg.setSeniorMember(memberSenior);
                    msg.setExternalAddress(addrSockSrc);
                    service.send(msg);
                    fRecordAnnouncing = true;
                }
                if (!fRecordAnnouncing) break;
                service.getQuorumControl().onMemberAnnounceWaiting(memberNew);
                break;
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        MessagePacket packet;
        super.read(input);
        this.setAttemptCounter(input.readInt());
        this.setAttemptLimit(input.readInt());
        long ldtSentAndVer = input.readLong();
        this.setAnnounceProtocolVersion((int)(ldtSentAndVer >>> 56));
        this.setThisSentTimestamp(ldtSentAndVer);
        MessagePacket[] aPacket = this.getPacket();
        if ((!(aPacket != null) ? false : aPacket.length > 0) && (packet = aPacket[0]) != null) {
            this.setThisRecvTimestamp(((ClusterService)this.getService()).calcTimestamp(packet.getReceivedMillis()));
        }
        if (input.available() > 0) {
            byte[] abSrc = new byte[input.readInt()];
            input.readFully(abSrc);
            this.setSourceAddress(new InetSocketAddress(InetAddress.getByAddress(abSrc), input.readInt()));
        }
        this.ensureEOS(input);
    }

    public void setAnnounceProtocolVersion(int nVersion) {
        if ((nVersion & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("version exceeds max bit width");
        }
        this.__m_AnnounceProtocolVersion = nVersion;
    }

    public void setAttemptCounter(int n) {
        this.__m_AttemptCounter = n;
    }

    public void setAttemptLimit(int c) {
        this.__m_AttemptLimit = c;
    }

    protected void setThisRecvTimestamp(long ldt) {
        this.__m_ThisRecvTimestamp = ldt;
    }

    public void setThisSentTimestamp(long cMillis) {
        this.__m_ThisSentTimestamp = cMillis;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        this.setThisSentTimestamp(Base.getSafeTimeMillis() | (long)this.getAnnounceProtocolVersion() << 56);
        output.writeInt(this.getAttemptCounter());
        output.writeInt(this.getAttemptLimit());
        output.writeLong(this.getThisSentTimestamp());
    }
}

