/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.IOException;

public class ClusterService$NewMemberWelcomeAnnounce
extends DiscoveryMessage {
    private Member __m_SeniorMember;
    private String __m_ServiceVersion;

    public ClusterService$NewMemberWelcomeAnnounce() {
        this(null, null, true);
    }

    public ClusterService$NewMemberWelcomeAnnounce(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(38);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("SeniorMember=")).append(this.getSeniorMember()).append("\nServiceVersion=").append(this.getServiceVersion()).toString();
    }

    public Member getSeniorMember() {
        return this.__m_SeniorMember;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberWelcomeAnnounce".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberWelcomeAnnounce();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        if (service.isRunning() ^ true) {
            return;
        }
        boolean bl = this.isReadError();
        if (bl) {
            return;
        }
        Member memberFrom = this.getFromMember();
        switch (service.getState()) {
            case 0: 
            case 1: {
                Member memberThis = service.getState() == ClusterService.STATE_ANNOUNCE ? service.getAnnounceMember() : service.getRequestMember();
                if (!(memberThis.equals(memberFrom) ^ true)) return;
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                return;
            }
            case 2: {
                Member memberThis = service.getThisMember();
                if (!(memberThis.equals(memberFrom) ^ true)) return;
                int nMember = memberFrom.getId();
                UUID uidMember = memberFrom.getUid32();
                MasterMemberSet setMember = service.getClusterMemberSet();
                ActualMemberSet setRecycled = setMember.getRecycleSet();
                Member memberById = setMember.getMember(nMember);
                Member memberByUid = setMember.getMember(uidMember);
                if (!(memberById == null) ? false : memberByUid == null) {
                    Member memberSenior = this.getSeniorMember();
                    if (!(memberSenior.equals(setMember.getOldestMember()) ? true : memberSenior.equals(((MemberSet)setRecycled).getMember(memberSenior.getId())))) return;
                    service.ensureMember(memberFrom, this.getServiceVersion());
                    return;
                }
                if (memberById != memberByUid) return;
                return;
            }
            default: {
                return;
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        ClusterService service = (ClusterService)this.getService();
        Member memberSenior = service.instantiateMember();
        memberSenior.readExternal(input);
        this.setSeniorMember(memberSenior);
        this.setServiceVersion(input.readUTF());
        this.getFromMember().setTcpRingPort(input.readInt());
    }

    public void setSeniorMember(Member member) {
        this.__m_SeniorMember = member;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        this.getSeniorMember().writeExternal(output);
        output.writeUTF(this.getServiceVersion());
        output.writeInt(this.getFromMember().getTcpRingPort());
    }
}

