/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Date;

public class ClusterService$SeniorMemberHeartbeat
extends DiscoveryMessage {
    private long __m_LastJoinTime;
    private long __m_LastReceivedMillis;
    private MemberSet __m_MemberSet;
    private boolean __m_WkaEnabled;

    public ClusterService$SeniorMemberHeartbeat() {
        this(null, null, true);
    }

    public ClusterService$SeniorMemberHeartbeat(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(17);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        long lLastRecvTimestamp = this.getLastReceivedMillis();
        String sLastRecvTimestamp = lLastRecvTimestamp == 0L ? "none" : new Date(lLastRecvTimestamp).toString();
        return new StringBuilder(String.valueOf("\nLastRecvTimestamp=")).append(sLastRecvTimestamp).append("\nMemberSet=").append(this.getMemberSet()).toString();
    }

    public long getLastJoinTime() {
        return this.__m_LastJoinTime;
    }

    public long getLastReceivedMillis() {
        return this.__m_LastReceivedMillis;
    }

    public MemberSet getMemberSet() {
        return this.__m_MemberSet;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$SeniorMemberHeartbeat".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$SeniorMemberHeartbeat();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean isWkaEnabled() {
        return this.__m_WkaEnabled;
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        if (service.validateSeniorBroadcast(this, this.getMemberSet())) {
            Member memberThis = service.getThisMember();
            if (!(this.getLastJoinTime() >= memberThis.getTimestamp()) ? false : this.getMemberSet().contains(memberThis) ^ true) {
                Component._trace(new StringBuilder(String.valueOf("Received cluster heartbeat from the senior ")).append(service.getClusterOldestMember()).append(" that does not contain this ").append(memberThis).append("; stopping cluster service.").toString(), 1);
                service.onStopRunning();
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setLastReceivedMillis(input.readLong());
        MemberSet setMember = new MemberSet();
        setMember.readExternal(input);
        this.setMemberSet(setMember);
        this.setWkaEnabled(input.readBoolean());
        this.setLastJoinTime(input.readLong());
        this.ensureEOS(input);
    }

    public void setLastJoinTime(long lTime) {
        this.__m_LastJoinTime = lTime;
    }

    public void setLastReceivedMillis(long cMillis) {
        this.__m_LastReceivedMillis = cMillis;
    }

    public void setMemberSet(MemberSet setMember) {
        this.__m_MemberSet = setMember;
    }

    public void setWkaEnabled(boolean pWkaEnabled) {
        this.__m_WkaEnabled = pWkaEnabled;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        output.writeLong(this.getLastReceivedMillis());
        this.getMemberSet().writeExternal(output);
        output.writeBoolean(this.isWkaEnabled());
        output.writeLong(this.getLastJoinTime());
    }
}

