/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoinRequest$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoining$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceUpdateResponse;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ClusterService$ServiceJoinRequest
extends RequestMessage
implements Continuation {
    private Map __m_MemberConfigMap;
    private PermissionInfo __m_PermissionInfo;
    private String __m_ServiceEndPointName;
    private int __m_ServiceId;
    private String __m_ServiceVersion;
    private static ListMap __mapChildren;

    static {
        ClusterService$ServiceJoinRequest.__initStatic();
    }

    public ClusterService$ServiceJoinRequest() {
        this(null, null, true);
    }

    public ClusterService$ServiceJoinRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(42);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Poll", ClusterService$ServiceJoinRequest$Poll.get_CLASS());
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("ServiceId=")).append(this.getServiceId()).append("\nServiceVersion=").append(this.getServiceVersion()).append("\nServiceEndPoint=").append(this.getServiceEndPointName()).append("\nMemberConfigMap=").append(this.getMemberConfigMap()).toString();
    }

    public Map getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public PermissionInfo getPermissionInfo() {
        return this.__m_PermissionInfo;
    }

    public String getServiceEndPointName() {
        return this.__m_ServiceEndPointName;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceJoinRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ClusterService$ServiceJoinRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    protected Poll instantiatePoll() {
        return (Poll)this._newChild("Poll");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        int nService = this.getServiceId();
        ServiceInfo info = service.getServiceInfo(nService);
        if (info == null) {
            ClusterService$ServiceUpdateResponse msg = (ClusterService$ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
            msg.respondTo(this);
            service.send(msg);
        } else {
            Member member;
            ServiceMemberSet setMember = info.getMemberSet();
            if (setMember.contains(member = this.getFromMember())) {
                int nState = setMember.getState(member.getId());
                setMember.remove(member);
                service.onServiceLeft(info, member, nState);
            }
            long ldtJoined = service.getTimestamp();
            int nMember = member.getId();
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                long ldtOld = setMember.getServiceJoinTime(((Member)iter.next()).getId());
                if (!(ldtJoined <= ldtOld)) continue;
                ldtJoined = ldtOld + (long)1;
            }
            ServiceMemberSet serviceMemberSet = setMember;
            synchronized (serviceMemberSet) {
                setMember.add(member);
                setMember.setServiceVersion(nMember, this.getServiceVersion());
                setMember.setServiceJoinTime(nMember, ldtJoined);
                setMember.setServiceJoining(nMember);
                setMember.setServiceEndPointName(nMember, this.getServiceEndPointName());
                setMember.updateMemberConfigMap(nMember, this.getMemberConfigMap());
            }
            service.onServiceJoining(info, member);
            service.validateNewService(info, member, this, this.getPermissionInfo());
        }
    }

    public void proceed(Object oResult) {
        ClusterService service = (ClusterService)this.getService();
        Member member = this.getFromMember();
        int nMember = member.getId();
        int nService = this.getServiceId();
        ServiceInfo info = service.getServiceInfo(nService);
        Component._assert(info != null);
        if (oResult instanceof SecurityException) {
            Component._trace("member left due to security exception", 1);
            service.doMemberLeft(member);
            return;
        }
        if (oResult instanceof String ? true : oResult instanceof Exception) {
            info.getMemberSet().remove(member);
            ClusterService$ServiceUpdateResponse msg = (ClusterService$ServiceUpdateResponse)service.instantiateMessage("ServiceUpdateResponse");
            msg.respondTo(this);
            msg.setResult(oResult);
            service.send(msg);
        } else {
            MemberSet setOthers = service.getOthersMemberSet();
            setOthers.remove(member);
            ClusterService$ServiceJoining msg = (ClusterService$ServiceJoining)service.instantiateMessage("ServiceJoining");
            msg.setMemberId(nMember);
            msg.setServiceId(nService);
            msg.setServiceName(info.getServiceName());
            msg.setServiceType(info.getServiceType());
            msg.setServiceJoinTime(info.getServiceJoinTime(nMember));
            msg.setServiceVersion(this.getServiceVersion());
            msg.setServiceEndPointName(this.getServiceEndPointName());
            msg.setMemberConfigMap(this.getMemberConfigMap());
            msg.setToMemberSet(setOthers);
            msg.setJoinRequest(this);
            msg.setPermissionInfo(this.getPermissionInfo());
            ((ClusterService$ServiceJoining$Poll)msg.ensureRequestPoll()).setResult((PermissionInfo)oResult);
            service.registerServiceJoining(msg);
            service.send(msg);
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        try {
            this.setServiceId(input.readUnsignedShort());
            this.setServiceVersion(input.readUTF());
            this.setServiceEndPointName(input.readUTF());
            this.setMemberConfigMap((Map)this.readObject(input));
            this.setPermissionInfo((PermissionInfo)this.readObject(input));
        }
        catch (IOException e) {
            this.getService().onConfigIOException(e, this.getFromMember());
        }
    }

    public void setMemberConfigMap(Map map) {
        this.__m_MemberConfigMap = map;
    }

    public void setPermissionInfo(PermissionInfo service) {
        this.__m_PermissionInfo = service;
    }

    public void setServiceEndPointName(String sEndPoint) {
        this.__m_ServiceEndPointName = sEndPoint;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        output.writeShort(this.getServiceId());
        output.writeUTF(this.getServiceVersion());
        output.writeUTF(this.getServiceEndPointName());
        this.writeObject(output, this.getMemberConfigMap());
        this.writeObject(output, this.getPermissionInfo());
    }
}

