/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.WrapperException;
import java.io.EOFException;
import java.io.IOException;

public class ClusterService$ServiceLeft
extends Message {
    private int __m_MemberLeftId;
    private int __m_ServiceId;
    private long __m_ServiceJoinTime;

    public ClusterService$ServiceLeft() {
        this(null, null, true);
    }

    public ClusterService$ServiceLeft(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(45);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("ServiceId=")).append(this.getServiceId()).toString();
    }

    public int getMemberLeftId() {
        return this.__m_MemberLeftId;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public long getServiceJoinTime() {
        return this.__m_ServiceJoinTime;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceLeft".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$ServiceLeft();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        int nService = this.getServiceId();
        ServiceInfo info = service.getServiceInfo(nService);
        if (info == null) {
            Component._trace(new StringBuilder(String.valueOf("ClusterService$ServiceLeft: ")).append("Unknown Service ").append(nService).toString(), 4);
        } else {
            ServiceMemberSet setMember = info.getMemberSet();
            Member memberThis = service.getThisMember();
            int nMemberId = this.getMemberLeftId();
            Member memberLeft = service.getClusterMemberSet().getMember(nMemberId);
            long ldtJoined = this.getServiceJoinTime();
            if (memberLeft == null) {
                return;
            }
            if (memberThis == memberLeft ? true : (!(memberThis == service.getClusterOldestMember()) ? false : setMember.contains(memberLeft))) {
                ClusterService$ServiceLeft msg = (ClusterService$ServiceLeft)service.instantiateMessage("ServiceLeft");
                MemberSet setTo = service.getOthersMemberSet();
                setTo.remove(nMemberId);
                msg.setToMemberSet(setTo);
                msg.setServiceId(nService);
                msg.setMemberLeftId(nMemberId);
                msg.setServiceJoinTime((!(memberThis != memberLeft) ? false : ldtJoined == 0L) ? setMember.getServiceJoinTime(nMemberId) : ldtJoined);
                service.send(msg);
            }
            if (setMember.contains(memberLeft)) {
                if (setMember.getServiceJoinTime(nMemberId) == ldtJoined ? true : ldtJoined == 0L) {
                    int nState = setMember.getState(nMemberId);
                    setMember.remove(memberLeft);
                    service.onServiceLeft(info, memberLeft, nState);
                }
            } else {
                Component._trace(new StringBuilder(String.valueOf("ClusterService$ServiceLeft: ")).append(info.getServiceName()).append("; ").append("Unknown ").append(memberLeft).toString(), 6);
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        this.setServiceId(input.readUnsignedShort());
        this.setServiceJoinTime(input.readLong());
        try {
            this.setMemberLeftId(input.readUnsignedShort());
        }
        catch (EOFException eOFException) {}
    }

    public void setMemberLeftId(int nId) {
        this.__m_MemberLeftId = nId;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setServiceJoinTime(long ldtJoined) {
        this.__m_ServiceJoinTime = ldtJoined;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        output.writeShort(this.getServiceId());
        output.writeLong(this.getServiceJoinTime());
        output.writeShort(this.getMemberLeftId());
    }
}

