/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceQuiescence;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceQuiescenceRequest$Poll;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Map;

public class ClusterService$ServiceQuiescenceRequest
extends RequestMessage
implements Continuation {
    private transient int __m_PendingCounter;
    private boolean __m_Relay;
    private boolean __m_Resume;
    private boolean __m_ResumeOnFailover;
    private int __m_ServiceId;
    private static ListMap __mapChildren;

    static {
        ClusterService$ServiceQuiescenceRequest.__initStatic();
    }

    public ClusterService$ServiceQuiescenceRequest() {
        this(null, null, true);
    }

    public ClusterService$ServiceQuiescenceRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(57);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Poll", ClusterService$ServiceQuiescenceRequest$Poll.get_CLASS());
    }

    public Message cloneMessage() {
        ClusterService$ServiceQuiescenceRequest msg = (ClusterService$ServiceQuiescenceRequest)super.cloneMessage();
        msg.setServiceId(this.getServiceId());
        msg.setResume(this.isResume());
        return msg;
    }

    public int getPendingCounter() {
        return this.__m_PendingCounter;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$ServiceQuiescenceRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ClusterService$ServiceQuiescenceRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean isRelay() {
        return this.__m_Relay;
    }

    public boolean isResume() {
        return this.__m_Resume;
    }

    protected boolean isResumeOnFailover() {
        return this.__m_ResumeOnFailover;
    }

    public void onReceived() {
        ServiceInfo[] serviceInfoArray;
        ClusterService clusterSvc = (ClusterService)this.getService();
        int nServiceId = this.getServiceId();
        int cPending = 0;
        boolean fResume = this.isResume();
        boolean fResumeFailover = this.isResumeOnFailover();
        if (nServiceId == 0) {
            serviceInfoArray = clusterSvc.getServiceInfo();
        } else {
            ServiceInfo[] serviceInfoArray2 = new ServiceInfo[1];
            serviceInfoArray = serviceInfoArray2;
            serviceInfoArray2[0] = clusterSvc.getServiceInfo(nServiceId);
        }
        ServiceInfo[] aInfo = serviceInfoArray;
        int i = 0;
        int c = aInfo.length;
        while (i < c) {
            ServiceInfo info = aInfo[i];
            if (info != null) {
                info.setSuspended(fResume ^ true);
                Grid service = clusterSvc.getService(info.getServiceId());
                if (service != null) {
                    Grid$NotifyServiceQuiescence msg = (Grid$NotifyServiceQuiescence)service.instantiateMessage("NotifyServiceQuiescence");
                    msg.addToMember(service.getThisMember());
                    msg.setResume(fResume);
                    msg.setResumeOnFailover(fResumeFailover);
                    ClusterService$NotifyResponse msgContinue = (ClusterService$NotifyResponse)clusterSvc.instantiateMessage("NotifyResponse");
                    msgContinue.setService(clusterSvc);
                    msgContinue.setContinuation(this);
                    msg.setContinuationMessage(msgContinue);
                    service.send(msg);
                    ++cPending;
                }
            }
            ++i;
        }
        if (this.isRelay()) {
            ClusterService$ServiceQuiescenceRequest msg = (ClusterService$ServiceQuiescenceRequest)clusterSvc.instantiateMessage("ServiceQuiescenceRequest");
            msg.setServiceId(nServiceId);
            msg.setResume(fResume);
            msg.setResumeOnFailover(fResumeFailover);
            msg.setRelay(false);
            msg.setToMemberSet(clusterSvc.getOthersMemberSet());
            ((ClusterService$ServiceQuiescenceRequest$Poll)msg.ensureRequestPoll()).setContinuation(this);
            ++cPending;
            msg.post();
        }
        if (cPending == 0) {
            this.sendReply();
        } else {
            this.setPendingCounter(cPending);
        }
    }

    public void proceed(Object oResult) {
        int cPending = this.getPendingCounter() - 1;
        this.setPendingCounter(cPending);
        if (cPending == 0) {
            this.sendReply();
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setServiceId(input.readInt());
        this.setResume(input.readBoolean());
        this.setResumeOnFailover(input.readBoolean());
        this.setRelay(input.readBoolean());
    }

    protected void sendReply() {
        Message msgResp = this.getService().instantiateMessage("Response");
        msgResp.respondTo(this);
        msgResp.post();
    }

    public void setPendingCounter(int sProperty) {
        this.__m_PendingCounter = sProperty;
    }

    public void setRelay(boolean fRelay) {
        this.__m_Relay = fRelay;
    }

    public void setResume(boolean fResume) {
        this.__m_Resume = fResume;
    }

    public void setResumeOnFailover(boolean fResume) {
        this.__m_ResumeOnFailover = fResume;
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        output.writeInt(this.getServiceId());
        output.writeBoolean(this.isResume());
        output.writeBoolean(this.isResumeOnFailover());
        output.writeBoolean(this.isRelay());
    }
}

