/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.collections.Arrays;
import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$BusEventMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceQuiescence;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PingRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberHeartbeat;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounce;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounceReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounceWait;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberInduct;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestId;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdReject;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberRequestIdWait;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberTimestampRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberTimestampResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberWelcomeAnnounce;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyIpTimeout;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NotifyTcmpTimeout;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$QuorumControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$QuorumRollCall;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberHeartbeat;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberKill;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$SeniorMemberPanic;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoinRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceQuiescenceRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceRegister;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceRegisterRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$ServiceUpdateResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$TcpRing;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$WitnessRequest;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.internal.ClusterJoinException;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ClusterService
extends Grid {
    public static final int ANNOUNCE_BIND_THRESHOLD = 3;
    public static final int ANNOUNCE_PROTOCOL_VERSION = 1;
    public static final int REJECT_AUTHORIZE = 8161;
    public static final int REJECT_CLUSTER_NAME = 8167;
    public static final int REJECT_EDITION = 8168;
    public static final int REJECT_LICENSE_EXPIRED = 8164;
    public static final int REJECT_LICENSE_TYPE = 8169;
    public static final int REJECT_NONE = 8171;
    public static final int REJECT_PACKET_MAX = 8163;
    public static final int REJECT_QUORUM = 8172;
    public static final int REJECT_RESTART = 8170;
    public static final int REJECT_SENIOR = 8165;
    public static final int REJECT_SIZE = 8160;
    public static final int REJECT_VERSION = 8162;
    public static final int REJECT_WKA = 8166;
    public static final int STATE_ANNOUNCE = 0;
    public static final int STATE_JOINED = 2;
    public static final int STATE_JOINING = 1;
    public static final int STATE_LEAVING = 3;
    public static final int STATE_LEFT = 4;
    public static final String VERSION = "12.2.1.1.0";
    public static final String VERSION_BARRIER = "12.2.1";
    private Member __m_AnnounceMember;
    private transient Set __m_BroadcastAddresses;
    private transient long __m_BroadcastAddressesExpiry;
    private int __m_BroadcastCounter;
    private int __m_BroadcastLimit;
    private int __m_BroadcastMode;
    private long __m_BroadcastNextMillis;
    private int __m_BroadcastRepeatMillis;
    private int __m_BroadcastTimeoutMillis;
    private Binary __m_BroadcastTimestamp;
    private transient int __m_DeliveryTimeoutMillis;
    private int __m_HeartbeatDelay;
    private transient MemberSet __m_HeartbeatMemberSet;
    private transient long __m_LastInterminableWarningMillis;
    private UUID __m_LastPanicUid;
    private transient int __m_MaximumPacketLength;
    private long __m_MembershipReopen;
    private transient LongArray __m_PendingServiceJoining;
    private ClusterService$QuorumControl __m_QuorumControl;
    private Member __m_RequestMember;
    private volatile Grid[] __m_Service;
    private transient Map __m_ServiceContext;
    private ServiceInfo[] __m_ServiceInfo;
    private int __m_State;
    private transient long __m_StatsJoinRequests;
    private transient long __m_StatsMembersDepartureCount;
    private transient ClusterService$TcpRing __m_TcpRing;
    private transient long __m_TimestampAdjustment;
    private transient int __m_TimestampMaxVariance;
    private Set __m_WellKnownAddresses;
    private Map __m_WkaMap;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        ClusterService.__initStatic();
    }

    public ClusterService() {
        this(null, null, true);
    }

    public ClusterService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAcceptingClients(false);
            this.setAcceptingOthers(true);
            this.setBroadcastRepeatMillis(256);
            this.setBroadcastTimeoutMillis(32768);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setServiceId(0);
            this.setServiceName("Cluster");
            this.setSuspendPollLimit(new AtomicLong());
            this.setTimestampMaxVariance(10);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid$Guard("Guard", this, true), "Guard");
        this._addChild(new Grid$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new ClusterService$QuorumControl("QuorumControl", this, true), "QuorumControl");
        this._addChild(new Grid$ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid$ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this._addChild(new ClusterService$TcpRing("TcpRing", this, true), "TcpRing");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_PendingServiceJoining = new SparseArray();
            this.__m_WkaMap = new SafeHashMap();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("BusEventMessage", Grid$BusEventMessage.get_CLASS());
        Class clazz3 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz6 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz7 = __mapChildren.put("DispatchEvent", Grid$DispatchEvent.get_CLASS());
        Class clazz8 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz9 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz10 = __mapChildren.put("MemberHeartbeat", ClusterService$MemberHeartbeat.get_CLASS());
        Class clazz11 = __mapChildren.put("MemberJoined", ClusterService$MemberJoined.get_CLASS());
        Class clazz12 = __mapChildren.put("MemberLeaving", ClusterService$MemberLeaving.get_CLASS());
        Class clazz13 = __mapChildren.put("MemberLeft", ClusterService$MemberLeft.get_CLASS());
        Class clazz14 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz15 = __mapChildren.put("MemberWelcomeRequest", Grid$MemberWelcomeRequest.get_CLASS());
        Class clazz16 = __mapChildren.put("NewMemberAnnounce", ClusterService$NewMemberAnnounce.get_CLASS());
        Class clazz17 = __mapChildren.put("NewMemberAnnounceReply", ClusterService$NewMemberAnnounceReply.get_CLASS());
        Class clazz18 = __mapChildren.put("NewMemberAnnounceWait", ClusterService$NewMemberAnnounceWait.get_CLASS());
        Class clazz19 = __mapChildren.put("NewMemberInduct", ClusterService$NewMemberInduct.get_CLASS());
        Class clazz20 = __mapChildren.put("NewMemberRequestId", ClusterService$NewMemberRequestId.get_CLASS());
        Class clazz21 = __mapChildren.put("NewMemberRequestIdReject", ClusterService$NewMemberRequestIdReject.get_CLASS());
        Class clazz22 = __mapChildren.put("NewMemberRequestIdReply", ClusterService$NewMemberRequestIdReply.get_CLASS());
        Class clazz23 = __mapChildren.put("NewMemberRequestIdWait", ClusterService$NewMemberRequestIdWait.get_CLASS());
        Class clazz24 = __mapChildren.put("NewMemberTimestampRequest", ClusterService$NewMemberTimestampRequest.get_CLASS());
        Class clazz25 = __mapChildren.put("NewMemberTimestampResponse", ClusterService$NewMemberTimestampResponse.get_CLASS());
        Class clazz26 = __mapChildren.put("NewMemberWelcome", ClusterService$NewMemberWelcome.get_CLASS());
        Class clazz27 = __mapChildren.put("NewMemberWelcomeAnnounce", ClusterService$NewMemberWelcomeAnnounce.get_CLASS());
        Class clazz28 = __mapChildren.put("NewMemberWelcomeRequest", ClusterService$NewMemberWelcomeRequest.get_CLASS());
        Class clazz29 = __mapChildren.put("NotifyIpTimeout", ClusterService$NotifyIpTimeout.get_CLASS());
        Class clazz30 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz31 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz32 = __mapChildren.put("NotifyMemberLeft", ClusterService$NotifyMemberLeft.get_CLASS());
        Class clazz33 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz34 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz35 = __mapChildren.put("NotifyResponse", ClusterService$NotifyResponse.get_CLASS());
        Class clazz36 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz37 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz38 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz39 = __mapChildren.put("NotifyServiceLeft", Grid$NotifyServiceLeft.get_CLASS());
        Class clazz40 = __mapChildren.put("NotifyServiceQuiescence", Grid$NotifyServiceQuiescence.get_CLASS());
        Class clazz41 = __mapChildren.put("NotifyShutdown", ClusterService$NotifyShutdown.get_CLASS());
        Class clazz42 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz43 = __mapChildren.put("NotifyTcmpTimeout", ClusterService$NotifyTcmpTimeout.get_CLASS());
        Class clazz44 = __mapChildren.put("PingRequest", Grid$PingRequest.get_CLASS());
        Class clazz45 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz46 = __mapChildren.put("QuorumRollCall", ClusterService$QuorumRollCall.get_CLASS());
        Class clazz47 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz48 = __mapChildren.put("SeniorMemberHeartbeat", ClusterService$SeniorMemberHeartbeat.get_CLASS());
        Class clazz49 = __mapChildren.put("SeniorMemberKill", ClusterService$SeniorMemberKill.get_CLASS());
        Class clazz50 = __mapChildren.put("SeniorMemberPanic", ClusterService$SeniorMemberPanic.get_CLASS());
        Class clazz51 = __mapChildren.put("ServiceJoined", ClusterService$ServiceJoined.get_CLASS());
        Class clazz52 = __mapChildren.put("ServiceJoining", ClusterService$ServiceJoining.get_CLASS());
        Class clazz53 = __mapChildren.put("ServiceJoinRequest", ClusterService$ServiceJoinRequest.get_CLASS());
        Class clazz54 = __mapChildren.put("ServiceLeaving", ClusterService$ServiceLeaving.get_CLASS());
        Class clazz55 = __mapChildren.put("ServiceLeft", ClusterService$ServiceLeft.get_CLASS());
        Class clazz56 = __mapChildren.put("ServiceQuiescenceRequest", ClusterService$ServiceQuiescenceRequest.get_CLASS());
        Class clazz57 = __mapChildren.put("ServiceRegister", ClusterService$ServiceRegister.get_CLASS());
        Class clazz58 = __mapChildren.put("ServiceRegisterRequest", ClusterService$ServiceRegisterRequest.get_CLASS());
        Class clazz59 = __mapChildren.put("ServiceUpdateResponse", ClusterService$ServiceUpdateResponse.get_CLASS());
        Class clazz60 = __mapChildren.put("WitnessRequest", ClusterService$WitnessRequest.get_CLASS());
        Class clazz61 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.util.Base");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicBroadcast(Member member) {
        Set setBroadcast;
        if ((!(member != null) ? false : this.isWellKnown(member) ^ true) && (setBroadcast = this.getBroadcastAddresses()) != null) {
            Set set = setBroadcast;
            synchronized (set) {
                setBroadcast.add(member.getSocketAddress());
            }
            this.setBroadcastAddressesExpiry(Base.getSafeTimeMillis() + (long)this.getDeliveryTimeoutMillis());
        }
    }

    public static int calcMachines(Set setMembers) {
        HashSet<Integer> setMachines = new HashSet<Integer>();
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            setMachines.add(Base.makeInteger(member.getMachineId()));
        }
        return setMachines.size();
    }

    public long calcTimestamp(long lLocalhostMillis) {
        if (lLocalhostMillis != (long)0) {
            lLocalhostMillis += this.getTimestampAdjustment();
        }
        return lLocalhostMillis;
    }

    protected void checkGuardables() {
        long cLateMillis;
        if (this.isGuardian() && (cLateMillis = this.getGuardSupport().check()) > 0L) {
            Component._trace(new StringBuilder(String.valueOf("Service guardian is ")).append(cLateMillis).append("ms late, indicating that this JVM may be ").append("running slowly or experienced a long GC").toString(), 3);
        }
    }

    protected void checkPendingJoinPolls() {
        block13: {
            Component._assert(Thread.currentThread() == this.getThread());
            LongArray laPending = this.getPendingServiceJoining();
            if (!(laPending.isEmpty() ^ true)) break block13;
            long ldtNow = Base.getSafeTimeMillis();
            long cTimeout = this.getDeliveryTimeoutMillis();
            long ldtCutoff = ldtNow - (cTimeout - (cTimeout >> 2));
            long ldtOldest = laPending.getFirstIndex();
            if (ldtOldest < ldtCutoff) {
                ClusterService$ServiceJoining msg = (ClusterService$ServiceJoining)laPending.get(ldtOldest);
                String sMsg = "ServiceJoining";
                try {
                    sMsg = String.valueOf(msg);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Poll poll = msg.getRequestPoll();
                if (poll == null) {
                    laPending.remove(ldtOldest);
                    Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("This senior encountered a null pending poll for message: ").append(sMsg).toString(), 1);
                    return;
                }
                MemberSet setRemain = poll.getRemainingMemberSet();
                if (setRemain.isEmpty()) {
                    boolean fWasClosed = poll.isClosed();
                    poll.close();
                    laPending.remove(ldtOldest);
                    Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("This senior encountered an empty ").append(fWasClosed ? "closed " : "").append("pending poll for message: ").append(sMsg).toString(), 1);
                    return;
                }
                String sPoll = "Poll";
                try {
                    sPoll = poll.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("This senior encountered an overdue poll, indicating a dead ").append("member, a significant network issue or an Operating ").append("System threading library bug (e.g. Linux NPTL): ").append(sPoll).append("\nfor message: ").append(sMsg).toString(), 2);
                try {
                    ArrayList<Member> listOverdue = new ArrayList<Member>();
                    HashSet<Integer> setMachines = new HashSet<Integer>();
                    MasterMemberSet setAll = this.getClusterMemberSet();
                    Member[] aMember = (Member[])((MemberSet)setAll).toArray(new Member[((MemberSet)setAll).size()]);
                    int i = 0;
                    int c = aMember.length;
                    while (i < c) {
                        Member member = aMember[i];
                        if (!(member != null) ? false : setRemain.contains(member)) {
                            listOverdue.add(member);
                            setMachines.add(new Integer(member.getMachineId()));
                        }
                        ++i;
                    }
                    long ldtGiveUp = ldtOldest + (cTimeout + (cTimeout >> 2));
                    if (!(setMachines.size() <= 1 ? true : ldtNow > ldtGiveUp)) break block13;
                    Iterator iter = listOverdue.iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        Component._trace(new StringBuilder(String.valueOf("Removing unresponsive member: ")).append(member).toString(), 2);
                        this.doMemberLeft(member);
                    }
                    poll.close();
                    if (listOverdue.isEmpty()) {
                        Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("This senior encountered and closed an overdue poll ").append("that did not contain any known members, indicating ").append("a likely JVM or Operating System threading library ").append("(e.g. Linux NPTL) bug: ").append(sPoll).toString(), 1);
                    }
                }
                catch (Throwable e) {
                    Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Non-fatal exception detected during processing:").toString(), 1);
                    Component._trace(e);
                    Component._trace(new StringBuilder(String.valueOf("validatePolls: ")).append("Exception has been logged; continuing processing.").toString(), 1);
                }
            }
        }
    }

    public int compareImportance(Member memberThat) {
        Member memberThis = this.getThisMember();
        int nThisWeight = memberThis.getPriority();
        int nThatWeight = memberThat.getPriority();
        int iResult = nThisWeight - nThatWeight;
        int i = 1;
        int c = this.getServiceCount();
        while (i < c) {
            Grid service = this.getService(i);
            if (service != null) {
                try {
                    iResult += service.compareImportance(memberThat);
                }
                catch (Throwable e) {
                    Component._trace(new StringBuilder(String.valueOf("Failed to determine importance of Service \"")).append(service.getServiceName()).append("\"\n").append(Component.getStackTrace(e)).toString(), 1);
                }
            }
            ++i;
        }
        return iResult;
    }

    public void doMemberInduct(Member memberNew) {
        Component._assert(Thread.currentThread() == this.getThread());
        ClusterService$NewMemberInduct msg = (ClusterService$NewMemberInduct)this.instantiateMessage("NewMemberInduct");
        msg.addToMember(memberNew);
        MasterMemberSet setMember = this.getClusterMemberSet();
        Object[] aoMember = setMember.toArray();
        int cMembers = aoMember.length;
        msg.setMemberCount(cMembers);
        int i = 0;
        while (i < cMembers) {
            Member member = (Member)aoMember[i];
            msg.setMember(i, member);
            msg.setServiceVersion(i, VERSION_BARRIER);
            ++i;
        }
        int cServices = this.getServiceInfoCount();
        msg.setServiceCount(cServices);
        int i2 = 0;
        while (i2 < cServices) {
            ServiceInfo info = this.getServiceInfo(i2);
            msg.setServiceId(i2, info.getServiceId());
            msg.setServiceName(i2, info.getServiceName());
            msg.setServiceType(i2, info.getServiceType());
            msg.setServiceSuspended(i2, info.isSuspended());
            ++i2;
        }
        this.send(msg);
    }

    public void doMemberLeaving() {
        this.setState(STATE_LEAVING);
        Member memberThis = this.getThisMember();
        if (memberThis != null) {
            ClusterService$MemberLeaving msg = (ClusterService$MemberLeaving)this.instantiateMessage("MemberLeaving");
            msg.setToMemberSet(this.getOthersMemberSet());
            msg.setMemberId(memberThis.getId());
            msg.setMemberUid(memberThis.getUid32());
            this.send(msg);
        }
    }

    public void doMemberLeft() {
        Member memberThis = this.getThisMember();
        if (memberThis != null) {
            ClusterService$MemberLeft msg = (ClusterService$MemberLeft)this.instantiateMessage("MemberLeft");
            msg.setToMemberSet(this.getOthersMemberSet());
            msg.setSynchronizationRequest(false);
            msg.setMemberCount(1);
            msg.setMemberIDs(new short[]{(short)memberThis.getId()});
            msg.setMemberUUIDs(new UUID[]{memberThis.getUid32()});
            msg.setMemberTimestamps(new long[]{this.calcTimestamp(memberThis.getTimestamp())});
            this.send(msg);
            Daemon.sleep(((Cluster)this.getCluster()).getDependencies().getPublisherAckDelayMillis());
        }
        this.setState(STATE_LEFT);
    }

    public void doMemberLeft(Member member) {
        this.removeMember(member);
        this.ensureMemberLeft(null, null, false);
    }

    public void doNotifyIpTimeout(InetAddress address) {
        ClusterService$NotifyIpTimeout msg = (ClusterService$NotifyIpTimeout)this.instantiateMessage("NotifyIpTimeout");
        msg.addToMember(this.getThisMember());
        msg.setTimedOutAddress(address);
        this.send(msg);
    }

    public void doNotifyTcmpTimeout(MessagePacket packet, MemberSet setTimedOut) {
        ClusterService$NotifyTcmpTimeout msg = (ClusterService$NotifyTcmpTimeout)this.instantiateMessage("NotifyTcmpTimeout");
        msg.addToMember(this.getThisMember());
        msg.setUndeliverablePacket(packet);
        msg.setTimedOutMembers(setTimedOut);
        this.send(msg);
    }

    public void doServiceJoined(Grid service) {
        int nServiceId = service.getServiceId();
        if (nServiceId > 0) {
            if (this.getService(nServiceId) == service) {
                ServiceMemberSet setMember = service.getServiceMemberSet();
                Member memberThis = this.getThisMember();
                long ldtJoined = setMember.getServiceJoinTime(memberThis.getId());
                ClusterService$ServiceJoined msg = (ClusterService$ServiceJoined)this.instantiateMessage("ServiceJoined");
                msg.addToMember(memberThis);
                msg.setServiceId(nServiceId);
                this.send(msg);
            } else {
                Component._trace(new StringBuilder(String.valueOf("ClusterService.doServiceJoined: ")).append("Unknown Service ").append(service).toString(), 1);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void doServiceJoining(Grid service) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void doServiceLeaving(Grid service) {
        int nServiceId = service.getServiceId();
        if (nServiceId > 0) {
            if (this.getService(nServiceId) == service) {
                ServiceMemberSet setMember = this.getServiceInfo(nServiceId).getMemberSet();
                Member memberThis = this.getThisMember();
                long ldtJoined = setMember.getServiceJoinTime(memberThis.getId());
                ClusterService$ServiceLeaving msg = (ClusterService$ServiceLeaving)this.instantiateMessage("ServiceLeaving");
                msg.addToMember(memberThis);
                msg.setServiceId(nServiceId);
                msg.setServiceJoinTime(ldtJoined);
                this.send(msg);
            } else {
                Component._trace(new StringBuilder(String.valueOf("ClusterService.doServiceLeaving: ")).append("Unknown Service ").append(service).toString(), 1);
            }
        }
    }

    public void doServiceLeft(Grid serviceLeft) {
        int nServiceId = serviceLeft.getServiceId();
        if (nServiceId > 0) {
            Grid service = this.getService(nServiceId);
            if (service == null ? true : service == serviceLeft) {
                ServiceMemberSet setMember = this.getServiceInfo(nServiceId).getMemberSet();
                Member memberThis = this.getThisMember();
                long ldtJoined = setMember.getServiceJoinTime(memberThis.getId());
                this.setService(nServiceId, null);
                ClusterService$ServiceLeft msg = (ClusterService$ServiceLeft)this.instantiateMessage("ServiceLeft");
                msg.addToMember(memberThis);
                msg.setServiceId(nServiceId);
                msg.setServiceJoinTime(ldtJoined);
                msg.setMemberLeftId(memberThis.getId());
                this.send(msg);
            } else if (serviceLeft.isExiting() ^ true) {
                Component._trace(new StringBuilder(String.valueOf("ClusterService.doServiceLeft: ")).append("Unknown Service ").append(serviceLeft).toString(), 1);
            }
        }
    }

    public void doServiceQueiscence(String sService, boolean fResume) {
        this.doServiceQueiscence(sService, fResume, false);
    }

    public void doServiceQueiscence(String sService, boolean fResume, boolean fResumeOnFailover) {
        ClusterService$ServiceQuiescenceRequest msg;
        ServiceInfo info = this.getServiceInfo(sService);
        if (info == null) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("Unknown service: ")).append(sService).toString());
        }
        do {
            msg = (ClusterService$ServiceQuiescenceRequest)this.instantiateMessage("ServiceQuiescenceRequest");
            msg.setServiceId(info.getServiceId());
            msg.setResume(fResume);
            msg.setResumeOnFailover(fResumeOnFailover);
            msg.setRelay(true);
            msg.setToMemberSet(MemberSet.instantiate(this.getServiceMemberSet().getOldestMember()));
            this.poll(msg);
        } while (msg.ensureRequestPoll().getRespondedMemberSet().isEmpty());
    }

    protected boolean ensureDiscovery() {
        return false;
    }

    public Member ensureMember(Member memberNew, String sVersion) {
        int nId;
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member member = setMember.getMember(nId = memberNew.getId());
        if (member == null) {
            member = memberNew;
            Member memberDead = setMember.getRecycleSet().getMember(nId);
            if (!(memberDead != null) ? false : memberDead.getUid32().equals(memberNew.getUid32())) {
                return null;
            }
            member.initCommSupport();
            setMember.add(member);
            setMember.setServiceVersion(nId, sVersion);
            setMember.setServiceJoinTime(nId, member.getTimestamp());
            setMember.setServiceEndPointName(nId, "");
            setMember.setServiceJoining(nId);
            this.onMemberJoined(member);
        }
        return member;
    }

    public void ensureMemberLeft(Member memberTo, Set setUUIDExempt, boolean fRequest) {
        MasterMemberSet setMembers = this.getClusterMemberSet();
        Member[] aMemberDead = (Member[])setMembers.getRecycleSet().toArray((Object[])null);
        short[] anId = new short[aMemberDead.length];
        UUID[] aUUID = new UUID[aMemberDead.length];
        long[] aldtDeath = new long[aMemberDead.length];
        long ldtCutoffMillis = Base.getSafeTimeMillis() - (long)setMembers.getRecycleMillis();
        int cDead = 0;
        int i = 0;
        int c = aMemberDead.length;
        while (i < c) {
            Member member = aMemberDead[i];
            if (!(!(!(member != null) ? false : member.getTimestamp() > ldtCutoffMillis) ? false : (member.isLeaving() ? true : memberTo != null)) ? false : (setUUIDExempt == null ? true : setUUIDExempt.contains(member.getUid32()) ^ true)) {
                anId[cDead] = (short)member.getId();
                aUUID[cDead] = member.getUid32();
                aldtDeath[cDead] = this.calcTimestamp(member.getTimestamp());
                if (memberTo == null) {
                    member.setLeaving(false);
                }
                ++cDead;
            }
            ++i;
        }
        if (cDead > 0 ? true : fRequest) {
            ClusterService$MemberLeft msg = (ClusterService$MemberLeft)this.instantiateMessage("MemberLeft");
            msg.setToMemberSet(memberTo == null ? this.getOthersMemberSet() : SingleMemberSet.instantiate(memberTo));
            msg.setSynchronizationRequest(fRequest);
            msg.setMemberCount(cDead);
            msg.setMemberIDs(anId);
            msg.setMemberUUIDs(aUUID);
            msg.setMemberTimestamps(aldtDeath);
            this.send(msg);
        }
    }

    public int ensureService(String sName, String sType) {
        do {
            ClusterService$ServiceRegisterRequest msg = (ClusterService$ServiceRegisterRequest)this.instantiateMessage("ServiceRegisterRequest");
            msg.addToMember(this.getClusterOldestMember());
            msg.setServiceName(sName);
            msg.setServiceType(sType);
            Object oResult = this.poll(msg);
            if (!(oResult != null)) continue;
            int nId = (Integer)oResult;
            ServiceInfo info = this.getServiceInfo(nId);
            String sTypeReg = info.getServiceType();
            if (sType.equals(sTypeReg) ^ true) {
                throw new IllegalArgumentException(new StringBuilder(String.valueOf("Invalid service type: requested=")).append(sType).append(", registered=").append(sTypeReg).toString());
            }
            return nId;
        } while (!(this.getServiceState() > Service.SERVICE_STARTED));
        throw new IllegalStateException("Service can not be created against a stopped cluster");
    }

    public ServiceInfo ensureServiceInfo(int nService, String sName, String sType) {
        ServiceInfo[] ainfo = this.getServiceInfo();
        int i = 0;
        int c = ainfo == null ? 0 : ainfo.length;
        while (i < c) {
            ServiceInfo info = ainfo[i];
            if (info != null) {
                boolean fObsolete = false;
                fObsolete = i == nService ? (info.getServiceName().equals(sName) ^ true ? true : (!(sType != null) ? false : sType.equals(info.getServiceType()) ^ true)) : info.getServiceName().equals(sName);
                if (fObsolete) {
                    Component._trace(new StringBuilder(String.valueOf("Removing the obsolete service info: ")).append(info).toString(), 3);
                    ainfo[i] = null;
                }
            }
            ++i;
        }
        ServiceInfo info = this.getServiceInfo(nService);
        if (info == null) {
            info = new ServiceInfo();
            info.setMemberSet(nService == 0 ? this.getServiceMemberSet() : new ServiceMemberSet());
            info.setServiceId(nService);
            info.setServiceName(sName);
            info.setServiceType(sType);
            if (!(nService != 0) ? false : this.getServiceInfo(0).isSuspended()) {
                info.setSuspended(true);
            }
            this.setServiceInfo(nService, info);
            this.onServiceAnnounced(info);
        } else {
            Component._assert(sName.equals(info.getServiceName()));
            Component._assert(sType == null ? true : sType.equals(info.getServiceType()));
        }
        return info;
    }

    public String formatClusterString() {
        String sClusterName = this.getClusterName();
        StringBuffer sb = new StringBuffer("cluster");
        if (!(sClusterName != null) ? false : sClusterName.length() > 0) {
            sb.append(" \"").append(sClusterName).append('\"');
        }
        return sb.toString();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "STATE_ANNOUNCE";
            }
            case 1: {
                return "STATE_JOINING";
            }
            case 2: {
                return "STATE_JOINED";
            }
            case 3: {
                return "STATE_LEAVING";
            }
            case 4: {
                return "STATE_LEFT";
            }
        }
        return new StringBuilder(String.valueOf("<unknown> ")).append(nState).toString();
    }

    public int fromString(String s) {
        if (!(s != null) ? false : s.length() >= 2) {
            String[] a;
            char ch1 = s.charAt(0);
            int ch2 = s.charAt(1);
            if (s.indexOf(32) > 0 && (!(!(!(!((a = Base.parseDelimitedString(s, ' ')).length > 3) ? false : a[0].length() > 5) ? false : a[1].length() > 5) ? false : a[2].length() > 3) ? false : a[3].length() > 3)) {
                int n = 0;
                int i = 1;
                while (i < 4) {
                    n = n << 8 | a[i].charAt(i);
                    ++i;
                }
                switch (n) {
                    case 7103333: 
                    case 7304293: {
                        return 0;
                    }
                    case 7299429: 
                    case 7302501: {
                        return 1;
                    }
                    case 7299956: {
                        if (a[2].charAt(0) == 'L') {
                            return 0;
                        }
                    }
                    case 7299444: 
                    case 7304564: {
                        return 3;
                    }
                    case 7303284: 
                    case 7304308: {
                        if (a[2].charAt(0) != 'D') {
                            return 4;
                        }
                    }
                    case 7301492: {
                        return 5;
                    }
                }
            }
            if (!(!(s.length() >= 30) ? false : s.charAt(13) == 'l') ? false : s.charAt(28) == 'c') {
                ch2 = s.length();
                ch1 = s.charAt(ch2 - 1);
                switch (ch1) {
                    case 'e': {
                        return 5 - (ch2 < 33 ? 2 : 1);
                    }
                    case 'l': 
                    case 's': {
                        return 0;
                    }
                }
                ch2 = s.charAt(ch2 - (ch1 == 'n' ? 1 : 0) - 6);
                ch1 = s.charAt(30);
            }
            switch (ch1) {
                case 'G': {
                    return 5;
                }
                case 'E': 
                case 'e': {
                    return ch2 == ch1 ? 4 : 0;
                }
                case 'S': {
                    return 3;
                }
                case 'P': 
                case 'p': {
                    return 2;
                }
                case 'C': 
                case 'R': {
                    return 1;
                }
                case 'D': 
                case 'd': {
                    return ch2 == 101 ? 1 : 0;
                }
            }
        }
        return -1;
    }

    public Member getAnnounceMember() {
        return this.__m_AnnounceMember;
    }

    public Set getBroadcastAddresses() {
        return this.__m_BroadcastAddresses;
    }

    public long getBroadcastAddressesExpiry() {
        return this.__m_BroadcastAddressesExpiry;
    }

    public int getBroadcastCounter() {
        return this.__m_BroadcastCounter;
    }

    public int getBroadcastLimit() {
        return this.__m_BroadcastLimit;
    }

    private int getBroadcastMode() {
        return this.__m_BroadcastMode;
    }

    public long getBroadcastNextMillis() {
        return this.__m_BroadcastNextMillis;
    }

    public int getBroadcastRepeatMillis() {
        return this.__m_BroadcastRepeatMillis;
    }

    public int getBroadcastTimeoutMillis() {
        return this.__m_BroadcastTimeoutMillis;
    }

    public Binary getBroadcastTimestamp() {
        return this.__m_BroadcastTimestamp;
    }

    public int getBroadcastVariance() {
        return 212343923;
    }

    public int getClusterId() {
        return 0;
    }

    public String getClusterName() {
        return ((Cluster)this.getCluster()).getClusterName();
    }

    public String getDecoratedThreadName() {
        int nState = this.getState();
        String sState = nState == STATE_JOINED ? "" : new StringBuilder(String.valueOf(Logger.THREAD_NAME_DELIM)).append(ClusterService.formatStateName(nState)).toString();
        Member member = this.getThisMember();
        if (member == null && (member = this.getRequestMember()) == null) {
            member = this.getAnnounceMember();
        }
        String sMember = member == null ? "" : new StringBuilder(String.valueOf(Logger.THREAD_NAME_DELIM)).append(member.toString()).toString();
        return new StringBuilder(String.valueOf(super.getDecoratedThreadName())).append(sState).append(sMember).toString();
    }

    public int getDeliveryTimeoutMillis() {
        return this.__m_DeliveryTimeoutMillis;
    }

    public int getHeartbeatDelay() {
        return this.__m_HeartbeatDelay;
    }

    public MemberSet getHeartbeatMemberSet() {
        MemberSet setTo = this.__m_HeartbeatMemberSet;
        if (setTo == null) {
            setTo = new ActualMemberSet();
            this.setHeartbeatMemberSet(setTo);
        }
        setTo.clear();
        MasterMemberSet setMembers = this.getClusterMemberSet();
        int cMembers = setMembers.size();
        if (cMembers > 1) {
            Cluster cluster = (Cluster)this.getCluster();
            Member memberThis = setMembers.getThisMember();
            int cDelay = this.getHeartbeatDelay();
            int cTimeout = this.getHeuristicTimeoutMillis() - cDelay;
            int cDesired = Math.max(cMembers * cDelay / cTimeout, 1);
            long ldtNow = Base.getSafeTimeMillis();
            long ldtEligible = ldtNow - (long)(cTimeout >> 2);
            long ldtDanger = ldtEligible - (long)(cTimeout >> 1);
            Member[] aMember = (Member[])setMembers.toArray(new Member[cMembers]);
            cMembers = aMember.length;
            int iFirst = (int)(Math.random() * (double)cMembers);
            int iLast = iFirst + cMembers;
            int i = iFirst;
            while (i < iLast) {
                Member member = aMember[i >= cMembers ? i - cMembers : i];
                if (!(!(member != null) ? false : member != memberThis) ? false : member.isDeaf() ^ true) {
                    boolean fDanger;
                    long ldtLastIn;
                    boolean fAckPending;
                    long ldtLastOut = member.getLastOutgoingMillis();
                    boolean bl = fAckPending = ldtLastOut > (ldtLastIn = member.getLastIncomingMillis());
                    boolean bl2 = !(fAckPending ^ true) ? false : (fDanger = ldtLastIn < ldtDanger);
                    boolean fEligible = !(fAckPending ^ true) ? false : ldtLastIn < ldtEligible;
                    boolean fTrintDanger = cluster.isCommEndangered(member);
                    if (((!fEligible ? false : cDesired > 0) ? true : fDanger) ? true : fTrintDanger) {
                        setTo.add(member);
                    }
                    --cDesired;
                }
                ++i;
            }
        }
        return setTo;
    }

    public int getHeuristicTimeoutMillis() {
        return this.getDeliveryTimeoutMillis() >> 1;
    }

    public long getLastInterminableWarningMillis() {
        return this.__m_LastInterminableWarningMillis;
    }

    public UUID getLastPanicUid() {
        return this.__m_LastPanicUid;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public String getMemberStatsDescription(Member member) {
        return member.toString(Member.SHOW_STATS);
    }

    public long getMembershipReopen() {
        return this.__m_MembershipReopen;
    }

    public int getMulticastTimeToLive() {
        return this.getWellKnownAddresses() == null ? 0 : ((Cluster)this.getCluster()).getDependencies().getGroupTimeToLive();
    }

    public LongArray getPendingServiceJoining() {
        return this.__m_PendingServiceJoining;
    }

    public ClusterService$QuorumControl getQuorumControl() {
        ClusterService$QuorumControl control = this.__m_QuorumControl;
        if (control == null) {
            control = (ClusterService$QuorumControl)this._findChild("QuorumControl");
            this.setQuorumControl(control);
        }
        return control;
    }

    public Member getRequestMember() {
        return this.__m_RequestMember;
    }

    public long getRequestTimeout() {
        return this.getDeliveryTimeoutMillis();
    }

    public Grid[] getService() {
        return this.__m_Service;
    }

    public Grid getService(int i) {
        Grid[] aService = this.getService();
        return (aService == null ? true : i >= aService.length) ? null : aService[i];
    }

    public Grid getService(String sName) {
        int cServices = this.getServiceCount();
        int i = 0;
        while (i < cServices) {
            Grid service = this.getService(i);
            if (!(service != null) ? false : sName.equals(service.getServiceName())) {
                return service;
            }
            ++i;
        }
        return null;
    }

    public Map getServiceContext() {
        return this.__m_ServiceContext;
    }

    public int getServiceCount() {
        Grid[] aService = this.getService();
        return aService == null ? 0 : aService.length;
    }

    public ServiceInfo[] getServiceInfo() {
        return this.__m_ServiceInfo;
    }

    public ServiceInfo getServiceInfo(int i) {
        ServiceInfo[] ainfo = this.getServiceInfo();
        return (ainfo == null ? true : i >= ainfo.length) ? null : ainfo[i];
    }

    public ServiceInfo getServiceInfo(String sName) {
        int cInfo = this.getServiceInfoCount();
        int i = 0;
        while (i < cInfo) {
            ServiceInfo info = this.getServiceInfo(i);
            if (!(info != null) ? false : sName.equals(info.getServiceName())) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public int getServiceInfoCount() {
        ServiceInfo[] ainfo = this.getServiceInfo();
        return ainfo == null ? 0 : ainfo.length;
    }

    public Member getServiceOldestMember() {
        return this.getClusterOldestMember();
    }

    public String getServiceStateName() {
        return new StringBuilder(String.valueOf(super.getServiceStateName())).append(", ").append(ClusterService.formatStateName(this.getState())).toString();
    }

    public String getServiceType() {
        return "Cluster";
    }

    public String getServiceVersion() {
        String sVersion = Coherence.VERSION_INTERNAL;
        return ((sVersion == null ? true : sVersion.isEmpty()) ? true : "n/a".equals(sVersion)) ? VERSION : sVersion;
    }

    public Set getSlowMembers() {
        HashSet<Member> setMembers = null;
        Iterator iter = this.getClusterMemberSet().iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!this.isSlow(member)) continue;
            if (setMembers == null) {
                setMembers = new HashSet<Member>();
            }
            setMembers.add(member);
        }
        return setMembers;
    }

    public long getStartupTimeout() {
        return this.getDeliveryTimeoutMillis();
    }

    public int getState() {
        return this.__m_State;
    }

    public long getStatsJoinRequests() {
        return this.__m_StatsJoinRequests;
    }

    public long getStatsMembersDepartureCount() {
        return this.__m_StatsMembersDepartureCount;
    }

    public ClusterService$TcpRing getTcpRing() {
        ClusterService$TcpRing ring = this.__m_TcpRing;
        if (ring == null) {
            ring = (ClusterService$TcpRing)this._findChild("TcpRing");
            this.setTcpRing(ring);
        }
        return ring;
    }

    public long getTimestamp() {
        return this.calcTimestamp(Base.getSafeTimeMillis());
    }

    public long getTimestampAdjustment() {
        return this.__m_TimestampAdjustment;
    }

    public int getTimestampMaxVariance() {
        return this.__m_TimestampMaxVariance;
    }

    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long cWait2 = Math.max(1L, this.getBroadcastNextMillis() - Base.getSafeTimeMillis());
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    public Set getWellKnownAddresses() {
        return this.__m_WellKnownAddresses;
    }

    protected MemberSet getWitnessMemberSet(Member memberSuspect) {
        int GREATER = 0;
        int EQUAL = 1;
        int LESSER = 2;
        int WEAK = 3;
        int POOR = 4;
        int NIL = 5;
        Object[] aoMember = this.getClusterMemberSet().toArray();
        Member memberThis = this.getThisMember();
        int nMachineThis = memberThis.getMachineId();
        int nMachineSuspect = memberSuspect.getMachineId();
        Arrays.shuffle(aoMember);
        ActualMemberSet setWitness = new ActualMemberSet();
        int iCatDesired = GREATER;
        int iCatBest = NIL;
        int s = 0;
        while (iCatDesired < NIL) {
            int i = s;
            while (i < aoMember.length) {
                Member member = (Member)aoMember[i];
                int iCatThat = NIL;
                if (member != null) {
                    int nMachineThat = member.getMachineId();
                    int iComp = this.compareImportance(member);
                    int n = ((member == memberThis ? true : member == memberSuspect) ? true : member.isDeaf()) ? NIL : ((this.isSlow(member) ? true : this.isRecentlyHeuristicallyDead(member)) ? POOR : ((nMachineThat == nMachineThis ? true : nMachineThat == nMachineSuspect) ? WEAK : (iCatThat = iComp > 0 ? LESSER : (iComp == 0 ? EQUAL : GREATER))));
                    if (iCatThat <= iCatDesired) {
                        setWitness.add(member);
                        if (setWitness.size() == 2) {
                            return setWitness;
                        }
                        iCatThat = NIL;
                    } else if (iCatThat < iCatBest) {
                        iCatBest = iCatThat;
                    }
                }
                if (iCatThat == NIL) {
                    aoMember[i] = null;
                    if (i == s) {
                        ++s;
                    }
                }
                ++i;
            }
            iCatDesired = Math.max(iCatDesired + 1, iCatBest);
        }
        return setWitness.isEmpty() ? null : setWitness;
    }

    public int getWkaHashCode() {
        return this.isWkaEnabled() ? this.getWellKnownAddresses().hashCode() : 0;
    }

    public Map getWkaMap() {
        return this.__m_WkaMap;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ClusterService();
    }

    private final Component get_Module() {
        return this;
    }

    public void heartbeat(MemberSet setMember) {
        if (setMember == null ? true : setMember.isEmpty()) {
            return;
        }
        long ldtLastReceived = this.calcTimestamp(this.getThisMember().getLastIncomingMillis());
        Iterator iter = setMember.iterator();
        while (iter.hasNext()) {
            ClusterService$MemberHeartbeat msg = (ClusterService$MemberHeartbeat)this.instantiateMessage("MemberHeartbeat");
            msg.setToMemberSet(SingleMemberSet.instantiate((Member)iter.next()));
            msg.setLastReceivedMillis(ldtLastReceived);
            this.post(msg);
        }
        this.flush();
    }

    public int indexOfService(String sName) {
        Component._assert(sName != null);
        ServiceInfo[] ainfo = this.getServiceInfo();
        int i = 0;
        int c = ainfo.length;
        while (i < c) {
            ServiceInfo info = ainfo[i];
            if (!(info != null) ? false : info.getServiceName().equals(sName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void initializeTransport() {
        this.setMessagePublisher(((Cluster)this.getCluster()).getPublisher());
    }

    public Member instantiateMember() {
        Member member = new Member();
        member.initCommSupport();
        return member;
    }

    public boolean isHeuristicallyDead(Member member) {
        if (member == null ? true : member.isDeaf()) {
            return true;
        }
        long lCurrentMillis = Base.getSafeTimeMillis();
        long lCutoffMillis = lCurrentMillis - (long)this.getHeuristicTimeoutMillis();
        long lLastInMillis = member.getLastIncomingMillis();
        return lLastInMillis < lCutoffMillis;
    }

    public boolean isMembershipSuspended() {
        return Base.getSafeTimeMillis() <= this.getMembershipReopen() ? true : this.getQuorumControl().isClusterSuspended();
    }

    public boolean isRecentlyHeuristicallyDead(Member member) {
        if ((member == null ? true : member.isDeaf()) ? true : this.isHeuristicallyDead(member)) {
            return true;
        }
        return member.getLastHeuristicDeathMillis() >= Base.getSafeTimeMillis() - (long)this.getDeliveryTimeoutMillis();
    }

    public boolean isSlow(Member member) {
        int cTimeoutMillis;
        long lCurrentMillis = Base.getSafeTimeMillis();
        long lLastSlowMillis = member.getLastSlowMillis();
        return lLastSlowMillis > lCurrentMillis - (long)(cTimeoutMillis = this.getDeliveryTimeoutMillis());
    }

    public boolean isSuspendedFully() {
        return this.isSuspended();
    }

    public boolean isVersionCompatible(String sVersion) {
        int nThat;
        String sVersionThis = this.getServiceVersion();
        if (Base.equals(sVersionThis, sVersion)) {
            return true;
        }
        int nThis = ServiceMemberSet.parseVersion(sVersionThis);
        return nThis <= (nThat = ServiceMemberSet.parseVersion(sVersion)) ? true : nThat >= ServiceMemberSet.parseVersion(VERSION_BARRIER);
    }

    public boolean isVersionOlder(String sVersion) {
        String sVersionThis = this.getServiceVersion();
        return !(Base.equals(sVersionThis, sVersion) ^ true) ? false : ServiceMemberSet.parseVersion(sVersion) < ServiceMemberSet.parseVersion(sVersionThis);
    }

    public boolean isWellKnown(Member member) {
        return this.isWkaEnabled() ^ true ? true : this.getWellKnownAddresses().contains(member.getSocketAddress());
    }

    public boolean isWellKnown(InetAddress addrInet) {
        return this.isWkaEnabled() ^ true ? true : this.getWellKnownAddresses().contains(new InetSocketAddress(addrInet, this.getCluster().getDependencies().getGroupPort()));
    }

    public boolean isWkaEnabled() {
        return this.getWellKnownAddresses() != null;
    }

    protected void notifyServiceJoined() {
    }

    protected void onEnter() {
        int n;
        if (this.isWkaEnabled() && (!((n = ((Cluster)this.getCluster()).getDependencies().getEdition()) < 3) ? false : n != 1)) {
            throw Base.ensureRuntimeException(null, this.toString("HT^\u007fw*16<>,+r013&v\u007f<3*,+:-618\u007f6,\u007f10+\u007f>)>63>=3:q"));
        }
        this.setBroadcastLimit(this.getBroadcastTimeoutMillis() / this.getBroadcastRepeatMillis() + 1);
        this.setBroadcastNextMillis(Base.getSafeTimeMillis());
        super.onEnter();
    }

    public void onException(Throwable e) {
        switch (this.getState()) {
            default: {
                super.onException(e);
                break;
            }
            case 1: {
                if (e instanceof ClusterJoinException) {
                    this.setStartException(e);
                } else {
                    Component._trace(new StringBuilder(String.valueOf("StopJoining ")).append(this.toString()).append(" due to unhandled exception: ").toString(), 1);
                    Component._trace(e);
                }
                this.onStopJoining();
                break;
            }
            case 2: {
                Component._trace(new StringBuilder(String.valueOf("StopRunning ")).append(this.toString()).append(" due to unhandled exception: ").toString(), 1);
                Component._trace(e);
                this.onStopRunning();
                break;
            }
        }
    }

    protected void onExit() {
        this.getTcpRing().close();
        super.onExit();
    }

    public void onInit() {
        MasterMemberSet setMember = new MasterMemberSet();
        this.setClusterMemberSet(setMember);
        this.setServiceMemberSet(setMember);
        this.ensureServiceInfo(0, this.getServiceName(), this.getServiceType());
        this.setService(0, this);
        super.onInit();
        ClusterService$TcpRing ring = this.getTcpRing();
        this.setNotifier(ring);
        ((Grid$ReceiveQueue)this.getQueue()).setNotifier(ring);
    }

    protected void onInterval() {
        super.onInterval();
    }

    public void onMemberJoined(Member member) {
        Member memberThis = this.getThisMember();
        if (!(memberThis != null) ? false : member != memberThis) {
            long ldtCluster;
            long ldtMember = member.getTimestamp();
            if (ldtMember > (ldtCluster = this.getTimestamp())) {
                this.setTimestampAdjustment(this.getTimestampAdjustment() + (ldtMember - ldtCluster));
            }
            Component._trace(new StringBuilder(String.valueOf(member)).append(" joined Cluster with senior member ").append(this.getClusterOldestMember().getId()).toString(), 3);
            Cluster cluster = (Cluster)this.getCluster();
            cluster.onMemberJoined(member);
            if (this.getClusterMemberSet().isServiceJoined(memberThis.getId())) {
                this.getTcpRing().onMemberJoined(member);
            }
            int i = 0;
            int c = this.getServiceCount();
            while (i < c) {
                Grid service = this.getService(i);
                if (service != null) {
                    Grid$NotifyMemberJoined msg = (Grid$NotifyMemberJoined)service.instantiateMessage("NotifyMemberJoined");
                    msg.setNotifyMember(member);
                    service.send(msg);
                }
                ++i;
            }
            this.getQuorumControl().onMemberJoined(member);
        }
        if (this.isAcceptingClients()) {
            this.dispatchMemberEvent(member, MemberEvent.MEMBER_JOINED);
            this.dispatchNotification(Registry.CLUSTER_TYPE, "member.joined", new StringBuilder(String.valueOf("Member ")).append(member.getId()).append(" joined").toString(), member.toString());
        }
    }

    public void onMemberLeaving(Member member) {
        int i = 0;
        int c = this.getServiceCount();
        while (i < c) {
            Grid service = this.getService(i);
            if (service != null) {
                Grid$NotifyMemberLeaving msg = (Grid$NotifyMemberLeaving)service.instantiateMessage("NotifyMemberLeaving");
                msg.setNotifyMember(member);
                service.send(msg);
            }
            ++i;
        }
        this.dispatchMemberEvent(member, MemberEvent.MEMBER_LEAVING);
    }

    protected void onMemberLeft(Member member) {
        member.setLeaving(true);
        Member memberSenior = this.getClusterOldestMember();
        Component._trace(new StringBuilder(String.valueOf(member)).append(" left Cluster with senior member ").append(memberSenior.getId()).toString(), 3);
        this.getQuorumControl().onMemberLeft(member);
        this.removeDynamicBroadcast(member);
        Cluster cluster = (Cluster)this.getCluster();
        cluster.onMemberLeft(member);
        this.getTcpRing().onMemberLeft(member);
        int i = 0;
        int c = this.getServiceCount();
        while (i < c) {
            Grid service = this.getService(i);
            if (service != null) {
                Grid$NotifyMemberLeft msg = (Grid$NotifyMemberLeft)service.instantiateMessage("NotifyMemberLeft");
                msg.setNotifyMember(member);
                service.send(msg);
            }
            ++i;
        }
        this.dispatchMemberEvent(member, MemberEvent.MEMBER_LEFT);
        this.dispatchNotification(Registry.CLUSTER_TYPE, "member.left", new StringBuilder(String.valueOf("Member ")).append(member.getId()).append(" left").toString(), member.toString());
        this.setStatsMembersDepartureCount(this.getStatsMembersDepartureCount() + (long)1);
    }

    public void onMemberRejected(int nReason, Member rejector) {
        String sError;
        switch (nReason) {
            case 8160: {
                int cbMax = this.getMaximumPacketLength();
                sError = new StringBuilder(String.valueOf("The cluster has exceeded its maximum size.  This limit is ")).append("based on the configured maximum packet length, with the ").append("current value of ").append(cbMax).append(" bytes the cluster size limit ").append("is approximately ").append(MessagePacket.calcMaxMembers(cbMax)).append(" members.").toString();
                break;
            }
            case 8161: {
                sError = "This member is not authorized to join the cluster.";
                break;
            }
            case 8162: {
                sError = new StringBuilder(String.valueOf("This member could not join the cluster because of ")).append("an incompatibility between the cluster protocol used by this ").append("member and the one being used by the rest of the cluster.  This ").append("is most likely caused by a Coherence version mismatch, or by ").append("mismatched protocol filters (e.g. compression, or encryption).").toString();
                break;
            }
            case 8163: {
                sError = new StringBuilder(String.valueOf("This member could not join the cluster because of ")).append("a configuration mismatch between this member ").append("and the configuration being used by the rest of the cluster. ").append("The maximum packet size (").append(this.getMaximumPacketLength()).append(") for this member does not match the maximum packet size that ").append("the running cluster is using.").toString();
                break;
            }
            case 8164: {
                sError = new StringBuilder(String.valueOf("This member could not join the cluster because the ")).append("senior member's license has expired.").toString();
                break;
            }
            case 8165: {
                sError = new StringBuilder(String.valueOf("This member will not join the cluster because the ")).append("senior member's IP address is not an authorized host.").toString();
                break;
            }
            case 8166: {
                boolean fWka = this.isWkaEnabled();
                sError = new StringBuilder(String.valueOf("This member could not join the cluster because of ")).append("a configuration mismatch between this member ").append("and the configuration being used by the running cluster. ").append("This member is").append(fWka ? " " : " not ").append("configured to use WKA, but the running cluster is").append(fWka ? " not." : ".").toString();
                break;
            }
            case 8167: {
                sError = new StringBuilder(String.valueOf("This member could not join the cluster because of ")).append("a configuration mismatch between this member ").append("and the configuration being used by the rest of the cluster. ").append("This member specified a cluster name of \"").append(this.getClusterName()).append("\" ").append("which did not match the name of the running cluster").append(rejector == null ? "" : new StringBuilder(String.valueOf(" ")).append(rejector.getClusterName()).append("\"").toString()).append(". This indicates that there are multiple clusters on this network attempting to use overlapping ").append("network configurations.").toString();
                break;
            }
            case 8168: {
                ClusterDependencies cfg = ((Cluster)this.getCluster()).getDependencies();
                String sEditionName = Coherence.EDITION_NAMES[cfg.getEdition()];
                sError = new StringBuilder(String.valueOf("This member could not join the cluster because of ")).append("a mismatch between Coherence product editions. This ").append("member was attempting to run as a ").append(Coherence.TITLE).append(" ").append(sEditionName).append(" edition cluster.").toString();
                break;
            }
            case 8169: {
                ClusterDependencies cfg = ((Cluster)this.getCluster()).getDependencies();
                String modeName = Coherence.MODE_NAMES[cfg.getMode()];
                sError = new StringBuilder(String.valueOf("This member could not join the cluster because of ")).append("a mismatch between Coherence license types. This ").append("member was attempting to run in ").append(modeName).append(" mode.").toString();
                break;
            }
            case 8170: {
                this.resetBroadcastCounter("restarting the join protocol", null);
                this.setTimestampAdjustment(0);
                this.setRequestMember(null);
                this.setState(STATE_ANNOUNCE);
                return;
            }
            case 8172: {
                sError = new StringBuilder(String.valueOf("This member was prevented from joining the cluster by ")).append("the existing cluster's action policy.").toString();
                break;
            }
            default: {
                sError = new StringBuilder(String.valueOf("Unknown reject reason code of ")).append(nReason).toString();
                break;
            }
        }
        if (sError != null) {
            if (rejector != null) {
                sError = new StringBuilder(String.valueOf(sError)).append(new StringBuilder(String.valueOf(" Rejected by ")).append(rejector).append(".").toString()).toString();
            }
            Component._trace(sError, 1);
        }
        this.onStopJoining();
    }

    public void onMembersTimedOut(Set setTimedOut) {
        this.getQuorumControl().onMembersTimedOut(setTimedOut);
    }

    protected boolean onMessageReadException(Throwable e, Message msg) {
        if (msg instanceof DiscoveryMessage) {
            if (e instanceof SecurityException) {
                Component._trace(new StringBuilder(String.valueOf("SecurityException received while reading message ")).append(msg.get_Name()).append("\n").append(e).toString(), 2);
            }
            ((DiscoveryMessage)msg).setReadError(true);
            return true;
        }
        return super.onMessageReadException(e, msg);
    }

    protected void onNotify() {
        long lTime = Base.getSafeTimeMillis();
        if (lTime >= this.getBroadcastNextMillis()) {
            switch (this.getState()) {
                case 0: {
                    this.onTimerAnnouncing();
                    break;
                }
                case 1: {
                    this.onTimerJoining();
                    break;
                }
                case 2: {
                    this.onTimerRunning();
                    break;
                }
            }
            this.setBroadcastNextMillis(lTime + (long)this.getBroadcastRepeatMillis());
        }
        super.onNotify();
    }

    public void onNotifyIpTimeout(InetAddress address) {
        ActualMemberSet setTimedOut = new ActualMemberSet();
        Iterator iter = this.getClusterMemberSet().iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!address.equals(member.getAddress())) continue;
            ((MemberSet)setTimedOut).add(member);
        }
        if (((MemberSet)setTimedOut).isEmpty() ^ true) {
            iter = setTimedOut.iterator();
            while (iter.hasNext()) {
                if (!(((Member)iter.next()).isTimedOut() ^ true)) continue;
                Component._trace(new StringBuilder(String.valueOf("Failed to reach address ")).append(address).append(" within the ").append("IpMonitor timeout. Members ").append(setTimedOut.toString(Member.SHOW_STATS)).append(" are suspect.").toString(), 2);
                break;
            }
            this.onMembersTimedOut(setTimedOut);
        }
    }

    public void onNotifyMemberLeft(Member member) {
        this.closePolls(member);
    }

    public void onNotifyTcmpTimeout(MessagePacket packet, MemberSet setLate) {
        HashSet<Member> setTimedOut = new HashSet<Member>();
        Member memberThis = this.getThisMember();
        Iterator iter = setLate.iterator();
        while (iter.hasNext()) {
            Member memberLate = (Member)iter.next();
            if (!((memberLate.isTimedOut() ? true : memberThis.isTimedOut()) ? true : this.verifyMemberLeft(memberLate, packet))) continue;
            setTimedOut.add(memberLate);
        }
        if (setTimedOut.isEmpty() ^ true) {
            this.onMembersTimedOut(setTimedOut);
        }
    }

    public void onNotifyTcpDeparture(Member member) {
        if (this.getClusterMemberSet().contains(member)) {
            this.doMemberLeft(member);
        }
    }

    public void onServiceAnnounced(ServiceInfo info) {
        String sServiceName = info.getServiceName();
        int i = 1;
        int c = this.getServiceCount();
        while (i < c) {
            Grid service = this.getService(i);
            if (service != null) {
                Grid$NotifyServiceAnnounced msg = (Grid$NotifyServiceAnnounced)service.instantiateMessage("NotifyServiceAnnounced");
                msg.setNotifyServiceName(sServiceName);
                service.send(msg);
            }
            ++i;
        }
    }

    public void onServiceJoined(ServiceInfo info, Member member) {
    }

    public void onServiceJoining(ServiceInfo info, Member member) {
        Component._assert(!(info != null) ? false : member != null);
    }

    public void onServiceLeaving(ServiceInfo info, Member member) {
        Grid service;
        int nServiceId;
        Component._assert(!(info != null) ? false : member != null);
        Component._assert(info.getMemberSet().contains(member));
        if (member != this.getThisMember() && (nServiceId = info.getServiceId()) > 0 && (!((service = this.getService(nServiceId)) != null) ? false : service.getServiceMemberSet() != null)) {
            Grid$NotifyServiceLeaving msg = (Grid$NotifyServiceLeaving)service.instantiateMessage("NotifyServiceLeaving");
            msg.setNotifyMember(member);
            service.send(msg);
        }
    }

    public void onServiceLeft(ServiceInfo info, Member member, int nState) {
        Component._assert(!(info != null) ? false : member != null);
        if (member != this.getThisMember()) {
            int nServiceId = info.getServiceId();
            Component._assert(nServiceId > 0);
            Grid service = this.getService(nServiceId);
            if (!(service != null) ? false : service.getServiceMemberSet() != null) {
                Grid$NotifyServiceLeft msg = (Grid$NotifyServiceLeft)service.instantiateMessage("NotifyServiceLeft");
                msg.setNotifyMember(member);
                service.send(msg);
            }
        }
    }

    public void onServiceStarted() {
    }

    public void onStopJoining() {
        if (this.isAcceptingClients()) {
            this.getCluster().stop();
        } else {
            this.stop();
        }
    }

    public void onStopRunning() {
        if (this.isAcceptingClients()) {
            this.getCluster().stop();
        } else {
            this.getTcpRing().onLeft();
            this.stop();
        }
    }

    public void onTimerAnnouncing() {
        int cLimit;
        Member memberThis = this.getAnnounceMember();
        int cAttempts = this.getBroadcastCounter() + 1;
        if (cAttempts > (cLimit = this.getBroadcastLimit())) {
            Cluster cluster = (Cluster)this.getCluster();
            boolean fWellKnown = this.isWellKnown(memberThis) ? true : this.isWellKnown(memberThis.getAddress());
            boolean fDeaf = this.getStatsJoinRequests() == (long)0;
            if (!(!fWellKnown ? false : fDeaf ^ true) ? false : this.ensureDiscovery()) {
                MasterMemberSet setMember = this.getClusterMemberSet();
                memberThis.setId(1);
                memberThis.setPreferredPacketLength(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPacketLength());
                memberThis.setPreferredPort(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPort());
                int nReject = setMember.induct(memberThis, this);
                if (nReject == REJECT_NONE) {
                    setMember.setThisMember(memberThis);
                    Component._trace(new StringBuilder(String.valueOf("Created a new ")).append(this.formatClusterString()).append(" with ").append(memberThis.toString(Member.SHOW_LICENSE)).toString(), 3);
                    this.setState(STATE_JOINED);
                    setMember.setServiceJoined(memberThis.getId());
                    this.setAcceptingClients(true);
                } else {
                    Component._trace(new StringBuilder(String.valueOf(memberThis.toString(Member.SHOW_LICENSE))).append(" is unable to join the cluster.").toString(), 1);
                    this.onMemberRejected(nReject, null);
                }
            } else if (fWellKnown ^ true) {
                this.resetBroadcastCounter(new StringBuilder(String.valueOf("waiting for well-known nodes in cluster '")).append(this.getClusterName()).append("' to respond").toString(), null);
            } else if (fDeaf) {
                boolean fMC = this.getWellKnownAddresses() == null;
                this.resetBroadcastCounter(new StringBuilder(String.valueOf(fMC ? "multicast" : "unicast")).append(" networking appears to be inoperable on interface ").append(memberThis.getAddress().getHostAddress()).append(" as this process isn't receiving even its own transmissions").append(InetAddresses.PreferIPv4Stack ? (fMC ? "; consider switching network interfaces or using WKA based clustering" : "; consider switching network interfaces") : "; consider forcing IPv4 via -Djava.net.preferIPv4Stack=true").toString(), null);
            } else {
                this.resetBroadcastCounter("unable to bind or share cluster port", null);
            }
        } else {
            ClusterService$NewMemberAnnounce msg = (ClusterService$NewMemberAnnounce)this.instantiateMessage("NewMemberAnnounce");
            msg.setAnnounceProtocolVersion(ANNOUNCE_PROTOCOL_VERSION);
            msg.setFromMember(memberThis);
            msg.setAttemptCounter(cAttempts);
            msg.setAttemptLimit(cLimit);
            this.send(msg);
            this.setBroadcastCounter(cAttempts);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onTimerJoining() {
        int cLimit;
        int cAttempts = this.getBroadcastCounter() + 1;
        if (cAttempts > (cLimit = this.getBroadcastLimit())) {
            if (!(this.getThisMember() == null)) throw new ClusterJoinException();
            this.resetBroadcastCounter("AnnounceReply was not followed by RequestIdReply", null);
            this.setTimestampAdjustment(0);
            this.setRequestMember(null);
            this.setState(STATE_ANNOUNCE);
            return;
        } else {
            ClusterService$NewMemberRequestId msg = (ClusterService$NewMemberRequestId)this.instantiateMessage("NewMemberRequestId");
            msg.setFromMember(this.getRequestMember());
            msg.setAttemptCounter(cAttempts);
            msg.setAttemptLimit(cLimit);
            msg.setServiceVersion(VERSION_BARRIER);
            msg.setMaxPacketSize(this.getMaximumPacketLength());
            msg.setWkaEnabled(this.isWkaEnabled());
            this.send(msg);
            this.setBroadcastCounter(cAttempts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimerRunning() {
        DiscoveryMessage msg;
        Set setBroadcast;
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member memberThis = setMember.getThisMember();
        Member memberOldest = setMember.getOldestMember();
        long ldtLastRecv = this.calcTimestamp(memberThis.getLastIncomingMillis());
        MemberSet setTo = this.getHeartbeatMemberSet();
        if (!(setTo != null) ? false : setTo.isEmpty() ^ true) {
            this.heartbeat(setTo);
        }
        if (!((setBroadcast = this.getBroadcastAddresses()) != null) ? false : this.getBroadcastAddressesExpiry() < Base.getSafeTimeMillis()) {
            Set set = setBroadcast;
            synchronized (set) {
                setBroadcast.clear();
            }
        }
        if (this.isAcceptingClients()) {
            if (memberThis == memberOldest) {
                msg = (ClusterService$SeniorMemberHeartbeat)this.instantiateMessage("SeniorMemberHeartbeat");
                ((ClusterService$SeniorMemberHeartbeat)msg).setLastReceivedMillis(ldtLastRecv);
                ((ClusterService$SeniorMemberHeartbeat)msg).setMemberSet(setMember);
                ((ClusterService$SeniorMemberHeartbeat)msg).setWkaEnabled(this.isWkaEnabled());
                ((ClusterService$SeniorMemberHeartbeat)msg).setLastJoinTime(setMember.getLastJoinTime());
                this.send(msg);
                this.checkPendingJoinPolls();
            }
        } else if (memberThis == memberOldest) {
            this.setAcceptingClients(true);
        } else {
            msg = (ClusterService$NewMemberWelcomeAnnounce)this.instantiateMessage("NewMemberWelcomeAnnounce");
            ((ClusterService$NewMemberWelcomeAnnounce)msg).setSeniorMember(memberOldest);
            ((ClusterService$NewMemberWelcomeAnnounce)msg).setServiceVersion(VERSION_BARRIER);
            this.send(msg);
        }
        this.getTcpRing().heartbeatBuddies();
    }

    public void populateWelcomeMessage(ClusterService$NewMemberWelcome msg) {
        Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        msg.setFromMemberUid(memberThis.getUid32());
        msg.setPreferredPacketLength(memberThis.getPreferredPacketLength());
        msg.setPreferredPort(memberThis.getPreferredPort());
        Grid[] aService = this.getService();
        int cServices = aService.length;
        ServiceInfo[] aInfo = new ServiceInfo[cServices];
        int cInfo = 0;
        int iService = 0;
        while (iService < cServices) {
            ServiceInfo info;
            Grid service = aService[iService];
            if (service != null && (info = this.getServiceInfo(iService)).getMemberSet().getServiceJoinTime(nMemberThis) > 0L) {
                aInfo[cInfo++] = info;
            }
            ++iService;
        }
        msg.setServiceCount(cInfo);
        int i = 0;
        while (i < cInfo) {
            ServiceInfo info = aInfo[i];
            ServiceMemberSet setMember = info.getMemberSet();
            msg.setServiceId(i, info.getServiceId());
            msg.setServiceName(i, info.getServiceName());
            msg.setServiceType(i, info.getServiceType());
            msg.setServiceVersion(i, setMember.getServiceVersion(nMemberThis));
            msg.setServiceEndPointName(i, setMember.getServiceEndPointName(nMemberThis));
            msg.setServiceJoinTime(i, setMember.getServiceJoinTime(nMemberThis));
            msg.setServiceState(i, setMember.getState(nMemberThis));
            msg.setServiceMemberConfigMap(i, setMember.getMemberConfigMap(nMemberThis));
            ++i;
        }
    }

    protected void register() {
    }

    public void registerServiceJoining(ClusterService$ServiceJoining msg) {
        Component._assert(Thread.currentThread() == this.getThread());
        LongArray laPending = this.getPendingServiceJoining();
        long lIndex = Base.getSafeTimeMillis();
        while (true) {
            if (laPending.get(lIndex) == null) {
                laPending.set(lIndex, msg);
                return;
            }
            ++lIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicBroadcast(Member member) {
        Set setBroadcast;
        if ((!(member != null) ? false : this.isWellKnown(member) ^ true) && (setBroadcast = this.getBroadcastAddresses()) != null) {
            Set set = setBroadcast;
            synchronized (set) {
                setBroadcast.remove(member.getSocketAddress());
            }
        }
    }

    public void removeMember(Member member) {
        int nMember = member.getId();
        int i = 1;
        int c = this.getServiceInfoCount();
        while (i < c) {
            ServiceInfo info = this.getServiceInfo(i);
            if (info != null) {
                int nState = info.getMemberSet().getState(nMember);
                if (info.getMemberSet().remove(member)) {
                    this.onServiceLeft(info, member, nState);
                }
            }
            ++i;
        }
        if (this.getClusterMemberSet().remove(member)) {
            this.onMemberLeft(member);
        }
    }

    public void resetBroadcastCounter(DataInput stream, boolean fSelf) throws IOException {
        Coherence app = (Coherence)Coherence.get_Instance();
        XmlElement xmlAll = Coherence.getServiceConfig(this.toString("{S6<:1,:"));
        MasterMemberSet setMember = this.getClusterMemberSet();
        boolean fValid = fSelf ? true : (!(!(this.getState() == STATE_JOINED) ? false : setMember.getThisMember() == setMember.getOldestMember()) ? false : this.isMembershipSuspended() ^ true);
        int nEThis = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString(":;6+601r1>2:")).getString()));
        int nMThis = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString("36<:1,:r20;:")).getString()));
        Map map = this.getWkaMap();
        int nEThat = ExternalizableHelper.readInt(stream);
        int nMThat = ExternalizableHelper.readInt(stream);
        if ((nEThis == nEThat ? true : ((!(nEThis == 1) ? false : nEThat == 5) ? true : (!(nEThis == 5) ? false : nEThat == 1))) ^ true) {
            fValid = false;
        }
        if (nMThis != nMThat) {
            fValid = false;
        }
        int[] anType = new int[6];
        int i = 0;
        int c = anType.length;
        while (i < c) {
            anType[i] = -1;
            ++i;
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            int[] an = (int[])iter.next();
            anType[an[0]] = an[1];
        }
        while (stream.readBoolean()) {
            int[] anOld;
            UID id = new UID(stream);
            int[] an = new int[3];
            int i2 = 0;
            while (i2 < 3) {
                an[i2] = ExternalizableHelper.readInt(stream);
                ++i2;
            }
            if (!fValid) continue;
            if (!(anType[an[0]] >= 0) ? false : an[1] != anType[an[0]]) {
                if (an[2] >= 0) continue;
                Iterator iter2 = map.values().iterator();
                while (iter2.hasNext()) {
                    if (!(((int[])iter2.next())[0] == an[0])) continue;
                    iter2.remove();
                }
            }
            if ((anOld = map.put(id, an)) != null && (!(anOld[0] == an[0]) ? false : anOld[1] == an[1])) {
                an[2] = Math.max(an[2], anOld[2]);
            }
            anType[an[0]] = an[1];
        }
    }

    public void resetBroadcastCounter(String sReason, DiscoveryMessage msg) {
        this.setBroadcastCounter(0);
        Member memberThis = this.getAnnounceMember();
        long ldtNow = Base.getSafeTimeMillis();
        long cMillisDelay = ldtNow - memberThis.getTimestamp();
        long cMillisMax = this.getStartupTimeout();
        long cMillisJoin = this.getBroadcastTimeoutMillis();
        long cMillisWarn = Math.min(30000L, (cMillisMax + cMillisJoin) / (long)2);
        if (!(sReason != null) ? false : cMillisDelay > cMillisWarn) {
            long ldtLastWarning = this.getLastInterminableWarningMillis();
            if (ldtLastWarning == 0L) {
                if (this.isWkaEnabled()) {
                    Component._trace(new StringBuilder(String.valueOf("This ")).append(memberThis).append(" has been attempting to join the cluster using WKA list ").append(this.getWellKnownAddresses()).append(" for ").append(cMillisDelay / (long)1000).append(" seconds without success;").append(" this could indicate a mis-configured WKA, or it may").append(" simply be the result of a busy cluster or active failover.").toString(), 2);
                } else {
                    ClusterDependencies config = ((Cluster)this.getCluster()).getDependencies();
                    Component._trace(new StringBuilder(String.valueOf("This ")).append(memberThis).append(" has been attempting to join the cluster at address ").append(config.getGroupAddress().toString()).append(":").append(config.getGroupPort()).append(" with TTL ").append(config.getGroupTimeToLive()).append(" for ").append(cMillisDelay / (long)1000).append(" seconds without success;").append(" this could indicate a mis-configured TTL value, or it may").append(" simply be the result of a busy cluster or active failover.").toString(), 2);
                }
            }
            int iLevel = 6;
            if (ldtNow > ldtLastWarning + 5000L) {
                iLevel = 2;
                this.setLastInterminableWarningMillis(ldtNow);
            }
            String sMsg = msg == null ? new StringBuilder(String.valueOf("Delaying formation of a new cluster; ")).append(sReason).toString() : new StringBuilder(String.valueOf("Received a discovery message that indicates ")).append(sReason).append(":\n").append(msg).toString();
            Component._trace(sMsg, iLevel);
            if (cMillisDelay > cMillisMax) {
                Component._trace(new StringBuilder(String.valueOf("Failure to join a cluster for ")).append(cMillisDelay / (long)1000).append(" seconds").append("; stopping cluster service.").toString(), 1);
                this.onStopJoining();
            }
        }
    }

    public void setAcceptingClients(boolean fAccepting) {
        boolean fPrev = this.isAcceptingClients();
        super.setAcceptingClients(fAccepting);
        if (!fAccepting ? false : fPrev ^ true) {
            int cMillis = this.getHeartbeatDelay();
            if (cMillis == 0) {
                cMillis = Math.max(this.getBroadcastRepeatMillis(), this.getBroadcastTimeoutMillis() >>> 3);
            }
            this.setBroadcastRepeatMillis(cMillis);
        }
    }

    public void setActionPolicy(ActionPolicy policy) {
        super.setActionPolicy(policy);
    }

    public void setAnnounceMember(Member member) {
        this.__m_AnnounceMember = member;
    }

    public void setBroadcastAddresses(Set setAddresses) {
        this.__m_BroadcastAddresses = setAddresses;
    }

    public void setBroadcastAddressesExpiry(long setAddresses) {
        this.__m_BroadcastAddressesExpiry = setAddresses;
    }

    public void setBroadcastCounter(int c) {
        this.__m_BroadcastCounter = c;
    }

    /*
     * Unable to fully structure code
     */
    public void setBroadcastLimit(int c) {
        block40: {
            block41: {
                if (!(c > 0)) break block40;
                n = this.getBroadcastMode();
                iInv = -2147483648;
                if (!(n < 1)) break block41;
                app = (Coherence)Coherence.get_Instance();
                n = this.getBroadcastVariance();
                cl = ClusterService.__sm0().getClassLoader();
                if (cl == null) {
                    cl = Base.getContextClassLoader();
                }
                asName = new String[]{"<02p+>180,03p36<:1,:pS6<:1,:;P=5:<+q<3>,,", "<02p+>180,03p36<:1,:pS6<:1,:;P=5:<+{S6<:1,:[>+>q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:[>+>X-6;Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:^//36<>+601Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:\\><7618Z;6+601q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:\\02/*+:\\36:1+q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:M:>3K62:\\36:1+q<3>,,", "<02p+>180,03p36<:1,:p\\07:-:1<:[>+>\\36:1+q<3>,,", "+>180,03q;>+", "+>180,03q<:-"};
                sa = new SparseArray<UID>();
                ab = null;
                if (cl != null) {
                    i = 0;
                    cNames = asName.length;
                    while (i < cNames) {
                        try {
                            in = cl.getResourceAsStream(this.toString(asName[i]));
                            if (in != null) {
                                ab = Base.read(in);
                                n ^= Base.toCrc(ab);
                                if (i == 8) {
                                    bufin = new Binary(ab).getBufferInput();
                                    while (bufin.available() > 0) {
                                        sa.set(bufin.readPackedInt(), new UID(bufin));
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            n -= this.getBroadcastRepeatMillis();
                            iInv |= 1;
                        }
                        ++i;
                    }
                }
                xmlAll = Coherence.getServiceConfig(this.toString("{S6<:1,:"));
                nEN = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString(":;6+601r1>2:")).getString()));
                nLM = Math.max(0, this.fromString(xmlAll.getSafeElement(this.toString("36<:1,:r20;:")).getString()));
                buf = new BinaryWriteBuffer(100);
                try {
                    block37: {
                        try {
                            out = buf.getBufferOutput();
                            out.writePackedInt(nEN);
                            out.writePackedInt(nLM);
                            if (!(nEN >= 2 == false ? false : xmlAll != null)) break block37;
                            cfc = Class.forName(this.toString("5>)>q,:<*-6+&q<:-+q\\:-+696<>+:Y><+0-&"));
                            cf = ClassHelper.invokeStatic(cfc, this.toString("8:+V1,+>1<:"), new Object[]{this.toString("Gqjof")});
                            ct = ClassHelper.invoke(cf, this.toString("8:1:->+:\\:-+696<>+:"), new Object[]{new Binary(ab).getInputStream()});
                            pb = ((Certificate)ct).getPublicKey();
                            sg = null;
                            sgc = Class.forName(this.toString("5>)>q,:<*-6+&qL681>+*-:"));
                            sg = ClassHelper.invokeStatic(sgc, this.toString("8:+V1,+>1<:"), new String[]{this.toString("LW^n(6+7[L^")});
                            mUp = sgc.getMethod(this.toString("*/;>+:"), new Class[]{ClusterService.__sm1(), Integer.TYPE, Integer.TYPE});
                            mVf = sgc.getMethod(this.toString("):-69&"), new Class[]{ClusterService.__sm1()});
                            ClassHelper.invoke(sg, this.toString("616+I:-69&"), new Object[]{pb});
                            iLc = 15;
                            iter = xmlAll.getSafeElement(this.toString("36<:1,:r36,+")).getElements(this.toString("36<:1,:"));
                            while (iter.hasNext()) {
                                block39: {
                                    block45: {
                                        block48: {
                                            block47: {
                                                block46: {
                                                    block38: {
                                                        block44: {
                                                            block43: {
                                                                block42: {
                                                                    xml = (XmlElement)iter.next();
                                                                    id = null;
                                                                    nId = 0;
                                                                    nType = 0;
                                                                    cStop = 0;
                                                                    sP = xml.getSafeElement(this.toString(",09+(>-:")).getString();
                                                                    sL = xml.getSafeElement(this.toString("36<:1,::")).getString();
                                                                    sA = xml.getSafeElement(this.toString(">8-::2:1+")).getString();
                                                                    sM = xml.getSafeElement(this.toString("+&/:")).getString();
                                                                    sF = xml.getSafeElement(this.toString("9-02r;>+:")).getString();
                                                                    sT = xml.getSafeElement(this.toString("+0r;>+:")).getString();
                                                                    sR = xml.getSafeElement(this.toString("2>61+:1>1<:r-:1:(>3r;>+:")).getString();
                                                                    cI = xml.getSafeElement(this.toString("2>'r,:>+,")).getInt();
                                                                    cU = xml.getSafeElement(this.toString("2>'r*,:-,")).getInt();
                                                                    sS = xml.getSafeElement(this.toString(",6+:")).getString();
                                                                    cS = xml.getSafeElement(this.toString("2>'r,:-):-,")).getInt();
                                                                    cP = xml.getSafeElement(this.toString("2>'r,0<4:+,")).getInt();
                                                                    cC = xml.getSafeElement(this.toString("2>'r</*,")).getInt();
                                                                    sI = xml.getSafeElement(this.toString("6;")).getString();
                                                                    sK = xml.getSafeElement(this.toString("4:&")).getString();
                                                                    sE = xml.getSafeElement(this.toString(",681>+*-:")).getString();
                                                                    iInv |= 1 << iLc;
                                                                    if (!(((sP.length() == 0 != false ? true : sL.length() == 0) != false ? true : sM.length() == 0) != false ? true : sI.length() == 0)) break block42;
                                                                    iInv |= 2;
                                                                    break block39;
                                                                }
                                                                nP = this.fromString(sP);
                                                                nM = this.fromString(sM);
                                                                if (!(nP < 1)) break block43;
                                                                iInv |= 4;
                                                                break block39;
                                                            }
                                                            if (!((nP == nEN != false ? true : ((nEN == 1 != false ? true : nEN == 5) == false ? false : (nP == 1 != false ? true : nP == 5))) ^ true)) break block44;
                                                            iInv |= 8;
                                                            break block39;
                                                        }
                                                        if (!(sT.length() > 0)) ** GOTO lbl-1000
                                                        ldt = 0L;
                                                        if (sT.length() >= 8 == false ? false : sT.length() <= 10) {
                                                            ldt = Coherence.parseDate(sT) + (long)(Base.UNIT_D << 2);
                                                        }
                                                        if (this.getTimestamp() > ldt) {
                                                            iInv |= 16;
                                                        } else lbl-1000:
                                                        // 2 sources

                                                        {
                                                            if (sI.length() == 32 != false ? true : sI.length() == 34) {
                                                                try {
                                                                    id = new UID(sI);
                                                                    break block38;
                                                                }
                                                                catch (Throwable e) {
                                                                    iInv |= 32;
                                                                    break block39;
                                                                }
                                                            }
                                                            iInv |= 64;
                                                        }
                                                        break block39;
                                                    }
                                                    if (!(sE.length() == 0)) break block45;
                                                    if (!(sK.length() == 0)) break block46;
                                                    iInv |= 128;
                                                    break block39;
                                                }
                                                try {
                                                    nC = (int)Long.parseLong(sK.substring(1, 9), 16);
                                                    sC = new Binary(Base.parseHex(sK.substring(9, sK.length() - 1))).getBufferInput().readUTF();
                                                }
                                                catch (Exception e) {
                                                    iInv |= 256;
                                                    break block39;
                                                }
                                                nId = this.fromString(sC);
                                                if (!(nP != nId)) break block47;
                                                iInv |= 512;
                                                break block39;
                                            }
                                            sb = new StringBuffer();
                                            sb.append(sP.length() == 0 != false ? null : sP).append(sL.length() == 0 != false ? null : sL).append(nM).append(sC.length() == 0 != false ? null : sC).append(Coherence.parseDate(sF)).append(Coherence.parseDate(sT)).append(cU).append("00").append(sS.length() == 0 != false ? null : sS).append(cS).append('0').append(cC).append(id);
                                            bufTemp = new BinaryWriteBuffer(sb.length() + 10);
                                            bufTemp.getBufferOutput().writeUTF(sb.toString());
                                            if (!(nC != Base.toCrc(bufTemp.toByteArray()))) break block48;
                                            iInv |= 1024;
                                            break block39;
                                        }
                                        if (!(Base.equals(sa.get(nC), id) ^ true)) ** GOTO lbl-1000
                                        iInv |= 2048;
                                        break block39;
                                    }
                                    nId = this.fromString(sP);
                                    sb = new StringBuffer();
                                    sb.append(sP.length() == 0 != false ? null : sP).append(sL.length() == 0 != false ? null : sL).append(sA).append(nM).append(Coherence.parseDate(sF)).append(Coherence.parseDate(sT)).append(Coherence.parseDate(sR)).append(cI).append(cU).append(sS.length() == 0 != false ? null : sS).append(cS).append(cP).append(cC).append(id);
                                    streamRaw = new ByteArrayOutputStream();
                                    stream = new DataOutputStream(streamRaw);
                                    stream.writeUTF(sb.toString());
                                    abRaw = streamRaw.toByteArray();
                                    abSg = Base.parseHex(sE);
                                    mUp.invoke(sg, new Object[]{abRaw, Base.makeInteger(0), Base.makeInteger(abRaw.length)});
                                    if ((Boolean)mVf.invoke(sg, new Object[]{abSg}) ^ true) {
                                        iInv |= 4096;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        if (cS > 0) {
                                            nType = 1;
                                            cStop = cS;
                                        } else if (cP > 0) {
                                            nType = 2;
                                            cStop = cP;
                                        } else if (cC > 0) {
                                            nType = 3;
                                            cStop = cC;
                                        } else if (cI > 0) {
                                            nType = 4;
                                            cStop = cI;
                                        } else if (cU > 0) {
                                            nType = 5;
                                            cStop = cU;
                                        }
                                        out.writeBoolean(true);
                                        out.write(id.toByteArray());
                                        ExternalizableHelper.writeInt(out, nId);
                                        ExternalizableHelper.writeInt(out, nType);
                                        ExternalizableHelper.writeInt(out, cStop);
                                        iInv &= ~(1 << iLc);
                                    }
                                }
                                ++iLc;
                            }
                        }
                        catch (Throwable e) {
                            if (buf.length() > 2) {
                                buf.retain(0, 2);
                            }
                            iInv |= 8192;
                        }
                    }
                    var14_19 = null;
                }
                catch (Throwable var13_18) {
                    var14_20 = null;
                    try {
                        buf.getAppendingBufferOutput().writeBoolean(false);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    throw var13_18;
                }
                try {
                    buf.getAppendingBufferOutput().writeBoolean(false);
                }
                catch (Throwable e) {}
                this.setBroadcastTimestamp(buf.toBinary());
                n = n == 2 != false ? --n : 2;
                this.setBroadcastMode(n);
            }
            if (n > 1) {
                var3_3 = iInv | 16384;
            }
        }
        this.__m_BroadcastLimit = c;
    }

    private void setBroadcastMode(int n) {
        this.__m_BroadcastMode = n;
        try {
            this.resetBroadcastCounter(this.getBroadcastTimestamp().getBufferInput(), true);
        }
        catch (Throwable throwable) {}
    }

    public void setBroadcastNextMillis(long cMillis) {
        this.__m_BroadcastNextMillis = cMillis;
    }

    public void setBroadcastRepeatMillis(int cMillis) {
        this.__m_BroadcastRepeatMillis = cMillis;
    }

    public void setBroadcastTimeoutMillis(int cMillis) {
        this.__m_BroadcastTimeoutMillis = cMillis;
    }

    private void setBroadcastTimestamp(Binary bin) {
        this.__m_BroadcastTimestamp = bin;
    }

    public void setDeliveryTimeoutMillis(int cMillis) {
        this.__m_DeliveryTimeoutMillis = cMillis;
    }

    public void setHeartbeatDelay(int cMillis) {
        this.__m_HeartbeatDelay = cMillis;
    }

    protected void setHeartbeatMemberSet(MemberSet setMember) {
        this.__m_HeartbeatMemberSet = setMember;
    }

    protected void setLastInterminableWarningMillis(long cMillis) {
        this.__m_LastInterminableWarningMillis = cMillis;
    }

    protected void setLastPanicUid(UUID uid) {
        this.__m_LastPanicUid = uid;
    }

    public void setMaximumPacketLength(int cbPacket) {
        this.__m_MaximumPacketLength = cbPacket;
    }

    public void setMembershipReopen(long ldtMillis) {
        this.__m_MembershipReopen = ldtMillis;
    }

    private void setPendingServiceJoining(LongArray la) {
        this.__m_PendingServiceJoining = la;
    }

    protected void setQuorumControl(ClusterService$QuorumControl control) {
        this.__m_QuorumControl = control;
    }

    public void setRequestMember(Member member) {
        this.__m_RequestMember = member;
    }

    protected synchronized void setService(int i, Grid service) {
        boolean fBeyondBounds;
        Grid[] aService = this.getService();
        boolean bl = aService == null ? true : (fBeyondBounds = i >= aService.length);
        if (!fBeyondBounds ? false : service != null) {
            int cNew = i + 1;
            Grid[] aServiceNew = new Grid[cNew];
            if (aService != null) {
                System.arraycopy(aService, 0, aServiceNew, 0, aService.length);
            }
            aService = aServiceNew;
            this.setService(aServiceNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aService[i] = service;
            this.setService(aService);
        }
    }

    protected void setService(Grid[] aService) {
        this.__m_Service = aService;
    }

    public void setServiceContext(Map mapContext) {
        this.__m_ServiceContext = mapContext;
    }

    public synchronized void setServiceInfo(int i, ServiceInfo info) {
        boolean fBeyondBounds;
        ServiceInfo[] ainfo = this.getServiceInfo();
        boolean bl = ainfo == null ? true : (fBeyondBounds = i >= ainfo.length);
        if (!fBeyondBounds ? false : info != null) {
            int cNew = i + 1;
            ServiceInfo[] ainfoNew = new ServiceInfo[cNew];
            if (ainfo != null) {
                System.arraycopy(ainfo, 0, ainfoNew, 0, ainfo.length);
            }
            ainfo = ainfoNew;
            this.setServiceInfo(ainfoNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            ainfo[i] = info;
        }
    }

    protected void setServiceInfo(ServiceInfo[] aInfo) {
        this.__m_ServiceInfo = aInfo;
    }

    public synchronized void setState(int nState) {
        if (nState != this.getState()) {
            switch (nState) {
                case 2: {
                    Member member = this.getThisMember();
                    int nMemberId = member.getId();
                    MasterMemberSet setMember = this.getClusterMemberSet();
                    setMember.setServiceVersion(nMemberId, this.getServiceVersion());
                    setMember.setServiceJoinTime(nMemberId, member.getTimestamp());
                    setMember.setServiceEndPointName(nMemberId, "");
                    this.initializeSUID();
                    Cluster cluster = (Cluster)this.getCluster();
                    ClusterDependencies config = cluster.getDependencies();
                    if (!config.isIpMonitorEnabled()) break;
                    cluster.getIpMonitor().ensureSeniority();
                    break;
                }
            }
            this.__m_State = nState;
            this.updateServiceThreadName();
        }
        this.notifyAll();
    }

    public void setStatsJoinRequests(long cMsgs) {
        this.__m_StatsJoinRequests = cMsgs;
    }

    protected void setStatsMembersDepartureCount(long c) {
        this.__m_StatsMembersDepartureCount = c;
    }

    protected void setTcpRing(ClusterService$TcpRing ring) {
        this.__m_TcpRing = ring;
    }

    public void setTimestampAdjustment(long cMillis) {
        this.__m_TimestampAdjustment = cMillis;
    }

    public void setTimestampMaxVariance(int cMillis) {
        this.__m_TimestampMaxVariance = cMillis;
    }

    public void setWellKnownAddresses(Set setWka) {
        this.__m_WellKnownAddresses = setWka;
    }

    private void setWkaMap(Map map) {
        this.__m_WkaMap = map;
    }

    public void shutdown() {
        Cluster cluster = (Cluster)this.getCluster();
        if (cluster.getState() < Cluster.STATE_LEAVING) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Cannot shutdown ClusterService")).append(" without shutting down the Cluster").toString());
        }
        super.shutdown();
    }

    public void stop() {
        Cluster cluster = (Cluster)this.getCluster();
        if (!this.isAcceptingClients() ? false : cluster.getState() < Cluster.STATE_LEAVING) {
            Component._trace("Requested to stop cluster service.", 1);
            cluster.stop();
        } else {
            super.stop();
        }
    }

    public void unregisterServiceJoining(ClusterService$ServiceJoining msg) {
        Component._assert(Thread.currentThread() == this.getThread());
        boolean fRemoved = false;
        LongArray laPending = this.getPendingServiceJoining();
        Iterator iter = laPending.iterator();
        while (iter.hasNext()) {
            if (!msg.equals(iter.next())) continue;
            iter.remove();
            fRemoved = true;
            break;
        }
        Component._assert(fRemoved);
    }

    public boolean validateNewMember(Member memberNew) {
        InetAddress addrNew = memberNew.getAddress();
        int nPortNew = memberNew.getPort();
        MasterMemberSet setMember = this.getClusterMemberSet();
        Iterator iter = setMember.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(!(!(member.getPort() == nPortNew) ? false : member.getAddress().equals(addrNew)) ? false : member.getUid32().equals(memberNew.getUid32()) ^ true)) continue;
            Component._trace(new StringBuilder(String.valueOf("New member uses existing address/port; ")).append("killing the old member: ").append(member).toString(), 3);
            this.doMemberLeft(member);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateNewService(ServiceInfo info, Member member, Continuation continuation, PermissionInfo piRequest) {
        Component._assert(!(info != null) ? false : member != null);
        int nServiceId = info.getServiceId();
        Component._assert(nServiceId > 0);
        Member memberThis = this.getThisMember();
        if (!(member == memberThis)) {
            Grid serviceJoining;
            ClusterService clusterService = this;
            synchronized (clusterService) {
                serviceJoining = this.getService(nServiceId);
            }
            ServiceMemberSet setMember = info.getMemberSet();
            if (serviceJoining != null) {
                Member memberOldest = setMember.getOldestMember();
                if (serviceJoining.getServiceMemberSet() != null) {
                    int nMember = member.getId();
                    Grid$NotifyServiceJoining msg = (Grid$NotifyServiceJoining)serviceJoining.instantiateMessage("NotifyServiceJoining");
                    msg.setNotifyMember(member);
                    msg.setNotifyServiceVersion(setMember.getServiceVersion(nMember));
                    msg.setNotifyServiceJoinTime(setMember.getServiceJoinTime(nMember));
                    msg.setNotifyServiceEndPointName(setMember.getServiceEndPointName(nMember));
                    msg.setNotifyMemberConfigMap(setMember.getMemberConfigMap(nMember));
                    msg.setPermissionInfo(piRequest);
                    msg.addToMember(memberThis);
                    if (continuation != null) {
                        ClusterService$NotifyResponse msgContinue = (ClusterService$NotifyResponse)this.instantiateMessage("NotifyResponse");
                        msgContinue.setService(this);
                        msgContinue.setContinuation(continuation);
                        continuation = null;
                        msg.setContinuationMessage(msgContinue);
                    }
                    serviceJoining.send(msg);
                }
            }
        }
        if (continuation != null) {
            continuation.proceed(null);
        }
    }

    public boolean validateSeniorBroadcast(DiscoveryMessage message, MemberSet setFrom) {
        if (this.isExiting()) {
            return false;
        }
        Member memberFrom = message.getFromMember();
        if (message.isReadError()) {
            if (this.getClusterMemberSet().size() <= 1) {
                this.onMemberRejected(REJECT_VERSION, memberFrom);
                throw new EventDeathException("Version mismatch");
            }
            Component._trace(new StringBuilder(String.valueOf("Detected another cluster senior, running on an incompatible ")).append("protocol at ").append(message.getSourceAddress()).append(" manual intervention may be required").toString(), 1);
            return false;
        }
        if (!(!(message instanceof ClusterService$SeniorMemberHeartbeat) ? false : ((ClusterService$SeniorMemberHeartbeat)message).isWkaEnabled()) ? false : Base.equals(this.getClusterName(), message.getClusterName()) ^ true) {
            return false;
        }
        switch (this.getState()) {
            case 0: 
            case 1: {
                if (!(message instanceof ClusterService$SeniorMemberHeartbeat) ? false : this.isWkaEnabled() ^ ((ClusterService$SeniorMemberHeartbeat)message).isWkaEnabled()) {
                    this.onMemberRejected(REJECT_WKA, memberFrom);
                    throw new EventDeathException("WKA mismatch");
                }
                if (message.getClusterName().equals(this.getClusterName()) ^ true) {
                    this.onMemberRejected(REJECT_CLUSTER_NAME, memberFrom);
                    throw new EventDeathException("Cluster name mismatch");
                }
                this.resetBroadcastCounter(new StringBuilder(String.valueOf("the presence of an existing cluster")).append(" that does not respond to join requests;").append(" this is usually caused by a network layer failure").toString(), message);
                this.addDynamicBroadcast(memberFrom);
            }
            default: {
                return false;
            }
            case 2: 
        }
        MasterMemberSet setMember = this.getClusterMemberSet();
        Member memberThis = setMember.getThisMember();
        Member memberOldest = setMember.getOldestMember();
        if (memberThis == null ? true : memberOldest == null) {
            return false;
        }
        if (memberFrom.equals(memberOldest)) {
            return true;
        }
        UUID uidFrom = memberFrom.getUid32();
        UUID uidThis = memberThis.getUid32();
        Component._assert(uidFrom.equals(uidThis) ^ true);
        if (!(memberThis == memberOldest) ? false : (!(message instanceof ClusterService$SeniorMemberHeartbeat) ? false : ((ClusterService$SeniorMemberHeartbeat)message).isWkaEnabled())) {
            if (this.isWkaEnabled()) {
                this.addDynamicBroadcast(memberFrom);
            } else {
                ClusterService$SeniorMemberHeartbeat msg = (ClusterService$SeniorMemberHeartbeat)this.instantiateMessage("SeniorMemberHeartbeat");
                msg.setToMember(memberFrom);
                msg.setLastReceivedMillis(this.calcTimestamp(memberThis.getLastIncomingMillis()));
                msg.setMemberSet(setMember);
                msg.setWkaEnabled(this.isWkaEnabled());
                msg.setLastJoinTime(setMember.getLastJoinTime());
                this.send(msg);
            }
        }
        long ldtCurrent = Base.getSafeTimeMillis();
        long cTimeout = this.getDeliveryTimeoutMillis();
        long cHeartbeat = this.getHeartbeatDelay();
        Member memberDead = setMember.findDeadMember(memberFrom);
        if (memberDead != null) {
            Component._assert(memberDead.isDead());
            this.setMembershipReopen(ldtCurrent + cTimeout / (long)4);
            if (memberDead.isZombie() ^ true) {
                Component._trace(new StringBuilder(String.valueOf("The member formerly known as ")).append(memberDead).append(" has been forcefully evicted from the cluster, but continues").append(" to emit a cluster heartbeat; henceforth, the member will be").append(" shunned and its messages will be ignored.").toString(), 2);
                memberDead.declareZombie();
                return false;
            }
            if (!(ldtCurrent > memberDead.getTimestamp() + cTimeout) ? false : (memberThis == memberOldest ? true : this.isWellKnown(memberDead) ^ true)) {
                memberDead.declareZombie();
                this.setLastPanicUid(null);
            } else {
                return false;
            }
        }
        boolean fPanicActivated = uidFrom.equals(this.getLastPanicUid());
        if (memberThis == memberOldest) {
            if (setFrom == null) {
                return false;
            }
            int cSizeThis = setMember.size();
            int cSizeFrom = setFrom.size();
            if (!(!(setMember.getMember(uidFrom) != null) ? false : cSizeThis - cSizeFrom < cSizeFrom) ? false : setMember.containsAll((Collection)setFrom)) {
                Component._trace(new StringBuilder(String.valueOf("This senior ")).append(memberThis).append(" appears to have been disconnected from other nodes due to a long").append(" period of inactivity and the seniority has been assumed by the ").append(memberFrom).append("; stopping cluster service.").toString(), 1);
                this.onStopRunning();
                return false;
            }
            if (fPanicActivated ^ true) {
                this.setMembershipReopen(ldtCurrent + (long)4 * cHeartbeat);
            }
            if (cSizeThis == 1 ? true : cSizeFrom == 1) {
                boolean fStop;
                if (cSizeThis > 1) {
                    fStop = false;
                } else if (cSizeFrom > 1) {
                    fStop = true;
                } else {
                    boolean bl = fStop = uidThis.compareTo(uidFrom) > 0;
                }
                if (fStop) {
                    Component._trace(new StringBuilder(String.valueOf("This senior ")).append(memberThis).append(" appears to have been disconnected from another senior ").append(memberFrom).append("; stopping cluster service.").toString(), 1);
                    this.onStopRunning();
                } else {
                    long ldtWarning = this.getLastInterminableWarningMillis();
                    if (ldtCurrent > ldtWarning + cTimeout) {
                        if (ldtWarning > 0L) {
                            String sCause = cSizeThis == 1 ? "younger that this member" : "the only member of its cluster";
                            Component._trace(new StringBuilder(String.valueOf("This senior ")).append(memberThis).append(" appears to have been disconnected from another senior ").append(memberFrom).append(", which is ").append(sCause).append(", but did not respond to any of the termination requests").append("; manual intervention may be necessary to stop that process.").toString(), 2);
                            this.setLastPanicUid(uidFrom);
                        }
                        this.setLastInterminableWarningMillis(ldtCurrent);
                    }
                }
                return false;
            }
            if (cSizeThis < cSizeFrom ? true : (!(cSizeThis == cSizeFrom) ? false : uidThis.compareTo(uidFrom) > 0)) {
                return false;
            }
            if (fPanicActivated ^ true) {
                Component._trace(new StringBuilder(String.valueOf("An existence of a cluster island with senior ")).append(memberFrom).append(" containing ").append(cSizeFrom).append(" nodes have been detected.").append(" Since this ").append(memberThis).append(" is the senior of ").append(cSizeThis > cSizeFrom ? "a larger" : "an older").append(" cluster island, the panic protocol is being activated to stop the").append(" other island's senior and all junior nodes that belong to it.").toString(), 2);
                this.setLastPanicUid(uidFrom);
                ClusterService$SeniorMemberPanic msg = (ClusterService$SeniorMemberPanic)this.instantiateMessage("SeniorMemberPanic");
                MemberSet setTo = new MemberSet();
                setTo.addAll((Collection)setMember);
                setTo.remove(memberThis);
                msg.setCulpritMember(memberFrom);
                msg.setToMemberSet(setTo);
                this.send(msg);
            }
        } else if (fPanicActivated ^ true) {
            this.setLastPanicUid(uidFrom);
            Component._trace(new StringBuilder(String.valueOf("Notifying the senior ")).append(memberOldest).append(" of an unexpected cluster").append(" heartbeat from ").append(memberDead == null ? "" : "departed ").append(memberFrom).toString(), 2);
            ClusterService$SeniorMemberPanic msg = (ClusterService$SeniorMemberPanic)this.instantiateMessage("SeniorMemberPanic");
            msg.setCulpritMember(memberFrom);
            msg.addToMember(memberOldest);
            this.send(msg);
        }
        return false;
    }

    protected boolean verifyMemberLeft(Member memberSuspect, MessagePacket packet) {
        if (this.isRunning() ^ true) {
            return false;
        }
        if (memberSuspect == null) {
            return true;
        }
        MasterMemberSet setMembers = this.getClusterMemberSet();
        int cMembers = ((MemberSet)setMembers).size();
        if (!(packet != null) ? false : this.isHeuristicallyDead(memberSuspect) ^ true) {
            Set setSlow = this.getSlowMembers();
            if (setSlow == null ? true : setSlow.contains(memberSuspect) ^ true) {
                this.verifyMemberSlow(memberSuspect, packet);
                Component._trace(new StringBuilder(String.valueOf("This member is running extremely slowly and may endanger ")).append("the rest of the cluster. Marking this member as suspect.").toString(), 1);
                this.onMembersTimedOut(Collections.singleton(this.getThisMember()));
                return false;
            }
            int cSlow = setSlow.size();
            int iVote = this.compareImportance(memberSuspect);
            if (iVote > 0 ? true : (!(iVote == 0) ? false : cSlow == 1)) {
                if (memberSuspect.isTimedOut() ^ true) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Timeout while delivering a packet");
                    if (cSlow == 1) {
                        sb.append("to ").append(this.getMemberStatsDescription(memberSuspect)).append("; the member appears to be alive, but exhibits long periods of unresponsiveness ");
                    } else {
                        sb.append(" to a lower priority ").append(this.getMemberStatsDescription(memberSuspect));
                    }
                    sb.append(". Marking Member ").append(memberSuspect.getId()).append(" as suspect.");
                    Component._trace(sb.toString(), 2);
                }
                return true;
            }
        }
        if (!memberSuspect.isDeaf()) {
            if (memberSuspect.isDead()) {
                return true;
            }
            MemberSet setWitness = this.getWitnessMemberSet(memberSuspect);
            if (setWitness == null) {
                if (this.getThisMember().isTimedOut() ^ true) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("This node appears to have become disconnected from the rest of the cluster containing ").append(cMembers - 1).append(" nodes. All departure confirmation requests went unanswered.");
                    Component._trace(sb.toString(), 1);
                }
                this.onMembersTimedOut(Collections.singleton(this.getThisMember()));
                return false;
            }
            memberSuspect.setDeaf(true);
            StringBuffer sb = new StringBuffer();
            sb.append(new StringBuilder(String.valueOf("Timeout while delivering a ")).append(packet == null ? "message" : "packet").toString());
            if (!(packet != null) ? false : Component._isTraceEnabled(6)) {
                sb.append(' ').append(packet);
            }
            sb.append("; requesting time-out confirmation for ").append(this.getMemberStatsDescription(memberSuspect)).append("\nby ").append(setWitness);
            Component._trace(sb.toString(), 2);
            ClusterService$WitnessRequest msg = (ClusterService$WitnessRequest)this.instantiateMessage("WitnessRequest");
            msg.setToMemberSet(setWitness);
            msg.setMemberUUID(memberSuspect.getUid32());
            this.send(msg);
        }
        return false;
    }

    public void verifyMemberSlow(Member memberSlow, MessagePacket packet) {
        block8: {
            int cTimeoutMillis;
            long lLastInMillis;
            if (this.isRunning() ^ true ? true : memberSlow == null) {
                return;
            }
            long lCurrentMillis = Base.getSafeTimeMillis();
            if (!(lCurrentMillis - (lLastInMillis = memberSlow.getLastIncomingMillis()) < (long)((cTimeoutMillis = this.getDeliveryTimeoutMillis()) >> 1))) break block8;
            if (this.isSlow(memberSlow) ^ true) {
                long lFirstSentMillis = packet.getResendTimeout() - (long)cTimeoutMillis;
                long lFailedAckMillis = lCurrentMillis - lFirstSentMillis;
                long cRecentMillis = lCurrentMillis - lLastInMillis;
                int cbPacket = packet.getLength();
                DependentMemberSet setTo = packet.getToMemberSet();
                boolean fMulticast = !(!(setTo != null) ? false : this.isWkaEnabled() ^ true) ? false : ((Cluster)this.getCluster()).getPublisher().isMulticast(((MemberSet)setTo).size());
                StringBuffer sb = new StringBuffer();
                sb.append("A potential communication problem has been detected. ").append("A packet has failed to be acknowledged");
                if (!(setTo != null) ? false : ((MemberSet)setTo).size() > 1) {
                    sb.append(" by ").append(((MemberSet)setTo).size()).append(" members");
                }
                sb.append(" after ").append(lFailedAckMillis / (long)1000).append(" seconds, although other packets were acknowledged by ").append(this.getMemberStatsDescription(memberSlow)).append(" to this ").append(this.getThisMember()).append(" as recently as ").append(cRecentMillis / (long)1000).append(" seconds ago. ");
                if (fMulticast ? true : cbPacket > 1468) {
                    if (fMulticast) {
                        sb.append("It is possible this was caused by a multicast failure");
                        if (InetAddresses.PreferIPv4Stack ^ true) {
                            sb.append("; you may need to run the JVM with the system property ").append("\"-Djava.net.preferIPv4Stack=true\"");
                        }
                        sb.append(". ");
                    }
                    if (cbPacket > 1468) {
                        sb.append("It is possible that the packet size greater than ").append(cbPacket).append(" is responsible; for example, some network ").append("equipment cannot handle packets larger than 1472 bytes (IPv4) or 1468 bytes (IPv6). ").append("Use the 'ping' command with the <size> option to verify successful").append(" delivery of specifically sized packets.");
                    }
                    sb.append(" Other possible");
                } else {
                    sb.append(" Possible");
                }
                sb.append(" causes include network failure, poor thread scheduling (see FAQ if running on Windows), ").append("an extremely overloaded server, a server that is attempting to run its ").append("processes using swap space, and unreasonably lengthy GC times.");
                Component._trace(sb.toString(), 2);
            }
            memberSlow.setLastSlowMillis(lCurrentMillis);
        }
    }
}

