/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.internal.Platform;
import com.oracle.coherence.persistence.PersistenceManager;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionRecoverRequest$Poll;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionRecoverRequest$RecoverJob;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.internal.PartitionRecoverInfo;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class PartitionedService$PartitionRecoverRequest
extends RequestMessage {
    private String[] __m_GUIDs;
    private transient Map __m_MapAssigned;
    private PartitionSet __m_PartsAssign;
    private transient PartitionSet __m_PartsAssigned;
    private transient PartitionSet __m_PartsLost;
    private PartitionSet __m_PartsRecover;
    private PartitionSet __m_PartsRecovered;
    private AtomicInteger __m_RecoverJobs;
    private String __m_SnapshotToRecover;
    private static ListMap __mapChildren;

    static {
        PartitionedService$PartitionRecoverRequest.__initStatic();
    }

    public PartitionedService$PartitionRecoverRequest() {
        this(null, null, true);
    }

    public PartitionedService$PartitionRecoverRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageType(43);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Poll", PartitionedService$PartitionRecoverRequest$Poll.get_CLASS());
        Class clazz2 = __mapChildren.put("RecoverJob", PartitionedService$PartitionRecoverRequest$RecoverJob.get_CLASS());
    }

    public String[] getGUIDs() {
        return this.__m_GUIDs;
    }

    public Map getMapAssigned() {
        return this.__m_MapAssigned;
    }

    public PartitionSet getPartsAssign() {
        return this.__m_PartsAssign;
    }

    public PartitionSet getPartsAssigned() {
        return this.__m_PartsAssigned;
    }

    public PartitionSet getPartsLost() {
        return this.__m_PartsLost;
    }

    public PartitionSet getPartsRecover() {
        return this.__m_PartsRecover;
    }

    public PartitionSet getPartsRecovered() {
        return this.__m_PartsRecovered;
    }

    public PersistenceManager getPersistenceManager() {
        String sSnapshot = this.getSnapshotToRecover();
        PartitionedService$PersistenceControl ctrlPersistence = ((PartitionedService)this.getService()).getPersistenceControl();
        return sSnapshot == null ? ctrlPersistence.getActiveManager() : ctrlPersistence.openSnapshot(sSnapshot);
    }

    public AtomicInteger getRecoverJobs() {
        return this.__m_RecoverJobs;
    }

    public String getSnapshotToRecover() {
        return this.__m_SnapshotToRecover;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionRecoverRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PartitionedService$PartitionRecoverRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    protected Poll instantiatePoll() {
        return (Poll)this._newChild("Poll");
    }

    public void onReceived() {
        this.scheduleRecoveryJobs();
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        int cGUID = input.readInt();
        String[] asGUID = new String[cGUID];
        int i = 0;
        while (i < cGUID) {
            asGUID[i] = input.readUTF();
            ++i;
        }
        this.setGUIDs(asGUID);
        PartitionSet partsAssign = new PartitionSet();
        partsAssign.readExternal(input);
        this.setPartsAssign(partsAssign);
        if (input.readBoolean()) {
            this.setSnapshotToRecover(input.readUTF());
        }
    }

    public void scheduleRecoveryJobs() {
        PartitionedService service = (PartitionedService)this.getService();
        String[] asGUIDs = this.getGUIDs();
        int cGUIDs = asGUIDs.length;
        int cFair = Config.getInteger("coherence.distributed.persistence.recover.threads", Platform.getPlatform().getFairShareProcessors() + 2);
        int cBatch = cGUIDs / cFair + 1;
        SparseArray<PartitionedService$PartitionRecoverRequest$RecoverJob> laJob = new SparseArray<PartitionedService$PartitionRecoverRequest$RecoverJob>();
        Map mapUpdate = service.lockForRecovery(this);
        PartitionRecoverInfo info = new PartitionRecoverInfo(this, mapUpdate, new ArrayList(), this.getPersistenceManager(), service.instantiatePartitionSet(false), service.instantiatePartitionSet(false));
        int i = 0;
        while (i < cGUIDs) {
            String sGUID = asGUIDs[i];
            int nPartition = GUIDHelper.getPartition(sGUID);
            int nBatch = i / cBatch;
            PartitionedService$PartitionRecoverRequest$RecoverJob job = (PartitionedService$PartitionRecoverRequest$RecoverJob)laJob.get(nBatch);
            if (job == null) {
                job = new PartitionedService$PartitionRecoverRequest$RecoverJob();
                job.setListGUID(new ArrayList());
                job.setService(service);
                job.setRecoverInfo(info);
                laJob.set(nBatch, job);
            }
            job.getListGUID().add(sGUID);
            ++i;
        }
        if (laJob.isEmpty()) {
            PartitionedService$PartitionRecoverRequest$RecoverJob job = new PartitionedService$PartitionRecoverRequest$RecoverJob();
            job.setListGUID(Collections.emptyList());
            job.setService(service);
            job.setRecoverInfo(info);
            laJob.set(0, job);
        }
        this.setRecoverJobs(new AtomicInteger(laJob.getSize()));
        DaemonPool pool = service.getDaemonPool();
        Iterator iter = laJob.iterator();
        while (iter.hasNext()) {
            PartitionedService$PartitionRecoverRequest$RecoverJob job = (PartitionedService$PartitionRecoverRequest$RecoverJob)iter.next();
            pool.add(job);
        }
    }

    public void setGUIDs(String[] asGUID) {
        this.__m_GUIDs = asGUID;
    }

    public void setMapAssigned(Map mapAssigned) {
        this.__m_MapAssigned = mapAssigned;
    }

    public void setPartsAssign(PartitionSet setRecovered) {
        this.__m_PartsAssign = setRecovered;
    }

    public void setPartsAssigned(PartitionSet setAssigned) {
        this.__m_PartsAssigned = setAssigned;
    }

    public void setPartsLost(PartitionSet setAssigned) {
        this.__m_PartsLost = setAssigned;
    }

    public void setPartsRecover(PartitionSet setRecovered) {
        this.__m_PartsRecover = setRecovered;
    }

    public void setPartsRecovered(PartitionSet setRecovered) {
        this.__m_PartsRecovered = setRecovered;
    }

    public void setRecoverJobs(AtomicInteger atomicJobs) {
        this.__m_RecoverJobs = atomicJobs;
    }

    public void setSnapshotToRecover(String sSnapshot) {
        this.__m_SnapshotToRecover = sSnapshot;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        String[] asGUID = this.getGUIDs();
        int cGUID = asGUID.length;
        output.writeInt(cGUID);
        int i = 0;
        while (i < cGUID) {
            output.writeUTF(asGUID[i]);
            ++i;
        }
        this.getPartsAssign().writeExternal(output);
        String sSnapshot = this.getSnapshotToRecover();
        if (sSnapshot == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeUTF(sSnapshot);
        }
    }
}

