/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.message.responseMessage.SimpleResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.util.concurrent.atomic.AtomicInteger;

public class PartitionedService$PersistenceControl$SnapshotBuilder
extends Component
implements Continuation,
PriorityTask,
Runnable {
    private PersistenceManager __m_Manager;
    private int __m_Partition;
    private boolean __m_PartitionLocked;
    private PartitionSet __m_Partitions;
    private volatile PartitionSet __m_RejectedPartitions;
    private Grid$Response __m_Response;

    public PartitionedService$PersistenceControl$SnapshotBuilder() {
        this(null, null, true);
    }

    public PartitionedService$PersistenceControl$SnapshotBuilder(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setPartition(-1);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void build(int iPart) {
        PartitionedService service = this.getService();
        boolean fSuspended = service.isSuspendedFully();
        boolean fLocked = false;
        while ((iPart = this.getPartitions().next(iPart)) >= 0) {
            if (fSuspended ? true : this.lock(iPart)) break;
            if (fSuspended ^ true) {
                this.onPartitionFailed(iPart, null);
            }
            ++iPart;
        }
        if (iPart == -1) {
            this.setPartition(Integer.MIN_VALUE);
            this.onSnapshotCompleted();
            return;
        }
        Component._assert(fSuspended ? true : fLocked);
        this.setPartitionLocked(fLocked);
        boolean fStart = this.getPartition() == -1;
        this.setPartition(iPart);
        if (fStart) {
            service.getDaemonPool().add(this);
        }
    }

    protected String buildGUID(int iPart) {
        PartitionedService service = this.getService();
        Member memberThis = service.getThisMember();
        return GUIDHelper.generateGUID(iPart, service.getOwnershipVersion(iPart), service.getServiceMemberSet().getServiceJoinTime(memberThis.getId()), memberThis);
    }

    public long getExecutionTimeoutMillis() {
        return 0L;
    }

    public PersistenceManager getManager() {
        return this.__m_Manager;
    }

    public int getPartition() {
        return this.__m_Partition;
    }

    public PartitionSet getPartitions() {
        return this.__m_Partitions;
    }

    public PartitionSet getRejectedPartitions() {
        return this.__m_RejectedPartitions;
    }

    public long getRequestTimeoutMillis() {
        return 0L;
    }

    public Grid$Response getResponse() {
        return this.__m_Response;
    }

    public int getSchedulingPriority() {
        return PriorityTask.SCHEDULE_IMMEDIATE;
    }

    protected PartitionedService getService() {
        return (PartitionedService)this.get_Module();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PersistenceControl$SnapshotBuilder".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedService$PersistenceControl$SnapshotBuilder();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    protected boolean isPartitionLocked() {
        return this.__m_PartitionLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lock(int iPart) {
        PartitionedService service = this.getService();
        PartitionedService$PartitionControl ctrlPart = service.getPartitionControl(iPart);
        long cMillis = service.getDistributionContendMillis();
        boolean fLocked = !(ctrlPart != null) ? false : ctrlPart.lock(cMillis, PartitionedService$PartitionControl.LOCK_PERSISTENCE);
        AtomicInteger atomicTasks = ctrlPart.getPersistenceTasks();
        if (!fLocked ? false : atomicTasks.get() > 0) {
            try {
                AtomicInteger atomicInteger = atomicTasks;
                synchronized (atomicInteger) {
                    Blocking.wait(atomicTasks, cMillis);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (atomicTasks.get() > 0) {
                ctrlPart.unlock();
                fLocked = false;
            }
        }
        return fLocked;
    }

    public void onPartitionFailed(int iPart, Throwable tFailure) {
        Grid$Response msgResponse = this.getResponse();
        PartitionSet partsRejected = this.getRejectedPartitions();
        if (partsRejected == null) {
            msgResponse.setResult(SimpleResponse.RESULT_FAILURE);
            partsRejected = this.getService().instantiatePartitionSet(false);
        }
        String sMsg = "Failed to create snapshot of partition";
        if (iPart != -1) {
            partsRejected.add(iPart);
            sMsg = new StringBuilder(String.valueOf(sMsg)).append(new StringBuilder(String.valueOf(" ")).append(iPart).toString()).toString();
            this.setRejectedPartitions(partsRejected);
        }
        if (tFailure == null) {
            Component._trace(new StringBuilder(String.valueOf(sMsg)).append(" due to a failure to lock").toString(), 6);
        } else {
            Component._trace(new StringBuilder(String.valueOf(sMsg)).append(" due to: ").append(tFailure).append('\n').append(Base.getStackTrace(tFailure)).toString(), 2);
        }
    }

    protected void onPartitionsFailed(PartitionSet partsFailed, Throwable tFailure) {
        if (partsFailed.isEmpty()) {
            return;
        }
        Grid$Response msgResponse = this.getResponse();
        PartitionSet partsRejected = this.getRejectedPartitions();
        if (partsRejected == null) {
            msgResponse.setResult(SimpleResponse.RESULT_FAILURE);
            partsRejected = this.getService().instantiatePartitionSet(false);
        }
        partsRejected.add(partsFailed);
        String sMsg = new StringBuilder(String.valueOf("Failed to create snapshot of partitions ")).append(partsFailed).append(" due to: ").append(tFailure).append('\n').append(Base.getStackTrace(tFailure)).toString();
        this.setRejectedPartitions(partsRejected);
        Component._trace(sMsg, 2);
    }

    protected void onSnapshotCompleted() {
        Grid$Response msgResponse = this.getResponse();
        PartitionSet partsCompleted = this.getPartitions();
        PartitionSet partsRejected = this.getRejectedPartitions();
        if (partsRejected != null) {
            partsCompleted.remove(partsRejected);
        }
        msgResponse.setValue(partsCompleted);
        this.getManager().release();
        this.getService().send(msgResponse);
    }

    public void proceed(Object o) {
        int iPart;
        Throwable t = null;
        if (o instanceof Integer) {
            iPart = (Integer)o;
        } else {
            t = (Throwable)o;
            iPart = this.getPartition();
        }
        if (this.isPartitionLocked()) {
            this.getService().getPartitionControl(iPart).unlock();
        }
        if (t == null) {
            this.build(iPart + 1);
        } else {
            PartitionSet parts = this.getPartitions();
            PartitionSet partsFailed = this.getService().instantiatePartitionSet(false);
            while (iPart >= 0) {
                partsFailed.add(iPart);
                iPart = parts.next(iPart + 1);
            }
            this.onPartitionsFailed(partsFailed, t);
        }
    }

    public void removeTransientCaches(PersistentStore store) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int iPartPrev = -1;
        while (true) {
            int iPart;
            PartitionedService$PersistenceControl$SnapshotBuilder partitionedService$PersistenceControl$SnapshotBuilder = this;
            synchronized (partitionedService$PersistenceControl$SnapshotBuilder) {
                while ((iPart = this.getPartition()) < 0 ? true : iPartPrev == iPart) {
                    if (iPart == Integer.MIN_VALUE) return;
                    boolean bl = false;
                    if (bl) {
                        return;
                    }
                    try {
                        Blocking.wait(this, 1000L);
                    }
                    catch (InterruptedException e) {
                        this.getService().getContinuations().thenOnServiceThread(this).proceed(e);
                    }
                }
            }
            this.snapshotStore(iPart);
            iPartPrev = iPart;
        }
    }

    public void runCanceled(boolean fAbandoned) {
    }

    public void setManager(PersistenceManager manager) {
        if (this.getManager() != null) {
            throw new IllegalStateException("The PersistenceManager cannot be reset.");
        }
        this.__m_Manager = manager;
    }

    public synchronized void setPartition(int nPartition) {
        this.__m_Partition = nPartition;
        this.notify();
    }

    protected void setPartitionLocked(boolean fLocked) {
        this.__m_PartitionLocked = fLocked;
    }

    public void setPartitions(PartitionSet setPartitions) {
        this.__m_Partitions = setPartitions;
    }

    public void setRejectedPartitions(PartitionSet setPartitions) {
        this.__m_RejectedPartitions = setPartitions;
    }

    public void setResponse(Grid$Response response) {
        this.__m_Response = response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void snapshotStore(int iPart) {
        boolean bl;
        PersistenceManager mgrActive = ((PartitionedService$PersistenceControl)this.get_Parent()).getActiveManager();
        PersistenceManager mgrSnapshot = this.getManager();
        PersistentStore store = null;
        Object oToken = null;
        PartitionedService service = this.getService();
        Throwable eFailure = null;
        String sGUID = null;
        try {
            try {
                GuardSupport.heartbeat();
                if (mgrActive == null) {
                    sGUID = this.buildGUID(iPart);
                    store = mgrSnapshot.open(sGUID, null);
                    oToken = store.begin();
                    service.snapshotPartition(iPart, store, oToken);
                    store.commit(oToken);
                } else {
                    PersistentStore storeFrom = service.getPartitionControl(iPart).getPersistentStore();
                    sGUID = storeFrom.getId();
                    store = mgrSnapshot.open(sGUID, storeFrom);
                    this.removeTransientCaches(store);
                }
                Component._trace(new StringBuilder(String.valueOf("Created snapshot of partition ")).append(iPart).toString(), 3);
            }
            catch (Throwable t) {
                eFailure = t;
                if (store != null) {
                    store.abort(oToken);
                }
                this.onPartitionFailed(iPart, t);
            }
            Object var10_12 = null;
            bl = store != null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (store != null) {
                mgrSnapshot.close(sGUID);
            }
            this.getService().getContinuations().thenOnServiceThread(this).proceed(iPart);
            throw throwable;
        }
        if (bl) {
            mgrSnapshot.close(sGUID);
        }
        this.getService().getContinuations().thenOnServiceThread(this).proceed(iPart);
    }
}

