/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$SnapshotArchiveRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$SnapshotListRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$SnapshotRequest;
import com.tangosol.net.Member;
import com.tangosol.net.management.AnnotatedStandardEmitterMBean;
import com.tangosol.net.management.Registry;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.persistence.PersistenceManagerMBean;
import com.tangosol.persistence.Snapshot;
import com.tangosol.persistence.SnapshotArchiver;
import com.tangosol.util.Base;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PartitionedService$PersistenceControl$SnapshotController
extends Component
implements PersistenceManagerMBean {
    public static final int SNAPSHOT_NAMES_EXPIRE = 5000;
    public static final int STATE_ACTIVE_RECOVERY = 6;
    public static final int STATE_IDLE = 0;
    public static final int STATE_RECOVER_RECOVERING = 2;
    public static final int STATE_SNAPSHOT_ARCHIVING = 4;
    public static final int STATE_SNAPSHOT_BUILDING = 1;
    public static final int STATE_SNAPSHOT_REMOVING = 3;
    public static final int STATE_SNAPSHOT_RETRIEVING = 5;
    private boolean __m_ResumeOnCompletion;
    private String __m_SnapshotName;
    private String[] __m_SnapshotNames;
    private volatile long __m_SnapshotNamesExpire;
    private volatile int __m_State;
    private static /* synthetic */ Class __sf0;

    public PartitionedService$PersistenceControl$SnapshotController() {
        this(null, null, true);
    }

    public PartitionedService$PersistenceControl$SnapshotController(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.persistence.PersistenceManagerMBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void _imports() {
    }

    protected void addNotification(String sNotificationType, String sMessage, String sUserData) {
        Registry registry = this.getService().getCluster().getManagement();
        if (registry != null) {
            this.getService().dispatchNotification(registry.ensureGlobalName(this.getMBeanName()), sNotificationType, sMessage, sUserData);
        }
    }

    public synchronized void archiveSnapshot(String sSnapshot) {
        this.ensureArchiveReady();
        if (this.hasSnapshot(sSnapshot) ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("A snapshot named \"")).append(sSnapshot).append("\" does not exist").toString());
        }
        if (this.hasArchivedSnapshot(sSnapshot)) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("The archived snapshot \"")).append(sSnapshot).append("\" already exists").toString());
        }
        Map<Integer, String[]> mapStores = this.getSnapshotStores(sSnapshot);
        PartitionedService service = this.getService();
        mapStores = GUIDHelper.assignStores((Map<Integer, Object[]>)mapStores, service.getPartitionCount());
        this.setSnapshotName(sSnapshot);
        ActualMemberSet setMembers = new ActualMemberSet();
        Iterator iter = service.getOwnershipMemberSet().iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            Object[] aoStores = mapStores.get(member.getId());
            if (!(!(aoStores != null) ? false : aoStores.length > 0)) continue;
            ((MemberSet)setMembers).add(member);
        }
        PartitionedService$SnapshotArchiveRequest msgArchiveRequest = (PartitionedService$SnapshotArchiveRequest)service.instantiateMessage("SnapshotArchiveRequest");
        msgArchiveRequest.setSnapshotName(sSnapshot);
        msgArchiveRequest.setToMemberSet(setMembers);
        msgArchiveRequest.setArchive(true);
        msgArchiveRequest.setStores(mapStores);
        service.send(msgArchiveRequest);
        this.setState(STATE_SNAPSHOT_ARCHIVING);
        this.addNotification(PersistenceManagerMBean.ARCHIVE_SNAPSHOT_BEGIN, this.getOperationStatus(), "");
    }

    protected void checkResume() {
        if (this.isResumeOnCompletion()) {
            PartitionedService service = this.getService();
            String sServiceName = service.getServiceName();
            Component._trace(new StringBuilder(String.valueOf("Automatically resuming service ")).append(sServiceName).toString(), 3);
            CachePersistenceHelper.resumeService(service.getCluster(), sServiceName);
            this.setResumeOnCompletion(false);
        }
    }

    public MemberSet combineMembersLeft(MemberSet setMembersFailed, MemberSet setMembersLeft) {
        if (setMembersFailed == null) {
            return setMembersLeft;
        }
        if (setMembersLeft.isEmpty() ^ true) {
            setMembersFailed.addAll((Collection)setMembersLeft);
        }
        return setMembersFailed;
    }

    public synchronized void createSnapshot(String sSnapshot) {
        MemberSet setOwners;
        boolean fPartitioned;
        this.ensureReady(false);
        if (this.hasSnapshot(sSnapshot)) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("A snapshot named \"")).append(sSnapshot).append("\" already exists").toString());
        }
        PartitionedService service = this.getService();
        boolean bl = fPartitioned = !service.isVersionCompatible(setOwners = service.getOwnershipMemberSet(), 12, 2, 1, 2, 0) ? false : service.isSuspendedFully() ^ true;
        if (fPartitioned ^ true) {
            this.ensureSuspended();
        }
        this.setSnapshotName(sSnapshot);
        this.setState(STATE_SNAPSHOT_BUILDING);
        PartitionedService$SnapshotRequest msgRequest = (PartitionedService$SnapshotRequest)service.instantiateMessage("SnapshotRequest");
        msgRequest.setSnapshotName(sSnapshot);
        msgRequest.setToMemberSet(setOwners);
        msgRequest.setCreate(true);
        if (fPartitioned) {
            msgRequest.setCompleted(service.instantiatePartitionSet(false));
            msgRequest.setRequestMask(service.instantiatePartitionSet(true));
        }
        service.send(msgRequest);
        this.addNotification(PersistenceManagerMBean.CREATE_SNAPSHOT_BEGIN, this.getOperationStatus(), "");
    }

    protected void ensureArchiveReady() {
        this.ensureReady(false);
        if (this.getPersistenceControl().getSnapshotArchiver() == null) {
            throw new IllegalArgumentException("No archiver is defined for this service");
        }
    }

    protected void ensureReady(boolean fSuspend) {
        PartitionedService service = this.getService();
        if (service == null ? true : service.isRunning() ^ true) {
            throw new IllegalStateException("There are no remaining storage-enabled members of the service");
        }
        Component._assert(service.getOwnershipSenior() == service.getThisMember());
        if (this.getPersistenceControl().isValid() ^ true) {
            throw new IllegalStateException("Persistence has not been configured on the ownership senior");
        }
        if (fSuspend && service.isSuspended() ^ true) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("The service must be suspended; ")).append("see the \"suspendService\" operation on the ClusterMBean").toString());
        }
        if (this.isIdle() ^ true) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Request is pending: ")).append(this.getOperationStatus()).toString());
        }
    }

    protected void ensureSuspended() {
        PartitionedService service = this.getService();
        if (service.isSuspended()) {
            this.setResumeOnCompletion(false);
        } else {
            String sServiceName = service.getServiceName();
            Component._trace(new StringBuilder(String.valueOf("Automatically suspending service ")).append(sServiceName).toString(), 3);
            ((Cluster)service.getCluster()).suspendService(sServiceName, true);
            this.setResumeOnCompletion(true);
        }
    }

    public void forceRecovery() {
        this.getPersistenceControl().setForceRecovery(true);
    }

    public int getCoordinatorId() {
        PartitionedService service = this.getService();
        return (service == null ? true : service.isRunning() ^ true) ? -1 : service.getThisMember().getId();
    }

    public String getGUIDFromPartition(int nPartition, String[] asStores) {
        int i = 0;
        while (i < asStores.length) {
            if (GUIDHelper.getPartition(asStores[i]) == nPartition) {
                return asStores[i];
            }
            ++i;
        }
        return null;
    }

    public String getMBeanName() {
        return CachePersistenceHelper.getMBeanName(this.getService().getServiceName());
    }

    public String getOperationStatus() {
        PartitionedService service = this.getService();
        if (service == null ? true : service.isRunning() ^ true) {
            return "n/a";
        }
        switch (this.getState()) {
            case 0: {
                return "Idle";
            }
            case 1: {
                return new StringBuilder(String.valueOf("Building snapshot \"")).append(this.getSnapshotName()).append('\"').toString();
            }
            case 2: {
                return new StringBuilder(String.valueOf("Recovering snapshot \"")).append(this.getSnapshotName()).append('\"').toString();
            }
            case 3: {
                return new StringBuilder(String.valueOf("Removing snapshot \"")).append(this.getSnapshotName()).append('\"').toString();
            }
            case 4: {
                return new StringBuilder(String.valueOf("Archiving snapshot \"")).append(this.getSnapshotName()).append('\"').toString();
            }
            case 5: {
                return new StringBuilder(String.valueOf("Retrieving archived snapshot \"")).append(this.getSnapshotName()).append('\"').toString();
            }
            case 6: {
                return "Active recovery in progress";
            }
        }
        throw new IllegalStateException(new StringBuilder(String.valueOf("Invalid state: ")).append(this.getState()).toString());
    }

    protected PartitionedService$PersistenceControl getPersistenceControl() {
        return (PartitionedService$PersistenceControl)this.get_Parent();
    }

    protected PartitionedService getService() {
        return (PartitionedService)this.get_Module();
    }

    public String getSnapshotName() {
        return this.__m_SnapshotName;
    }

    protected String[] getSnapshotNames() {
        return this.__m_SnapshotNames;
    }

    protected long getSnapshotNamesExpire() {
        return this.__m_SnapshotNamesExpire;
    }

    private Map getSnapshotStores(String sSnapshot) {
        PartitionedService service = this.getService();
        PartitionedService$SnapshotListRequest msgRequest = (PartitionedService$SnapshotListRequest)service.instantiateMessage("SnapshotListRequest");
        msgRequest.setToMemberSet(service.getOwnershipMemberSet());
        msgRequest.setSnapshotName(sSnapshot);
        Map mapStores = (Map)service.poll(msgRequest);
        if (mapStores == null ? true : mapStores.size() == 0) {
            throw new IllegalArgumentException("No members returned snapshot store details");
        }
        return mapStores;
    }

    public String[] getSnapshots() {
        PartitionedService service = this.getService();
        if (service == null ? true : service.isRunning() ^ true) {
            return null;
        }
        if (Base.getSafeTimeMillis() < this.getSnapshotNamesExpire() ? true : Thread.currentThread() == service.getThread()) {
            return this.getSnapshotNames();
        }
        PartitionedService$SnapshotListRequest msgRequest = (PartitionedService$SnapshotListRequest)service.instantiateMessage("SnapshotListRequest");
        msgRequest.setToMemberSet(service.getOwnershipMemberSet());
        msgRequest.setSnapshotName(null);
        String[] asNames = (String[])service.poll(msgRequest);
        this.setSnapshotNames(asNames);
        return asNames;
    }

    public int getState() {
        return this.__m_State;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PersistenceControl$SnapshotController".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedService$PersistenceControl$SnapshotController();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    protected boolean hasArchivedSnapshot(String sSnapshot) {
        String[] asSnapshots = this.listArchivedSnapshots();
        int i = 0;
        int c = asSnapshots.length;
        while (i < c) {
            if (sSnapshot.equals(asSnapshots[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean hasSnapshot(String sSnapshot) {
        String[] asSnapshots = this.getSnapshots();
        int i = 0;
        int c = asSnapshots.length;
        while (i < c) {
            if (sSnapshot.equals(asSnapshots[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isIdle() {
        return this.getState() == STATE_IDLE;
    }

    public boolean isResumeOnCompletion() {
        return this.__m_ResumeOnCompletion;
    }

    public String[] listArchivedSnapshotStores(String sSnapshot) {
        if (this.hasArchivedSnapshot(sSnapshot) ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("A snapshot named \"")).append(sSnapshot).append("\" does not exist").toString());
        }
        SnapshotArchiver archiver = this.getPersistenceControl().getSnapshotArchiver();
        return archiver.get(sSnapshot).listStores();
    }

    public String[] listArchivedSnapshots() {
        SnapshotArchiver archiver = this.getPersistenceControl().getSnapshotArchiver();
        if (archiver == null) {
            throw new IllegalArgumentException("No archiver is defined for this service");
        }
        return archiver.list();
    }

    public void onArchiveCompleted(MemberSet setMembersFailed) {
        String sNotificationType;
        String sMessage;
        int nState = this.getState();
        Component._assert(nState == STATE_SNAPSHOT_ARCHIVING ? true : nState == STATE_SNAPSHOT_RETRIEVING);
        String sSnapshot = this.getSnapshotName();
        String sUserData = "";
        boolean fArchive = nState == STATE_SNAPSHOT_ARCHIVING;
        String sDesc = fArchive ? "archive" : "retrieve";
        String sArchived = fArchive ? "" : " archived ";
        String sServiceName = this.getService().getServiceName();
        if (setMembersFailed == null ? true : setMembersFailed.isEmpty()) {
            sMessage = new StringBuilder(String.valueOf("Successfully ")).append(sDesc).append("d ").append(sArchived).append("snapshot \"").append(sSnapshot).append('\"').toString();
            Component._trace(sMessage, 3);
        } else {
            sMessage = new StringBuilder(String.valueOf("Failed to ")).append(sDesc).append(" ").append(sArchived).append("snapshot \"").append(sSnapshot).append('\"').toString();
            sUserData = new StringBuilder(String.valueOf("failed members ")).append(setMembersFailed).toString();
            Component._trace(new StringBuilder(String.valueOf(sMessage)).append(" because of ").append(sUserData).toString(), 2);
        }
        if (fArchive) {
            sNotificationType = PersistenceManagerMBean.ARCHIVE_SNAPSHOT_END;
        } else {
            sNotificationType = PersistenceManagerMBean.RETRIEVE_ARCHIVED_SNAPSHOT_END;
            this.setSnapshotNames(null);
        }
        this.addNotification(sNotificationType, sMessage, sUserData);
        this.reset();
    }

    public void onInit() {
        super.onInit();
        Registry registry = this.getService().getCluster().getManagement();
        if (registry != null) {
            try {
                registry.register(registry.ensureGlobalName(this.getMBeanName()), new AnnotatedStandardEmitterMBean(this, PartitionedService$PersistenceControl$SnapshotController.__sm0()));
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        this.setResumeOnCompletion(this.getPersistenceControl().isResumeOnFailover());
        this.checkResume();
    }

    public void onRecoveryCompleted(String sSnapshot, PartitionSet partsFailed) {
        String sUserData;
        String sMessage;
        if (sSnapshot == null) {
            this.addNotification(PersistenceManagerMBean.RECOVER_END, "Recovery Completed", "");
            this.reset();
            return;
        }
        Component._assert(this.getState() == STATE_RECOVER_RECOVERING);
        if (partsFailed == null ? true : partsFailed.isEmpty()) {
            sMessage = new StringBuilder(String.valueOf("Successfully recovered snapshot \"")).append(sSnapshot).append('\"').toString();
            sUserData = "";
            Component._trace(sMessage, 3);
        } else {
            sMessage = new StringBuilder(String.valueOf("Failed to recover snapshot \"")).append(sSnapshot).append('\"').toString();
            sUserData = new StringBuilder(String.valueOf("failed partitions ")).append(partsFailed).toString();
            Component._trace(new StringBuilder(String.valueOf(sMessage)).append(" because of ").append(sUserData).toString(), 2);
        }
        this.checkResume();
        this.addNotification(PersistenceManagerMBean.RECOVER_END, "Recovery Completed", "");
        this.addNotification(PersistenceManagerMBean.RECOVER_SNAPSHOT_END, sMessage, sUserData);
        this.reset();
    }

    public void onRecoveryStarted(String sSnapshot, PartitionSet partsRecover) {
        if (sSnapshot == null) {
            this.setState(STATE_ACTIVE_RECOVERY);
        }
        this.addNotification(PersistenceManagerMBean.RECOVER_BEGIN, this.getOperationStatus(), new StringBuilder(String.valueOf(partsRecover.cardinality())).append(" partitions to recover").toString());
    }

    public void onSnapshotCompleted(MemberSet setMembersFailed, PartitionSet partsFailed) {
        String sMessage;
        int nState = this.getState();
        Component._assert(nState == STATE_SNAPSHOT_BUILDING ? true : nState == STATE_SNAPSHOT_REMOVING);
        String sSnapshot = this.getSnapshotName();
        String sUserData = "";
        boolean fCreate = nState == STATE_SNAPSHOT_BUILDING;
        String sDesc = fCreate ? "create" : "remove";
        boolean fPartsSuccess = partsFailed == null ? true : partsFailed.isEmpty();
        boolean fMembersSuccess = setMembersFailed == null ? true : setMembersFailed.isEmpty();
        if (!fMembersSuccess ? false : fPartsSuccess) {
            sMessage = new StringBuilder(String.valueOf("Successfully ")).append(sDesc).append("d snapshot \"").append(sSnapshot).append('\"').toString();
            Component._trace(sMessage, 3);
        } else {
            sMessage = new StringBuilder(String.valueOf("Failed to ")).append(sDesc).append(" snapshot \"").append(sSnapshot).append('\"').toString();
            sUserData = new StringBuilder(String.valueOf(sUserData)).append(fPartsSuccess ? "" : new StringBuilder(String.valueOf("failed ")).append(partsFailed).toString()).toString();
            sUserData = new StringBuilder(String.valueOf(sUserData)).append(fMembersSuccess ? "" : new StringBuilder(String.valueOf(fPartsSuccess ? "failed " : " on ")).append(setMembersFailed).toString()).toString();
            Component._trace(new StringBuilder(String.valueOf(sMessage)).append(" because of ").append(sUserData).toString(), 2);
        }
        if (fCreate) {
            this.checkResume();
        }
        this.setSnapshotNames(null);
        this.addNotification(fCreate ? PersistenceManagerMBean.CREATE_SNAPSHOT_END : PersistenceManagerMBean.REMOVE_SNAPSHOT_END, sMessage, sUserData);
        this.reset();
    }

    public synchronized void recoverSnapshot(String sSnapshot) {
        this.ensureReady(false);
        if (this.hasSnapshot(sSnapshot) ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("A snapshot named \"")).append(sSnapshot).append("\" does not exist").toString());
        }
        PartitionedService service = this.getService();
        int cParts = service.getPartitionCount();
        PartitionSet parts = GUIDHelper.getPartitions(this.getSnapshotStores(sSnapshot), cParts);
        if (parts.cardinality() != cParts) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Missing the following partitions to recover snapsot '")).append(sSnapshot).append("': ").append(parts.invert()).toString());
        }
        this.ensureSuspended();
        this.setSnapshotName(sSnapshot);
        this.addNotification(PersistenceManagerMBean.RECOVER_SNAPSHOT_BEGIN, new StringBuilder(String.valueOf("Recovering Snapshot \"")).append(sSnapshot).append('\"').toString(), "");
        this.setState(STATE_RECOVER_RECOVERING);
        service.doOwnershipProtocol(service.getOwnershipMemberSet(), sSnapshot);
    }

    public void release() {
        Registry registry = this.getService().getCluster().getManagement();
        if (registry != null) {
            registry.unregister(registry.ensureGlobalName(this.getMBeanName()));
        }
    }

    public void removeArchivedSnapshot(String sSnapshot) {
        this.ensureArchiveReady();
        if (this.hasArchivedSnapshot(sSnapshot) ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("The archived snapshot \"")).append(sSnapshot).append("\" does not exist").toString());
        }
        SnapshotArchiver archiver = this.getPersistenceControl().getSnapshotArchiver();
        String sServiceName = this.getService().getServiceName();
        Component._trace(new StringBuilder(String.valueOf("Removing archived snapshot \"")).append(sSnapshot).append("\" for service ").append(sServiceName).toString(), 3);
        try {
            this.addNotification(PersistenceManagerMBean.REMOVE_ARCHIVED_SNAPSHOT_BEGIN, new StringBuilder(String.valueOf("Removing archived snapshot \"")).append(sSnapshot).append("\"").toString(), "");
            archiver.remove(sSnapshot);
            Component._trace(new StringBuilder(String.valueOf("Archived snapshot \"")).append(sSnapshot).append("\" removed for service ").append(sServiceName).toString(), 3);
            this.addNotification(PersistenceManagerMBean.REMOVE_ARCHIVED_SNAPSHOT_END, new StringBuilder(String.valueOf("Sucessfully removed archived snapshot \"")).append(sSnapshot).append("\"").toString(), "");
        }
        catch (Exception e) {
            String sStack = Component.getStackTrace(e);
            Component._trace(new StringBuilder(String.valueOf("Unable to remove archived snapshot \"")).append(sSnapshot).append("\"\n").append(sStack).toString(), 2);
            this.addNotification(PersistenceManagerMBean.REMOVE_ARCHIVED_SNAPSHOT_END, new StringBuilder(String.valueOf("Failed to remove archived snapshot \"")).append(sSnapshot).append("\"").toString(), sStack);
        }
    }

    public void removeSnapshot(String sSnapshot) {
        this.ensureReady(false);
        if (this.hasSnapshot(sSnapshot) ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("A snapshot named \"")).append(sSnapshot).append("\" does not exist").toString());
        }
        this.setSnapshotName(sSnapshot);
        this.setState(STATE_SNAPSHOT_REMOVING);
        PartitionedService service = this.getService();
        PartitionedService$SnapshotRequest msgRequest = (PartitionedService$SnapshotRequest)service.instantiateMessage("SnapshotRequest");
        msgRequest.setSnapshotName(sSnapshot);
        msgRequest.setCreate(false);
        msgRequest.setToMemberSet(service.getOwnershipMemberSet());
        service.send(msgRequest);
        this.addNotification(PersistenceManagerMBean.REMOVE_SNAPSHOT_BEGIN, this.getOperationStatus(), "");
    }

    protected void reset() {
        this.setSnapshotName(null);
        this.setState(STATE_IDLE);
    }

    public void retrieveArchivedSnapshot(String sSnapshot) {
        HashSet<String> setStores;
        Snapshot snapshot;
        String[] asStores;
        this.ensureArchiveReady();
        if (this.hasSnapshot(sSnapshot)) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("A local snapshot named \"")).append(sSnapshot).append("\" already exists and ").append("must be removed prior to being retrieved").toString());
        }
        if (this.hasArchivedSnapshot(sSnapshot) ^ true) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("The archived snapshot \"")).append(sSnapshot).append("\" does not exist").toString());
        }
        SnapshotArchiver archiver = this.getPersistenceControl().getSnapshotArchiver();
        PartitionedService service = this.getService();
        int cParts = service.getPartitionCount();
        if (cParts != (asStores = (snapshot = archiver.get(sSnapshot)).listStores()).length) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("The number of archived stores for snapshot ")).append(sSnapshot).append(" is ").append(asStores.length).append(" which does not ").append("match the current service partition count of ").append(cParts).toString());
        }
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        ActualMemberSet setTo = new ActualMemberSet();
        HashMap mapStores = new HashMap();
        int iPart = 0;
        while (iPart < cParts) {
            String sGUID;
            int nMember = service.getPartitionConfig(iPart).getPrimaryOwner();
            Integer NMember = nMember;
            setStores = (HashSet<String>)mapStores.get(NMember);
            if (setStores == null) {
                setStores = new HashSet<String>();
                mapStores.put(NMember, setStores);
                setTo.add(setMembers.getMember(nMember));
            }
            if ((sGUID = this.getGUIDFromPartition(iPart, asStores)) == null) {
                throw new IllegalStateException(new StringBuilder(String.valueOf("Unable to find a GUID for partition ")).append(iPart).append(" in the list of stores for snapshot ").append(sSnapshot).append(". Unable to retrieve").toString());
            }
            setStores.add(sGUID);
            ++iPart;
        }
        HashMap mapConvertedStores = new HashMap();
        Iterator iter = mapStores.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            setStores = (Set)entry.getValue();
            mapConvertedStores.put(entry.getKey(), setStores.toArray(new String[setStores.size()]));
        }
        this.setSnapshotName(sSnapshot);
        PartitionedService$SnapshotArchiveRequest msgArchiveRequest = (PartitionedService$SnapshotArchiveRequest)service.instantiateMessage("SnapshotArchiveRequest");
        msgArchiveRequest.setSnapshotName(sSnapshot);
        msgArchiveRequest.setToMemberSet(setTo);
        msgArchiveRequest.setArchive(false);
        msgArchiveRequest.setStores(mapConvertedStores);
        service.send(msgArchiveRequest);
        this.setState(STATE_SNAPSHOT_RETRIEVING);
        this.addNotification(PersistenceManagerMBean.RETRIEVE_ARCHIVED_SNAPSHOT_BEGIN, this.getOperationStatus(), "");
    }

    protected void setResumeOnCompletion(boolean fResume) {
        this.__m_ResumeOnCompletion = fResume;
    }

    protected void setSnapshotName(String sSnapshot) {
        this.__m_SnapshotName = sSnapshot;
    }

    public void setSnapshotNames(String[] asNames) {
        this.__m_SnapshotNames = asNames;
        this.setSnapshotNamesExpire(asNames == null ? 0L : Base.getSafeTimeMillis() + (long)SNAPSHOT_NAMES_EXPIRE);
    }

    protected void setSnapshotNamesExpire(long ldtExpire) {
        this.__m_SnapshotNamesExpire = ldtExpire;
    }

    protected void setState(int nState) {
        this.__m_State = nState;
    }
}

