/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$BackupAssignment;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$BackupConfirmRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferControl$TransferIterator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferRequest;
import com.tangosol.util.ListMap;
import com.tangosol.util.PrimitiveSparseArray;
import com.tangosol.util.WrapperException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PartitionedService$TransferControl
extends Component {
    private RequestMessage __m_DistributionRequest;
    private Map __m_IncomingTransfers;
    private PrimitiveSparseArray __m_PartitionsOut;
    private Member __m_ToMember;
    private int __m_TransferCountLimit;
    private long __m_TransferSizeLimit;
    private long __m_TransferredBytes;
    private static ListMap __mapChildren;

    static {
        PartitionedService$TransferControl.__initStatic();
    }

    public PartitionedService$TransferControl() {
        this(null, null, true);
    }

    public PartitionedService$TransferControl(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setIncomingTransfers(new HashMap());
            this.setPartitionsOut(new PrimitiveSparseArray());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("TransferIterator", PartitionedService$TransferControl$TransferIterator.get_CLASS());
    }

    public void cancelTransmit(int iPartition) {
    }

    public void finalizeReceive(PartitionedService$TransferRequest msgTransferLast) {
    }

    public void finalizeReceivePartition(int iPartition, List listXferRequests) {
        Iterator iter = listXferRequests.iterator();
        while (iter.hasNext()) {
            PartitionedService$TransferRequest msgTransfer = (PartitionedService$TransferRequest)iter.next();
            if (!msgTransfer.isLastInPartition()) continue;
            this.finalizeReceive(msgTransfer);
        }
    }

    protected void finalizeTransmit(PartitionedService$TransferRequest msgTransferLast) {
        this.setTransferState(msgTransferLast.getPartition(), PartitionedService$PartitionControl.XFER_SENT);
    }

    public RequestMessage getDistributionRequest() {
        return this.__m_DistributionRequest;
    }

    public Map getIncomingTransfers() {
        return this.__m_IncomingTransfers;
    }

    public PartitionedService$PartitionControl getPartitionControl(int idx) {
        return ((PartitionedService)this.get_Module()).getPartitionControl(idx);
    }

    public PrimitiveSparseArray getPartitionsOut() {
        return this.__m_PartitionsOut;
    }

    public List getQueuedTransfers(Member member) {
        return (List)this.getIncomingTransfers().get(member);
    }

    public Member getToMember() {
        return this.__m_ToMember;
    }

    public int getTransferCount() {
        return this.getPartitionsOut().getSize();
    }

    public int getTransferCountLimit() {
        return this.__m_TransferCountLimit;
    }

    public long getTransferSizeLimit() {
        return this.__m_TransferSizeLimit;
    }

    public long getTransferredBytes() {
        return this.__m_TransferredBytes;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$TransferControl".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PartitionedService$TransferControl();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isInProgress() {
        return this.getDistributionRequest() != null ? true : this.getTransferCount() > 0;
    }

    public boolean isIncomingTransfer(Member member) {
        return this.getIncomingTransfers().containsKey(member);
    }

    public boolean isIncompleteTransfer(Member member) {
        List listXfers = (List)this.getIncomingTransfers().get(member);
        if (listXfers == null ? true : listXfers.isEmpty()) {
            return false;
        }
        PartitionedService$TransferRequest msgXferLast = (PartitionedService$TransferRequest)listXfers.get(listXfers.size() - 1);
        return msgXferLast.isLastInTransfer() ^ true;
    }

    public boolean isTransferFull() {
        return this.getTransferredBytes() >= this.getTransferSizeLimit() ? true : this.getTransferCount() >= this.getTransferCountLimit();
    }

    public boolean isTransferInProgress(int iPartition) {
        return this.getPartitionsOut().exists(iPartition);
    }

    public PartitionedService$TransferControl$TransferIterator iterateTransfersInProgress() {
        return (PartitionedService$TransferControl$TransferIterator)this._newChild("TransferIterator");
    }

    public void onMemberLeft(Member member) {
        if (this.isIncompleteTransfer(member)) {
            this.onReceiveRollback(member);
        }
    }

    public void onReceiveCommitted(PartitionedService$TransferRequest msgLastTransfer) {
        Component._assert(msgLastTransfer.isLastInTransfer());
        this.getIncomingTransfers().remove(msgLastTransfer.getFromMember());
    }

    public void onReceiveRollback(Member memberSender) {
        this.getIncomingTransfers().remove(memberSender);
        this.finalizeReceive(null);
    }

    public void onReceiveStarted(PartitionedService$TransferRequest msgRequest, Continuation continuation) {
        Member memberFrom = msgRequest.getFromMember();
        Map mapQueues = this.getIncomingTransfers();
        ArrayList<PartitionedService$TransferRequest> listXfers = (ArrayList<PartitionedService$TransferRequest>)mapQueues.get(memberFrom);
        if (listXfers == null) {
            listXfers = new ArrayList<PartitionedService$TransferRequest>();
            mapQueues.put(memberFrom, listXfers);
        }
        listXfers.add(msgRequest);
        if (continuation != null) {
            continuation.proceed(null);
        }
    }

    public void onTransmitCommitted(PartitionedService$TransferRequest msgLastTransfer) {
        this.finalizeTransmit(msgLastTransfer);
    }

    public void onTransmitCompleted(int iPartition, int iStore) {
        PrimitiveSparseArray saInProgress = this.getPartitionsOut();
        this.setTransferState(iPartition, PartitionedService$PartitionControl.XFER_NONE);
        int iStoreXfer = (int)saInProgress.removePrimitive(iPartition);
        Component._assert(iStoreXfer == iStore);
        if (saInProgress.isEmpty()) {
            this.reset();
        }
    }

    public void onTransmitRejected(int iPartition, int iStore) {
        this.setTransferState(iPartition, PartitionedService$PartitionControl.XFER_NONE);
        PrimitiveSparseArray saInProgress = this.getPartitionsOut();
        int iStoreXfer = (int)saInProgress.removePrimitive(iPartition);
        Component._assert(iStoreXfer == iStore);
        if (iStore == 0) {
            this.cancelTransmit(iPartition);
        }
        if (saInProgress.isEmpty()) {
            this.reset();
        }
    }

    public void prepareBackupTransfer(Member member, long cbLimit, int cPartitionLimit) {
        Component._assert(this.isInProgress() ^ true);
        this.setDistributionRequest(null);
        this.setToMember(member);
        this.setTransferSizeLimit(cbLimit);
        this.setTransferCountLimit(cPartitionLimit);
    }

    public void preparePrimaryTransfer(RequestMessage msgRequest, long cbLimit) {
        Component._assert(this.isInProgress() ^ true);
        this.setDistributionRequest(msgRequest);
        this.setToMember(msgRequest.getFromMember());
        this.setTransferSizeLimit(cbLimit);
        this.setTransferCountLimit(Integer.MAX_VALUE);
    }

    public boolean recordTransfer(PartitionedService$TransferRequest msgTransfer, long cbTransfer) {
        RequestMessage msgRequest = this.getDistributionRequest();
        Member member = this.getToMember();
        msgTransfer.setRecipient(member);
        if (msgRequest == null) {
            msgTransfer.addToMember(member);
        } else {
            msgTransfer.respondTo(msgRequest);
        }
        int iPartition = msgTransfer.getPartition();
        int iStore = msgTransfer.getStore();
        this.setTransferredBytes(this.getTransferredBytes() + cbTransfer);
        this.getPartitionsOut().setPrimitive(iPartition, iStore);
        this.setTransferState(iPartition, PartitionedService$PartitionControl.XFER_STARTED);
        return this.isTransferFull();
    }

    public void requestBackupConfirmation(int iPartition, int iStore, int nMemberDeparted, Member memberTo) {
        Component._assert(iStore > 0);
        Component._trace(new StringBuilder(String.valueOf("Sending backup[")).append(iStore).append("] confirmation to member ").append(memberTo.getId()).append(" for partition ").append(iPartition).toString(), 3);
        PartitionedService service = (PartitionedService)this.get_Module();
        PartitionedService$BackupConfirmRequest msg = (PartitionedService$BackupConfirmRequest)service.instantiateMessage("BackupConfirmRequest");
        this.getPartitionControl(iPartition).preventTransfer();
        msg.setPartition(iPartition);
        msg.setStore(iStore);
        msg.setDepartedMemberId(nMemberDeparted);
        msg.addToMember(memberTo);
        service.post(msg);
    }

    protected void reset() {
        this.setDistributionRequest(null);
        this.getPartitionsOut().clear();
        this.setToMember(null);
        this.setTransferCountLimit(0);
        this.setTransferredBytes(0L);
        PartitionedService$PartitionControl[] aCtrlPartition = ((PartitionedService)this.get_Module()).getPartitionControl();
        int cPartitions = aCtrlPartition.length;
        int i = 0;
        while (i < cPartitions) {
            PartitionedService$PartitionControl ctrlPartition = aCtrlPartition[i];
            if (!(ctrlPartition != null) ? false : ctrlPartition.getTransferState() != PartitionedService$PartitionControl.XFER_NONE) {
                Component._trace(new StringBuilder(String.valueOf("Partition ")).append(i).append(" is in an unexpected transfer state; recovering.").toString(), 3);
                ctrlPartition.setTransferState(PartitionedService$PartitionControl.XFER_NONE);
            }
            ++i;
        }
    }

    public void sendBackupAnnounce(int iPartition, int iStore, Member memberTo, PartitionedService$BackupConfirmRequest msgRequest) {
        Component._assert(iStore != 0);
        PartitionedService service = (PartitionedService)this.get_Module();
        PartitionedService$BackupAssignment msg = (PartitionedService$BackupAssignment)service.instantiateMessage("BackupAssignment");
        msg.setPartition(iPartition);
        msg.setStore(iStore);
        msg.setRelease(false);
        if (msgRequest == null) {
            msg.addToMember(memberTo);
        } else {
            msg.respondTo(msgRequest);
        }
        service.post(msg);
    }

    public void sendBackupRelease(int iPartition, int iStore, int nOwnerPrimary, int nOwnerNew, Member memberTo, PartitionedService$BackupConfirmRequest msgRequest) {
        Component._assert(iStore > 0);
        PartitionedService service = (PartitionedService)this.get_Module();
        PartitionedService$BackupAssignment msg = (PartitionedService$BackupAssignment)service.instantiateMessage("BackupAssignment");
        msg.setPartition(iPartition);
        msg.setStore(iStore);
        msg.setRelease(true);
        msg.setNewBackupOwner(nOwnerNew);
        msg.setPrimaryOwner(nOwnerPrimary);
        if (msgRequest == null) {
            msg.addToMember(memberTo);
        } else {
            msg.respondTo(msgRequest);
        }
        service.post(msg);
    }

    protected void setDistributionRequest(RequestMessage msgRequest) {
        this.__m_DistributionRequest = msgRequest;
    }

    protected void setIncomingTransfers(Map laQueues) {
        this.__m_IncomingTransfers = laQueues;
    }

    protected void setPartitionsOut(PrimitiveSparseArray saInProgress) {
        this.__m_PartitionsOut = saInProgress;
    }

    protected void setToMember(Member member) {
        this.__m_ToMember = member;
    }

    protected void setTransferCountLimit(int cTransfer) {
        this.__m_TransferCountLimit = cTransfer;
    }

    protected void setTransferSizeLimit(long cbLimit) {
        this.__m_TransferSizeLimit = cbLimit;
    }

    protected void setTransferState(int nPartition, int nState) {
        this.getPartitionControl(nPartition).setTransferState(nState);
    }

    protected void setTransferredBytes(long cbTransfer) {
        this.__m_TransferredBytes = cbTransfer;
    }
}

