/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.MutableLong;
import com.oracle.coherence.common.internal.Platform;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.util.CommonMonitor;
import com.oracle.coherence.common.util.MemorySize;
import com.oracle.coherence.persistence.ConcurrentAccessException;
import com.oracle.coherence.persistence.FatalAccessException;
import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.requestMessage.DistributedCacheRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupMultiRequest;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest.BackupSingleRequest;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.ServiceConfig$Map;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$BusEventMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PingRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$BackupAssignment;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$BackupConfirmRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$CentralDistribution;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$Contention;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$Continuations;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$ConverterKeyToBinary;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$DistributionPlanUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$DistributionRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$NotifyServiceQuiescence;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$OwnershipRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$OwnershipResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionAbandonRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionConfig$Map;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionFilter;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionRecoverCleanup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionRecoverRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionRecoverRequest$RecoverJob;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionStatsUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionSwapRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PartitionVersionSyncRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PersistenceControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$PinningIterator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$SnapshotArchiveRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$SnapshotListRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$SnapshotRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferControl;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferControl$TransferIterator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferResponse;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultPartitionedServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlPartitionedServiceHelper;
import com.tangosol.internal.net.service.grid.PartitionedServiceDependencies;
import com.tangosol.internal.net.service.grid.PersistenceDependencies;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.license.CoherenceCommunityEdition;
import com.tangosol.license.LicenseException;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.Guardian;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.internal.PartitionRecoverInfo;
import com.tangosol.net.internal.PartitionVersions;
import com.tangosol.net.internal.QuorumInfo;
import com.tangosol.net.partition.DefaultKeyPartitioningStrategy;
import com.tangosol.net.partition.KeyAssociator;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.PartitionAssignmentStrategy;
import com.tangosol.net.partition.PartitionEvent;
import com.tangosol.net.partition.PartitionListener;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionStatistics;
import com.tangosol.net.partition.SimpleAssignmentStrategy;
import com.tangosol.net.partition.VersionedOwnership;
import com.tangosol.persistence.AbstractPersistenceEnvironment;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.GUIDHelper;
import com.tangosol.persistence.SafePersistenceWrappers;
import com.tangosol.persistence.SnapshotArchiver;
import com.tangosol.persistence.SnapshotArchiverFactory;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashEncoded;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.MapEvent;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.PrimitiveSparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.WrapperException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PartitionedService
extends Grid
implements com.tangosol.net.PartitionedService {
    public static final int BACKUP_STRENGTH_ENDANGERED = 1;
    public static final int BACKUP_STRENGTH_MACHINE = 3;
    public static final int BACKUP_STRENGTH_NODE = 2;
    public static final int BACKUP_STRENGTH_ORPHANED = 0;
    public static final int BACKUP_STRENGTH_RACK = 4;
    public static final int BACKUP_STRENGTH_SITE = 5;
    public static final int CONFIG_MAP_PARTITION = 2;
    public static final int MAX_PENDING_BACKUP_POLL = 100;
    public static final int OWNERSHIP_DISABLED = 1;
    public static final int OWNERSHIP_ENABLED = 4;
    public static final int OWNERSHIP_PENDING = 2;
    public static final int OWNERSHIP_UNKNOWN = 0;
    private boolean __m_AsyncBackup;
    private int __m_BackupCount;
    private boolean __m_Concurrent;
    private PartitionedService$Continuations __m_Continuations;
    private long __m_DeferredBackupTimeoutMillis;
    private int __m_DistributionAggressiveness;
    private volatile transient long __m_DistributionNextMillis;
    private int __m_DistributionRepeatMillis;
    private boolean __m_DistributionStable;
    private PartitionedService$CentralDistribution __m_DistributionStrategy;
    private boolean __m_DistributionSynchronized;
    private boolean __m_Finalizing;
    private transient KeyAssociator __m_KeyAssociator;
    private transient KeyPartitioningStrategy __m_KeyPartitioningStrategy;
    private PartitionedService$ConverterKeyToBinary __m_KeyToBinaryConverter;
    private transient String __m_MsgCAE;
    private boolean __m_OwnershipEnabled;
    private transient int __m_OwnershipInProgress;
    private int[] __m_OwnershipVersion;
    private volatile int[][] __m_PartitionAssignments;
    private PartitionedService$PartitionConfig$Map __m_PartitionConfigMap;
    private transient PartitionedService$Contention[] __m_PartitionContention;
    private transient PartitionedService$PartitionControl[] __m_PartitionControl;
    private int __m_PartitionCount;
    private Listeners __m_PartitionListeners;
    private PartitionedService$PersistenceControl __m_PersistenceControl;
    private PersistenceDependencies __m_PersistenceDependencies;
    private transient ThreadGate __m_PreprocessingGate;
    private String __m_RemainsOwnershipReport;
    private transient boolean __m_RestoreInProgress;
    private AtomicLong __m_ScratchSpaceCounter;
    private ThreadLocal __m_TLORecoveryThread;
    private PartitionedService$TransferControl __m_TransferControl;
    private int __m_TransferThreshold;
    private static ListMap __mapChildren;

    static {
        PartitionedService.__initStatic();
    }

    public PartitionedService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_PreprocessingGate = new ThreadGate();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("BackupAssignment", PartitionedService$BackupAssignment.get_CLASS());
        Class clazz3 = __mapChildren.put("BackupConfirmRequest", PartitionedService$BackupConfirmRequest.get_CLASS());
        Class clazz4 = __mapChildren.put("BusEventMessage", Grid$BusEventMessage.get_CLASS());
        Class clazz5 = __mapChildren.put("CentralDistribution", PartitionedService$CentralDistribution.get_CLASS());
        Class clazz6 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz7 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz8 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz9 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz10 = __mapChildren.put("Contention", PartitionedService$Contention.get_CLASS());
        Class clazz11 = __mapChildren.put("ConverterKeyToBinary", PartitionedService$ConverterKeyToBinary.get_CLASS());
        Class clazz12 = __mapChildren.put("DispatchEvent", PartitionedService$DispatchEvent.get_CLASS());
        Class clazz13 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz14 = __mapChildren.put("DistributionPlanUpdate", PartitionedService$DistributionPlanUpdate.get_CLASS());
        Class clazz15 = __mapChildren.put("DistributionRequest", PartitionedService$DistributionRequest.get_CLASS());
        Class clazz16 = __mapChildren.put("MemberConfigUpdate", PartitionedService$MemberConfigUpdate.get_CLASS());
        Class clazz17 = __mapChildren.put("MemberJoined", Grid$MemberJoined.get_CLASS());
        Class clazz18 = __mapChildren.put("MemberWelcome", PartitionedService$MemberWelcome.get_CLASS());
        Class clazz19 = __mapChildren.put("MemberWelcomeRequest", PartitionedService$MemberWelcomeRequest.get_CLASS());
        Class clazz20 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz21 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz22 = __mapChildren.put("NotifyMemberLeft", Grid$NotifyMemberLeft.get_CLASS());
        Class clazz23 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz24 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz25 = __mapChildren.put("NotifyResponse", Grid$NotifyResponse.get_CLASS());
        Class clazz26 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz27 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz28 = __mapChildren.put("NotifyServiceLeaving", PartitionedService$NotifyServiceLeaving.get_CLASS());
        Class clazz29 = __mapChildren.put("NotifyServiceLeft", Grid$NotifyServiceLeft.get_CLASS());
        Class clazz30 = __mapChildren.put("NotifyServiceQuiescence", PartitionedService$NotifyServiceQuiescence.get_CLASS());
        Class clazz31 = __mapChildren.put("NotifyShutdown", PartitionedService$NotifyShutdown.get_CLASS());
        Class clazz32 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz33 = __mapChildren.put("OwnershipRequest", PartitionedService$OwnershipRequest.get_CLASS());
        Class clazz34 = __mapChildren.put("OwnershipResponse", PartitionedService$OwnershipResponse.get_CLASS());
        Class clazz35 = __mapChildren.put("PartitionAbandonRequest", PartitionedService$PartitionAbandonRequest.get_CLASS());
        Class clazz36 = __mapChildren.put("PartitionControl", PartitionedService$PartitionControl.get_CLASS());
        Class clazz37 = __mapChildren.put("PartitionFilter", PartitionedService$PartitionFilter.get_CLASS());
        Class clazz38 = __mapChildren.put("PartitionRecoverCleanup", PartitionedService$PartitionRecoverCleanup.get_CLASS());
        Class clazz39 = __mapChildren.put("PartitionRecoverRequest", PartitionedService$PartitionRecoverRequest.get_CLASS());
        Class clazz40 = __mapChildren.put("PartitionStatsUpdate", PartitionedService$PartitionStatsUpdate.get_CLASS());
        Class clazz41 = __mapChildren.put("PartitionSwapRequest", PartitionedService$PartitionSwapRequest.get_CLASS());
        Class clazz42 = __mapChildren.put("PartitionVersionSyncRequest", PartitionedService$PartitionVersionSyncRequest.get_CLASS());
        Class clazz43 = __mapChildren.put("PersistenceControl", PartitionedService$PersistenceControl.get_CLASS());
        Class clazz44 = __mapChildren.put("PingRequest", Grid$PingRequest.get_CLASS());
        Class clazz45 = __mapChildren.put("PinningIterator", PartitionedService$PinningIterator.get_CLASS());
        Class clazz46 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz47 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz48 = __mapChildren.put("SnapshotArchiveRequest", PartitionedService$SnapshotArchiveRequest.get_CLASS());
        Class clazz49 = __mapChildren.put("SnapshotListRequest", PartitionedService$SnapshotListRequest.get_CLASS());
        Class clazz50 = __mapChildren.put("SnapshotRequest", PartitionedService$SnapshotRequest.get_CLASS());
        Class clazz51 = __mapChildren.put("TransferRequest", PartitionedService$TransferRequest.get_CLASS());
        Class clazz52 = __mapChildren.put("TransferResponse", PartitionedService$TransferResponse.get_CLASS());
        Class clazz53 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    protected void abandonPartitions(PartitionSet parts) {
        int cBackups = this.getBackupCount();
        int nMemberThis = this.getThisMember().getId();
        LiteMap<Integer, VersionedOwnership> mapUpdate = new LiteMap<Integer, VersionedOwnership>();
        Component._trace(new StringBuilder(String.valueOf("Abandoning the ownership of partitions ")).append(parts).toString(), 3);
        int iPart = parts.next(0);
        while (iPart >= 0) {
            int iStore = this.getOwnedIndex(iPart, nMemberThis);
            if (iStore >= 0) {
                if (iStore == 0) {
                    PartitionedService$PartitionControl ctrlPart = this.getPartitionControl(iPart);
                    boolean fLock = ctrlPart.lock(100L, PartitionedService$PartitionControl.LOCK_PRIMARY_XFER_OUT);
                    Component._assert(fLock);
                    try {
                        ctrlPart.setTransferState(PartitionedService$PartitionControl.XFER_SENT);
                        this.assignPartitionOwner(iPart, iStore, 0);
                        this.releasePartition(iPart, iStore);
                    }
                    finally {
                        Object var10_9 = null;
                        ctrlPart.setTransferState(PartitionedService$PartitionControl.XFER_NONE);
                        ctrlPart.unlock();
                        mapUpdate.put(iPart, new VersionedOwnership(cBackups, this.incrementOwnershipVersion(iPart)));
                    }
                } else {
                    this.assignPartitionOwner(iPart, iStore, 0);
                    this.releasePartition(iPart, iStore);
                }
                this.releasePartitionControl(iPart);
            } else {
                Component._trace(new StringBuilder(String.valueOf("Ignoring PartitionAbandonRequest for un-owned partition ")).append(iPart).toString(), 2);
            }
            iPart = parts.next(iPart + 1);
        }
        this.getDistributionStrategy().clearAdvice(parts);
        if (!(mapUpdate != null) ? false : mapUpdate.isEmpty() ^ true) {
            this.putPartitionConfig(mapUpdate);
        }
    }

    public void addPartitionListener(PartitionListener listener) {
        this.getPartitionListeners().add(listener);
    }

    protected void assignOrphan(int iPartition) {
        PartitionedService$PartitionControl ctrl = this.ensurePartitionControl(iPartition);
        if (this.isActivePersistence()) {
            PersistentStore store = ctrl.ensurePersistentStore();
            this.saveQuorum(iPartition, store);
            if (!(this.isExiting() ^ true) ? false : this.getServiceState() != Service.SERVICE_STOPPING) {
                CachePersistenceHelper.seal(store, this, null);
            }
        }
    }

    public void assignOrphans(PartitionSet parts, Message msgResponse) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        LiteMap<Integer, VersionedOwnership> mapUpdate = new LiteMap<Integer, VersionedOwnership>();
        PartitionSet partsAssigned = null;
        PartitionSet partsLost = null;
        boolean fActive = this.isActivePersistence();
        PartitionedService$PartitionConfig$Map mapConfig = this.getPartitionConfigMap();
        int iPartition = parts.next(0);
        int c = 0;
        while (!(!(iPartition >= 0) ? false : this.isExiting() ^ true) ? false : this.getServiceState() != Service.SERVICE_STOPPING) {
            int nOwner = aaiOwner[iPartition][0];
            if (nOwner == 0) {
                VersionedOwnership owners = this.assignPrimaryPartition(iPartition, 'r');
                mapUpdate.put(iPartition, owners);
                this.assignOrphan(iPartition);
                if (!fActive ? false : (c++ & 0xF) == 15) {
                    this.heartbeat();
                }
                if (mapConfig.isAssignmentCompleted(iPartition)) {
                    if (partsLost == null) {
                        partsLost = new PartitionSet(cPartitions);
                    }
                    partsLost.add(iPartition);
                } else {
                    if (partsAssigned == null) {
                        partsAssigned = new PartitionSet(cPartitions);
                    }
                    partsAssigned.add(iPartition);
                }
            } else {
                Component._trace(new StringBuilder(String.valueOf("Unable to assign orphaned partition ")).append(iPartition).append("; current owner is member ").append(nOwner).toString(), 2);
            }
            iPartition = parts.next(iPartition + 1);
        }
        if (partsLost != null) {
            Component._trace(new StringBuilder(String.valueOf("Assigned ")).append(partsLost.cardinality()).append(" orphaned primary partitions: ").append(partsLost).toString(), 2);
            this.firePartitionEvent(PartitionEvent.PARTITION_LOST, partsLost, null, this.getThisMember());
        }
        if (partsAssigned != null) {
            this.firePartitionEvent(PartitionEvent.PARTITION_ASSIGNED, partsAssigned, null, this.getThisMember());
        }
        this.onPartitionsAssigned(partsAssigned, partsLost, this.getContinuations().instantiateFinalizeAssignPrimaries(mapUpdate, msgResponse));
    }

    protected int[][] assignPartitionOwner(int iPartition, int iStore, int nMember) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int[] aiOwner = aaiOwner[iPartition];
        if (iStore == 0) {
            aaiOwner = (int[][])aaiOwner.clone();
            aiOwner = (int[])aiOwner.clone();
            aaiOwner[iPartition] = aiOwner;
        }
        aiOwner[iStore] = nMember;
        this.setPartitionAssignments(aaiOwner);
        return aaiOwner;
    }

    protected void assignPartitionOwners(int iPartition, int[] aiOwnerThat) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int[] aiOwnerThis = aaiOwner[iPartition];
        ServiceMemberSet setService = this.getServiceMemberSet();
        int i = 0;
        int c = aiOwnerThis.length;
        while (i < c) {
            int nOwnerThat = aiOwnerThat[i];
            if (aiOwnerThis[i] != nOwnerThat) {
                if (i == 0) {
                    aaiOwner = (int[][])aaiOwner.clone();
                }
                if (setService.contains(nOwnerThat) ^ true) {
                    aiOwnerThat[i] = 0;
                }
            }
            ++i;
        }
        aaiOwner[iPartition] = aiOwnerThat;
        this.setPartitionAssignments(aaiOwner);
    }

    protected VersionedOwnership assignPrimaryPartition(int iPartition, char chBackupOp) {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        int nMachineThis = memberThis.getMachineId();
        int[][] aaiOwner = this.getPartitionAssignments();
        int cBackups = this.getBackupCount();
        if (cBackups > 0) {
            int[] aiOwner = aaiOwner[iPartition];
            ServiceMemberSet setMember = this.getServiceMemberSet();
            int nPrimeOwner = aiOwner[0];
            if ((nPrimeOwner == nMemberThis ? true : setMember.contains(nPrimeOwner) ^ true) ? true : setMember.isServiceLeaving(nPrimeOwner)) {
                nPrimeOwner = 0;
            }
            int iBackupSwap = 0;
            int iBackup = 1;
            while (iBackup <= cBackups) {
                int nBackupOwner = aiOwner[iBackup];
                if (nBackupOwner == nMemberThis) {
                    if (!(chBackupOp == 'm')) {
                        this.releasePartition(iPartition, iBackup);
                    }
                    iBackupSwap = iBackup;
                } else if (!(iBackupSwap == 0) ? false : setMember.contains(nBackupOwner) ^ true) {
                    iBackupSwap = iBackup;
                }
                ++iBackup;
            }
            if (iBackupSwap > 0) {
                aiOwner = (int[])aiOwner.clone();
                aiOwner[iBackupSwap] = nPrimeOwner;
                aaiOwner[iPartition] = aiOwner;
            }
        }
        this.preparePartition(iPartition, 0);
        int nVersionNew = this.incrementOwnershipVersion(iPartition);
        aaiOwner = this.assignPartitionOwner(iPartition, 0, nMemberThis);
        VersionedOwnership owners = new VersionedOwnership(cBackups, nVersionNew);
        owners.setOwners(aaiOwner[iPartition]);
        return owners;
    }

    public int calculateEndangered() {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int cBackups = this.getBackupCount();
        if (cBackups == 0) {
            return cPartitions;
        }
        int cEndangered = 0;
        int iPartition = 0;
        while (iPartition < cPartitions) {
            int[] aiOwner = aaiOwner[iPartition];
            int iBackup = 1;
            while (iBackup <= cBackups) {
                if (aiOwner[iBackup] == 0) {
                    ++cEndangered;
                    break;
                }
                ++iBackup;
            }
            ++iPartition;
        }
        return cEndangered;
    }

    public int calculateEndangeredMembers() {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int cBackups = this.getBackupCount();
        HashSet<Integer> setId = new HashSet<Integer>();
        int iPartition = 0;
        while (iPartition < cPartitions) {
            int[] aiOwner = aaiOwner[iPartition];
            int iBackup = 1;
            while (iBackup <= cBackups) {
                if (aiOwner[iBackup] == 0) {
                    setId.add(aiOwner[0]);
                }
                ++iBackup;
            }
            ++iPartition;
        }
        return setId.size();
    }

    public int[] calculateOwnership(MemberSet setOwners, boolean fPrimary) {
        if (setOwners == null) {
            setOwners = this.getOwnershipMemberSet();
        }
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int nMaxMember = setOwners.getLastId();
        int[] acPartitions = new int[nMaxMember + 1];
        if (fPrimary) {
            int iPartition = 0;
            while (iPartition < cPartitions) {
                int nMemberOwner = aaiOwner[iPartition][0];
                if (nMemberOwner <= nMaxMember) {
                    int n = nMemberOwner;
                    acPartitions[n] = acPartitions[n] + 1;
                }
                ++iPartition;
            }
        } else {
            int cBackups = this.getBackupCount();
            int iPartition = 0;
            while (iPartition < cPartitions) {
                int[] aiOwner = aaiOwner[iPartition];
                int iBackup = 1;
                while (iBackup <= cBackups) {
                    int nMemberOwner = aiOwner[iBackup];
                    if (nMemberOwner <= nMaxMember) {
                        int n = nMemberOwner;
                        acPartitions[n] = acPartitions[n] + 1;
                    }
                    ++iBackup;
                }
                ++iPartition;
            }
        }
        return acPartitions;
    }

    public void calculateOwnershipConflicts(int nMemberThat, int[][] aaiOwnerThat, int cAttempts) {
        int nMemberThis = this.getThisMember().getId();
        int[][] aaiOwnerThis = this.getPartitionAssignments();
        int cBackups = this.getBackupCount();
        String sSubstToken = "{partitions}";
        HashMap<String, PartitionSet> mapLogMsgs = null;
        int iPartition = 0;
        int cPartitions = aaiOwnerThis.length;
        while (iPartition < cPartitions) {
            int[] aiOwnerThis = aaiOwnerThis[iPartition];
            int[] aiOwnerThat = aaiOwnerThat[iPartition];
            int iStore = 0;
            while (iStore <= cBackups) {
                int nOwnerThis = aiOwnerThis[iStore];
                int nOwnerThat = aiOwnerThat[iStore];
                if (nOwnerThis != nOwnerThat) {
                    String sLogTemplate = null;
                    if (!(iStore == 0) ? false : ((!(nOwnerThat == nMemberThis) ? false : nOwnerThis == 0) ? true : (!(nOwnerThis == nMemberThis) ? false : nOwnerThat == 0))) {
                        sLogTemplate = new StringBuilder(String.valueOf("Re-publishing the ownership for ")).append(sSubstToken).append(" [").append(nOwnerThis).append(']').toString();
                        this.publishPartitionOwnership(iPartition, iStore, nOwnerThis);
                    }
                    if (cAttempts > PartitionedService$OwnershipRequest.REQUEST_COUNT_THRESHOLD) {
                        int nOwnerGlobal = this.getPartitionConfig(iPartition).getOwner(iStore);
                        sLogTemplate = new StringBuilder(String.valueOf(cAttempts)).append("> Ownership conflict for ").append(sSubstToken).append(iStore == 0 ? "(primary)" : new StringBuilder(String.valueOf("(backup[")).append(iStore).append("])").toString()).append(" with member ").append(nMemberThat).append(" (").append(nOwnerThis).append("!=").append(nOwnerThat).append(nOwnerGlobal == nOwnerThis ? "" : new StringBuilder(String.valueOf("; global=")).append(nOwnerGlobal).toString()).append(')').toString();
                        if (!(nOwnerThis == nMemberThis ? true : nOwnerThat == nMemberThis) ? false : nOwnerThat > 0) {
                            if (nMemberThis == Math.min(nOwnerThis, nOwnerThat)) {
                                this.publishPartitionOwnership(iPartition, iStore, nOwnerThis);
                            } else {
                                Component._trace(new StringBuilder(String.valueOf("Unreconcilable ownership conflict; ")).append("conceding the ownership.").toString(), 1);
                                this.assignPartitionOwner(iPartition, iStore, 0);
                                this.releasePartition(iPartition, iStore);
                                this.publishPartitionOwnership(iPartition, iStore, 0);
                            }
                        } else if (!(iStore == 0) ? false : nMemberThis != this.getOwnershipSenior().getId()) {
                            Component._trace(new StringBuilder(String.valueOf("Multi-way ownership conflict; ")).append("requesting a republish of the ownership").toString(), 1);
                            this.assignPartitionOwner(iPartition, 0, 0);
                            this.publishPartitionOwnership(iPartition, 0, 0);
                        }
                    }
                    if (sLogTemplate != null) {
                        PartitionSet parts;
                        if (mapLogMsgs == null) {
                            mapLogMsgs = new HashMap<String, PartitionSet>();
                        }
                        if ((parts = (PartitionSet)mapLogMsgs.get(sLogTemplate)) == null) {
                            parts = new PartitionSet(cPartitions);
                            mapLogMsgs.put(sLogTemplate, parts);
                        }
                        parts.add(iPartition);
                    }
                }
                ++iStore;
            }
            ++iPartition;
        }
        if (mapLogMsgs != null) {
            Iterator iter = mapLogMsgs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String sLogTemplate = (String)entry.getKey();
                int ofStart = sLogTemplate.indexOf(sSubstToken);
                int ofEnd = ofStart + sSubstToken.length();
                Component._trace(new StringBuilder(String.valueOf(sLogTemplate.substring(0, ofStart))).append(entry.getValue()).append(sLogTemplate.substring(ofEnd, sLogTemplate.length())).toString(), 2);
            }
        }
    }

    public PartitionSet calculatePartitionSet(Member member, int iStore) {
        return this.calculatePartitionSet(member, iStore, false);
    }

    public PartitionSet calculatePartitionSet(Member member, int iStore, boolean fCheckLocked) {
        Component._assert(iStore <= this.getBackupCount());
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int nMember = member == null ? 0 : member.getId();
        PartitionSet partitions = new PartitionSet(cPartitions);
        int iPartition = 0;
        while (iPartition < cPartitions) {
            if (!(aaiOwner[iPartition][iStore] == nMember) ? false : (fCheckLocked ^ true ? true : this.getPartitionControl(iPartition).isLocked() ^ true)) {
                partitions.add(iPartition);
            }
            ++iPartition;
        }
        return partitions;
    }

    public PartitionSet calculatePartitionSet(Set setKeys) {
        PartitionSet partitions = new PartitionSet(this.getPartitionCount());
        Iterator iter = setKeys.iterator();
        while (iter.hasNext()) {
            partitions.add(this.getKeyPartition((Binary)iter.next()));
        }
        return partitions;
    }

    public int calculateThisOwnership(boolean fPrimary) {
        int nMemberThis = this.getThisMember().getId();
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitionsTotal = aaiOwner.length;
        int cPartitionsThis = 0;
        if (fPrimary) {
            int iPartition = 0;
            while (iPartition < cPartitionsTotal) {
                if (aaiOwner[iPartition][0] == nMemberThis) {
                    ++cPartitionsThis;
                }
                ++iPartition;
            }
        } else {
            int cBackups = this.getBackupCount();
            int iPartition = 0;
            while (iPartition < cPartitionsTotal) {
                int[] aiOwner = aaiOwner[iPartition];
                int iBackup = 1;
                while (iBackup <= cBackups) {
                    if (aiOwner[iBackup] == nMemberThis) {
                        ++cPartitionsThis;
                    }
                    ++iBackup;
                }
                ++iPartition;
            }
        }
        return cPartitionsThis;
    }

    public int calculateUnbalanced() {
        int cBuckets = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        int cMembers = this.getOwnershipMemberSet().size();
        if (cMembers == 0) {
            return cBuckets * (cBackups + 1);
        }
        int[] acBucket = this.calculateOwnership(null, true);
        int cUnbalanced = acBucket[0];
        if (cMembers == 1) {
            return cUnbalanced;
        }
        if (cMembers == 2) {
            VersionedOwnership owners = this.getPartitionConfig(0);
            ServiceMemberSet setMembers = this.getServiceMemberSet();
            com.tangosol.coherence.component.net.Member memberPrime = ((MemberSet)setMembers).getMember(owners.getPrimaryOwner());
            if (!(memberPrime != null) ? false : this.calculatePartitionSet(memberPrime, 0).isFull()) {
                if (cBackups == 0) {
                    return 0;
                }
                com.tangosol.coherence.component.net.Member memberBackup = ((MemberSet)setMembers).getMember(owners.getOwner(1));
                if (!(memberBackup != null) ? false : this.calculatePartitionSet(memberBackup, 1).isFull()) {
                    return 0;
                }
            }
        }
        int cFairShare = Math.min(cBuckets / cMembers + 1, cBuckets);
        int i = 1;
        int c = acBucket.length;
        while (i < c) {
            cUnbalanced += Math.max(0, acBucket[i] - cFairShare);
            ++i;
        }
        if ((cBuckets *= cBackups) > 0) {
            cFairShare = Math.min(cBuckets / cMembers + 1, cBuckets);
            acBucket = this.calculateOwnership(null, false);
            cUnbalanced += acBucket[0];
            boolean fForgive = cBackups > 1;
            int i2 = 1;
            int c2 = acBucket.length;
            while (i2 < c2) {
                int cOverload = Math.max(0, acBucket[i2] - cFairShare);
                cUnbalanced += (!fForgive ? false : (double)cOverload < (double)cFairShare * 0.1) ? 0 : cOverload;
                ++i2;
            }
        }
        return Math.min(cUnbalanced, cBuckets);
    }

    public int calculateVulnerable() {
        return this.calculateVulnerable(true);
    }

    public int calculateVulnerable(boolean fStrict) {
        int cPartitions = this.getPartitionCount();
        if (this.getBackupCount() == 0) {
            return cPartitions;
        }
        int cVulnerable = 0;
        int iPartition = 0;
        while (iPartition < cPartitions) {
            if (this.isPartitionVulnerable(iPartition, fStrict)) {
                ++cVulnerable;
            }
            ++iPartition;
        }
        return cVulnerable;
    }

    public boolean checkDeferredDistribution() {
        PartitionedService$CentralDistribution strategy = this.getDistributionStrategy();
        if (((this.isDistributionInProgress() ? true : this.isOwnershipChangeInProgress()) ? true : this.isRecoveryInProgress()) ? true : this.isRestoreInProgress()) {
            strategy.reportLateDistributions();
            return true;
        }
        strategy.setDistributionsPendingStart(0L);
        strategy.setWarningNextMillis(0L);
        int cPending = this.getPartitionConfigMap().getPendingConfigRequestCount();
        if (!this.isDistributionSynchronized() ? false : cPending > 0) {
            Component._trace(new StringBuilder(String.valueOf("Deferring the distribution due to ")).append(cPending).append(" pending configuration updates").toString(), 3);
            return true;
        }
        return false;
    }

    protected void checkDistribution() {
        this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)this.getDistributionRepeatMillis());
        if (this.checkDeferredDistribution()) {
            this.setDistributionStable(false);
            return;
        }
        MemberSet setOwners = this.getOwnershipMemberSet();
        MemberSet setOthers = this.getOwnershipOtherMemberSet(setOwners);
        Set setLeaving = this.getOwnershipLeavingMembers(setOwners);
        if (this.getServiceState() == Service.SERVICE_STOPPING) {
            PartitionSet partsPrimary = this.collectOwnedPartitions(true);
            PartitionSet partsBackup = this.collectOwnedPartitions(false);
            int cRemainPrimary = partsPrimary.cardinality();
            int cRemainBackup = partsBackup.cardinality();
            if (!(cRemainPrimary == 0) ? false : cRemainBackup == 0) {
                this.stop();
            } else if (setLeaving.size() == 1 + setOthers.size()) {
                this.stop();
            } else if (this.isDistributionAllowed() ^ true ? true : this.isRestorePartitionAllowed() ^ true) {
                this.stop();
            } else {
                String sRemains;
                Component._trace(new StringBuilder(String.valueOf("Remains to transfer before shutting down: ")).append(cRemainPrimary).append(" primary partitions, ").append(cRemainBackup).append(" backup partitions").toString(), 3);
                String sRemainsPrev = this.getRemainsOwnershipReport();
                if (sRemainsPrev == null) {
                    sRemains = "";
                } else {
                    sRemains = this.reportOwnership(this.getThisMember().getId(), true);
                    if (Base.equals(sRemainsPrev, sRemains) ^ true) {
                        Component._trace(sRemains, 5);
                    }
                }
                this.setRemainsOwnershipReport(sRemains);
            }
            return;
        }
        Component._assert(this.isOwnershipEnabled());
        int cOrphans = this.calculateOwnership(setOwners, true)[0];
        if (cOrphans > 0) {
            if (!(!this.isRestorePartitionAllowed() ? false : this.getThisMember() == this.getOwnershipSenior()) ? false : this.getOwnershipInProgress() <= 0) {
                this.doOwnershipProtocol(setOwners, null);
            }
            this.setDistributionStable(false);
            return;
        }
        this.setOwnershipInProgress(0);
        this.getDistributionStrategy().checkDistribution(setOwners, setLeaving);
        if (((this.isDistributionInProgress() ? true : this.isOwnershipChangeInProgress()) ? true : this.isAllAllowed() ^ true) ? true : this.calculateUnbalanced() > 0) {
            this.setDistributionStable(false);
        } else if (this.isDistributionStable() ^ true) {
            this.setDistributionStable(true);
            this.onOwnershipStable();
        }
    }

    public boolean checkLockRequired() {
        return this.isActivePersistence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContention(int iPartition) {
        PartitionedService$Contention contention;
        CommonMonitor oMonitor;
        PartitionedService$Contention[] aContention = this.getPartitionContention();
        CommonMonitor commonMonitor = oMonitor = Base.getCommonMonitor(System.identityHashCode(aContention) + iPartition);
        synchronized (commonMonitor) {
            contention = aContention[iPartition];
            if (contention != null) {
                aContention[iPartition] = null;
            }
        }
        if (contention != null) {
            contention.clear();
        }
    }

    public void clearContention(PartitionSet partitions) {
        int iPartition = partitions.next(0);
        while (iPartition >= 0) {
            this.clearContention(iPartition);
            iPartition = partitions.next(iPartition + 1);
        }
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultPartitionedServiceDependencies((PartitionedServiceDependencies)deps);
    }

    public PartitionSet collectEndangeredPartitions(int iBackup) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int nMemberThis = this.getThisMember().getId();
        PartitionSet setEndangered = new PartitionSet(cPartitions);
        int iPartition = 0;
        while (iPartition < cPartitions) {
            if (!(aaiOwner[iPartition][0] == nMemberThis) ? false : aaiOwner[iPartition][iBackup] == 0) {
                setEndangered.add(iPartition);
            }
            ++iPartition;
        }
        return setEndangered;
    }

    public PartitionSet collectOrphanPartitions() {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        PartitionSet parts = new PartitionSet(cPartitions);
        int iPartition = 0;
        while (iPartition < cPartitions) {
            if (aaiOwner[iPartition][0] == 0) {
                parts.add(iPartition);
            }
            ++iPartition;
        }
        return parts;
    }

    public PartitionSet collectOwnedPartitions(boolean fPrimary) {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        if (fPrimary) {
            return this.calculatePartitionSet(memberThis, 0);
        }
        int cBackups = this.getBackupCount();
        if (cBackups == 0) {
            return new PartitionSet(this.getPartitionCount());
        }
        PartitionSet setOwned = this.calculatePartitionSet(memberThis, 1);
        if (cBackups > 1) {
            int iStore = 2;
            while (iStore <= cBackups) {
                setOwned.add(this.calculatePartitionSet(memberThis, iStore));
                ++iStore;
            }
        }
        return setOwned;
    }

    public PartitionVersions collectOwnershipVersions(PartitionSet parts) {
        int[] anVersions = new int[parts.cardinality()];
        int iVersion = 0;
        int iPart = parts.next(0);
        while (iPart >= 0) {
            anVersions[iVersion++] = this.getOwnershipVersion(iPart);
            iPart = parts.next(iPart + 1);
        }
        return new PartitionVersions(parts, anVersions);
    }

    public PartitionSet collectVulnerablePartitions() {
        return this.collectVulnerablePartitions(false);
    }

    public PartitionSet collectVulnerablePartitions(boolean fStrict) {
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int nMemberThis = this.getThisMember().getId();
        PartitionSet partsVulnerable = new PartitionSet(cPartitions);
        int iPartition = 0;
        while (iPartition < cPartitions) {
            if (!(aaiOwner[iPartition][0] == nMemberThis) ? false : this.isPartitionVulnerable(iPartition, fStrict)) {
                partsVulnerable.add(iPartition);
            }
            ++iPartition;
        }
        return partsVulnerable;
    }

    public int compareImportance(com.tangosol.coherence.component.net.Member memberThat) {
        if (this.isAcceptingClients() ^ true) {
            return -1;
        }
        boolean fThisOwnership = this.isOwnershipEnabled();
        boolean fThatOwnership = this.isOwnershipEnabled(memberThat);
        int iResult = super.compareImportance(memberThat);
        if (!(iResult == 0) ? false : fThisOwnership ^ fThatOwnership) {
            iResult = fThisOwnership ? 1 : -1;
        }
        return iResult;
    }

    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlPartitionedServiceHelper.fromXml(xml, new DefaultPartitionedServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    public int convertHash(int nHash) {
        if (nHash == HashEncoded.UNENCODED) {
            nHash += this.getPartitionCount();
        }
        return nHash;
    }

    protected PartitionedService$PinningIterator createPinningIterator(Set set) {
        return this.createPinningIterator(set, null);
    }

    protected PartitionedService$PinningIterator createPinningIterator(Set set, PartitionVersions versions) {
        PartitionedService$PinningIterator pinner = (PartitionedService$PinningIterator)this._newChild("PinningIterator");
        pinner.setFullSet(set);
        pinner.setPartitionVersions(versions);
        return pinner;
    }

    public void discardBackupOwnership(int nPartition) {
        int iStore = this.getOwnedIndex(nPartition, this.getThisMember().getId());
        if (iStore > 0) {
            this.assignPartitionOwner(nPartition, iStore, 0);
            this.releasePartition(nPartition, iStore);
            this.releasePartitionControl(nPartition);
            com.tangosol.coherence.component.net.Member memberOwner = this.getPrimaryOwner(nPartition);
            this.getTransferControl().sendBackupRelease(nPartition, iStore, memberOwner.getId(), 0, memberOwner, null);
        }
    }

    public void doOwnershipProtocol(MemberSet setOwners, String sSnapshotToRecover) {
        PartitionedService$OwnershipRequest msg = (PartitionedService$OwnershipRequest)this.instantiateMessage("OwnershipRequest");
        msg.setSenderMemberSet(setOwners);
        msg.setQuery(true);
        msg.setSnapshotToRecover(sSnapshotToRecover);
        msg.setToMemberSet(setOwners);
        this.setOwnershipInProgress(-this.getOwnershipInProgress() + 1);
        this.post(msg);
    }

    protected PartitionedService$PartitionControl ensurePartitionControl(int nPartition) {
        PartitionedService$PartitionControl ctrl = this.getPartitionControl(nPartition);
        if (ctrl == null) {
            ctrl = (PartitionedService$PartitionControl)this._newChild("PartitionControl");
            ctrl.setPartitionId(nPartition);
            ctrl.setStatistics(new PartitionStatistics(nPartition, Base.getLastSafeTimeMillis()));
            ctrl.setTLOEnterCounter(MutableLong.createThreadLocal());
            this.setPartitionControl(nPartition, ctrl);
        }
        return ctrl;
    }

    protected Exception ensureSupport(DistributedCacheRequest msgRequest, String sFeature) {
        Exception e = msgRequest == null ? null : msgRequest.getReadException();
        if (!(e == null) ? false : this.getMsgCAE() != null) {
            e = new LicenseException(new StringBuilder(String.valueOf(sFeature)).append(": ").append(this.getMsgCAE()).toString());
        }
        return e;
    }

    public boolean enterPartition(int nPartition) {
        return this.enterPartition(nPartition, -1L);
    }

    public boolean enterPartition(int nPartition, long cWait) {
        PartitionedService$PartitionControl ctrlPartition = this.getPartitionControl(nPartition);
        if (ctrlPartition == null) {
            return false;
        }
        if (ctrlPartition.enter(0L)) {
            return true;
        }
        if (cWait == 0L) {
            return false;
        }
        int nLockType = ctrlPartition.getLockType();
        if ((nLockType == PartitionedService$PartitionControl.LOCK_BACKUP_XFER_OUT ? true : nLockType == PartitionedService$PartitionControl.LOCK_NONE) ? true : nLockType == PartitionedService$PartitionControl.LOCK_PERSISTENCE) {
            ctrlPartition.enter(-1L);
            return true;
        }
        return false;
    }

    public void exitPartition(int nPartition) {
        PartitionedService$PartitionControl ctrlPart = this.getPartitionControl(nPartition);
        if (ctrlPart != null) {
            ctrlPart.exit();
        }
    }

    protected void finalizeStartup() {
        Component._assert(this.isAcceptingOthers() ^ true);
        if (!this.validateMemberConfig() ? false : this.validatePartitionConfig()) {
            this.setAcceptingOthers(true);
            PartitionedService$PartitionConfig$Map mapConfig = this.getPartitionConfigMap();
            mapConfig.initializePartitions();
            if (this.isOwnershipEnabled()) {
                this.getThisMemberConfigMap().put("ownership-enabled", OWNERSHIP_ENABLED);
                com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
                if (this.getOwnershipSenior() == memberThis) {
                    Component._assert(mapConfig.getConfigCoordinator() == memberThis);
                    mapConfig.publishConfig(null);
                    this.onOwnershipSeniority(null);
                }
                if (this.isActivePersistence()) {
                    PartitionedService$PartitionRecoverCleanup msg = (PartitionedService$PartitionRecoverCleanup)this.instantiateMessage("PartitionRecoverCleanup");
                    msg.setPartitions(this.instantiatePartitionSet(true));
                    msg.addToMember(memberThis);
                    this.post(msg);
                }
                this.setDistributionNextMillis(0L);
            } else {
                this.setDistributionNextMillis(Long.MAX_VALUE);
            }
            this.onFinalizeStartup();
        } else {
            this.setFinalizing(true);
            long ldtStart = this.getStartTimestamp();
            long ldtCurrent = Base.getSafeTimeMillis();
            long lTimeout = this.getStartupTimeout();
            if (ldtCurrent > ldtStart + lTimeout - (long)1000) {
                Component._trace(new StringBuilder(String.valueOf("Failed to synchronize the service configuration; ")).append("stopping the service").toString(), 1);
                this.stop();
            }
        }
    }

    protected void firePartitionEvent(int nEventId, int nPartition, com.tangosol.coherence.component.net.Member memberFrom, com.tangosol.coherence.component.net.Member memberTo) {
        PartitionSet partitions = new PartitionSet(this.getPartitionCount());
        if (nPartition == -1) {
            partitions.fill();
        } else {
            partitions.add(nPartition);
        }
        this.firePartitionEvent(nEventId, partitions, memberFrom, memberTo);
    }

    protected void firePartitionEvent(int nEventId, PartitionSet partitions, com.tangosol.coherence.component.net.Member memberFrom, com.tangosol.coherence.component.net.Member memberTo) {
        block3: {
            EventListener[] listeners = this.getPartitionListeners().listeners();
            int cListeners = listeners.length;
            if (!(cListeners > 0)) break block3;
            try {
                int i = 0;
                while (i < cListeners) {
                    ((PartitionListener)listeners[i]).onPartitionEvent(new PartitionEvent(this, nEventId, partitions, memberFrom, memberTo));
                    ++i;
                }
            }
            catch (RuntimeException e) {
                Component._trace(new StringBuilder(String.valueOf("The following exception was thrown by PartitionListener:\n")).append(Component.getStackTrace(e)).append("\n(The service thread has logged the exception and is continuing.)").toString(), 1);
            }
        }
    }

    public int getBackupCount() {
        return this.__m_BackupCount;
    }

    public Member getBackupOwner(int iPartition, int nBackup) {
        if (nBackup <= 0 ? true : nBackup > this.getBackupCount()) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("invalid backup: ")).append(nBackup).toString());
        }
        try {
            int nMember = this.getPartitionAssignments()[iPartition][nBackup];
            return nMember == 0 ? null : this.getServiceMemberSet().getMember(nMember);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("invalid partition: ")).append(iPartition).toString());
        }
    }

    public List getBackupOwners(int iPartition) {
        return this.getBackupOwners(iPartition, true);
    }

    public List getBackupOwners(int iPartition, boolean fIncludeTransitional) {
        int cBackups = this.getBackupCount();
        if (cBackups == 0) {
            return Collections.emptyList();
        }
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        ArrayList<com.tangosol.coherence.component.net.Member> listOwners = new ArrayList<com.tangosol.coherence.component.net.Member>(cBackups);
        int iStore = 1;
        while (iStore <= cBackups) {
            com.tangosol.coherence.component.net.Member memberGlobal;
            com.tangosol.coherence.component.net.Member memberOwner;
            int nOwner = aiOwner[iStore];
            if ((!(nOwner > 0) ? false : setMembers.isServiceLeaving(nOwner) ^ true) && (memberOwner = setMembers.getMember(nOwner)) != null) {
                listOwners.add(memberOwner);
            }
            int nOwnerGlobal = owners.getOwner(iStore);
            if ((!(!(!fIncludeTransitional ? false : nOwnerGlobal != nOwner) ? false : nOwnerGlobal > 0) ? false : setMembers.isServiceLeaving(nOwnerGlobal) ^ true) && (memberGlobal = setMembers.getMember(nOwnerGlobal)) != null) {
                listOwners.add(memberGlobal);
            }
            ++iStore;
        }
        return listOwners;
    }

    public List getBackupOwners(Binary binKey) {
        return this.getBackupOwners(this.getKeyPartition(binKey));
    }

    public int getBackupStrength() {
        return this.getBackupStrength(false);
    }

    public int getBackupStrength(int iPartition, boolean fLocal) {
        int[] aiOwners = fLocal ? this.getPartitionAssignments()[iPartition] : this.getPartitionConfig(iPartition).getOwners();
        return this.getBackupStrength(aiOwners);
    }

    public int getBackupStrength(boolean fLocal) {
        if (this.getBackupCount() == 0) {
            return BACKUP_STRENGTH_ENDANGERED;
        }
        int nStatusSvc = BACKUP_STRENGTH_SITE;
        int cPartitions = this.getPartitionCount();
        int iPartition = 0;
        while (iPartition < cPartitions) {
            int nStatusPart = this.getBackupStrength(iPartition, fLocal);
            if (nStatusSvc > nStatusPart) {
                nStatusSvc = nStatusPart;
            }
            ++iPartition;
        }
        return nStatusSvc;
    }

    public int getBackupStrength(int[] aiOwners) {
        int cBackups = this.getBackupCount();
        if (cBackups == 0) {
            return BACKUP_STRENGTH_ENDANGERED;
        }
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int nStrength = BACKUP_STRENGTH_SITE;
        int iStoreThis = 0;
        while (iStoreThis <= cBackups) {
            com.tangosol.coherence.component.net.Member memberThis = ((MemberSet)setMembers).getMember(aiOwners[iStoreThis]);
            if (memberThis == null) {
                return BACKUP_STRENGTH_ORPHANED;
            }
            int iStoreThat = iStoreThis + 1;
            while (iStoreThat <= cBackups) {
                com.tangosol.coherence.component.net.Member memberThat = ((MemberSet)setMembers).getMember(aiOwners[iStoreThat]);
                if (memberThat == null) {
                    return BACKUP_STRENGTH_ENDANGERED;
                }
                if (!(nStrength > BACKUP_STRENGTH_NODE) ? false : memberThis.getMachineId() == memberThat.getMachineId()) {
                    nStrength = BACKUP_STRENGTH_NODE;
                } else if (!(nStrength > BACKUP_STRENGTH_MACHINE) ? false : Base.equals(memberThis.getRackName(), memberThat.getRackName())) {
                    nStrength = BACKUP_STRENGTH_MACHINE;
                } else if (!(nStrength > BACKUP_STRENGTH_RACK) ? false : Base.equals(memberThis.getSiteName(), memberThat.getSiteName())) {
                    nStrength = BACKUP_STRENGTH_RACK;
                }
                ++iStoreThat;
            }
            ++iStoreThis;
        }
        return nStrength;
    }

    public String getBackupStrengthName() {
        switch (this.getBackupStrength()) {
            case 0: 
            case 1: {
                return "ENDANGERED";
            }
            case 2: {
                return "NODE-SAFE";
            }
            case 3: {
                return "MACHINE-SAFE";
            }
            case 4: {
                return "RACK-SAFE";
            }
            case 5: {
                return "SITE-SAFE";
            }
        }
        return null;
    }

    public ServiceConfig$Map getConfigMap(int nMapType) {
        if (nMapType == CONFIG_MAP_PARTITION) {
            return this.getPartitionConfigMap();
        }
        return super.getConfigMap(nMapType);
    }

    public PartitionedService$Continuations getContinuations() {
        return this.__m_Continuations;
    }

    public long getDeferredBackupTimeoutMillis() {
        return this.__m_DeferredBackupTimeoutMillis;
    }

    public String getDescription() {
        if (this.isAcceptingClients()) {
            StringBuilder sb = new StringBuilder(super.getDescription()).append(", ");
            if (this.isOwnershipEnabled()) {
                sb.append("LocalStorage=enabled").append(", PartitionCount=").append(this.getPartitionCount()).append(", BackupCount=").append(this.getBackupCount()).append(", AssignedPartitions=").append(this.calculateThisOwnership(true));
                if (this.getBackupCount() > 0) {
                    sb.append(", BackupPartitions=").append(this.calculateThisOwnership(false));
                }
            } else {
                sb = new StringBuilder("LocalStorage=disabled");
            }
            Member member = this.getOwnershipSenior();
            sb.append(", CoordinatorId=").append(member == null ? "n/a" : String.valueOf(member.getId()));
            return sb.toString();
        }
        return "Not initialized";
    }

    public int getDistributionAggressiveness() {
        return this.__m_DistributionAggressiveness;
    }

    public long getDistributionContendMillis() {
        return Math.max(100L, (long)this.getDistributionAggressiveness());
    }

    public long getDistributionNextMillis() {
        return this.__m_DistributionNextMillis;
    }

    public int getDistributionRepeatMillis() {
        return this.__m_DistributionRepeatMillis;
    }

    public PartitionedService$CentralDistribution getDistributionStrategy() {
        return this.__m_DistributionStrategy;
    }

    public com.tangosol.coherence.component.net.Member getGlobalPrimaryOwner(int iPartition) {
        int nMember = this.getPartitionConfig(iPartition).getPrimaryOwner();
        return nMember == 0 ? null : this.getServiceMemberSet().getMember(nMember);
    }

    public KeyAssociator getKeyAssociator() {
        return this.__m_KeyAssociator;
    }

    public Member getKeyOwner(Object oKey) {
        return this.getPrimaryOwner((Binary)this.getKeyToBinaryConverter().convert(oKey));
    }

    public int getKeyPartition(Binary binKey) {
        if (binKey == null) {
            return 0;
        }
        return ExternalizableHelper.isIntDecorated(binKey) ? DefaultKeyPartitioningStrategy.calculatePartition(this, ExternalizableHelper.extractIntDecoration(binKey)) : binKey.calculateNaturalPartition(this.getPartitionCount());
    }

    public KeyPartitioningStrategy getKeyPartitioningStrategy() {
        return this.__m_KeyPartitioningStrategy;
    }

    public PartitionSet getKeyPartitions(Set setKey) {
        PartitionSet setPartition = new PartitionSet(this.getPartitionCount());
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            setPartition.add(this.getKeyPartition((Binary)iter.next()));
        }
        return setPartition;
    }

    public PartitionedService$ConverterKeyToBinary getKeyToBinaryConverter() {
        return this.__m_KeyToBinaryConverter;
    }

    private String getMsgCAE() {
        return this.__m_MsgCAE;
    }

    public MemberSet getOthersMemberSet() {
        ActualMemberSet setOthers = new ActualMemberSet();
        setOthers.addAll((Collection)this.getServiceMemberSet());
        setOthers.remove(this.getThisMember());
        return setOthers;
    }

    public int getOwnedIndex(int iPartition, int nMember) {
        return this.getOwnedIndex(iPartition, nMember, true);
    }

    public int getOwnedIndex(int iPartition, int nMember, boolean fLocal) {
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        int iStore = 0;
        int cBackups = this.getBackupCount();
        while (iStore <= cBackups) {
            int nOwner = fLocal ? aiOwner[iStore] : owners.getOwner(iStore);
            if (nOwner == nMember) {
                return iStore;
            }
            ++iStore;
        }
        return -1;
    }

    public PartitionSet getOwnedPartitions(Member member) {
        return this.getServiceMemberSet().contains(member) ? this.calculatePartitionSet(member, 0) : null;
    }

    public Set getOwnershipEnabledMembers() {
        return this.getOwnershipMemberSet();
    }

    public int getOwnershipInProgress() {
        return this.__m_OwnershipInProgress;
    }

    public Set getOwnershipLeavingMembers() {
        return this.getOwnershipLeavingMembers(this.getOwnershipMemberSet());
    }

    public Set getOwnershipLeavingMembers(Set setOwners) {
        LiteSet<com.tangosol.coherence.component.net.Member> setLeaving = new LiteSet<com.tangosol.coherence.component.net.Member>();
        ServiceMemberSet setService = this.getServiceMemberSet();
        if (setOwners == null) {
            setOwners = this.getOwnershipMemberSet();
        }
        Iterator iter = setOwners.iterator();
        while (iter.hasNext()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            if (!setService.isServiceLeaving(member.getId())) continue;
            setLeaving.add(member);
        }
        return setLeaving;
    }

    public MemberSet getOwnershipMemberSet() {
        return this.getOwnershipMemberSet(false);
    }

    public MemberSet getOwnershipMemberSet(boolean fIncludePending) {
        ActualMemberSet setOwners = new ActualMemberSet();
        switch (this.getServiceState()) {
            case 2: 
            case 3: {
                ServiceMemberSet setMembers = this.getServiceMemberSet();
                if (!(setMembers != null)) break;
                Iterator iter = setMembers.iterator();
                while (iter.hasNext()) {
                    com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                    int nStatus = this.getOwnershipStatus(member);
                    if (!(nStatus == OWNERSHIP_ENABLED ? true : (!fIncludePending ? false : nStatus == OWNERSHIP_PENDING))) continue;
                    setOwners.add(member);
                }
                break;
            }
        }
        return setOwners;
    }

    public MemberSet getOwnershipOtherMemberSet(MemberSet setOwners) {
        DependentMemberSet setOthers = new DependentMemberSet();
        setOthers.setBaseSet(setOwners == null ? this.getOwnershipMemberSet() : setOwners);
        setOthers.addAll();
        setOthers.remove(this.getThisMember());
        return setOthers;
    }

    public Member getOwnershipSenior() {
        return this.getOwnershipSenior(true);
    }

    public com.tangosol.coherence.component.net.Member getOwnershipSenior(boolean fIncludeLeaving) {
        MemberSet setOwners = this.getOwnershipMemberSet();
        ServiceMemberSet setService = this.getServiceMemberSet();
        com.tangosol.coherence.component.net.Member memberAnchor = null;
        long ldtJoinedAnchor = Long.MAX_VALUE;
        Iterator iter = setOwners.iterator();
        while (iter.hasNext()) {
            long ldtJoined;
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            int nMember = member.getId();
            if ((!(fIncludeLeaving ^ true) ? false : setService.isServiceLeaving(nMember)) || !(!((ldtJoined = setService.getServiceJoinTime(nMember)) != 0L) ? false : ldtJoined < ldtJoinedAnchor)) continue;
            memberAnchor = member;
            ldtJoinedAnchor = ldtJoined;
        }
        return memberAnchor;
    }

    public int getOwnershipStatus(com.tangosol.coherence.component.net.Member member) {
        Integer IOwnership = (Integer)this.getServiceMemberSet().getMemberConfigMap(member.getId()).get("ownership-enabled");
        return IOwnership == null ? OWNERSHIP_UNKNOWN : IOwnership;
    }

    public int[] getOwnershipVersion() {
        return this.__m_OwnershipVersion;
    }

    public int getOwnershipVersion(int i) {
        return this.getOwnershipVersion()[i];
    }

    public PartitionAssignmentStrategy getPartitionAssignmentStrategy() {
        return this.getDistributionStrategy().getPartitionAssignmentStrategy();
    }

    public int[][] getPartitionAssignments() {
        return this.__m_PartitionAssignments;
    }

    public VersionedOwnership getPartitionConfig(int iPartition) {
        return (VersionedOwnership)this.getPartitionConfigMap().get(iPartition);
    }

    public PartitionedService$PartitionConfig$Map getPartitionConfigMap() {
        return this.__m_PartitionConfigMap;
    }

    public PartitionedService$Contention[] getPartitionContention() {
        return this.__m_PartitionContention;
    }

    public PartitionedService$PartitionControl[] getPartitionControl() {
        return this.__m_PartitionControl;
    }

    public PartitionedService$PartitionControl getPartitionControl(int i) {
        return this.getPartitionControl()[i];
    }

    public int getPartitionCount() {
        return this.__m_PartitionCount;
    }

    public Listeners getPartitionListeners() {
        return this.__m_PartitionListeners;
    }

    public Member getPartitionOwner(int nPartition) {
        try {
            return this.getPrimaryOwner(nPartition);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("invalid partition: ")).append(nPartition).toString());
        }
    }

    public Ownership getPartitionOwnership(int nPartition) {
        Ownership owners = new Ownership(this.getBackupCount());
        owners.setOwners(this.getPartitionAssignments()[nPartition]);
        return owners;
    }

    public PartitionedService$PersistenceControl getPersistenceControl() {
        return this.__m_PersistenceControl;
    }

    public PersistenceDependencies getPersistenceDependencies() {
        return this.__m_PersistenceDependencies;
    }

    public PersistenceManager getPersistenceManager() {
        return this.getPersistenceControl().getActiveManager();
    }

    public ThreadGate getPreprocessingGate() {
        return this.__m_PreprocessingGate;
    }

    public com.tangosol.coherence.component.net.Member getPrimaryOwner(int iPartition) {
        int nMember = this.getPartitionAssignments()[iPartition][0];
        return nMember == 0 ? null : this.getServiceMemberSet().getMember(nMember);
    }

    public com.tangosol.coherence.component.net.Member getPrimaryOwner(Binary binKey) {
        return this.getPrimaryOwner(this.getKeyPartition(binKey));
    }

    public String getRemainsOwnershipReport() {
        return this.__m_RemainsOwnershipReport;
    }

    public AtomicLong getScratchSpaceCounter() {
        return this.__m_ScratchSpaceCounter;
    }

    public MemberSet getStatusMemberSet(int nMask) {
        ActualMemberSet setMembers = new ActualMemberSet();
        if (this.getServiceState() != Service.SERVICE_STOPPED) {
            Iterator iter = this.getServiceMemberSet().iterator();
            while (iter.hasNext()) {
                com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                if (!((this.getOwnershipStatus(member) & nMask) != 0)) continue;
                setMembers.add(member);
            }
        }
        return setMembers;
    }

    public ThreadLocal getTLORecoveryThread() {
        return this.__m_TLORecoveryThread;
    }

    public PartitionedService$TransferControl getTransferControl() {
        PartitionedService$TransferControl control = this.__m_TransferControl;
        if (control == null) {
            control = (PartitionedService$TransferControl)this._findChild("TransferControl");
            this.setTransferControl(control);
        }
        return control;
    }

    public int getTransferThreshold() {
        return this.__m_TransferThreshold;
    }

    public long getWaitMillis() {
        long cWait1 = super.getWaitMillis();
        long ldtNow = Base.getSafeTimeMillis();
        long cWait2 = Math.max(1L, this.getDistributionNextMillis() - ldtNow);
        return cWait1 <= 0L ? cWait2 : Math.min(cWait1, cWait2);
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public int incrementOwnershipVersion(int nPartition) {
        Component._assert(Thread.currentThread() == this.getThread());
        int[] nArray = this.getOwnershipVersion();
        int n = nPartition;
        int n2 = nArray[n] + 1;
        nArray[n] = n2;
        return n2;
    }

    protected void initPartitionConfig() {
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        HashMap<Integer, VersionedOwnership> mapUpdates = new HashMap<Integer, VersionedOwnership>();
        int iPartition = 0;
        while (iPartition < cPartitions) {
            mapUpdates.put(iPartition, new VersionedOwnership(cBackups, 0));
            ++iPartition;
        }
        this.getPartitionConfigMap().updateInternal(mapUpdates, false);
    }

    protected XmlElement initServiceConfig() {
        if (this.getThisMember() != this.getServiceOldestMember()) {
            throw new IllegalStateException(new StringBuilder(String.valueOf("Missing ServiceConfigMap from senior=")).append(this.getServiceOldestMember().getId()).toString());
        }
        KeyAssociator associator = this.getKeyAssociator();
        KeyPartitioningStrategy partitioning = this.getKeyPartitioningStrategy();
        ActionPolicy quorumPolicy = this.getActionPolicy();
        String sAssociator = associator == null ? "none" : associator.getClass().getName();
        String sPartitioning = partitioning == null ? "none" : partitioning.getClass().getName();
        String sQuorumPolicy = quorumPolicy == null ? "none" : quorumPolicy.getClass().getName();
        XmlElement xmlConfig = super.initServiceConfig();
        xmlConfig.addAttribute("partition-count").setInt(this.getPartitionCount());
        xmlConfig.addAttribute("redundancy-count").setInt(this.getBackupCount());
        xmlConfig.addAttribute("key-associator").setString(sAssociator);
        xmlConfig.addAttribute("key-partitioning").setString(sPartitioning);
        xmlConfig.addAttribute("quorum-policy").setString(sQuorumPolicy);
        return xmlConfig;
    }

    public PartitionedService$ConverterKeyToBinary instantiateKeyToBinaryConverter(ClassLoader loader, boolean fPassThrough) {
        ConfigurablePofContext cpc;
        PartitionedService$ConverterKeyToBinary conv = (PartitionedService$ConverterKeyToBinary)this._newChild("ConverterKeyToBinary");
        Serializer serializer = this.ensureSerializer(loader);
        if (serializer instanceof ConfigurablePofContext && (cpc = (ConfigurablePofContext)serializer).isReferenceEnabled()) {
            cpc = new ConfigurablePofContext(cpc);
            cpc.setReferenceEnabled(false);
            serializer = cpc;
        }
        conv.setSerializer(serializer);
        conv.setPassThrough(fPassThrough);
        return conv;
    }

    public PartitionedService$PartitionFilter instantiatePartitionFilter(int nPartition) {
        PartitionedService$PartitionFilter filter = (PartitionedService$PartitionFilter)this._newChild("PartitionFilter");
        PartitionSet parts = this.instantiatePartitionSet(false);
        parts.add(nPartition);
        filter.setPartitionSet(parts);
        return filter;
    }

    public PartitionSet instantiatePartitionSet(int nPartition) {
        PartitionSet parts = new PartitionSet(this.getPartitionCount());
        parts.add(nPartition);
        return parts;
    }

    public PartitionSet instantiatePartitionSet(boolean fFill) {
        PartitionSet parts = new PartitionSet(this.getPartitionCount());
        if (fFill) {
            parts.fill();
        }
        return parts;
    }

    public boolean isActivePersistence() {
        return this.getPersistenceManager() != null;
    }

    public boolean isAllAllowed() {
        return !(!(this.isSuspended() ^ true) ? false : this.getActionPolicy().isAllowed(this, PartitionedService.PartitionedAction.DISTRIBUTE)) ? false : this.getActionPolicy().isAllowed(this, PartitionedService.PartitionedAction.RESTORE);
    }

    public boolean isAsyncBackup() {
        return this.__m_AsyncBackup;
    }

    public boolean isBackupOwner(int iPartition) {
        return this.isBackupOwner(iPartition, this.getThisMember().getId());
    }

    public boolean isBackupOwner(int iPartition, int nMember) {
        return this.getOwnedIndex(iPartition, nMember) > 0;
    }

    public boolean isBackupOwner(Binary binKey) {
        return this.isBackupOwner(this.getKeyPartition(binKey));
    }

    public boolean isConcurrent() {
        return this.__m_Concurrent;
    }

    public boolean isDistributionAllowed() {
        return !(this.isSuspended() ^ true) ? false : this.getActionPolicy().isAllowed(this, PartitionedService.PartitionedAction.DISTRIBUTE);
    }

    public boolean isDistributionInProgress() {
        return this.getDistributionStrategy().isDistributionInProgress();
    }

    public boolean isDistributionStable() {
        return this.__m_DistributionStable;
    }

    public boolean isDistributionSynchronized() {
        return this.__m_DistributionSynchronized;
    }

    protected boolean isFinalizing() {
        return this.__m_Finalizing;
    }

    public boolean isOwnershipChangeInProgress() {
        if (this.getTransferControl().isInProgress()) {
            return true;
        }
        PartitionSet parts = this.collectOwnedPartitions(true);
        int iPart = parts.next(0);
        while (iPart >= 0) {
            if (this.getPartitionControl(iPart).isTransferDisallowed()) {
                return true;
            }
            iPart = parts.next(iPart + 1);
        }
        return false;
    }

    public boolean isOwnershipDisabled(com.tangosol.coherence.component.net.Member member) {
        return this.getOwnershipStatus(member) == OWNERSHIP_DISABLED;
    }

    public boolean isOwnershipEnabled() {
        return this.__m_OwnershipEnabled;
    }

    public boolean isOwnershipEnabled(com.tangosol.coherence.component.net.Member member) {
        return this.getOwnershipStatus(member) == OWNERSHIP_ENABLED;
    }

    public boolean isOwnershipPending(com.tangosol.coherence.component.net.Member member) {
        return this.getOwnershipStatus(member) == OWNERSHIP_PENDING;
    }

    public boolean isPartitionVulnerable(int iPartition, boolean fStrict) {
        return fStrict ? this.getBackupStrength(iPartition, false) < BACKUP_STRENGTH_MACHINE : this.isPartitionVulnerableLegacy(iPartition);
    }

    protected boolean isPartitionVulnerableLegacy(int iPartition) {
        com.tangosol.coherence.component.net.Member memberPrime;
        if (this.getBackupCount() > 0 && (memberPrime = this.getPrimaryOwner(iPartition)) != null) {
            Iterator iter = this.getBackupOwners(iPartition).iterator();
            while (iter.hasNext()) {
                com.tangosol.coherence.component.net.Member memberBackup = (com.tangosol.coherence.component.net.Member)iter.next();
                if (!(memberPrime.getMachineId() != memberBackup.getMachineId())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPrimaryOwner(int iPartition) {
        if (this.getPartitionAssignments()[iPartition][0] == this.getThisMember().getId()) {
            PartitionedService$PartitionControl control = this.getPartitionControl(iPartition);
            if (control.isLocked()) {
                int nLockType = control.getLockType();
                return !(!(nLockType != PartitionedService$PartitionControl.LOCK_PERSISTENCE) ? false : nLockType != PartitionedService$PartitionControl.LOCK_PRIMARY_XFER_IN) ? false : nLockType != PartitionedService$PartitionControl.LOCK_PRIMARY_XFER_OUT;
            }
            return true;
        }
        return false;
    }

    public boolean isPrimaryOwner(Binary binKey) {
        return this.isPrimaryOwner(this.getKeyPartition(binKey));
    }

    public boolean isRecoverPartitionsAllowed(PartitionSet partsOrphan, GUIDHelper.GUIDResolver resolver, QuorumInfo info) {
        if (this.isSuspended()) {
            return false;
        }
        if (this.isActivePersistence() ^ true ? true : this.getPersistenceControl().isForceRecovery()) {
            return true;
        }
        return this.getActionPolicy().isAllowed(this, new PartitionedService.PartitionRecoveryAction(partsOrphan, resolver, info));
    }

    public boolean isRecovering(int nPartition) {
        return this.getPartitionControl(nPartition).isRecovering();
    }

    public boolean isRecoveryInProgress() {
        return this.getPersistenceControl().getActiveRecoveryRequests().get() > 0;
    }

    public boolean isRecoveryThread() {
        Boolean fRecoveryThread = (Boolean)this.getTLORecoveryThread().get();
        return !(fRecoveryThread != null) ? false : fRecoveryThread;
    }

    public boolean isRestoreInProgress() {
        return this.__m_RestoreInProgress;
    }

    public boolean isRestorePartitionAllowed() {
        return !(this.isSuspended() ^ true) ? false : this.getActionPolicy().isAllowed(this, PartitionedService.PartitionedAction.RESTORE);
    }

    public boolean isSnapshotManager(PersistenceManager mgrRecover) {
        return mgrRecover != this.getPersistenceManager();
    }

    public boolean isSuspendedFully() {
        if (super.isSuspendedFully()) {
            PartitionSet parts = this.getOwnedPartitions(this.getThisMember());
            PartitionedService$PartitionControl[] actrlPartition = this.getPartitionControl();
            int nPartition = parts.next(0);
            while (nPartition >= 0) {
                PartitionedService$PartitionControl ctrl = actrlPartition[nPartition];
                if (ctrl != null && ctrl.getPersistenceTasks().get() > 0) {
                    return false;
                }
                nPartition = parts.next(nPartition + 1);
            }
            return this.isOwnershipEnabled() ^ true ? true : (!(this.isDistributionInProgress() ^ true) ? false : this.isOwnershipChangeInProgress() ^ true);
        }
        return false;
    }

    public boolean isTransferInProgress() {
        return this.getTransferControl().isInProgress();
    }

    public boolean isTransferVulnerable(int iPartition, int iStorage, com.tangosol.coherence.component.net.Member memberTo) {
        Component._assert(memberTo != null);
        if (this.getBackupCount() > 0) {
            int nMachineTo = memberTo.getMachineId();
            List listOwners = this.getBackupOwners(iPartition);
            switch (listOwners.size()) {
                case 0: {
                    return true;
                }
                case 1: {
                    if (iStorage > 0) {
                        com.tangosol.coherence.component.net.Member memberPrimary = this.getThisMember();
                        return memberPrimary.getMachineId() == nMachineTo;
                    }
                    com.tangosol.coherence.component.net.Member memberBackup = (com.tangosol.coherence.component.net.Member)listOwners.iterator().next();
                    return memberBackup.getMachineId() == nMachineTo;
                }
            }
            if (iStorage > 0) {
                listOwners.add(this.getThisMember());
                com.tangosol.coherence.component.net.Member memberBackup = (com.tangosol.coherence.component.net.Member)this.getBackupOwner(iPartition, iStorage);
                if (memberBackup != null) {
                    listOwners.remove(memberBackup);
                }
            }
            Iterator iter = listOwners.iterator();
            while (iter.hasNext()) {
                com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
                if (!(member.getMachineId() == nMachineTo)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isVulnerabilityAvoidable(MemberSet setOwners) {
        int cMembers = setOwners.size();
        int cBackups = this.getBackupCount();
        if (cMembers <= 1 ? true : cBackups == 0) {
            return false;
        }
        HashMap<Integer, Integer> mapCount = new HashMap<Integer, Integer>();
        Iterator iter = setOwners.iterator();
        while (iter.hasNext()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            Integer IMachine = member.getMachineId();
            Integer ICount = (Integer)mapCount.get(IMachine);
            int nCount = ICount == null ? 1 : ICount + 1;
            if (nCount * (cBackups + 1) >= cMembers) {
                return false;
            }
            mapCount.put(IMachine, nCount);
        }
        return true;
    }

    public Map lockForRecovery(PartitionedService$PartitionRecoverRequest msgRequest) {
        String[] asGUIDs = msgRequest.getGUIDs();
        int cGUIDs = asGUIDs.length;
        HashMap<Integer, VersionedOwnership> mapUpdate = new HashMap<Integer, VersionedOwnership>(cGUIDs);
        int i = 0;
        while (i < cGUIDs) {
            String sGUID = asGUIDs[i];
            int nPartition = GUIDHelper.getPartition(sGUID);
            PartitionedService$PartitionControl ctrlPart = this.ensurePartitionControl(nPartition);
            ctrlPart.lock(-1L, PartitionedService$PartitionControl.LOCK_PERSISTENCE);
            Component._assert(this.getPrimaryOwner(nPartition) == null);
            if (this.getOwnershipVersion(nPartition) == 0) {
                this.setOwnershipVersion(nPartition, (int)GUIDHelper.getVersion(sGUID));
            }
            VersionedOwnership owners = this.assignPrimaryPartition(nPartition, 'r');
            mapUpdate.put(nPartition, owners);
            ++i;
        }
        LiteMap<Integer, VersionedOwnership> mapAssigned = new LiteMap<Integer, VersionedOwnership>();
        PartitionSet partsAssign = msgRequest.getPartsAssign();
        if (partsAssign.isEmpty() ^ true) {
            int[][] aaiOwner = this.getPartitionAssignments();
            int cPartitions = aaiOwner.length;
            PartitionedService$PartitionConfig$Map mapConfig = this.getPartitionConfigMap();
            PartitionSet partsAssigned = null;
            PartitionSet partsLost = null;
            int iPartition = partsAssign.next(0);
            while (iPartition >= 0) {
                int nOwner = aaiOwner[iPartition][0];
                if (nOwner == 0) {
                    PartitionedService$PartitionControl ctrlPart = this.ensurePartitionControl(iPartition);
                    if (this.checkLockRequired()) {
                        ctrlPart.lock(-1L, PartitionedService$PartitionControl.LOCK_PERSISTENCE);
                    }
                    VersionedOwnership owners = this.assignPrimaryPartition(iPartition, 'r');
                    mapAssigned.put(iPartition, owners);
                    if (mapConfig.isAssignmentCompleted(iPartition)) {
                        if (partsLost == null) {
                            partsLost = new PartitionSet(cPartitions);
                        }
                        partsLost.add(iPartition);
                    } else {
                        if (partsAssigned == null) {
                            partsAssigned = new PartitionSet(cPartitions);
                        }
                        partsAssigned.add(iPartition);
                    }
                } else {
                    Component._trace(new StringBuilder(String.valueOf("Unable to assign orphaned partition ")).append(iPartition).append("; current owner is member ").append(nOwner).toString(), 2);
                    partsAssign.remove(iPartition);
                }
                iPartition = partsAssign.next(iPartition + 1);
            }
            msgRequest.setPartsAssigned(partsAssigned);
            msgRequest.setPartsLost(partsLost);
            msgRequest.setMapAssigned(mapAssigned);
        }
        return mapUpdate;
    }

    protected void movePartition(int iPartition, int iBackupTo) {
        if (this.isActivePersistence()) {
            PartitionedService$PartitionControl ctrl = this.getPartitionControl(iPartition);
            if (iBackupTo > 0) {
                ctrl.deletePersistentStore();
            } else {
                PersistentStore store = ctrl.ensurePersistentStore();
                this.saveQuorum(iPartition, store);
                if (!(this.isExiting() ^ true) ? false : this.getServiceState() != Service.SERVICE_STOPPING) {
                    CachePersistenceHelper.seal(store, this, null);
                }
            }
        }
    }

    public void onBackupAssignment(PartitionedService$BackupAssignment msgAssignment) {
        int iPartition = msgAssignment.getPartition();
        int iStore = msgAssignment.getStore();
        com.tangosol.coherence.component.net.Member memberFrom = msgAssignment.getFromMember();
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberFrom = memberFrom.getId();
        int nMemberThis = memberThis.getId();
        int[][] aaiOwner = this.getPartitionAssignments();
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        Component._assert(iStore != 0);
        if (msgAssignment.isRelease()) {
            if (aaiOwner[iPartition][iStore] == nMemberThis) {
                int nBackupNew = msgAssignment.getNewBackupOwner();
                if (setMembers.contains(nBackupNew) ^ true) {
                    nBackupNew = 0;
                }
                this.assignPartitionOwner(iPartition, iStore, nBackupNew);
                this.releasePartition(iPartition, iStore);
                this.releasePartitionControl(iPartition);
                com.tangosol.coherence.component.net.Member memberOwner = ((MemberSet)setMembers).getMember(msgAssignment.getPrimaryOwner());
                if (memberOwner != null) {
                    this.getTransferControl().sendBackupAnnounce(iPartition, iStore, memberOwner, null);
                }
            } else if (aaiOwner[iPartition][0] == nMemberThis) {
                if (owners.getOwner(iStore) == nMemberFrom) {
                    aaiOwner[iPartition][iStore] = 0;
                    this.publishPartitionOwnership(iPartition, iStore, 0);
                } else {
                    Component._trace(new StringBuilder(String.valueOf("Ignoring BackupAssignment for partition ")).append(iPartition).append(" (").append(iStore).append(") received from member ").append(nMemberFrom).toString(), 2);
                }
            } else {
                Component._trace(new StringBuilder(String.valueOf("Ignoring BackupAssignment for un-owned backup(")).append(iStore).append(") of partition ").append(iPartition).append(" from member ").append(nMemberFrom).toString(), 2);
            }
        } else if (aaiOwner[iPartition][0] == nMemberThis) {
            if (iStore >= 0) {
                int nBackupLocal = aaiOwner[iPartition][iStore];
                int nBackupGlobal = owners.getOwner(iStore);
                if (nMemberFrom == nBackupGlobal ? true : nMemberFrom == nBackupLocal) {
                    if (!(nBackupLocal == nBackupGlobal)) {
                        owners = new VersionedOwnership(owners);
                        owners.setOwner(iStore, nBackupLocal);
                        this.putPartitionConfig(iPartition, owners);
                    }
                } else {
                    Component._trace(new StringBuilder(String.valueOf("Ignoring unsolicited BackupAssignment announcement for partition ")).append(iPartition).append(" (backup ").append(iStore).append(") from member ").append(nMemberFrom).append("; (local=").append(nBackupLocal).append(", global=").append(nBackupGlobal).append(")").toString(), 2);
                }
            } else {
                owners = new VersionedOwnership(owners);
                owners.setOwners(aaiOwner[iPartition]);
                this.putPartitionConfig(iPartition, owners);
            }
            this.getPartitionControl(iPartition).enableTransfer();
        } else {
            Component._trace(new StringBuilder(String.valueOf("Ignoring BackupAssignment announcement for un-owned partition ")).append(iPartition).append(" (backup ").append(iStore).append(") from member ").append(nMemberFrom).toString(), 2);
        }
    }

    public void onBackupConfirmRequest(PartitionedService$BackupConfirmRequest msgConfirm) {
        int iPartition = msgConfirm.getPartition();
        int iStore = msgConfirm.getStore();
        com.tangosol.coherence.component.net.Member memberFrom = msgConfirm.getFromMember();
        Component._assert(iStore != 0);
        if (this.getPartitionAssignments()[iPartition][iStore] == this.getThisMember().getId()) {
            this.getTransferControl().sendBackupAnnounce(iPartition, iStore, memberFrom, msgConfirm);
        } else {
            this.getTransferControl().sendBackupRelease(iPartition, iStore, memberFrom.getId(), 0, memberFrom, msgConfirm);
        }
    }

    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        PartitionedServiceDependencies depsPS = (PartitionedServiceDependencies)deps;
        this.setBackupCount(depsPS.getPreferredBackupCount());
        this.setDistributionAggressiveness(depsPS.getDistributionAggressiveness());
        this.setDistributionSynchronized(depsPS.isDistributionSynchronized());
        this.setKeyAssociator(depsPS.getKeyAssociator());
        this.setKeyPartitioningStrategy(depsPS.getKeyPartitioningStrategy());
        this.setOwnershipEnabled(depsPS.isOwnershipCapable());
        this.setPartitionCount(depsPS.getPreferredPartitionCount());
        this.setTransferThreshold(depsPS.getTransferThreshold());
        this.setAsyncBackup(depsPS.isAsyncBackupEnabled());
        PartitionAssignmentStrategy pas = depsPS.getPartitionAssignmentStrategyBuilder().realize(this.createResolver(), this.getContextClassLoader(), null);
        if (pas == null) {
            pas = new SimpleAssignmentStrategy();
        }
        PartitionedService$CentralDistribution strategy = (PartitionedService$CentralDistribution)this._newChild("CentralDistribution");
        strategy.setService(this);
        strategy.setPartitionAssignmentStrategy(pas);
        this.setDistributionStrategy(strategy);
        if (this.isOwnershipEnabled()) {
            List<ParameterizedBuilder<PartitionListener>> listBuilders = depsPS.getPartitionListenerBuilders();
            if (listBuilders != null) {
                Iterator<ParameterizedBuilder<PartitionListener>> iter = listBuilders.iterator();
                while (iter.hasNext()) {
                    ParameterizedBuilder<PartitionListener> bldr = iter.next();
                    this.addPartitionListener(bldr.realize(this.createResolver(), this.getContextClassLoader(), null));
                }
            }
            this.setPersistenceDependencies(depsPS.getPersistenceDependencies());
        }
    }

    protected void onEnter() {
        PersistenceDependencies depsPersistence;
        ParameterizedBuilder bldr;
        try {
            new CoherenceCommunityEdition();
        }
        catch (Exception e) {
            this.setMsgCAE(e.getMessage());
        }
        boolean fOwnershipEnabled = this.isOwnershipEnabled();
        this.getThisMemberConfigMap().put("ownership-enabled", fOwnershipEnabled ? OWNERSHIP_PENDING : OWNERSHIP_DISABLED);
        String sDelayMillis = Config.getProperty("coherence.distributed.deferredbackuptimeout");
        this.setDeferredBackupTimeoutMillis(sDelayMillis == null ? (long)this.getClusterService().getDeliveryTimeoutMillis() : Long.parseLong(sDelayMillis));
        PartitionedService$PersistenceControl ctrlPersistence = (PartitionedService$PersistenceControl)this._newChild("PersistenceControl");
        this.setPersistenceControl(ctrlPersistence);
        if (fOwnershipEnabled && (bldr = (depsPersistence = this.getPersistenceDependencies()) == null ? null : depsPersistence.getPersistenceEnvironmentBuilder()) != null) {
            PersistenceEnvironment env = (PersistenceEnvironment)bldr.realize(this.createResolver(), this.getContextClassLoader(), null);
            ctrlPersistence.setActiveFailureMode(depsPersistence.getFailureMode());
            ctrlPersistence.setAsync(depsPersistence.isAsync());
            ctrlPersistence.setPersistenceEnvironment(env);
            SnapshotArchiver archiver = null;
            SnapshotArchiverFactory factoryArchiver = depsPersistence.getArchiverFactory();
            if (factoryArchiver != null) {
                archiver = factoryArchiver.createSnapshotArchiver(this.getCluster().getClusterName(), this.getServiceName());
                ctrlPersistence.setSnapshotArchiver(archiver);
            }
        }
        super.onEnter();
    }

    protected void onExit() {
        if (this.getPreprocessingGate().close(1000L) ^ true) {
            Component._trace(new StringBuilder(String.valueOf("timeout waiting for ")).append(this.getPreprocessingGate().getActiveCount()).append(" preprocessing threads to complete; abandoning").toString(), 2);
        }
        this.getPersistenceControl().release();
        super.onExit();
        this.getServiceConfigMap().getConfig().removeConfigListener();
        this.getPartitionConfigMap().getConfig().removeConfigListener();
    }

    public void onFinalizeAssignPrimary(Map mapConfig) {
        if (!(mapConfig != null) ? false : mapConfig.isEmpty() ^ true) {
            if (this.checkLockRequired()) {
                Iterator iter = mapConfig.keySet().iterator();
                while (iter.hasNext()) {
                    int iPartition = (Integer)iter.next();
                    PartitionedService$PartitionControl control = this.getPartitionControl(iPartition);
                    control.unlock();
                }
            }
            this.putPartitionConfig(mapConfig);
        }
        this.setOwnershipInProgress(0);
    }

    public void onFinalizeReceivePrimary(PartitionedService$TransferRequest msgLastTransfer) {
        PartitionedService$TransferResponse msgResponse = (PartitionedService$TransferResponse)this.instantiateMessage("TransferResponse");
        msgResponse.respondTo(msgLastTransfer);
        PartitionSet partsLocked = new PartitionSet(this.getPartitionCount());
        PartitionedService$TransferControl ctrlTransfer = this.getTransferControl();
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        com.tangosol.coherence.component.net.Member memberFrom = msgLastTransfer.getFromMember();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int nMemberThis = memberThis.getId();
        int cBackup = this.getBackupCount();
        HashMap<Integer, Integer> mapResponse = new HashMap<Integer, Integer>();
        HashMap<Integer, VersionedOwnership> mapOwners = new HashMap<Integer, VersionedOwnership>();
        int iPart = -1;
        Component._assert(Thread.currentThread() == this.getThread());
        if (ctrlTransfer.isIncomingTransfer(memberFrom) ^ true) {
            Component._trace(new StringBuilder(String.valueOf("Unable to complete distribution from member ")).append(memberFrom.getId()).toString(), 1);
            this.getDistributionStrategy().onDistributionCompleted(memberFrom, false);
            return;
        }
        int[][] aaiOwnerPrev = this.getPartitionAssignments();
        Iterator iterPending = ctrlTransfer.getQueuedTransfers(memberFrom).iterator();
        while (iterPending.hasNext()) {
            int nPrevBackup;
            com.tangosol.coherence.component.net.Member memberTo;
            PartitionedService$TransferRequest msgPending = (PartitionedService$TransferRequest)iterPending.next();
            Component._assert(msgPending.getStore() == 0);
            int iPartPrev = iPart;
            iPart = msgPending.getPartition();
            if (!(iPart != iPartPrev)) continue;
            int nMemberSender = msgPending.getFromMember().getId();
            Integer IPart = iPart;
            int[] aiOwnerPrev = aaiOwnerPrev[iPart];
            if (aiOwnerPrev[0] == nMemberThis) {
                Component._trace(new StringBuilder(String.valueOf("Request to transfer already owned primary partition ")).append(iPart).append(" from member ").append(nMemberSender).toString(), 1);
            }
            PartitionedService$PartitionControl ctrlPart = this.ensurePartitionControl(iPart);
            ctrlPart.lock(-1L, PartitionedService$PartitionControl.LOCK_PRIMARY_XFER_IN);
            partsLocked.add(iPart);
            long lVersionNew = msgPending.getPartitionVersion() + (long)1;
            ctrlPart.getVersionCounter().set(lVersionNew);
            VersionedOwnership ownersOld = msgPending.getOwners();
            this.assignPartitionOwners(iPart, ownersOld.getOwners());
            this.setOwnershipVersion(iPart, ownersOld.getVersion());
            VersionedOwnership owners = this.assignPrimaryPartition(iPart, 'r');
            mapOwners.put(IPart, owners);
            this.validateTransferStrength(ownersOld, owners, iPart);
            int iResponse = PartitionedService$TransferRequest.RESPONSE_RELEASE;
            int iBackup = 1;
            while (iBackup <= cBackup) {
                if (owners.getOwner(iBackup) == nMemberSender) {
                    iResponse = iBackup;
                    break;
                }
                ++iBackup;
            }
            if (iResponse > 0 && (!((memberTo = ((MemberSet)setMembers).getMember(nPrevBackup = aiOwnerPrev[iResponse])) != null) ? false : memberTo != memberThis)) {
                ctrlTransfer.sendBackupRelease(iPart, iResponse, nMemberThis, nMemberSender, memberTo, null);
            }
            mapResponse.put(IPart, iResponse);
            ctrlPart.preventTransfer();
        }
        msgResponse.setPrimaryPartitions(partsLocked);
        msgResponse.setValue(mapResponse);
        List listTransfers = ctrlTransfer.getQueuedTransfers(memberFrom);
        int iLeft = 0;
        int c = listTransfers.size();
        while (iLeft < c) {
            int iPartition = ((PartitionedService$TransferRequest)listTransfers.get(iLeft)).getPartition();
            int iRight = iLeft + 1;
            while (iRight < c) {
                if (((PartitionedService$TransferRequest)listTransfers.get(iRight)).getPartition() != iPartition) break;
                ++iRight;
            }
            this.firePartitionEvent(PartitionEvent.PARTITION_RECEIVE_BEGIN, iPartition, memberFrom, memberThis);
            List listXferRequests = listTransfers.subList(iLeft, iRight);
            this.receivePartition(iPartition, 0, listXferRequests);
            ctrlTransfer.finalizeReceivePartition(iPartition, listXferRequests);
            this.firePartitionEvent(PartitionEvent.PARTITION_RECEIVE_COMMIT, iPartition, memberFrom, memberThis);
            iLeft = iRight;
        }
        ctrlTransfer.onReceiveCommitted(msgLastTransfer);
        this.post(msgResponse);
        PartitionedService$PartitionControl[] aCtrlPartition = this.getPartitionControl();
        iPart = partsLocked.next(0);
        while (iPart >= 0) {
            PartitionedService$PartitionControl ctrlPart = aCtrlPartition[iPart];
            ctrlPart.doSyncBackups();
            ctrlPart.unlock();
            iPart = partsLocked.next(iPart + 1);
        }
        this.putPartitionConfig(mapOwners);
        this.getDistributionStrategy().onDistributionCompleted(memberFrom, true);
    }

    public void onFinalizeRecoverPrimary(PartitionRecoverInfo info) {
        PartitionSet partsAssign;
        PartitionedService$PartitionRecoverRequest msgRequest = (PartitionedService$PartitionRecoverRequest)info.getRequest();
        Map mapConfig = info.getMapConfig();
        PersistenceManager mgrRecover = info.getManager();
        PartitionSet partsRecovered = info.getRecoveredPartitions();
        PartitionSet partsFailed = info.getFailedPartitions();
        Grid$Response msgResponse = (Grid$Response)this.instantiateMessage("Response");
        boolean fSnapshot = mgrRecover != this.getPersistenceManager();
        int iPart = partsFailed.next(0);
        while (iPart >= 0) {
            mapConfig.remove(iPart);
            this.assignPartitionOwner(iPart, 0, 0);
            this.releasePartition(iPart, 0);
            this.releasePartitionControl(iPart);
            iPart = partsFailed.next(iPart + 1);
        }
        msgResponse.respondTo(msgRequest);
        msgResponse.setValue(partsRecovered);
        if (!(mapConfig != null) ? false : mapConfig.isEmpty() ^ true) {
            com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
            Iterator iter = mapConfig.keySet().iterator();
            while (iter.hasNext()) {
                int iPartition = (Integer)iter.next();
                PartitionedService$PartitionControl control = this.getPartitionControl(iPartition);
                this.firePartitionEvent(PartitionEvent.PARTITION_RECOVERED, iPartition, null, memberThis);
                control.setRecovered(false);
                control.unlock();
            }
            this.putPartitionConfig(mapConfig);
            Component._trace(new StringBuilder(String.valueOf("Recovered ")).append(partsRecovered).append(" from ").append(fSnapshot ? "snapshot" : "active").append(" persistent store").toString(), 3);
        }
        Iterator iter = info.getListRequests().iterator();
        while (iter.hasNext()) {
            this.post((Message)iter.next());
        }
        if (fSnapshot) {
            mgrRecover.release();
        }
        if ((partsAssign = msgRequest.getPartsAssign()).isEmpty()) {
            this.post(msgResponse);
        } else {
            PartitionSet partsAssigned;
            Map mapAssigned = msgRequest.getMapAssigned();
            PartitionSet partsLost = msgRequest.getPartsLost();
            if (partsLost != null) {
                Component._trace(new StringBuilder(String.valueOf("Assigned ")).append(partsLost.cardinality()).append(" orphaned primary partitions: ").append(partsLost).toString(), 2);
                this.firePartitionEvent(PartitionEvent.PARTITION_LOST, partsLost, null, this.getThisMember());
            }
            if ((partsAssigned = msgRequest.getPartsAssigned()) != null) {
                this.firePartitionEvent(PartitionEvent.PARTITION_ASSIGNED, partsAssigned, null, this.getThisMember());
            }
            this.onPartitionsAssigned(partsAssigned, partsLost, this.getContinuations().instantiateFinalizeAssignPrimaries(msgRequest.getMapAssigned(), msgResponse));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onFinalizeRestorePrimary(PartitionedService$OwnershipRequest msgRequest, Map mapUpdate) {
        PartitionedService$OwnershipResponse msgResponse = (PartitionedService$OwnershipResponse)this.instantiateMessage("OwnershipResponse");
        msgResponse.respondTo(msgRequest);
        PartitionSet partsRecover = msgRequest.getRecoveryPartitions();
        if (partsRecover != null) {
            String sSnapshot = msgRequest.getSnapshotToRecover();
            PartitionedService$PersistenceControl ctrl = this.getPersistenceControl();
            PersistenceManager mgr = sSnapshot == null ? this.getPersistenceManager() : ctrl.openSnapshot(sSnapshot);
            if (mgr != null) {
                GUIDHelper.GUIDResolver resolver;
                PartitionSet partsGlobal = CachePersistenceHelper.getGlobalPartitions(this);
                String[] asGUID = mgr.list();
                int cParts = this.getPartitionCount();
                int cGUID = asGUID.length;
                ArrayList<String> listRecover = new ArrayList<String>(cGUID);
                ArrayList<String> listGlobal = new ArrayList<String>(1);
                int i = 0;
                while (true) {
                    if (!(i < cGUID)) {
                        resolver = new GUIDHelper.GUIDResolver(cParts);
                        resolver.registerGUIDs(this.getThisMember(), listRecover.toArray(new String[listRecover.size()]));
                        msgResponse.setPersistentIds(resolver.getNewestGUIDs(partsRecover));
                    }
                    String sGUID = asGUID[i];
                    int iPart = GUIDHelper.getPartition(sGUID);
                    if (!(iPart < cParts) ? false : ctrl.isAllowed(sGUID)) {
                        PartitionedService$PartitionControl ctrlPart;
                        PersistentStore store;
                        if (partsRecover.contains(iPart)) {
                            listRecover.add(sGUID);
                        }
                        if ((!partsGlobal.contains(iPart) ? false : sSnapshot == null) && ((store = (ctrlPart = this.getPartitionControl(iPart)) == null ? null : ctrlPart.getPersistentStore()) == null ? true : store.getId().equals(sGUID) ^ true)) {
                            listGlobal.add(sGUID);
                        }
                    }
                    ++i;
                }
                if (sSnapshot == null) {
                    PartitionSet partsOwned = this.collectOwnedPartitions(true);
                    Binary binQuorum = null;
                    if (partsOwned.intersects(partsGlobal)) {
                        binQuorum = this.getPersistenceControl().getQuorumRaw();
                    }
                    if (!(binQuorum == null) ? false : listGlobal.isEmpty() ^ true) {
                        boolean bl;
                        resolver = new GUIDHelper.GUIDResolver(cParts);
                        resolver.registerGUIDs(this.getThisMember(), listGlobal.toArray(new String[listGlobal.size()]));
                        PersistentStore<ReadBuffer> storeGlobal = null;
                        try {
                            try {
                                storeGlobal = mgr.open(resolver.getNewestGUIDs(partsGlobal)[0], null);
                                CachePersistenceHelper.validate(storeGlobal, this);
                                binQuorum = CachePersistenceHelper.readQuorumRaw(storeGlobal);
                            }
                            catch (ConcurrentAccessException e) {
                            }
                            catch (PersistenceException e) {
                                Component._trace(new StringBuilder(String.valueOf("Failed to open a global store: ")).append(Component.getStackTrace(e)).toString(), 1);
                            }
                            Object var19_25 = null;
                            bl = storeGlobal != null;
                        }
                        catch (Throwable throwable) {
                            Object var19_26 = null;
                            if (storeGlobal != null) {
                                mgr.close(storeGlobal.getId());
                            }
                            throw throwable;
                        }
                        if (bl) {
                            mgr.close(storeGlobal.getId());
                        }
                    }
                    msgResponse.setQuorumRaw(binQuorum);
                } else {
                    mgr.release();
                }
            }
        }
        if (!(mapUpdate != null) ? false : mapUpdate.isEmpty() ^ true) {
            PartitionSet parts = new PartitionSet(this.getPartitionCount());
            Iterator iter = mapUpdate.keySet().iterator();
            while (true) {
                if (!iter.hasNext()) {
                    this.putPartitionConfig(mapUpdate);
                    Component._trace(new StringBuilder(String.valueOf("Restored from backup ")).append(parts.cardinality()).append(" partitions: ").append(parts).toString(), 3);
                    break;
                }
                int iPart = (Integer)iter.next();
                PartitionedService$PartitionControl control = this.getPartitionControl(iPart);
                control.doSyncBackups();
                this.firePartitionEvent(PartitionEvent.PARTITION_RECEIVE_COMMIT, iPart, null, this.getThisMember());
                parts.add(iPart);
                control.unlock();
            }
        }
        this.setRestoreInProgress(false);
        msgResponse.setAssignments(this.getPartitionAssignments());
        msgResponse.setSuccess(true);
        this.post(msgResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onFinalizeSendPrimary(PartitionSet parts) {
        PartitionedService$PartitionControl[] aCtrlPartition = this.getPartitionControl();
        PartitionedService$Continuations continuations = this.getContinuations();
        PartitionedService$TransferControl ctrlTransfer = this.getTransferControl();
        PartitionedService$DistributionRequest msgRequest = (PartitionedService$DistributionRequest)ctrlTransfer.getDistributionRequest();
        int iPart = parts.next(0);
        while (iPart >= 0) {
            PartitionedService$PartitionControl ctrl;
            PartitionedService$PartitionControl partitionedService$PartitionControl = ctrl = aCtrlPartition[iPart];
            synchronized (partitionedService$PartitionControl) {
                int cPolls = ctrl.getBackupPolls().get();
                if (cPolls > 0) {
                    Component._trace(new StringBuilder(String.valueOf("Deferring primary transfer for ")).append(parts).append(" to member ").append(msgRequest.getFromMember().getId()).append(" due to ").append(cPolls).append(" outsdanding backups").toString(), 3);
                    ctrl.addBackupsCompletedAction(continuations.wrapAsMessage(continuations.instantiateFinalizeSendPrimary(parts)));
                    return;
                }
            }
            iPart = parts.next(iPart + 1);
        }
        com.tangosol.coherence.component.net.Member memberTo = msgRequest.getFromMember();
        int cParts = parts.cardinality();
        int cSent = 0;
        int iPart2 = parts.next(0);
        while (iPart2 >= 0) {
            if (ctrlTransfer.isTransferFull()) {
                ctrlTransfer.cancelTransmit(iPart2);
                aCtrlPartition[iPart2].unlock();
                parts.remove(iPart2);
            } else {
                this.firePartitionEvent(PartitionEvent.PARTITION_TRANSMIT_BEGIN, iPart2, this.getThisMember(), memberTo);
                this.transferPartition(iPart2, 0, ++cSent == cParts);
            }
            iPart2 = parts.next(iPart2 + 1);
        }
        Component._trace(new StringBuilder(String.valueOf("Transferring primary ")).append(parts).append(" to member ").append(memberTo.getId()).append(" requesting ").append(msgRequest.getPartitionCount()).toString(), 3);
    }

    protected void onFinalizeStartup() {
        this.setAcceptingClients(true);
        this.notifyServiceJoined();
    }

    public void onInit() {
        super.onInit();
        String sScratch = Config.getProperty("coherence.distributed.scratchspace", String.valueOf("50M"));
        this.setScratchSpaceCounter(new AtomicLong(new MemorySize(sScratch).getByteCount()));
        this.setContinuations((PartitionedService$Continuations)this._findChild("Continuations"));
        this.setPartitionConfigMap((PartitionedService$PartitionConfig$Map)((PartitionedService$PartitionConfig)this._findChild("PartitionConfig")).getMap());
    }

    protected void onInterval() {
        if (!(!this.isAcceptingClients() ? false : this.isOwnershipEnabled()) ? false : this.getBackupCount() > 0) {
            int nMemberThis = this.getThisMember().getId();
            int[][] aaiOwner = this.getPartitionAssignments();
            PartitionedService$PartitionControl[] actrlPartition = this.getPartitionControl();
            int iPart = 0;
            int cParts = actrlPartition.length;
            while (iPart < cParts) {
                PartitionedService$PartitionControl ctrlPartition = actrlPartition[iPart];
                if (!(ctrlPartition != null) ? false : aaiOwner[iPart][0] != nMemberThis) {
                    ctrlPartition.checkDeferredBackups();
                }
                ++iPart;
            }
        }
        super.onInterval();
    }

    protected void onNotify() {
        super.onNotify();
        if (this.isExiting() ^ true) {
            if (this.isAcceptingOthers()) {
                long ldtNow = Base.getLastSafeTimeMillis();
                if (ldtNow >= this.getDistributionNextMillis()) {
                    this.checkDistribution();
                }
            } else if (!(this.getServiceState() == Service.SERVICE_STARTED) ? false : this.isFinalizing()) {
                this.finalizeStartup();
            }
        }
    }

    public void onNotifyServiceLeaving(com.tangosol.coherence.component.net.Member member) {
        if (!(!this.isAcceptingClients() ? false : this.isOwnershipEnabled(this.getThisMember())) ? false : this.isOwnershipEnabled(member)) {
            this.getDistributionStrategy().onMembershipChanged(MemberEvent.MEMBER_LEAVING);
            this.getPersistenceControl().onMembershipChanged(MemberEvent.MEMBER_LEAVING);
        }
    }

    public void onNotifyServiceLeft(com.tangosol.coherence.component.net.Member member) {
        boolean fWasOwnershipSenior = member == this.getOwnershipSenior(true);
        boolean fOwner = this.isOwnershipEnabled(member);
        super.onNotifyServiceLeft(member);
        if (fOwner) {
            if (this.isAcceptingClients()) {
                this.validatePartitionAssignments(this.getOwnershipMemberSet(true));
                if (this.isOwnershipEnabled(this.getThisMember())) {
                    this.getTransferControl().onMemberLeft(member);
                    this.getDistributionStrategy().onMembershipChanged(MemberEvent.MEMBER_LEFT);
                    this.getPersistenceControl().onMembershipChanged(MemberEvent.MEMBER_LEFT);
                    if (!fWasOwnershipSenior ? false : this.getOwnershipSenior(true) == this.getThisMember()) {
                        this.onOwnershipSeniority(member);
                    }
                }
            }
            this.getPartitionConfigMap().onServiceLeft(member, fWasOwnershipSenior);
        }
    }

    public void onNotifyServiceQuiescence(boolean fResume, boolean fResumeOnFailover) {
        super.onNotifyServiceQuiescence(fResume, fResumeOnFailover);
        if (!this.isOwnershipEnabled() ? false : this.isAcceptingClients()) {
            if (fResume) {
                this.getDistributionStrategy().scheduleImmediate();
                this.getPersistenceControl().onServiceResume();
            } else {
                this.setDistributionNextMillis(Long.MAX_VALUE);
                this.getPersistenceControl().onServiceSuspend(fResumeOnFailover);
            }
        }
    }

    public void onNotifyShutdown() {
        this.setServiceState(Service.SERVICE_STOPPING);
        if (this.isOwnershipEnabled() ^ true) {
            this.stop();
        } else {
            this.setOwnershipEnabled(false);
        }
    }

    public void onOwnershipRequest(PartitionedService$OwnershipRequest msgRequest) {
        MemberSet setMemberThis = this.getOwnershipMemberSet();
        MemberSet setMemberThat = msgRequest.getSenderMemberSet();
        PartitionedService$OwnershipResponse msgResponse = (PartitionedService$OwnershipResponse)this.instantiateMessage("OwnershipResponse");
        if (this.isOwnershipChangeInProgress() ? true : this.isDistributionInProgress()) {
            Component._trace("Unable to determine the ownership due to in-progress transfer", 3);
        } else if (setMemberThis.equals(setMemberThat) ^ true) {
            StringBuilder sb = new StringBuilder();
            MemberSet setDelta = new MemberSet();
            setDelta.addAll((Collection)setMemberThis);
            setDelta.removeAll((Collection)setMemberThat);
            if (setDelta.isEmpty() ^ true) {
                sb.append(new StringBuilder(String.valueOf("; requestor's member set is missing ")).append(setDelta).toString());
            }
            setDelta.clear();
            setDelta.addAll((Collection)setMemberThat);
            setDelta.removeAll((Collection)setMemberThis);
            if (setDelta.isEmpty() ^ true) {
                sb.append(new StringBuilder(String.valueOf("; requestor's member set has extra ")).append(setDelta).toString());
            }
            Component._trace(new StringBuilder(String.valueOf("Deferring the ownership reconciliation prematurely requested by member ")).append(msgRequest.getFromMember().getId()).append(" due to pending membership change").append(sb.toString()).toString(), 3);
        } else {
            int[][] aaiOwner;
            int[][] aaiOwnerThat = msgRequest.getRequestAssignments();
            if (msgRequest.isQuery()) {
                if (aaiOwnerThat != null) {
                    this.calculateOwnershipConflicts(msgRequest.getFromMember().getId(), aaiOwnerThat, msgRequest.getRequestCount());
                }
                aaiOwner = this.getPartitionAssignments();
                if (msgRequest.getSnapshotToRecover() != null) {
                    PartitionSet partsAbandon = this.collectOwnedPartitions(true);
                    partsAbandon.add(this.collectOwnedPartitions(false));
                    this.abandonPartitions(partsAbandon);
                    aaiOwner = new int[this.getPartitionCount()][this.getBackupCount() + 1];
                }
            } else {
                this.restoreOrphans(msgRequest);
                return;
            }
            msgResponse.setAssignments(aaiOwner);
            msgResponse.setSuccess(true);
        }
        msgResponse.respondTo(msgRequest);
        this.post(msgResponse);
    }

    public void onOwnershipRequestCompleted(PartitionedService$OwnershipRequest msgRequest, int cConflicts) {
        String sSnapshot = msgRequest.getSnapshotToRecover();
        long ldtNow = Base.getSafeTimeMillis();
        if (cConflicts == 0) {
            if (this.getServiceState() == Service.SERVICE_STARTED) {
                Component._assert(this.getThisMember() == this.getOwnershipSenior());
                if (msgRequest.isQuery()) {
                    int[][] aaiOwnersResolved = msgRequest.getConflictResolver().getResolvedAssignments();
                    int cPartitions = this.getPartitionCount();
                    int cBackups = this.getBackupCount();
                    PartitionSet partsRecover = null;
                    int iPart = 0;
                    while (iPart < cPartitions) {
                        int[] aiOwners = aaiOwnersResolved[iPart];
                        boolean fOrphan = true;
                        int iStore = 0;
                        while (iStore <= cBackups) {
                            if (aiOwners[iStore] != 0) {
                                fOrphan = false;
                                break;
                            }
                            ++iStore;
                        }
                        if (fOrphan) {
                            if (partsRecover == null) {
                                partsRecover = this.instantiatePartitionSet(false);
                            }
                            partsRecover.add(iPart);
                        }
                        ++iPart;
                    }
                    MemberSet setOwners = this.getOwnershipMemberSet();
                    PartitionedService$OwnershipRequest msg = (PartitionedService$OwnershipRequest)this.instantiateMessage("OwnershipRequest");
                    msg.setSenderMemberSet(setOwners);
                    msg.setSnapshotToRecover(sSnapshot);
                    msg.setQuery(false);
                    msg.setRecoveryPartitions(partsRecover);
                    msg.setToMemberSet(setOwners);
                    msg.setRequestAssignments(aaiOwnersResolved);
                    this.post(msg);
                } else {
                    this.setOwnershipInProgress(0);
                    PartitionSet partsRecover = msgRequest.getRecoveryPartitions();
                    if (partsRecover == null) {
                        this.setDistributionNextMillis(0);
                    } else {
                        GUIDHelper.GUIDResolver resolver = msgRequest.getPersistentIdResolver();
                        if (sSnapshot != null ? true : this.isRecoverPartitionsAllowed(partsRecover, resolver, msgRequest.getQuorumInfo())) {
                            MemberSet setOwners = this.getOwnershipMemberSet();
                            Set setLeaving = this.getOwnershipLeavingMembers(setOwners);
                            this.getDistributionStrategy().recoverOrphans(partsRecover, setOwners, setLeaving, resolver, sSnapshot);
                        } else {
                            this.setDistributionNextMillis(ldtNow + (long)this.getDistributionRepeatMillis());
                            return;
                        }
                    }
                    if (this.isActivePersistence()) {
                        PartitionSet parts = this.instantiatePartitionSet(false);
                        int[][] aaiOwnersOld = msgRequest.getRequestAssignments();
                        int[][] aaiOwnersNew = this.getPartitionAssignments();
                        int iPart = 0;
                        int cPart = aaiOwnersOld.length;
                        while (iPart < cPart) {
                            if (!(aaiOwnersOld[iPart][0] == 0) ? false : aaiOwnersNew[iPart][0] != 0) {
                                parts.add(iPart);
                            }
                            ++iPart;
                        }
                        if (parts.isEmpty() ^ true) {
                            PartitionedService$PartitionRecoverCleanup msg = (PartitionedService$PartitionRecoverCleanup)this.instantiateMessage("PartitionRecoverCleanup");
                            msg.setPartitions(parts);
                            msg.setToMemberSet(this.getOwnershipMemberSet());
                            this.post(msg);
                        }
                    }
                }
            }
        } else if (sSnapshot == null) {
            this.setDistributionNextMillis(ldtNow + 500L);
            this.setOwnershipInProgress(cConflicts <= 0 ? 0 : -this.getOwnershipInProgress());
        } else {
            PartitionSet partsOrphan = this.collectOrphanPartitions();
            if (partsOrphan.isEmpty() ^ true) {
                Component._trace(new StringBuilder(String.valueOf("Encountered ")).append(cConflicts).append(" unexpected ownership conflicts while attempting to recover ").append(partsOrphan).append(" from snapshot").toString(), 2);
                this.getPersistenceControl().getSnapshotController().onRecoveryCompleted(sSnapshot, partsOrphan);
            }
        }
    }

    public void onOwnershipSeniority(com.tangosol.coherence.component.net.Member memberPreviousSenior) {
        PersistenceEnvironment env = null;
        SnapshotArchiver arch = null;
        PartitionedService$PersistenceControl ctrl = this.getPersistenceControl();
        if (ctrl.isValid()) {
            env = SafePersistenceWrappers.unwrap(ctrl.getPersistenceEnvironment());
            arch = ctrl.getSnapshotArchiver();
            ctrl.onOwnershipSeniority();
        }
        SimpleElement xmlConfig = new SimpleElement("persistence-config");
        xmlConfig.addAttribute("persistence-active-failure-mode").setString((!this.isActivePersistence() ? false : ctrl != null) ? (ctrl.getActiveFailureMode() == PersistenceDependencies.FAILURE_STOP_SERVICE ? "stop-service" : "stop-persistence") : "none");
        xmlConfig.addAttribute("persistence-environment").setString(env == null ? "none" : env.getClass().getName());
        xmlConfig.addAttribute("persistence-mode").setString(this.isActivePersistence() ? "active" : "on-demand");
        xmlConfig.addAttribute("persistence-snapshot-archiver").setString(arch == null ? "none" : arch.getClass().getName());
        this.getThisMemberConfigMap().put("persistence-config", xmlConfig);
    }

    protected void onOwnershipStable() {
        if (this.isActivePersistence()) {
            PartitionSet partsGlobal = CachePersistenceHelper.getGlobalPartitions(this);
            PartitionSet partsOwned = this.collectOwnedPartitions(true);
            partsGlobal.retain(partsOwned);
            int iPart = partsGlobal.next(0);
            while (iPart >= 0) {
                Binary binQuorum = CachePersistenceHelper.writeQuorum(this.ensurePartitionControl(iPart).ensurePersistentStore(), this);
                if (this.isVersionCompatible(this.getOwnershipMemberSet(), 12, 2, 1, 1, 0)) {
                    this.getPartitionConfigMap().put(PartitionedService$PartitionConfig.KEY_QUORUM, binQuorum);
                }
                iPart = partsGlobal.next(iPart + 1);
            }
            this.getPersistenceControl().setForceRecovery(false);
        }
        Component._trace(new StringBuilder(String.valueOf("Partition ownership has stabilized with ")).append(this.getOwnershipMemberSet().size()).append(" nodes").toString(), 3);
    }

    public void onPartitionAbandonRequest(PartitionedService$PartitionAbandonRequest msgRequest) {
        this.abandonPartitions(msgRequest.getPartitionSet());
    }

    /*
     * Unable to fully structure code
     */
    public void onPartitionConfigUpdate(MapEvent event) {
        setMembers = this.getServiceMemberSet();
        nMemberThis = this.getThisMember().getId();
        cBackups = this.getBackupCount();
        iPartition = (Integer)event.getKey();
        owners = (VersionedOwnership)event.getNewValue();
        ownersPrev = (VersionedOwnership)event.getOldValue();
        aaiOwner = this.getPartitionAssignments();
        nOwnedIndex = this.getOwnedIndex(iPartition, nMemberThis);
        fPrimeOwner = nOwnedIndex == 0;
        fBackupOwner = nOwnedIndex > 0;
        fRepublish = false;
        iStore = 0;
        while (iStore <= cBackups) {
            block19: {
                block22: {
                    block21: {
                        block20: {
                            block18: {
                                nOwnerLocal = aaiOwner[iPartition][iStore];
                                nOwnerGlobal = ownersPrev == null != false ? 0 : ownersPrev.getOwner(iStore);
                                nOwnerNew = owners.getOwner(iStore);
                                nVersionLocal = this.getOwnershipVersion(iPartition);
                                nVersionGlobal = ownersPrev == null != false ? 0 : ownersPrev.getVersion();
                                nVersionNew = owners.getVersion();
                                if (!fPrimeOwner) break block18;
                                if ((nOwnerNew != nOwnerLocal == false ? false : nOwnerNew != nOwnerGlobal) != false ? true : ((iStore == 0 == false ? false : nVersionNew != nVersionLocal) == false ? false : nVersionNew != nVersionGlobal)) {
                                    Component._trace(new StringBuilder(String.valueOf("Obsolete partition info; restoring ")).append(iStore == 0 != false ? "primary" : new StringBuilder(String.valueOf("backup[")).append(iStore).append("]").toString()).append(" owner for partition ").append(iPartition).append(" from member ").append(nOwnerNew).append(" at version ").append(nVersionNew).append(" to ").append(nOwnerGlobal).append(nOwnerLocal == nOwnerGlobal != false ? "" : new StringBuilder(String.valueOf(" (local=")).append(nOwnerLocal).append(")").toString()).append(" at version ").append(nVersionGlobal).append("").append(nVersionLocal == nVersionGlobal != false ? "" : new StringBuilder(String.valueOf(" (local=")).append(nVersionLocal).append(")").toString()).toString(), 3);
                                    owners.setOwner(iStore, nOwnerGlobal);
                                    owners.setVersion(nVersionGlobal);
                                    fRepublish = true;
                                } else if (iStore == 0) {
                                    this.onPrimaryOwnershipChanged(iPartition);
                                }
                                break block19;
                            }
                            if (!(iStore == 0 == false ? false : nOwnerNew == nMemberThis)) break block20;
                            Component._trace(new StringBuilder(String.valueOf("Rejecting obsolete ownership update for partition ")).append(iPartition).append("[").append(nOwnerLocal).append("]").toString(), 3);
                            if (nOwnerLocal == 0) {
                                owners.setPrimaryOwner(0);
                                fRepublish = true;
                                break;
                            }
                            owners.setOwners(ownersPrev);
                            break block19;
                        }
                        if (!(nOwnerNew > 0 == false ? false : setMembers.getMember(nOwnerNew) == null)) break block21;
                        Component._trace(new StringBuilder(String.valueOf("Ignoring obsolete ")).append(iStore == 0 != false ? "primary" : new StringBuilder(String.valueOf("backup[")).append(iStore).append("]").toString()).append(" partition info for partition ").append(iPartition).append("; member ").append(nOwnerNew).append(" has departed").toString(), 3);
                        if (nOwnerLocal == nMemberThis) {
                            owners.setOwner(iStore, nOwnerGlobal);
                        } else {
                            owners.setOwner(iStore, 0);
                            aaiOwner = this.assignPartitionOwner(iPartition, iStore, 0);
                            if (iStore == 0) {
                                this.onPrimaryOwnershipChanged(iPartition);
                            }
                        }
                        break block19;
                    }
                    if (!(nOwnerNew != nOwnerLocal)) break block22;
                    if (!(this.getServiceState() != Service.SERVICE_STOPPING)) ** GOTO lbl67
                    if (nOwnerNew == nMemberThis) {
                        Component._trace(new StringBuilder(String.valueOf("Deferring ")).append("backup[").append(iStore).append("]").append(" partition ownership for partition ").append(iPartition).append(" (owners=").append(owners).append(")").toString(), 3);
                        if (this.isBackupOwner(iPartition) ^ true) {
                            owners.setOwner(iStore, 0);
                            fRepublish = true;
                            ctrlTransfer = this.getTransferControl();
                            if (ctrlTransfer.isTransferInProgress(iPartition) ^ true && (memberOwner = setMembers.getMember(nOwner = aaiOwner[iPartition][0])) != null) {
                                ctrlTransfer.sendBackupRelease(iPartition, iStore, nOwner, 0, memberOwner, null);
                            }
                        }
                    } else if (nOwnerLocal == nMemberThis) {
                        Component._trace(new StringBuilder(String.valueOf("Deferring backup[")).append(iStore).append("] release for partition ").append(iPartition).append(" (owners=").append(owners).append(")").toString(), 3);
                    } else {
                        if (((iStore == 0 == false ? false : nOwnerNew == 0) == false ? false : nOwnerLocal != 0) == false ? false : this.isOwnershipEnabled()) {
                            this.setDistributionNextMillis(0L);
                        }
lbl67:
                        // 4 sources

                        this.setOwnershipVersion(iPartition, nVersionNew);
                        aaiOwner = this.assignPartitionOwner(iPartition, iStore, nOwnerNew);
                        if (iStore == 0) {
                            this.onPrimaryOwnershipChanged(iPartition);
                        }
                    }
                    break block19;
                }
                if (nVersionNew != nVersionLocal) {
                    this.setOwnershipVersion(iPartition, nVersionNew);
                    this.onPrimaryOwnershipChanged(iPartition);
                }
            }
            ++iStore;
        }
        if (fRepublish == false ? false : this.isOwnershipEnabled()) {
            this.putPartitionConfig(iPartition, owners);
        }
    }

    public void onPartitionRecoverCleanup(PartitionedService$PartitionRecoverCleanup msg) {
        PersistenceManager mgrActive = this.getPersistenceManager();
        Component._assert(mgrActive != null);
        PartitionSet parts = msg.getPartitions();
        if (parts.isEmpty() ^ true) {
            String[] asGUIDs = mgrActive.list();
            int i = 0;
            int c = asGUIDs == null ? 0 : asGUIDs.length;
            while (i < c) {
                String sGUID = asGUIDs[i];
                int iPart = GUIDHelper.getPartition(sGUID);
                if (!(iPart < this.getPartitionCount()) ? false : parts.contains(iPart)) {
                    boolean fEligible;
                    VersionedOwnership owners = this.getPartitionConfig(iPart);
                    ServiceMemberSet setMembers = this.getServiceMemberSet();
                    int nMemberOwner = owners.getPrimaryOwner();
                    int nMemberStore = GUIDHelper.getMemberId(sGUID);
                    int nMemberThis = this.getThisMember().getId();
                    long ldtJoinStore = GUIDHelper.getServiceJoinTime(sGUID);
                    boolean bl = !(!(!(nMemberOwner > 0) ? false : nMemberStore != nMemberOwner) ? false : ldtJoinStore != setMembers.getServiceJoinTime(nMemberOwner)) ? false : (fEligible = GUIDHelper.getVersion(sGUID) < (long)owners.getVersion());
                    if ((!fEligible ? false : ((!(nMemberThis == nMemberStore) ? false : setMembers.getServiceJoinTime(nMemberThis) == ldtJoinStore) ? true : ldtJoinStore != setMembers.getServiceJoinTime(nMemberStore))) && mgrActive.delete(sGUID, false)) {
                        Component._trace(new StringBuilder(String.valueOf("Removed old partition (")).append(sGUID).append(") from active persistent directory store").toString(), 7);
                    }
                }
                ++i;
            }
        }
    }

    public void onPartitionRecoverJob(PartitionedService$PartitionRecoverRequest$RecoverJob job) {
        PartitionRecoverInfo info = job.getRecoverInfo();
        List listGUID = job.getListGUID();
        int cGUID = listGUID.size();
        HashMap<Integer, PersistentStore> mapStoresFrom = new HashMap<Integer, PersistentStore>(cGUID);
        PartitionSet partsFail = this.instantiatePartitionSet(false);
        PersistenceManager mgrRecover = info.getManager();
        String[] asGUID = listGUID.toArray(new String[cGUID]);
        boolean fSnapshot = this.getPersistenceControl().getActiveManager() != mgrRecover;
        if (mgrRecover != null) {
            int i = 0;
            while (!(i < cGUID) ? false : this.getServiceState() < Service.SERVICE_STOPPING) {
                String sGUID = asGUID[i];
                int iPart = GUIDHelper.getPartition(sGUID);
                try {
                    mapStoresFrom.put(iPart, this.openStoreForRead(mgrRecover, sGUID, fSnapshot));
                    if ((i & 0xF) == 15) {
                        this.heartbeat();
                    }
                }
                catch (PersistenceException e) {
                    partsFail.add(iPart);
                    this.onStoreOpenFailed(mgrRecover, iPart, sGUID, e);
                }
                ++i;
            }
        }
        Map mapStoresTo = this.openStores(mgrRecover, mapStoresFrom, partsFail);
        this.recoverPartitions(job, mapStoresFrom, mapStoresTo, partsFail);
    }

    public void onPartitionSwapRequest(PartitionedService$PartitionSwapRequest msgRequest) {
        Component._assert(this.isOwnershipEnabled());
        int iPartition = msgRequest.getPartition();
        int iStoreLow = msgRequest.getPromoteIndex();
        int iStoreHigh = iStoreLow + 1;
        this.assignPartitionOwners(iPartition, msgRequest.getOwners().getOwners());
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        int nMemberToPromote = aiOwner[iStoreHigh];
        aiOwner[iStoreHigh] = aiOwner[iStoreLow];
        aiOwner[iStoreLow] = nMemberToPromote;
    }

    protected void onPartitionsAssigned(PartitionSet partsAssigned, PartitionSet partsLost, Continuation continuation) {
    }

    public void onPartitionsRecovered(PartitionSet partsRecovered, String sSnapshotName, Continuation continuation) {
    }

    protected void onPartitionsRestored(PartitionSet partsRestored, Continuation continuation) {
    }

    public void onPrimaryOwnershipChanged(int nPartition) {
        if (this.getPartitionAssignments()[nPartition][0] != 0) {
            this.clearContention(nPartition);
        }
        if (this.isOwnershipEnabled(this.getThisMember())) {
            this.getPersistenceControl().onPrimaryOwnershipChanged(nPartition);
            this.setDistributionStable(false);
        }
    }

    public void onRecoverFailed(PersistenceManager mgrRecover, String sGUID, boolean fDelete) {
        if (this.getServiceState() < Service.SERVICE_STOPPING) {
            if (this.isSnapshotManager(mgrRecover)) {
                mgrRecover.close(sGUID);
            } else if (fDelete) {
                mgrRecover.delete(sGUID, true);
            }
        }
    }

    public void onServiceStarted() {
        if (this.validateServiceConfig() ^ true) {
            this.setOwnershipEnabled(false);
            this.post(this.instantiateMessage("NotifyShutdown"));
            return;
        }
        KeyAssociator associator = this.getKeyAssociator();
        KeyPartitioningStrategy partitioning = this.getKeyPartitioningStrategy();
        int cPartitions = this.getPartitionCount();
        this.setPartitionContention(new PartitionedService$Contention[cPartitions]);
        this.setPartitionAssignments(new int[cPartitions][this.getBackupCount() + 1]);
        this.setOwnershipVersion(new int[cPartitions]);
        PartitionedService$ConverterKeyToBinary convKeyDown = this.instantiateKeyToBinaryConverter(null, false);
        this.setKeyToBinaryConverter(convKeyDown);
        associator.init(this);
        if (partitioning == null) {
            this.setKeyPartitioningStrategy(convKeyDown);
        } else {
            partitioning.init(this);
        }
        if (this.isOwnershipEnabled()) {
            int cDaemonsMax;
            PersistenceManager mgrActive;
            this.setPartitionControl(new PartitionedService$PartitionControl[cPartitions]);
            PartitionedService$PersistenceControl ctrlPersistence = this.getPersistenceControl();
            DaemonPool pool = null;
            int cDaemons = this.getDependencies().getWorkerThreadCountMin();
            this.setConcurrent(cDaemons != 0);
            if (cDaemons > 0) {
                pool = this.getDaemonPool();
                pool.setThreadGroup(new ThreadGroup(this.getServiceName()));
                PersistenceEnvironment env = SafePersistenceWrappers.unwrap(ctrlPersistence.getPersistenceEnvironment());
                if (env instanceof AbstractPersistenceEnvironment) {
                    ((AbstractPersistenceEnvironment)env).setDaemonPool(pool);
                }
            }
            if ((!((mgrActive = ctrlPersistence.openActiveManager()) != null) ? false : cDaemons == 1) && (cDaemonsMax = pool.getDaemonCountMax()) > 2) {
                pool.setDaemonCountMin(Math.min(Math.max(Platform.getPlatform().getFairShareProcessors(), 2), cDaemonsMax - 1));
            }
            if (pool != null) {
                pool.start();
            }
            this.ensureEventDispatcher();
        }
        this.getServiceConfigMap().getConfig().attachConfigListener();
        this.getPartitionConfigMap().getConfig().attachConfigListener();
        this.getDistributionStrategy().initialize();
        this.finalizeStartup();
    }

    protected void onServiceStopping() {
        if (this.getThisMember() == this.getOwnershipSenior()) {
            this.setDistributionNextMillis(0L);
        }
    }

    public void onStoreOpenFailed(PersistenceManager mgrRecover, int nPartition, String sGUID, PersistenceException e) {
        if (e instanceof FatalAccessException) {
            String sMsg = new StringBuilder(String.valueOf("Failed to recover partition ")).append(nPartition).append(" (GUID=").append(sGUID).append("); ").append(e.getMessage()).toString();
            if (this.getServiceState() < Service.SERVICE_STOPPING) {
                if (this.isSnapshotManager(mgrRecover)) {
                    mgrRecover.close(sGUID);
                } else {
                    mgrRecover.delete(sGUID, true);
                    sMsg = new StringBuilder(String.valueOf(sMsg)).append("; reinstate persistent store from trash once validation errors have been resolved").toString();
                }
            }
            Component._trace(new StringBuilder(String.valueOf(sMsg)).append('\n').append(e.getMessage()).append('\n').append(Base.getStackTrace(e)).toString(), 2);
        } else {
            Component._trace(new StringBuilder(String.valueOf("Failed to recover partition ")).append(nPartition).append(" from the persistent storage (GUID=").append(sGUID).append("); excluded from future recovery requests: ").append(Component.getStackTrace(e)).toString(), 3);
            this.getPersistenceControl().onTransientException(sGUID);
        }
    }

    public void onTransferCompleted(boolean fSuccess, Object oResult, PartitionedService$TransferRequest msg) {
    }

    public void onTransferRequest(PartitionedService$TransferRequest msgRequest) {
        Component._assert(this.isDistributionInProgress() ? true : msgRequest.getStore() > 0);
        PartitionedService$TransferControl ctrlTransfer = this.getTransferControl();
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        boolean fLastInPartition = msgRequest.isLastInPartition();
        boolean fLastInTransfer = msgRequest.isLastInTransfer();
        int iPartition = msgRequest.getPartition();
        PartitionedService$PartitionControl ctrlPart = this.getPartitionControl(iPartition);
        if (!(!this.isAcceptingClients() ? false : this.isOwnershipEnabled()) ? false : (ctrlPart == null ? true : ctrlPart.isLocked() ^ true)) {
            int iStore = msgRequest.getStore();
            Span augmentSpan = TracingHelper.augmentSpan();
            augmentSpan.setMetadata("partition", iPartition);
            augmentSpan.setMetadata("replica", iStore);
            if (iStore == 0) {
                Continuation continuation = null;
                if (fLastInTransfer) {
                    continuation = this.getContinuations().instantiateFinalizeReceivePrimary(msgRequest);
                } else {
                    PartitionedService$TransferResponse msgResponse = (PartitionedService$TransferResponse)this.instantiateMessage("TransferResponse");
                    msgResponse.respondTo(msgRequest);
                    msgResponse.setValue(PartitionedService$TransferRequest.RESPONSE_INCOMPLETE);
                    this.post(msgResponse);
                }
                ctrlTransfer.onReceiveStarted(msgRequest, continuation);
            } else {
                int[][] aaiOwner = this.getPartitionAssignments();
                ctrlTransfer.onReceiveStarted(msgRequest, null);
                if (fLastInPartition) {
                    this.preparePartition(iPartition, iStore);
                    com.tangosol.coherence.component.net.Member memberPrimary = msgRequest.getFromMember();
                    List listXfersIn = ctrlTransfer.getQueuedTransfers(memberPrimary);
                    this.receivePartition(iPartition, iStore, listXfersIn);
                    listXfersIn.clear();
                    PartitionedService$PartitionControl ctrlPartition = this.ensurePartitionControl(iPartition);
                    ctrlPartition.getVersionCounter().set(msgRequest.getPartitionVersion());
                    aaiOwner[iPartition][iStore] = memberThis.getId();
                    int nPrevBackup = msgRequest.getOwners().getOwner(iStore);
                    com.tangosol.coherence.component.net.Member memberPrev = ((MemberSet)setMembers).getMember(nPrevBackup);
                    if (memberPrev == null) {
                        ctrlTransfer.sendBackupAnnounce(iPartition, iStore, memberPrimary, null);
                    } else {
                        ctrlTransfer.sendBackupRelease(iPartition, iStore, memberPrimary.getId(), memberThis.getId(), memberPrev, null);
                    }
                }
                if (fLastInTransfer) {
                    ctrlTransfer.onReceiveCommitted(msgRequest);
                }
                PartitionedService$TransferResponse msgResponse = (PartitionedService$TransferResponse)this.instantiateMessage("TransferResponse");
                msgResponse.respondTo(msgRequest);
                msgResponse.setValue(fLastInPartition ? PartitionedService$TransferRequest.RESPONSE_RELEASE : PartitionedService$TransferRequest.RESPONSE_INCOMPLETE);
                this.post(msgResponse);
            }
        } else {
            PartitionedService$TransferResponse msgResponse = (PartitionedService$TransferResponse)this.instantiateMessage("TransferResponse");
            msgResponse.respondTo(msgRequest);
            msgResponse.setValue(PartitionedService$TransferRequest.RESPONSE_REJECT);
            this.post(msgResponse);
        }
    }

    public void onTransferRequestCompleted(PartitionedService$TransferRequest msgRequest) {
        if (this.getServiceState() == Service.SERVICE_STOPPED) {
            return;
        }
        Object oResult = msgRequest.getResponse();
        int[][] aaiOwner = this.getPartitionAssignments();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        PartitionedService$TransferControl ctrlTransfer = this.getTransferControl();
        PartitionedService$PartitionControl[] aCtrlPartition = this.getPartitionControl();
        boolean fPrimary = msgRequest.getStore() == 0;
        if (fPrimary) {
            if (oResult instanceof Integer) {
                int iResult = (Integer)oResult;
                if (iResult == PartitionedService$TransferRequest.RESPONSE_REJECT) {
                    if (msgRequest.isLastInTransfer()) {
                        HashMap<Integer, VersionedOwnership> mapOwners = new HashMap<Integer, VersionedOwnership>();
                        PartitionSet partsLocked = new PartitionSet(this.getPartitionCount());
                        PartitionedService$TransferControl$TransferIterator iter = ctrlTransfer.iterateTransfersInProgress();
                        while (iter.hasNext()) {
                            iter.next();
                            int iPartition = iter.getPartition();
                            int iStore = iter.getBackup();
                            int nOwner = aaiOwner[iPartition][0];
                            Component._assert(iStore == 0);
                            if (!(nOwner != nMemberThis)) continue;
                            int nMemberRecipient = msgRequest.getRecipient().getId();
                            Component._trace(new StringBuilder(String.valueOf("Failed primary transfer for partition ")).append(iPartition).append(" to member ").append(nMemberRecipient).append("; reclaiming the ownership from member ").append(nOwner).toString(), 3);
                            this.incrementOwnershipVersion(iPartition);
                            int nVersionNew = this.incrementOwnershipVersion(iPartition);
                            this.assignPartitionOwner(iPartition, 0, nMemberThis);
                            if (this.isActivePersistence()) {
                                aCtrlPartition[iPartition].updatePersistentStoreVersion();
                            }
                            this.firePartitionEvent(PartitionEvent.PARTITION_TRANSMIT_ROLLBACK, iPartition, null, memberThis);
                            VersionedOwnership owners = new VersionedOwnership(this.getPartitionConfig(iPartition));
                            owners.setOwner(0, nMemberThis);
                            owners.setVersion(nVersionNew);
                            mapOwners.put(iPartition, owners);
                            ctrlTransfer.onTransmitRejected(iPartition, 0);
                            partsLocked.add(iPartition);
                            if (setMembers.contains(nMemberRecipient)) continue;
                            int cBackups = this.getBackupCount();
                            int iBackup = 1;
                            while (iBackup <= cBackups) {
                                int nBackupOwner = owners.getOwner(iBackup);
                                com.tangosol.coherence.component.net.Member memberBackup = ((MemberSet)setMembers).getMember(nBackupOwner);
                                if (memberBackup != null) {
                                    ctrlTransfer.requestBackupConfirmation(iPartition, iBackup, nMemberRecipient, memberBackup);
                                }
                                ++iBackup;
                            }
                        }
                        int iPart = partsLocked.next(0);
                        while (iPart >= 0) {
                            aCtrlPartition[iPart].unlock();
                            iPart = partsLocked.next(iPart + 1);
                        }
                        Component._assert(this.isTransferInProgress() ^ true);
                        this.putPartitionConfig(mapOwners);
                    }
                } else {
                    Component._assert(iResult == PartitionedService$TransferRequest.RESPONSE_INCOMPLETE);
                }
            } else {
                Map mapResponses = (Map)oResult;
                Iterator iter = mapResponses.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    int iPartition = (Integer)entry.getKey();
                    int iResult = (Integer)entry.getValue();
                    if (iResult == PartitionedService$TransferRequest.RESPONSE_RELEASE) {
                        this.releasePartition(iPartition, 0);
                    } else {
                        Component._assert(iResult > 0);
                        this.movePartition(iPartition, iResult);
                        aaiOwner[iPartition][iResult] = nMemberThis;
                    }
                    int nMemberTo = msgRequest.getRecipient().getId();
                    this.firePartitionEvent(PartitionEvent.PARTITION_TRANSMIT_COMMIT, iPartition, memberThis, ((MemberSet)setMembers).getMember(nMemberTo));
                    ctrlTransfer.onTransmitCompleted(iPartition, 0);
                    PartitionedService$PartitionControl control = aCtrlPartition[iPartition];
                    control.flushDeferredBackups();
                    control.unlock();
                    if (!(iResult == PartitionedService$TransferRequest.RESPONSE_RELEASE)) continue;
                    this.releasePartitionControl(iPartition);
                }
                Component._assert(this.isTransferInProgress() ^ true);
            }
        } else {
            int iPartition = msgRequest.getPartition();
            int iStore = msgRequest.getStore();
            if (aaiOwner[iPartition][0] == nMemberThis) {
                int iResult = (Integer)oResult;
                if (iResult == PartitionedService$TransferRequest.RESPONSE_REJECT) {
                    if (msgRequest.isLastInPartition()) {
                        VersionedOwnership owners = this.getPartitionConfig(iPartition);
                        int nBackupLocal = aaiOwner[iPartition][iStore];
                        int nBackupGlobal = owners.getOwner(iStore);
                        int nMemberRecipient = msgRequest.getRecipient().getId();
                        Component._assert(nBackupLocal == nMemberRecipient);
                        Component._trace(new StringBuilder(String.valueOf("Failed backup transfer for partition ")).append(iPartition).append(" to member ").append(nMemberRecipient).toString(), 3);
                        ctrlTransfer.onTransmitRejected(iPartition, iStore);
                        if (!(nBackupLocal == nBackupGlobal)) {
                            com.tangosol.coherence.component.net.Member memberOwnerPrev = ((MemberSet)setMembers).getMember(nBackupGlobal);
                            if (memberOwnerPrev == null) {
                                aaiOwner[iPartition][iStore] = 0;
                                this.publishPartitionOwnership(iPartition, iStore, 0);
                                this.getPartitionControl(iPartition).enableTransfer();
                            } else {
                                aaiOwner[iPartition][iStore] = nBackupGlobal;
                                if (setMembers.contains(nMemberRecipient)) {
                                    this.getPartitionControl(iPartition).enableTransfer();
                                } else {
                                    ctrlTransfer.requestBackupConfirmation(iPartition, iStore, nMemberRecipient, memberOwnerPrev);
                                }
                            }
                        }
                    }
                } else if (iResult == PartitionedService$TransferRequest.RESPONSE_RELEASE) {
                    if (msgRequest.isLastInPartition()) {
                        ctrlTransfer.onTransmitCompleted(iPartition, iStore);
                    }
                } else {
                    Component._assert(iResult == PartitionedService$TransferRequest.RESPONSE_INCOMPLETE);
                }
                if (msgRequest.isLastInTransfer()) {
                    Component._assert(this.isTransferInProgress() ^ true);
                }
            } else {
                Component._trace(new StringBuilder(String.valueOf("Partition ")).append(iPartition).append(" ownership was transferred to member ").append(aaiOwner[iPartition][0]).append(" without consent:\n").append(this.getPartitionConfig(iPartition)).toString(), 1);
            }
        }
        if (this.isTransferInProgress() ^ true) {
            this.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)(fPrimary ? 0 : this.getDistributionRepeatMillis() / this.getDistributionAggressiveness()));
            this.getDistributionStrategy().setStatsSampleNextMillis(Base.getSafeTimeMillis() + 1000L);
        }
    }

    protected PersistentStore openStoreForRead(PersistenceManager mgr, String sGUID, boolean fOpen) {
        if (fOpen) {
            int cRetry = 0;
            while (true) {
                try {
                    PersistentStore store = mgr.open(sGUID, null);
                    CachePersistenceHelper.validate(store, this);
                    return store;
                }
                catch (ConcurrentAccessException e) {
                    if (cRetry > 100) {
                        throw new FatalAccessException((Throwable)e);
                    }
                    Daemon.sleep(10L);
                    ++cRetry;
                    continue;
                }
                break;
            }
        }
        return mgr.createStore(sGUID);
    }

    public Map openStores(PersistenceManager mgrRecover, Map mapStores, PartitionSet partsFail) {
        HashMap<Integer, PersistentStore> mapStoresTo = new HashMap<Integer, PersistentStore>(mapStores.size());
        if (mapStores.isEmpty() ^ true) {
            boolean fSnapshot = mgrRecover != this.getPersistenceManager();
            Component._trace(new StringBuilder(String.valueOf("Recovering ")).append(mapStores.size()).append(" partitions").toString(), 5);
            Iterator iter = mapStores.entrySet().iterator();
            while (!iter.hasNext() ? false : this.getServiceState() < Service.SERVICE_STOPPING) {
                PersistentStore storeTo;
                Integer IPartition;
                block5: {
                    Map.Entry entry = iter.next();
                    IPartition = (Integer)entry.getKey();
                    int nPartition = IPartition;
                    PersistentStore storeFrom = (PersistentStore)entry.getValue();
                    String sGUID = storeFrom.getId();
                    this.heartbeat();
                    storeTo = null;
                    if (this.isActivePersistence()) {
                        try {
                            storeTo = this.getPartitionControl(nPartition).ensurePersistentStore(storeFrom);
                            CachePersistenceHelper.validate(storeTo, this);
                            CachePersistenceHelper.unseal(storeTo);
                            break block5;
                        }
                        catch (PersistenceException e) {
                            PersistentStore<?> storeFailed;
                            partsFail.add(nPartition);
                            this.onStoreOpenFailed(mgrRecover, nPartition, sGUID, e);
                            if (!(storeTo == null) || !((storeFailed = e.getPersistentStore()) != null)) continue;
                            mgrRecover.delete(storeFailed.getId(), false);
                            continue;
                        }
                    }
                    storeTo = storeFrom;
                }
                mapStoresTo.put(IPartition, storeTo);
            }
        }
        return mapStoresTo;
    }

    protected boolean pinOwnedPartition(int nPartition) {
        return this.pinOwnedPartition(nPartition, -1);
    }

    protected boolean pinOwnedPartition(int nPartition, int nVersion) {
        boolean fEntered = false;
        if (!(!(this.isConcurrent() ^ true ? true : (fEntered = this.enterPartition(nPartition))) ? false : this.isPrimaryOwner(nPartition)) ? false : (nVersion == -1 ? true : nVersion == this.getOwnershipVersion(nPartition))) {
            return true;
        }
        if (fEntered) {
            this.exitPartition(nPartition);
        }
        return false;
    }

    protected PartitionSet pinOwnedPartitions(PartitionSet partitions) {
        return this.pinOwnedPartitions(partitions, null);
    }

    protected PartitionSet pinOwnedPartitions(PartitionSet partitions, PartitionVersions versions) {
        boolean fConcurrent = this.isConcurrent();
        PartitionSet partsOther = null;
        int nPartition = partitions.next(0);
        while (nPartition >= 0) {
            int nVersion;
            int n = nVersion = versions == null ? -1 : versions.getVersion(nPartition);
            if (this.pinOwnedPartition(nPartition, nVersion) ^ true) {
                if (partsOther == null) {
                    partsOther = new PartitionSet(this.getPartitionCount());
                }
                partsOther.add(nPartition);
                partitions.remove(nPartition);
            }
            nPartition = partitions.next(nPartition + 1);
        }
        return partsOther;
    }

    protected void preparePartition(int iPartition, int iBackup) {
    }

    public void processBackup(BackupSingleRequest msgBackup) {
        long lVersionNew;
        int iPartition = msgBackup.getPartition();
        PartitionedService$PartitionControl control = this.getPartitionControl(iPartition);
        AtomicLong counter = control.getVersionCounter();
        long lVersionExpect = counter.get() + (long)1;
        if (lVersionExpect > (lVersionNew = msgBackup.getPartitionVersion())) {
            Component._trace(new StringBuilder(String.valueOf("Ignoring repeated backup update (version ")).append(lVersionNew).append(") for partition ").append(msgBackup.getPartition()).append("; current version is ").append(lVersionExpect).toString(), 5);
            msgBackup.forwardOrReply(msgBackup);
        } else if (lVersionExpect < lVersionNew ? true : (!(this.isBackupOwner(iPartition) ^ true) ? false : control.isTransferringOut())) {
            control.deferBackup(msgBackup, lVersionNew);
        } else {
            msgBackup.forwardOrReply(msgBackup);
            msgBackup.doBackup();
            counter.set(lVersionNew);
            control.flushDeferredBackups();
        }
    }

    public void processBackupMulti(BackupMultiRequest msgBackup) {
        PartitionSet parts = msgBackup.getPartitionSet();
        PartitionSet partsDefer = null;
        PrimitiveSparseArray paVersions = msgBackup.getPartitionVersions();
        int iPartition = parts.next(0);
        while (iPartition >= 0) {
            long lVersionNew;
            PartitionedService$PartitionControl control = this.getPartitionControl(iPartition);
            long lVersionExpect = control.getVersionCounter().get() + (long)1;
            if (lVersionExpect > (lVersionNew = paVersions.getPrimitive(iPartition))) {
                Component._trace(new StringBuilder(String.valueOf("Ignoring repeated backup update (version ")).append(lVersionNew).append(") for partition ").append(iPartition).append("; current version is ").append(lVersionExpect).toString(), 5);
                parts.remove(iPartition);
                msgBackup.skipPartition(iPartition);
            } else if (lVersionExpect < lVersionNew ? true : (!(this.isBackupOwner(iPartition) ^ true) ? false : control.isTransferringOut())) {
                if (partsDefer == null) {
                    partsDefer = new PartitionSet(parts.getPartitionCount());
                }
                partsDefer.add(iPartition);
            }
            iPartition = parts.next(iPartition + 1);
        }
        PartitionSet partsSkip = msgBackup.getSkipPartitions();
        if (partsDefer == null) {
            msgBackup.forwardOrReply(msgBackup);
        } else {
            parts.remove(partsDefer);
            int iPartition2 = partsDefer.next(0);
            PartitionedService$PartitionControl control = this.getPartitionControl(iPartition2);
            control.deferBackup(msgBackup, paVersions.getPrimitive(iPartition2));
            if (partsSkip != null) {
                partsDefer.add(partsSkip);
            }
            partsSkip = partsDefer;
        }
        if (parts.isEmpty() ^ true) {
            msgBackup.doBackup(partsSkip);
            msgBackup.skipPartitions(parts);
            int iPartition3 = parts.next(0);
            while (iPartition3 >= 0) {
                PartitionedService$PartitionControl control = this.getPartitionControl(iPartition3);
                control.getVersionCounter().incrementAndGet();
                control.flushDeferredBackups();
                iPartition3 = parts.next(iPartition3 + 1);
            }
        }
    }

    public void publishPartitionOwnership(int iPartition, int iStore, int nOwner) {
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        owners.setOwner(iStore, nOwner);
        this.putPartitionConfig(iPartition, owners);
    }

    public void putPartitionConfig(int iPartition, Ownership owners) {
        this.getPartitionConfigMap().put((Object)iPartition, owners);
    }

    protected void putPartitionConfig(Map mapOwners) {
        this.getPartitionConfigMap().putAll(mapOwners);
    }

    protected void receivePartition(int iPartition, int iBackup, List listXferRequests) {
        if (!this.isActivePersistence() ? false : iBackup == 0) {
            PersistentStore store = this.getPartitionControl(iPartition).ensurePersistentStore();
            this.saveQuorum(iPartition, store);
            if (!(this.isExiting() ^ true) ? false : this.getServiceState() != Service.SERVICE_STOPPING) {
                CachePersistenceHelper.seal(store, this, null);
            }
        }
    }

    public boolean recoverPartition(int iPartition, PersistentStore storeFrom, PersistentStore storeTo, List listRequests) {
        Binary binQuorum;
        if (CachePersistenceHelper.isGlobalPartitioningSchemePID(iPartition) && (binQuorum = CachePersistenceHelper.readQuorumRaw(storeFrom)) != null) {
            CachePersistenceHelper.writeQuorumRaw(storeTo, binQuorum);
            this.getPersistenceControl().setQuorumRaw(binQuorum);
        }
        if (this.getServiceState() >= Service.SERVICE_STOPPING) {
            return false;
        }
        CachePersistenceHelper.seal(storeTo, this, null);
        this.getPartitionControl(iPartition).setRecovered(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverPartitions(PartitionedService$PartitionRecoverRequest$RecoverJob job, Map mapStoresFrom, Map mapStoresTo, PartitionSet partsFail) {
        Object iter;
        PartitionRecoverInfo info = job.getRecoverInfo();
        List listGUID = job.getListGUID();
        int cGUIDs = listGUID.size();
        ArrayList listRequests = new ArrayList();
        PartitionSet partsRecovered = this.instantiatePartitionSet(false);
        PersistenceManager mgrRecover = info.getManager();
        if (mapStoresTo.isEmpty() ^ true) {
            iter = mapStoresTo.entrySet().iterator();
            while (!(!iter.hasNext() ? false : this.isExiting() ^ true) ? false : this.getServiceState() != Service.SERVICE_STOPPING) {
                Map.Entry entry = (Map.Entry)iter.next();
                Integer IPartition = (Integer)entry.getKey();
                int nPartition = IPartition;
                PersistentStore storeFrom = (PersistentStore)entry.getValue();
                String sGUID = ((PersistentStore)mapStoresFrom.get(IPartition)).getId();
                Component._assert(this.getPartitionControl(nPartition).isLocked(), "Partition must be locked");
                try {
                    PersistentStore storeTo;
                    PersistentStore persistentStore = storeTo = this.isActivePersistence() ? storeFrom : NullImplementation.getPersistentStore();
                    if (this.recoverPartition(nPartition, storeFrom, storeTo, listRequests)) {
                        if (this.isSnapshotManager(mgrRecover)) {
                            mgrRecover.close(sGUID);
                        } else {
                            mgrRecover.delete(sGUID, false);
                        }
                        partsRecovered.add(nPartition);
                    } else {
                        this.onRecoverFailed(mgrRecover, sGUID, true);
                        partsFail.add(nPartition);
                    }
                    this.heartbeat();
                }
                catch (Throwable t) {
                    this.onRecoverFailed(mgrRecover, sGUID, t instanceof PersistenceException);
                    partsFail.add(nPartition);
                    Component._trace(new StringBuilder(String.valueOf("Failed to recover partition ")).append(nPartition).append('\n').append(t.getMessage()).append('\n').append(Component.getStackTrace(t)).toString(), 2);
                }
            }
        }
        iter = info;
        synchronized (iter) {
            info.getRecoveredPartitions().add(partsRecovered);
            info.getFailedPartitions().add(partsFail);
            info.getListRequests().addAll(listRequests);
        }
        PartitionedService$PartitionRecoverRequest request = (PartitionedService$PartitionRecoverRequest)info.getRequest();
        if (request.getRecoverJobs().decrementAndGet() == 0) {
            PartitionSet partsAssign = request.getPartsAssign();
            if (partsAssign.isEmpty() ^ true) {
                int iPartition = partsAssign.next(0);
                int c = 0;
                while (!(iPartition >= 0) ? false : this.getServiceState() < Service.SERVICE_STOPPING) {
                    this.assignOrphan(iPartition);
                    if ((c++ & 0xF) == 15) {
                        this.heartbeat();
                    }
                    iPartition = partsAssign.next(iPartition + 1);
                }
            }
            PartitionedService$Continuations continuations = this.getContinuations();
            this.onPartitionsRecovered(info.getRecoveredPartitions(), ((PartitionedService$PartitionRecoverRequest)info.getRequest()).getSnapshotToRecover(), continuations.thenOnServiceThread(continuations.instantiateFinalizeRecoverPrimary(info)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContention(int iPartition) {
        CommonMonitor oMonitor;
        PartitionedService$Contention[] aContention = this.getPartitionContention();
        CommonMonitor commonMonitor = oMonitor = Base.getCommonMonitor(System.identityHashCode(aContention) + iPartition);
        synchronized (commonMonitor) {
            PartitionedService$Contention contention = aContention[iPartition];
            if (contention == null) {
                contention = aContention[iPartition] = new PartitionedService$Contention();
                contention.setPartition(iPartition);
            } else {
                contention.setAccessCount(contention.getAccessCount() + 1);
            }
        }
    }

    public void registerContention(PartitionSet partitions) {
        int iPartition = partitions.next(0);
        while (iPartition >= 0) {
            this.registerContention(iPartition);
            iPartition = partitions.next(iPartition + 1);
        }
    }

    protected void releasePartition(int iPartition, int iBackup) {
        if (!this.isActivePersistence() ? false : iBackup == 0) {
            this.getPartitionControl(iPartition).deletePersistentStore();
        }
    }

    protected void releasePartitionControl(int nPartition) {
        Guardian.GuardContext ctx;
        PartitionedService$PartitionControl ctrlPartition = this.getPartitionControl(nPartition);
        if (ctrlPartition != null && (ctx = ctrlPartition.getContext()) != null) {
            ctx.release();
        }
        this.setPartitionControl(nPartition, null);
    }

    public void releaseScratchSpace(long cb) {
        this.getScratchSpaceCounter().addAndGet(cb);
    }

    public void removePartitionListener(PartitionListener listener) {
        this.getPartitionListeners().remove(listener);
    }

    public String reportContentions() {
        StringBuffer sb = new StringBuffer();
        PartitionedService$Contention[] aContention = this.getPartitionContention();
        int iPartition = 0;
        int cPartitions = this.getPartitionCount();
        while (iPartition < cPartitions) {
            PartitionedService$Contention contention = aContention[iPartition];
            if (contention != null) {
                sb.append("\n*** ").append(contention);
            }
            ++iPartition;
        }
        return sb.toString();
    }

    public String reportOwnership(int nMember, boolean fVerbose) {
        StringBuffer sb = new StringBuffer();
        int[][] aaiOwner = this.getPartitionAssignments();
        int cPartitions = aaiOwner.length;
        int cBackups = this.getBackupCount();
        int nMemberThis = this.getThisMember().getId();
        int iStore = 0;
        while (iStore < 1 + cBackups) {
            if (iStore == 0) {
                sb.append("Primary[]");
            } else {
                sb.append("\nBackup[").append(iStore).append("]");
            }
            StringBuffer sbStore = new StringBuffer();
            int cDigits = cPartitions > 9999 ? 5 : (cPartitions > 999 ? 4 : 3);
            int cOwned = 0;
            int iPartition = 0;
            while (iPartition < cPartitions) {
                int nOwnerLocal = aaiOwner[iPartition][iStore];
                int nOwnerGlobal = this.getPartitionConfig(iPartition).getOwner(iStore);
                if (nOwnerLocal == nMember ? true : nOwnerGlobal == nMember) {
                    if (fVerbose) {
                        sbStore.append(',').append(this.isPartitionVulnerable(iPartition, true) ? (char)' ' : '+');
                        String sCtrl = null;
                        if (nOwnerLocal == nMemberThis) {
                            PartitionedService$PartitionControl ctrl = this.getPartitionControl(iPartition);
                            if (ctrl == null) {
                                sCtrl = new StringBuilder(String.valueOf(Base.toDecString(iPartition, cDigits))).append("; missing control").toString();
                            } else if (ctrl.getLockType() != PartitionedService$PartitionControl.LOCK_NONE) {
                                sCtrl = String.valueOf(ctrl);
                            }
                        }
                        sbStore.append(sCtrl == null ? Base.toDecString(iPartition, cDigits) : sCtrl);
                        if (nOwnerLocal != nOwnerGlobal) {
                            if (nOwnerLocal != nMember) {
                                sbStore.append("?local=").append(nOwnerLocal);
                            } else {
                                sbStore.append("?global=").append(nOwnerGlobal);
                            }
                        }
                    }
                    ++cOwned;
                }
                ++iPartition;
            }
            sb.append('#').append(Base.toDecString(cOwned, cDigits));
            if (!(cOwned > 0) ? false : fVerbose) {
                sb.append(':').append(sbStore.substring(1));
            }
            ++iStore;
        }
        return sb.toString();
    }

    public String reportOwnership(boolean fVerbose) {
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        MemberSet setOwners = this.getOwnershipMemberSet();
        int cMembers = setOwners.size();
        if (cMembers == 0) {
            return "No ownership-enabled members";
        }
        int[] acPrimary = this.calculateOwnership(setOwners, true);
        int[] acBackup = this.calculateOwnership(setOwners, false);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDistributionStrategy().reportLocalDistributionState(fVerbose));
        Iterator iter = setOwners.iterator();
        while (iter.hasNext()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            int nMember = member.getId();
            sb.append("\n*** Member: ");
            if (nMember < 10) {
                sb.append(' ');
            }
            sb.append(nMember).append(" total=").append(acPrimary[nMember] + acBackup[nMember]).append(" (primary=").append(acPrimary[nMember]).append(", backup=").append(acBackup[nMember]).append(")\n").append(this.reportOwnership(nMember, fVerbose)).append('\n');
        }
        sb.append("\n*** Orphans:\n").append(this.reportOwnership(0, fVerbose)).append('\n');
        PartitionedService$PartitionControl[] aControl = this.getPartitionControl();
        if (aControl != null) {
            StringBuilder sbStates = null;
            int i = 0;
            int c = aControl.length;
            while (i < c) {
                PartitionedService$PartitionControl ctrl = aControl[i];
                if (!(ctrl != null) ? false : ctrl.getPartitionState() != 0) {
                    if (sbStates == null) {
                        sbStates = new StringBuilder("\n*** Partition States:\n");
                    }
                    sbStates.append(i).append(": ").append(ctrl).append(", ");
                }
                ++i;
            }
            if (sbStates != null) {
                sb.append((CharSequence)sbStates);
            }
        }
        return sb.toString();
    }

    public String reportPartitionOwnership(int iPartition) {
        StringBuffer sb = new StringBuffer(new StringBuilder(String.valueOf("Partition ")).append(iPartition).append(": ").toString());
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        int nMemberThis = this.getThisMember().getId();
        PartitionedService$PartitionControl ctrl = this.getPartitionControl(iPartition);
        int iStore = 0;
        int c = 1 + this.getBackupCount();
        while (iStore < c) {
            int nOwnerLocal = aiOwner[iStore];
            int nOwnerGlobal = owners.getOwner(iStore);
            if (iStore == 0) {
                sb.append("owner=");
            } else {
                sb.append(", backup[").append(iStore).append("]=");
            }
            sb.append(nOwnerLocal);
            if (nOwnerLocal != nOwnerGlobal) {
                sb.append("?global=").append(nOwnerGlobal);
            }
            if (nOwnerLocal == nMemberThis) {
                if (ctrl == null) {
                    sb.append("; missing control");
                } else if (ctrl.getLockType() != PartitionedService$PartitionControl.LOCK_NONE) {
                    sb.append("; ").append(ctrl);
                }
            }
            ++iStore;
        }
        return sb.toString();
    }

    public String reportVulnerability(int nMember, boolean fVerbose) {
        if (this.getBackupCount() == 0) {
            return "No backup";
        }
        StringBuffer sbEndangered = new StringBuffer();
        StringBuffer sbVulnerable = new StringBuffer();
        int cEndangered = 0;
        int cVulnerable = 0;
        int iPartition = 0;
        int cPartitions = this.getPartitionCount();
        while (iPartition < cPartitions) {
            if (this.getPrimaryOwner(iPartition).getId() == nMember) {
                if (this.getBackupOwners(iPartition).isEmpty()) {
                    sbEndangered.append(',').append(iPartition);
                    ++cEndangered;
                } else if (this.isPartitionVulnerable(iPartition, true)) {
                    sbVulnerable.append(',').append(iPartition);
                    ++cVulnerable;
                }
            }
            ++iPartition;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("*** Endangered partitions: (").append(cEndangered).append(") ");
        if (!fVerbose ? false : sbEndangered.length() > 0) {
            sb.append(sbEndangered.substring(1));
        }
        sb.append("\n*** Vulnerable partitions: (").append(cVulnerable).append(") ");
        if (!fVerbose ? false : sbVulnerable.length() > 0) {
            sb.append(sbVulnerable.substring(1));
        }
        return sb.toString();
    }

    public String reportVulnerability(boolean fVerbose) {
        if (this.getBackupCount() == 0) {
            return "No backup";
        }
        StringBuffer sbEndangered = new StringBuffer();
        StringBuffer sbVulnerable = new StringBuffer();
        int cEndangered = 0;
        int cVulnerable = 0;
        int iPartition = 0;
        int cPartitions = this.getPartitionCount();
        while (iPartition < cPartitions) {
            if (this.getPrimaryOwner(iPartition) == null ? true : this.getBackupOwners(iPartition).isEmpty()) {
                sbEndangered.append(',').append(iPartition);
                ++cEndangered;
            } else if (this.isPartitionVulnerable(iPartition, true)) {
                sbVulnerable.append(',').append(iPartition);
                ++cVulnerable;
            }
            ++iPartition;
        }
        StringBuffer sb = new StringBuffer();
        if (cVulnerable > 0) {
            sb.append("Vulnerability is ").append(this.isVulnerabilityAvoidable(this.getOwnershipMemberSet()) ? "avoidable" : "unavoidable");
        }
        sb.append("\n*** Endangered partitions: (").append(cEndangered).append(") ");
        if (!fVerbose ? false : sbEndangered.length() > 0) {
            sb.append(sbEndangered.substring(1));
        }
        sb.append("\n*** Vulnerable partitions: (").append(cVulnerable).append(") ");
        if (!fVerbose ? false : sbVulnerable.length() > 0) {
            sb.append(sbVulnerable.substring(1));
        }
        return sb.toString();
    }

    public long reserveScratchSpace() {
        long cbReserve;
        long cbScratch;
        AtomicLong atomicScratch = this.getScratchSpaceCounter();
        while (!atomicScratch.compareAndSet(cbScratch = atomicScratch.get(), cbScratch - (cbReserve = Math.max(cbScratch / (long)2, (long)(2 * 1024))))) {
        }
        return cbReserve;
    }

    public void resetStats() {
        this.getPersistenceControl().resetStats();
        super.resetStats();
    }

    public EndPoint resolveEndPoint(String sEndPoint, com.tangosol.coherence.component.net.Member member, Map mapMemberConfig) {
        if (!(this.isOwnershipEnabled() ^ true) ? false : (Integer)mapMemberConfig.get("ownership-enabled") == OWNERSHIP_DISABLED) {
            return null;
        }
        return super.resolveEndPoint(sEndPoint, member, mapMemberConfig);
    }

    protected void restoreOrphans(PartitionedService$OwnershipRequest msgRequest) {
        int[][] aaiOwner = msgRequest.getRequestAssignments();
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nMemberThis = memberThis.getId();
        int cPartitions = aaiOwner.length;
        int cBackups = this.getBackupCount();
        PartitionSet partsRestore = new PartitionSet(cPartitions);
        this.setRestoreInProgress(true);
        int iPartition = 0;
        while (iPartition < cPartitions) {
            int[] aiOwner = aaiOwner[iPartition];
            if (aiOwner[0] == 0) {
                int iBackup = 1;
                while (iBackup <= cBackups) {
                    int nBackupOwner = aiOwner[iBackup];
                    if (nBackupOwner == nMemberThis) {
                        PartitionedService$PartitionControl control = this.getPartitionControl(iPartition);
                        control.lock(-1L, PartitionedService$PartitionControl.LOCK_PRIMARY_XFER_IN);
                        this.firePartitionEvent(PartitionEvent.PARTITION_RECEIVE_BEGIN, iPartition, null, memberThis);
                        while (++iBackup <= cBackups) {
                            this.assignPartitionOwner(iPartition, iBackup, aiOwner[iBackup]);
                        }
                        partsRestore.add(iPartition);
                        break;
                    }
                    if (nBackupOwner != 0) break;
                    ++iBackup;
                }
            }
            ++iPartition;
        }
        if (partsRestore.isEmpty()) {
            this.onFinalizeRestorePrimary(msgRequest, null);
        } else {
            LiteMap<Integer, VersionedOwnership> mapUpdate = new LiteMap<Integer, VersionedOwnership>();
            boolean fActive = this.isActivePersistence();
            int iPartition2 = partsRestore.next(0);
            int c = 0;
            while (!(!(iPartition2 >= 0) ? false : this.isExiting() ^ true) ? false : this.getServiceState() != Service.SERVICE_STOPPING) {
                mapUpdate.put(iPartition2, this.assignPrimaryPartition(iPartition2, 'm'));
                this.getPartitionControl(iPartition2).getVersionCounter().incrementAndGet();
                this.movePartition(iPartition2, 0);
                partsRestore.add(iPartition2);
                if (!fActive ? false : (c++ & 0xF) == 15) {
                    this.heartbeat();
                }
                iPartition2 = partsRestore.next(iPartition2 + 1);
            }
            this.onPartitionsRestored(partsRestore, this.getContinuations().instantiateFinalizeRestorePrimaries(msgRequest, mapUpdate));
        }
    }

    public void saveQuorum(int iPartition, PersistentStore store) {
        Binary binQuorum;
        if (iPartition < 0) {
            iPartition = GUIDHelper.getPartition(store.getId());
        }
        if (CachePersistenceHelper.isGlobalPartitioningSchemePID(iPartition) && (binQuorum = this.getPersistenceControl().getQuorumRaw()) != null) {
            CachePersistenceHelper.writeQuorumRaw(store, binQuorum);
        }
    }

    protected void setAsyncBackup(boolean fAsync) {
        this.__m_AsyncBackup = fAsync;
    }

    protected void setBackupCount(int cBackups) {
        Component._assert(this.isAcceptingClients() ^ true, "The backup count is immutable once the service has started");
        this.__m_BackupCount = cBackups;
    }

    public void setConcurrent(boolean fConcurrent) {
        this.__m_Concurrent = fConcurrent;
    }

    protected void setContinuations(PartitionedService$Continuations continuations) {
        this.__m_Continuations = continuations;
    }

    protected void setDeferredBackupTimeoutMillis(long cMillis) {
        this.__m_DeferredBackupTimeoutMillis = cMillis;
    }

    public void setDistributionAggressiveness(int iFactor) {
        this.__m_DistributionAggressiveness = Math.max(iFactor, 1);
    }

    public void setDistributionNextMillis(long ldtNext) {
        this.__m_DistributionNextMillis = ldtNext;
    }

    public void setDistributionRepeatMillis(int cMillis) {
        this.__m_DistributionRepeatMillis = cMillis;
    }

    protected void setDistributionStable(boolean fSync) {
        this.__m_DistributionStable = fSync;
    }

    protected void setDistributionStrategy(PartitionedService$CentralDistribution strategy) {
        this.__m_DistributionStrategy = strategy;
    }

    protected void setDistributionSynchronized(boolean fSync) {
        this.__m_DistributionSynchronized = fSync;
    }

    protected void setFinalizing(boolean fFinalizing) {
        this.__m_Finalizing = fFinalizing;
    }

    protected void setKeyAssociator(KeyAssociator associator) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_KeyAssociator = associator;
    }

    protected void setKeyPartitioningStrategy(KeyPartitioningStrategy strategy) {
        if (this.isAcceptingClients()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_KeyPartitioningStrategy = strategy;
    }

    public void setKeyToBinaryConverter(PartitionedService$ConverterKeyToBinary pKeyToBinaryConverter) {
        this.__m_KeyToBinaryConverter = pKeyToBinaryConverter;
    }

    private void setMsgCAE(String sMsg) {
        this.__m_MsgCAE = sMsg;
    }

    protected void setOwnershipEnabled(boolean fEnabled) {
        this.__m_OwnershipEnabled = fEnabled;
    }

    public void setOwnershipInProgress(int c) {
        this.__m_OwnershipInProgress = c;
    }

    public void setOwnershipVersion(int i, int nVersion) {
        this.getOwnershipVersion()[i] = nVersion;
    }

    public void setOwnershipVersion(int[] anVersion) {
        this.__m_OwnershipVersion = anVersion;
    }

    protected void setPartitionAssignments(int[][] aai) {
        this.__m_PartitionAssignments = aai;
    }

    protected void setPartitionConfigMap(PartitionedService$PartitionConfig$Map mapConfig) {
        this.__m_PartitionConfigMap = mapConfig;
    }

    private void setPartitionContention(PartitionedService$Contention[] aContention) {
        this.__m_PartitionContention = aContention;
    }

    protected void setPartitionControl(int i, PartitionedService$PartitionControl control) {
        this.getPartitionControl()[i] = control;
    }

    protected void setPartitionControl(PartitionedService$PartitionControl[] control) {
        this.__m_PartitionControl = control;
    }

    protected void setPartitionCount(int cPartitions) {
        Component._assert(this.isAcceptingClients() ^ true, "The partition count is immutable once the service has started");
        this.__m_PartitionCount = cPartitions;
    }

    protected void setPartitionListeners(Listeners listeners) {
        this.__m_PartitionListeners = listeners;
    }

    protected void setPersistenceControl(PartitionedService$PersistenceControl control) {
        this.__m_PersistenceControl = control;
    }

    protected void setPersistenceDependencies(PersistenceDependencies deps) {
        this.__m_PersistenceDependencies = deps;
    }

    private void setPreprocessingGate(ThreadGate gatePreprocessing) {
        this.__m_PreprocessingGate = gatePreprocessing;
    }

    public void setRecoveryThread(boolean fRecoveryThread) {
        this.getTLORecoveryThread().set(fRecoveryThread);
    }

    public void setRemainsOwnershipReport(String sReport) {
        this.__m_RemainsOwnershipReport = sReport;
    }

    protected void setRestoreInProgress(boolean fProgress) {
        this.__m_RestoreInProgress = fProgress;
    }

    protected void setScratchSpaceCounter(AtomicLong cbScratch) {
        this.__m_ScratchSpaceCounter = cbScratch;
    }

    public void setTLORecoveryThread(ThreadLocal localThread) {
        this.__m_TLORecoveryThread = localThread;
    }

    protected void setTransferControl(PartitionedService$TransferControl control) {
        this.__m_TransferControl = control;
    }

    protected void setTransferThreshold(int cbThreshold) {
        this.__m_TransferThreshold = cbThreshold;
    }

    public void shutdown() {
        if (this.getThread() != Thread.currentThread()) {
            long ldtTimeout = Base.getSafeTimeMillis() + 5000L;
            while (!(!this.isStarted() ? false : this.isAcceptingClients() ^ true) ? false : this.getServiceState() < Service.SERVICE_STOPPED) {
                Thread.yield();
                if (!(Base.getSafeTimeMillis() > ldtTimeout)) continue;
                Component._trace(new StringBuilder(String.valueOf("Timeout during shutdown; stopping service ")).append(this).toString(), 2);
                this.stop();
                return;
            }
        }
        super.shutdown();
    }

    public void snapshotPartition(int iPartition, PersistentStore store, Object oToken) {
        CachePersistenceHelper.seal(store, this, oToken);
    }

    public List sortMembers(MemberSet setOthers, int[] aiPrimaryWeight, int[] aiSecondaryWeight) {
        Object[] aMember = (com.tangosol.coherence.component.net.Member[])setOthers.toArray();
        int cOthers = aMember.length;
        if (cOthers > 1) {
            Random rand = Base.getRandom();
            TreeMap<Long, Object> mapSorted = new TreeMap<Long, Object>();
            int nMachineThis = this.getThisMember().getMachineId();
            int i = 0;
            while (i < cOthers) {
                Object member = aMember[i];
                int nId = ((com.tangosol.coherence.component.net.Member)member).getId();
                if (nId < aiPrimaryWeight.length) {
                    long nM = ((com.tangosol.coherence.component.net.Member)member).getMachineId() == nMachineThis ? 1L << 62 : (long)0;
                    long nP = (long)aiPrimaryWeight[nId] << 24;
                    long nS = 0L;
                    if (!(aiSecondaryWeight != null) ? false : nId < aiSecondaryWeight.length) {
                        nS = (long)aiSecondaryWeight[nId] << 8;
                    }
                    long nR = rand.nextInt() & 0xFF;
                    mapSorted.put(new Long(nM | nP | nS | nR), member);
                }
                ++i;
            }
            return new ImmutableArrayList(mapSorted.values());
        }
        return new ImmutableArrayList(aMember);
    }

    public Map splitByOwner(PartitionSet partitions, int iStore, int[][] aaiOwner) {
        Map<com.tangosol.coherence.component.net.Member, PartitionSet> mapByOwner = partitions.cardinality() > 1 ? new HashMap() : (Map)new LiteMap();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        int cPartitions = this.getPartitionCount();
        if (aaiOwner == null) {
            aaiOwner = this.getPartitionAssignments();
        }
        int iPartition = partitions.next(0);
        while (iPartition >= 0) {
            int nOwner = aaiOwner[iPartition][iStore];
            com.tangosol.coherence.component.net.Member member = (!(nOwner > 0) ? false : setMembers.isServiceLeaving(nOwner) ^ true) ? setMembers.getMember(nOwner) : null;
            PartitionSet partMember = (PartitionSet)mapByOwner.get(member);
            if (partMember == null) {
                partMember = new PartitionSet(cPartitions);
                mapByOwner.put(member, partMember);
            }
            partMember.add(iPartition);
            iPartition = partitions.next(iPartition + 1);
        }
        return mapByOwner;
    }

    public Map splitEntriesByOwner(Iterator iterEntries, int iStore, int[][] aaiOwner) {
        HashMap mapByOwner = new HashMap();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        if (aaiOwner == null) {
            aaiOwner = this.getPartitionAssignments();
        }
        while (iterEntries.hasNext()) {
            Map.Entry entry = (Map.Entry)iterEntries.next();
            Binary binKey = (Binary)entry.getKey();
            int iPartition = this.getKeyPartition(binKey);
            int nOwner = aaiOwner[iPartition][iStore];
            com.tangosol.coherence.component.net.Member member = (!(nOwner > 0) ? false : setMembers.isServiceLeaving(nOwner) ^ true) ? setMembers.getMember(nOwner) : null;
            HashMap mapMember = (HashMap)mapByOwner.get(member);
            if (mapMember == null) {
                mapMember = new HashMap();
                mapByOwner.put(member, mapMember);
            }
            mapMember.put(binKey, entry.getValue());
        }
        return mapByOwner;
    }

    public Map splitKeysByOwner(Iterator iterKeys, int iStore, int[][] aaiOwner) {
        HashMap<com.tangosol.coherence.component.net.Member, HashSet<Binary>> mapByOwner = new HashMap<com.tangosol.coherence.component.net.Member, HashSet<Binary>>();
        ServiceMemberSet setMembers = this.getServiceMemberSet();
        if (aaiOwner == null) {
            aaiOwner = this.getPartitionAssignments();
        }
        while (iterKeys.hasNext()) {
            Binary binKey = (Binary)iterKeys.next();
            int iPartition = this.getKeyPartition(binKey);
            int nOwner = aaiOwner[iPartition][iStore];
            com.tangosol.coherence.component.net.Member member = (!(nOwner > 0) ? false : setMembers.isServiceLeaving(nOwner) ^ true) ? setMembers.getMember(nOwner) : null;
            HashSet<Binary> setMember = (HashSet<Binary>)mapByOwner.get(member);
            if (setMember == null) {
                setMember = new HashSet<Binary>();
                mapByOwner.put(member, setMember);
            }
            setMember.add(binKey);
        }
        return mapByOwner;
    }

    public Map splitKeysByPartition(Iterator iterKeys) {
        HashMap<Integer, HashSet<Binary>> mapByPID = new HashMap<Integer, HashSet<Binary>>();
        while (iterKeys.hasNext()) {
            Binary binKey = (Binary)iterKeys.next();
            Integer IPartition = this.getKeyPartition(binKey);
            HashSet<Binary> setPart = (HashSet<Binary>)mapByPID.get(IPartition);
            if (setPart == null) {
                setPart = new HashSet<Binary>();
                mapByPID.put(IPartition, setPart);
            }
            setPart.add(binKey);
        }
        return mapByPID;
    }

    public boolean swapBackupIndex(int iPartition, int iStore0, int iStore1) {
        int iStoreHigh;
        int iStoreLow;
        PartitionedService$PartitionControl ctrlPartition = this.getPartitionControl(iPartition);
        if (ctrlPartition.isTransferDisallowed()) {
            return false;
        }
        int[] aiOwner = this.getPartitionAssignments()[iPartition];
        Component._assert(aiOwner[0] == this.getThisMember().getId(), "not a primary owner");
        Component._assert(!(iStore0 > 0) ? false : iStore1 > 0);
        if (iStore0 == iStore1) {
            return true;
        }
        if (iStore0 < iStore1) {
            iStoreLow = iStore1 - 1;
            iStoreHigh = iStore1;
        } else {
            iStoreLow = iStore1;
            iStoreHigh = iStore1 + 1;
        }
        ctrlPartition.preventTransfer();
        int nMemberToPromote = aiOwner[iStoreHigh];
        aiOwner[iStoreHigh] = aiOwner[iStoreLow];
        aiOwner[iStoreLow] = nMemberToPromote;
        VersionedOwnership owners = this.getPartitionConfig(iPartition);
        Component._trace(new StringBuilder(String.valueOf("Exchanging the ownership for partition ")).append(iPartition).append(" for backup indices ").append(iStoreLow).append(" and ").append(iStoreHigh).append(", owners=").append(owners).toString(), 3);
        PartitionedService$PartitionSwapRequest msg = (PartitionedService$PartitionSwapRequest)this.instantiateMessage("PartitionSwapRequest");
        msg.setPartition(iPartition);
        msg.setPromoteIndex(iStoreLow);
        msg.setOwners(owners);
        msg.setMemberList(this.getBackupOwners(iPartition, false));
        this.post(msg);
        return Math.abs(iStore0 - iStore1) == 1;
    }

    public int transferBackup(com.tangosol.coherence.component.net.Member member, PartitionSet parts, int iBackup, int cPartsLimit) {
        PartitionedService$TransferControl ctrlTransfer = this.getTransferControl();
        PartitionedService$PartitionControl[] aCtrlPartition = this.getPartitionControl();
        long cContendMillis = this.getDistributionContendMillis();
        int iPart = parts.next(0);
        while (iPart >= 0) {
            if (aCtrlPartition[iPart].lock(cContendMillis, PartitionedService$PartitionControl.LOCK_BACKUP_XFER_OUT)) {
                cContendMillis = 0L;
            } else {
                parts.remove(iPart);
                cContendMillis >>= (int)1L;
            }
            iPart = parts.next(iPart + 1);
        }
        int cPartitions = parts.cardinality();
        if (cPartitions == 0) {
            return 0;
        }
        ctrlTransfer.prepareBackupTransfer(member, this.getTransferThreshold(), Math.min(cPartsLimit, cPartitions));
        int cSent = 0;
        int iPart2 = parts.next(0);
        while (iPart2 >= 0) {
            PartitionedService$PartitionControl ctrlPart = aCtrlPartition[iPart2];
            if (ctrlTransfer.isTransferFull()) {
                parts.remove(iPart2);
                ctrlPart.unlock();
            } else {
                this.validateTransferStrength(member, iPart2, iBackup);
                this.transferPartition(iPart2, iBackup, ++cSent == cPartitions);
                ctrlPart.unlock();
                ctrlPart.preventTransfer();
            }
            iPart2 = parts.next(iPart2 + 1);
        }
        Component._trace(new StringBuilder(String.valueOf("Transferring ")).append(new MemorySize(ctrlTransfer.getTransferredBytes())).append(" of backup[").append(iBackup).append("] for ").append(parts).append(" to member ").append(member.getId()).toString(), 3);
        return cSent;
    }

    protected void transferPartition(int iPartition, int iStore, boolean fLastInTransfer) {
        this.assignPartitionOwner(iPartition, iStore, this.getTransferControl().getToMember().getId());
    }

    public boolean transferPrimary(com.tangosol.coherence.component.net.Member member, RequestMessage msgRequest, PartitionSet parts, int cPartsLimit) {
        int cLocked = 0;
        PartitionedService$PartitionControl[] aCtrlPartition = this.getPartitionControl();
        long cContendMillis = this.getDistributionContendMillis();
        int iPart = parts.next(0);
        while (iPart >= 0) {
            if (cLocked >= cPartsLimit) {
                parts.remove(iPart);
            } else if (aCtrlPartition[iPart].lock(cContendMillis, PartitionedService$PartitionControl.LOCK_PRIMARY_XFER_OUT)) {
                ++cLocked;
                cContendMillis = 0L;
            } else {
                cContendMillis >>= 1;
                parts.remove(iPart);
            }
            iPart = parts.next(iPart + 1);
        }
        if (parts.isEmpty()) {
            return false;
        }
        this.getTransferControl().preparePrimaryTransfer(msgRequest, this.getTransferThreshold());
        this.onFinalizeSendPrimary(parts);
        return true;
    }

    public void unpinPartition(int iPartition) {
        if (!this.isConcurrent() ? false : this.isPrimaryOwner(iPartition)) {
            this.exitPartition(iPartition);
        }
    }

    public void unpinPartitions(PartitionSet partitions) {
        if (this.isConcurrent()) {
            PartitionedService$PartitionControl[] aControl = this.getPartitionControl();
            int nPartition = partitions.next(0);
            while (nPartition >= 0) {
                aControl[nPartition].exit();
                nPartition = partitions.next(nPartition + 1);
            }
        }
    }

    protected boolean validateMemberConfig() {
        Member memberSenior;
        int nThisMember = this.getThisMember().getId();
        boolean fValid = true;
        ServiceMemberSet setService = this.getServiceMemberSet();
        long ldtJoinedThis = setService.getServiceJoinTime(nThisMember);
        StringBuilder sbMembers = null;
        Iterator iter = setService.iterator();
        while (iter.hasNext()) {
            Integer IOwnership;
            Member memberThat = (Member)iter.next();
            int nMemberThat = memberThat.getId();
            long ldtJoinedThat = setService.getServiceJoinTime(nMemberThat);
            if (!(ldtJoinedThat < ldtJoinedThis) || !((IOwnership = (Integer)setService.getMemberConfigMap(nMemberThat).get("ownership-enabled")) == null ? true : IOwnership == OWNERSHIP_PENDING)) continue;
            if (sbMembers == null) {
                sbMembers = new StringBuilder();
            } else {
                sbMembers.append(", ");
            }
            sbMembers.append(nMemberThat);
            fValid = false;
        }
        if ((!fValid ? false : this.isOwnershipEnabled()) && (memberSenior = this.getOwnershipSenior()) != null) {
            ObservableMap mapSenior = setService.getMemberConfigMap(memberSenior.getId());
            XmlElement xmlConfig = (XmlElement)mapSenior.get("persistence-config");
            if (xmlConfig == null) {
                sbMembers = new StringBuilder().append(memberSenior.getId());
                fValid = false;
            } else {
                PersistenceEnvironment env = null;
                SnapshotArchiver arch = null;
                PartitionedService$PersistenceControl ctrl = this.getPersistenceControl();
                if (ctrl.isValid()) {
                    env = SafePersistenceWrappers.unwrap(ctrl.getPersistenceEnvironment());
                    arch = ctrl.getSnapshotArchiver();
                }
                if (((this.verifyFeature("PersistenceActiveFailureMode", (this.isActivePersistence() ^ true ? true : ctrl == null) ? "none" : (ctrl.getActiveFailureMode() == PersistenceDependencies.FAILURE_STOP_SERVICE ? "stop-service" : "stop-persistence"), xmlConfig.getSafeAttribute("persistence-active-failure-mode").getString("none")) ^ true ? true : this.verifyFeature("PersistenceEnvironment", env == null ? "none" : env.getClass().getName(), xmlConfig.getSafeAttribute("persistence-environment").getString("none")) ^ true) ? true : this.verifyFeature("PersistenceMode", this.isActivePersistence() ? "active" : "on-demand", xmlConfig.getSafeAttribute("persistence-mode").getString("none")) ^ true) ? true : this.verifyFeature("PersistenceSnapshotArchiver", arch == null ? "none" : arch.getClass().getName(), xmlConfig.getSafeAttribute("persistence-snapshot-archiver").getString("none")) ^ true) {
                    fValid = false;
                    this.setOwnershipEnabled(false);
                    this.post(this.instantiateMessage("NotifyShutdown"));
                }
            }
        }
        if (sbMembers != null) {
            Component._trace(new StringBuilder(String.valueOf("Waiting for member config update from members [")).append(sbMembers.toString()).append("] that are in the process of joining").toString(), 3);
        }
        return fValid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validatePartitionAssignments(MemberSet setOwners) {
        int nMemberThis = this.getThisMember().getId();
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        int[][] aaiOwner = this.getPartitionAssignments();
        boolean fModified = false;
        int iPartition = 0;
        while (iPartition < cPartitions) {
            int[] aiOwner = aaiOwner[iPartition];
            VersionedOwnership owners = this.getPartitionConfig(iPartition);
            int nPrimaryOwner = aiOwner[0];
            boolean fPrimaryOwner = nPrimaryOwner == nMemberThis;
            int iStore = 0;
            while (iStore <= cBackups) {
                int nOwnerLocal = aiOwner[iStore];
                int nOwnerGlobal = owners.getOwner(iStore);
                boolean fLocalOwnerDeparted = !(!(nOwnerLocal > 0) ? false : nOwnerLocal != nMemberThis) ? false : setOwners.contains(nOwnerLocal) ^ true;
                boolean fGlobalOwnerDeparted = !(!(nOwnerGlobal > 0) ? false : nOwnerGlobal != nMemberThis) ? false : setOwners.contains(nOwnerGlobal) ^ true;
                if ((nOwnerLocal == nOwnerGlobal ? true : (!(nOwnerLocal == 0) ? false : fGlobalOwnerDeparted)) ? true : (!(nOwnerGlobal == 0) ? false : fLocalOwnerDeparted)) {
                    if (fLocalOwnerDeparted ? true : fGlobalOwnerDeparted) {
                        if (fModified ^ true) {
                            aaiOwner = (int[][])aaiOwner.clone();
                            fModified = true;
                        }
                        aiOwner = (int[])aiOwner.clone();
                        aiOwner[iStore] = 0;
                        aaiOwner[iPartition] = aiOwner;
                        owners.setOwner(iStore, 0);
                        if (!(!(!fPrimaryOwner ? false : iStore > 0) ? false : nOwnerLocal == 0) ? false : fGlobalOwnerDeparted) {
                            this.getPartitionControl(iPartition).enableTransfer();
                        }
                    }
                } else if (iStore == 0) {
                    if (fLocalOwnerDeparted) {
                        if (!(nOwnerGlobal == nMemberThis)) throw new IllegalStateException(new StringBuilder(String.valueOf("Unrecoverable ownership de-synchronization for partition ")).append(iPartition).append("(").append(nOwnerLocal).append("!=").append(nOwnerGlobal).append(")").toString());
                        if (fModified ^ true) {
                            aaiOwner = (int[][])aaiOwner.clone();
                            fModified = true;
                        }
                        aiOwner = (int[])aiOwner.clone();
                        aiOwner[0] = 0;
                        aaiOwner[iPartition] = aiOwner;
                        this.publishPartitionOwnership(iPartition, 0, 0);
                    }
                } else {
                    Component._assert((((fPrimaryOwner ? true : nOwnerLocal == nMemberThis) ? true : nOwnerGlobal == nMemberThis) ? true : nOwnerGlobal == 0) ? true : this.getOwnedIndex(iPartition, nMemberThis, false) != -1, new StringBuilder(String.valueOf("Unrecoverable backup[")).append(iStore).append("] ownership ").append("de-synchronization for partition ").append(iPartition).append("(").append(nOwnerLocal).append("!=").append(nOwnerGlobal).append(", primary=").append(nPrimaryOwner).append(")").toString());
                    if (fLocalOwnerDeparted) {
                        boolean fEndanger = false;
                        if (fPrimaryOwner) {
                            com.tangosol.coherence.component.net.Member memberBackupPrev = setOwners.getMember(nOwnerGlobal);
                            if (memberBackupPrev == null) {
                                fEndanger = true;
                            } else {
                                aiOwner[iStore] = nOwnerGlobal;
                                this.getTransferControl().requestBackupConfirmation(iPartition, iStore, nOwnerLocal, memberBackupPrev);
                            }
                        } else {
                            fEndanger = true;
                        }
                        if (fEndanger) {
                            aiOwner[iStore] = 0;
                            owners.setOwner(iStore, 0);
                        }
                    } else if (fGlobalOwnerDeparted && fPrimaryOwner) {
                        PartitionedService$TransferControl ctrlTransfer = this.getTransferControl();
                        if (ctrlTransfer.isTransferInProgress(iPartition)) {
                            com.tangosol.coherence.component.net.Member memberBackupNew = setOwners.getMember(nOwnerLocal);
                            Component._assert(memberBackupNew != null);
                            Component._trace(new StringBuilder(String.valueOf("Transfer of partition ")).append(iPartition).append(" (backup[").append(iStore).append("]) to member ").append(nOwnerLocal).append(" (previously owned by member ").append(nOwnerGlobal).append(") is still in progress.").toString(), 3);
                            ctrlTransfer.requestBackupConfirmation(iPartition, iStore, nOwnerGlobal, memberBackupNew);
                        } else {
                            this.publishPartitionOwnership(iPartition, iStore, nOwnerLocal);
                            this.getPartitionControl(iPartition).enableTransfer();
                        }
                    }
                }
                ++iStore;
            }
            ++iPartition;
        }
        if (!fModified) return;
        this.setPartitionAssignments(aaiOwner);
    }

    protected boolean validatePartitionConfig() {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        int nThisMember = memberThis.getId();
        Member memberSenior = this.getOwnershipSenior();
        int nSeniorMember = memberSenior == null ? (this.isOwnershipEnabled() ? nThisMember : 0) : memberSenior.getId();
        MemberSet setOwners = this.getOwnershipMemberSet();
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        if (this.getPartitionConfigMap().isEmpty()) {
            if (!(nSeniorMember == nThisMember ? true : nSeniorMember == 0)) {
                Component._trace(new StringBuilder(String.valueOf("Waiting for partition config from member ")).append(nSeniorMember).append(" that is in the process of joining").toString(), 3);
                return false;
            }
            this.initPartitionConfig();
            return true;
        }
        boolean fValid = true;
        int[][] aaiOwner = this.getPartitionAssignments();
        int[] aiVersions = this.getOwnershipVersion();
        int iPartition = 0;
        while (!(iPartition < cPartitions) ? false : fValid) {
            VersionedOwnership owners = this.getPartitionConfig(iPartition);
            if (owners == null) {
                throw new IllegalStateException(new StringBuilder(String.valueOf("Missing the ownership data for partition ")).append(iPartition).toString());
            }
            int[] aiOwner = aaiOwner[iPartition];
            int iStore = 0;
            while (iStore < 1 + cBackups) {
                int nOwner = owners.getOwner(iStore);
                if (nOwner == nThisMember) {
                    Component._trace(new StringBuilder(String.valueOf("Waiting for ownership update from member ")).append(nSeniorMember).append(" for partition ").append(iPartition).append(" ").append(owners).toString(), 3);
                    fValid = false;
                    break;
                }
                aiOwner[iStore] = (!(nOwner > 0) ? false : setOwners.contains(nOwner)) ? nOwner : 0;
                ++iStore;
            }
            aiVersions[iPartition] = owners.getVersion();
            ++iPartition;
        }
        return fValid;
    }

    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        int cBackups;
        int cPartitions = xmlConfig.getAttribute("partition-count").getInt();
        if (cPartitions != this.getPartitionCount()) {
            Component._trace(new StringBuilder(String.valueOf("This node is configured with a ")).append("'partition-count'").append(" value of ").append(this.getPartitionCount()).append(", but the service senior is using a value of ").append(cPartitions).append("; overriding the local configuration.").toString(), 2);
            this.setPartitionCount(cPartitions);
        }
        if ((cBackups = xmlConfig.getAttribute("redundancy-count").getInt()) != this.getBackupCount()) {
            Component._trace(new StringBuilder(String.valueOf("This node is configured with a ")).append("'backup-count'").append(" value of ").append(this.getBackupCount()).append(", but the service senior is using a value of ").append(cBackups).append("; overriding the local configuration.").toString(), 2);
            this.setBackupCount(cBackups);
        }
        KeyAssociator associator = this.getKeyAssociator();
        KeyPartitioningStrategy partitioning = this.getKeyPartitioningStrategy();
        ActionPolicy quorumPolicy = this.getActionPolicy();
        PartitionedService$CentralDistribution strategy = this.getDistributionStrategy();
        String sAssociator = associator == null ? "none" : associator.getClass().getName();
        String sPartitioning = partitioning == null ? "none" : partitioning.getClass().getName();
        String sQuorumPolicy = quorumPolicy == null ? "none" : quorumPolicy.getClass().getName();
        String QUORUM_DEFAULT_LEGACY = "com.tangosol.net.ConfigurableQuorumPolicy$WrapperQuorumPolicy";
        String QUORUM_DEFAULT_12211 = "com.tangosol.net.ConfigurableQuorumPolicy$PartitionedCacheQuorumPolicy";
        String sQuorumGlobal = xmlConfig.getSafeAttribute("quorum-policy").getString();
        if (QUORUM_DEFAULT_LEGACY.equals(sQuorumGlobal)) {
            sQuorumGlobal = QUORUM_DEFAULT_12211;
        }
        return !(!(!super.validateServiceConfig(xmlConfig) ? false : this.verifyFeature("QuorumPolicy", sQuorumPolicy, sQuorumGlobal)) ? false : this.verifyFeature("KeyAssociator", sAssociator, xmlConfig.getSafeAttribute("key-associator").getString())) ? false : this.verifyFeature("KeyPartitioningStrategy", sPartitioning, xmlConfig.getSafeAttribute("key-partitioning").getString());
    }

    protected void validateTransferStrength(com.tangosol.coherence.component.net.Member member, int iPartition, int iStore) {
        Ownership ownersNew = this.getPartitionOwnership(iPartition);
        ownersNew.setOwner(iStore, member.getId());
        this.validateTransferStrength(this.getPartitionOwnership(iPartition), ownersNew, iPartition);
    }

    protected void validateTransferStrength(Ownership ownersOld, Ownership ownersNew, int iPartition) {
        PartitionedService$CentralDistribution dist = this.getDistributionStrategy();
        int nStrengthOld = Math.min(this.getBackupStrength(ownersOld.getOwners()), dist.getTargetStrength());
        int nStrengthNew = this.getBackupStrength(ownersNew.getOwners());
        if (!(nStrengthNew < nStrengthOld) ? false : this.getServiceMemberSet().isServiceLeaving(ownersOld.getPrimaryOwner()) ^ true) {
            Component._trace(new StringBuilder(String.valueOf("Initiating a transitional transfer for partition ")).append(iPartition).append(": ").append(ownersOld).append(" -> ").append(ownersNew).append(" (strength ").append(nStrengthOld).append(" -> ").append(nStrengthNew).append(")").toString(), 2);
        }
    }
}

