/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.protocol.CacheServiceProtocol;
import com.tangosol.coherence.component.net.extend.protocol.InvocationServiceProtocol;
import com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.CacheServiceProxy;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.InvocationServiceProxy;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$BusEventMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceQuiescence;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PingRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$LoadBalancerActionGetList;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$LoadBalancerActionUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$LookupCallback;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$NotifyConnectionClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$NotifyConnectionOpened;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$RedirectRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$ServiceLoad;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$ServiceLoadListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.HttpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.MemcachedAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.coherence.config.builder.ServiceLoadBalancerBuilder;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultProxyServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlProxyServiceHelper;
import com.tangosol.internal.net.service.grid.ProxyServiceDependencies;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.Member;
import com.tangosol.net.NameService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ProxyService;
import com.tangosol.net.RequestPolicyException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.Session;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.management.Registry;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionFilter;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.net.proxy.ProxyServiceLoadBalancer;
import com.tangosol.net.proxy.RemoteMember;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;

public class ProxyService
extends Grid
implements NameService.Resolvable,
com.tangosol.net.ProxyService,
Session,
ConnectionFilter,
ConnectionListener,
SynchronousListener {
    private ConnectionAcceptor __m_Acceptor;
    private CacheServiceProxy __m_CacheServiceProxy;
    private InvocationServiceProxy __m_InvocationServiceProxy;
    private ProxyServiceLoadBalancer __m_LoadBalancer;
    private NavigableSet __m_MemberListenAddresses;
    private ProxyService$ServiceLoad __m_ServiceLoad;
    private Map __m_ServiceLoadMap;
    private ProxyService$ServiceLoad __m_ServiceLoadPublished;
    private long __m_ServiceLoadTimeMillis;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;

    static {
        ProxyService.__initStatic();
    }

    public ProxyService() {
        this(null, null, true);
    }

    public ProxyService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMemberListenAddresses(new TreeSet());
            this.setMessageClassMap(new HashMap());
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOldestPendingRequestSUIDCounter(new AtomicLong());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSerializerMap(new WeakHashMap());
            this.setServiceLoadMap(new SafeHashMap());
            this.setSuspendPollLimit(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid$Guard("Guard", this, true), "Guard");
        this._addChild(new Grid$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid$ReceiveQueue("ReceiveQueue", this, true), "ReceiveQueue");
        this._addChild(new Grid$ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("BusEventMessage", Grid$BusEventMessage.get_CLASS());
        Class clazz3 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz6 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz7 = __mapChildren.put("DispatchEvent", Grid$DispatchEvent.get_CLASS());
        Class clazz8 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz9 = __mapChildren.put("LoadBalancerActionGetList", ProxyService$LoadBalancerActionGetList.get_CLASS());
        Class clazz10 = __mapChildren.put("LoadBalancerActionUpdate", ProxyService$LoadBalancerActionUpdate.get_CLASS());
        Class clazz11 = __mapChildren.put("LookupCallback", ProxyService$LookupCallback.get_CLASS());
        Class clazz12 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz13 = __mapChildren.put("MemberJoined", Grid$MemberJoined.get_CLASS());
        Class clazz14 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz15 = __mapChildren.put("MemberWelcomeRequest", Grid$MemberWelcomeRequest.get_CLASS());
        Class clazz16 = __mapChildren.put("NotifyConnectionClosed", ProxyService$NotifyConnectionClosed.get_CLASS());
        Class clazz17 = __mapChildren.put("NotifyConnectionOpened", ProxyService$NotifyConnectionOpened.get_CLASS());
        Class clazz18 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz19 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz20 = __mapChildren.put("NotifyMemberLeft", Grid$NotifyMemberLeft.get_CLASS());
        Class clazz21 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz22 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz23 = __mapChildren.put("NotifyResponse", Grid$NotifyResponse.get_CLASS());
        Class clazz24 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz25 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz26 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz27 = __mapChildren.put("NotifyServiceLeft", Grid$NotifyServiceLeft.get_CLASS());
        Class clazz28 = __mapChildren.put("NotifyServiceQuiescence", Grid$NotifyServiceQuiescence.get_CLASS());
        Class clazz29 = __mapChildren.put("NotifyShutdown", Grid$NotifyShutdown.get_CLASS());
        Class clazz30 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz31 = __mapChildren.put("PingRequest", Grid$PingRequest.get_CLASS());
        Class clazz32 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz33 = __mapChildren.put("RedirectRequest", ProxyService$RedirectRequest.get_CLASS());
        Class clazz34 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz35 = __mapChildren.put("ServiceLoad", ProxyService$ServiceLoad.get_CLASS());
        Class clazz36 = __mapChildren.put("ServiceLoadListener", ProxyService$ServiceLoadListener.get_CLASS());
        Class clazz37 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.net.NameService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void activate() {
    }

    public void checkConnection(Connection connection) throws ConnectionException {
        if (connection instanceof TcpAcceptor$TcpConnection) {
            TcpAcceptor$TcpConnection connectionImpl = (TcpAcceptor$TcpConnection)connection;
            String sCluster = connectionImpl.getClusterName();
            if (!(sCluster != null) ? false : sCluster.equals(this.getCluster().getClusterName()) ^ true) {
                throw new ConnectionException("connection rejected, cluster mismatch");
            }
            String sService = connectionImpl.getServiceName();
            if (!(sService != null) ? false : sService.equals(this.getServiceName()) ^ true) {
                throw new ConnectionException("connection rejected, service mismatch");
            }
        }
        if (this.getActionPolicy().isAllowed(this, ProxyService.ProxyAction.CONNECT) ^ true) {
            throw new ConnectionException("connection rejected", new RequestPolicyException("client connections are disallowed by the action policy"));
        }
        ProxyService$RedirectRequest request = (ProxyService$RedirectRequest)this.instantiateMessage("RedirectRequest");
        request.setConnection(connection);
        request.addToMember(this.getThisMember());
        Object oResult = this.poll(request);
        if (!(oResult instanceof Boolean) ? false : (Boolean)oResult) {
            throw new ConnectionException("connection redirected");
        }
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultProxyServiceDependencies((ProxyServiceDependencies)deps);
    }

    public void close() throws Exception {
    }

    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlProxyServiceHelper.fromXml(xml, new DefaultProxyServiceDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    public void connectionClosed(ConnectionEvent evt) {
        ProxyService$NotifyConnectionClosed msg = (ProxyService$NotifyConnectionClosed)this.instantiateMessage("NotifyConnectionClosed");
        msg.setConnection(evt.getConnection());
        msg.addToMember(this.getThisMember());
        this.send(msg);
    }

    public void connectionError(ConnectionEvent evt) {
        this.connectionClosed(evt);
    }

    public void connectionOpened(ConnectionEvent evt) {
        ProxyService$NotifyConnectionOpened msg = (ProxyService$NotifyConnectionOpened)this.instantiateMessage("NotifyConnectionOpened");
        msg.setConnection(evt.getConnection());
        msg.addToMember(this.getThisMember());
        this.send(msg);
    }

    public String formatStats() {
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor instanceof Acceptor) {
            return ((Acceptor)acceptor).formatStats();
        }
        return super.formatStats();
    }

    public ConnectionAcceptor getAcceptor() {
        return this.__m_Acceptor;
    }

    public NamedCache getCache(String sName, NamedMap.Option[] options) {
        CacheService service = this.getCacheServiceProxy().getCacheService();
        if (service instanceof Session) {
            return ((Session)((Object)service)).getCache(sName, options);
        }
        return service.ensureCache(sName, Base.ensureClassLoader(null));
    }

    public CacheServiceProxy getCacheServiceProxy() {
        return this.__m_CacheServiceProxy;
    }

    public InterceptorRegistry getInterceptorRegistry() {
        return null;
    }

    public InvocationServiceProxy getInvocationServiceProxy() {
        return this.__m_InvocationServiceProxy;
    }

    protected String getListenAddress(Member member) {
        if (member instanceof RemoteMember) {
            return member.getAddress().getHostAddress();
        }
        ServiceMemberSet setMember = this.getServiceMemberSet();
        if (setMember == null) {
            return null;
        }
        ObservableMap map = setMember.getMemberConfigMap(member.getId());
        return map == null ? null : (String)map.get("listen-address");
    }

    protected Collection getListenAddresses(Member member) {
        if (member instanceof RemoteMember) {
            return Collections.singleton(member.getAddress());
        }
        ServiceMemberSet setMember = this.getServiceMemberSet();
        return setMember == null ? null : ProxyService.getListenAddresses(setMember.getMemberConfigMap(member.getId()));
    }

    public static Collection getListenAddresses(Map mapConfig) {
        if (mapConfig == null) {
            return null;
        }
        String sAddrList = (String)mapConfig.get("listen-addresses");
        if (sAddrList == null) {
            return null;
        }
        String[] saAddr = sAddrList.split(",");
        HashSet<InetAddress> colAddr = new HashSet<InetAddress>(saAddr.length);
        int i = 0;
        while (i < saAddr.length) {
            try {
                colAddr.add(InetAddress.getByName(saAddr[i++]));
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        return colAddr;
    }

    protected Integer getListenPort(Member member) {
        if (member instanceof RemoteMember) {
            return member.getPort();
        }
        ObservableMap map = this.getServiceMemberSet().getMemberConfigMap(member.getId());
        return (Integer)map.get("listen-port");
    }

    protected String getListenSocketAddress(Member member) {
        String sAddress = this.getListenAddress(member);
        if (sAddress == null) {
            return null;
        }
        if (!(sAddress.indexOf(58) >= 0) ? false : sAddress.charAt(0) != '[') {
            sAddress = new StringBuilder(String.valueOf('[')).append(sAddress).append(']').toString();
        }
        return new StringBuilder(String.valueOf(sAddress)).append(':').append(this.getListenPort(member)).toString();
    }

    public ProxyServiceLoadBalancer getLoadBalancer() {
        return this.__m_LoadBalancer;
    }

    public NamedMap getMap(String Param_1, NamedMap.Option[] Param_2) {
        return null;
    }

    public NavigableSet getMemberListenAddresses() {
        return this.__m_MemberListenAddresses;
    }

    public String getName() {
        return null;
    }

    protected NameService getNameService() {
        return (NameService)this.getCluster().getResourceRegistry().getResource(ProxyService.__sm0());
    }

    protected Object[] getRoutableAddress(Member member, NameService.RequestContext ctx) {
        return ProxyService.getRoutableAddress(member, member instanceof RemoteMember ? null : this.getServiceMemberSet().getMemberConfigMap(member.getId()), this.getCluster(), ctx);
    }

    protected Object[] getRoutableAddress(Member member, Socket socket) {
        InetAddress addrLocal;
        boolean fLocalSrc;
        if (socket == null) {
            fLocalSrc = true;
            addrLocal = null;
        } else {
            fLocalSrc = InetAddresses.isLocalAddress(InetAddresses.getAddress(socket.getRemoteSocketAddress()));
            addrLocal = socket.getLocalAddress();
        }
        return ProxyService.getRoutableAddress(member, member instanceof RemoteMember ? null : this.getServiceMemberSet().getMemberConfigMap(member.getId()), this.getCluster(), addrLocal, fLocalSrc);
    }

    public static Object[] getRoutableAddress(Member member, Map mapMemberConfig, Cluster cluster, NameService.RequestContext ctx) {
        InetAddress addrSource = ctx.getSourceAddress();
        return ProxyService.getRoutableAddress(member, mapMemberConfig, cluster, ctx.getAcceptAddress(), addrSource == null ? false : InetAddresses.isLocalAddress(addrSource));
    }

    public static Object[] getRoutableAddress(Member member, Map mapMemberConfig, Cluster cluster, InetAddress addrLocal, boolean fLocalSrc) {
        Object[] objectArray;
        if (member instanceof RemoteMember) {
            return new Object[]{member.getAddress().getHostAddress(), member.getPort()};
        }
        Collection<InetAddress> colAddresses = InetAddressHelper.getRoutableAddresses(addrLocal, fLocalSrc, ProxyService.getListenAddresses(mapMemberConfig), InetAddresses.isLocalAddress(member.getAddress()));
        String sProtocol = (String)mapMemberConfig.get("http-protocol");
        if (colAddresses == null ? true : colAddresses.isEmpty()) {
            objectArray = null;
        } else if (sProtocol == null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = colAddresses.iterator().next().getHostAddress();
            objectArray = objectArray2;
            objectArray2[1] = mapMemberConfig.get("listen-port");
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = colAddresses.iterator().next().getHostAddress();
            objectArray3[1] = mapMemberConfig.get("listen-port");
            objectArray = objectArray3;
            objectArray3[2] = sProtocol;
        }
        return objectArray;
    }

    protected Object[] getRoutableAddress(Collection colMembers, NameService.RequestContext ctx) {
        Object[] result = null;
        Iterator iter = colMembers.iterator();
        while (!iter.hasNext() ? false : result == null) {
            result = this.getRoutableAddress((Member)iter.next(), ctx);
        }
        return result;
    }

    public static Set getRoutableMemberAddresses(ServiceMemberSet setMembers, Cluster cluster, NameService.RequestContext ctx) {
        InetAddress addrSource = ctx.getSourceAddress();
        return ProxyService.getRoutableMemberAddresses(setMembers, cluster, ctx.getAcceptAddress(), addrSource == null ? false : InetAddresses.isLocalAddress(addrSource));
    }

    public static Set getRoutableMemberAddresses(ServiceMemberSet setMembers, Cluster cluster, InetAddress addrLocal, boolean fLocalSrc) {
        TreeSet<String> setResult = new TreeSet<String>();
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            int nMemberID;
            Member member = (Member)iter.next();
            Object[] aoAddress = ProxyService.getRoutableAddress(member, setMembers.getMemberConfigMap(nMemberID = member.getId()), cluster, addrLocal, fLocalSrc);
            if (!(aoAddress != null)) continue;
            if (aoAddress.length > 2) {
                setResult.add(new StringBuilder().append(aoAddress[0]).append(':').append(aoAddress[1]).append(':').append(aoAddress[2]).toString());
                continue;
            }
            setResult.add(new StringBuilder().append(aoAddress[0]).append(':').append(aoAddress[1]).toString());
        }
        return setResult;
    }

    public Set getRoutableMemberAddresses(Socket socket) {
        InetAddress addrLocal;
        boolean fLocalSrc;
        if (socket == null) {
            fLocalSrc = true;
            addrLocal = null;
        } else {
            fLocalSrc = InetAddresses.isLocalAddress(InetAddresses.getAddress(socket.getRemoteSocketAddress()));
            addrLocal = socket.getLocalAddress();
        }
        return ProxyService.getRoutableMemberAddresses(this.getServiceMemberSet(), this.getCluster(), addrLocal, fLocalSrc);
    }

    public String getScopeName() {
        return null;
    }

    public Service getService(String Param_1) {
        return null;
    }

    public ProxyService$ServiceLoad getServiceLoad() {
        ProxyService$ServiceLoad load = this.__m_ServiceLoad;
        if (load == null) {
            load = new ProxyService$ServiceLoad();
            this.setServiceLoad(load);
        }
        return load;
    }

    public Map getServiceLoadMap() {
        return this.__m_ServiceLoadMap;
    }

    public ProxyService$ServiceLoad getServiceLoadPublished() {
        return this.__m_ServiceLoadPublished;
    }

    public long getServiceLoadTimeMillis() {
        return this.__m_ServiceLoadTimeMillis;
    }

    public String getServiceType() {
        return "Proxy";
    }

    public NamedTopic getTopic(String Param_1, NamedCollection.Option[] Param_2) {
        return null;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ProxyService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ProxyService();
    }

    private final Component get_Module() {
        return this;
    }

    protected XmlElement initServiceConfig() {
        XmlElement xmlConfig = super.initServiceConfig();
        ActionPolicy quorumPolicy = this.getActionPolicy();
        String sQuorumPolicy = quorumPolicy == null ? "none" : quorumPolicy.getClass().getName();
        xmlConfig.addAttribute("quorum-policy").setString(sQuorumPolicy);
        return xmlConfig;
    }

    public boolean isActive() {
        return false;
    }

    public boolean isCacheActive(String Param_1, ClassLoader Param_2) {
        return false;
    }

    public boolean isMapActive(String Param_1, ClassLoader Param_2) {
        return false;
    }

    public boolean isRunning() {
        ConnectionAcceptor acceptor;
        if (super.isRunning() && (acceptor = this.getAcceptor()) != null) {
            if (acceptor.isRunning()) {
                return true;
            }
            this.stop();
        }
        return false;
    }

    public boolean isTopicActive(String Param_1, ClassLoader Param_2) {
        return false;
    }

    protected void onDependencies(ServiceDependencies deps) {
        block11: {
            ProxyServiceLoadBalancer balancer;
            super.onDependencies(deps);
            ProxyServiceDependencies proxyDeps = (ProxyServiceDependencies)deps;
            ActionPolicy policy = (ActionPolicy)proxyDeps.getActionPolicyBuilder().realize(this.createResolver(), this.getContextClassLoader(), null);
            this.setActionPolicy(policy);
            OperationalContext ctx = this.getOperationalContext();
            if (ctx == null) {
                throw new IllegalStateException("missing required OperationalContext");
            }
            CacheServiceProxy cacheServiceProxy = new CacheServiceProxy();
            this.setCacheServiceProxy(cacheServiceProxy);
            cacheServiceProxy.setDependencies(proxyDeps.getCacheServiceProxyDependencies());
            cacheServiceProxy.setContextClassLoader(this.getContextClassLoader());
            InvocationServiceProxy invocationServiceProxy = new InvocationServiceProxy();
            this.setInvocationServiceProxy(invocationServiceProxy);
            invocationServiceProxy.setDependencies(proxyDeps.getInvocationServiceProxyDependencies());
            ConnectionAcceptor acceptor = Acceptor.createAcceptor(proxyDeps.getAcceptorDependencies(), ctx);
            this.setAcceptor(acceptor);
            if (acceptor instanceof Acceptor) {
                Acceptor acceptorImpl = (Acceptor)acceptor;
                String sAcceptorServiceName = new StringBuilder(String.valueOf(this.getThreadName())).append(':').append(acceptorImpl.getServiceName()).toString();
                acceptorImpl.setServiceName(sAcceptorServiceName);
                acceptorImpl.setParentService(this);
                acceptorImpl.setDefaultGuardTimeout(this.getDefaultGuardTimeout());
                if (acceptor instanceof HttpAcceptor ^ true) {
                    Acceptor$DaemonPool pool = (Acceptor$DaemonPool)acceptorImpl.getDaemonPool();
                    int cThreads = proxyDeps.getWorkerThreadCountMin();
                    if (cThreads > 0) {
                        pool.setDaemonCount(cThreads);
                        pool.setDaemonCountMax(proxyDeps.getWorkerThreadCountMax());
                        pool.setDaemonCountMin(cThreads);
                        pool.setHungThreshold(proxyDeps.getTaskHungThresholdMillis());
                        pool.setName(sAcceptorServiceName);
                        pool.setTaskTimeout(proxyDeps.getTaskTimeoutMillis());
                        pool.setThreadPriority(proxyDeps.getWorkerThreadPriority());
                        cacheServiceProxy.setDaemonPool(pool);
                        invocationServiceProxy.setDaemonPool(pool);
                    }
                }
            }
            acceptor.registerProtocol(CacheServiceProtocol.getInstance());
            acceptor.registerProtocol(InvocationServiceProtocol.getInstance());
            acceptor.registerProtocol(NamedCacheProtocol.getInstance());
            if (this.getCacheServiceProxy().isEnabled()) {
                acceptor.registerReceiver(this.getCacheServiceProxy());
            }
            if (this.getInvocationServiceProxy().isEnabled()) {
                acceptor.registerReceiver(this.getInvocationServiceProxy());
            }
            if (acceptor instanceof HttpAcceptor) {
                cacheServiceProxy.setPassThroughEnabled(false);
                ((HttpAcceptor)acceptor).setSession(this);
            } else if (acceptor instanceof MemcachedAcceptor) {
                cacheServiceProxy.setPassThroughEnabled(false);
            }
            ServiceLoadBalancerBuilder builder = proxyDeps.getLoadBalancerBuilder();
            if (!(builder != null) || !((balancer = (ProxyServiceLoadBalancer)builder.realize(this.createResolver(), this.getContextClassLoader(), null)) != null)) break block11;
            this.setLoadBalancer(balancer);
            try {
                balancer.init(this);
            }
            catch (RuntimeException e) {
                Base.ensureRuntimeException(e, "error initializing load balancer");
            }
        }
    }

    protected void onNotify() {
        super.onNotify();
        long UPDATE_PERIOD = 10000L;
        if (this.getServiceLoadTimeMillis() + UPDATE_PERIOD <= Base.getLastSafeTimeMillis()) {
            ProxyService$ServiceLoad load = this.getServiceLoad();
            ConnectionAcceptor acceptor = this.getAcceptor();
            if (acceptor instanceof Acceptor) {
                Acceptor acceptorImpl = (Acceptor)acceptor;
                load.setConnectionPendingCount(acceptorImpl.getConnectionPendingSet().size());
                DaemonPool pool = acceptorImpl.getDaemonPool();
                if (pool.isStarted()) {
                    load.setDaemonActiveCount(pool.getActiveDaemonCount());
                    load.setMessageBacklogIncoming(pool.getBacklog());
                }
                if (acceptor instanceof TcpAcceptor) {
                    int cBacklog = 0;
                    try {
                        Iterator iter = acceptorImpl.getConnectionSet().iterator();
                        while (iter.hasNext()) {
                            TcpAcceptor$TcpConnection conn = (TcpAcceptor$TcpConnection)iter.next();
                            if (!(conn != null)) continue;
                            cBacklog += conn.getOutgoingQueue().size();
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        // empty catch block
                    }
                    load.setMessageBacklogOutgoing(cBacklog);
                }
            }
            this.updateServiceLoad();
        }
    }

    public void onNotifyConnectionClosed(ProxyService$NotifyConnectionClosed msg) {
        Registry registry;
        Connection connection = msg.getConnection();
        if (connection instanceof TcpAcceptor$TcpConnection && (registry = this.getCluster().getManagement()) != null) {
            String sName = new StringBuilder(String.valueOf(registry.ensureGlobalName(new StringBuilder(String.valueOf(Registry.CONNECTION_TYPE)).append(",name=").append(this.getServiceName()).toString()))).append(",UUID=").append(connection.getId()).toString();
            registry.unregister(sName);
        }
        ProxyService$ServiceLoad load = this.getServiceLoad();
        load.updateConnectionCount(-1);
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load, connection);
    }

    public void onNotifyConnectionOpened(ProxyService$NotifyConnectionOpened msg) {
        Registry registry;
        Connection connection = msg.getConnection();
        if (connection instanceof TcpAcceptor$TcpConnection && (registry = this.getCluster().getManagement()) != null) {
            String sName = new StringBuilder(String.valueOf(registry.ensureGlobalName(new StringBuilder(String.valueOf(Registry.CONNECTION_TYPE)).append(",name=").append(this.getServiceName()).toString()))).append(",UUID=").append(connection.getId()).toString();
            registry.register(sName, connection);
        }
        ProxyService$ServiceLoad load = this.getServiceLoad();
        load.updateConnectionCount(1);
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load, connection);
    }

    public void onNotifyServiceJoined(com.tangosol.coherence.component.net.Member member) {
        ConnectionAcceptor acceptor;
        super.onNotifyServiceJoined(member);
        ObservableMap map = this.getServiceMemberSet().getMemberConfigMap(member.getId());
        Map mapLoad = (Map)map.get("service-load");
        if (mapLoad != null) {
            ProxyService$ServiceLoadListener listener = (ProxyService$ServiceLoadListener)this._newChild("ServiceLoadListener");
            listener.setMember(member);
            ProxyService$ServiceLoad load = new ProxyService$ServiceLoad();
            load.fromMap(mapLoad);
            load.setListener(listener);
            this.getServiceLoadMap().put(member, load);
            map.addMapListener(listener);
            this.updateLoadBalancer(member, load, null);
        }
        if ((acceptor = this.getAcceptor()) instanceof TcpAcceptor ? true : acceptor instanceof HttpAcceptor) {
            this.getMemberListenAddresses().add(this.getListenSocketAddress(member));
        }
    }

    public void onNotifyServiceLeft(com.tangosol.coherence.component.net.Member member) {
        NavigableSet setAddr = this.getMemberListenAddresses();
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (!(setAddr.isEmpty() ^ true) ? false : (acceptor instanceof TcpAcceptor ? true : acceptor instanceof HttpAcceptor)) {
            setAddr.remove(this.getListenSocketAddress(member));
        }
        super.onNotifyServiceLeft(member);
        ProxyService$ServiceLoad load = (ProxyService$ServiceLoad)this.getServiceLoadMap().remove(member);
        if (load != null) {
            ProxyService$ServiceLoadListener listener = load.getListener();
            if (listener != null) {
                this.getServiceMemberSet().getMemberConfigMap(member.getId()).removeMapListener(listener);
            }
            this.updateLoadBalancer(member, null, null);
        }
    }

    public void onRedirectRequest(ProxyService$RedirectRequest request) {
        boolean fRedirect = false;
        Connection connection = request.getConnection();
        if (connection instanceof TcpAcceptor$TcpConnection) {
            com.tangosol.coherence.component.net.Member memberThis;
            List list;
            TcpAcceptor$TcpConnection connectionImpl = (TcpAcceptor$TcpConnection)connection;
            ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
            if ((balancer == null ? true : connectionImpl.isRedirect()) ? true : connectionImpl.isRedirectSupported() ^ true) {
                list = null;
            } else {
                Subject subject = connection.getChannel(0).getSubject();
                if (subject == null) {
                    list = balancer.getMemberList(connectionImpl.getMember());
                } else {
                    ProxyService$LoadBalancerActionGetList action = new ProxyService$LoadBalancerActionGetList();
                    action.setBalancer(balancer);
                    action.setConnection(connectionImpl);
                    list = (List)Subject.doAs(subject, action);
                }
            }
            if ((!(list != null) ? false : list.isEmpty() ^ true) && !Base.equals(memberThis = this.getThisMember(), list.get(0))) {
                boolean fConnectionPendingUpdated = false;
                ArrayList<Object[]> listAddr = new ArrayList<Object[]>(list.size());
                Socket socket = connectionImpl.getSocket();
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Member member = (Member)iter.next();
                    if (Base.equals(memberThis, member)) break;
                    Object[] result = this.getRoutableAddress(member, socket);
                    if (!(result != null)) continue;
                    listAddr.add(result);
                    if (!(fConnectionPendingUpdated ^ true)) continue;
                    ProxyService$ServiceLoad load = (ProxyService$ServiceLoad)this.getServiceLoadMap().get(member);
                    if (load != null) {
                        load.updateConnectionPendingCount(1);
                        this.updateLoadBalancer(member, load, connectionImpl);
                    }
                    fConnectionPendingUpdated = true;
                }
                if (listAddr.isEmpty() ^ true) {
                    connectionImpl.setRedirect(true);
                    connectionImpl.setRedirectList(listAddr);
                    fRedirect = true;
                }
            }
        }
        Grid$Response response = (Grid$Response)this.instantiateMessage("Response");
        request.ensureRequestPoll().setResult(fRedirect);
        response.respondTo(request);
        this.send(response);
    }

    public void onServiceStarted() {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        Iterator iter = this.getServiceMemberSet().iterator();
        while (iter.hasNext()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            if (!(Base.equals(member, memberThis) ^ true)) continue;
            this.onNotifyServiceJoined(member);
        }
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor instanceof TcpAcceptor ? true : acceptor instanceof HttpAcceptor) {
            this.getMemberListenAddresses().add(this.getListenSocketAddress(memberThis));
            try {
                NameService service = this.getNameService();
                if (service != null) {
                    service.bind(this.getServiceName(), this);
                }
            }
            catch (Throwable e) {
                Component._trace(new StringBuilder(String.valueOf("Failed to bind \"")).append(this.getServiceName()).append("\" to the NameService: ").append(e).toString(), 2);
            }
        }
        super.onServiceStarted();
    }

    protected void onServiceStarting() {
        boolean fIsTcp;
        super.onServiceStarting();
        ConnectionAcceptor acceptor = this.getAcceptor();
        acceptor.setContextClassLoader(this.getContextClassLoader());
        acceptor.setConnectionFilter(this);
        if (acceptor instanceof Acceptor) {
            Acceptor acceptorImpl = (Acceptor)acceptor;
            this.getCacheServiceProxy().setSerializer(acceptorImpl.ensureSerializer());
            this.getInvocationServiceProxy().setSerializer(acceptorImpl.ensureSerializer());
        } else {
            this.getCacheServiceProxy().setSerializer(this.ensureSerializer());
            this.getInvocationServiceProxy().setSerializer(this.ensureSerializer());
        }
        ProxyService$ServiceLoad load = this.getServiceLoad();
        if (acceptor instanceof Acceptor) {
            Acceptor acceptorImpl = (Acceptor)acceptor;
            load.setConnectionLimit(acceptorImpl.getConnectionLimit());
            load.setDaemonCount(acceptorImpl.getDaemonPool().getDaemonCount());
        }
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load, null);
        if (acceptor instanceof TcpAcceptor) {
            ((TcpAcceptor)acceptor).addConnectionListener(this);
        }
        if (acceptor instanceof Acceptor) {
            this.guard(((Acceptor)acceptor).getGuardable());
        }
        acceptor.start();
        Registry registry = this.getCluster().getManagement();
        if (registry != null) {
            String sName = registry.ensureGlobalName(new StringBuilder(String.valueOf(Registry.CONNECTION_MANAGER_TYPE)).append(",name=").append(this.getServiceName()).toString());
            registry.register(sName, acceptor);
        }
        boolean fIsHttp = !((fIsTcp = acceptor instanceof TcpAcceptor) ^ true) ? false : acceptor instanceof HttpAcceptor;
        if (fIsTcp ? true : fIsHttp) {
            InetSocketAddress32 sockAddr;
            LiteMap<String, Object> map = new LiteMap<String, Object>();
            String sProtocol = null;
            if (fIsTcp) {
                sockAddr = (InetSocketAddress32)((TcpAcceptor)acceptor).getProcessor().getServerSocket().getLocalSocketAddress();
            } else {
                HttpAcceptor acceptorImpl = (HttpAcceptor)acceptor;
                sockAddr = new InetSocketAddress32(acceptorImpl.getListenAddress(), acceptorImpl.getListenPort());
                sProtocol = acceptorImpl.getSocketProvider() instanceof SSLSocketProvider ? "https" : "http";
            }
            InetAddress addr = sockAddr.getAddress();
            map.put("listen-address", addr.getHostAddress());
            map.put("listen-port", sockAddr.getPort());
            if (sProtocol != null) {
                map.put("http-protocol", sProtocol);
            }
            Collection<InetAddress> colAddr = addr.isAnyLocalAddress() ? InetAddresses.getLocalBindableAddresses() : Collections.singletonList(addr);
            StringJoiner sjFull = new StringJoiner(",");
            Iterator<InetAddress> iter = colAddr.iterator();
            while (iter.hasNext()) {
                sjFull.add(iter.next().getHostAddress());
            }
            map.put("listen-addresses", sjFull.toString());
            this.getThisMemberConfigMap().putAll(map);
        }
    }

    protected void onServiceStopped() {
        block5: {
            NameService service;
            super.onServiceStopped();
            ConnectionAcceptor acceptor = this.getAcceptor();
            acceptor.stop();
            this.updateLoadBalancer(this.getThisMember(), null, null);
            Registry registry = this.getCluster().getManagement();
            if (registry != null) {
                String sName = registry.ensureGlobalName(new StringBuilder(String.valueOf(Registry.CONNECTION_MANAGER_TYPE)).append(",name=").append(this.getServiceName()).toString());
                registry.unregister(sName);
            }
            if (!(acceptor instanceof TcpAcceptor ? true : acceptor instanceof HttpAcceptor)) break block5;
            String sAddr = this.getListenSocketAddress(this.getThisMember());
            if (sAddr != null) {
                this.getMemberListenAddresses().remove(sAddr);
            }
            if ((service = this.getNameService()) != null) {
                try {
                    service.unbind(this.getServiceName());
                }
                catch (Throwable e) {
                    Component._trace(new StringBuilder(String.valueOf("Failed to unbind \"")).append(this.getServiceName()).append("\" from the NameService: ").append(e).toString(), 2);
                }
            }
        }
    }

    protected void onServiceStopping() {
        super.onServiceStopping();
        this.getAcceptor().shutdown();
    }

    public void resetStats() {
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor instanceof Acceptor) {
            ((Acceptor)acceptor).resetStats();
        }
        super.resetStats();
    }

    public Object resolve(NameService.RequestContext ctx) {
        ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
        Object[] result = null;
        List<Member> list = balancer == null ? null : balancer.getMemberList(ctx.getMember());
        if (list != null) {
            result = this.getRoutableAddress(list, ctx);
        }
        if (result == null) {
            Set setRemainingMembers;
            if (list == null) {
                setRemainingMembers = this.getServiceMemberSet();
            } else {
                setRemainingMembers = new HashSet(this.getServiceMemberSet());
                setRemainingMembers.removeAll(list);
            }
            result = this.getRoutableAddress(Base.randomize(setRemainingMembers), ctx);
        }
        if (result == null) {
            com.tangosol.coherence.component.net.Member member = this.getThisMember();
            result = new Object[]{this.getListenAddress(member), this.getListenPort(member)};
            Component._trace(new StringBuilder(String.valueOf("No route could be determined from ")).append(ctx.getMember()).append(" to \"").append(this.getServiceName()).append("\".  Returning \"").append(result[0]).append(':').append(InetAddressHelper.toString((Integer)result[1])).append('\"').toString(), 2);
        }
        return result;
    }

    protected void setAcceptor(ConnectionAcceptor acceptor) {
        Component._assert(this.getAcceptor() == null);
        this.__m_Acceptor = acceptor;
    }

    protected void setCacheServiceProxy(CacheServiceProxy proxy) {
        Component._assert(this.getCacheServiceProxy() == null);
        this.__m_CacheServiceProxy = proxy;
    }

    public void setContextClassLoader(ClassLoader loader) {
        CacheServiceProxy proxy;
        super.setContextClassLoader(loader);
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor != null) {
            acceptor.setContextClassLoader(loader);
        }
        if ((proxy = this.getCacheServiceProxy()) != null) {
            proxy.setContextClassLoader(loader);
        }
    }

    protected void setInvocationServiceProxy(InvocationServiceProxy proxy) {
        Component._assert(this.getInvocationServiceProxy() == null);
        this.__m_InvocationServiceProxy = proxy;
    }

    protected void setLoadBalancer(ProxyServiceLoadBalancer balancer) {
        Component._assert(balancer != null);
        this.__m_LoadBalancer = balancer;
    }

    protected void setMemberListenAddresses(NavigableSet setMember) {
        this.__m_MemberListenAddresses = setMember;
    }

    protected void setServiceLoad(ProxyService$ServiceLoad load) {
        this.__m_ServiceLoad = load;
    }

    protected void setServiceLoadMap(Map map) {
        Component._assert(map != null);
        this.__m_ServiceLoadMap = map;
    }

    protected void setServiceLoadPublished(ProxyService$ServiceLoad load) {
        this.__m_ServiceLoadPublished = load;
    }

    protected void setServiceLoadTimeMillis(long c) {
        this.__m_ServiceLoadTimeMillis = c;
    }

    public void updateLoadBalancer(Member member, ProxyService$ServiceLoad load, Connection connection) {
        ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
        if (balancer != null) {
            Subject subject;
            if (load != null) {
                ProxyService$ServiceLoad loadService = new ProxyService$ServiceLoad();
                loadService.fromMap(load.toMap());
                load = loadService;
            }
            if ((subject = connection instanceof TcpAcceptor$TcpConnection ? ((TcpAcceptor$TcpConnection)connection).getChannel(0).getSubject() : null) == null) {
                balancer.update(member, load);
            } else {
                ProxyService$LoadBalancerActionUpdate action = new ProxyService$LoadBalancerActionUpdate();
                action.setBalancer(balancer);
                action.setLoad(load);
                action.setmember(member);
                Subject.doAs(subject, action);
            }
        }
    }

    protected void updateServiceLoad() {
        ProxyService$ServiceLoad load = this.getServiceLoad();
        ProxyService$ServiceLoad loadLast = this.getServiceLoadPublished();
        ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
        if (loadLast == null ? true : (balancer == null ? load.compareTo(loadLast) : balancer.compare(load, loadLast)) != 0) {
            Map mapLoad = load.toMap();
            this.getThisMemberConfigMap().put("service-load", mapLoad);
            if (loadLast == null) {
                loadLast = new ProxyService$ServiceLoad();
                this.setServiceLoadPublished(loadLast);
            }
            loadLast.fromMap(mapLoad);
        }
        this.setServiceLoadTimeMillis(Base.getSafeTimeMillis());
    }

    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        ActionPolicy quorumPolicy = this.getActionPolicy();
        String sQuorumPolicy = quorumPolicy == null ? "none" : quorumPolicy.getClass().getName();
        String QUORUM_DEFAULT_LEGACY = "com.tangosol.net.ConfigurableQuorumPolicy$WrapperQuorumPolicy";
        String QUORUM_DEFAULT_12211 = "com.tangosol.util.NullImplementation$NullActionPolicy";
        String sQuorumGlobal = xmlConfig.getSafeAttribute("quorum-policy").getString();
        if (QUORUM_DEFAULT_LEGACY.equals(sQuorumGlobal)) {
            sQuorumGlobal = QUORUM_DEFAULT_12211;
        }
        return !super.validateServiceConfig(xmlConfig) ? false : this.verifyFeature("QuorumPolicy", sQuorumPolicy, sQuorumGlobal);
    }
}

