/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.tangosol.application.ContainerHelper;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$BackingMapContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$BinaryMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.license.LicenseException;
import com.tangosol.net.CacheService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceStoppedException;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.aggregator.AbstractAsynchronousAggregator;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.filter.PartitionedFilter;
import com.tangosol.util.processor.AbstractAsynchronousProcessor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartitionedCache$ViewMap
extends Util
implements ClassLoaderAware,
NamedCache {
    private boolean __m_Active;
    private volatile PartitionedCache$BinaryMap __m_BinaryMap;
    private String __m_CacheName;
    private ClassLoader __m_ClassLoader;
    private transient NamedCache __m_ConverterMap;
    private Listeners __m_DeactivationListeners;
    private boolean __m_Destroyed;
    private transient Converter __m_FromBinaryConverter;
    private transient Converter __m_KeyToBinaryConverter;
    private boolean __m_PassThrough;
    private boolean __m_Released;
    private transient Converter __m_ValueToBinaryConverter;
    private static transient long __s_LicenseMsgTimestamp;

    public PartitionedCache$ViewMap() {
        this(null, null, true);
    }

    public PartitionedCache$ViewMap(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setActive(true);
            this.setDeactivationListeners(new Listeners());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.ensureBinaryMap().addIndex(extractor, fOrdered, comparator);
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        if (!(listener instanceof MapListenerSupport.SynchronousListener) ? false : Thread.currentThread() == this.getService().getThread()) {
            Component._trace(new StringBuilder(String.valueOf("SynchronousListener cannot be added on the service thread:\n")).append(Component.get_StackTrace()).toString(), 1);
            return;
        }
        if (listener instanceof NamedCacheDeactivationListener) {
            this.getDeactivationListeners().add(listener);
            return;
        } else if (listener instanceof MapTriggerListener) {
            if (!(filter == null)) throw new UnsupportedOperationException("Filter-based MapTriggers are not supported");
            MapTrigger trigger = ((MapTriggerListener)listener).getTrigger();
            this.ensureBinaryMap().addMapListener(null, null, trigger, fLite);
            return;
        } else if (filter instanceof InKeySetFilter) {
            Set setBinKeys = this.retrieveBinaryKeys((InKeySetFilter)filter);
            this.ensureBinaryMap().addMapListener(this.instantiateProxyListener(listener), setBinKeys, fLite, MapListenerSupport.isPrimingListener(listener));
            return;
        } else {
            if (MapListenerSupport.isPrimingListener(listener)) {
                throw new UnsupportedOperationException("Priming listeners are only supported with InKeySetFilter");
            }
            this.ensureBinaryMap().addMapListener(this.instantiateProxyListener(listener), filter, null, fLite);
        }
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        if (!(listener instanceof MapListenerSupport.SynchronousListener) ? false : Thread.currentThread() == this.getService().getThread()) {
            Component._trace(new StringBuilder(String.valueOf("SynchronousListener cannot be added on the service thread:\n")).append(Component.get_StackTrace()).toString(), 1);
            return;
        }
        if (listener instanceof MapTriggerListener) {
            throw new UnsupportedOperationException("Key-based MapTriggers are not supported");
        }
        this.ensureBinaryMap().addMapListener(this.instantiateProxyListener(listener), this.getKeyToBinaryConverter().convert(oKey), fLite, MapListenerSupport.isPrimingListener(listener));
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        AbstractAsynchronousAggregator asyncAggr = null;
        if (agent instanceof AbstractAsynchronousAggregator && (agent = (asyncAggr = (AbstractAsynchronousAggregator)((Object)agent)).getAggregator()) instanceof InvocableMap.StreamingAggregator ^ true) {
            throw new UnsupportedOperationException("StreamingAggregator required");
        }
        if (agent == null) {
            throw new IllegalArgumentException("Aggregator must be specified");
        }
        PartitionSet partitions = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            PartitionSet parts = filterPart.getPartitionSet();
            this.validatePartitionCount(parts);
            partitions = new PartitionSet(parts);
            filter = filterPart.getFilter();
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("LimitFilter cannot be used with aggregate");
        }
        this.prepareParallelQuery(filter);
        PriorityTask taskHolder = agent instanceof PriorityTask ? (PriorityTask)((Object)agent) : null;
        try {
            InvocableMap.EntryAggregator aggregator;
            if (agent instanceof InvocableMap.StreamingAggregator) {
                aggregator = agent;
                return asyncAggr == null ? this.aggregateStreaming(filter, (InvocableMap.StreamingAggregator)aggregator, partitions, taskHolder) : this.aggregateAsync(filter, aggregator, partitions, taskHolder, asyncAggr);
            }
            if (agent instanceof InvocableMap.ParallelAwareAggregator) {
                aggregator = (InvocableMap.ParallelAwareAggregator)((Object)agent);
                return this.resultParallel((InvocableMap.ParallelAwareAggregator)aggregator, this.aggregatePart(filter, aggregator.getParallelAggregator(), partitions, taskHolder));
            }
            return agent.aggregate(InvocableMapHelper.makeEntrySet(this.entrySet(filter)));
        }
        catch (RequestTimeoutException e) {
            throw this.processAggregateTimeout(e, agent);
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Aggregation", e);
            return agent.aggregate(InvocableMapHelper.makeEntrySet(this.localEntrySet(filter)));
        }
    }

    public Object aggregate(Collection colKeys, InvocableMap.EntryAggregator agent) {
        AbstractAsynchronousAggregator asyncAggr = null;
        if (agent instanceof AbstractAsynchronousAggregator && (agent = (asyncAggr = (AbstractAsynchronousAggregator)((Object)agent)).getAggregator()) instanceof InvocableMap.StreamingAggregator ^ true) {
            throw new UnsupportedOperationException("StreamingAggregator required");
        }
        if (agent == null) {
            throw new IllegalArgumentException("Aggregator must be specified");
        }
        PriorityTask taskHolder = agent instanceof PriorityTask ? (PriorityTask)((Object)agent) : null;
        try {
            if (agent instanceof InvocableMap.StreamingAggregator) {
                InvocableMap.StreamingAggregator aggregator = agent;
                return asyncAggr == null ? this.aggregateStreaming(colKeys, aggregator, taskHolder) : this.aggregateAsync(colKeys, aggregator, taskHolder, asyncAggr);
            }
            if (agent instanceof InvocableMap.ParallelAwareAggregator) {
                InvocableMap.ParallelAwareAggregator aggregator = (InvocableMap.ParallelAwareAggregator)((Object)agent);
                return this.resultParallel(aggregator, this.aggregatePart(colKeys, aggregator.getParallelAggregator(), taskHolder));
            }
        }
        catch (RequestTimeoutException e) {
            throw this.processAggregateTimeout(e, agent);
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Aggregation", e);
        }
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this.getAll(colKeys), colKeys, true));
    }

    protected List aggregateAsync(Filter filter, InvocableMap.EntryAggregator aggregator, PartitionSet partitions, PriorityTask taskHolder, AbstractAsynchronousAggregator asyncAggr) {
        Converter convDown;
        Converter convUp;
        if (this.isPassThrough()) {
            PartitionedCache$BackingMapContext context = this.getService().getBackingMapContext();
            convUp = context.getValueFromInternalConverter();
            convDown = context.getValueToInternalConverter();
        } else {
            convUp = this.getFromBinaryConverter();
            convDown = this.getValueToBinaryConverter();
        }
        if (partitions == null) {
            partitions = this.getService().instantiatePartitionSet(true);
        }
        this.ensureBinaryMap().aggregateAsync(filter, (Binary)convDown.convert(aggregator), partitions, taskHolder, asyncAggr, convUp);
        return null;
    }

    protected List aggregateAsync(Collection colKeys, InvocableMap.EntryAggregator aggregator, PriorityTask taskHolder, AbstractAsynchronousAggregator asyncAggr) {
        ConverterCollections.ConverterCollection colBinKeys;
        Converter convKeyDown = this.getKeyToBinaryConverter();
        Converter convValDown = this.getValueToBinaryConverter();
        Converter convUp = this.getFromBinaryConverter();
        ConverterCollections.ConverterCollection converterCollection = colBinKeys = colKeys instanceof Set ? ConverterCollections.getSet((Set)colKeys, convKeyDown, convUp) : ConverterCollections.getCollection(colKeys, convKeyDown, convUp);
        if (this.isPassThrough()) {
            PartitionedCache$BackingMapContext context = this.getService().getBackingMapContext();
            convValDown = context.getValueToInternalConverter();
            convUp = context.getValueFromInternalConverter();
        }
        Binary binAgent = (Binary)convValDown.convert(aggregator);
        this.ensureBinaryMap().aggregateAsync(colBinKeys, binAgent, taskHolder, asyncAggr, convUp);
        return null;
    }

    protected List aggregatePart(Filter filter, InvocableMap.EntryAggregator aggregator, PartitionSet partitions, PriorityTask taskHolder) {
        PartitionedCache$BinaryMap mapBinary = this.ensureBinaryMap();
        if (this.isPassThrough()) {
            Binary binAgent = (Binary)this.getService().getBackingMapContext().getValueToInternalConverter().convert(aggregator);
            return partitions == null ? (List)mapBinary.aggregate(filter, binAgent, taskHolder) : (List)mapBinary.aggregate(filter, binAgent, partitions, taskHolder);
        }
        Binary binAgent = (Binary)this.getValueToBinaryConverter().convert(aggregator);
        return partitions == null ? (List)mapBinary.aggregate(filter, binAgent, taskHolder) : (List)mapBinary.aggregate(filter, binAgent, partitions, taskHolder);
    }

    protected List aggregatePart(Collection colKeys, InvocableMap.EntryAggregator aggregator, PriorityTask taskHolder) {
        ConverterCollections.ConverterCollection colBinKeys;
        Converter convKeyDown = this.getKeyToBinaryConverter();
        Converter convValDown = this.getValueToBinaryConverter();
        Converter convUp = this.getFromBinaryConverter();
        ConverterCollections.ConverterCollection converterCollection = colBinKeys = colKeys instanceof Set ? ConverterCollections.getSet((Set)colKeys, convKeyDown, convUp) : ConverterCollections.getCollection(colKeys, convKeyDown, convUp);
        if (this.isPassThrough()) {
            PartitionedCache$BackingMapContext context = this.getService().getBackingMapContext();
            convValDown = context.getValueToInternalConverter();
            convUp = context.getValueFromInternalConverter();
        }
        PartitionedCache$BinaryMap mapBinary = this.ensureBinaryMap();
        Binary binAgent = (Binary)convValDown.convert(aggregator);
        return (List)mapBinary.aggregate(colBinKeys, binAgent, taskHolder);
    }

    protected Object aggregateStreaming(Filter filter, InvocableMap.StreamingAggregator aggregator, PartitionSet partitions, PriorityTask taskHolder) {
        if (partitions == null) {
            partitions = this.getService().instantiatePartitionSet(true);
        }
        block0 : switch (aggregator.characteristics() & (InvocableMap.StreamingAggregator.PARALLEL | InvocableMap.StreamingAggregator.SERIAL | InvocableMap.StreamingAggregator.BY_MEMBER | InvocableMap.StreamingAggregator.BY_PARTITION)) {
            case 2: 
            case 6: {
                Map mapByOwner = this.getService().splitByOwner(partitions, 0, null);
                aggregator = aggregator.supply();
                Iterator iter = mapByOwner.values().iterator();
                while (iter.hasNext()) {
                    PartitionSet partMember = (PartitionSet)iter.next();
                    if (this.streamingCombine(aggregator, this.aggregatePart(filter, aggregator, partMember, taskHolder)) ^ true) break block0;
                }
                break;
            }
            case 10: {
                PartitionSet partSingle = new PartitionSet(partitions.getPartitionCount());
                aggregator = aggregator.supply();
                while (partitions.isEmpty() ^ true) {
                    int nPart = partitions.rnd();
                    partitions.remove(nPart);
                    partSingle.add(nPart);
                    if (this.streamingCombine(aggregator, this.aggregatePart(filter, aggregator, partSingle, taskHolder)) ^ true) break block0;
                    partSingle.remove(nPart);
                }
                break;
            }
            default: {
                List listBinParts = this.aggregatePart(filter, aggregator, partitions, taskHolder);
                aggregator = aggregator.supply();
                this.streamingCombine(aggregator, listBinParts);
            }
        }
        return this.resultStreaming(aggregator);
    }

    protected Object aggregateStreaming(Collection colKeys, InvocableMap.StreamingAggregator aggregator, PriorityTask taskHolder) {
        block0 : switch (aggregator.characteristics() & (InvocableMap.StreamingAggregator.PARALLEL | InvocableMap.StreamingAggregator.SERIAL | InvocableMap.StreamingAggregator.BY_MEMBER | InvocableMap.StreamingAggregator.BY_PARTITION)) {
            case 2: 
            case 6: {
                Map mapByOwner = this.splitKeysByOwner(colKeys.iterator());
                aggregator = aggregator.supply();
                Iterator iter = mapByOwner.values().iterator();
                while (iter.hasNext()) {
                    Set setMember = (Set)iter.next();
                    if (this.streamingCombine(aggregator, this.aggregatePart(setMember, aggregator, taskHolder)) ^ true) break block0;
                }
                break;
            }
            case 10: {
                Map mapByPartition = this.splitKeysByPartition(colKeys.iterator());
                aggregator = aggregator.supply();
                Iterator iter = mapByPartition.values().iterator();
                while (iter.hasNext()) {
                    Set setPart = (Set)iter.next();
                    if (this.streamingCombine(aggregator, this.aggregatePart(setPart, aggregator, taskHolder)) ^ true) break block0;
                }
                break;
            }
            default: {
                List listBinParts = this.aggregatePart(colKeys, aggregator, taskHolder);
                aggregator = aggregator.supply();
                this.streamingCombine(aggregator, listBinParts);
            }
        }
        return this.resultStreaming(aggregator);
    }

    public void clear() {
        this.ensureBinaryMap().clear();
    }

    public boolean containsKey(Object oKey) {
        return this.ensureConverterMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.ensureConverterMap().containsValue(oValue);
    }

    public void destroy() {
        this.getCacheService().destroyCache(this);
        this.setDestroyed(true);
    }

    protected PartitionedCache$BinaryMap ensureBinaryMap() {
        PartitionedCache$BinaryMap map = this.getBinaryMap();
        if (map == null) {
            throw this.onInvalidAccess();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedCache ensureConverterMap() {
        NamedCache map = this.getConverterMap();
        if (map == null) {
            PartitionedCache$ViewMap partitionedCache$ViewMap = this;
            synchronized (partitionedCache$ViewMap) {
                map = this.getConverterMap();
                if (map == null) {
                    map = ConverterCollections.getNamedCache(this.ensureBinaryMap(), this.getFromBinaryConverter(), this.getKeyToBinaryConverter(), this.getFromBinaryConverter(), this.getValueToBinaryConverter());
                    this.setConverterMap(map);
                }
            }
        }
        return map;
    }

    public Set entrySet() {
        return this.ensureConverterMap().entrySet();
    }

    public Set entrySet(Filter filter) {
        if (filter == null) {
            return this.entrySet();
        }
        PartitionSet partitions = null;
        Filter filterOrig = filter;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            PartitionSet parts = filterPart.getPartitionSet();
            this.validatePartitionCount(parts);
            partitions = new PartitionSet(parts);
            filter = filterPart.getFilter();
        }
        if (filter instanceof LimitFilter) {
            LimitFilter filterLimit = (LimitFilter)filter;
            filterLimit.setComparator(null);
            filterLimit.setTopAnchor(null);
            filterLimit.setBottomAnchor(null);
        }
        this.prepareParallelQuery(filter);
        try {
            if (partitions == null) {
                return this.ensureConverterMap().entrySet(filter);
            }
            Converter convUp = this.getFromBinaryConverter();
            return ConverterCollections.getEntrySet(this.ensureBinaryMap().entrySet(filter, partitions), convUp, this.getKeyToBinaryConverter(), convUp, this.getValueToBinaryConverter());
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Query", e);
            return this.localEntrySet(filterOrig);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestIncomplete(e, PartitionedCache$BinaryMap.RESPONSE_SET);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set entrySet(Filter filter, Comparator comparator) {
        EntryComparator comparatorEntry;
        Object[] aEntry;
        int nPage;
        int cSkip;
        int cPageSize;
        LimitFilter filterLimitOrig;
        block27: {
            PartitionedCache service = this.getService();
            PartitionSet partitions = null;
            Filter filterOrig = filter;
            if (filter instanceof KeyAssociatedFilter) {
                KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
                partitions = this.makePartitionSet(filterAssoc.getHostKey());
                filter = filterAssoc.getFilter();
            } else if (filter instanceof PartitionedFilter) {
                PartitionedFilter filterPart = (PartitionedFilter)filter;
                PartitionSet parts = filterPart.getPartitionSet();
                this.validatePartitionCount(parts);
                partitions = new PartitionSet(parts);
                filter = filterPart.getFilter();
            }
            filterLimitOrig = null;
            cPageSize = 0;
            cSkip = 0;
            Object oAnchorTop = null;
            Object oAnchorBottom = null;
            nPage = 0;
            if (filter instanceof LimitFilter) {
                filterLimitOrig = (LimitFilter)filter;
                if (comparator == null) {
                    comparator = SafeComparator.INSTANCE;
                }
                filterLimitOrig.setComparator(comparator);
                cPageSize = filterLimitOrig.getPageSize();
                filter = (LimitFilter)filterLimitOrig.clone();
                nPage = filterLimitOrig.getPage();
                if (nPage == 0) {
                    filterLimitOrig.setTopAnchor(null);
                    filterLimitOrig.setBottomAnchor(null);
                } else {
                    oAnchorTop = filterLimitOrig.getTopAnchor();
                    oAnchorBottom = filterLimitOrig.getBottomAnchor();
                    if (!(oAnchorTop == null) ? false : oAnchorBottom == null) {
                        cSkip = cPageSize * nPage;
                        ((LimitFilter)filter).setPage(0);
                        ((LimitFilter)filter).setPageSize(cSkip + cPageSize);
                    }
                }
            }
            this.prepareParallelQuery(filter);
            Object[] aEntryCur = null;
            aEntry = null;
            int cPageTotal = cSkip + cPageSize;
            comparatorEntry = new EntryComparator(comparator);
            if (filter instanceof LimitFilter) {
                if (this.isPassThrough()) {
                    int cMembers = service.getOwnershipMemberSet().size();
                    ((LimitFilter)filter).setBatchSize(cMembers);
                } else {
                    partitions = service.instantiatePartitionSet(true);
                    filterLimitOrig.setComparator(comparatorEntry);
                    if (cSkip > 0) {
                        filterLimitOrig.setPageSize(cPageTotal);
                        filterLimitOrig.setPage(0);
                    }
                }
            }
            try {
                if (partitions == null) {
                    Set setEntries = this.ensureConverterMap().entrySet(filter, comparator);
                    aEntry = setEntries.toArray();
                    break block27;
                }
                while (partitions.isEmpty() ^ true) {
                    Converter convUp = this.getFromBinaryConverter();
                    ConverterCollections.ConverterEntrySet setEntries = ConverterCollections.getEntrySet(this.ensureBinaryMap().entrySet(filter, comparator, partitions), convUp, this.getKeyToBinaryConverter(), convUp, this.getValueToBinaryConverter());
                    aEntry = setEntries.toArray();
                    int cEntries = setEntries.size();
                    if (!(filter instanceof LimitFilter) ? false : aEntryCur != null) {
                        Object[] ao = new Object[aEntryCur.length + aEntry.length];
                        System.arraycopy(aEntry, 0, ao, 0, aEntry.length);
                        System.arraycopy(aEntryCur, 0, ao, aEntry.length, aEntryCur.length);
                        aEntry = ao;
                    }
                    if (!partitions.isEmpty()) {
                        Arrays.sort(aEntry, comparatorEntry);
                        aEntryCur = aEntry = filterLimitOrig.extractPage(aEntry);
                        if (!(!(cEntries >= cPageTotal) ? false : aEntry.length >= cPageTotal)) continue;
                        if (oAnchorTop != null) {
                            ((LimitFilter)filter).setBottomAnchor(((Map.Entry)aEntry[aEntry.length - 1]).getValue());
                            continue;
                        }
                        if (!(oAnchorBottom != null)) continue;
                        ((LimitFilter)filter).setTopAnchor(((Map.Entry)aEntry[0]).getValue());
                        continue;
                    }
                    break;
                }
            }
            catch (LicenseException e) {
                PartitionedCache$ViewMap.reportMissingLicense("Query", e);
                return this.localEntrySet(filterOrig, comparator);
            }
            catch (RequestTimeoutException e) {
                throw this.processRequestIncomplete(e, PartitionedCache$BinaryMap.RESPONSE_VOID);
            }
        }
        if (this.isPassThrough() ^ true) {
            Arrays.sort(aEntry, comparatorEntry);
            if (filterLimitOrig != null) {
                int cEntries;
                filterLimitOrig.setPageSize(cPageSize);
                if (cSkip > 0) {
                    cEntries = Math.min(Math.max(0, aEntry.length - cSkip), cPageSize);
                    if (cEntries > 0) {
                        Object[] ao = new Object[cEntries];
                        System.arraycopy(aEntry, cSkip, ao, 0, cEntries);
                        aEntry = ao;
                    } else {
                        aEntry = new Object[]{};
                    }
                } else {
                    aEntry = filterLimitOrig.extractPage(aEntry);
                    cEntries = aEntry.length;
                }
                if (cEntries > 0) {
                    filterLimitOrig.setTopAnchor(((Map.Entry)aEntry[0]).getValue());
                    filterLimitOrig.setBottomAnchor(((Map.Entry)aEntry[cEntries - 1]).getValue());
                }
                filterLimitOrig.setPage(nPage);
                filterLimitOrig.setPageSize(cPageSize);
                filterLimitOrig.setComparator(comparator);
            }
        }
        return new ImmutableArrayList(aEntry);
    }

    public Object get(Object oKey) {
        return this.ensureConverterMap().get(oKey);
    }

    public Map getAll(Collection colKeys) {
        try {
            return this.ensureConverterMap().getAll(colKeys);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestIncomplete(e, PartitionedCache$BinaryMap.RESPONSE_MAP);
        }
    }

    public PartitionedCache$BinaryMap getBinaryMap() {
        return this.__m_BinaryMap;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return (PartitionedCache)this.get_Module();
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    public ClassLoader getContextClassLoader() {
        return this.getClassLoader();
    }

    protected NamedCache getConverterMap() {
        return this.__m_ConverterMap;
    }

    public Listeners getDeactivationListeners() {
        return this.__m_DeactivationListeners;
    }

    public Converter getFromBinaryConverter() {
        return this.__m_FromBinaryConverter;
    }

    public Converter getKeyToBinaryConverter() {
        return this.__m_KeyToBinaryConverter;
    }

    public static long getLicenseMsgTimestamp() {
        return __s_LicenseMsgTimestamp;
    }

    public PartitionedCache getService() {
        return (PartitionedCache)this.get_Module();
    }

    public Converter getValueToBinaryConverter() {
        return this.__m_ValueToBinaryConverter;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ViewMap".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedCache$ViewMap();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected MapListener instantiateProxyListener(MapListener listener) {
        Converter conv = this.getFromBinaryConverter();
        return ContainerHelper.getContextAwareListener(this.getService(), ConverterCollections.getMapListener(this, listener, conv, conv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invalidate(boolean fDestroyed) {
        PartitionedCache$ViewMap partitionedCache$ViewMap = this;
        synchronized (partitionedCache$ViewMap) {
            if (this.isActive() ^ true) {
                return;
            }
            this.setDestroyed(fDestroyed);
            this.setActive(false);
            this.setBinaryMap(null);
            this.setConverterMap(null);
            this.setClassLoader(null);
            this.setFromBinaryConverter(null);
            this.setKeyToBinaryConverter(null);
            this.setValueToBinaryConverter(null);
        }
        Listeners listeners = this.getDeactivationListeners();
        if (listeners.isEmpty() ^ true) {
            com.tangosol.net.cache.CacheEvent<Object, Object> evt = new com.tangosol.net.cache.CacheEvent<Object, Object>(this, MapEvent.ENTRY_DELETED, null, null, null, true);
            CacheEvent.dispatchSafe(evt, listeners, null);
        }
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        AbstractAsynchronousProcessor asyncProc = null;
        if (agent instanceof AbstractAsynchronousProcessor) {
            asyncProc = (AbstractAsynchronousProcessor)agent;
            agent = asyncProc.getProcessor();
        }
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        PriorityTask taskHolder = agent instanceof PriorityTask ? (PriorityTask)((Object)agent) : null;
        try {
            Converter convKeyDown = this.getKeyToBinaryConverter();
            Converter convUp = this.getFromBinaryConverter();
            PartitionedCache$BinaryMap mapBinary = this.ensureBinaryMap();
            Binary binAgent = this.toBinary(agent);
            Binary binKey = (Binary)convKeyDown.convert(oKey);
            if (asyncProc == null) {
                return convUp.convert(mapBinary.invoke(binKey, binAgent, taskHolder));
            }
            mapBinary.invokeAsync(binKey, binAgent, taskHolder, asyncProc, convUp);
            return null;
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this, oKey), agent);
        }
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        PartitionSet partitions;
        AbstractAsynchronousProcessor asyncProc = null;
        if (agent instanceof AbstractAsynchronousProcessor) {
            asyncProc = (AbstractAsynchronousProcessor)agent;
            agent = asyncProc.getProcessor();
        }
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            partitions = new PartitionSet(filterPart.getPartitionSet());
            filter = filterPart.getFilter();
        } else {
            partitions = this.getService().instantiatePartitionSet(true);
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("LimitFilter cannot be used with invokeAll");
        }
        this.prepareParallelQuery(filter);
        Converter convUp = this.getFromBinaryConverter();
        Converter convKeyDown = this.getKeyToBinaryConverter();
        PriorityTask taskHolder = agent instanceof PriorityTask ? (PriorityTask)((Object)agent) : null;
        try {
            Binary binAgent = this.toBinary(agent);
            PartitionedCache$BinaryMap mapBinary = this.ensureBinaryMap();
            if (asyncProc == null) {
                return ConverterCollections.getMap(mapBinary.invokeAll(filter, binAgent, partitions, taskHolder), convUp, convKeyDown, convUp, this.getValueToBinaryConverter());
            }
            mapBinary.invokeAllAsync(filter, binAgent, partitions, taskHolder, asyncProc, convUp);
            return null;
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, this.localKeySet(filter), false), agent);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestIncomplete(e, PartitionedCache$BinaryMap.RESPONSE_MAP);
        }
    }

    public Map invokeAll(Collection colKeys, InvocableMap.EntryProcessor agent) {
        AbstractAsynchronousProcessor asyncProc = null;
        if (agent instanceof AbstractAsynchronousProcessor) {
            asyncProc = (AbstractAsynchronousProcessor)agent;
            agent = asyncProc.getProcessor();
        }
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        PriorityTask taskHolder = agent instanceof PriorityTask ? (PriorityTask)((Object)agent) : null;
        try {
            Binary binAgent = this.toBinary(agent);
            Converter convKeyDown = this.getKeyToBinaryConverter();
            Converter convUp = this.getFromBinaryConverter();
            PartitionedCache$BinaryMap mapBinary = this.ensureBinaryMap();
            ConverterCollections.ConverterCollection colBinKeys = colKeys instanceof Set ? ConverterCollections.getSet((Set)colKeys, convKeyDown, convUp) : ConverterCollections.getCollection(colKeys, convKeyDown, convUp);
            if (asyncProc == null) {
                return ConverterCollections.getMap(mapBinary.invokeAll(colBinKeys, binAgent, taskHolder), convUp, convKeyDown, convUp, this.getValueToBinaryConverter());
            }
            mapBinary.invokeAllAsync(colBinKeys, binAgent, taskHolder, asyncProc, convUp);
            return null;
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, colKeys, false), agent);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestIncomplete(e, PartitionedCache$BinaryMap.RESPONSE_MAP);
        }
        catch (RequestIncompleteException e) {
            throw this.processRequestIncomplete(e, PartitionedCache$BinaryMap.RESPONSE_SET);
        }
    }

    public boolean isActive() {
        return this.__m_Active;
    }

    public boolean isDestroyed() {
        return this.__m_Destroyed;
    }

    public boolean isEmpty() {
        return this.ensureConverterMap().isEmpty();
    }

    public boolean isPassThrough() {
        return this.__m_PassThrough;
    }

    public boolean isReleased() {
        return this.__m_Released;
    }

    public Set keySet() {
        return this.ensureConverterMap().keySet();
    }

    public Set keySet(Filter filter) {
        if (filter == null) {
            return this.keySet();
        }
        PartitionSet partitions = null;
        Filter filterOrig = filter;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        }
        if (filter instanceof LimitFilter) {
            LimitFilter filterLimit = (LimitFilter)filter;
            filterLimit.setComparator(null);
            filterLimit.setTopAnchor(null);
            filterLimit.setBottomAnchor(null);
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            PartitionSet parts = filterPart.getPartitionSet();
            this.validatePartitionCount(parts);
            partitions = new PartitionSet(parts);
            filter = filterPart.getFilter();
        }
        this.prepareParallelQuery(filter);
        try {
            return partitions == null ? this.ensureConverterMap().keySet(filter) : ConverterCollections.getSet(this.ensureBinaryMap().keySet(filter, partitions), this.getFromBinaryConverter(), this.getKeyToBinaryConverter());
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Query", e);
            return this.localKeySet(filterOrig);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestIncomplete(e, PartitionedCache$BinaryMap.RESPONSE_SET);
        }
    }

    protected Set localEntrySet(Filter filter) {
        return InvocableMapHelper.query(this, filter, true, false, null);
    }

    protected Set localEntrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query(this, filter, true, true, comparator);
    }

    protected Set localKeySet(Filter filter) {
        return InvocableMapHelper.query(this, filter, false, false, null);
    }

    public boolean lock(Object oKey) {
        return this.ensureConverterMap().lock(oKey);
    }

    public boolean lock(Object oKey, long lMillis) {
        return this.ensureConverterMap().lock(oKey, lMillis);
    }

    protected PartitionSet makePartitionSet(Object oKey) {
        return this.getService().getKeyPartitioningStrategy().getAssociatedPartitions(oKey);
    }

    protected RuntimeException onInvalidAccess() {
        PartitionedCache service = this.getService();
        if (service.isRunning()) {
            return new IllegalStateException(new StringBuilder(String.valueOf("The distributed cache reference \"")).append(this.getCacheName()).append("\" has been invalidated; no further operations are allowed.").toString());
        }
        return new ServiceStoppedException(new StringBuilder(String.valueOf("Service ")).append(service.getServiceName()).append(" has been terminated").toString());
    }

    protected void prepareParallelQuery(Filter filter) {
        Filter filterTest;
        Filter filter2 = filterTest = filter instanceof LimitFilter ? ((LimitFilter)filter).getFilter() : filter;
        if (filterTest instanceof InKeySetFilter) {
            ((InKeySetFilter)filterTest).ensureConverted(this.getService().getBackingMapContext().getKeyToInternalConverter());
        }
    }

    protected RequestTimeoutException processAggregateTimeout(RequestTimeoutException eTimeout, InvocableMap.EntryAggregator agent) {
        if (this.isPassThrough()) {
            eTimeout.setPartialResult(null);
            return eTimeout;
        }
        Object oResult = eTimeout.getPartialResult();
        if (oResult != null) {
            try {
                if (agent instanceof InvocableMap.StreamingAggregator) {
                    InvocableMap.StreamingAggregator aggregator = (InvocableMap.StreamingAggregator)agent;
                    Converter convUp = this.getFromBinaryConverter();
                    Iterator iter = ((List)oResult).iterator();
                    while (iter.hasNext()) {
                        if (aggregator.combine(convUp.convert(iter.next())) ^ true) break;
                    }
                    oResult = aggregator.finalizeResult();
                } else {
                    InvocableMap.ParallelAwareAggregator aggregator = (InvocableMap.ParallelAwareAggregator)agent;
                    oResult = aggregator.aggregateResults(ConverterCollections.getCollection((List)oResult, this.getFromBinaryConverter(), NullImplementation.getConverter()));
                }
            }
            catch (Throwable e) {
                oResult = null;
            }
        }
        eTimeout.setPartialResult(oResult);
        return eTimeout;
    }

    protected RequestIncompleteException processRequestIncomplete(RequestIncompleteException exception, int nResponseType) {
        if (this.isPassThrough()) {
            exception.setPartialResult(null);
            return exception;
        }
        Serializable oResult = exception.getPartialResult();
        if (oResult != null) {
            try {
                Converter convKeyDown = this.getKeyToBinaryConverter();
                Converter convUp = this.getFromBinaryConverter();
                Converter convNotUsed = NullImplementation.getConverter();
                switch (nResponseType) {
                    case 2: {
                        oResult = ConverterCollections.getSet((Set)((Object)oResult), convUp, convNotUsed);
                        break;
                    }
                    case 3: {
                        oResult = ConverterCollections.getMap((Map)((Object)oResult), convUp, convKeyDown, convUp, convNotUsed);
                        break;
                    }
                    default: {
                        oResult = null;
                        break;
                    }
                }
            }
            catch (Throwable e) {
                oResult = null;
            }
        }
        exception.setPartialResult(oResult);
        return exception;
    }

    public Object put(Object oKey, Object oValue) {
        return this.ensureConverterMap().put(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.ensureConverterMap().put(oKey, oValue, cMillis);
    }

    public void putAll(Map map) {
        try {
            this.ensureConverterMap().putAll(map);
        }
        catch (RequestIncompleteException e) {
            throw this.processRequestIncomplete(e, PartitionedCache$BinaryMap.RESPONSE_SET);
        }
    }

    public void release() {
        this.getCacheService().releaseCache(this);
        this.setReleased(true);
    }

    public Object remove(Object oKey) {
        return this.ensureConverterMap().remove(oKey);
    }

    public void removeIndex(ValueExtractor extractor) {
        this.ensureBinaryMap().removeIndex(extractor);
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeMapListener(MapListener listener, Filter filter) {
        if (listener instanceof NamedCacheDeactivationListener) {
            this.getDeactivationListeners().remove(listener);
            return;
        } else if (listener instanceof MapTriggerListener) {
            if (!(filter == null)) throw new UnsupportedOperationException("Filter-based MapTriggers are not supported");
            MapTrigger trigger = ((MapTriggerListener)listener).getTrigger();
            this.ensureBinaryMap().removeMapListener(null, null, trigger);
            return;
        } else if (filter instanceof InKeySetFilter) {
            Set setBinKeys = this.retrieveBinaryKeys((InKeySetFilter)filter);
            this.ensureBinaryMap().removeMapListener(this.instantiateProxyListener(listener), setBinKeys, MapListenerSupport.isPrimingListener(listener));
            return;
        } else {
            this.ensureBinaryMap().removeMapListener(this.instantiateProxyListener(listener), filter, null);
        }
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        if (listener instanceof MapTriggerListener) {
            throw new UnsupportedOperationException("Key-based MapTriggers are not supported");
        }
        this.ensureBinaryMap().removeMapListener(this.instantiateProxyListener(listener), this.getKeyToBinaryConverter().convert(oKey), MapListenerSupport.isPrimingListener(listener));
    }

    public String reportKey(Object oKey) {
        PartitionedCache service = this.getService();
        return service.reportPartitionOwnership(service.getKeyPartitioningStrategy().getKeyPartition(oKey));
    }

    public String reportKeyDistribution(boolean fVerbose) {
        PartitionedCache service = this.getService();
        KeyPartitioningStrategy strategy = service.getKeyPartitioningStrategy();
        int cPartitions = service.getPartitionCount();
        int[] ac = new int[cPartitions];
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            int n = strategy.getKeyPartition(iter.next());
            ac[n] = ac[n] + 1;
        }
        StringBuffer sb = new StringBuffer("\n");
        double dAverage = (double)this.size() / (double)cPartitions;
        double dStdDev = 0.0;
        int cMax = 0;
        int cMin = Integer.MAX_VALUE;
        int iPartition = 0;
        while (iPartition < cPartitions) {
            int c = ac[iPartition];
            cMax = Math.max(cMax, c);
            cMin = Math.min(cMin, c);
            if (!fVerbose ? false : c > 0) {
                sb.append('\n').append(iPartition).append(": ").append(c);
            }
            double dDiff = dAverage - (double)c;
            dStdDev += dDiff * dDiff;
            ++iPartition;
        }
        return new StringBuilder(String.valueOf("max=")).append(cMax).append("; min=").append(cMin).append("; average=").append((float)dAverage).append("; std dev=").append(Math.sqrt((float)(dStdDev / (double)cPartitions))).append((Object)sb).toString();
    }

    private static void reportMissingLicense(String sFeature, LicenseException e) {
        long ldtMsg = PartitionedCache$ViewMap.getLicenseMsgTimestamp();
        if (ldtMsg == 0L) {
            PartitionedCache$ViewMap.setLicenseMsgTimestamp(Base.getSafeTimeMillis());
            String sMsg = new StringBuilder(String.valueOf("Parallel ")).append(sFeature).append(" is a feature of Coherence Enterprise Edition and Coherence Grid Edition,").append(" and is not available in this Coherence Edition; selecting the default single-threaded Local ").append(sFeature).append(" implementation instead. The single-threaded Local ").append(sFeature).append(" implementation uses significantly more resources (CPU, memory and network) than the Parallel ").append(sFeature).append(" implementation").append(sFeature.equals("Query") ? ", and should not be used for large queries" : "").append(".").toString();
            Component._trace(sMsg, 2);
        }
    }

    public String reportStorage(boolean fPrimary) {
        PartitionedCache service = this.getService();
        PartitionedCache$BinaryMap mapBinary = (PartitionedCache$BinaryMap)service.getReferencesBinaryMap().get(this.getCacheName());
        long lCacheId = mapBinary.getCacheId();
        PartitionedCache$Storage storage = service.getStorage(lCacheId);
        Map map = fPrimary ? storage.getBackingMap() : storage.getBackupMap();
        StringBuffer sb = new StringBuffer();
        sb.append("CacheId=").append(lCacheId).append(", Size=").append(map.size());
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Binary binKey = (Binary)entry.getKey();
            Binary binValue = (Binary)entry.getValue();
            sb.append('\n').append(this.getFromBinaryConverter().convert(binKey)).append(" = ").append(this.getFromBinaryConverter().convert(binValue));
            if (!(fPrimary ? service.isPrimaryOwner(binKey) ^ true : service.isBackupOwner(binKey) ^ true)) continue;
            int iPartition = service.getKeyPartition(binKey);
            int[] aiOwner = service.getPartitionAssignments()[iPartition];
            int nOwner = fPrimary ? aiOwner[0] : aiOwner[1];
            sb.append(" ! owner=").append(nOwner);
        }
        return sb.toString();
    }

    protected Object resultParallel(InvocableMap.ParallelAwareAggregator aggregator, List listBinParts) {
        Converter convUp;
        Converter convDown;
        boolean fPassThrough = this.isPassThrough();
        if (fPassThrough) {
            PartitionedCache$BackingMapContext context = this.getService().getBackingMapContext();
            convDown = context.getValueToInternalConverter();
            convUp = context.getValueFromInternalConverter();
        } else {
            convDown = this.getValueToBinaryConverter();
            convUp = this.getFromBinaryConverter();
        }
        Object oResult = aggregator.aggregateResults(ConverterCollections.getCollection(listBinParts, convUp, convDown));
        return fPassThrough ? convDown.convert(oResult) : oResult;
    }

    protected Object resultStreaming(InvocableMap.StreamingAggregator aggregator) {
        Object oResult = aggregator.finalizeResult();
        return this.isPassThrough() ? this.getService().getBackingMapContext().getValueToInternalConverter().convert(oResult) : oResult;
    }

    private Set retrieveBinaryKeys(InKeySetFilter filterKeys) {
        return ConverterCollections.getSet(filterKeys.getKeys(), this.getKeyToBinaryConverter(), this.getFromBinaryConverter());
    }

    protected void setActive(boolean fActive) {
        this.__m_Active = fActive;
    }

    public void setBinaryMap(PartitionedCache$BinaryMap map) {
        if (this.isActive()) {
            Component._assert(!(this.getBinaryMap() == null) ? false : map != null);
            this.setCacheName(map.getCacheName());
        } else {
            Component._assert(map == null);
        }
        this.__m_BinaryMap = map;
    }

    protected void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setClassLoader(ClassLoader loader) {
        if (this.isActive()) {
            Component._assert(!(this.getClassLoader() == null) ? false : loader != null);
            PartitionedCache service = this.getService();
            if (loader == NullImplementation.getClassLoader()) {
                this.setKeyToBinaryConverter(service.instantiateKeyToBinaryConverter(null, true));
                this.setValueToBinaryConverter(NullImplementation.getConverter());
                this.setFromBinaryConverter(ExternalizableHelper.CONVERTER_STRIP_INTDECO);
                this.setPassThrough(true);
            } else {
                this.setKeyToBinaryConverter(service.instantiateKeyToBinaryConverter(loader, false));
                this.setValueToBinaryConverter(service.instantiateValueToBinaryConverter(loader));
                this.setFromBinaryConverter(service.instantiateFromBinaryConverter(loader));
            }
        } else {
            Component._assert(loader == null);
        }
        this.__m_ClassLoader = loader;
    }

    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    protected void setConverterMap(NamedCache map) {
        if (this.isActive()) {
            Component._assert(!(this.getConverterMap() == null) ? false : map != null);
        } else {
            Component._assert(map == null);
        }
        this.__m_ConverterMap = map;
    }

    protected void setDeactivationListeners(Listeners listeners) {
        this.__m_DeactivationListeners = listeners;
    }

    protected void setDestroyed(boolean fDestroyed) {
        this.__m_Destroyed = fDestroyed;
    }

    protected void setFromBinaryConverter(Converter conv) {
        this.__m_FromBinaryConverter = conv;
    }

    protected void setKeyToBinaryConverter(Converter conv) {
        this.__m_KeyToBinaryConverter = conv;
    }

    private static void setLicenseMsgTimestamp(long ldt) {
        __s_LicenseMsgTimestamp = ldt;
    }

    protected void setPassThrough(boolean fPass) {
        this.__m_PassThrough = fPass;
    }

    protected void setReleased(boolean fReleased) {
        this.__m_Released = fReleased;
    }

    protected void setValueToBinaryConverter(Converter conv) {
        this.__m_ValueToBinaryConverter = conv;
    }

    public int size() {
        return this.ensureConverterMap().size();
    }

    protected Map splitKeysByOwner(Iterator iterKeys) {
        PartitionedCache service = this.getService();
        HashMap mapByOwner = new HashMap();
        while (iterKeys.hasNext()) {
            Object oKey = iterKeys.next();
            Member member = service.getKeyOwner(oKey);
            HashSet setMember = (HashSet)mapByOwner.get(member);
            if (setMember == null) {
                setMember = new HashSet();
                mapByOwner.put(member, setMember);
            }
            setMember.add(oKey);
        }
        return mapByOwner;
    }

    protected Map splitKeysByPartition(Iterator iterKeys) {
        KeyPartitioningStrategy strategy = this.getService().getKeyPartitioningStrategy();
        HashMap mapByPID = new HashMap();
        while (iterKeys.hasNext()) {
            Object oKey = iterKeys.next();
            Integer IPartition = strategy.getKeyPartition(oKey);
            HashSet setPart = (HashSet)mapByPID.get(IPartition);
            if (setPart == null) {
                setPart = new HashSet();
                mapByPID.put(IPartition, setPart);
            }
            setPart.add(oKey);
        }
        return mapByPID;
    }

    protected boolean streamingCombine(InvocableMap.StreamingAggregator aggregator, List listBinParts) {
        Converter convUp = this.isPassThrough() ? this.getService().getBackingMapContext().getValueFromInternalConverter() : this.getFromBinaryConverter();
        Iterator iter = listBinParts.iterator();
        while (iter.hasNext()) {
            if (!(aggregator.combine(convUp.convert(iter.next())) ^ true)) continue;
            return false;
        }
        return true;
    }

    protected Binary toBinary(Object o) {
        if (this.isPassThrough()) {
            return (Binary)this.getService().getBackingMapContext().getValueToInternalConverter().convert(o);
        }
        Converter conv = this.getValueToBinaryConverter();
        if (conv == null) {
            throw this.onInvalidAccess();
        }
        return (Binary)conv.convert(o);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getCacheName()).append(", ClassLoader=").append(this.getClassLoader()).append(", ServiceName=").append(this.getService().getServiceName()).append('}');
        return sb.toString();
    }

    public void truncate() {
        this.ensureBinaryMap().truncate();
    }

    public boolean unlock(Object oKey) {
        return this.ensureConverterMap().unlock(oKey);
    }

    protected void validatePartitionCount(PartitionSet parts) {
        int cPartitionThis;
        int cPartitionThat = parts.getPartitionCount();
        if (cPartitionThat != (cPartitionThis = this.getService().getPartitionCount())) {
            throw new IllegalArgumentException(new StringBuilder(String.valueOf("The specified ")).append(parts).append(" uses a partition-count of ").append(cPartitionThat).append(" that does not match the service's partition-count ").append(cPartitionThis).toString());
        }
    }

    public Collection values() {
        return this.ensureConverterMap().values();
    }
}

