/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.InetAddresses;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$MessageFactory;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.memcached.server.MemcachedServer;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.DefaultMemcachedAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.LegacyXmlMemcachedAcceptorHelper;
import com.tangosol.internal.net.service.peer.acceptor.MemcachedAcceptorDependencies;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

public class MemcachedAcceptor
extends Acceptor
implements Executor {
    private String __m_AuthMethod;
    private boolean __m_BinaryPassThru;
    private String __m_CacheName;
    private String __m_LocalAddress;
    private int __m_LocalPort;
    private MemcachedServer __m_MemcachedServer;
    private SocketProvider __m_SocketProvider;
    private static ListMap __mapChildren;

    static {
        MemcachedAcceptor.__initStatic();
    }

    public MemcachedAcceptor() {
        this(null, null, true);
    }

    public MemcachedAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionPendingSet(new SafeHashSet());
            this.setConnectionSet(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Acceptor$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Acceptor$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultMemcachedAcceptorDependencies((MemcachedAcceptorDependencies)deps);
    }

    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlMemcachedAcceptorHelper.fromXml(xml, new DefaultMemcachedAcceptorDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
    }

    public void execute(Runnable task) {
        this.getDaemonPool().add(task);
    }

    public String getAuthMethod() {
        return this.__m_AuthMethod;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public String getDescription() {
        return new StringBuilder(String.valueOf("MemcachedAcceptor :")).append(" LocalAddress=").append(this.getLocalAddress()).append(",LocalPort=").append(this.getLocalPort()).toString();
    }

    public String getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public int getLocalPort() {
        return this.__m_LocalPort;
    }

    public MemcachedServer getMemcachedServer() {
        return this.__m_MemcachedServer;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/MemcachedAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new MemcachedAcceptor();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        throw new UnsupportedOperationException();
    }

    public boolean isBinaryPassThru() {
        return this.__m_BinaryPassThru;
    }

    protected void onDependencies(ServiceDependencies deps) {
        super.onDependencies(deps);
        MemcachedAcceptorDependencies memcachedDeps = (MemcachedAcceptorDependencies)deps;
        this.setMemcachedServer(memcachedDeps.getMemcachedServer());
        this.setSocketProvider(memcachedDeps.getSocketProviderBuilder().realize(null, null, null));
        this.setCacheName(memcachedDeps.getCacheName());
        this.setAuthMethod(memcachedDeps.getAuthMethod());
        this.setBinaryPassThru(memcachedDeps.isBinaryPassThru());
        ParameterizedBuilder<AddressProvider> bldr = memcachedDeps.getAddressProviderBuilder();
        if (bldr != null) {
            AddressProvider provider = bldr.realize(new NullParameterResolver(), this.getContextClassLoader(), null);
            InetSocketAddress address = provider.getNextAddress();
            this.setLocalAddress(address.getAddress().getHostAddress());
            this.setLocalPort(address.getPort());
        }
    }

    protected void onServiceStarting() {
        super.onServiceStarting();
        MemcachedServer server = this.getMemcachedServer();
        Component._assert(server != null);
        try {
            server.setParentService(this.getParentService());
            server.setExecutor(this);
            server.setLocalAddress(this.getLocalAddress());
            server.setLocalPort(this.getLocalPort());
            server.setSocketProvider(this.getSocketProvider());
            server.setCacheName(this.getCacheName());
            server.setAuthMethod(this.getAuthMethod());
            server.setBinaryPassthru(this.isBinaryPassThru());
            server.setIdentityAsserter(this.getOperationalContext().getIdentityAsserter());
            server.start();
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
        String sAddr = this.getLocalAddress();
        if (InetAddresses.isAnyLocalAddress(sAddr)) {
            try {
                sAddr = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        Component._trace(new StringBuilder(String.valueOf("MemcachedAcceptor now listening for connections on ")).append(sAddr).append(':').append(this.getLocalPort()).toString(), 3);
    }

    protected void onServiceStopped() {
        MemcachedServer server = this.getMemcachedServer();
        if (server != null) {
            try {
                server.stop();
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    protected void onServiceStopping() {
        MemcachedServer server = this.getMemcachedServer();
        if (server != null) {
            try {
                server.stop();
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    public void setAuthMethod(String sMethod) {
        this.__m_AuthMethod = sMethod;
    }

    public void setBinaryPassThru(boolean fThru) {
        this.__m_BinaryPassThru = fThru;
    }

    public void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setLocalAddress(String sAddress) {
        this.__m_LocalAddress = sAddress;
    }

    public void setLocalPort(int nPort) {
        this.__m_LocalPort = nPort;
    }

    public void setMemcachedServer(MemcachedServer serverMemcached) {
        this.__m_MemcachedServer = serverMemcached;
    }

    public void setSocketProvider(SocketProvider providerSocket) {
        this.__m_SocketProvider = providerSocket;
    }

    public void submit(Runnable task) {
    }
}

