/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.common.net.SocketProvider;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator$MessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator$TcpConnection;
import com.tangosol.coherence.config.builder.FactoryBasedAddressProviderBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.peer.initiator.DefaultTcpInitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.LegacyXmlTcpInitiatorHelper;
import com.tangosol.internal.net.service.peer.initiator.TcpInitiatorDependencies;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.SocketAddressProvider;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class TcpInitiator
extends Initiator {
    private SocketAddress __m_LocalAddress;
    private SocketAddressProvider __m_RemoteAddressProvider;
    private transient SocketOptions __m_SocketOptions;
    private SocketProvider __m_SocketProvider;
    private SocketProviderFactory __m_SocketProviderFactory;
    private static ListMap __mapChildren;

    static {
        TcpInitiator.__initStatic();
    }

    public TcpInitiator() {
        this(null, null, true);
    }

    public TcpInitiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCloseOnExit(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
            this.setSocketOptions(new SocketOptions());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Peer$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", TcpInitiator$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
        Class clazz4 = __mapChildren.put("TcpConnection", TcpInitiator$TcpConnection.get_CLASS());
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultTcpInitiatorDependencies((TcpInitiatorDependencies)deps);
    }

    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlTcpInitiatorHelper.fromXml(xml, new DefaultTcpInitiatorDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    protected void configureSocket(Socket socket) {
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring Socket");
        }
        SocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            Component._trace(new StringBuilder(String.valueOf("Binding Socket to ")).append(TcpUtil.toString(addr)).toString(), 6);
            try {
                socket.bind(addr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, new StringBuilder(String.valueOf("error binding Socket to ")).append(TcpUtil.toString(addr)).toString());
            }
            if (socket.isBound() ^ true) {
                throw new RuntimeException(new StringBuilder(String.valueOf("could not bind Socket to ")).append(TcpUtil.toString(addr)).toString());
            }
        }
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        sb.append(", SocketProvider=").append(this.getSocketProvider());
        SocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            sb.append(", LocalAddress=").append(TcpUtil.toString(addr));
        }
        sb.append(", RemoteAddresses=").append(this.getRemoteAddressProvider());
        SocketOptions options = this.getSocketOptions();
        if (options != null) {
            sb.append(", ").append(options);
        }
        return sb.toString();
    }

    public SocketAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public SocketAddressProvider getRemoteAddressProvider() {
        return this.__m_RemoteAddressProvider;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public SocketProviderFactory getSocketProviderFactory() {
        SocketProviderFactory factory = this.__m_SocketProviderFactory;
        if (factory == null) {
            OperationalContext ctx = this.getOperationalContext();
            factory = ctx == null ? new SocketProviderFactory() : ctx.getSocketProviderFactory();
            this.setSocketProviderFactory(factory);
        }
        return factory;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpInitiator();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        TcpInitiator$TcpConnection connection = (TcpInitiator$TcpConnection)this._newChild("TcpConnection");
        connection.setConnectionManager(this);
        connection.setRequestSendTimeout(this.getRequestSendTimeout());
        return connection;
    }

    public Socket instantiateSocket() {
        Socket socket;
        try {
            socket = this.getSocketProvider().openSocket();
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e, "error creating Socket");
        }
        this.configureSocket(socket);
        return socket;
    }

    protected void onDependencies(ServiceDependencies deps) {
        AddressProviderFactory factory;
        super.onDependencies(deps);
        TcpInitiatorDependencies tcpDeps = (TcpInitiatorDependencies)deps;
        SocketAddress addrLocal = tcpDeps.getLocalAddress();
        if (addrLocal instanceof InetSocketAddress) {
            InetSocketAddress addrLocalInet = (InetSocketAddress)addrLocal;
            addrLocal = new InetSocketAddress32(addrLocalInet.getAddress(), addrLocalInet.getPort());
        }
        this.setLocalAddress(addrLocal);
        this.setSocketOptions(tcpDeps.getSocketOptions());
        this.setSocketProvider(tcpDeps.getSocketProviderBuilder().realize(null, null, null));
        ParameterizedBuilder bldr = tcpDeps.getRemoteAddressProviderBuilder();
        if (bldr == null && (factory = this.getOperationalContext().getAddressProviderMap().get("cluster-discovery")) != null) {
            bldr = factory instanceof ParameterizedBuilder ? (ParameterizedBuilder)((Object)factory) : new FactoryBasedAddressProviderBuilder(factory);
        }
        if (bldr != null) {
            this.setRemoteAddressProvider(bldr.realize(new NullParameterResolver(), this.getContextClassLoader(), null));
        }
    }

    public void onInit() {
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(java.net.SocketOptions.SO_KEEPALIVE, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.TCP_NODELAY, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.SO_LINGER, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connection openConnection() {
        TcpInitiator$TcpConnection connection;
        SocketAddressProvider provider = this.getRemoteAddressProvider();
        Component._assert(provider != null);
        int cMillis = Math.max(0, (int)this.getConnectTimeout());
        LinkedList<String> listAddr = new LinkedList<String>();
        Iterator iterRedirect = null;
        Exception cause = null;
        block6: while (true) {
            Exception e3;
            String sAddr;
            block15: {
                Iterator iter;
                ArrayList<InetSocketAddress32> listRedirect;
                ConnectionException connectionException;
                boolean bl;
                String sMessage;
                block20: {
                    block18: {
                        block19: {
                            Object var12_15;
                            SocketAddress addr;
                            block17: {
                                connection = (TcpInitiator$TcpConnection)this.instantiateConnection();
                                if (iterRedirect == null ? true : iterRedirect.hasNext() ^ true) {
                                    addr = provider.getNextAddress();
                                    iterRedirect = null;
                                } else {
                                    addr = (SocketAddress)iterRedirect.next();
                                    connection.setRedirect(true);
                                }
                                if (!(addr == null)) break block17;
                                sMessage = new StringBuilder(String.valueOf("could not establish a connection to one of the following addresses: ")).append(listAddr).toString();
                                if (cause == null) break block18;
                                break block19;
                            }
                            if (((InetSocketAddress32)addr).getAddress().isMulticastAddress()) continue;
                            sAddr = TcpUtil.toString(addr);
                            listAddr.add(sAddr);
                            Socket socket = this.instantiateSocket();
                            SafeHashSet setClose = this.getCloseOnExit();
                            setClose.add(socket);
                            try {
                                try {
                                    if (iterRedirect == null) {
                                        Component._trace(new StringBuilder(String.valueOf("Connecting Socket to ")).append(sAddr).toString(), 6);
                                    } else {
                                        Component._trace(new StringBuilder(String.valueOf("Redirecting Socket to ")).append(sAddr).toString(), 6);
                                    }
                                    Blocking.connect(socket, addr, cMillis);
                                    connection.setSocket(socket);
                                }
                                catch (Exception e2) {
                                    Component._trace(new StringBuilder(String.valueOf("Error connecting Socket to ")).append(sAddr).append(": ").append(e2).toString(), 6);
                                    TcpUtil.close(socket);
                                    if (iterRedirect == null ? true : iterRedirect.hasNext() ^ true) {
                                        provider.reject(e2);
                                    }
                                    var12_15 = null;
                                    setClose.remove(socket);
                                    continue;
                                }
                                var12_15 = null;
                                setClose.remove(socket);
                            }
                            catch (Throwable e2) {
                                var12_15 = null;
                                setClose.remove(socket);
                                throw e2;
                            }
                        }
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
                if (bl) {
                    connectionException = new ConnectionException(sMessage);
                    throw connectionException;
                }
                connectionException = new ConnectionException(sMessage, cause);
                throw connectionException;
                try {
                    connection.open();
                    break;
                }
                catch (Exception e3) {
                    if (!(!(iterRedirect == null) ? false : connection.isRedirect())) break block15;
                    List list = connection.getRedirectList();
                    listRedirect = new ArrayList<InetSocketAddress32>(list.size());
                    iter = list.iterator();
                }
                while (true) {
                    if (!iter.hasNext()) {
                        iterRedirect = listRedirect.iterator();
                        continue block6;
                    }
                    Object[] ao = (Object[])iter.next();
                    String s = (String)ao[0];
                    int n = (Integer)ao[1];
                    listRedirect.add(new InetSocketAddress32(s, n));
                }
            }
            cause = e3;
            Component._trace(new StringBuilder(String.valueOf("Error establishing a connection with ")).append(sAddr).append(": ").append(e3).toString(), 6);
            if (!(iterRedirect == null ? true : iterRedirect.hasNext() ^ true)) continue;
            provider.reject(e3);
        }
        provider.accept();
        return connection;
    }

    protected void setLocalAddress(SocketAddress addr) {
        this.__m_LocalAddress = addr;
    }

    public void setRemoteAddressProvider(SocketAddressProvider provider) {
        this.__m_RemoteAddressProvider = provider;
    }

    protected void setSocketOptions(SocketOptions options) {
        Component._assert(options != null);
        this.__m_SocketOptions = options;
    }

    public void setSocketProvider(SocketProvider pSocketProvider) {
        this.__m_SocketProvider = pSocketProvider;
    }

    public void setSocketProviderFactory(SocketProviderFactory factory) {
        this.__m_SocketProviderFactory = factory;
    }
}

