/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config;

import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;

public interface EnvironmentVariableResolver {
    public String getEnv(String var1);

    default public String getEnv(String sVarName, String sDefaultValue) {
        return Optional.ofNullable(this.getEnv(sVarName)).orElse(sDefaultValue);
    }

    public static EnvironmentVariableResolver getInstance() {
        ServiceLoader<EnvironmentVariableResolver> serviceLoader = ServiceLoader.load(EnvironmentVariableResolver.class);
        Iterator<EnvironmentVariableResolver> resolvers = serviceLoader.iterator();
        return resolvers.hasNext() ? resolvers.next() : new Default();
    }

    public static class Default
    implements EnvironmentVariableResolver {
        @Override
        public String getEnv(String sVarName) {
            return System.getenv(sVarName);
        }
    }
}

