/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.InetAddressRangeFilter;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressRangeFilterBuilder
implements ParameterizedBuilder<Filter> {
    private InetAddressRangeFilter m_filter = new InetAddressRangeFilter();
    private boolean m_fFilterAdded = false;
    private IllegalStateException m_exceptionDeferred = null;

    @Override
    public Filter realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        if (this.m_exceptionDeferred != null) {
            throw this.m_exceptionDeferred;
        }
        return this.m_fFilterAdded ? this.m_filter : null;
    }

    public void addAuthorizedHostsToFilter(String sAddrFrom, String sAddrTo) {
        InetAddress addrTo;
        InetAddress addrFrom;
        if (sAddrFrom == null || sAddrFrom.length() == 0) {
            if (sAddrTo != null && sAddrTo.length() != 0) {
                this.m_exceptionDeferred = new IllegalStateException("Error adding host filter.  Both <from-ip> and <to-ip> elements must be specified");
            }
            return;
        }
        try {
            addrFrom = InetAddress.getByName(sAddrFrom);
            addrTo = sAddrTo == null ? addrFrom : InetAddress.getByName(sAddrTo);
        }
        catch (UnknownHostException e) {
            Base.trace("Unresolvable authorized host will be ignored: " + e);
            return;
        }
        this.m_filter.addRange(addrFrom, addrTo);
        this.m_fFilterAdded = true;
    }
}

