/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.builder;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.internal.net.ssl.SSLCertUtility;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.coherence.config.xml.processor.PasswordProviderBuilderProcessor;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.ssl.SSLSocketProviderDefaultDependencies;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.PasswordProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.security.SecurityProvider;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLSocketProviderDependenciesBuilder
implements ParameterizedBuilder<SSLSocketProviderDefaultDependencies> {
    public static final String ACTION_ALLOW = "allow";
    private static final boolean VERIFY_CN_AFTER_SAN = Config.getBoolean("coherence.security.ssl.verifyCNAfterSAN", true);
    private static final boolean ALLOW_LOCALHOST = Config.getBoolean("coherence.security.ssl.allowLocalhost", false);
    private static final String LOCALHOST_HOSTNAME = "localhost";
    private static final String LOCALHOST_IPADDRESS = "127.0.0.1";
    private static final String WILDCARD_DNSNAME_REGEX = "^\\*((\\.[^*.]+){2,})$";
    private static final Pattern WILDCARD_DNSNAME_PATTERN = Pattern.compile("^\\*((\\.[^*.]+){2,})$");
    private static final String URL_HOSTNAME_REGEX = "^[^*.\\s]+((\\.[^*.]+){2,})$";
    private static final Pattern URL_HOSTNAME_PATTERN = Pattern.compile("^[^*.\\s]+((\\.[^*.]+){2,})$");
    private SocketProviderBuilder m_bldrDelegateSocketProvider;
    private ParameterizedBuilder<Executor> m_bldrExecutor;
    private ParameterizedBuilder<HostnameVerifier> m_bldrHostnameVerifier;
    private ProviderBuilder m_bldrProvider;
    private SSLSocketProviderDefaultDependencies m_deps;
    private NameListDependencies m_depsCipherSuite;
    private DefaultManagerDependencies m_depsIdentityManager;
    private NameListDependencies m_depsProtocolVersion;
    private ManagerDependencies m_depsTrustManager;
    private boolean m_fRealized;
    private String m_sNameProtocol;

    public SSLSocketProviderDependenciesBuilder(SSLSocketProviderDefaultDependencies deps) {
        this.m_deps = deps;
        this.m_bldrDelegateSocketProvider = new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER);
        this.m_sNameProtocol = "TLS";
    }

    @Injectable(value="protocol")
    public void setProtocol(String sName) {
        this.m_sNameProtocol = sName;
    }

    public String getProtocol() {
        return this.m_sNameProtocol;
    }

    @Injectable(value="provider")
    public void setProviderBuilder(ProviderBuilder builder) {
        this.m_bldrProvider = builder;
    }

    public ProviderBuilder getProvider() {
        return this.m_bldrProvider;
    }

    @Injectable(value="executor")
    public void setExecutor(ParameterizedBuilder<Executor> bldr) {
        this.m_bldrExecutor = bldr;
    }

    @Injectable(value="identity-manager")
    public void setIdentityManager(DefaultManagerDependencies deps) {
        this.m_depsIdentityManager = deps;
    }

    public DefaultManagerDependencies getIdentityManager() {
        return this.m_depsIdentityManager;
    }

    public ManagerDependencies getTrustManager() {
        return this.m_depsTrustManager;
    }

    @Injectable(value="trust-manager")
    public void setTrustManager(ManagerDependencies deps) {
        this.m_depsTrustManager = deps;
    }

    @Injectable(value="hostname-verifier")
    public void setHostnameVerifierBuilder(ParameterizedBuilder<HostnameVerifier> bldr) {
        this.m_bldrHostnameVerifier = bldr;
    }

    public ParameterizedBuilder<HostnameVerifier> getHostnameVerifierBuilder() {
        return this.m_bldrHostnameVerifier;
    }

    @Injectable(value="cipher-suites")
    public void setCipherSuitesNameList(NameListDependencies deps) {
        this.m_depsCipherSuite = deps;
    }

    @Injectable(value="protocol-versions")
    public void setProtocolVersionsNameList(NameListDependencies deps) {
        this.m_depsProtocolVersion = deps;
    }

    @Injectable(value="socket-provider")
    public void setDelegate(SocketProviderBuilder bldr) {
        this.m_bldrDelegateSocketProvider = bldr;
    }

    public SocketProviderBuilder getSocketProviderBuilder() {
        return this.m_bldrDelegateSocketProvider;
    }

    public synchronized SSLSocketProviderDefaultDependencies realize() {
        if (this.m_fRealized) {
            return this.m_deps;
        }
        SSLSocketProviderDefaultDependencies deps = this.m_deps;
        try {
            SSLEngine engine;
            Provider provider;
            KeyManager[] aKeyManager = null;
            TrustManager[] aTrustManager = null;
            SSLContext ctx = null;
            StringBuffer sbDesc = new StringBuffer();
            Provider provider2 = provider = this.m_bldrProvider == null ? null : this.m_bldrProvider.realize(null, null, null);
            if (provider == null) {
                if (this.m_bldrProvider != null && this.m_bldrProvider.getName() != null) {
                    ctx = SSLContext.getInstance(this.getProtocol(), this.m_bldrProvider.getName());
                }
            } else {
                ctx = SSLContext.getInstance(this.getProtocol(), provider);
            }
            if (ctx == null) {
                ctx = SSLContext.getInstance(this.getProtocol());
            }
            deps.setSSLContext(ctx);
            if (this.m_bldrExecutor == null) {
                deps.setExecutor(SSLSocketProviderDefaultDependencies.DEFAULT_EXECUTOR);
            } else {
                deps.setExecutor(this.m_bldrExecutor.realize(new NullParameterResolver(), null, null));
            }
            DefaultManagerDependencies depsIdMgr = this.getIdentityManager();
            if (depsIdMgr == null) {
                sbDesc.append("identity=unspecified");
            } else {
                KeyManagerFactory factory = null;
                ProviderBuilder bldrProvider = depsIdMgr.getProviderBuilder();
                String sAlgorithm = depsIdMgr.getAlgorithm();
                sbDesc.append("identity=").append(sAlgorithm);
                if (bldrProvider != null) {
                    provider = bldrProvider.realize(null, null, null);
                    if (provider == null) {
                        if (bldrProvider.getName() != null) {
                            factory = KeyManagerFactory.getInstance(sAlgorithm, bldrProvider.getName());
                        }
                    } else {
                        factory = KeyManagerFactory.getInstance(sAlgorithm, provider);
                    }
                }
                if (factory == null) {
                    factory = KeyManagerFactory.getInstance(sAlgorithm);
                }
                DefaultKeystoreDependencies depsKeystore = depsIdMgr.getKeystoreDependencies();
                String sURL = depsKeystore.getURL();
                KeyStore keyStore = this.loadKeyStore(sURL, depsKeystore.getPasswordProvider(), depsKeystore.getType());
                if (sURL != null && sURL.length() > 0) {
                    sbDesc.append('/').append(sURL);
                }
                char[] achPassword = depsIdMgr.getPasswordProvider().get();
                factory.init(keyStore, achPassword);
                aKeyManager = factory.getKeyManagers();
                if (achPassword != null) {
                    Arrays.fill(achPassword, '0');
                }
            }
            ManagerDependencies depsTrustMgr = this.getTrustManager();
            if (depsTrustMgr == null) {
                sbDesc.append(", trust=unspecified");
            } else {
                TrustManagerFactory factory = null;
                ProviderBuilder bldrProvider = depsTrustMgr.getProviderBuilder();
                String sAlgorithm = depsTrustMgr.getAlgorithm();
                sbDesc.append(", trust=").append(sAlgorithm);
                if (bldrProvider != null) {
                    provider = bldrProvider.realize(null, null, null);
                    String sProvider = bldrProvider.getName();
                    if (provider == null) {
                        if (sProvider != null) {
                            factory = TrustManagerFactory.getInstance(sAlgorithm, sProvider);
                        }
                    } else {
                        factory = TrustManagerFactory.getInstance(sAlgorithm, provider);
                    }
                }
                if (factory == null) {
                    factory = TrustManagerFactory.getInstance(sAlgorithm);
                }
                DefaultKeystoreDependencies depsKeystore = depsTrustMgr.getKeystoreDependencies();
                String sURL = depsKeystore.getURL();
                KeyStore keyStore = this.loadKeyStore(sURL, depsKeystore.getPasswordProvider(), depsKeystore.getType());
                if (sURL != null && sURL.length() > 0) {
                    sbDesc.append('/').append(sURL);
                }
                factory.init(keyStore);
                aTrustManager = factory.getTrustManagers();
                deps.setClientAuthenticationRequired(aTrustManager != null);
            }
            ParameterizedBuilder<HostnameVerifier> bldrHostnameVerifier = this.getHostnameVerifierBuilder();
            if (bldrHostnameVerifier != null) {
                deps.setHostnameVerifier(bldrHostnameVerifier.realize(null, null, null));
                sbDesc.append(", hostname-verifier=custom");
            }
            SecureRandom random = new SecureRandom();
            random.nextInt();
            ctx.init(aKeyManager, aTrustManager, random);
            if (this.m_depsCipherSuite != null) {
                List<String> listCipher = this.m_depsCipherSuite.getNameList();
                if (this.m_depsCipherSuite.isBlackList()) {
                    engine = ctx.createSSLEngine();
                    ArrayList<String> listDefaultCipher = new ArrayList<String>(Arrays.asList(engine.getEnabledCipherSuites()));
                    listDefaultCipher.removeAll(listCipher);
                    listCipher = listDefaultCipher;
                }
                deps.setEnabledCipherSuites(listCipher.toArray(new String[listCipher.size()]));
            }
            if (this.m_depsProtocolVersion != null) {
                List<String> listProtocol = this.m_depsProtocolVersion.getNameList();
                if (this.m_depsProtocolVersion.isBlackList()) {
                    engine = ctx.createSSLEngine();
                    ArrayList<String> listDefaultProtocols = new ArrayList<String>(Arrays.asList(engine.getEnabledProtocols()));
                    listDefaultProtocols.removeAll(listProtocol);
                    listProtocol = listDefaultProtocols;
                }
                deps.setEnabledProtocolVersions(listProtocol.toArray(new String[listProtocol.size()]));
            }
            deps.setDelegateSocketProviderBuilder(this.m_bldrDelegateSocketProvider);
            String sAuth = aKeyManager == null && aTrustManager == null ? "none" : (aKeyManager == null && aTrustManager != null ? "one-way client" : (aKeyManager != null && aTrustManager == null ? "one-way server" : "two-way"));
            deps.setDescription(sbDesc.insert(0, "SSLSocketProvider(auth=" + sAuth + ", ").append(')').toString());
            Logger.fine("instantiated SSLSocketProviderDependencies: " + sbDesc.toString());
            this.m_fRealized = true;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid configuration ", e);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        return deps;
    }

    @Override
    public SSLSocketProviderDefaultDependencies realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
        return this.realize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String sURL, PasswordProvider passwordProvider, String sType) throws GeneralSecurityException, IOException {
        char[] achPassword;
        KeyStore keyStore;
        block11: {
            if (sURL == null || sURL.length() == 0) {
                return null;
            }
            keyStore = KeyStore.getInstance(sType);
            InputStream in = null;
            achPassword = null;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                in = loader.getResourceAsStream(new URL(sURL).getFile());
                if (in == null) {
                    in = new URL(sURL).openStream();
                }
                achPassword = passwordProvider.get();
                keyStore.load(in, achPassword);
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (achPassword != null) {
                    Arrays.fill(achPassword, '0');
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (achPassword != null) {
            Arrays.fill(achPassword, '0');
        }
        return keyStore;
    }

    public static class NameListDependencies {
        final String f_sDescription;
        public static final USAGE USAGE_DEFAULT = USAGE.WHITE_LIST;
        private List<String> m_lstNames = new LinkedList<String>();
        private USAGE m_usage = USAGE_DEFAULT;

        public NameListDependencies(String sDescription) {
            this.f_sDescription = sDescription;
        }

        public void add(String sName) {
            this.m_lstNames.add(sName);
        }

        public List<String> getNameList() {
            return this.m_lstNames;
        }

        public void setUsage(String v) {
            this.m_usage = USAGE.myValueOf(v);
        }

        public boolean isBlackList() {
            return this.m_usage == USAGE.BLACK_LIST;
        }

        public static enum USAGE {
            WHITE_LIST("white-list"),
            BLACK_LIST("black-list");

            private final String f_value;

            private USAGE(String s) {
                this.f_value = s;
            }

            public String toString() {
                return this.f_value;
            }

            public static USAGE myValueOf(String v) {
                if ("white-list".equals(v)) {
                    return WHITE_LIST;
                }
                if ("black-list".equals(v)) {
                    return BLACK_LIST;
                }
                throw new IllegalArgumentException("unknown usage value of " + v + "; expected either \"white-list\" or \"black-list\"");
            }

            public boolean equalsName(String otherName) {
                return otherName == null ? false : this.f_value.equals(otherName);
            }
        }
    }

    public static class ProviderBuilder
    implements ParameterizedBuilder<Provider> {
        private String m_sName;
        private ParameterizedBuilder<Provider> m_builder;
        private static boolean m_fRegisteredCoherenceSecurityProvider = false;

        @Injectable(value="name")
        public void setName(String sName) {
            this.m_sName = sName;
            if (!m_fRegisteredCoherenceSecurityProvider && "CoherenceSecurityProvider".equals(sName)) {
                SecurityProvider.ensureRegistration();
            }
        }

        public String getName() {
            return this.m_sName;
        }

        @Injectable(value="provider")
        public void setBuilder(ParameterizedBuilder<Provider> builder) {
            this.m_builder = builder;
        }

        @Override
        public Provider realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            return this.m_builder == null ? null : this.m_builder.realize(resolver, loader, listParameters);
        }
    }

    static class DefaultHostnameVerifier
    implements HostnameVerifier {
        DefaultHostnameVerifier() {
        }

        @Override
        public boolean verify(String sUrlHostname, SSLSession sslSession) {
            boolean fMatched = false;
            if (sUrlHostname != null && sslSession != null) {
                Collection<String> colWildcardDNSNames = SSLCertUtility.getDNSSubjAltNames(sslSession, true, false);
                String sCertHostname = SSLCertUtility.getCommonName(sslSession);
                fMatched = colWildcardDNSNames != null && colWildcardDNSNames.size() > 0 ? (VERIFY_CN_AFTER_SAN ? DefaultHostnameVerifier.verifySANWildcardDNSNames(sUrlHostname, colWildcardDNSNames) || DefaultHostnameVerifier.isLegalWildcarded(sUrlHostname, sCertHostname) : DefaultHostnameVerifier.verifySANWildcardDNSNames(sUrlHostname, colWildcardDNSNames)) : DefaultHostnameVerifier.isLegalWildcarded(sUrlHostname, sCertHostname);
                if (!fMatched) {
                    Collection<String> colSubAltNames = SSLCertUtility.getDNSSubjAltNames(sslSession, false, true);
                    fMatched = colSubAltNames != null && colSubAltNames.size() > 0 ? (VERIFY_CN_AFTER_SAN ? this.doDNSSubjAltNamesVerify(sUrlHostname, colSubAltNames) || this.doVerify(sUrlHostname, sCertHostname) : this.doDNSSubjAltNamesVerify(sUrlHostname, colSubAltNames)) : this.doVerify(sUrlHostname, sCertHostname);
                }
            }
            if (!fMatched) {
                Logger.err("DefaultHostnameVerifier rejecting hostname " + sUrlHostname);
            }
            return fMatched;
        }

        private boolean doVerify(String sUrlHostname, String sCertHostname) {
            if (sCertHostname == null || sCertHostname.length() == 0) {
                return false;
            }
            if (sUrlHostname.equalsIgnoreCase(sCertHostname)) {
                return true;
            }
            if (!ALLOW_LOCALHOST) {
                return false;
            }
            try {
                InetAddress addrLocalhost = InetAddressHelper.getLocalHost();
                String sHostname = addrLocalhost.getHostName();
                if (sHostname.equalsIgnoreCase(sCertHostname)) {
                    if (addrLocalhost.getHostAddress().equalsIgnoreCase(sUrlHostname)) {
                        return true;
                    }
                    if (SSLSocketProviderDependenciesBuilder.LOCALHOST_HOSTNAME.equalsIgnoreCase(sUrlHostname) || SSLSocketProviderDependenciesBuilder.LOCALHOST_IPADDRESS.equalsIgnoreCase(sUrlHostname)) {
                        return true;
                    }
                }
            }
            catch (UnknownHostException e) {
                Logger.err("HostnameVerifier: " + e.getMessage());
            }
            return false;
        }

        private boolean doDNSSubjAltNamesVerify(String sUrlhostname, Collection<String> colDnsAltNames) {
            if (colDnsAltNames != null && !colDnsAltNames.isEmpty()) {
                for (String dnsName : colDnsAltNames) {
                    if (!dnsName.equalsIgnoreCase(sUrlhostname)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isLegalWildcarded(String sURL, String sCommonName) {
            if (sCommonName != null) {
                if (!sCommonName.contains("*")) {
                    return false;
                }
                if (sCommonName.indexOf(".") != sCommonName.lastIndexOf(".") && sCommonName.startsWith("*.") && sCommonName.indexOf("*") == sCommonName.lastIndexOf("*") && DefaultHostnameVerifier.domainMatchesDomain(sURL, sCommonName)) {
                    return true;
                }
            }
            return false;
        }

        private static boolean domainMatchesDomain(String sUrl, String sCommonName) {
            int nIndex = sCommonName.indexOf("*");
            if (nIndex == -1) {
                return false;
            }
            String sStrippedCN = sCommonName.substring(nIndex + 1).toLowerCase();
            String sUrlLower = sUrl.toLowerCase();
            if (!sUrlLower.endsWith(sStrippedCN)) {
                return false;
            }
            if (sUrlLower.lastIndexOf(sStrippedCN) == -1) {
                return false;
            }
            String sUrlBeginning = sUrlLower.substring(0, sUrlLower.length() - sStrippedCN.length());
            if (sUrlBeginning.length() <= 0) {
                return false;
            }
            return !sUrlBeginning.contains(".");
        }

        private static boolean verifySANWildcardDNSNames(String sUrlHostname, Collection<String> colWildcardDNSNames) {
            boolean fMatched = false;
            if (colWildcardDNSNames != null && !colWildcardDNSNames.isEmpty()) {
                Matcher urlHostnameMatcher = URL_HOSTNAME_PATTERN.matcher(sUrlHostname);
                boolean fURLHostnameValid = urlHostnameMatcher.matches();
                for (String sDnsName : colWildcardDNSNames) {
                    Matcher wildCardDNSNameMatcher = WILDCARD_DNSNAME_PATTERN.matcher(sDnsName);
                    if (!wildCardDNSNameMatcher.matches()) continue;
                    String sDomainOfWildcardDNS = wildCardDNSNameMatcher.group(1);
                    if (!fURLHostnameValid) continue;
                    String sDomainOfURL = urlHostnameMatcher.group(1);
                    if (sDomainOfWildcardDNS == null || !sDomainOfWildcardDNS.equalsIgnoreCase(sDomainOfURL)) continue;
                    fMatched = true;
                    break;
                }
            }
            return fMatched;
        }
    }

    public static class HostnameVerifierBuilder
    implements ParameterizedBuilder<HostnameVerifier> {
        private String m_sAction;
        private ParameterizedBuilder<HostnameVerifier> m_builder;

        @Injectable(value="action")
        public void setAction(String sAction) {
            this.m_sAction = sAction;
        }

        public String getAction() {
            return this.m_sAction;
        }

        @Injectable(value="instance")
        public void setBuilder(ParameterizedBuilder<HostnameVerifier> builder) {
            this.m_builder = builder;
        }

        @Override
        public HostnameVerifier realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
            if (this.m_builder != null) {
                return this.m_builder.realize(resolver, loader, listParameters);
            }
            if (SSLSocketProviderDependenciesBuilder.ACTION_ALLOW.equals(this.m_sAction)) {
                return (s, sslSession) -> true;
            }
            return new DefaultHostnameVerifier();
        }
    }

    public static class DefaultManagerDependencies
    implements ManagerDependencies {
        private final String f_sNameManagerKind;
        private ProviderBuilder m_bldrProvider;
        private DefaultKeystoreDependencies m_depsKeystore;
        private String m_sAlgorithm;
        private PasswordProvider m_passProvider;

        public DefaultManagerDependencies(String sNameManagerKind) {
            this.f_sNameManagerKind = sNameManagerKind;
        }

        @Override
        public String getAlgorithm() {
            if (this.m_sAlgorithm == null) {
                if (this.f_sNameManagerKind.equals("trust-manager")) {
                    this.m_sAlgorithm = "SunX509";
                } else if (this.f_sNameManagerKind.equals("identity-manager")) {
                    this.m_sAlgorithm = "SunX509";
                } else {
                    throw new IllegalArgumentException("unknown manager: " + this.f_sNameManagerKind + "; expected either identity-manager or trust-manager");
                }
            }
            return this.m_sAlgorithm;
        }

        @Override
        public ProviderBuilder getProviderBuilder() {
            return this.m_bldrProvider;
        }

        @Override
        public DefaultKeystoreDependencies getKeystoreDependencies() {
            return this.m_depsKeystore;
        }

        @Override
        public PasswordProvider getPasswordProvider() {
            if (null == this.m_passProvider) {
                ParameterizedBuilder<PasswordProvider> bldr = PasswordProviderBuilderProcessor.getNullPasswordProviderBuilder();
                this.m_passProvider = bldr.realize(null, null, null);
            }
            return this.m_passProvider;
        }

        @Injectable(value="password")
        public void setPassword(String sPassword) {
            ParameterizedBuilder<PasswordProvider> bldr = PasswordProviderBuilderProcessor.getPasswordProviderBuilderForPasswordStr(sPassword);
            this.m_passProvider = bldr.realize(null, null, null);
        }

        @Injectable(value="password-provider")
        public void setPasswordProvider(ParameterizedBuilder<PasswordProvider> bldrPasswordProvider) {
            ParameterizedBuilder<PasswordProvider> bldr = bldrPasswordProvider == null ? PasswordProviderBuilderProcessor.getNullPasswordProviderBuilder() : bldrPasswordProvider;
            this.m_passProvider = bldr.realize(null, null, null);
        }

        @Injectable(value="algorithm")
        public void setAlgorithm(String sAlgorithm) {
            this.m_sAlgorithm = sAlgorithm;
        }

        @Injectable(value="key-store")
        public void setKeystore(DefaultKeystoreDependencies deps) {
            this.m_depsKeystore = deps;
        }

        @Injectable(value="provider")
        public void setProviderBuilder(ProviderBuilder m_bldrProvider) {
            this.m_bldrProvider = m_bldrProvider;
        }
    }

    public static class DefaultKeystoreDependencies
    implements KeystoreDependencies {
        private PasswordProvider m_passProvider;
        private String m_sURL;
        private String m_sType = "JKS";

        @Override
        public String getURL() {
            return this.m_sURL;
        }

        @Override
        public String getType() {
            return this.m_sType;
        }

        @Override
        public PasswordProvider getPasswordProvider() {
            if (null == this.m_passProvider) {
                ParameterizedBuilder<PasswordProvider> bldr = PasswordProviderBuilderProcessor.getNullPasswordProviderBuilder();
                this.m_passProvider = bldr.realize(null, null, null);
            }
            return this.m_passProvider;
        }

        @Injectable(value="url")
        public void setURL(String sURL) {
            this.m_sURL = sURL;
        }

        @Injectable(value="type")
        public void setType(String sType) {
            this.m_sType = sType;
        }

        @Injectable(value="password")
        public void setPassword(String sPassword) {
            ParameterizedBuilder<PasswordProvider> bldr = PasswordProviderBuilderProcessor.getPasswordProviderBuilderForPasswordStr(sPassword);
            this.m_passProvider = bldr.realize(null, null, null);
        }

        @Injectable(value="password-provider")
        public void setPasswordProvider(ParameterizedBuilder<PasswordProvider> bldrPassProvider) {
            ParameterizedBuilder<PasswordProvider> bldr = bldrPassProvider == null ? PasswordProviderBuilderProcessor.getNullPasswordProviderBuilder() : bldrPassProvider;
            this.m_passProvider = bldr.realize(null, null, null);
        }
    }

    public static interface ManagerDependencies {
        public String getAlgorithm();

        public ProviderBuilder getProviderBuilder();

        public DefaultKeystoreDependencies getKeystoreDependencies();

        public PasswordProvider getPasswordProvider();
    }

    public static interface KeystoreDependencies {
        public String getURL();

        public String getType();

        public PasswordProvider getPasswordProvider();
    }
}

