/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.preprocessor;

import com.tangosol.config.ConfigurationException;
import com.tangosol.config.xml.DocumentElementPreprocessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import java.util.ArrayList;
import java.util.List;

public class SchemeRefPreprocessor
implements DocumentElementPreprocessor.ElementPreprocessor {
    public static final SchemeRefPreprocessor INSTANCE = new SchemeRefPreprocessor();

    @Override
    public boolean preprocess(ProcessingContext context, XmlElement element) throws ConfigurationException {
        XmlElement xmlSchemeRef = element.getElement("scheme-ref");
        boolean fNullSchemeRef = false;
        if (xmlSchemeRef == null) {
            return false;
        }
        String sSchemeName = xmlSchemeRef.getString().trim();
        if (sSchemeName.isEmpty()) {
            throw new ConfigurationException(String.format("The referenced scheme in %s is blank.", element), "Please ensure that the referenced scheme name is declared in the configuration");
        }
        XmlElement xmlScheme = this.findCachingScheme(sSchemeName, element);
        if (xmlScheme == null) {
            String sXmlNullScheme = "<null-scheme-ref/>";
            xmlScheme = XmlHelper.loadXml(sXmlNullScheme);
            fNullSchemeRef = true;
        }
        if (fNullSchemeRef || xmlScheme.getName().equals(element.getName())) {
            if (element == xmlScheme) {
                throw new ConfigurationException(String.format("Discovered a cyclic reference to scheme [%s] in %s.", xmlSchemeRef.getString(), element), "Please ensure that the referenced scheme won't eventually reference itself.");
            }
            List listElements = element.getElementList();
            listElements.remove(xmlSchemeRef);
            boolean fChanged = false;
            for (XmlElement xmlSchemeChild : xmlScheme.getElementList()) {
                if (element.getElement(xmlSchemeChild.getName()) != null) continue;
                listElements.add(xmlSchemeChild);
                fChanged = true;
            }
            return fChanged;
        }
        throw new ConfigurationException(String.format("The referenced scheme [%s] in %s is a different type of scheme.", xmlSchemeRef.getString(), element), "Please ensure that the referenced scheme is the same type");
    }

    public XmlElement findCachingScheme(String sSchemeName, XmlElement element) {
        XmlElement xmlSchemes = element.getRoot().getElement("schemes");
        XmlElement xmlCachingSchemes = element.getRoot().getElement("caching-schemes");
        ArrayList elements = new ArrayList();
        if (xmlSchemes != null) {
            elements.addAll(xmlSchemes.getElementList());
        }
        if (xmlCachingSchemes != null) {
            elements.addAll(xmlCachingSchemes.getElementList());
        }
        for (XmlElement xml : elements) {
            if (!xml.getSafeElement("scheme-name").getString().trim().equals(sSchemeName)) continue;
            return xml;
        }
        return null;
    }
}

