/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.preprocessor;

import com.tangosol.coherence.config.Config;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.SystemPropertyParameterResolver;
import com.tangosol.config.expression.ValueMacroExpression;
import com.tangosol.config.xml.DocumentElementPreprocessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;

public class SystemPropertyPreprocessor
implements DocumentElementPreprocessor.ElementPreprocessor {
    public static final SystemPropertyPreprocessor INSTANCE = new SystemPropertyPreprocessor();
    private static final String SYSTEM_PROPERTY = "system-property";

    @Override
    public boolean preprocess(ProcessingContext context, XmlElement element) throws ConfigurationException {
        boolean fUpdated = false;
        XmlValue attribute = element.getAttribute(SYSTEM_PROPERTY);
        if (attribute != null) {
            element.setAttribute(SYSTEM_PROPERTY, null);
            try {
                String sName = attribute.getString();
                String sValue = Config.getProperty(sName);
                if (sValue != null) {
                    element.setString(sValue);
                    fUpdated = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fUpdated |= SystemPropertyPreprocessor.processValueMacro(element, context.getDefaultParameterResolver());
    }

    public static boolean processValueMacro(XmlElement element) {
        return SystemPropertyPreprocessor.processValueMacro(element, SystemPropertyParameterResolver.INSTANCE);
    }

    public static boolean processValueMacro(XmlElement element, ParameterResolver resolver) {
        if (ValueMacroExpression.containsMacro(element.getString())) {
            ValueMacroExpression macroExpr = new ValueMacroExpression(element.getString().trim());
            String sValue = macroExpr.evaluate(resolver);
            element.setString(sValue);
            return true;
        }
        return false;
    }
}

