/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.config.xml.processor;

import com.tangosol.coherence.config.CacheConfig;
import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.CacheMappingRegistry;
import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.ResourceMappingRegistry;
import com.tangosol.coherence.config.ServiceSchemeRegistry;
import com.tangosol.coherence.config.TopicMapping;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.scheme.CachingScheme;
import com.tangosol.coherence.config.scheme.ClassScheme;
import com.tangosol.coherence.config.scheme.ExternalScheme;
import com.tangosol.coherence.config.scheme.FlashJournalScheme;
import com.tangosol.coherence.config.scheme.InvocationScheme;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.ObservableCachingScheme;
import com.tangosol.coherence.config.scheme.OverflowScheme;
import com.tangosol.coherence.config.scheme.RamJournalScheme;
import com.tangosol.coherence.config.scheme.ReadWriteBackingMapScheme;
import com.tangosol.coherence.config.scheme.RemoteInvocationScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.Parameter;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.Value;
import com.tangosol.config.xml.ElementProcessor;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.config.xml.XmlSimpleName;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.UUID;
import java.lang.reflect.Type;
import java.util.Map;

@XmlSimpleName(value="init-param")
public class InitParamProcessor
implements ElementProcessor<Parameter> {
    @Override
    public Parameter process(ProcessingContext context, XmlElement element) throws ConfigurationException {
        String sName = context.getOptionalProperty("param-name", (Type)((Object)String.class), new UUID().toString(), element);
        Expression exprValue = (Expression)context.getMandatoryProperty("param-value", (Type)((Object)Expression.class), element);
        String sType = context.getOptionalProperty("param-type", (Type)((Object)String.class), null, element);
        Class<Object> clzType = null;
        if (sType != null && sType.equals("{cache-ref}")) {
            Expression exprCacheName = exprValue;
            ClassLoader loader = context.getContextClassLoader();
            ResourceMappingRegistry registry = context.getCookie(CacheConfig.class).getMappingRegistry();
            clzType = NamedCache.class;
            exprValue = new CacheRefExpression(exprCacheName, loader, registry);
        } else if (sType != null && sType.equals("{destination-ref}")) {
            Expression exprCacheName = exprValue;
            ClassLoader loader = context.getContextClassLoader();
            ResourceMappingRegistry registry = context.getCookie(CacheConfig.class).getMappingRegistry();
            clzType = NamedTopic.class;
            exprValue = new CollectionRefExpression(exprCacheName, loader, registry);
        } else if (sType != null && sType.equals("{scheme-ref}")) {
            Expression exprSchemeName = exprValue;
            ServiceSchemeRegistry registry = context.getCookie(CacheConfig.class).getServiceSchemeRegistry();
            clzType = Object.class;
            exprValue = new SchemeRefExpression(exprSchemeName, registry);
        } else if (sType != null) {
            try {
                clzType = context.getContextClassLoader().loadClass(sType);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(String.format("Failed to resolve the specified param-type in [%s]", element), "Please ensure that the specified class is publicly accessible via the class path", e);
            }
        }
        return new Parameter(sName, clzType, exprValue);
    }

    public static class SchemeRefExpression
    implements Expression<Object> {
        private Expression<?> m_exprSchemeName;
        private ServiceSchemeRegistry m_registry;

        public SchemeRefExpression(Expression<?> exprSchemeName, ServiceSchemeRegistry registry) {
            this.m_exprSchemeName = exprSchemeName;
            this.m_registry = registry;
        }

        @Override
        public Object evaluate(ParameterResolver resolver) {
            ClassLoader classLoader;
            String sSchemeName = new Value(this.m_exprSchemeName.evaluate(resolver)).as(String.class);
            ServiceScheme scheme = this.m_registry.findSchemeBySchemeName(sSchemeName);
            Parameter paramClassLoader = resolver.resolve("class-loader");
            ClassLoader classLoader2 = classLoader = paramClassLoader == null ? Base.getContextClassLoader() : paramClassLoader.evaluate(resolver).as(ClassLoader.class);
            if (scheme instanceof InvocationScheme || scheme instanceof RemoteInvocationScheme) {
                return ((InvocationScheme)scheme).realizeService(resolver, classLoader, CacheFactory.getCluster());
            }
            if (scheme instanceof ClassScheme) {
                return ((ClassScheme)scheme).realize(resolver, classLoader, null);
            }
            if (scheme instanceof CachingScheme) {
                CachingScheme cachingScheme = (CachingScheme)scheme;
                ConfigurableCacheFactory ccf = CacheFactory.getConfigurableCacheFactory();
                Parameter paramCacheName = resolver.resolve("cache-name");
                String sCacheName = paramCacheName == null ? null : paramCacheName.evaluate(resolver).as(String.class);
                Parameter paramBMMC = resolver.resolve("manager-context");
                BackingMapManagerContext bmmc = paramBMMC == null ? null : paramBMMC.evaluate(resolver).as(BackingMapManagerContext.class);
                MapBuilder.Dependencies dependencies = new MapBuilder.Dependencies(ccf, bmmc, classLoader, sCacheName, cachingScheme.getServiceType());
                Map map = scheme instanceof LocalScheme || scheme instanceof OverflowScheme || scheme instanceof ExternalScheme || scheme instanceof ReadWriteBackingMapScheme || scheme instanceof FlashJournalScheme || scheme instanceof RamJournalScheme ? cachingScheme.realizeMap(resolver, dependencies) : cachingScheme.realizeCache(resolver, dependencies);
                if (cachingScheme instanceof ObservableCachingScheme) {
                    ObservableCachingScheme observableScheme = (ObservableCachingScheme)cachingScheme;
                    observableScheme.establishMapListeners(map, resolver, dependencies);
                }
                return map;
            }
            throw new ConfigurationException(String.format("Failed to resolve the {scheme-ref} name [%s]", sSchemeName), "Please ensure that the specified {scheme-ref} refers to a defined <scheme-name>");
        }

        public String toString() {
            return String.format("SchemeRefExpression{exprSchemeName=%s}", this.m_exprSchemeName);
        }
    }

    public static class CollectionRefExpression
    extends DataStructureRefExpression<NamedCollection> {
        public CollectionRefExpression(Expression<?> exprCacheName, ClassLoader classLoader, ResourceMappingRegistry registry) {
            super(exprCacheName, classLoader, registry);
        }

        @Override
        public NamedCollection evaluate(ParameterResolver resolver) {
            String sName = this.evaluateName(resolver, TopicMapping.class, "topic-name");
            ClassLoader classLoader = this.getClassLoader();
            Parameter parameter = resolver.resolve("manager-context");
            BackingMapManagerContext ctx = (BackingMapManagerContext)parameter.evaluate(resolver).get();
            ExtensibleConfigurableCacheFactory eccf = ctx == null ? (ExtensibleConfigurableCacheFactory)CacheFactory.getConfigurableCacheFactory(classLoader) : (ExtensibleConfigurableCacheFactory)ctx.getManager().getCacheFactory();
            return eccf.ensureTopic(sName, classLoader, ValueTypeAssertion.withRawTypes());
        }
    }

    public static class CacheRefExpression
    extends DataStructureRefExpression<NamedCache> {
        public CacheRefExpression(Expression<?> exprCacheName, ClassLoader classLoader, ResourceMappingRegistry registry) {
            super(exprCacheName, classLoader, registry);
        }

        public CacheRefExpression(Expression<?> exprCacheName, ClassLoader classLoader, CacheMappingRegistry registry) {
            super(exprCacheName, classLoader, registry.getMappingRegistry());
        }

        @Override
        public NamedCache evaluate(ParameterResolver resolver) {
            String sName = this.evaluateName(resolver, CacheMapping.class, "cache-name");
            ClassLoader loader = this.getClassLoader();
            Parameter parameter = resolver.resolve("manager-context");
            BackingMapManagerContext ctx = (BackingMapManagerContext)parameter.evaluate(resolver).get();
            ConfigurableCacheFactory ccf = ctx == null ? CacheFactory.getConfigurableCacheFactory(loader) : ctx.getManager().getCacheFactory();
            return ccf.ensureCache(sName, loader);
        }
    }

    public static abstract class DataStructureRefExpression<E>
    implements Expression<E> {
        private Expression<?> m_exprCacheName;
        private ClassLoader m_classLoader;
        private ResourceMappingRegistry m_registryResourceMappings;

        public DataStructureRefExpression(Expression<?> exprCacheName, ClassLoader classLoader, ResourceMappingRegistry registry) {
            this.m_exprCacheName = exprCacheName;
            this.m_classLoader = classLoader;
            this.m_registryResourceMappings = registry;
        }

        public String evaluateName(ParameterResolver resolver, Class<? extends ResourceMapping> clsType, String sElementName) {
            String sDesiredName = new Value(this.m_exprCacheName.evaluate(resolver)).as(String.class);
            if (sDesiredName.contains("*")) {
                ResourceMapping mapping;
                String sCacheName;
                Parameter paramCacheName = resolver.resolve(sElementName);
                String string = sCacheName = paramCacheName == null ? null : paramCacheName.evaluate(resolver).as(String.class);
                if (sCacheName != null && (mapping = this.m_registryResourceMappings.findMapping(sCacheName, clsType)).usesWildcard()) {
                    String sWildcardValue = mapping.getWildcardMatch(sCacheName);
                    sDesiredName = sDesiredName.replaceAll("\\*", sWildcardValue);
                }
            }
            return sDesiredName;
        }

        public ClassLoader getClassLoader() {
            return this.m_classLoader;
        }

        public String toString() {
            return String.format(this.getClass().getSimpleName() + "{exprCacheName=%s}", this.m_exprCacheName);
        }
    }
}

